/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageComponent
extends AbstractEntityImage {
    private final Url url;
    private final TextBlock asSmall;

    public EntityImageComponent(ILeaf iLeaf, ISkinParam iSkinParam, PortionShower portionShower) {
        super(iLeaf, iSkinParam);
        USymbol uSymbol;
        Stereotype stereotype = iLeaf.getStereotype();
        USymbol uSymbol2 = iLeaf.getUSymbol() == null ? (iSkinParam.useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1) : (uSymbol = iLeaf.getUSymbol());
        if (uSymbol == null) {
            throw new IllegalArgumentException();
        }
        BodyEnhanced bodyEnhanced = new BodyEnhanced(iLeaf.getDisplay(), uSymbol.getFontParam(), iSkinParam, HorizontalAlignment.CENTER, stereotype, uSymbol.manageHorizontalLine(), false);
        this.url = iLeaf.getUrl99();
        HtmlColor htmlColor = this.getEntity().getSpecificBackColor();
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), uSymbol.getColorParamBack(), this.getStereo());
        }
        HtmlColor htmlColor2 = SkinParamUtils.getColor(this.getSkinParam(), uSymbol.getColorParamBorder(), this.getStereo());
        SymbolContext symbolContext = new SymbolContext(htmlColor, htmlColor2).withStroke(new UStroke(1.5)).withShadow(this.getSkinParam().shadowing());
        TextBlock textBlock = TextBlockUtils.empty(0.0, 0.0);
        if (stereotype != null && stereotype.getLabel() != null && portionShower.showPortion(EntityPortion.STEREOTYPE, iLeaf)) {
            textBlock = TextBlockUtils.create(Display.getWithNewlines(stereotype.getLabel()), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), uSymbol.getFontParamStereotype(), stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), uSymbol.getFontParamStereotype(), null)), HorizontalAlignment.CENTER, iSkinParam);
        }
        this.asSmall = uSymbol.asSmall(bodyEnhanced, textBlock, symbolContext);
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.asSmall.calculateDimension(stringBounder);
    }

    public final void drawU(UGraphic uGraphic) {
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        this.asSmall.drawU(uGraphic);
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

