/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

public class UnionResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public int rowsSeenLeft;
    public int rowsSeenRight;
    public int rowsReturned;
    private int whichSource = 1;
    private int source1FinalRowCount = -1;
    public NoPutResultSet source1;
    public NoPutResultSet source2;
    protected GeneratedMethod closeCleanup;

    public UnionResultSet(NoPutResultSet noPutResultSet, NoPutResultSet noPutResultSet2, Activation activation, int n, double d, double d2, GeneratedMethod generatedMethod) {
        super(activation, n, d, d2);
        this.source1 = noPutResultSet;
        this.source2 = noPutResultSet2;
        this.closeCleanup = generatedMethod;
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }

    public ResultDescription getResultDescription() {
        return this.source1.getResultDescription();
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.isOpen = true;
        this.source1.openCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            switch (this.whichSource) {
                case 1: {
                    execRow = this.source1.getNextRowCore();
                    if (execRow == (ExecRow)null) {
                        this.source1.close();
                        this.whichSource = 2;
                        this.source2.openCore();
                        execRow = this.source2.getNextRowCore();
                        if (execRow == null) break;
                        ++this.rowsSeenRight;
                        break;
                    }
                    ++this.rowsSeenLeft;
                    break;
                }
                case 2: {
                    execRow = this.source2.getNextRowCore();
                    if (execRow == null) break;
                    ++this.rowsSeenRight;
                    break;
                }
            }
        }
        this.currentRow = execRow;
        this.setCurrentRow(execRow);
        if (execRow != null) {
            ++this.rowsReturned;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            if (this.closeCleanup != null) {
                this.closeCleanup.invoke(this.activation);
            }
            this.clearCurrentRow();
            this.currentRow = null;
            switch (this.whichSource) {
                case 1: {
                    this.source1.close();
                    break;
                }
                case 2: {
                    this.source2.close();
                    this.source1FinalRowCount = -1;
                    this.whichSource = 1;
                    break;
                }
            }
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        this.source1.finish();
        this.source2.finish();
        this.finishAndRTS();
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.source1.getTimeSpent(1) - this.source2.getTimeSpent(1);
        }
        return l;
    }

    public RowLocation getRowLocation() throws StandardException {
        switch (this.whichSource) {
            case 1: {
                return ((CursorResultSet)((Object)this.source1)).getRowLocation();
            }
            case 2: {
                return ((CursorResultSet)((Object)this.source2)).getRowLocation();
            }
        }
        return null;
    }

    public ExecRow getCurrentRow() throws StandardException {
        ExecRow execRow = null;
        switch (this.whichSource) {
            case 1: {
                execRow = ((CursorResultSet)((Object)this.source1)).getCurrentRow();
                break;
            }
            case 2: {
                execRow = ((CursorResultSet)((Object)this.source2)).getCurrentRow();
            }
        }
        this.currentRow = execRow;
        this.setCurrentRow(execRow);
        return execRow;
    }
}

