#ifndef __glext_consts_h_
#define __glext_consts_h_

#ifdef __cplusplus
extern "C" {
#endif

/*
** This file is derived from glext.h and is subject to the same license
** restrictions as that file.
**
** Copyright (c) 2013-2016 The Khronos Group Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and/or associated documentation files (the
** "Materials"), to deal in the Materials without restriction, including
** without limitation the rights to use, copy, modify, merge, publish,
** distribute, sublicense, and/or sell copies of the Materials, and to
** permit persons to whom the Materials are furnished to do so, subject to
** the following conditions:
**
** The above copyright notice and this permission notice shall be included
** in all copies or substantial portions of the Materials.
**
** THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
** EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
** IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
** CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
** TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
** MATERIALS OR THE USE OR OTHER DEALINGS IN THE MATERIALS.
*/
/*
** This header is generated from the Khronos OpenGL / OpenGL ES XML
** API Registry. The current version of the Registry, generator scripts
** used to make the header, and the header can be found at
**   http://www.opengl.org/registry/
**
** Khronos $Revision: 32957 $ on $Date: 2016-06-09 23:03:08 +0200 (Do, 09 Jun 2016) $
*/

#if defined(_WIN32) && !defined(APIENTRY) && !defined(__CYGWIN__) && !defined(__SCITECH_SNAP__)
#ifndef WIN32_LEAN_AND_MEAN
#endif
#endif

#ifndef APIENTRY
#endif
#ifndef APIENTRYP
#endif
#ifndef GLAPI
#endif


/* Generated C header for:
 * API: gl
 * Profile: compatibility
 * Versions considered: .*
 * Versions emitted: 1\.[2-9]|[234]\.[0-9]
 * Default extensions included: gl
 * Additional extensions included: _nomatch_^
 * Extensions removed: _nomatch_^
 */

#ifndef NO_GL_VERSION_1_2
    i(GL_UNSIGNED_BYTE_3_3_2)
    i(GL_UNSIGNED_SHORT_4_4_4_4)
    i(GL_UNSIGNED_SHORT_5_5_5_1)
    i(GL_UNSIGNED_INT_8_8_8_8)
    i(GL_UNSIGNED_INT_10_10_10_2)
    i(GL_TEXTURE_BINDING_3D)
    i(GL_PACK_SKIP_IMAGES)
    i(GL_PACK_IMAGE_HEIGHT)
    i(GL_UNPACK_SKIP_IMAGES)
    i(GL_UNPACK_IMAGE_HEIGHT)
    i(GL_TEXTURE_3D)
    i(GL_PROXY_TEXTURE_3D)
    i(GL_TEXTURE_DEPTH)
    i(GL_TEXTURE_WRAP_R)
    i(GL_MAX_3D_TEXTURE_SIZE)
    i(GL_UNSIGNED_BYTE_2_3_3_REV)
    i(GL_UNSIGNED_SHORT_5_6_5)
    i(GL_UNSIGNED_SHORT_5_6_5_REV)
    i(GL_UNSIGNED_SHORT_4_4_4_4_REV)
    i(GL_UNSIGNED_SHORT_1_5_5_5_REV)
    i(GL_UNSIGNED_INT_8_8_8_8_REV)
    i(GL_UNSIGNED_INT_2_10_10_10_REV)
    i(GL_BGR)
    i(GL_BGRA)
    i(GL_MAX_ELEMENTS_VERTICES)
    i(GL_MAX_ELEMENTS_INDICES)
    i(GL_CLAMP_TO_EDGE)
    i(GL_TEXTURE_MIN_LOD)
    i(GL_TEXTURE_MAX_LOD)
    i(GL_TEXTURE_BASE_LEVEL)
    i(GL_TEXTURE_MAX_LEVEL)
    i(GL_SMOOTH_POINT_SIZE_RANGE)
    i(GL_SMOOTH_POINT_SIZE_GRANULARITY)
    i(GL_SMOOTH_LINE_WIDTH_RANGE)
    i(GL_SMOOTH_LINE_WIDTH_GRANULARITY)
    i(GL_ALIASED_LINE_WIDTH_RANGE)
    i(GL_RESCALE_NORMAL)
    i(GL_LIGHT_MODEL_COLOR_CONTROL)
    i(GL_SINGLE_COLOR)
    i(GL_SEPARATE_SPECULAR_COLOR)
    i(GL_ALIASED_POINT_SIZE_RANGE)
#endif /* GL_VERSION_1_2 */

#ifndef NO_GL_VERSION_1_3
    i(GL_TEXTURE0)
    i(GL_TEXTURE1)
    i(GL_TEXTURE2)
    i(GL_TEXTURE3)
    i(GL_TEXTURE4)
    i(GL_TEXTURE5)
    i(GL_TEXTURE6)
    i(GL_TEXTURE7)
    i(GL_TEXTURE8)
    i(GL_TEXTURE9)
    i(GL_TEXTURE10)
    i(GL_TEXTURE11)
    i(GL_TEXTURE12)
    i(GL_TEXTURE13)
    i(GL_TEXTURE14)
    i(GL_TEXTURE15)
    i(GL_TEXTURE16)
    i(GL_TEXTURE17)
    i(GL_TEXTURE18)
    i(GL_TEXTURE19)
    i(GL_TEXTURE20)
    i(GL_TEXTURE21)
    i(GL_TEXTURE22)
    i(GL_TEXTURE23)
    i(GL_TEXTURE24)
    i(GL_TEXTURE25)
    i(GL_TEXTURE26)
    i(GL_TEXTURE27)
    i(GL_TEXTURE28)
    i(GL_TEXTURE29)
    i(GL_TEXTURE30)
    i(GL_TEXTURE31)
    i(GL_ACTIVE_TEXTURE)
    i(GL_MULTISAMPLE)
    i(GL_SAMPLE_ALPHA_TO_COVERAGE)
    i(GL_SAMPLE_ALPHA_TO_ONE)
    i(GL_SAMPLE_COVERAGE)
    i(GL_SAMPLE_BUFFERS)
    i(GL_SAMPLES)
    i(GL_SAMPLE_COVERAGE_VALUE)
    i(GL_SAMPLE_COVERAGE_INVERT)
    i(GL_TEXTURE_CUBE_MAP)
    i(GL_TEXTURE_BINDING_CUBE_MAP)
    i(GL_TEXTURE_CUBE_MAP_POSITIVE_X)
    i(GL_TEXTURE_CUBE_MAP_NEGATIVE_X)
    i(GL_TEXTURE_CUBE_MAP_POSITIVE_Y)
    i(GL_TEXTURE_CUBE_MAP_NEGATIVE_Y)
    i(GL_TEXTURE_CUBE_MAP_POSITIVE_Z)
    i(GL_TEXTURE_CUBE_MAP_NEGATIVE_Z)
    i(GL_PROXY_TEXTURE_CUBE_MAP)
    i(GL_MAX_CUBE_MAP_TEXTURE_SIZE)
    i(GL_COMPRESSED_RGB)
    i(GL_COMPRESSED_RGBA)
    i(GL_TEXTURE_COMPRESSION_HINT)
    i(GL_TEXTURE_COMPRESSED_IMAGE_SIZE)
    i(GL_TEXTURE_COMPRESSED)
    i(GL_NUM_COMPRESSED_TEXTURE_FORMATS)
    i(GL_COMPRESSED_TEXTURE_FORMATS)
    i(GL_CLAMP_TO_BORDER)
    i(GL_CLIENT_ACTIVE_TEXTURE)
    i(GL_MAX_TEXTURE_UNITS)
    i(GL_TRANSPOSE_MODELVIEW_MATRIX)
    i(GL_TRANSPOSE_PROJECTION_MATRIX)
    i(GL_TRANSPOSE_TEXTURE_MATRIX)
    i(GL_TRANSPOSE_COLOR_MATRIX)
    i(GL_MULTISAMPLE_BIT)
    i(GL_NORMAL_MAP)
    i(GL_REFLECTION_MAP)
    i(GL_COMPRESSED_ALPHA)
    i(GL_COMPRESSED_LUMINANCE)
    i(GL_COMPRESSED_LUMINANCE_ALPHA)
    i(GL_COMPRESSED_INTENSITY)
    i(GL_COMBINE)
    i(GL_COMBINE_RGB)
    i(GL_COMBINE_ALPHA)
    i(GL_SOURCE0_RGB)
    i(GL_SOURCE1_RGB)
    i(GL_SOURCE2_RGB)
    i(GL_SOURCE0_ALPHA)
    i(GL_SOURCE1_ALPHA)
    i(GL_SOURCE2_ALPHA)
    i(GL_OPERAND0_RGB)
    i(GL_OPERAND1_RGB)
    i(GL_OPERAND2_RGB)
    i(GL_OPERAND0_ALPHA)
    i(GL_OPERAND1_ALPHA)
    i(GL_OPERAND2_ALPHA)
    i(GL_RGB_SCALE)
    i(GL_ADD_SIGNED)
    i(GL_INTERPOLATE)
    i(GL_SUBTRACT)
    i(GL_CONSTANT)
    i(GL_PRIMARY_COLOR)
    i(GL_PREVIOUS)
    i(GL_DOT3_RGB)
    i(GL_DOT3_RGBA)
#endif /* GL_VERSION_1_3 */

#ifndef NO_GL_VERSION_1_4
    i(GL_BLEND_DST_RGB)
    i(GL_BLEND_SRC_RGB)
    i(GL_BLEND_DST_ALPHA)
    i(GL_BLEND_SRC_ALPHA)
    i(GL_POINT_FADE_THRESHOLD_SIZE)
    i(GL_DEPTH_COMPONENT16)
    i(GL_DEPTH_COMPONENT24)
    i(GL_DEPTH_COMPONENT32)
    i(GL_MIRRORED_REPEAT)
    i(GL_MAX_TEXTURE_LOD_BIAS)
    i(GL_TEXTURE_LOD_BIAS)
    i(GL_INCR_WRAP)
    i(GL_DECR_WRAP)
    i(GL_TEXTURE_DEPTH_SIZE)
    i(GL_TEXTURE_COMPARE_MODE)
    i(GL_TEXTURE_COMPARE_FUNC)
    i(GL_POINT_SIZE_MIN)
    i(GL_POINT_SIZE_MAX)
    i(GL_POINT_DISTANCE_ATTENUATION)
    i(GL_GENERATE_MIPMAP)
    i(GL_GENERATE_MIPMAP_HINT)
    i(GL_FOG_COORDINATE_SOURCE)
    i(GL_FOG_COORDINATE)
    i(GL_FRAGMENT_DEPTH)
    i(GL_CURRENT_FOG_COORDINATE)
    i(GL_FOG_COORDINATE_ARRAY_TYPE)
    i(GL_FOG_COORDINATE_ARRAY_STRIDE)
    i(GL_FOG_COORDINATE_ARRAY_POINTER)
    i(GL_FOG_COORDINATE_ARRAY)
    i(GL_COLOR_SUM)
    i(GL_CURRENT_SECONDARY_COLOR)
    i(GL_SECONDARY_COLOR_ARRAY_SIZE)
    i(GL_SECONDARY_COLOR_ARRAY_TYPE)
    i(GL_SECONDARY_COLOR_ARRAY_STRIDE)
    i(GL_SECONDARY_COLOR_ARRAY_POINTER)
    i(GL_SECONDARY_COLOR_ARRAY)
    i(GL_TEXTURE_FILTER_CONTROL)
    i(GL_DEPTH_TEXTURE_MODE)
    i(GL_COMPARE_R_TO_TEXTURE)
    i(GL_FUNC_ADD)
    i(GL_FUNC_SUBTRACT)
    i(GL_FUNC_REVERSE_SUBTRACT)
    i(GL_MIN)
    i(GL_MAX)
    i(GL_CONSTANT_COLOR)
    i(GL_ONE_MINUS_CONSTANT_COLOR)
    i(GL_CONSTANT_ALPHA)
    i(GL_ONE_MINUS_CONSTANT_ALPHA)
#endif /* GL_VERSION_1_4 */

#ifndef NO_GL_VERSION_1_5
    i(GL_BUFFER_SIZE)
    i(GL_BUFFER_USAGE)
    i(GL_QUERY_COUNTER_BITS)
    i(GL_CURRENT_QUERY)
    i(GL_QUERY_RESULT)
    i(GL_QUERY_RESULT_AVAILABLE)
    i(GL_ARRAY_BUFFER)
    i(GL_ELEMENT_ARRAY_BUFFER)
    i(GL_ARRAY_BUFFER_BINDING)
    i(GL_ELEMENT_ARRAY_BUFFER_BINDING)
    i(GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING)
    i(GL_READ_ONLY)
    i(GL_WRITE_ONLY)
    i(GL_READ_WRITE)
    i(GL_BUFFER_ACCESS)
    i(GL_BUFFER_MAPPED)
    i(GL_BUFFER_MAP_POINTER)
    i(GL_STREAM_DRAW)
    i(GL_STREAM_READ)
    i(GL_STREAM_COPY)
    i(GL_STATIC_DRAW)
    i(GL_STATIC_READ)
    i(GL_STATIC_COPY)
    i(GL_DYNAMIC_DRAW)
    i(GL_DYNAMIC_READ)
    i(GL_DYNAMIC_COPY)
    i(GL_SAMPLES_PASSED)
    i(GL_SRC1_ALPHA)
    i(GL_VERTEX_ARRAY_BUFFER_BINDING)
    i(GL_NORMAL_ARRAY_BUFFER_BINDING)
    i(GL_COLOR_ARRAY_BUFFER_BINDING)
    i(GL_INDEX_ARRAY_BUFFER_BINDING)
    i(GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING)
    i(GL_EDGE_FLAG_ARRAY_BUFFER_BINDING)
    i(GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING)
    i(GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING)
    i(GL_WEIGHT_ARRAY_BUFFER_BINDING)
    i(GL_FOG_COORD_SRC)
    i(GL_FOG_COORD)
    i(GL_CURRENT_FOG_COORD)
    i(GL_FOG_COORD_ARRAY_TYPE)
    i(GL_FOG_COORD_ARRAY_STRIDE)
    i(GL_FOG_COORD_ARRAY_POINTER)
    i(GL_FOG_COORD_ARRAY)
    i(GL_FOG_COORD_ARRAY_BUFFER_BINDING)
    i(GL_SRC0_RGB)
    i(GL_SRC1_RGB)
    i(GL_SRC2_RGB)
    i(GL_SRC0_ALPHA)
    i(GL_SRC2_ALPHA)
#endif /* GL_VERSION_1_5 */

#ifndef NO_GL_VERSION_2_0
    i(GL_BLEND_EQUATION_RGB)
    i(GL_VERTEX_ATTRIB_ARRAY_ENABLED)
    i(GL_VERTEX_ATTRIB_ARRAY_SIZE)
    i(GL_VERTEX_ATTRIB_ARRAY_STRIDE)
    i(GL_VERTEX_ATTRIB_ARRAY_TYPE)
    i(GL_CURRENT_VERTEX_ATTRIB)
    i(GL_VERTEX_PROGRAM_POINT_SIZE)
    i(GL_VERTEX_ATTRIB_ARRAY_POINTER)
    i(GL_STENCIL_BACK_FUNC)
    i(GL_STENCIL_BACK_FAIL)
    i(GL_STENCIL_BACK_PASS_DEPTH_FAIL)
    i(GL_STENCIL_BACK_PASS_DEPTH_PASS)
    i(GL_MAX_DRAW_BUFFERS)
    i(GL_DRAW_BUFFER0)
    i(GL_DRAW_BUFFER1)
    i(GL_DRAW_BUFFER2)
    i(GL_DRAW_BUFFER3)
    i(GL_DRAW_BUFFER4)
    i(GL_DRAW_BUFFER5)
    i(GL_DRAW_BUFFER6)
    i(GL_DRAW_BUFFER7)
    i(GL_DRAW_BUFFER8)
    i(GL_DRAW_BUFFER9)
    i(GL_DRAW_BUFFER10)
    i(GL_DRAW_BUFFER11)
    i(GL_DRAW_BUFFER12)
    i(GL_DRAW_BUFFER13)
    i(GL_DRAW_BUFFER14)
    i(GL_DRAW_BUFFER15)
    i(GL_BLEND_EQUATION_ALPHA)
    i(GL_MAX_VERTEX_ATTRIBS)
    i(GL_VERTEX_ATTRIB_ARRAY_NORMALIZED)
    i(GL_MAX_TEXTURE_IMAGE_UNITS)
    i(GL_FRAGMENT_SHADER)
    i(GL_VERTEX_SHADER)
    i(GL_MAX_FRAGMENT_UNIFORM_COMPONENTS)
    i(GL_MAX_VERTEX_UNIFORM_COMPONENTS)
    i(GL_MAX_VARYING_FLOATS)
    i(GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS)
    i(GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS)
    i(GL_SHADER_TYPE)
    i(GL_FLOAT_VEC2)
    i(GL_FLOAT_VEC3)
    i(GL_FLOAT_VEC4)
    i(GL_INT_VEC2)
    i(GL_INT_VEC3)
    i(GL_INT_VEC4)
    i(GL_BOOL)
    i(GL_BOOL_VEC2)
    i(GL_BOOL_VEC3)
    i(GL_BOOL_VEC4)
    i(GL_FLOAT_MAT2)
    i(GL_FLOAT_MAT3)
    i(GL_FLOAT_MAT4)
    i(GL_SAMPLER_1D)
    i(GL_SAMPLER_2D)
    i(GL_SAMPLER_3D)
    i(GL_SAMPLER_CUBE)
    i(GL_SAMPLER_1D_SHADOW)
    i(GL_SAMPLER_2D_SHADOW)
    i(GL_DELETE_STATUS)
    i(GL_COMPILE_STATUS)
    i(GL_LINK_STATUS)
    i(GL_VALIDATE_STATUS)
    i(GL_INFO_LOG_LENGTH)
    i(GL_ATTACHED_SHADERS)
    i(GL_ACTIVE_UNIFORMS)
    i(GL_ACTIVE_UNIFORM_MAX_LENGTH)
    i(GL_SHADER_SOURCE_LENGTH)
    i(GL_ACTIVE_ATTRIBUTES)
    i(GL_ACTIVE_ATTRIBUTE_MAX_LENGTH)
    i(GL_FRAGMENT_SHADER_DERIVATIVE_HINT)
    i(GL_SHADING_LANGUAGE_VERSION)
    i(GL_CURRENT_PROGRAM)
    i(GL_POINT_SPRITE_COORD_ORIGIN)
    i(GL_LOWER_LEFT)
    i(GL_UPPER_LEFT)
    i(GL_STENCIL_BACK_REF)
    i(GL_STENCIL_BACK_VALUE_MASK)
    i(GL_STENCIL_BACK_WRITEMASK)
    i(GL_VERTEX_PROGRAM_TWO_SIDE)
    i(GL_POINT_SPRITE)
    i(GL_COORD_REPLACE)
    i(GL_MAX_TEXTURE_COORDS)
#endif /* GL_VERSION_2_0 */

#ifndef NO_GL_VERSION_2_1
    i(GL_PIXEL_PACK_BUFFER)
    i(GL_PIXEL_UNPACK_BUFFER)
    i(GL_PIXEL_PACK_BUFFER_BINDING)
    i(GL_PIXEL_UNPACK_BUFFER_BINDING)
    i(GL_FLOAT_MAT2x3)
    i(GL_FLOAT_MAT2x4)
    i(GL_FLOAT_MAT3x2)
    i(GL_FLOAT_MAT3x4)
    i(GL_FLOAT_MAT4x2)
    i(GL_FLOAT_MAT4x3)
    i(GL_SRGB)
    i(GL_SRGB8)
    i(GL_SRGB_ALPHA)
    i(GL_SRGB8_ALPHA8)
    i(GL_COMPRESSED_SRGB)
    i(GL_COMPRESSED_SRGB_ALPHA)
    i(GL_CURRENT_RASTER_SECONDARY_COLOR)
    i(GL_SLUMINANCE_ALPHA)
    i(GL_SLUMINANCE8_ALPHA8)
    i(GL_SLUMINANCE)
    i(GL_SLUMINANCE8)
    i(GL_COMPRESSED_SLUMINANCE)
    i(GL_COMPRESSED_SLUMINANCE_ALPHA)
#endif /* GL_VERSION_2_1 */

#ifndef NO_GL_VERSION_3_0
    i(GL_COMPARE_REF_TO_TEXTURE)
    i(GL_CLIP_DISTANCE0)
    i(GL_CLIP_DISTANCE1)
    i(GL_CLIP_DISTANCE2)
    i(GL_CLIP_DISTANCE3)
    i(GL_CLIP_DISTANCE4)
    i(GL_CLIP_DISTANCE5)
    i(GL_CLIP_DISTANCE6)
    i(GL_CLIP_DISTANCE7)
    i(GL_MAX_CLIP_DISTANCES)
    i(GL_MAJOR_VERSION)
    i(GL_MINOR_VERSION)
    i(GL_NUM_EXTENSIONS)
    i(GL_CONTEXT_FLAGS)
    i(GL_COMPRESSED_RED)
    i(GL_COMPRESSED_RG)
    i(GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT)
    i(GL_RGBA32F)
    i(GL_RGB32F)
    i(GL_RGBA16F)
    i(GL_RGB16F)
    i(GL_VERTEX_ATTRIB_ARRAY_INTEGER)
    i(GL_MAX_ARRAY_TEXTURE_LAYERS)
    i(GL_MIN_PROGRAM_TEXEL_OFFSET)
    i(GL_MAX_PROGRAM_TEXEL_OFFSET)
    i(GL_CLAMP_READ_COLOR)
    i(GL_FIXED_ONLY)
    i(GL_MAX_VARYING_COMPONENTS)
    i(GL_TEXTURE_1D_ARRAY)
    i(GL_PROXY_TEXTURE_1D_ARRAY)
    i(GL_TEXTURE_2D_ARRAY)
    i(GL_PROXY_TEXTURE_2D_ARRAY)
    i(GL_TEXTURE_BINDING_1D_ARRAY)
    i(GL_TEXTURE_BINDING_2D_ARRAY)
    i(GL_R11F_G11F_B10F)
    i(GL_UNSIGNED_INT_10F_11F_11F_REV)
    i(GL_RGB9_E5)
    i(GL_UNSIGNED_INT_5_9_9_9_REV)
    i(GL_TEXTURE_SHARED_SIZE)
    i(GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_MODE)
    i(GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS)
    i(GL_TRANSFORM_FEEDBACK_VARYINGS)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_START)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_SIZE)
    i(GL_PRIMITIVES_GENERATED)
    i(GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN)
    i(GL_RASTERIZER_DISCARD)
    i(GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS)
    i(GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS)
    i(GL_INTERLEAVED_ATTRIBS)
    i(GL_SEPARATE_ATTRIBS)
    i(GL_TRANSFORM_FEEDBACK_BUFFER)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_BINDING)
    i(GL_RGBA32UI)
    i(GL_RGB32UI)
    i(GL_RGBA16UI)
    i(GL_RGB16UI)
    i(GL_RGBA8UI)
    i(GL_RGB8UI)
    i(GL_RGBA32I)
    i(GL_RGB32I)
    i(GL_RGBA16I)
    i(GL_RGB16I)
    i(GL_RGBA8I)
    i(GL_RGB8I)
    i(GL_RED_INTEGER)
    i(GL_GREEN_INTEGER)
    i(GL_BLUE_INTEGER)
    i(GL_RGB_INTEGER)
    i(GL_RGBA_INTEGER)
    i(GL_BGR_INTEGER)
    i(GL_BGRA_INTEGER)
    i(GL_SAMPLER_1D_ARRAY)
    i(GL_SAMPLER_2D_ARRAY)
    i(GL_SAMPLER_1D_ARRAY_SHADOW)
    i(GL_SAMPLER_2D_ARRAY_SHADOW)
    i(GL_SAMPLER_CUBE_SHADOW)
    i(GL_UNSIGNED_INT_VEC2)
    i(GL_UNSIGNED_INT_VEC3)
    i(GL_UNSIGNED_INT_VEC4)
    i(GL_INT_SAMPLER_1D)
    i(GL_INT_SAMPLER_2D)
    i(GL_INT_SAMPLER_3D)
    i(GL_INT_SAMPLER_CUBE)
    i(GL_INT_SAMPLER_1D_ARRAY)
    i(GL_INT_SAMPLER_2D_ARRAY)
    i(GL_UNSIGNED_INT_SAMPLER_1D)
    i(GL_UNSIGNED_INT_SAMPLER_2D)
    i(GL_UNSIGNED_INT_SAMPLER_3D)
    i(GL_UNSIGNED_INT_SAMPLER_CUBE)
    i(GL_UNSIGNED_INT_SAMPLER_1D_ARRAY)
    i(GL_UNSIGNED_INT_SAMPLER_2D_ARRAY)
    i(GL_QUERY_WAIT)
    i(GL_QUERY_NO_WAIT)
    i(GL_QUERY_BY_REGION_WAIT)
    i(GL_QUERY_BY_REGION_NO_WAIT)
    i(GL_BUFFER_ACCESS_FLAGS)
    i(GL_BUFFER_MAP_LENGTH)
    i(GL_BUFFER_MAP_OFFSET)
    i(GL_DEPTH_COMPONENT32F)
    i(GL_DEPTH32F_STENCIL8)
    i(GL_FLOAT_32_UNSIGNED_INT_24_8_REV)
    i(GL_INVALID_FRAMEBUFFER_OPERATION)
    i(GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING)
    i(GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE)
    i(GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE)
    i(GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE)
    i(GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE)
    i(GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE)
    i(GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE)
    i(GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE)
    i(GL_FRAMEBUFFER_DEFAULT)
    i(GL_FRAMEBUFFER_UNDEFINED)
    i(GL_DEPTH_STENCIL_ATTACHMENT)
    i(GL_MAX_RENDERBUFFER_SIZE)
    i(GL_DEPTH_STENCIL)
    i(GL_UNSIGNED_INT_24_8)
    i(GL_DEPTH24_STENCIL8)
    i(GL_TEXTURE_STENCIL_SIZE)
    i(GL_TEXTURE_RED_TYPE)
    i(GL_TEXTURE_GREEN_TYPE)
    i(GL_TEXTURE_BLUE_TYPE)
    i(GL_TEXTURE_ALPHA_TYPE)
    i(GL_TEXTURE_DEPTH_TYPE)
    i(GL_UNSIGNED_NORMALIZED)
    i(GL_FRAMEBUFFER_BINDING)
    i(GL_DRAW_FRAMEBUFFER_BINDING)
    i(GL_RENDERBUFFER_BINDING)
    i(GL_READ_FRAMEBUFFER)
    i(GL_DRAW_FRAMEBUFFER)
    i(GL_READ_FRAMEBUFFER_BINDING)
    i(GL_RENDERBUFFER_SAMPLES)
    i(GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE)
    i(GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME)
    i(GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL)
    i(GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE)
    i(GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER)
    i(GL_FRAMEBUFFER_COMPLETE)
    i(GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT)
    i(GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT)
    i(GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER)
    i(GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER)
    i(GL_FRAMEBUFFER_UNSUPPORTED)
    i(GL_MAX_COLOR_ATTACHMENTS)
    i(GL_COLOR_ATTACHMENT0)
    i(GL_COLOR_ATTACHMENT1)
    i(GL_COLOR_ATTACHMENT2)
    i(GL_COLOR_ATTACHMENT3)
    i(GL_COLOR_ATTACHMENT4)
    i(GL_COLOR_ATTACHMENT5)
    i(GL_COLOR_ATTACHMENT6)
    i(GL_COLOR_ATTACHMENT7)
    i(GL_COLOR_ATTACHMENT8)
    i(GL_COLOR_ATTACHMENT9)
    i(GL_COLOR_ATTACHMENT10)
    i(GL_COLOR_ATTACHMENT11)
    i(GL_COLOR_ATTACHMENT12)
    i(GL_COLOR_ATTACHMENT13)
    i(GL_COLOR_ATTACHMENT14)
    i(GL_COLOR_ATTACHMENT15)
    i(GL_COLOR_ATTACHMENT16)
    i(GL_COLOR_ATTACHMENT17)
    i(GL_COLOR_ATTACHMENT18)
    i(GL_COLOR_ATTACHMENT19)
    i(GL_COLOR_ATTACHMENT20)
    i(GL_COLOR_ATTACHMENT21)
    i(GL_COLOR_ATTACHMENT22)
    i(GL_COLOR_ATTACHMENT23)
    i(GL_COLOR_ATTACHMENT24)
    i(GL_COLOR_ATTACHMENT25)
    i(GL_COLOR_ATTACHMENT26)
    i(GL_COLOR_ATTACHMENT27)
    i(GL_COLOR_ATTACHMENT28)
    i(GL_COLOR_ATTACHMENT29)
    i(GL_COLOR_ATTACHMENT30)
    i(GL_COLOR_ATTACHMENT31)
    i(GL_DEPTH_ATTACHMENT)
    i(GL_STENCIL_ATTACHMENT)
    i(GL_FRAMEBUFFER)
    i(GL_RENDERBUFFER)
    i(GL_RENDERBUFFER_WIDTH)
    i(GL_RENDERBUFFER_HEIGHT)
    i(GL_RENDERBUFFER_INTERNAL_FORMAT)
    i(GL_STENCIL_INDEX1)
    i(GL_STENCIL_INDEX4)
    i(GL_STENCIL_INDEX8)
    i(GL_STENCIL_INDEX16)
    i(GL_RENDERBUFFER_RED_SIZE)
    i(GL_RENDERBUFFER_GREEN_SIZE)
    i(GL_RENDERBUFFER_BLUE_SIZE)
    i(GL_RENDERBUFFER_ALPHA_SIZE)
    i(GL_RENDERBUFFER_DEPTH_SIZE)
    i(GL_RENDERBUFFER_STENCIL_SIZE)
    i(GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE)
    i(GL_MAX_SAMPLES)
    i(GL_INDEX)
    i(GL_TEXTURE_LUMINANCE_TYPE)
    i(GL_TEXTURE_INTENSITY_TYPE)
    i(GL_FRAMEBUFFER_SRGB)
    i(GL_HALF_FLOAT)
    i(GL_MAP_READ_BIT)
    i(GL_MAP_WRITE_BIT)
    i(GL_MAP_INVALIDATE_RANGE_BIT)
    i(GL_MAP_INVALIDATE_BUFFER_BIT)
    i(GL_MAP_FLUSH_EXPLICIT_BIT)
    i(GL_MAP_UNSYNCHRONIZED_BIT)
    i(GL_COMPRESSED_RED_RGTC1)
    i(GL_COMPRESSED_SIGNED_RED_RGTC1)
    i(GL_COMPRESSED_RG_RGTC2)
    i(GL_COMPRESSED_SIGNED_RG_RGTC2)
    i(GL_RG)
    i(GL_RG_INTEGER)
    i(GL_R8)
    i(GL_R16)
    i(GL_RG8)
    i(GL_RG16)
    i(GL_R16F)
    i(GL_R32F)
    i(GL_RG16F)
    i(GL_RG32F)
    i(GL_R8I)
    i(GL_R8UI)
    i(GL_R16I)
    i(GL_R16UI)
    i(GL_R32I)
    i(GL_R32UI)
    i(GL_RG8I)
    i(GL_RG8UI)
    i(GL_RG16I)
    i(GL_RG16UI)
    i(GL_RG32I)
    i(GL_RG32UI)
    i(GL_VERTEX_ARRAY_BINDING)
    i(GL_CLAMP_VERTEX_COLOR)
    i(GL_CLAMP_FRAGMENT_COLOR)
    i(GL_ALPHA_INTEGER)
#endif /* GL_VERSION_3_0 */

#ifndef NO_GL_VERSION_3_1
    i(GL_SAMPLER_2D_RECT)
    i(GL_SAMPLER_2D_RECT_SHADOW)
    i(GL_SAMPLER_BUFFER)
    i(GL_INT_SAMPLER_2D_RECT)
    i(GL_INT_SAMPLER_BUFFER)
    i(GL_UNSIGNED_INT_SAMPLER_2D_RECT)
    i(GL_UNSIGNED_INT_SAMPLER_BUFFER)
    i(GL_TEXTURE_BUFFER)
    i(GL_MAX_TEXTURE_BUFFER_SIZE)
    i(GL_TEXTURE_BINDING_BUFFER)
    i(GL_TEXTURE_BUFFER_DATA_STORE_BINDING)
    i(GL_TEXTURE_RECTANGLE)
    i(GL_TEXTURE_BINDING_RECTANGLE)
    i(GL_PROXY_TEXTURE_RECTANGLE)
    i(GL_MAX_RECTANGLE_TEXTURE_SIZE)
    i(GL_R8_SNORM)
    i(GL_RG8_SNORM)
    i(GL_RGB8_SNORM)
    i(GL_RGBA8_SNORM)
    i(GL_R16_SNORM)
    i(GL_RG16_SNORM)
    i(GL_RGB16_SNORM)
    i(GL_RGBA16_SNORM)
    i(GL_SIGNED_NORMALIZED)
    i(GL_PRIMITIVE_RESTART)
    i(GL_PRIMITIVE_RESTART_INDEX)
    i(GL_COPY_READ_BUFFER)
    i(GL_COPY_WRITE_BUFFER)
    i(GL_UNIFORM_BUFFER)
    i(GL_UNIFORM_BUFFER_BINDING)
    i(GL_UNIFORM_BUFFER_START)
    i(GL_UNIFORM_BUFFER_SIZE)
    i(GL_MAX_VERTEX_UNIFORM_BLOCKS)
    i(GL_MAX_GEOMETRY_UNIFORM_BLOCKS)
    i(GL_MAX_FRAGMENT_UNIFORM_BLOCKS)
    i(GL_MAX_COMBINED_UNIFORM_BLOCKS)
    i(GL_MAX_UNIFORM_BUFFER_BINDINGS)
    i(GL_MAX_UNIFORM_BLOCK_SIZE)
    i(GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS)
    i(GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS)
    i(GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS)
    i(GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT)
    i(GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH)
    i(GL_ACTIVE_UNIFORM_BLOCKS)
    i(GL_UNIFORM_TYPE)
    i(GL_UNIFORM_SIZE)
    i(GL_UNIFORM_NAME_LENGTH)
    i(GL_UNIFORM_BLOCK_INDEX)
    i(GL_UNIFORM_OFFSET)
    i(GL_UNIFORM_ARRAY_STRIDE)
    i(GL_UNIFORM_MATRIX_STRIDE)
    i(GL_UNIFORM_IS_ROW_MAJOR)
    i(GL_UNIFORM_BLOCK_BINDING)
    i(GL_UNIFORM_BLOCK_DATA_SIZE)
    i(GL_UNIFORM_BLOCK_NAME_LENGTH)
    i(GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS)
    i(GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES)
    i(GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER)
    i(GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER)
    i(GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER)
    i(GL_INVALID_INDEX)
#endif /* GL_VERSION_3_1 */

#ifndef NO_GL_VERSION_3_2
#ifndef GLEXT_64_TYPES_DEFINED
/* This code block is duplicated in glxext.h, so must be protected */
/* Define int32_t, int64_t, and uint64_t types for UST/MSC */
/* (as used in the GL_EXT_timer_query extension). */
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#elif defined(__sun__) || defined(__digital__)
#if defined(__STDC__)
#if defined(__arch64__) || defined(_LP64)
#else
#endif /* __arch64__ */
#endif /* __STDC__ */
#elif defined( __VMS ) || defined(__sgi)
#elif defined(__SCO__) || defined(__USLC__)
#elif defined(__UNIXOS2__) || defined(__SOL64__)
#elif defined(_WIN32) && defined(__GNUC__)
#elif defined(_WIN32)
#else
/* Fallback if nothing above works */
#endif
#endif
    i(GL_CONTEXT_CORE_PROFILE_BIT)
    i(GL_CONTEXT_COMPATIBILITY_PROFILE_BIT)
    i(GL_LINES_ADJACENCY)
    i(GL_LINE_STRIP_ADJACENCY)
    i(GL_TRIANGLES_ADJACENCY)
    i(GL_TRIANGLE_STRIP_ADJACENCY)
    i(GL_PROGRAM_POINT_SIZE)
    i(GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS)
    i(GL_FRAMEBUFFER_ATTACHMENT_LAYERED)
    i(GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS)
    i(GL_GEOMETRY_SHADER)
    i(GL_GEOMETRY_VERTICES_OUT)
    i(GL_GEOMETRY_INPUT_TYPE)
    i(GL_GEOMETRY_OUTPUT_TYPE)
    i(GL_MAX_GEOMETRY_UNIFORM_COMPONENTS)
    i(GL_MAX_GEOMETRY_OUTPUT_VERTICES)
    i(GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS)
    i(GL_MAX_VERTEX_OUTPUT_COMPONENTS)
    i(GL_MAX_GEOMETRY_INPUT_COMPONENTS)
    i(GL_MAX_GEOMETRY_OUTPUT_COMPONENTS)
    i(GL_MAX_FRAGMENT_INPUT_COMPONENTS)
    i(GL_CONTEXT_PROFILE_MASK)
    i(GL_DEPTH_CLAMP)
    i(GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION)
    i(GL_FIRST_VERTEX_CONVENTION)
    i(GL_LAST_VERTEX_CONVENTION)
    i(GL_PROVOKING_VERTEX)
    i(GL_TEXTURE_CUBE_MAP_SEAMLESS)
    i(GL_MAX_SERVER_WAIT_TIMEOUT)
    i(GL_OBJECT_TYPE)
    i(GL_SYNC_CONDITION)
    i(GL_SYNC_STATUS)
    i(GL_SYNC_FLAGS)
    i(GL_SYNC_FENCE)
    i(GL_SYNC_GPU_COMMANDS_COMPLETE)
    i(GL_UNSIGNALED)
    i(GL_SIGNALED)
    i(GL_ALREADY_SIGNALED)
    i(GL_TIMEOUT_EXPIRED)
    i(GL_CONDITION_SATISFIED)
    i(GL_WAIT_FAILED)
    i(GL_TIMEOUT_IGNORED)
    i(GL_SYNC_FLUSH_COMMANDS_BIT)
    i(GL_SAMPLE_POSITION)
    i(GL_SAMPLE_MASK)
    i(GL_SAMPLE_MASK_VALUE)
    i(GL_MAX_SAMPLE_MASK_WORDS)
    i(GL_TEXTURE_2D_MULTISAMPLE)
    i(GL_PROXY_TEXTURE_2D_MULTISAMPLE)
    i(GL_TEXTURE_2D_MULTISAMPLE_ARRAY)
    i(GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY)
    i(GL_TEXTURE_BINDING_2D_MULTISAMPLE)
    i(GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY)
    i(GL_TEXTURE_SAMPLES)
    i(GL_TEXTURE_FIXED_SAMPLE_LOCATIONS)
    i(GL_SAMPLER_2D_MULTISAMPLE)
    i(GL_INT_SAMPLER_2D_MULTISAMPLE)
    i(GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE)
    i(GL_SAMPLER_2D_MULTISAMPLE_ARRAY)
    i(GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY)
    i(GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY)
    i(GL_MAX_COLOR_TEXTURE_SAMPLES)
    i(GL_MAX_DEPTH_TEXTURE_SAMPLES)
    i(GL_MAX_INTEGER_SAMPLES)
#endif /* GL_VERSION_3_2 */

#ifndef NO_GL_VERSION_3_3
    i(GL_VERTEX_ATTRIB_ARRAY_DIVISOR)
    i(GL_SRC1_COLOR)
    i(GL_ONE_MINUS_SRC1_COLOR)
    i(GL_ONE_MINUS_SRC1_ALPHA)
    i(GL_MAX_DUAL_SOURCE_DRAW_BUFFERS)
    i(GL_ANY_SAMPLES_PASSED)
    i(GL_SAMPLER_BINDING)
    i(GL_RGB10_A2UI)
    i(GL_TEXTURE_SWIZZLE_R)
    i(GL_TEXTURE_SWIZZLE_G)
    i(GL_TEXTURE_SWIZZLE_B)
    i(GL_TEXTURE_SWIZZLE_A)
    i(GL_TEXTURE_SWIZZLE_RGBA)
    i(GL_TIME_ELAPSED)
    i(GL_TIMESTAMP)
    i(GL_INT_2_10_10_10_REV)
#endif /* GL_VERSION_3_3 */

#ifndef NO_GL_VERSION_4_0
    i(GL_SAMPLE_SHADING)
    i(GL_MIN_SAMPLE_SHADING_VALUE)
    i(GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET)
    i(GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET)
    i(GL_TEXTURE_CUBE_MAP_ARRAY)
    i(GL_TEXTURE_BINDING_CUBE_MAP_ARRAY)
    i(GL_PROXY_TEXTURE_CUBE_MAP_ARRAY)
    i(GL_SAMPLER_CUBE_MAP_ARRAY)
    i(GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW)
    i(GL_INT_SAMPLER_CUBE_MAP_ARRAY)
    i(GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY)
    i(GL_DRAW_INDIRECT_BUFFER)
    i(GL_DRAW_INDIRECT_BUFFER_BINDING)
    i(GL_GEOMETRY_SHADER_INVOCATIONS)
    i(GL_MAX_GEOMETRY_SHADER_INVOCATIONS)
    i(GL_MIN_FRAGMENT_INTERPOLATION_OFFSET)
    i(GL_MAX_FRAGMENT_INTERPOLATION_OFFSET)
    i(GL_FRAGMENT_INTERPOLATION_OFFSET_BITS)
    i(GL_MAX_VERTEX_STREAMS)
    i(GL_DOUBLE_VEC2)
    i(GL_DOUBLE_VEC3)
    i(GL_DOUBLE_VEC4)
    i(GL_DOUBLE_MAT2)
    i(GL_DOUBLE_MAT3)
    i(GL_DOUBLE_MAT4)
    i(GL_DOUBLE_MAT2x3)
    i(GL_DOUBLE_MAT2x4)
    i(GL_DOUBLE_MAT3x2)
    i(GL_DOUBLE_MAT3x4)
    i(GL_DOUBLE_MAT4x2)
    i(GL_DOUBLE_MAT4x3)
    i(GL_ACTIVE_SUBROUTINES)
    i(GL_ACTIVE_SUBROUTINE_UNIFORMS)
    i(GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS)
    i(GL_ACTIVE_SUBROUTINE_MAX_LENGTH)
    i(GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH)
    i(GL_MAX_SUBROUTINES)
    i(GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS)
    i(GL_NUM_COMPATIBLE_SUBROUTINES)
    i(GL_COMPATIBLE_SUBROUTINES)
    i(GL_PATCHES)
    i(GL_PATCH_VERTICES)
    i(GL_PATCH_DEFAULT_INNER_LEVEL)
    i(GL_PATCH_DEFAULT_OUTER_LEVEL)
    i(GL_TESS_CONTROL_OUTPUT_VERTICES)
    i(GL_TESS_GEN_MODE)
    i(GL_TESS_GEN_SPACING)
    i(GL_TESS_GEN_VERTEX_ORDER)
    i(GL_TESS_GEN_POINT_MODE)
    i(GL_ISOLINES)
    i(GL_FRACTIONAL_ODD)
    i(GL_FRACTIONAL_EVEN)
    i(GL_MAX_PATCH_VERTICES)
    i(GL_MAX_TESS_GEN_LEVEL)
    i(GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS)
    i(GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS)
    i(GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS)
    i(GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS)
    i(GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS)
    i(GL_MAX_TESS_PATCH_COMPONENTS)
    i(GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS)
    i(GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS)
    i(GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS)
    i(GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS)
    i(GL_MAX_TESS_CONTROL_INPUT_COMPONENTS)
    i(GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS)
    i(GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS)
    i(GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS)
    i(GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER)
    i(GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER)
    i(GL_TESS_EVALUATION_SHADER)
    i(GL_TESS_CONTROL_SHADER)
    i(GL_TRANSFORM_FEEDBACK)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE)
    i(GL_TRANSFORM_FEEDBACK_BINDING)
    i(GL_MAX_TRANSFORM_FEEDBACK_BUFFERS)
#endif /* GL_VERSION_4_0 */

#ifndef NO_GL_VERSION_4_1
    i(GL_FIXED)
    i(GL_IMPLEMENTATION_COLOR_READ_TYPE)
    i(GL_IMPLEMENTATION_COLOR_READ_FORMAT)
    i(GL_LOW_FLOAT)
    i(GL_MEDIUM_FLOAT)
    i(GL_HIGH_FLOAT)
    i(GL_LOW_INT)
    i(GL_MEDIUM_INT)
    i(GL_HIGH_INT)
    i(GL_SHADER_COMPILER)
    i(GL_SHADER_BINARY_FORMATS)
    i(GL_NUM_SHADER_BINARY_FORMATS)
    i(GL_MAX_VERTEX_UNIFORM_VECTORS)
    i(GL_MAX_VARYING_VECTORS)
    i(GL_MAX_FRAGMENT_UNIFORM_VECTORS)
    i(GL_RGB565)
    i(GL_PROGRAM_BINARY_RETRIEVABLE_HINT)
    i(GL_PROGRAM_BINARY_LENGTH)
    i(GL_NUM_PROGRAM_BINARY_FORMATS)
    i(GL_PROGRAM_BINARY_FORMATS)
    i(GL_VERTEX_SHADER_BIT)
    i(GL_FRAGMENT_SHADER_BIT)
    i(GL_GEOMETRY_SHADER_BIT)
    i(GL_TESS_CONTROL_SHADER_BIT)
    i(GL_TESS_EVALUATION_SHADER_BIT)
    i(GL_ALL_SHADER_BITS)
    i(GL_PROGRAM_SEPARABLE)
    i(GL_ACTIVE_PROGRAM)
    i(GL_PROGRAM_PIPELINE_BINDING)
    i(GL_MAX_VIEWPORTS)
    i(GL_VIEWPORT_SUBPIXEL_BITS)
    i(GL_VIEWPORT_BOUNDS_RANGE)
    i(GL_LAYER_PROVOKING_VERTEX)
    i(GL_VIEWPORT_INDEX_PROVOKING_VERTEX)
    i(GL_UNDEFINED_VERTEX)
#endif /* GL_VERSION_4_1 */

#ifndef NO_GL_VERSION_4_2
    i(GL_COPY_READ_BUFFER_BINDING)
    i(GL_COPY_WRITE_BUFFER_BINDING)
    i(GL_TRANSFORM_FEEDBACK_ACTIVE)
    i(GL_TRANSFORM_FEEDBACK_PAUSED)
    i(GL_UNPACK_COMPRESSED_BLOCK_WIDTH)
    i(GL_UNPACK_COMPRESSED_BLOCK_HEIGHT)
    i(GL_UNPACK_COMPRESSED_BLOCK_DEPTH)
    i(GL_UNPACK_COMPRESSED_BLOCK_SIZE)
    i(GL_PACK_COMPRESSED_BLOCK_WIDTH)
    i(GL_PACK_COMPRESSED_BLOCK_HEIGHT)
    i(GL_PACK_COMPRESSED_BLOCK_DEPTH)
    i(GL_PACK_COMPRESSED_BLOCK_SIZE)
    i(GL_NUM_SAMPLE_COUNTS)
    i(GL_MIN_MAP_BUFFER_ALIGNMENT)
    i(GL_ATOMIC_COUNTER_BUFFER)
    i(GL_ATOMIC_COUNTER_BUFFER_BINDING)
    i(GL_ATOMIC_COUNTER_BUFFER_START)
    i(GL_ATOMIC_COUNTER_BUFFER_SIZE)
    i(GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE)
    i(GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS)
    i(GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES)
    i(GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER)
    i(GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER)
    i(GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER)
    i(GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER)
    i(GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER)
    i(GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS)
    i(GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS)
    i(GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS)
    i(GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS)
    i(GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS)
    i(GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS)
    i(GL_MAX_VERTEX_ATOMIC_COUNTERS)
    i(GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS)
    i(GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS)
    i(GL_MAX_GEOMETRY_ATOMIC_COUNTERS)
    i(GL_MAX_FRAGMENT_ATOMIC_COUNTERS)
    i(GL_MAX_COMBINED_ATOMIC_COUNTERS)
    i(GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE)
    i(GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS)
    i(GL_ACTIVE_ATOMIC_COUNTER_BUFFERS)
    i(GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX)
    i(GL_UNSIGNED_INT_ATOMIC_COUNTER)
    i(GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT)
    i(GL_ELEMENT_ARRAY_BARRIER_BIT)
    i(GL_UNIFORM_BARRIER_BIT)
    i(GL_TEXTURE_FETCH_BARRIER_BIT)
    i(GL_SHADER_IMAGE_ACCESS_BARRIER_BIT)
    i(GL_COMMAND_BARRIER_BIT)
    i(GL_PIXEL_BUFFER_BARRIER_BIT)
    i(GL_TEXTURE_UPDATE_BARRIER_BIT)
    i(GL_BUFFER_UPDATE_BARRIER_BIT)
    i(GL_FRAMEBUFFER_BARRIER_BIT)
    i(GL_TRANSFORM_FEEDBACK_BARRIER_BIT)
    i(GL_ATOMIC_COUNTER_BARRIER_BIT)
    i(GL_ALL_BARRIER_BITS)
    i(GL_MAX_IMAGE_UNITS)
    i(GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS)
    i(GL_IMAGE_BINDING_NAME)
    i(GL_IMAGE_BINDING_LEVEL)
    i(GL_IMAGE_BINDING_LAYERED)
    i(GL_IMAGE_BINDING_LAYER)
    i(GL_IMAGE_BINDING_ACCESS)
    i(GL_IMAGE_1D)
    i(GL_IMAGE_2D)
    i(GL_IMAGE_3D)
    i(GL_IMAGE_2D_RECT)
    i(GL_IMAGE_CUBE)
    i(GL_IMAGE_BUFFER)
    i(GL_IMAGE_1D_ARRAY)
    i(GL_IMAGE_2D_ARRAY)
    i(GL_IMAGE_CUBE_MAP_ARRAY)
    i(GL_IMAGE_2D_MULTISAMPLE)
    i(GL_IMAGE_2D_MULTISAMPLE_ARRAY)
    i(GL_INT_IMAGE_1D)
    i(GL_INT_IMAGE_2D)
    i(GL_INT_IMAGE_3D)
    i(GL_INT_IMAGE_2D_RECT)
    i(GL_INT_IMAGE_CUBE)
    i(GL_INT_IMAGE_BUFFER)
    i(GL_INT_IMAGE_1D_ARRAY)
    i(GL_INT_IMAGE_2D_ARRAY)
    i(GL_INT_IMAGE_CUBE_MAP_ARRAY)
    i(GL_INT_IMAGE_2D_MULTISAMPLE)
    i(GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY)
    i(GL_UNSIGNED_INT_IMAGE_1D)
    i(GL_UNSIGNED_INT_IMAGE_2D)
    i(GL_UNSIGNED_INT_IMAGE_3D)
    i(GL_UNSIGNED_INT_IMAGE_2D_RECT)
    i(GL_UNSIGNED_INT_IMAGE_CUBE)
    i(GL_UNSIGNED_INT_IMAGE_BUFFER)
    i(GL_UNSIGNED_INT_IMAGE_1D_ARRAY)
    i(GL_UNSIGNED_INT_IMAGE_2D_ARRAY)
    i(GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY)
    i(GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE)
    i(GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY)
    i(GL_MAX_IMAGE_SAMPLES)
    i(GL_IMAGE_BINDING_FORMAT)
    i(GL_IMAGE_FORMAT_COMPATIBILITY_TYPE)
    i(GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE)
    i(GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS)
    i(GL_MAX_VERTEX_IMAGE_UNIFORMS)
    i(GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS)
    i(GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS)
    i(GL_MAX_GEOMETRY_IMAGE_UNIFORMS)
    i(GL_MAX_FRAGMENT_IMAGE_UNIFORMS)
    i(GL_MAX_COMBINED_IMAGE_UNIFORMS)
    i(GL_COMPRESSED_RGBA_BPTC_UNORM)
    i(GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM)
    i(GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT)
    i(GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT)
    i(GL_TEXTURE_IMMUTABLE_FORMAT)
#endif /* GL_VERSION_4_2 */

#ifndef NO_GL_VERSION_4_3
    i(GL_NUM_SHADING_LANGUAGE_VERSIONS)
    i(GL_VERTEX_ATTRIB_ARRAY_LONG)
    i(GL_COMPRESSED_RGB8_ETC2)
    i(GL_COMPRESSED_SRGB8_ETC2)
    i(GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2)
    i(GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2)
    i(GL_COMPRESSED_RGBA8_ETC2_EAC)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC)
    i(GL_COMPRESSED_R11_EAC)
    i(GL_COMPRESSED_SIGNED_R11_EAC)
    i(GL_COMPRESSED_RG11_EAC)
    i(GL_COMPRESSED_SIGNED_RG11_EAC)
    i(GL_PRIMITIVE_RESTART_FIXED_INDEX)
    i(GL_ANY_SAMPLES_PASSED_CONSERVATIVE)
    i(GL_MAX_ELEMENT_INDEX)
    i(GL_COMPUTE_SHADER)
    i(GL_MAX_COMPUTE_UNIFORM_BLOCKS)
    i(GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS)
    i(GL_MAX_COMPUTE_IMAGE_UNIFORMS)
    i(GL_MAX_COMPUTE_SHARED_MEMORY_SIZE)
    i(GL_MAX_COMPUTE_UNIFORM_COMPONENTS)
    i(GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS)
    i(GL_MAX_COMPUTE_ATOMIC_COUNTERS)
    i(GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS)
    i(GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS)
    i(GL_MAX_COMPUTE_WORK_GROUP_COUNT)
    i(GL_MAX_COMPUTE_WORK_GROUP_SIZE)
    i(GL_COMPUTE_WORK_GROUP_SIZE)
    i(GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER)
    i(GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER)
    i(GL_DISPATCH_INDIRECT_BUFFER)
    i(GL_DISPATCH_INDIRECT_BUFFER_BINDING)
    i(GL_COMPUTE_SHADER_BIT)
    i(GL_DEBUG_OUTPUT_SYNCHRONOUS)
    i(GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH)
    i(GL_DEBUG_CALLBACK_FUNCTION)
    i(GL_DEBUG_CALLBACK_USER_PARAM)
    i(GL_DEBUG_SOURCE_API)
    i(GL_DEBUG_SOURCE_WINDOW_SYSTEM)
    i(GL_DEBUG_SOURCE_SHADER_COMPILER)
    i(GL_DEBUG_SOURCE_THIRD_PARTY)
    i(GL_DEBUG_SOURCE_APPLICATION)
    i(GL_DEBUG_SOURCE_OTHER)
    i(GL_DEBUG_TYPE_ERROR)
    i(GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR)
    i(GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR)
    i(GL_DEBUG_TYPE_PORTABILITY)
    i(GL_DEBUG_TYPE_PERFORMANCE)
    i(GL_DEBUG_TYPE_OTHER)
    i(GL_MAX_DEBUG_MESSAGE_LENGTH)
    i(GL_MAX_DEBUG_LOGGED_MESSAGES)
    i(GL_DEBUG_LOGGED_MESSAGES)
    i(GL_DEBUG_SEVERITY_HIGH)
    i(GL_DEBUG_SEVERITY_MEDIUM)
    i(GL_DEBUG_SEVERITY_LOW)
    i(GL_DEBUG_TYPE_MARKER)
    i(GL_DEBUG_TYPE_PUSH_GROUP)
    i(GL_DEBUG_TYPE_POP_GROUP)
    i(GL_DEBUG_SEVERITY_NOTIFICATION)
    i(GL_MAX_DEBUG_GROUP_STACK_DEPTH)
    i(GL_DEBUG_GROUP_STACK_DEPTH)
    i(GL_BUFFER)
    i(GL_SHADER)
    i(GL_PROGRAM)
    i(GL_QUERY)
    i(GL_PROGRAM_PIPELINE)
    i(GL_SAMPLER)
    i(GL_MAX_LABEL_LENGTH)
    i(GL_DEBUG_OUTPUT)
    i(GL_CONTEXT_FLAG_DEBUG_BIT)
    i(GL_MAX_UNIFORM_LOCATIONS)
    i(GL_FRAMEBUFFER_DEFAULT_WIDTH)
    i(GL_FRAMEBUFFER_DEFAULT_HEIGHT)
    i(GL_FRAMEBUFFER_DEFAULT_LAYERS)
    i(GL_FRAMEBUFFER_DEFAULT_SAMPLES)
    i(GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS)
    i(GL_MAX_FRAMEBUFFER_WIDTH)
    i(GL_MAX_FRAMEBUFFER_HEIGHT)
    i(GL_MAX_FRAMEBUFFER_LAYERS)
    i(GL_MAX_FRAMEBUFFER_SAMPLES)
    i(GL_INTERNALFORMAT_SUPPORTED)
    i(GL_INTERNALFORMAT_PREFERRED)
    i(GL_INTERNALFORMAT_RED_SIZE)
    i(GL_INTERNALFORMAT_GREEN_SIZE)
    i(GL_INTERNALFORMAT_BLUE_SIZE)
    i(GL_INTERNALFORMAT_ALPHA_SIZE)
    i(GL_INTERNALFORMAT_DEPTH_SIZE)
    i(GL_INTERNALFORMAT_STENCIL_SIZE)
    i(GL_INTERNALFORMAT_SHARED_SIZE)
    i(GL_INTERNALFORMAT_RED_TYPE)
    i(GL_INTERNALFORMAT_GREEN_TYPE)
    i(GL_INTERNALFORMAT_BLUE_TYPE)
    i(GL_INTERNALFORMAT_ALPHA_TYPE)
    i(GL_INTERNALFORMAT_DEPTH_TYPE)
    i(GL_INTERNALFORMAT_STENCIL_TYPE)
    i(GL_MAX_WIDTH)
    i(GL_MAX_HEIGHT)
    i(GL_MAX_DEPTH)
    i(GL_MAX_LAYERS)
    i(GL_MAX_COMBINED_DIMENSIONS)
    i(GL_COLOR_COMPONENTS)
    i(GL_DEPTH_COMPONENTS)
    i(GL_STENCIL_COMPONENTS)
    i(GL_COLOR_RENDERABLE)
    i(GL_DEPTH_RENDERABLE)
    i(GL_STENCIL_RENDERABLE)
    i(GL_FRAMEBUFFER_RENDERABLE)
    i(GL_FRAMEBUFFER_RENDERABLE_LAYERED)
    i(GL_FRAMEBUFFER_BLEND)
    i(GL_READ_PIXELS)
    i(GL_READ_PIXELS_FORMAT)
    i(GL_READ_PIXELS_TYPE)
    i(GL_TEXTURE_IMAGE_FORMAT)
    i(GL_TEXTURE_IMAGE_TYPE)
    i(GL_GET_TEXTURE_IMAGE_FORMAT)
    i(GL_GET_TEXTURE_IMAGE_TYPE)
    i(GL_MIPMAP)
    i(GL_MANUAL_GENERATE_MIPMAP)
    i(GL_AUTO_GENERATE_MIPMAP)
    i(GL_COLOR_ENCODING)
    i(GL_SRGB_READ)
    i(GL_SRGB_WRITE)
    i(GL_FILTER)
    i(GL_VERTEX_TEXTURE)
    i(GL_TESS_CONTROL_TEXTURE)
    i(GL_TESS_EVALUATION_TEXTURE)
    i(GL_GEOMETRY_TEXTURE)
    i(GL_FRAGMENT_TEXTURE)
    i(GL_COMPUTE_TEXTURE)
    i(GL_TEXTURE_SHADOW)
    i(GL_TEXTURE_GATHER)
    i(GL_TEXTURE_GATHER_SHADOW)
    i(GL_SHADER_IMAGE_LOAD)
    i(GL_SHADER_IMAGE_STORE)
    i(GL_SHADER_IMAGE_ATOMIC)
    i(GL_IMAGE_TEXEL_SIZE)
    i(GL_IMAGE_COMPATIBILITY_CLASS)
    i(GL_IMAGE_PIXEL_FORMAT)
    i(GL_IMAGE_PIXEL_TYPE)
    i(GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST)
    i(GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST)
    i(GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE)
    i(GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE)
    i(GL_TEXTURE_COMPRESSED_BLOCK_WIDTH)
    i(GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT)
    i(GL_TEXTURE_COMPRESSED_BLOCK_SIZE)
    i(GL_CLEAR_BUFFER)
    i(GL_TEXTURE_VIEW)
    i(GL_VIEW_COMPATIBILITY_CLASS)
    i(GL_FULL_SUPPORT)
    i(GL_CAVEAT_SUPPORT)
    i(GL_IMAGE_CLASS_4_X_32)
    i(GL_IMAGE_CLASS_2_X_32)
    i(GL_IMAGE_CLASS_1_X_32)
    i(GL_IMAGE_CLASS_4_X_16)
    i(GL_IMAGE_CLASS_2_X_16)
    i(GL_IMAGE_CLASS_1_X_16)
    i(GL_IMAGE_CLASS_4_X_8)
    i(GL_IMAGE_CLASS_2_X_8)
    i(GL_IMAGE_CLASS_1_X_8)
    i(GL_IMAGE_CLASS_11_11_10)
    i(GL_IMAGE_CLASS_10_10_10_2)
    i(GL_VIEW_CLASS_128_BITS)
    i(GL_VIEW_CLASS_96_BITS)
    i(GL_VIEW_CLASS_64_BITS)
    i(GL_VIEW_CLASS_48_BITS)
    i(GL_VIEW_CLASS_32_BITS)
    i(GL_VIEW_CLASS_24_BITS)
    i(GL_VIEW_CLASS_16_BITS)
    i(GL_VIEW_CLASS_8_BITS)
    i(GL_VIEW_CLASS_S3TC_DXT1_RGB)
    i(GL_VIEW_CLASS_S3TC_DXT1_RGBA)
    i(GL_VIEW_CLASS_S3TC_DXT3_RGBA)
    i(GL_VIEW_CLASS_S3TC_DXT5_RGBA)
    i(GL_VIEW_CLASS_RGTC1_RED)
    i(GL_VIEW_CLASS_RGTC2_RG)
    i(GL_VIEW_CLASS_BPTC_UNORM)
    i(GL_VIEW_CLASS_BPTC_FLOAT)
    i(GL_UNIFORM)
    i(GL_UNIFORM_BLOCK)
    i(GL_PROGRAM_INPUT)
    i(GL_PROGRAM_OUTPUT)
    i(GL_BUFFER_VARIABLE)
    i(GL_SHADER_STORAGE_BLOCK)
    i(GL_VERTEX_SUBROUTINE)
    i(GL_TESS_CONTROL_SUBROUTINE)
    i(GL_TESS_EVALUATION_SUBROUTINE)
    i(GL_GEOMETRY_SUBROUTINE)
    i(GL_FRAGMENT_SUBROUTINE)
    i(GL_COMPUTE_SUBROUTINE)
    i(GL_VERTEX_SUBROUTINE_UNIFORM)
    i(GL_TESS_CONTROL_SUBROUTINE_UNIFORM)
    i(GL_TESS_EVALUATION_SUBROUTINE_UNIFORM)
    i(GL_GEOMETRY_SUBROUTINE_UNIFORM)
    i(GL_FRAGMENT_SUBROUTINE_UNIFORM)
    i(GL_COMPUTE_SUBROUTINE_UNIFORM)
    i(GL_TRANSFORM_FEEDBACK_VARYING)
    i(GL_ACTIVE_RESOURCES)
    i(GL_MAX_NAME_LENGTH)
    i(GL_MAX_NUM_ACTIVE_VARIABLES)
    i(GL_MAX_NUM_COMPATIBLE_SUBROUTINES)
    i(GL_NAME_LENGTH)
    i(GL_TYPE)
    i(GL_ARRAY_SIZE)
    i(GL_OFFSET)
    i(GL_BLOCK_INDEX)
    i(GL_ARRAY_STRIDE)
    i(GL_MATRIX_STRIDE)
    i(GL_IS_ROW_MAJOR)
    i(GL_ATOMIC_COUNTER_BUFFER_INDEX)
    i(GL_BUFFER_BINDING)
    i(GL_BUFFER_DATA_SIZE)
    i(GL_NUM_ACTIVE_VARIABLES)
    i(GL_ACTIVE_VARIABLES)
    i(GL_REFERENCED_BY_VERTEX_SHADER)
    i(GL_REFERENCED_BY_TESS_CONTROL_SHADER)
    i(GL_REFERENCED_BY_TESS_EVALUATION_SHADER)
    i(GL_REFERENCED_BY_GEOMETRY_SHADER)
    i(GL_REFERENCED_BY_FRAGMENT_SHADER)
    i(GL_REFERENCED_BY_COMPUTE_SHADER)
    i(GL_TOP_LEVEL_ARRAY_SIZE)
    i(GL_TOP_LEVEL_ARRAY_STRIDE)
    i(GL_LOCATION)
    i(GL_LOCATION_INDEX)
    i(GL_IS_PER_PATCH)
    i(GL_SHADER_STORAGE_BUFFER)
    i(GL_SHADER_STORAGE_BUFFER_BINDING)
    i(GL_SHADER_STORAGE_BUFFER_START)
    i(GL_SHADER_STORAGE_BUFFER_SIZE)
    i(GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS)
    i(GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS)
    i(GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS)
    i(GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS)
    i(GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS)
    i(GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS)
    i(GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS)
    i(GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS)
    i(GL_MAX_SHADER_STORAGE_BLOCK_SIZE)
    i(GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT)
    i(GL_SHADER_STORAGE_BARRIER_BIT)
    i(GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES)
    i(GL_DEPTH_STENCIL_TEXTURE_MODE)
    i(GL_TEXTURE_BUFFER_OFFSET)
    i(GL_TEXTURE_BUFFER_SIZE)
    i(GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT)
    i(GL_TEXTURE_VIEW_MIN_LEVEL)
    i(GL_TEXTURE_VIEW_NUM_LEVELS)
    i(GL_TEXTURE_VIEW_MIN_LAYER)
    i(GL_TEXTURE_VIEW_NUM_LAYERS)
    i(GL_TEXTURE_IMMUTABLE_LEVELS)
    i(GL_VERTEX_ATTRIB_BINDING)
    i(GL_VERTEX_ATTRIB_RELATIVE_OFFSET)
    i(GL_VERTEX_BINDING_DIVISOR)
    i(GL_VERTEX_BINDING_OFFSET)
    i(GL_VERTEX_BINDING_STRIDE)
    i(GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET)
    i(GL_MAX_VERTEX_ATTRIB_BINDINGS)
    i(GL_VERTEX_BINDING_BUFFER)
    i(GL_DISPLAY_LIST)
#endif /* GL_VERSION_4_3 */

#ifndef NO_GL_VERSION_4_4
    i(GL_MAX_VERTEX_ATTRIB_STRIDE)
    i(GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED)
    i(GL_TEXTURE_BUFFER_BINDING)
    i(GL_MAP_PERSISTENT_BIT)
    i(GL_MAP_COHERENT_BIT)
    i(GL_DYNAMIC_STORAGE_BIT)
    i(GL_CLIENT_STORAGE_BIT)
    i(GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT)
    i(GL_BUFFER_IMMUTABLE_STORAGE)
    i(GL_BUFFER_STORAGE_FLAGS)
    i(GL_CLEAR_TEXTURE)
    i(GL_LOCATION_COMPONENT)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_INDEX)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE)
    i(GL_QUERY_BUFFER)
    i(GL_QUERY_BUFFER_BARRIER_BIT)
    i(GL_QUERY_BUFFER_BINDING)
    i(GL_QUERY_RESULT_NO_WAIT)
    i(GL_MIRROR_CLAMP_TO_EDGE)
#endif /* GL_VERSION_4_4 */

#ifndef NO_GL_VERSION_4_5
    i(GL_CONTEXT_LOST)
    i(GL_NEGATIVE_ONE_TO_ONE)
    i(GL_ZERO_TO_ONE)
    i(GL_CLIP_ORIGIN)
    i(GL_CLIP_DEPTH_MODE)
    i(GL_QUERY_WAIT_INVERTED)
    i(GL_QUERY_NO_WAIT_INVERTED)
    i(GL_QUERY_BY_REGION_WAIT_INVERTED)
    i(GL_QUERY_BY_REGION_NO_WAIT_INVERTED)
    i(GL_MAX_CULL_DISTANCES)
    i(GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES)
    i(GL_TEXTURE_TARGET)
    i(GL_QUERY_TARGET)
    i(GL_GUILTY_CONTEXT_RESET)
    i(GL_INNOCENT_CONTEXT_RESET)
    i(GL_UNKNOWN_CONTEXT_RESET)
    i(GL_RESET_NOTIFICATION_STRATEGY)
    i(GL_LOSE_CONTEXT_ON_RESET)
    i(GL_NO_RESET_NOTIFICATION)
    i(GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT)
    i(GL_CONTEXT_RELEASE_BEHAVIOR)
    i(GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH)
#endif /* GL_VERSION_4_5 */

#ifndef NO_GL_ARB_ES2_compatibility
#endif /* GL_ARB_ES2_compatibility */

#ifndef NO_GL_ARB_ES3_1_compatibility
#endif /* GL_ARB_ES3_1_compatibility */

#ifndef NO_GL_ARB_ES3_2_compatibility
    i(GL_PRIMITIVE_BOUNDING_BOX_ARB)
    i(GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB)
    i(GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB)
#endif /* GL_ARB_ES3_2_compatibility */

#ifndef NO_GL_ARB_ES3_compatibility
#endif /* GL_ARB_ES3_compatibility */

#ifndef NO_GL_ARB_arrays_of_arrays
#endif /* GL_ARB_arrays_of_arrays */

#ifndef NO_GL_ARB_base_instance
#endif /* GL_ARB_base_instance */

#ifndef NO_GL_ARB_bindless_texture
    i(GL_UNSIGNED_INT64_ARB)
#endif /* GL_ARB_bindless_texture */

#ifndef NO_GL_ARB_blend_func_extended
#endif /* GL_ARB_blend_func_extended */

#ifndef NO_GL_ARB_buffer_storage
#endif /* GL_ARB_buffer_storage */

#ifndef NO_GL_ARB_cl_event
    i(GL_SYNC_CL_EVENT_ARB)
    i(GL_SYNC_CL_EVENT_COMPLETE_ARB)
#endif /* GL_ARB_cl_event */

#ifndef NO_GL_ARB_clear_buffer_object
#endif /* GL_ARB_clear_buffer_object */

#ifndef NO_GL_ARB_clear_texture
#endif /* GL_ARB_clear_texture */

#ifndef NO_GL_ARB_clip_control
#endif /* GL_ARB_clip_control */

#ifndef NO_GL_ARB_color_buffer_float
    i(GL_RGBA_FLOAT_MODE_ARB)
    i(GL_CLAMP_VERTEX_COLOR_ARB)
    i(GL_CLAMP_FRAGMENT_COLOR_ARB)
    i(GL_CLAMP_READ_COLOR_ARB)
    i(GL_FIXED_ONLY_ARB)
#endif /* GL_ARB_color_buffer_float */

#ifndef NO_GL_ARB_compatibility
#endif /* GL_ARB_compatibility */

#ifndef NO_GL_ARB_compressed_texture_pixel_storage
#endif /* GL_ARB_compressed_texture_pixel_storage */

#ifndef NO_GL_ARB_compute_shader
#endif /* GL_ARB_compute_shader */

#ifndef NO_GL_ARB_compute_variable_group_size
    i(GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB)
    i(GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB)
    i(GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB)
    i(GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB)
#endif /* GL_ARB_compute_variable_group_size */

#ifndef NO_GL_ARB_conditional_render_inverted
#endif /* GL_ARB_conditional_render_inverted */

#ifndef NO_GL_ARB_conservative_depth
#endif /* GL_ARB_conservative_depth */

#ifndef NO_GL_ARB_copy_buffer
#endif /* GL_ARB_copy_buffer */

#ifndef NO_GL_ARB_copy_image
#endif /* GL_ARB_copy_image */

#ifndef NO_GL_ARB_cull_distance
#endif /* GL_ARB_cull_distance */

#ifndef NO_GL_ARB_debug_output
    i(GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB)
    i(GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB)
    i(GL_DEBUG_CALLBACK_FUNCTION_ARB)
    i(GL_DEBUG_CALLBACK_USER_PARAM_ARB)
    i(GL_DEBUG_SOURCE_API_ARB)
    i(GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB)
    i(GL_DEBUG_SOURCE_SHADER_COMPILER_ARB)
    i(GL_DEBUG_SOURCE_THIRD_PARTY_ARB)
    i(GL_DEBUG_SOURCE_APPLICATION_ARB)
    i(GL_DEBUG_SOURCE_OTHER_ARB)
    i(GL_DEBUG_TYPE_ERROR_ARB)
    i(GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB)
    i(GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB)
    i(GL_DEBUG_TYPE_PORTABILITY_ARB)
    i(GL_DEBUG_TYPE_PERFORMANCE_ARB)
    i(GL_DEBUG_TYPE_OTHER_ARB)
    i(GL_MAX_DEBUG_MESSAGE_LENGTH_ARB)
    i(GL_MAX_DEBUG_LOGGED_MESSAGES_ARB)
    i(GL_DEBUG_LOGGED_MESSAGES_ARB)
    i(GL_DEBUG_SEVERITY_HIGH_ARB)
    i(GL_DEBUG_SEVERITY_MEDIUM_ARB)
    i(GL_DEBUG_SEVERITY_LOW_ARB)
#endif /* GL_ARB_debug_output */

#ifndef NO_GL_ARB_depth_buffer_float
#endif /* GL_ARB_depth_buffer_float */

#ifndef NO_GL_ARB_depth_clamp
#endif /* GL_ARB_depth_clamp */

#ifndef NO_GL_ARB_depth_texture
    i(GL_DEPTH_COMPONENT16_ARB)
    i(GL_DEPTH_COMPONENT24_ARB)
    i(GL_DEPTH_COMPONENT32_ARB)
    i(GL_TEXTURE_DEPTH_SIZE_ARB)
    i(GL_DEPTH_TEXTURE_MODE_ARB)
#endif /* GL_ARB_depth_texture */

#ifndef NO_GL_ARB_derivative_control
#endif /* GL_ARB_derivative_control */

#ifndef NO_GL_ARB_direct_state_access
#endif /* GL_ARB_direct_state_access */

#ifndef NO_GL_ARB_draw_buffers
    i(GL_MAX_DRAW_BUFFERS_ARB)
    i(GL_DRAW_BUFFER0_ARB)
    i(GL_DRAW_BUFFER1_ARB)
    i(GL_DRAW_BUFFER2_ARB)
    i(GL_DRAW_BUFFER3_ARB)
    i(GL_DRAW_BUFFER4_ARB)
    i(GL_DRAW_BUFFER5_ARB)
    i(GL_DRAW_BUFFER6_ARB)
    i(GL_DRAW_BUFFER7_ARB)
    i(GL_DRAW_BUFFER8_ARB)
    i(GL_DRAW_BUFFER9_ARB)
    i(GL_DRAW_BUFFER10_ARB)
    i(GL_DRAW_BUFFER11_ARB)
    i(GL_DRAW_BUFFER12_ARB)
    i(GL_DRAW_BUFFER13_ARB)
    i(GL_DRAW_BUFFER14_ARB)
    i(GL_DRAW_BUFFER15_ARB)
#endif /* GL_ARB_draw_buffers */

#ifndef NO_GL_ARB_draw_buffers_blend
#endif /* GL_ARB_draw_buffers_blend */

#ifndef NO_GL_ARB_draw_elements_base_vertex
#endif /* GL_ARB_draw_elements_base_vertex */

#ifndef NO_GL_ARB_draw_indirect
#endif /* GL_ARB_draw_indirect */

#ifndef NO_GL_ARB_draw_instanced
#endif /* GL_ARB_draw_instanced */

#ifndef NO_GL_ARB_enhanced_layouts
#endif /* GL_ARB_enhanced_layouts */

#ifndef NO_GL_ARB_explicit_attrib_location
#endif /* GL_ARB_explicit_attrib_location */

#ifndef NO_GL_ARB_explicit_uniform_location
#endif /* GL_ARB_explicit_uniform_location */

#ifndef NO_GL_ARB_fragment_coord_conventions
#endif /* GL_ARB_fragment_coord_conventions */

#ifndef NO_GL_ARB_fragment_layer_viewport
#endif /* GL_ARB_fragment_layer_viewport */

#ifndef NO_GL_ARB_fragment_program
    i(GL_FRAGMENT_PROGRAM_ARB)
    i(GL_PROGRAM_FORMAT_ASCII_ARB)
    i(GL_PROGRAM_LENGTH_ARB)
    i(GL_PROGRAM_FORMAT_ARB)
    i(GL_PROGRAM_BINDING_ARB)
    i(GL_PROGRAM_INSTRUCTIONS_ARB)
    i(GL_MAX_PROGRAM_INSTRUCTIONS_ARB)
    i(GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB)
    i(GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB)
    i(GL_PROGRAM_TEMPORARIES_ARB)
    i(GL_MAX_PROGRAM_TEMPORARIES_ARB)
    i(GL_PROGRAM_NATIVE_TEMPORARIES_ARB)
    i(GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB)
    i(GL_PROGRAM_PARAMETERS_ARB)
    i(GL_MAX_PROGRAM_PARAMETERS_ARB)
    i(GL_PROGRAM_NATIVE_PARAMETERS_ARB)
    i(GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB)
    i(GL_PROGRAM_ATTRIBS_ARB)
    i(GL_MAX_PROGRAM_ATTRIBS_ARB)
    i(GL_PROGRAM_NATIVE_ATTRIBS_ARB)
    i(GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB)
    i(GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB)
    i(GL_MAX_PROGRAM_ENV_PARAMETERS_ARB)
    i(GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB)
    i(GL_PROGRAM_ALU_INSTRUCTIONS_ARB)
    i(GL_PROGRAM_TEX_INSTRUCTIONS_ARB)
    i(GL_PROGRAM_TEX_INDIRECTIONS_ARB)
    i(GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB)
    i(GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB)
    i(GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB)
    i(GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB)
    i(GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB)
    i(GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB)
    i(GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB)
    i(GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB)
    i(GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB)
    i(GL_PROGRAM_STRING_ARB)
    i(GL_PROGRAM_ERROR_POSITION_ARB)
    i(GL_CURRENT_MATRIX_ARB)
    i(GL_TRANSPOSE_CURRENT_MATRIX_ARB)
    i(GL_CURRENT_MATRIX_STACK_DEPTH_ARB)
    i(GL_MAX_PROGRAM_MATRICES_ARB)
    i(GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB)
    i(GL_MAX_TEXTURE_COORDS_ARB)
    i(GL_MAX_TEXTURE_IMAGE_UNITS_ARB)
    i(GL_PROGRAM_ERROR_STRING_ARB)
    i(GL_MATRIX0_ARB)
    i(GL_MATRIX1_ARB)
    i(GL_MATRIX2_ARB)
    i(GL_MATRIX3_ARB)
    i(GL_MATRIX4_ARB)
    i(GL_MATRIX5_ARB)
    i(GL_MATRIX6_ARB)
    i(GL_MATRIX7_ARB)
    i(GL_MATRIX8_ARB)
    i(GL_MATRIX9_ARB)
    i(GL_MATRIX10_ARB)
    i(GL_MATRIX11_ARB)
    i(GL_MATRIX12_ARB)
    i(GL_MATRIX13_ARB)
    i(GL_MATRIX14_ARB)
    i(GL_MATRIX15_ARB)
    i(GL_MATRIX16_ARB)
    i(GL_MATRIX17_ARB)
    i(GL_MATRIX18_ARB)
    i(GL_MATRIX19_ARB)
    i(GL_MATRIX20_ARB)
    i(GL_MATRIX21_ARB)
    i(GL_MATRIX22_ARB)
    i(GL_MATRIX23_ARB)
    i(GL_MATRIX24_ARB)
    i(GL_MATRIX25_ARB)
    i(GL_MATRIX26_ARB)
    i(GL_MATRIX27_ARB)
    i(GL_MATRIX28_ARB)
    i(GL_MATRIX29_ARB)
    i(GL_MATRIX30_ARB)
    i(GL_MATRIX31_ARB)
#endif /* GL_ARB_fragment_program */

#ifndef NO_GL_ARB_fragment_program_shadow
#endif /* GL_ARB_fragment_program_shadow */

#ifndef NO_GL_ARB_fragment_shader
    i(GL_FRAGMENT_SHADER_ARB)
    i(GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB)
    i(GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB)
#endif /* GL_ARB_fragment_shader */

#ifndef NO_GL_ARB_fragment_shader_interlock
#endif /* GL_ARB_fragment_shader_interlock */

#ifndef NO_GL_ARB_framebuffer_no_attachments
#endif /* GL_ARB_framebuffer_no_attachments */

#ifndef NO_GL_ARB_framebuffer_object
#endif /* GL_ARB_framebuffer_object */

#ifndef NO_GL_ARB_framebuffer_sRGB
#endif /* GL_ARB_framebuffer_sRGB */

#ifndef NO_GL_ARB_geometry_shader4
    i(GL_LINES_ADJACENCY_ARB)
    i(GL_LINE_STRIP_ADJACENCY_ARB)
    i(GL_TRIANGLES_ADJACENCY_ARB)
    i(GL_TRIANGLE_STRIP_ADJACENCY_ARB)
    i(GL_PROGRAM_POINT_SIZE_ARB)
    i(GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB)
    i(GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB)
    i(GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB)
    i(GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB)
    i(GL_GEOMETRY_SHADER_ARB)
    i(GL_GEOMETRY_VERTICES_OUT_ARB)
    i(GL_GEOMETRY_INPUT_TYPE_ARB)
    i(GL_GEOMETRY_OUTPUT_TYPE_ARB)
    i(GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB)
    i(GL_MAX_VERTEX_VARYING_COMPONENTS_ARB)
    i(GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB)
    i(GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB)
    i(GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB)
#endif /* GL_ARB_geometry_shader4 */

#ifndef NO_GL_ARB_get_program_binary
#endif /* GL_ARB_get_program_binary */

#ifndef NO_GL_ARB_get_texture_sub_image
#endif /* GL_ARB_get_texture_sub_image */

#ifndef NO_GL_ARB_gpu_shader5
#endif /* GL_ARB_gpu_shader5 */

#ifndef NO_GL_ARB_gpu_shader_fp64
#endif /* GL_ARB_gpu_shader_fp64 */

#ifndef NO_GL_ARB_gpu_shader_int64
    i(GL_INT64_ARB)
    i(GL_INT64_VEC2_ARB)
    i(GL_INT64_VEC3_ARB)
    i(GL_INT64_VEC4_ARB)
    i(GL_UNSIGNED_INT64_VEC2_ARB)
    i(GL_UNSIGNED_INT64_VEC3_ARB)
    i(GL_UNSIGNED_INT64_VEC4_ARB)
#endif /* GL_ARB_gpu_shader_int64 */

#ifndef NO_GL_ARB_half_float_pixel
    i(GL_HALF_FLOAT_ARB)
#endif /* GL_ARB_half_float_pixel */

#ifndef NO_GL_ARB_half_float_vertex
#endif /* GL_ARB_half_float_vertex */

#ifndef NO_GL_ARB_imaging
    i(GL_BLEND_COLOR)
    i(GL_BLEND_EQUATION)
    i(GL_CONVOLUTION_1D)
    i(GL_CONVOLUTION_2D)
    i(GL_SEPARABLE_2D)
    i(GL_CONVOLUTION_BORDER_MODE)
    i(GL_CONVOLUTION_FILTER_SCALE)
    i(GL_CONVOLUTION_FILTER_BIAS)
    i(GL_REDUCE)
    i(GL_CONVOLUTION_FORMAT)
    i(GL_CONVOLUTION_WIDTH)
    i(GL_CONVOLUTION_HEIGHT)
    i(GL_MAX_CONVOLUTION_WIDTH)
    i(GL_MAX_CONVOLUTION_HEIGHT)
    i(GL_POST_CONVOLUTION_RED_SCALE)
    i(GL_POST_CONVOLUTION_GREEN_SCALE)
    i(GL_POST_CONVOLUTION_BLUE_SCALE)
    i(GL_POST_CONVOLUTION_ALPHA_SCALE)
    i(GL_POST_CONVOLUTION_RED_BIAS)
    i(GL_POST_CONVOLUTION_GREEN_BIAS)
    i(GL_POST_CONVOLUTION_BLUE_BIAS)
    i(GL_POST_CONVOLUTION_ALPHA_BIAS)
    i(GL_HISTOGRAM)
    i(GL_PROXY_HISTOGRAM)
    i(GL_HISTOGRAM_WIDTH)
    i(GL_HISTOGRAM_FORMAT)
    i(GL_HISTOGRAM_RED_SIZE)
    i(GL_HISTOGRAM_GREEN_SIZE)
    i(GL_HISTOGRAM_BLUE_SIZE)
    i(GL_HISTOGRAM_ALPHA_SIZE)
    i(GL_HISTOGRAM_LUMINANCE_SIZE)
    i(GL_HISTOGRAM_SINK)
    i(GL_MINMAX)
    i(GL_MINMAX_FORMAT)
    i(GL_MINMAX_SINK)
    i(GL_TABLE_TOO_LARGE)
    i(GL_COLOR_MATRIX)
    i(GL_COLOR_MATRIX_STACK_DEPTH)
    i(GL_MAX_COLOR_MATRIX_STACK_DEPTH)
    i(GL_POST_COLOR_MATRIX_RED_SCALE)
    i(GL_POST_COLOR_MATRIX_GREEN_SCALE)
    i(GL_POST_COLOR_MATRIX_BLUE_SCALE)
    i(GL_POST_COLOR_MATRIX_ALPHA_SCALE)
    i(GL_POST_COLOR_MATRIX_RED_BIAS)
    i(GL_POST_COLOR_MATRIX_GREEN_BIAS)
    i(GL_POST_COLOR_MATRIX_BLUE_BIAS)
    i(GL_POST_COLOR_MATRIX_ALPHA_BIAS)
    i(GL_COLOR_TABLE)
    i(GL_POST_CONVOLUTION_COLOR_TABLE)
    i(GL_POST_COLOR_MATRIX_COLOR_TABLE)
    i(GL_PROXY_COLOR_TABLE)
    i(GL_PROXY_POST_CONVOLUTION_COLOR_TABLE)
    i(GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE)
    i(GL_COLOR_TABLE_SCALE)
    i(GL_COLOR_TABLE_BIAS)
    i(GL_COLOR_TABLE_FORMAT)
    i(GL_COLOR_TABLE_WIDTH)
    i(GL_COLOR_TABLE_RED_SIZE)
    i(GL_COLOR_TABLE_GREEN_SIZE)
    i(GL_COLOR_TABLE_BLUE_SIZE)
    i(GL_COLOR_TABLE_ALPHA_SIZE)
    i(GL_COLOR_TABLE_LUMINANCE_SIZE)
    i(GL_COLOR_TABLE_INTENSITY_SIZE)
    i(GL_CONSTANT_BORDER)
    i(GL_REPLICATE_BORDER)
    i(GL_CONVOLUTION_BORDER_COLOR)
#endif /* GL_ARB_imaging */

#ifndef NO_GL_ARB_indirect_parameters
    i(GL_PARAMETER_BUFFER_ARB)
    i(GL_PARAMETER_BUFFER_BINDING_ARB)
#endif /* GL_ARB_indirect_parameters */

#ifndef NO_GL_ARB_instanced_arrays
    i(GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB)
#endif /* GL_ARB_instanced_arrays */

#ifndef NO_GL_ARB_internalformat_query
#endif /* GL_ARB_internalformat_query */

#ifndef NO_GL_ARB_internalformat_query2
    i(GL_SRGB_DECODE_ARB)
#endif /* GL_ARB_internalformat_query2 */

#ifndef NO_GL_ARB_invalidate_subdata
#endif /* GL_ARB_invalidate_subdata */

#ifndef NO_GL_ARB_map_buffer_alignment
#endif /* GL_ARB_map_buffer_alignment */

#ifndef NO_GL_ARB_map_buffer_range
#endif /* GL_ARB_map_buffer_range */

#ifndef NO_GL_ARB_matrix_palette
    i(GL_MATRIX_PALETTE_ARB)
    i(GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB)
    i(GL_MAX_PALETTE_MATRICES_ARB)
    i(GL_CURRENT_PALETTE_MATRIX_ARB)
    i(GL_MATRIX_INDEX_ARRAY_ARB)
    i(GL_CURRENT_MATRIX_INDEX_ARB)
    i(GL_MATRIX_INDEX_ARRAY_SIZE_ARB)
    i(GL_MATRIX_INDEX_ARRAY_TYPE_ARB)
    i(GL_MATRIX_INDEX_ARRAY_STRIDE_ARB)
    i(GL_MATRIX_INDEX_ARRAY_POINTER_ARB)
#endif /* GL_ARB_matrix_palette */

#ifndef NO_GL_ARB_multi_bind
#endif /* GL_ARB_multi_bind */

#ifndef NO_GL_ARB_multi_draw_indirect
#endif /* GL_ARB_multi_draw_indirect */

#ifndef NO_GL_ARB_multisample
    i(GL_MULTISAMPLE_ARB)
    i(GL_SAMPLE_ALPHA_TO_COVERAGE_ARB)
    i(GL_SAMPLE_ALPHA_TO_ONE_ARB)
    i(GL_SAMPLE_COVERAGE_ARB)
    i(GL_SAMPLE_BUFFERS_ARB)
    i(GL_SAMPLES_ARB)
    i(GL_SAMPLE_COVERAGE_VALUE_ARB)
    i(GL_SAMPLE_COVERAGE_INVERT_ARB)
    i(GL_MULTISAMPLE_BIT_ARB)
#endif /* GL_ARB_multisample */

#ifndef NO_GL_ARB_multitexture
    i(GL_TEXTURE0_ARB)
    i(GL_TEXTURE1_ARB)
    i(GL_TEXTURE2_ARB)
    i(GL_TEXTURE3_ARB)
    i(GL_TEXTURE4_ARB)
    i(GL_TEXTURE5_ARB)
    i(GL_TEXTURE6_ARB)
    i(GL_TEXTURE7_ARB)
    i(GL_TEXTURE8_ARB)
    i(GL_TEXTURE9_ARB)
    i(GL_TEXTURE10_ARB)
    i(GL_TEXTURE11_ARB)
    i(GL_TEXTURE12_ARB)
    i(GL_TEXTURE13_ARB)
    i(GL_TEXTURE14_ARB)
    i(GL_TEXTURE15_ARB)
    i(GL_TEXTURE16_ARB)
    i(GL_TEXTURE17_ARB)
    i(GL_TEXTURE18_ARB)
    i(GL_TEXTURE19_ARB)
    i(GL_TEXTURE20_ARB)
    i(GL_TEXTURE21_ARB)
    i(GL_TEXTURE22_ARB)
    i(GL_TEXTURE23_ARB)
    i(GL_TEXTURE24_ARB)
    i(GL_TEXTURE25_ARB)
    i(GL_TEXTURE26_ARB)
    i(GL_TEXTURE27_ARB)
    i(GL_TEXTURE28_ARB)
    i(GL_TEXTURE29_ARB)
    i(GL_TEXTURE30_ARB)
    i(GL_TEXTURE31_ARB)
    i(GL_ACTIVE_TEXTURE_ARB)
    i(GL_CLIENT_ACTIVE_TEXTURE_ARB)
    i(GL_MAX_TEXTURE_UNITS_ARB)
#endif /* GL_ARB_multitexture */

#ifndef NO_GL_ARB_occlusion_query
    i(GL_QUERY_COUNTER_BITS_ARB)
    i(GL_CURRENT_QUERY_ARB)
    i(GL_QUERY_RESULT_ARB)
    i(GL_QUERY_RESULT_AVAILABLE_ARB)
    i(GL_SAMPLES_PASSED_ARB)
#endif /* GL_ARB_occlusion_query */

#ifndef NO_GL_ARB_occlusion_query2
#endif /* GL_ARB_occlusion_query2 */

#ifndef NO_GL_ARB_parallel_shader_compile
    i(GL_MAX_SHADER_COMPILER_THREADS_ARB)
    i(GL_COMPLETION_STATUS_ARB)
#endif /* GL_ARB_parallel_shader_compile */

#ifndef NO_GL_ARB_pipeline_statistics_query
    i(GL_VERTICES_SUBMITTED_ARB)
    i(GL_PRIMITIVES_SUBMITTED_ARB)
    i(GL_VERTEX_SHADER_INVOCATIONS_ARB)
    i(GL_TESS_CONTROL_SHADER_PATCHES_ARB)
    i(GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB)
    i(GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB)
    i(GL_FRAGMENT_SHADER_INVOCATIONS_ARB)
    i(GL_COMPUTE_SHADER_INVOCATIONS_ARB)
    i(GL_CLIPPING_INPUT_PRIMITIVES_ARB)
    i(GL_CLIPPING_OUTPUT_PRIMITIVES_ARB)
#endif /* GL_ARB_pipeline_statistics_query */

#ifndef NO_GL_ARB_pixel_buffer_object
    i(GL_PIXEL_PACK_BUFFER_ARB)
    i(GL_PIXEL_UNPACK_BUFFER_ARB)
    i(GL_PIXEL_PACK_BUFFER_BINDING_ARB)
    i(GL_PIXEL_UNPACK_BUFFER_BINDING_ARB)
#endif /* GL_ARB_pixel_buffer_object */

#ifndef NO_GL_ARB_point_parameters
    i(GL_POINT_SIZE_MIN_ARB)
    i(GL_POINT_SIZE_MAX_ARB)
    i(GL_POINT_FADE_THRESHOLD_SIZE_ARB)
    i(GL_POINT_DISTANCE_ATTENUATION_ARB)
#endif /* GL_ARB_point_parameters */

#ifndef NO_GL_ARB_point_sprite
    i(GL_POINT_SPRITE_ARB)
    i(GL_COORD_REPLACE_ARB)
#endif /* GL_ARB_point_sprite */

#ifndef NO_GL_ARB_post_depth_coverage
#endif /* GL_ARB_post_depth_coverage */

#ifndef NO_GL_ARB_program_interface_query
#endif /* GL_ARB_program_interface_query */

#ifndef NO_GL_ARB_provoking_vertex
#endif /* GL_ARB_provoking_vertex */

#ifndef NO_GL_ARB_query_buffer_object
#endif /* GL_ARB_query_buffer_object */

#ifndef NO_GL_ARB_robust_buffer_access_behavior
#endif /* GL_ARB_robust_buffer_access_behavior */

#ifndef NO_GL_ARB_robustness
    i(GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB)
    i(GL_LOSE_CONTEXT_ON_RESET_ARB)
    i(GL_GUILTY_CONTEXT_RESET_ARB)
    i(GL_INNOCENT_CONTEXT_RESET_ARB)
    i(GL_UNKNOWN_CONTEXT_RESET_ARB)
    i(GL_RESET_NOTIFICATION_STRATEGY_ARB)
    i(GL_NO_RESET_NOTIFICATION_ARB)
#endif /* GL_ARB_robustness */

#ifndef NO_GL_ARB_robustness_isolation
#endif /* GL_ARB_robustness_isolation */

#ifndef NO_GL_ARB_sample_locations
    i(GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB)
    i(GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB)
    i(GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB)
    i(GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB)
    i(GL_SAMPLE_LOCATION_ARB)
    i(GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB)
    i(GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB)
    i(GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB)
#endif /* GL_ARB_sample_locations */

#ifndef NO_GL_ARB_sample_shading
    i(GL_SAMPLE_SHADING_ARB)
    i(GL_MIN_SAMPLE_SHADING_VALUE_ARB)
#endif /* GL_ARB_sample_shading */

#ifndef NO_GL_ARB_sampler_objects
#endif /* GL_ARB_sampler_objects */

#ifndef NO_GL_ARB_seamless_cube_map
#endif /* GL_ARB_seamless_cube_map */

#ifndef NO_GL_ARB_seamless_cubemap_per_texture
#endif /* GL_ARB_seamless_cubemap_per_texture */

#ifndef NO_GL_ARB_separate_shader_objects
#endif /* GL_ARB_separate_shader_objects */

#ifndef NO_GL_ARB_shader_atomic_counter_ops
#endif /* GL_ARB_shader_atomic_counter_ops */

#ifndef NO_GL_ARB_shader_atomic_counters
#endif /* GL_ARB_shader_atomic_counters */

#ifndef NO_GL_ARB_shader_ballot
#endif /* GL_ARB_shader_ballot */

#ifndef NO_GL_ARB_shader_bit_encoding
#endif /* GL_ARB_shader_bit_encoding */

#ifndef NO_GL_ARB_shader_clock
#endif /* GL_ARB_shader_clock */

#ifndef NO_GL_ARB_shader_draw_parameters
#endif /* GL_ARB_shader_draw_parameters */

#ifndef NO_GL_ARB_shader_group_vote
#endif /* GL_ARB_shader_group_vote */

#ifndef NO_GL_ARB_shader_image_load_store
#endif /* GL_ARB_shader_image_load_store */

#ifndef NO_GL_ARB_shader_image_size
#endif /* GL_ARB_shader_image_size */

#ifndef NO_GL_ARB_shader_objects
#ifdef __APPLE__
#else
#endif
    i(GL_PROGRAM_OBJECT_ARB)
    i(GL_SHADER_OBJECT_ARB)
    i(GL_OBJECT_TYPE_ARB)
    i(GL_OBJECT_SUBTYPE_ARB)
    i(GL_FLOAT_VEC2_ARB)
    i(GL_FLOAT_VEC3_ARB)
    i(GL_FLOAT_VEC4_ARB)
    i(GL_INT_VEC2_ARB)
    i(GL_INT_VEC3_ARB)
    i(GL_INT_VEC4_ARB)
    i(GL_BOOL_ARB)
    i(GL_BOOL_VEC2_ARB)
    i(GL_BOOL_VEC3_ARB)
    i(GL_BOOL_VEC4_ARB)
    i(GL_FLOAT_MAT2_ARB)
    i(GL_FLOAT_MAT3_ARB)
    i(GL_FLOAT_MAT4_ARB)
    i(GL_SAMPLER_1D_ARB)
    i(GL_SAMPLER_2D_ARB)
    i(GL_SAMPLER_3D_ARB)
    i(GL_SAMPLER_CUBE_ARB)
    i(GL_SAMPLER_1D_SHADOW_ARB)
    i(GL_SAMPLER_2D_SHADOW_ARB)
    i(GL_SAMPLER_2D_RECT_ARB)
    i(GL_SAMPLER_2D_RECT_SHADOW_ARB)
    i(GL_OBJECT_DELETE_STATUS_ARB)
    i(GL_OBJECT_COMPILE_STATUS_ARB)
    i(GL_OBJECT_LINK_STATUS_ARB)
    i(GL_OBJECT_VALIDATE_STATUS_ARB)
    i(GL_OBJECT_INFO_LOG_LENGTH_ARB)
    i(GL_OBJECT_ATTACHED_OBJECTS_ARB)
    i(GL_OBJECT_ACTIVE_UNIFORMS_ARB)
    i(GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB)
    i(GL_OBJECT_SHADER_SOURCE_LENGTH_ARB)
#endif /* GL_ARB_shader_objects */

#ifndef NO_GL_ARB_shader_precision
#endif /* GL_ARB_shader_precision */

#ifndef NO_GL_ARB_shader_stencil_export
#endif /* GL_ARB_shader_stencil_export */

#ifndef NO_GL_ARB_shader_storage_buffer_object
#endif /* GL_ARB_shader_storage_buffer_object */

#ifndef NO_GL_ARB_shader_subroutine
#endif /* GL_ARB_shader_subroutine */

#ifndef NO_GL_ARB_shader_texture_image_samples
#endif /* GL_ARB_shader_texture_image_samples */

#ifndef NO_GL_ARB_shader_texture_lod
#endif /* GL_ARB_shader_texture_lod */

#ifndef NO_GL_ARB_shader_viewport_layer_array
#endif /* GL_ARB_shader_viewport_layer_array */

#ifndef NO_GL_ARB_shading_language_100
    i(GL_SHADING_LANGUAGE_VERSION_ARB)
#endif /* GL_ARB_shading_language_100 */

#ifndef NO_GL_ARB_shading_language_420pack
#endif /* GL_ARB_shading_language_420pack */

#ifndef NO_GL_ARB_shading_language_include
    i(GL_SHADER_INCLUDE_ARB)
    i(GL_NAMED_STRING_LENGTH_ARB)
    i(GL_NAMED_STRING_TYPE_ARB)
#endif /* GL_ARB_shading_language_include */

#ifndef NO_GL_ARB_shading_language_packing
#endif /* GL_ARB_shading_language_packing */

#ifndef NO_GL_ARB_shadow
    i(GL_TEXTURE_COMPARE_MODE_ARB)
    i(GL_TEXTURE_COMPARE_FUNC_ARB)
    i(GL_COMPARE_R_TO_TEXTURE_ARB)
#endif /* GL_ARB_shadow */

#ifndef NO_GL_ARB_shadow_ambient
    i(GL_TEXTURE_COMPARE_FAIL_VALUE_ARB)
#endif /* GL_ARB_shadow_ambient */

#ifndef NO_GL_ARB_sparse_buffer
    i(GL_SPARSE_STORAGE_BIT_ARB)
    i(GL_SPARSE_BUFFER_PAGE_SIZE_ARB)
#endif /* GL_ARB_sparse_buffer */

#ifndef NO_GL_ARB_sparse_texture
    i(GL_TEXTURE_SPARSE_ARB)
    i(GL_VIRTUAL_PAGE_SIZE_INDEX_ARB)
    i(GL_NUM_SPARSE_LEVELS_ARB)
    i(GL_NUM_VIRTUAL_PAGE_SIZES_ARB)
    i(GL_VIRTUAL_PAGE_SIZE_X_ARB)
    i(GL_VIRTUAL_PAGE_SIZE_Y_ARB)
    i(GL_VIRTUAL_PAGE_SIZE_Z_ARB)
    i(GL_MAX_SPARSE_TEXTURE_SIZE_ARB)
    i(GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB)
    i(GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB)
    i(GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB)
#endif /* GL_ARB_sparse_texture */

#ifndef NO_GL_ARB_sparse_texture2
#endif /* GL_ARB_sparse_texture2 */

#ifndef NO_GL_ARB_sparse_texture_clamp
#endif /* GL_ARB_sparse_texture_clamp */

#ifndef NO_GL_ARB_stencil_texturing
#endif /* GL_ARB_stencil_texturing */

#ifndef NO_GL_ARB_sync
#endif /* GL_ARB_sync */

#ifndef NO_GL_ARB_tessellation_shader
#endif /* GL_ARB_tessellation_shader */

#ifndef NO_GL_ARB_texture_barrier
#endif /* GL_ARB_texture_barrier */

#ifndef NO_GL_ARB_texture_border_clamp
    i(GL_CLAMP_TO_BORDER_ARB)
#endif /* GL_ARB_texture_border_clamp */

#ifndef NO_GL_ARB_texture_buffer_object
    i(GL_TEXTURE_BUFFER_ARB)
    i(GL_MAX_TEXTURE_BUFFER_SIZE_ARB)
    i(GL_TEXTURE_BINDING_BUFFER_ARB)
    i(GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB)
    i(GL_TEXTURE_BUFFER_FORMAT_ARB)
#endif /* GL_ARB_texture_buffer_object */

#ifndef NO_GL_ARB_texture_buffer_object_rgb32
#endif /* GL_ARB_texture_buffer_object_rgb32 */

#ifndef NO_GL_ARB_texture_buffer_range
#endif /* GL_ARB_texture_buffer_range */

#ifndef NO_GL_ARB_texture_compression
    i(GL_COMPRESSED_ALPHA_ARB)
    i(GL_COMPRESSED_LUMINANCE_ARB)
    i(GL_COMPRESSED_LUMINANCE_ALPHA_ARB)
    i(GL_COMPRESSED_INTENSITY_ARB)
    i(GL_COMPRESSED_RGB_ARB)
    i(GL_COMPRESSED_RGBA_ARB)
    i(GL_TEXTURE_COMPRESSION_HINT_ARB)
    i(GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB)
    i(GL_TEXTURE_COMPRESSED_ARB)
    i(GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB)
    i(GL_COMPRESSED_TEXTURE_FORMATS_ARB)
#endif /* GL_ARB_texture_compression */

#ifndef NO_GL_ARB_texture_compression_bptc
    i(GL_COMPRESSED_RGBA_BPTC_UNORM_ARB)
    i(GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB)
    i(GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB)
    i(GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB)
#endif /* GL_ARB_texture_compression_bptc */

#ifndef NO_GL_ARB_texture_compression_rgtc
#endif /* GL_ARB_texture_compression_rgtc */

#ifndef NO_GL_ARB_texture_cube_map
    i(GL_NORMAL_MAP_ARB)
    i(GL_REFLECTION_MAP_ARB)
    i(GL_TEXTURE_CUBE_MAP_ARB)
    i(GL_TEXTURE_BINDING_CUBE_MAP_ARB)
    i(GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB)
    i(GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB)
    i(GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB)
    i(GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB)
    i(GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB)
    i(GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB)
    i(GL_PROXY_TEXTURE_CUBE_MAP_ARB)
    i(GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB)
#endif /* GL_ARB_texture_cube_map */

#ifndef NO_GL_ARB_texture_cube_map_array
    i(GL_TEXTURE_CUBE_MAP_ARRAY_ARB)
    i(GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB)
    i(GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB)
    i(GL_SAMPLER_CUBE_MAP_ARRAY_ARB)
    i(GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB)
    i(GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB)
    i(GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB)
#endif /* GL_ARB_texture_cube_map_array */

#ifndef NO_GL_ARB_texture_env_add
#endif /* GL_ARB_texture_env_add */

#ifndef NO_GL_ARB_texture_env_combine
    i(GL_COMBINE_ARB)
    i(GL_COMBINE_RGB_ARB)
    i(GL_COMBINE_ALPHA_ARB)
    i(GL_SOURCE0_RGB_ARB)
    i(GL_SOURCE1_RGB_ARB)
    i(GL_SOURCE2_RGB_ARB)
    i(GL_SOURCE0_ALPHA_ARB)
    i(GL_SOURCE1_ALPHA_ARB)
    i(GL_SOURCE2_ALPHA_ARB)
    i(GL_OPERAND0_RGB_ARB)
    i(GL_OPERAND1_RGB_ARB)
    i(GL_OPERAND2_RGB_ARB)
    i(GL_OPERAND0_ALPHA_ARB)
    i(GL_OPERAND1_ALPHA_ARB)
    i(GL_OPERAND2_ALPHA_ARB)
    i(GL_RGB_SCALE_ARB)
    i(GL_ADD_SIGNED_ARB)
    i(GL_INTERPOLATE_ARB)
    i(GL_SUBTRACT_ARB)
    i(GL_CONSTANT_ARB)
    i(GL_PRIMARY_COLOR_ARB)
    i(GL_PREVIOUS_ARB)
#endif /* GL_ARB_texture_env_combine */

#ifndef NO_GL_ARB_texture_env_crossbar
#endif /* GL_ARB_texture_env_crossbar */

#ifndef NO_GL_ARB_texture_env_dot3
    i(GL_DOT3_RGB_ARB)
    i(GL_DOT3_RGBA_ARB)
#endif /* GL_ARB_texture_env_dot3 */

#ifndef NO_GL_ARB_texture_filter_minmax
    i(GL_TEXTURE_REDUCTION_MODE_ARB)
    i(GL_WEIGHTED_AVERAGE_ARB)
#endif /* GL_ARB_texture_filter_minmax */

#ifndef NO_GL_ARB_texture_float
    i(GL_TEXTURE_RED_TYPE_ARB)
    i(GL_TEXTURE_GREEN_TYPE_ARB)
    i(GL_TEXTURE_BLUE_TYPE_ARB)
    i(GL_TEXTURE_ALPHA_TYPE_ARB)
    i(GL_TEXTURE_LUMINANCE_TYPE_ARB)
    i(GL_TEXTURE_INTENSITY_TYPE_ARB)
    i(GL_TEXTURE_DEPTH_TYPE_ARB)
    i(GL_UNSIGNED_NORMALIZED_ARB)
    i(GL_RGBA32F_ARB)
    i(GL_RGB32F_ARB)
    i(GL_ALPHA32F_ARB)
    i(GL_INTENSITY32F_ARB)
    i(GL_LUMINANCE32F_ARB)
    i(GL_LUMINANCE_ALPHA32F_ARB)
    i(GL_RGBA16F_ARB)
    i(GL_RGB16F_ARB)
    i(GL_ALPHA16F_ARB)
    i(GL_INTENSITY16F_ARB)
    i(GL_LUMINANCE16F_ARB)
    i(GL_LUMINANCE_ALPHA16F_ARB)
#endif /* GL_ARB_texture_float */

#ifndef NO_GL_ARB_texture_gather
    i(GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB)
    i(GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB)
    i(GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB)
#endif /* GL_ARB_texture_gather */

#ifndef NO_GL_ARB_texture_mirror_clamp_to_edge
#endif /* GL_ARB_texture_mirror_clamp_to_edge */

#ifndef NO_GL_ARB_texture_mirrored_repeat
    i(GL_MIRRORED_REPEAT_ARB)
#endif /* GL_ARB_texture_mirrored_repeat */

#ifndef NO_GL_ARB_texture_multisample
#endif /* GL_ARB_texture_multisample */

#ifndef NO_GL_ARB_texture_non_power_of_two
#endif /* GL_ARB_texture_non_power_of_two */

#ifndef NO_GL_ARB_texture_query_levels
#endif /* GL_ARB_texture_query_levels */

#ifndef NO_GL_ARB_texture_query_lod
#endif /* GL_ARB_texture_query_lod */

#ifndef NO_GL_ARB_texture_rectangle
    i(GL_TEXTURE_RECTANGLE_ARB)
    i(GL_TEXTURE_BINDING_RECTANGLE_ARB)
    i(GL_PROXY_TEXTURE_RECTANGLE_ARB)
    i(GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB)
#endif /* GL_ARB_texture_rectangle */

#ifndef NO_GL_ARB_texture_rg
#endif /* GL_ARB_texture_rg */

#ifndef NO_GL_ARB_texture_rgb10_a2ui
#endif /* GL_ARB_texture_rgb10_a2ui */

#ifndef NO_GL_ARB_texture_stencil8
#endif /* GL_ARB_texture_stencil8 */

#ifndef NO_GL_ARB_texture_storage
#endif /* GL_ARB_texture_storage */

#ifndef NO_GL_ARB_texture_storage_multisample
#endif /* GL_ARB_texture_storage_multisample */

#ifndef NO_GL_ARB_texture_swizzle
#endif /* GL_ARB_texture_swizzle */

#ifndef NO_GL_ARB_texture_view
#endif /* GL_ARB_texture_view */

#ifndef NO_GL_ARB_timer_query
#endif /* GL_ARB_timer_query */

#ifndef NO_GL_ARB_transform_feedback2
#endif /* GL_ARB_transform_feedback2 */

#ifndef NO_GL_ARB_transform_feedback3
#endif /* GL_ARB_transform_feedback3 */

#ifndef NO_GL_ARB_transform_feedback_instanced
#endif /* GL_ARB_transform_feedback_instanced */

#ifndef NO_GL_ARB_transform_feedback_overflow_query
    i(GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB)
    i(GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB)
#endif /* GL_ARB_transform_feedback_overflow_query */

#ifndef NO_GL_ARB_transpose_matrix
    i(GL_TRANSPOSE_MODELVIEW_MATRIX_ARB)
    i(GL_TRANSPOSE_PROJECTION_MATRIX_ARB)
    i(GL_TRANSPOSE_TEXTURE_MATRIX_ARB)
    i(GL_TRANSPOSE_COLOR_MATRIX_ARB)
#endif /* GL_ARB_transpose_matrix */

#ifndef NO_GL_ARB_uniform_buffer_object
#endif /* GL_ARB_uniform_buffer_object */

#ifndef NO_GL_ARB_vertex_array_bgra
#endif /* GL_ARB_vertex_array_bgra */

#ifndef NO_GL_ARB_vertex_array_object
#endif /* GL_ARB_vertex_array_object */

#ifndef NO_GL_ARB_vertex_attrib_64bit
#endif /* GL_ARB_vertex_attrib_64bit */

#ifndef NO_GL_ARB_vertex_attrib_binding
#endif /* GL_ARB_vertex_attrib_binding */

#ifndef NO_GL_ARB_vertex_blend
    i(GL_MAX_VERTEX_UNITS_ARB)
    i(GL_ACTIVE_VERTEX_UNITS_ARB)
    i(GL_WEIGHT_SUM_UNITY_ARB)
    i(GL_VERTEX_BLEND_ARB)
    i(GL_CURRENT_WEIGHT_ARB)
    i(GL_WEIGHT_ARRAY_TYPE_ARB)
    i(GL_WEIGHT_ARRAY_STRIDE_ARB)
    i(GL_WEIGHT_ARRAY_SIZE_ARB)
    i(GL_WEIGHT_ARRAY_POINTER_ARB)
    i(GL_WEIGHT_ARRAY_ARB)
    i(GL_MODELVIEW0_ARB)
    i(GL_MODELVIEW1_ARB)
    i(GL_MODELVIEW2_ARB)
    i(GL_MODELVIEW3_ARB)
    i(GL_MODELVIEW4_ARB)
    i(GL_MODELVIEW5_ARB)
    i(GL_MODELVIEW6_ARB)
    i(GL_MODELVIEW7_ARB)
    i(GL_MODELVIEW8_ARB)
    i(GL_MODELVIEW9_ARB)
    i(GL_MODELVIEW10_ARB)
    i(GL_MODELVIEW11_ARB)
    i(GL_MODELVIEW12_ARB)
    i(GL_MODELVIEW13_ARB)
    i(GL_MODELVIEW14_ARB)
    i(GL_MODELVIEW15_ARB)
    i(GL_MODELVIEW16_ARB)
    i(GL_MODELVIEW17_ARB)
    i(GL_MODELVIEW18_ARB)
    i(GL_MODELVIEW19_ARB)
    i(GL_MODELVIEW20_ARB)
    i(GL_MODELVIEW21_ARB)
    i(GL_MODELVIEW22_ARB)
    i(GL_MODELVIEW23_ARB)
    i(GL_MODELVIEW24_ARB)
    i(GL_MODELVIEW25_ARB)
    i(GL_MODELVIEW26_ARB)
    i(GL_MODELVIEW27_ARB)
    i(GL_MODELVIEW28_ARB)
    i(GL_MODELVIEW29_ARB)
    i(GL_MODELVIEW30_ARB)
    i(GL_MODELVIEW31_ARB)
#endif /* GL_ARB_vertex_blend */

#ifndef NO_GL_ARB_vertex_buffer_object
    i(GL_BUFFER_SIZE_ARB)
    i(GL_BUFFER_USAGE_ARB)
    i(GL_ARRAY_BUFFER_ARB)
    i(GL_ELEMENT_ARRAY_BUFFER_ARB)
    i(GL_ARRAY_BUFFER_BINDING_ARB)
    i(GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB)
    i(GL_VERTEX_ARRAY_BUFFER_BINDING_ARB)
    i(GL_NORMAL_ARRAY_BUFFER_BINDING_ARB)
    i(GL_COLOR_ARRAY_BUFFER_BINDING_ARB)
    i(GL_INDEX_ARRAY_BUFFER_BINDING_ARB)
    i(GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB)
    i(GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB)
    i(GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB)
    i(GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB)
    i(GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB)
    i(GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB)
    i(GL_READ_ONLY_ARB)
    i(GL_WRITE_ONLY_ARB)
    i(GL_READ_WRITE_ARB)
    i(GL_BUFFER_ACCESS_ARB)
    i(GL_BUFFER_MAPPED_ARB)
    i(GL_BUFFER_MAP_POINTER_ARB)
    i(GL_STREAM_DRAW_ARB)
    i(GL_STREAM_READ_ARB)
    i(GL_STREAM_COPY_ARB)
    i(GL_STATIC_DRAW_ARB)
    i(GL_STATIC_READ_ARB)
    i(GL_STATIC_COPY_ARB)
    i(GL_DYNAMIC_DRAW_ARB)
    i(GL_DYNAMIC_READ_ARB)
    i(GL_DYNAMIC_COPY_ARB)
#endif /* GL_ARB_vertex_buffer_object */

#ifndef NO_GL_ARB_vertex_program
    i(GL_COLOR_SUM_ARB)
    i(GL_VERTEX_PROGRAM_ARB)
    i(GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB)
    i(GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB)
    i(GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB)
    i(GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB)
    i(GL_CURRENT_VERTEX_ATTRIB_ARB)
    i(GL_VERTEX_PROGRAM_POINT_SIZE_ARB)
    i(GL_VERTEX_PROGRAM_TWO_SIDE_ARB)
    i(GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB)
    i(GL_MAX_VERTEX_ATTRIBS_ARB)
    i(GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB)
    i(GL_PROGRAM_ADDRESS_REGISTERS_ARB)
    i(GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB)
    i(GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB)
    i(GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB)
#endif /* GL_ARB_vertex_program */

#ifndef NO_GL_ARB_vertex_shader
    i(GL_VERTEX_SHADER_ARB)
    i(GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB)
    i(GL_MAX_VARYING_FLOATS_ARB)
    i(GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB)
    i(GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB)
    i(GL_OBJECT_ACTIVE_ATTRIBUTES_ARB)
    i(GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB)
#endif /* GL_ARB_vertex_shader */

#ifndef NO_GL_ARB_vertex_type_10f_11f_11f_rev
#endif /* GL_ARB_vertex_type_10f_11f_11f_rev */

#ifndef NO_GL_ARB_vertex_type_2_10_10_10_rev
#endif /* GL_ARB_vertex_type_2_10_10_10_rev */

#ifndef NO_GL_ARB_viewport_array
#endif /* GL_ARB_viewport_array */

#ifndef NO_GL_ARB_window_pos
#endif /* GL_ARB_window_pos */

#ifndef NO_GL_KHR_blend_equation_advanced
    i(GL_MULTIPLY_KHR)
    i(GL_SCREEN_KHR)
    i(GL_OVERLAY_KHR)
    i(GL_DARKEN_KHR)
    i(GL_LIGHTEN_KHR)
    i(GL_COLORDODGE_KHR)
    i(GL_COLORBURN_KHR)
    i(GL_HARDLIGHT_KHR)
    i(GL_SOFTLIGHT_KHR)
    i(GL_DIFFERENCE_KHR)
    i(GL_EXCLUSION_KHR)
    i(GL_HSL_HUE_KHR)
    i(GL_HSL_SATURATION_KHR)
    i(GL_HSL_COLOR_KHR)
    i(GL_HSL_LUMINOSITY_KHR)
#endif /* GL_KHR_blend_equation_advanced */

#ifndef NO_GL_KHR_blend_equation_advanced_coherent
    i(GL_BLEND_ADVANCED_COHERENT_KHR)
#endif /* GL_KHR_blend_equation_advanced_coherent */

#ifndef NO_GL_KHR_context_flush_control
#endif /* GL_KHR_context_flush_control */

#ifndef NO_GL_KHR_debug
#endif /* GL_KHR_debug */

#ifndef NO_GL_KHR_no_error
    i(GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR)
#endif /* GL_KHR_no_error */

#ifndef NO_GL_KHR_robust_buffer_access_behavior
#endif /* GL_KHR_robust_buffer_access_behavior */

#ifndef NO_GL_KHR_robustness
    i(GL_CONTEXT_ROBUST_ACCESS)
#endif /* GL_KHR_robustness */

#ifndef NO_GL_KHR_texture_compression_astc_hdr
    i(GL_COMPRESSED_RGBA_ASTC_4x4_KHR)
    i(GL_COMPRESSED_RGBA_ASTC_5x4_KHR)
    i(GL_COMPRESSED_RGBA_ASTC_5x5_KHR)
    i(GL_COMPRESSED_RGBA_ASTC_6x5_KHR)
    i(GL_COMPRESSED_RGBA_ASTC_6x6_KHR)
    i(GL_COMPRESSED_RGBA_ASTC_8x5_KHR)
    i(GL_COMPRESSED_RGBA_ASTC_8x6_KHR)
    i(GL_COMPRESSED_RGBA_ASTC_8x8_KHR)
    i(GL_COMPRESSED_RGBA_ASTC_10x5_KHR)
    i(GL_COMPRESSED_RGBA_ASTC_10x6_KHR)
    i(GL_COMPRESSED_RGBA_ASTC_10x8_KHR)
    i(GL_COMPRESSED_RGBA_ASTC_10x10_KHR)
    i(GL_COMPRESSED_RGBA_ASTC_12x10_KHR)
    i(GL_COMPRESSED_RGBA_ASTC_12x12_KHR)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR)
    i(GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR)
#endif /* GL_KHR_texture_compression_astc_hdr */

#ifndef NO_GL_KHR_texture_compression_astc_ldr
#endif /* GL_KHR_texture_compression_astc_ldr */

#ifndef NO_GL_KHR_texture_compression_astc_sliced_3d
#endif /* GL_KHR_texture_compression_astc_sliced_3d */

#ifndef NO_GL_OES_byte_coordinates
#endif /* GL_OES_byte_coordinates */

#ifndef NO_GL_OES_compressed_paletted_texture
    i(GL_PALETTE4_RGB8_OES)
    i(GL_PALETTE4_RGBA8_OES)
    i(GL_PALETTE4_R5_G6_B5_OES)
    i(GL_PALETTE4_RGBA4_OES)
    i(GL_PALETTE4_RGB5_A1_OES)
    i(GL_PALETTE8_RGB8_OES)
    i(GL_PALETTE8_RGBA8_OES)
    i(GL_PALETTE8_R5_G6_B5_OES)
    i(GL_PALETTE8_RGBA4_OES)
    i(GL_PALETTE8_RGB5_A1_OES)
#endif /* GL_OES_compressed_paletted_texture */

#ifndef NO_GL_OES_fixed_point
    i(GL_FIXED_OES)
#endif /* GL_OES_fixed_point */

#ifndef NO_GL_OES_query_matrix
#endif /* GL_OES_query_matrix */

#ifndef NO_GL_OES_read_format
    i(GL_IMPLEMENTATION_COLOR_READ_TYPE_OES)
    i(GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES)
#endif /* GL_OES_read_format */

#ifndef NO_GL_OES_single_precision
#endif /* GL_OES_single_precision */

#ifndef NO_GL_3DFX_multisample
    i(GL_MULTISAMPLE_3DFX)
    i(GL_SAMPLE_BUFFERS_3DFX)
    i(GL_SAMPLES_3DFX)
    i(GL_MULTISAMPLE_BIT_3DFX)
#endif /* GL_3DFX_multisample */

#ifndef NO_GL_3DFX_tbuffer
#endif /* GL_3DFX_tbuffer */

#ifndef NO_GL_3DFX_texture_compression_FXT1
    i(GL_COMPRESSED_RGB_FXT1_3DFX)
    i(GL_COMPRESSED_RGBA_FXT1_3DFX)
#endif /* GL_3DFX_texture_compression_FXT1 */

#ifndef NO_GL_AMD_blend_minmax_factor
    i(GL_FACTOR_MIN_AMD)
    i(GL_FACTOR_MAX_AMD)
#endif /* GL_AMD_blend_minmax_factor */

#ifndef NO_GL_AMD_conservative_depth
#endif /* GL_AMD_conservative_depth */

#ifndef NO_GL_AMD_debug_output
    i(GL_MAX_DEBUG_MESSAGE_LENGTH_AMD)
    i(GL_MAX_DEBUG_LOGGED_MESSAGES_AMD)
    i(GL_DEBUG_LOGGED_MESSAGES_AMD)
    i(GL_DEBUG_SEVERITY_HIGH_AMD)
    i(GL_DEBUG_SEVERITY_MEDIUM_AMD)
    i(GL_DEBUG_SEVERITY_LOW_AMD)
    i(GL_DEBUG_CATEGORY_API_ERROR_AMD)
    i(GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD)
    i(GL_DEBUG_CATEGORY_DEPRECATION_AMD)
    i(GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD)
    i(GL_DEBUG_CATEGORY_PERFORMANCE_AMD)
    i(GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD)
    i(GL_DEBUG_CATEGORY_APPLICATION_AMD)
    i(GL_DEBUG_CATEGORY_OTHER_AMD)
#endif /* GL_AMD_debug_output */

#ifndef NO_GL_AMD_depth_clamp_separate
    i(GL_DEPTH_CLAMP_NEAR_AMD)
    i(GL_DEPTH_CLAMP_FAR_AMD)
#endif /* GL_AMD_depth_clamp_separate */

#ifndef NO_GL_AMD_draw_buffers_blend
#endif /* GL_AMD_draw_buffers_blend */

#ifndef NO_GL_AMD_gcn_shader
#endif /* GL_AMD_gcn_shader */

#ifndef NO_GL_AMD_gpu_shader_int64
    i(GL_INT64_NV)
    i(GL_UNSIGNED_INT64_NV)
    i(GL_INT8_NV)
    i(GL_INT8_VEC2_NV)
    i(GL_INT8_VEC3_NV)
    i(GL_INT8_VEC4_NV)
    i(GL_INT16_NV)
    i(GL_INT16_VEC2_NV)
    i(GL_INT16_VEC3_NV)
    i(GL_INT16_VEC4_NV)
    i(GL_INT64_VEC2_NV)
    i(GL_INT64_VEC3_NV)
    i(GL_INT64_VEC4_NV)
    i(GL_UNSIGNED_INT8_NV)
    i(GL_UNSIGNED_INT8_VEC2_NV)
    i(GL_UNSIGNED_INT8_VEC3_NV)
    i(GL_UNSIGNED_INT8_VEC4_NV)
    i(GL_UNSIGNED_INT16_NV)
    i(GL_UNSIGNED_INT16_VEC2_NV)
    i(GL_UNSIGNED_INT16_VEC3_NV)
    i(GL_UNSIGNED_INT16_VEC4_NV)
    i(GL_UNSIGNED_INT64_VEC2_NV)
    i(GL_UNSIGNED_INT64_VEC3_NV)
    i(GL_UNSIGNED_INT64_VEC4_NV)
    i(GL_FLOAT16_NV)
    i(GL_FLOAT16_VEC2_NV)
    i(GL_FLOAT16_VEC3_NV)
    i(GL_FLOAT16_VEC4_NV)
#endif /* GL_AMD_gpu_shader_int64 */

#ifndef NO_GL_AMD_interleaved_elements
    i(GL_VERTEX_ELEMENT_SWIZZLE_AMD)
    i(GL_VERTEX_ID_SWIZZLE_AMD)
#endif /* GL_AMD_interleaved_elements */

#ifndef NO_GL_AMD_multi_draw_indirect
#endif /* GL_AMD_multi_draw_indirect */

#ifndef NO_GL_AMD_name_gen_delete
    i(GL_DATA_BUFFER_AMD)
    i(GL_PERFORMANCE_MONITOR_AMD)
    i(GL_QUERY_OBJECT_AMD)
    i(GL_VERTEX_ARRAY_OBJECT_AMD)
    i(GL_SAMPLER_OBJECT_AMD)
#endif /* GL_AMD_name_gen_delete */

#ifndef NO_GL_AMD_occlusion_query_event
    i(GL_OCCLUSION_QUERY_EVENT_MASK_AMD)
    i(GL_QUERY_DEPTH_PASS_EVENT_BIT_AMD)
    i(GL_QUERY_DEPTH_FAIL_EVENT_BIT_AMD)
    i(GL_QUERY_STENCIL_FAIL_EVENT_BIT_AMD)
    i(GL_QUERY_DEPTH_BOUNDS_FAIL_EVENT_BIT_AMD)
    i(GL_QUERY_ALL_EVENT_BITS_AMD)
#endif /* GL_AMD_occlusion_query_event */

#ifndef NO_GL_AMD_performance_monitor
    i(GL_COUNTER_TYPE_AMD)
    i(GL_COUNTER_RANGE_AMD)
    i(GL_UNSIGNED_INT64_AMD)
    i(GL_PERCENTAGE_AMD)
    i(GL_PERFMON_RESULT_AVAILABLE_AMD)
    i(GL_PERFMON_RESULT_SIZE_AMD)
    i(GL_PERFMON_RESULT_AMD)
#endif /* GL_AMD_performance_monitor */

#ifndef NO_GL_AMD_pinned_memory
    i(GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD)
#endif /* GL_AMD_pinned_memory */

#ifndef NO_GL_AMD_query_buffer_object
    i(GL_QUERY_BUFFER_AMD)
    i(GL_QUERY_BUFFER_BINDING_AMD)
    i(GL_QUERY_RESULT_NO_WAIT_AMD)
#endif /* GL_AMD_query_buffer_object */

#ifndef NO_GL_AMD_sample_positions
    i(GL_SUBSAMPLE_DISTANCE_AMD)
#endif /* GL_AMD_sample_positions */

#ifndef NO_GL_AMD_seamless_cubemap_per_texture
#endif /* GL_AMD_seamless_cubemap_per_texture */

#ifndef NO_GL_AMD_shader_atomic_counter_ops
#endif /* GL_AMD_shader_atomic_counter_ops */

#ifndef NO_GL_AMD_shader_explicit_vertex_parameter
#endif /* GL_AMD_shader_explicit_vertex_parameter */

#ifndef NO_GL_AMD_shader_stencil_export
#endif /* GL_AMD_shader_stencil_export */

#ifndef NO_GL_AMD_shader_trinary_minmax
#endif /* GL_AMD_shader_trinary_minmax */

#ifndef NO_GL_AMD_sparse_texture
    i(GL_VIRTUAL_PAGE_SIZE_X_AMD)
    i(GL_VIRTUAL_PAGE_SIZE_Y_AMD)
    i(GL_VIRTUAL_PAGE_SIZE_Z_AMD)
    i(GL_MAX_SPARSE_TEXTURE_SIZE_AMD)
    i(GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD)
    i(GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS)
    i(GL_MIN_SPARSE_LEVEL_AMD)
    i(GL_MIN_LOD_WARNING_AMD)
    i(GL_TEXTURE_STORAGE_SPARSE_BIT_AMD)
#endif /* GL_AMD_sparse_texture */

#ifndef NO_GL_AMD_stencil_operation_extended
    i(GL_SET_AMD)
    i(GL_REPLACE_VALUE_AMD)
    i(GL_STENCIL_OP_VALUE_AMD)
    i(GL_STENCIL_BACK_OP_VALUE_AMD)
#endif /* GL_AMD_stencil_operation_extended */

#ifndef NO_GL_AMD_texture_texture4
#endif /* GL_AMD_texture_texture4 */

#ifndef NO_GL_AMD_transform_feedback3_lines_triangles
#endif /* GL_AMD_transform_feedback3_lines_triangles */

#ifndef NO_GL_AMD_transform_feedback4
    i(GL_STREAM_RASTERIZATION_AMD)
#endif /* GL_AMD_transform_feedback4 */

#ifndef NO_GL_AMD_vertex_shader_layer
#endif /* GL_AMD_vertex_shader_layer */

#ifndef NO_GL_AMD_vertex_shader_tessellator
    i(GL_SAMPLER_BUFFER_AMD)
    i(GL_INT_SAMPLER_BUFFER_AMD)
    i(GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD)
    i(GL_TESSELLATION_MODE_AMD)
    i(GL_TESSELLATION_FACTOR_AMD)
    i(GL_DISCRETE_AMD)
    i(GL_CONTINUOUS_AMD)
#endif /* GL_AMD_vertex_shader_tessellator */

#ifndef NO_GL_AMD_vertex_shader_viewport_index
#endif /* GL_AMD_vertex_shader_viewport_index */

#ifndef NO_GL_APPLE_aux_depth_stencil
    i(GL_AUX_DEPTH_STENCIL_APPLE)
#endif /* GL_APPLE_aux_depth_stencil */

#ifndef NO_GL_APPLE_client_storage
    i(GL_UNPACK_CLIENT_STORAGE_APPLE)
#endif /* GL_APPLE_client_storage */

#ifndef NO_GL_APPLE_element_array
    i(GL_ELEMENT_ARRAY_APPLE)
    i(GL_ELEMENT_ARRAY_TYPE_APPLE)
    i(GL_ELEMENT_ARRAY_POINTER_APPLE)
#endif /* GL_APPLE_element_array */

#ifndef NO_GL_APPLE_fence
    i(GL_DRAW_PIXELS_APPLE)
    i(GL_FENCE_APPLE)
#endif /* GL_APPLE_fence */

#ifndef NO_GL_APPLE_float_pixels
    i(GL_HALF_APPLE)
    i(GL_RGBA_FLOAT32_APPLE)
    i(GL_RGB_FLOAT32_APPLE)
    i(GL_ALPHA_FLOAT32_APPLE)
    i(GL_INTENSITY_FLOAT32_APPLE)
    i(GL_LUMINANCE_FLOAT32_APPLE)
    i(GL_LUMINANCE_ALPHA_FLOAT32_APPLE)
    i(GL_RGBA_FLOAT16_APPLE)
    i(GL_RGB_FLOAT16_APPLE)
    i(GL_ALPHA_FLOAT16_APPLE)
    i(GL_INTENSITY_FLOAT16_APPLE)
    i(GL_LUMINANCE_FLOAT16_APPLE)
    i(GL_LUMINANCE_ALPHA_FLOAT16_APPLE)
    i(GL_COLOR_FLOAT_APPLE)
#endif /* GL_APPLE_float_pixels */

#ifndef NO_GL_APPLE_flush_buffer_range
    i(GL_BUFFER_SERIALIZED_MODIFY_APPLE)
    i(GL_BUFFER_FLUSHING_UNMAP_APPLE)
#endif /* GL_APPLE_flush_buffer_range */

#ifndef NO_GL_APPLE_object_purgeable
    i(GL_BUFFER_OBJECT_APPLE)
    i(GL_RELEASED_APPLE)
    i(GL_VOLATILE_APPLE)
    i(GL_RETAINED_APPLE)
    i(GL_UNDEFINED_APPLE)
    i(GL_PURGEABLE_APPLE)
#endif /* GL_APPLE_object_purgeable */

#ifndef NO_GL_APPLE_rgb_422
    i(GL_RGB_422_APPLE)
    i(GL_UNSIGNED_SHORT_8_8_APPLE)
    i(GL_UNSIGNED_SHORT_8_8_REV_APPLE)
    i(GL_RGB_RAW_422_APPLE)
#endif /* GL_APPLE_rgb_422 */

#ifndef NO_GL_APPLE_row_bytes
    i(GL_PACK_ROW_BYTES_APPLE)
    i(GL_UNPACK_ROW_BYTES_APPLE)
#endif /* GL_APPLE_row_bytes */

#ifndef NO_GL_APPLE_specular_vector
    i(GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE)
#endif /* GL_APPLE_specular_vector */

#ifndef NO_GL_APPLE_texture_range
    i(GL_TEXTURE_RANGE_LENGTH_APPLE)
    i(GL_TEXTURE_RANGE_POINTER_APPLE)
    i(GL_TEXTURE_STORAGE_HINT_APPLE)
    i(GL_STORAGE_PRIVATE_APPLE)
    i(GL_STORAGE_CACHED_APPLE)
    i(GL_STORAGE_SHARED_APPLE)
#endif /* GL_APPLE_texture_range */

#ifndef NO_GL_APPLE_transform_hint
    i(GL_TRANSFORM_HINT_APPLE)
#endif /* GL_APPLE_transform_hint */

#ifndef NO_GL_APPLE_vertex_array_object
    i(GL_VERTEX_ARRAY_BINDING_APPLE)
#endif /* GL_APPLE_vertex_array_object */

#ifndef NO_GL_APPLE_vertex_array_range
    i(GL_VERTEX_ARRAY_RANGE_APPLE)
    i(GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE)
    i(GL_VERTEX_ARRAY_STORAGE_HINT_APPLE)
    i(GL_VERTEX_ARRAY_RANGE_POINTER_APPLE)
    i(GL_STORAGE_CLIENT_APPLE)
#endif /* GL_APPLE_vertex_array_range */

#ifndef NO_GL_APPLE_vertex_program_evaluators
    i(GL_VERTEX_ATTRIB_MAP1_APPLE)
    i(GL_VERTEX_ATTRIB_MAP2_APPLE)
    i(GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE)
    i(GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE)
    i(GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE)
    i(GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE)
    i(GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE)
    i(GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE)
    i(GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE)
    i(GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE)
#endif /* GL_APPLE_vertex_program_evaluators */

#ifndef NO_GL_APPLE_ycbcr_422
    i(GL_YCBCR_422_APPLE)
#endif /* GL_APPLE_ycbcr_422 */

#ifndef NO_GL_ATI_draw_buffers
    i(GL_MAX_DRAW_BUFFERS_ATI)
    i(GL_DRAW_BUFFER0_ATI)
    i(GL_DRAW_BUFFER1_ATI)
    i(GL_DRAW_BUFFER2_ATI)
    i(GL_DRAW_BUFFER3_ATI)
    i(GL_DRAW_BUFFER4_ATI)
    i(GL_DRAW_BUFFER5_ATI)
    i(GL_DRAW_BUFFER6_ATI)
    i(GL_DRAW_BUFFER7_ATI)
    i(GL_DRAW_BUFFER8_ATI)
    i(GL_DRAW_BUFFER9_ATI)
    i(GL_DRAW_BUFFER10_ATI)
    i(GL_DRAW_BUFFER11_ATI)
    i(GL_DRAW_BUFFER12_ATI)
    i(GL_DRAW_BUFFER13_ATI)
    i(GL_DRAW_BUFFER14_ATI)
    i(GL_DRAW_BUFFER15_ATI)
#endif /* GL_ATI_draw_buffers */

#ifndef NO_GL_ATI_element_array
    i(GL_ELEMENT_ARRAY_ATI)
    i(GL_ELEMENT_ARRAY_TYPE_ATI)
    i(GL_ELEMENT_ARRAY_POINTER_ATI)
#endif /* GL_ATI_element_array */

#ifndef NO_GL_ATI_envmap_bumpmap
    i(GL_BUMP_ROT_MATRIX_ATI)
    i(GL_BUMP_ROT_MATRIX_SIZE_ATI)
    i(GL_BUMP_NUM_TEX_UNITS_ATI)
    i(GL_BUMP_TEX_UNITS_ATI)
    i(GL_DUDV_ATI)
    i(GL_DU8DV8_ATI)
    i(GL_BUMP_ENVMAP_ATI)
    i(GL_BUMP_TARGET_ATI)
#endif /* GL_ATI_envmap_bumpmap */

#ifndef NO_GL_ATI_fragment_shader
    i(GL_FRAGMENT_SHADER_ATI)
    i(GL_REG_0_ATI)
    i(GL_REG_1_ATI)
    i(GL_REG_2_ATI)
    i(GL_REG_3_ATI)
    i(GL_REG_4_ATI)
    i(GL_REG_5_ATI)
    i(GL_REG_6_ATI)
    i(GL_REG_7_ATI)
    i(GL_REG_8_ATI)
    i(GL_REG_9_ATI)
    i(GL_REG_10_ATI)
    i(GL_REG_11_ATI)
    i(GL_REG_12_ATI)
    i(GL_REG_13_ATI)
    i(GL_REG_14_ATI)
    i(GL_REG_15_ATI)
    i(GL_REG_16_ATI)
    i(GL_REG_17_ATI)
    i(GL_REG_18_ATI)
    i(GL_REG_19_ATI)
    i(GL_REG_20_ATI)
    i(GL_REG_21_ATI)
    i(GL_REG_22_ATI)
    i(GL_REG_23_ATI)
    i(GL_REG_24_ATI)
    i(GL_REG_25_ATI)
    i(GL_REG_26_ATI)
    i(GL_REG_27_ATI)
    i(GL_REG_28_ATI)
    i(GL_REG_29_ATI)
    i(GL_REG_30_ATI)
    i(GL_REG_31_ATI)
    i(GL_CON_0_ATI)
    i(GL_CON_1_ATI)
    i(GL_CON_2_ATI)
    i(GL_CON_3_ATI)
    i(GL_CON_4_ATI)
    i(GL_CON_5_ATI)
    i(GL_CON_6_ATI)
    i(GL_CON_7_ATI)
    i(GL_CON_8_ATI)
    i(GL_CON_9_ATI)
    i(GL_CON_10_ATI)
    i(GL_CON_11_ATI)
    i(GL_CON_12_ATI)
    i(GL_CON_13_ATI)
    i(GL_CON_14_ATI)
    i(GL_CON_15_ATI)
    i(GL_CON_16_ATI)
    i(GL_CON_17_ATI)
    i(GL_CON_18_ATI)
    i(GL_CON_19_ATI)
    i(GL_CON_20_ATI)
    i(GL_CON_21_ATI)
    i(GL_CON_22_ATI)
    i(GL_CON_23_ATI)
    i(GL_CON_24_ATI)
    i(GL_CON_25_ATI)
    i(GL_CON_26_ATI)
    i(GL_CON_27_ATI)
    i(GL_CON_28_ATI)
    i(GL_CON_29_ATI)
    i(GL_CON_30_ATI)
    i(GL_CON_31_ATI)
    i(GL_MOV_ATI)
    i(GL_ADD_ATI)
    i(GL_MUL_ATI)
    i(GL_SUB_ATI)
    i(GL_DOT3_ATI)
    i(GL_DOT4_ATI)
    i(GL_MAD_ATI)
    i(GL_LERP_ATI)
    i(GL_CND_ATI)
    i(GL_CND0_ATI)
    i(GL_DOT2_ADD_ATI)
    i(GL_SECONDARY_INTERPOLATOR_ATI)
    i(GL_NUM_FRAGMENT_REGISTERS_ATI)
    i(GL_NUM_FRAGMENT_CONSTANTS_ATI)
    i(GL_NUM_PASSES_ATI)
    i(GL_NUM_INSTRUCTIONS_PER_PASS_ATI)
    i(GL_NUM_INSTRUCTIONS_TOTAL_ATI)
    i(GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI)
    i(GL_NUM_LOOPBACK_COMPONENTS_ATI)
    i(GL_COLOR_ALPHA_PAIRING_ATI)
    i(GL_SWIZZLE_STR_ATI)
    i(GL_SWIZZLE_STQ_ATI)
    i(GL_SWIZZLE_STR_DR_ATI)
    i(GL_SWIZZLE_STQ_DQ_ATI)
    i(GL_SWIZZLE_STRQ_ATI)
    i(GL_SWIZZLE_STRQ_DQ_ATI)
    i(GL_RED_BIT_ATI)
    i(GL_GREEN_BIT_ATI)
    i(GL_BLUE_BIT_ATI)
    i(GL_2X_BIT_ATI)
    i(GL_4X_BIT_ATI)
    i(GL_8X_BIT_ATI)
    i(GL_HALF_BIT_ATI)
    i(GL_QUARTER_BIT_ATI)
    i(GL_EIGHTH_BIT_ATI)
    i(GL_SATURATE_BIT_ATI)
    i(GL_COMP_BIT_ATI)
    i(GL_NEGATE_BIT_ATI)
    i(GL_BIAS_BIT_ATI)
#endif /* GL_ATI_fragment_shader */

#ifndef NO_GL_ATI_map_object_buffer
#endif /* GL_ATI_map_object_buffer */

#ifndef NO_GL_ATI_meminfo
    i(GL_VBO_FREE_MEMORY_ATI)
    i(GL_TEXTURE_FREE_MEMORY_ATI)
    i(GL_RENDERBUFFER_FREE_MEMORY_ATI)
#endif /* GL_ATI_meminfo */

#ifndef NO_GL_ATI_pixel_format_float
    i(GL_RGBA_FLOAT_MODE_ATI)
    i(GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI)
#endif /* GL_ATI_pixel_format_float */

#ifndef NO_GL_ATI_pn_triangles
    i(GL_PN_TRIANGLES_ATI)
    i(GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI)
    i(GL_PN_TRIANGLES_POINT_MODE_ATI)
    i(GL_PN_TRIANGLES_NORMAL_MODE_ATI)
    i(GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI)
    i(GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI)
    i(GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI)
    i(GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI)
    i(GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI)
#endif /* GL_ATI_pn_triangles */

#ifndef NO_GL_ATI_separate_stencil
    i(GL_STENCIL_BACK_FUNC_ATI)
    i(GL_STENCIL_BACK_FAIL_ATI)
    i(GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI)
    i(GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI)
#endif /* GL_ATI_separate_stencil */

#ifndef NO_GL_ATI_text_fragment_shader
    i(GL_TEXT_FRAGMENT_SHADER_ATI)
#endif /* GL_ATI_text_fragment_shader */

#ifndef NO_GL_ATI_texture_env_combine3
    i(GL_MODULATE_ADD_ATI)
    i(GL_MODULATE_SIGNED_ADD_ATI)
    i(GL_MODULATE_SUBTRACT_ATI)
#endif /* GL_ATI_texture_env_combine3 */

#ifndef NO_GL_ATI_texture_float
    i(GL_RGBA_FLOAT32_ATI)
    i(GL_RGB_FLOAT32_ATI)
    i(GL_ALPHA_FLOAT32_ATI)
    i(GL_INTENSITY_FLOAT32_ATI)
    i(GL_LUMINANCE_FLOAT32_ATI)
    i(GL_LUMINANCE_ALPHA_FLOAT32_ATI)
    i(GL_RGBA_FLOAT16_ATI)
    i(GL_RGB_FLOAT16_ATI)
    i(GL_ALPHA_FLOAT16_ATI)
    i(GL_INTENSITY_FLOAT16_ATI)
    i(GL_LUMINANCE_FLOAT16_ATI)
    i(GL_LUMINANCE_ALPHA_FLOAT16_ATI)
#endif /* GL_ATI_texture_float */

#ifndef NO_GL_ATI_texture_mirror_once
    i(GL_MIRROR_CLAMP_ATI)
    i(GL_MIRROR_CLAMP_TO_EDGE_ATI)
#endif /* GL_ATI_texture_mirror_once */

#ifndef NO_GL_ATI_vertex_array_object
    i(GL_STATIC_ATI)
    i(GL_DYNAMIC_ATI)
    i(GL_PRESERVE_ATI)
    i(GL_DISCARD_ATI)
    i(GL_OBJECT_BUFFER_SIZE_ATI)
    i(GL_OBJECT_BUFFER_USAGE_ATI)
    i(GL_ARRAY_OBJECT_BUFFER_ATI)
    i(GL_ARRAY_OBJECT_OFFSET_ATI)
#endif /* GL_ATI_vertex_array_object */

#ifndef NO_GL_ATI_vertex_attrib_array_object
#endif /* GL_ATI_vertex_attrib_array_object */

#ifndef NO_GL_ATI_vertex_streams
    i(GL_MAX_VERTEX_STREAMS_ATI)
    i(GL_VERTEX_STREAM0_ATI)
    i(GL_VERTEX_STREAM1_ATI)
    i(GL_VERTEX_STREAM2_ATI)
    i(GL_VERTEX_STREAM3_ATI)
    i(GL_VERTEX_STREAM4_ATI)
    i(GL_VERTEX_STREAM5_ATI)
    i(GL_VERTEX_STREAM6_ATI)
    i(GL_VERTEX_STREAM7_ATI)
    i(GL_VERTEX_SOURCE_ATI)
#endif /* GL_ATI_vertex_streams */

#ifndef NO_GL_EXT_422_pixels
    i(GL_422_EXT)
    i(GL_422_REV_EXT)
    i(GL_422_AVERAGE_EXT)
    i(GL_422_REV_AVERAGE_EXT)
#endif /* GL_EXT_422_pixels */

#ifndef NO_GL_EXT_abgr
    i(GL_ABGR_EXT)
#endif /* GL_EXT_abgr */

#ifndef NO_GL_EXT_bgra
    i(GL_BGR_EXT)
    i(GL_BGRA_EXT)
#endif /* GL_EXT_bgra */

#ifndef NO_GL_EXT_bindable_uniform
    i(GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT)
    i(GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT)
    i(GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT)
    i(GL_MAX_BINDABLE_UNIFORM_SIZE_EXT)
    i(GL_UNIFORM_BUFFER_EXT)
    i(GL_UNIFORM_BUFFER_BINDING_EXT)
#endif /* GL_EXT_bindable_uniform */

#ifndef NO_GL_EXT_blend_color
    i(GL_CONSTANT_COLOR_EXT)
    i(GL_ONE_MINUS_CONSTANT_COLOR_EXT)
    i(GL_CONSTANT_ALPHA_EXT)
    i(GL_ONE_MINUS_CONSTANT_ALPHA_EXT)
    i(GL_BLEND_COLOR_EXT)
#endif /* GL_EXT_blend_color */

#ifndef NO_GL_EXT_blend_equation_separate
    i(GL_BLEND_EQUATION_RGB_EXT)
    i(GL_BLEND_EQUATION_ALPHA_EXT)
#endif /* GL_EXT_blend_equation_separate */

#ifndef NO_GL_EXT_blend_func_separate
    i(GL_BLEND_DST_RGB_EXT)
    i(GL_BLEND_SRC_RGB_EXT)
    i(GL_BLEND_DST_ALPHA_EXT)
    i(GL_BLEND_SRC_ALPHA_EXT)
#endif /* GL_EXT_blend_func_separate */

#ifndef NO_GL_EXT_blend_logic_op
#endif /* GL_EXT_blend_logic_op */

#ifndef NO_GL_EXT_blend_minmax
    i(GL_MIN_EXT)
    i(GL_MAX_EXT)
    i(GL_FUNC_ADD_EXT)
    i(GL_BLEND_EQUATION_EXT)
#endif /* GL_EXT_blend_minmax */

#ifndef NO_GL_EXT_blend_subtract
    i(GL_FUNC_SUBTRACT_EXT)
    i(GL_FUNC_REVERSE_SUBTRACT_EXT)
#endif /* GL_EXT_blend_subtract */

#ifndef NO_GL_EXT_clip_volume_hint
    i(GL_CLIP_VOLUME_CLIPPING_HINT_EXT)
#endif /* GL_EXT_clip_volume_hint */

#ifndef NO_GL_EXT_cmyka
    i(GL_CMYK_EXT)
    i(GL_CMYKA_EXT)
    i(GL_PACK_CMYK_HINT_EXT)
    i(GL_UNPACK_CMYK_HINT_EXT)
#endif /* GL_EXT_cmyka */

#ifndef NO_GL_EXT_color_subtable
#endif /* GL_EXT_color_subtable */

#ifndef NO_GL_EXT_compiled_vertex_array
    i(GL_ARRAY_ELEMENT_LOCK_FIRST_EXT)
    i(GL_ARRAY_ELEMENT_LOCK_COUNT_EXT)
#endif /* GL_EXT_compiled_vertex_array */

#ifndef NO_GL_EXT_convolution
    i(GL_CONVOLUTION_1D_EXT)
    i(GL_CONVOLUTION_2D_EXT)
    i(GL_SEPARABLE_2D_EXT)
    i(GL_CONVOLUTION_BORDER_MODE_EXT)
    i(GL_CONVOLUTION_FILTER_SCALE_EXT)
    i(GL_CONVOLUTION_FILTER_BIAS_EXT)
    i(GL_REDUCE_EXT)
    i(GL_CONVOLUTION_FORMAT_EXT)
    i(GL_CONVOLUTION_WIDTH_EXT)
    i(GL_CONVOLUTION_HEIGHT_EXT)
    i(GL_MAX_CONVOLUTION_WIDTH_EXT)
    i(GL_MAX_CONVOLUTION_HEIGHT_EXT)
    i(GL_POST_CONVOLUTION_RED_SCALE_EXT)
    i(GL_POST_CONVOLUTION_GREEN_SCALE_EXT)
    i(GL_POST_CONVOLUTION_BLUE_SCALE_EXT)
    i(GL_POST_CONVOLUTION_ALPHA_SCALE_EXT)
    i(GL_POST_CONVOLUTION_RED_BIAS_EXT)
    i(GL_POST_CONVOLUTION_GREEN_BIAS_EXT)
    i(GL_POST_CONVOLUTION_BLUE_BIAS_EXT)
    i(GL_POST_CONVOLUTION_ALPHA_BIAS_EXT)
#endif /* GL_EXT_convolution */

#ifndef NO_GL_EXT_coordinate_frame
    i(GL_TANGENT_ARRAY_EXT)
    i(GL_BINORMAL_ARRAY_EXT)
    i(GL_CURRENT_TANGENT_EXT)
    i(GL_CURRENT_BINORMAL_EXT)
    i(GL_TANGENT_ARRAY_TYPE_EXT)
    i(GL_TANGENT_ARRAY_STRIDE_EXT)
    i(GL_BINORMAL_ARRAY_TYPE_EXT)
    i(GL_BINORMAL_ARRAY_STRIDE_EXT)
    i(GL_TANGENT_ARRAY_POINTER_EXT)
    i(GL_BINORMAL_ARRAY_POINTER_EXT)
    i(GL_MAP1_TANGENT_EXT)
    i(GL_MAP2_TANGENT_EXT)
    i(GL_MAP1_BINORMAL_EXT)
    i(GL_MAP2_BINORMAL_EXT)
#endif /* GL_EXT_coordinate_frame */

#ifndef NO_GL_EXT_copy_texture
#endif /* GL_EXT_copy_texture */

#ifndef NO_GL_EXT_cull_vertex
    i(GL_CULL_VERTEX_EXT)
    i(GL_CULL_VERTEX_EYE_POSITION_EXT)
    i(GL_CULL_VERTEX_OBJECT_POSITION_EXT)
#endif /* GL_EXT_cull_vertex */

#ifndef NO_GL_EXT_debug_label
    i(GL_PROGRAM_PIPELINE_OBJECT_EXT)
    i(GL_PROGRAM_OBJECT_EXT)
    i(GL_SHADER_OBJECT_EXT)
    i(GL_BUFFER_OBJECT_EXT)
    i(GL_QUERY_OBJECT_EXT)
    i(GL_VERTEX_ARRAY_OBJECT_EXT)
#endif /* GL_EXT_debug_label */

#ifndef NO_GL_EXT_debug_marker
#endif /* GL_EXT_debug_marker */

#ifndef NO_GL_EXT_depth_bounds_test
    i(GL_DEPTH_BOUNDS_TEST_EXT)
    i(GL_DEPTH_BOUNDS_EXT)
#endif /* GL_EXT_depth_bounds_test */

#ifndef NO_GL_EXT_direct_state_access
    i(GL_PROGRAM_MATRIX_EXT)
    i(GL_TRANSPOSE_PROGRAM_MATRIX_EXT)
    i(GL_PROGRAM_MATRIX_STACK_DEPTH_EXT)
#endif /* GL_EXT_direct_state_access */

#ifndef NO_GL_EXT_draw_buffers2
#endif /* GL_EXT_draw_buffers2 */

#ifndef NO_GL_EXT_draw_instanced
#endif /* GL_EXT_draw_instanced */

#ifndef NO_GL_EXT_draw_range_elements
    i(GL_MAX_ELEMENTS_VERTICES_EXT)
    i(GL_MAX_ELEMENTS_INDICES_EXT)
#endif /* GL_EXT_draw_range_elements */

#ifndef NO_GL_EXT_fog_coord
    i(GL_FOG_COORDINATE_SOURCE_EXT)
    i(GL_FOG_COORDINATE_EXT)
    i(GL_FRAGMENT_DEPTH_EXT)
    i(GL_CURRENT_FOG_COORDINATE_EXT)
    i(GL_FOG_COORDINATE_ARRAY_TYPE_EXT)
    i(GL_FOG_COORDINATE_ARRAY_STRIDE_EXT)
    i(GL_FOG_COORDINATE_ARRAY_POINTER_EXT)
    i(GL_FOG_COORDINATE_ARRAY_EXT)
#endif /* GL_EXT_fog_coord */

#ifndef NO_GL_EXT_framebuffer_blit
    i(GL_READ_FRAMEBUFFER_EXT)
    i(GL_DRAW_FRAMEBUFFER_EXT)
    i(GL_DRAW_FRAMEBUFFER_BINDING_EXT)
    i(GL_READ_FRAMEBUFFER_BINDING_EXT)
#endif /* GL_EXT_framebuffer_blit */

#ifndef NO_GL_EXT_framebuffer_multisample
    i(GL_RENDERBUFFER_SAMPLES_EXT)
    i(GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT)
    i(GL_MAX_SAMPLES_EXT)
#endif /* GL_EXT_framebuffer_multisample */

#ifndef NO_GL_EXT_framebuffer_multisample_blit_scaled
    i(GL_SCALED_RESOLVE_FASTEST_EXT)
    i(GL_SCALED_RESOLVE_NICEST_EXT)
#endif /* GL_EXT_framebuffer_multisample_blit_scaled */

#ifndef NO_GL_EXT_framebuffer_object
    i(GL_INVALID_FRAMEBUFFER_OPERATION_EXT)
    i(GL_MAX_RENDERBUFFER_SIZE_EXT)
    i(GL_FRAMEBUFFER_BINDING_EXT)
    i(GL_RENDERBUFFER_BINDING_EXT)
    i(GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT)
    i(GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT)
    i(GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT)
    i(GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT)
    i(GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT)
    i(GL_FRAMEBUFFER_COMPLETE_EXT)
    i(GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT)
    i(GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT)
    i(GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT)
    i(GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT)
    i(GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT)
    i(GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT)
    i(GL_FRAMEBUFFER_UNSUPPORTED_EXT)
    i(GL_MAX_COLOR_ATTACHMENTS_EXT)
    i(GL_COLOR_ATTACHMENT0_EXT)
    i(GL_COLOR_ATTACHMENT1_EXT)
    i(GL_COLOR_ATTACHMENT2_EXT)
    i(GL_COLOR_ATTACHMENT3_EXT)
    i(GL_COLOR_ATTACHMENT4_EXT)
    i(GL_COLOR_ATTACHMENT5_EXT)
    i(GL_COLOR_ATTACHMENT6_EXT)
    i(GL_COLOR_ATTACHMENT7_EXT)
    i(GL_COLOR_ATTACHMENT8_EXT)
    i(GL_COLOR_ATTACHMENT9_EXT)
    i(GL_COLOR_ATTACHMENT10_EXT)
    i(GL_COLOR_ATTACHMENT11_EXT)
    i(GL_COLOR_ATTACHMENT12_EXT)
    i(GL_COLOR_ATTACHMENT13_EXT)
    i(GL_COLOR_ATTACHMENT14_EXT)
    i(GL_COLOR_ATTACHMENT15_EXT)
    i(GL_DEPTH_ATTACHMENT_EXT)
    i(GL_STENCIL_ATTACHMENT_EXT)
    i(GL_FRAMEBUFFER_EXT)
    i(GL_RENDERBUFFER_EXT)
    i(GL_RENDERBUFFER_WIDTH_EXT)
    i(GL_RENDERBUFFER_HEIGHT_EXT)
    i(GL_RENDERBUFFER_INTERNAL_FORMAT_EXT)
    i(GL_STENCIL_INDEX1_EXT)
    i(GL_STENCIL_INDEX4_EXT)
    i(GL_STENCIL_INDEX8_EXT)
    i(GL_STENCIL_INDEX16_EXT)
    i(GL_RENDERBUFFER_RED_SIZE_EXT)
    i(GL_RENDERBUFFER_GREEN_SIZE_EXT)
    i(GL_RENDERBUFFER_BLUE_SIZE_EXT)
    i(GL_RENDERBUFFER_ALPHA_SIZE_EXT)
    i(GL_RENDERBUFFER_DEPTH_SIZE_EXT)
    i(GL_RENDERBUFFER_STENCIL_SIZE_EXT)
#endif /* GL_EXT_framebuffer_object */

#ifndef NO_GL_EXT_framebuffer_sRGB
    i(GL_FRAMEBUFFER_SRGB_EXT)
    i(GL_FRAMEBUFFER_SRGB_CAPABLE_EXT)
#endif /* GL_EXT_framebuffer_sRGB */

#ifndef NO_GL_EXT_geometry_shader4
    i(GL_GEOMETRY_SHADER_EXT)
    i(GL_GEOMETRY_VERTICES_OUT_EXT)
    i(GL_GEOMETRY_INPUT_TYPE_EXT)
    i(GL_GEOMETRY_OUTPUT_TYPE_EXT)
    i(GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT)
    i(GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT)
    i(GL_MAX_VERTEX_VARYING_COMPONENTS_EXT)
    i(GL_MAX_VARYING_COMPONENTS_EXT)
    i(GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT)
    i(GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT)
    i(GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT)
    i(GL_LINES_ADJACENCY_EXT)
    i(GL_LINE_STRIP_ADJACENCY_EXT)
    i(GL_TRIANGLES_ADJACENCY_EXT)
    i(GL_TRIANGLE_STRIP_ADJACENCY_EXT)
    i(GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT)
    i(GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT)
    i(GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT)
    i(GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT)
    i(GL_PROGRAM_POINT_SIZE_EXT)
#endif /* GL_EXT_geometry_shader4 */

#ifndef NO_GL_EXT_gpu_program_parameters
#endif /* GL_EXT_gpu_program_parameters */

#ifndef NO_GL_EXT_gpu_shader4
    i(GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT)
    i(GL_SAMPLER_1D_ARRAY_EXT)
    i(GL_SAMPLER_2D_ARRAY_EXT)
    i(GL_SAMPLER_BUFFER_EXT)
    i(GL_SAMPLER_1D_ARRAY_SHADOW_EXT)
    i(GL_SAMPLER_2D_ARRAY_SHADOW_EXT)
    i(GL_SAMPLER_CUBE_SHADOW_EXT)
    i(GL_UNSIGNED_INT_VEC2_EXT)
    i(GL_UNSIGNED_INT_VEC3_EXT)
    i(GL_UNSIGNED_INT_VEC4_EXT)
    i(GL_INT_SAMPLER_1D_EXT)
    i(GL_INT_SAMPLER_2D_EXT)
    i(GL_INT_SAMPLER_3D_EXT)
    i(GL_INT_SAMPLER_CUBE_EXT)
    i(GL_INT_SAMPLER_2D_RECT_EXT)
    i(GL_INT_SAMPLER_1D_ARRAY_EXT)
    i(GL_INT_SAMPLER_2D_ARRAY_EXT)
    i(GL_INT_SAMPLER_BUFFER_EXT)
    i(GL_UNSIGNED_INT_SAMPLER_1D_EXT)
    i(GL_UNSIGNED_INT_SAMPLER_2D_EXT)
    i(GL_UNSIGNED_INT_SAMPLER_3D_EXT)
    i(GL_UNSIGNED_INT_SAMPLER_CUBE_EXT)
    i(GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT)
    i(GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT)
    i(GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT)
    i(GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT)
    i(GL_MIN_PROGRAM_TEXEL_OFFSET_EXT)
    i(GL_MAX_PROGRAM_TEXEL_OFFSET_EXT)
#endif /* GL_EXT_gpu_shader4 */

#ifndef NO_GL_EXT_histogram
    i(GL_HISTOGRAM_EXT)
    i(GL_PROXY_HISTOGRAM_EXT)
    i(GL_HISTOGRAM_WIDTH_EXT)
    i(GL_HISTOGRAM_FORMAT_EXT)
    i(GL_HISTOGRAM_RED_SIZE_EXT)
    i(GL_HISTOGRAM_GREEN_SIZE_EXT)
    i(GL_HISTOGRAM_BLUE_SIZE_EXT)
    i(GL_HISTOGRAM_ALPHA_SIZE_EXT)
    i(GL_HISTOGRAM_LUMINANCE_SIZE_EXT)
    i(GL_HISTOGRAM_SINK_EXT)
    i(GL_MINMAX_EXT)
    i(GL_MINMAX_FORMAT_EXT)
    i(GL_MINMAX_SINK_EXT)
    i(GL_TABLE_TOO_LARGE_EXT)
#endif /* GL_EXT_histogram */

#ifndef NO_GL_EXT_index_array_formats
    i(GL_IUI_V2F_EXT)
    i(GL_IUI_V3F_EXT)
    i(GL_IUI_N3F_V2F_EXT)
    i(GL_IUI_N3F_V3F_EXT)
    i(GL_T2F_IUI_V2F_EXT)
    i(GL_T2F_IUI_V3F_EXT)
    i(GL_T2F_IUI_N3F_V2F_EXT)
    i(GL_T2F_IUI_N3F_V3F_EXT)
#endif /* GL_EXT_index_array_formats */

#ifndef NO_GL_EXT_index_func
    i(GL_INDEX_TEST_EXT)
    i(GL_INDEX_TEST_FUNC_EXT)
    i(GL_INDEX_TEST_REF_EXT)
#endif /* GL_EXT_index_func */

#ifndef NO_GL_EXT_index_material
    i(GL_INDEX_MATERIAL_EXT)
    i(GL_INDEX_MATERIAL_PARAMETER_EXT)
    i(GL_INDEX_MATERIAL_FACE_EXT)
#endif /* GL_EXT_index_material */

#ifndef NO_GL_EXT_index_texture
#endif /* GL_EXT_index_texture */

#ifndef NO_GL_EXT_light_texture
    i(GL_FRAGMENT_MATERIAL_EXT)
    i(GL_FRAGMENT_NORMAL_EXT)
    i(GL_FRAGMENT_COLOR_EXT)
    i(GL_ATTENUATION_EXT)
    i(GL_SHADOW_ATTENUATION_EXT)
    i(GL_TEXTURE_APPLICATION_MODE_EXT)
    i(GL_TEXTURE_LIGHT_EXT)
    i(GL_TEXTURE_MATERIAL_FACE_EXT)
    i(GL_TEXTURE_MATERIAL_PARAMETER_EXT)
#endif /* GL_EXT_light_texture */

#ifndef NO_GL_EXT_misc_attribute
#endif /* GL_EXT_misc_attribute */

#ifndef NO_GL_EXT_multi_draw_arrays
#endif /* GL_EXT_multi_draw_arrays */

#ifndef NO_GL_EXT_multisample
    i(GL_MULTISAMPLE_EXT)
    i(GL_SAMPLE_ALPHA_TO_MASK_EXT)
    i(GL_SAMPLE_ALPHA_TO_ONE_EXT)
    i(GL_SAMPLE_MASK_EXT)
    i(GL_1PASS_EXT)
    i(GL_2PASS_0_EXT)
    i(GL_2PASS_1_EXT)
    i(GL_4PASS_0_EXT)
    i(GL_4PASS_1_EXT)
    i(GL_4PASS_2_EXT)
    i(GL_4PASS_3_EXT)
    i(GL_SAMPLE_BUFFERS_EXT)
    i(GL_SAMPLES_EXT)
    i(GL_SAMPLE_MASK_VALUE_EXT)
    i(GL_SAMPLE_MASK_INVERT_EXT)
    i(GL_SAMPLE_PATTERN_EXT)
    i(GL_MULTISAMPLE_BIT_EXT)
#endif /* GL_EXT_multisample */

#ifndef NO_GL_EXT_packed_depth_stencil
    i(GL_DEPTH_STENCIL_EXT)
    i(GL_UNSIGNED_INT_24_8_EXT)
    i(GL_DEPTH24_STENCIL8_EXT)
    i(GL_TEXTURE_STENCIL_SIZE_EXT)
#endif /* GL_EXT_packed_depth_stencil */

#ifndef NO_GL_EXT_packed_float
    i(GL_R11F_G11F_B10F_EXT)
    i(GL_UNSIGNED_INT_10F_11F_11F_REV_EXT)
    i(GL_RGBA_SIGNED_COMPONENTS_EXT)
#endif /* GL_EXT_packed_float */

#ifndef NO_GL_EXT_packed_pixels
    i(GL_UNSIGNED_BYTE_3_3_2_EXT)
    i(GL_UNSIGNED_SHORT_4_4_4_4_EXT)
    i(GL_UNSIGNED_SHORT_5_5_5_1_EXT)
    i(GL_UNSIGNED_INT_8_8_8_8_EXT)
    i(GL_UNSIGNED_INT_10_10_10_2_EXT)
#endif /* GL_EXT_packed_pixels */

#ifndef NO_GL_EXT_paletted_texture
    i(GL_COLOR_INDEX1_EXT)
    i(GL_COLOR_INDEX2_EXT)
    i(GL_COLOR_INDEX4_EXT)
    i(GL_COLOR_INDEX8_EXT)
    i(GL_COLOR_INDEX12_EXT)
    i(GL_COLOR_INDEX16_EXT)
    i(GL_TEXTURE_INDEX_SIZE_EXT)
#endif /* GL_EXT_paletted_texture */

#ifndef NO_GL_EXT_pixel_buffer_object
    i(GL_PIXEL_PACK_BUFFER_EXT)
    i(GL_PIXEL_UNPACK_BUFFER_EXT)
    i(GL_PIXEL_PACK_BUFFER_BINDING_EXT)
    i(GL_PIXEL_UNPACK_BUFFER_BINDING_EXT)
#endif /* GL_EXT_pixel_buffer_object */

#ifndef NO_GL_EXT_pixel_transform
    i(GL_PIXEL_TRANSFORM_2D_EXT)
    i(GL_PIXEL_MAG_FILTER_EXT)
    i(GL_PIXEL_MIN_FILTER_EXT)
    i(GL_PIXEL_CUBIC_WEIGHT_EXT)
    i(GL_CUBIC_EXT)
    i(GL_AVERAGE_EXT)
    i(GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT)
    i(GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT)
    i(GL_PIXEL_TRANSFORM_2D_MATRIX_EXT)
#endif /* GL_EXT_pixel_transform */

#ifndef NO_GL_EXT_pixel_transform_color_table
#endif /* GL_EXT_pixel_transform_color_table */

#ifndef NO_GL_EXT_point_parameters
    i(GL_POINT_SIZE_MIN_EXT)
    i(GL_POINT_SIZE_MAX_EXT)
    i(GL_POINT_FADE_THRESHOLD_SIZE_EXT)
    i(GL_DISTANCE_ATTENUATION_EXT)
#endif /* GL_EXT_point_parameters */

#ifndef NO_GL_EXT_polygon_offset
    i(GL_POLYGON_OFFSET_EXT)
    i(GL_POLYGON_OFFSET_FACTOR_EXT)
    i(GL_POLYGON_OFFSET_BIAS_EXT)
#endif /* GL_EXT_polygon_offset */

#ifndef NO_GL_EXT_polygon_offset_clamp
    i(GL_POLYGON_OFFSET_CLAMP_EXT)
#endif /* GL_EXT_polygon_offset_clamp */

#ifndef NO_GL_EXT_post_depth_coverage
#endif /* GL_EXT_post_depth_coverage */

#ifndef NO_GL_EXT_provoking_vertex
    i(GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT)
    i(GL_FIRST_VERTEX_CONVENTION_EXT)
    i(GL_LAST_VERTEX_CONVENTION_EXT)
    i(GL_PROVOKING_VERTEX_EXT)
#endif /* GL_EXT_provoking_vertex */

#ifndef NO_GL_EXT_raster_multisample
    i(GL_RASTER_MULTISAMPLE_EXT)
    i(GL_RASTER_SAMPLES_EXT)
    i(GL_MAX_RASTER_SAMPLES_EXT)
    i(GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT)
    i(GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT)
    i(GL_EFFECTIVE_RASTER_SAMPLES_EXT)
#endif /* GL_EXT_raster_multisample */

#ifndef NO_GL_EXT_rescale_normal
    i(GL_RESCALE_NORMAL_EXT)
#endif /* GL_EXT_rescale_normal */

#ifndef NO_GL_EXT_secondary_color
    i(GL_COLOR_SUM_EXT)
    i(GL_CURRENT_SECONDARY_COLOR_EXT)
    i(GL_SECONDARY_COLOR_ARRAY_SIZE_EXT)
    i(GL_SECONDARY_COLOR_ARRAY_TYPE_EXT)
    i(GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT)
    i(GL_SECONDARY_COLOR_ARRAY_POINTER_EXT)
    i(GL_SECONDARY_COLOR_ARRAY_EXT)
#endif /* GL_EXT_secondary_color */

#ifndef NO_GL_EXT_separate_shader_objects
    i(GL_ACTIVE_PROGRAM_EXT)
#endif /* GL_EXT_separate_shader_objects */

#ifndef NO_GL_EXT_separate_specular_color
    i(GL_LIGHT_MODEL_COLOR_CONTROL_EXT)
    i(GL_SINGLE_COLOR_EXT)
    i(GL_SEPARATE_SPECULAR_COLOR_EXT)
#endif /* GL_EXT_separate_specular_color */

#ifndef NO_GL_EXT_shader_image_load_formatted
#endif /* GL_EXT_shader_image_load_formatted */

#ifndef NO_GL_EXT_shader_image_load_store
    i(GL_MAX_IMAGE_UNITS_EXT)
    i(GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT)
    i(GL_IMAGE_BINDING_NAME_EXT)
    i(GL_IMAGE_BINDING_LEVEL_EXT)
    i(GL_IMAGE_BINDING_LAYERED_EXT)
    i(GL_IMAGE_BINDING_LAYER_EXT)
    i(GL_IMAGE_BINDING_ACCESS_EXT)
    i(GL_IMAGE_1D_EXT)
    i(GL_IMAGE_2D_EXT)
    i(GL_IMAGE_3D_EXT)
    i(GL_IMAGE_2D_RECT_EXT)
    i(GL_IMAGE_CUBE_EXT)
    i(GL_IMAGE_BUFFER_EXT)
    i(GL_IMAGE_1D_ARRAY_EXT)
    i(GL_IMAGE_2D_ARRAY_EXT)
    i(GL_IMAGE_CUBE_MAP_ARRAY_EXT)
    i(GL_IMAGE_2D_MULTISAMPLE_EXT)
    i(GL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT)
    i(GL_INT_IMAGE_1D_EXT)
    i(GL_INT_IMAGE_2D_EXT)
    i(GL_INT_IMAGE_3D_EXT)
    i(GL_INT_IMAGE_2D_RECT_EXT)
    i(GL_INT_IMAGE_CUBE_EXT)
    i(GL_INT_IMAGE_BUFFER_EXT)
    i(GL_INT_IMAGE_1D_ARRAY_EXT)
    i(GL_INT_IMAGE_2D_ARRAY_EXT)
    i(GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT)
    i(GL_INT_IMAGE_2D_MULTISAMPLE_EXT)
    i(GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT)
    i(GL_UNSIGNED_INT_IMAGE_1D_EXT)
    i(GL_UNSIGNED_INT_IMAGE_2D_EXT)
    i(GL_UNSIGNED_INT_IMAGE_3D_EXT)
    i(GL_UNSIGNED_INT_IMAGE_2D_RECT_EXT)
    i(GL_UNSIGNED_INT_IMAGE_CUBE_EXT)
    i(GL_UNSIGNED_INT_IMAGE_BUFFER_EXT)
    i(GL_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT)
    i(GL_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT)
    i(GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT)
    i(GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT)
    i(GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT)
    i(GL_MAX_IMAGE_SAMPLES_EXT)
    i(GL_IMAGE_BINDING_FORMAT_EXT)
    i(GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT_EXT)
    i(GL_ELEMENT_ARRAY_BARRIER_BIT_EXT)
    i(GL_UNIFORM_BARRIER_BIT_EXT)
    i(GL_TEXTURE_FETCH_BARRIER_BIT_EXT)
    i(GL_SHADER_IMAGE_ACCESS_BARRIER_BIT_EXT)
    i(GL_COMMAND_BARRIER_BIT_EXT)
    i(GL_PIXEL_BUFFER_BARRIER_BIT_EXT)
    i(GL_TEXTURE_UPDATE_BARRIER_BIT_EXT)
    i(GL_BUFFER_UPDATE_BARRIER_BIT_EXT)
    i(GL_FRAMEBUFFER_BARRIER_BIT_EXT)
    i(GL_TRANSFORM_FEEDBACK_BARRIER_BIT_EXT)
    i(GL_ATOMIC_COUNTER_BARRIER_BIT_EXT)
    i(GL_ALL_BARRIER_BITS_EXT)
#endif /* GL_EXT_shader_image_load_store */

#ifndef NO_GL_EXT_shader_integer_mix
#endif /* GL_EXT_shader_integer_mix */

#ifndef NO_GL_EXT_shadow_funcs
#endif /* GL_EXT_shadow_funcs */

#ifndef NO_GL_EXT_shared_texture_palette
    i(GL_SHARED_TEXTURE_PALETTE_EXT)
#endif /* GL_EXT_shared_texture_palette */

#ifndef NO_GL_EXT_sparse_texture2
#endif /* GL_EXT_sparse_texture2 */

#ifndef NO_GL_EXT_stencil_clear_tag
    i(GL_STENCIL_TAG_BITS_EXT)
    i(GL_STENCIL_CLEAR_TAG_VALUE_EXT)
#endif /* GL_EXT_stencil_clear_tag */

#ifndef NO_GL_EXT_stencil_two_side
    i(GL_STENCIL_TEST_TWO_SIDE_EXT)
    i(GL_ACTIVE_STENCIL_FACE_EXT)
#endif /* GL_EXT_stencil_two_side */

#ifndef NO_GL_EXT_stencil_wrap
    i(GL_INCR_WRAP_EXT)
    i(GL_DECR_WRAP_EXT)
#endif /* GL_EXT_stencil_wrap */

#ifndef NO_GL_EXT_subtexture
#endif /* GL_EXT_subtexture */

#ifndef NO_GL_EXT_texture
    i(GL_ALPHA4_EXT)
    i(GL_ALPHA8_EXT)
    i(GL_ALPHA12_EXT)
    i(GL_ALPHA16_EXT)
    i(GL_LUMINANCE4_EXT)
    i(GL_LUMINANCE8_EXT)
    i(GL_LUMINANCE12_EXT)
    i(GL_LUMINANCE16_EXT)
    i(GL_LUMINANCE4_ALPHA4_EXT)
    i(GL_LUMINANCE6_ALPHA2_EXT)
    i(GL_LUMINANCE8_ALPHA8_EXT)
    i(GL_LUMINANCE12_ALPHA4_EXT)
    i(GL_LUMINANCE12_ALPHA12_EXT)
    i(GL_LUMINANCE16_ALPHA16_EXT)
    i(GL_INTENSITY_EXT)
    i(GL_INTENSITY4_EXT)
    i(GL_INTENSITY8_EXT)
    i(GL_INTENSITY12_EXT)
    i(GL_INTENSITY16_EXT)
    i(GL_RGB2_EXT)
    i(GL_RGB4_EXT)
    i(GL_RGB5_EXT)
    i(GL_RGB8_EXT)
    i(GL_RGB10_EXT)
    i(GL_RGB12_EXT)
    i(GL_RGB16_EXT)
    i(GL_RGBA2_EXT)
    i(GL_RGBA4_EXT)
    i(GL_RGB5_A1_EXT)
    i(GL_RGBA8_EXT)
    i(GL_RGB10_A2_EXT)
    i(GL_RGBA12_EXT)
    i(GL_RGBA16_EXT)
    i(GL_TEXTURE_RED_SIZE_EXT)
    i(GL_TEXTURE_GREEN_SIZE_EXT)
    i(GL_TEXTURE_BLUE_SIZE_EXT)
    i(GL_TEXTURE_ALPHA_SIZE_EXT)
    i(GL_TEXTURE_LUMINANCE_SIZE_EXT)
    i(GL_TEXTURE_INTENSITY_SIZE_EXT)
    i(GL_REPLACE_EXT)
    i(GL_PROXY_TEXTURE_1D_EXT)
    i(GL_PROXY_TEXTURE_2D_EXT)
    i(GL_TEXTURE_TOO_LARGE_EXT)
#endif /* GL_EXT_texture */

#ifndef NO_GL_EXT_texture3D
    i(GL_PACK_SKIP_IMAGES_EXT)
    i(GL_PACK_IMAGE_HEIGHT_EXT)
    i(GL_UNPACK_SKIP_IMAGES_EXT)
    i(GL_UNPACK_IMAGE_HEIGHT_EXT)
    i(GL_TEXTURE_3D_EXT)
    i(GL_PROXY_TEXTURE_3D_EXT)
    i(GL_TEXTURE_DEPTH_EXT)
    i(GL_TEXTURE_WRAP_R_EXT)
    i(GL_MAX_3D_TEXTURE_SIZE_EXT)
#endif /* GL_EXT_texture3D */

#ifndef NO_GL_EXT_texture_array
    i(GL_TEXTURE_1D_ARRAY_EXT)
    i(GL_PROXY_TEXTURE_1D_ARRAY_EXT)
    i(GL_TEXTURE_2D_ARRAY_EXT)
    i(GL_PROXY_TEXTURE_2D_ARRAY_EXT)
    i(GL_TEXTURE_BINDING_1D_ARRAY_EXT)
    i(GL_TEXTURE_BINDING_2D_ARRAY_EXT)
    i(GL_MAX_ARRAY_TEXTURE_LAYERS_EXT)
    i(GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT)
#endif /* GL_EXT_texture_array */

#ifndef NO_GL_EXT_texture_buffer_object
    i(GL_TEXTURE_BUFFER_EXT)
    i(GL_MAX_TEXTURE_BUFFER_SIZE_EXT)
    i(GL_TEXTURE_BINDING_BUFFER_EXT)
    i(GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT)
    i(GL_TEXTURE_BUFFER_FORMAT_EXT)
#endif /* GL_EXT_texture_buffer_object */

#ifndef NO_GL_EXT_texture_compression_latc
    i(GL_COMPRESSED_LUMINANCE_LATC1_EXT)
    i(GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT)
    i(GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT)
    i(GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT)
#endif /* GL_EXT_texture_compression_latc */

#ifndef NO_GL_EXT_texture_compression_rgtc
    i(GL_COMPRESSED_RED_RGTC1_EXT)
    i(GL_COMPRESSED_SIGNED_RED_RGTC1_EXT)
    i(GL_COMPRESSED_RED_GREEN_RGTC2_EXT)
    i(GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT)
#endif /* GL_EXT_texture_compression_rgtc */

#ifndef NO_GL_EXT_texture_compression_s3tc
    i(GL_COMPRESSED_RGB_S3TC_DXT1_EXT)
    i(GL_COMPRESSED_RGBA_S3TC_DXT1_EXT)
    i(GL_COMPRESSED_RGBA_S3TC_DXT3_EXT)
    i(GL_COMPRESSED_RGBA_S3TC_DXT5_EXT)
#endif /* GL_EXT_texture_compression_s3tc */

#ifndef NO_GL_EXT_texture_cube_map
    i(GL_NORMAL_MAP_EXT)
    i(GL_REFLECTION_MAP_EXT)
    i(GL_TEXTURE_CUBE_MAP_EXT)
    i(GL_TEXTURE_BINDING_CUBE_MAP_EXT)
    i(GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT)
    i(GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT)
    i(GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT)
    i(GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT)
    i(GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT)
    i(GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT)
    i(GL_PROXY_TEXTURE_CUBE_MAP_EXT)
    i(GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT)
#endif /* GL_EXT_texture_cube_map */

#ifndef NO_GL_EXT_texture_env_add
#endif /* GL_EXT_texture_env_add */

#ifndef NO_GL_EXT_texture_env_combine
    i(GL_COMBINE_EXT)
    i(GL_COMBINE_RGB_EXT)
    i(GL_COMBINE_ALPHA_EXT)
    i(GL_RGB_SCALE_EXT)
    i(GL_ADD_SIGNED_EXT)
    i(GL_INTERPOLATE_EXT)
    i(GL_CONSTANT_EXT)
    i(GL_PRIMARY_COLOR_EXT)
    i(GL_PREVIOUS_EXT)
    i(GL_SOURCE0_RGB_EXT)
    i(GL_SOURCE1_RGB_EXT)
    i(GL_SOURCE2_RGB_EXT)
    i(GL_SOURCE0_ALPHA_EXT)
    i(GL_SOURCE1_ALPHA_EXT)
    i(GL_SOURCE2_ALPHA_EXT)
    i(GL_OPERAND0_RGB_EXT)
    i(GL_OPERAND1_RGB_EXT)
    i(GL_OPERAND2_RGB_EXT)
    i(GL_OPERAND0_ALPHA_EXT)
    i(GL_OPERAND1_ALPHA_EXT)
    i(GL_OPERAND2_ALPHA_EXT)
#endif /* GL_EXT_texture_env_combine */

#ifndef NO_GL_EXT_texture_env_dot3
    i(GL_DOT3_RGB_EXT)
    i(GL_DOT3_RGBA_EXT)
#endif /* GL_EXT_texture_env_dot3 */

#ifndef NO_GL_EXT_texture_filter_anisotropic
    i(GL_TEXTURE_MAX_ANISOTROPY_EXT)
    i(GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT)
#endif /* GL_EXT_texture_filter_anisotropic */

#ifndef NO_GL_EXT_texture_filter_minmax
#endif /* GL_EXT_texture_filter_minmax */

#ifndef NO_GL_EXT_texture_integer
    i(GL_RGBA32UI_EXT)
    i(GL_RGB32UI_EXT)
    i(GL_ALPHA32UI_EXT)
    i(GL_INTENSITY32UI_EXT)
    i(GL_LUMINANCE32UI_EXT)
    i(GL_LUMINANCE_ALPHA32UI_EXT)
    i(GL_RGBA16UI_EXT)
    i(GL_RGB16UI_EXT)
    i(GL_ALPHA16UI_EXT)
    i(GL_INTENSITY16UI_EXT)
    i(GL_LUMINANCE16UI_EXT)
    i(GL_LUMINANCE_ALPHA16UI_EXT)
    i(GL_RGBA8UI_EXT)
    i(GL_RGB8UI_EXT)
    i(GL_ALPHA8UI_EXT)
    i(GL_INTENSITY8UI_EXT)
    i(GL_LUMINANCE8UI_EXT)
    i(GL_LUMINANCE_ALPHA8UI_EXT)
    i(GL_RGBA32I_EXT)
    i(GL_RGB32I_EXT)
    i(GL_ALPHA32I_EXT)
    i(GL_INTENSITY32I_EXT)
    i(GL_LUMINANCE32I_EXT)
    i(GL_LUMINANCE_ALPHA32I_EXT)
    i(GL_RGBA16I_EXT)
    i(GL_RGB16I_EXT)
    i(GL_ALPHA16I_EXT)
    i(GL_INTENSITY16I_EXT)
    i(GL_LUMINANCE16I_EXT)
    i(GL_LUMINANCE_ALPHA16I_EXT)
    i(GL_RGBA8I_EXT)
    i(GL_RGB8I_EXT)
    i(GL_ALPHA8I_EXT)
    i(GL_INTENSITY8I_EXT)
    i(GL_LUMINANCE8I_EXT)
    i(GL_LUMINANCE_ALPHA8I_EXT)
    i(GL_RED_INTEGER_EXT)
    i(GL_GREEN_INTEGER_EXT)
    i(GL_BLUE_INTEGER_EXT)
    i(GL_ALPHA_INTEGER_EXT)
    i(GL_RGB_INTEGER_EXT)
    i(GL_RGBA_INTEGER_EXT)
    i(GL_BGR_INTEGER_EXT)
    i(GL_BGRA_INTEGER_EXT)
    i(GL_LUMINANCE_INTEGER_EXT)
    i(GL_LUMINANCE_ALPHA_INTEGER_EXT)
    i(GL_RGBA_INTEGER_MODE_EXT)
#endif /* GL_EXT_texture_integer */

#ifndef NO_GL_EXT_texture_lod_bias
    i(GL_MAX_TEXTURE_LOD_BIAS_EXT)
    i(GL_TEXTURE_FILTER_CONTROL_EXT)
    i(GL_TEXTURE_LOD_BIAS_EXT)
#endif /* GL_EXT_texture_lod_bias */

#ifndef NO_GL_EXT_texture_mirror_clamp
    i(GL_MIRROR_CLAMP_EXT)
    i(GL_MIRROR_CLAMP_TO_EDGE_EXT)
    i(GL_MIRROR_CLAMP_TO_BORDER_EXT)
#endif /* GL_EXT_texture_mirror_clamp */

#ifndef NO_GL_EXT_texture_object
    i(GL_TEXTURE_PRIORITY_EXT)
    i(GL_TEXTURE_RESIDENT_EXT)
    i(GL_TEXTURE_1D_BINDING_EXT)
    i(GL_TEXTURE_2D_BINDING_EXT)
    i(GL_TEXTURE_3D_BINDING_EXT)
#endif /* GL_EXT_texture_object */

#ifndef NO_GL_EXT_texture_perturb_normal
    i(GL_PERTURB_EXT)
    i(GL_TEXTURE_NORMAL_EXT)
#endif /* GL_EXT_texture_perturb_normal */

#ifndef NO_GL_EXT_texture_sRGB
    i(GL_SRGB_EXT)
    i(GL_SRGB8_EXT)
    i(GL_SRGB_ALPHA_EXT)
    i(GL_SRGB8_ALPHA8_EXT)
    i(GL_SLUMINANCE_ALPHA_EXT)
    i(GL_SLUMINANCE8_ALPHA8_EXT)
    i(GL_SLUMINANCE_EXT)
    i(GL_SLUMINANCE8_EXT)
    i(GL_COMPRESSED_SRGB_EXT)
    i(GL_COMPRESSED_SRGB_ALPHA_EXT)
    i(GL_COMPRESSED_SLUMINANCE_EXT)
    i(GL_COMPRESSED_SLUMINANCE_ALPHA_EXT)
    i(GL_COMPRESSED_SRGB_S3TC_DXT1_EXT)
    i(GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT)
    i(GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT)
    i(GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT)
#endif /* GL_EXT_texture_sRGB */

#ifndef NO_GL_EXT_texture_sRGB_decode
    i(GL_TEXTURE_SRGB_DECODE_EXT)
    i(GL_DECODE_EXT)
    i(GL_SKIP_DECODE_EXT)
#endif /* GL_EXT_texture_sRGB_decode */

#ifndef NO_GL_EXT_texture_shared_exponent
    i(GL_RGB9_E5_EXT)
    i(GL_UNSIGNED_INT_5_9_9_9_REV_EXT)
    i(GL_TEXTURE_SHARED_SIZE_EXT)
#endif /* GL_EXT_texture_shared_exponent */

#ifndef NO_GL_EXT_texture_snorm
    i(GL_ALPHA_SNORM)
    i(GL_LUMINANCE_SNORM)
    i(GL_LUMINANCE_ALPHA_SNORM)
    i(GL_INTENSITY_SNORM)
    i(GL_ALPHA8_SNORM)
    i(GL_LUMINANCE8_SNORM)
    i(GL_LUMINANCE8_ALPHA8_SNORM)
    i(GL_INTENSITY8_SNORM)
    i(GL_ALPHA16_SNORM)
    i(GL_LUMINANCE16_SNORM)
    i(GL_LUMINANCE16_ALPHA16_SNORM)
    i(GL_INTENSITY16_SNORM)
    i(GL_RED_SNORM)
    i(GL_RG_SNORM)
    i(GL_RGB_SNORM)
    i(GL_RGBA_SNORM)
#endif /* GL_EXT_texture_snorm */

#ifndef NO_GL_EXT_texture_swizzle
    i(GL_TEXTURE_SWIZZLE_R_EXT)
    i(GL_TEXTURE_SWIZZLE_G_EXT)
    i(GL_TEXTURE_SWIZZLE_B_EXT)
    i(GL_TEXTURE_SWIZZLE_A_EXT)
    i(GL_TEXTURE_SWIZZLE_RGBA_EXT)
#endif /* GL_EXT_texture_swizzle */

#ifndef NO_GL_EXT_timer_query
    i(GL_TIME_ELAPSED_EXT)
#endif /* GL_EXT_timer_query */

#ifndef NO_GL_EXT_transform_feedback
    i(GL_TRANSFORM_FEEDBACK_BUFFER_EXT)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT)
    i(GL_INTERLEAVED_ATTRIBS_EXT)
    i(GL_SEPARATE_ATTRIBS_EXT)
    i(GL_PRIMITIVES_GENERATED_EXT)
    i(GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT)
    i(GL_RASTERIZER_DISCARD_EXT)
    i(GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT)
    i(GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT)
    i(GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT)
    i(GL_TRANSFORM_FEEDBACK_VARYINGS_EXT)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT)
    i(GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT)
#endif /* GL_EXT_transform_feedback */

#ifndef NO_GL_EXT_vertex_array
    i(GL_VERTEX_ARRAY_EXT)
    i(GL_NORMAL_ARRAY_EXT)
    i(GL_COLOR_ARRAY_EXT)
    i(GL_INDEX_ARRAY_EXT)
    i(GL_TEXTURE_COORD_ARRAY_EXT)
    i(GL_EDGE_FLAG_ARRAY_EXT)
    i(GL_VERTEX_ARRAY_SIZE_EXT)
    i(GL_VERTEX_ARRAY_TYPE_EXT)
    i(GL_VERTEX_ARRAY_STRIDE_EXT)
    i(GL_VERTEX_ARRAY_COUNT_EXT)
    i(GL_NORMAL_ARRAY_TYPE_EXT)
    i(GL_NORMAL_ARRAY_STRIDE_EXT)
    i(GL_NORMAL_ARRAY_COUNT_EXT)
    i(GL_COLOR_ARRAY_SIZE_EXT)
    i(GL_COLOR_ARRAY_TYPE_EXT)
    i(GL_COLOR_ARRAY_STRIDE_EXT)
    i(GL_COLOR_ARRAY_COUNT_EXT)
    i(GL_INDEX_ARRAY_TYPE_EXT)
    i(GL_INDEX_ARRAY_STRIDE_EXT)
    i(GL_INDEX_ARRAY_COUNT_EXT)
    i(GL_TEXTURE_COORD_ARRAY_SIZE_EXT)
    i(GL_TEXTURE_COORD_ARRAY_TYPE_EXT)
    i(GL_TEXTURE_COORD_ARRAY_STRIDE_EXT)
    i(GL_TEXTURE_COORD_ARRAY_COUNT_EXT)
    i(GL_EDGE_FLAG_ARRAY_STRIDE_EXT)
    i(GL_EDGE_FLAG_ARRAY_COUNT_EXT)
    i(GL_VERTEX_ARRAY_POINTER_EXT)
    i(GL_NORMAL_ARRAY_POINTER_EXT)
    i(GL_COLOR_ARRAY_POINTER_EXT)
    i(GL_INDEX_ARRAY_POINTER_EXT)
    i(GL_TEXTURE_COORD_ARRAY_POINTER_EXT)
    i(GL_EDGE_FLAG_ARRAY_POINTER_EXT)
#endif /* GL_EXT_vertex_array */

#ifndef NO_GL_EXT_vertex_array_bgra
#endif /* GL_EXT_vertex_array_bgra */

#ifndef NO_GL_EXT_vertex_attrib_64bit
    i(GL_DOUBLE_VEC2_EXT)
    i(GL_DOUBLE_VEC3_EXT)
    i(GL_DOUBLE_VEC4_EXT)
    i(GL_DOUBLE_MAT2_EXT)
    i(GL_DOUBLE_MAT3_EXT)
    i(GL_DOUBLE_MAT4_EXT)
    i(GL_DOUBLE_MAT2x3_EXT)
    i(GL_DOUBLE_MAT2x4_EXT)
    i(GL_DOUBLE_MAT3x2_EXT)
    i(GL_DOUBLE_MAT3x4_EXT)
    i(GL_DOUBLE_MAT4x2_EXT)
    i(GL_DOUBLE_MAT4x3_EXT)
#endif /* GL_EXT_vertex_attrib_64bit */

#ifndef NO_GL_EXT_vertex_shader
    i(GL_VERTEX_SHADER_EXT)
    i(GL_VERTEX_SHADER_BINDING_EXT)
    i(GL_OP_INDEX_EXT)
    i(GL_OP_NEGATE_EXT)
    i(GL_OP_DOT3_EXT)
    i(GL_OP_DOT4_EXT)
    i(GL_OP_MUL_EXT)
    i(GL_OP_ADD_EXT)
    i(GL_OP_MADD_EXT)
    i(GL_OP_FRAC_EXT)
    i(GL_OP_MAX_EXT)
    i(GL_OP_MIN_EXT)
    i(GL_OP_SET_GE_EXT)
    i(GL_OP_SET_LT_EXT)
    i(GL_OP_CLAMP_EXT)
    i(GL_OP_FLOOR_EXT)
    i(GL_OP_ROUND_EXT)
    i(GL_OP_EXP_BASE_2_EXT)
    i(GL_OP_LOG_BASE_2_EXT)
    i(GL_OP_POWER_EXT)
    i(GL_OP_RECIP_EXT)
    i(GL_OP_RECIP_SQRT_EXT)
    i(GL_OP_SUB_EXT)
    i(GL_OP_CROSS_PRODUCT_EXT)
    i(GL_OP_MULTIPLY_MATRIX_EXT)
    i(GL_OP_MOV_EXT)
    i(GL_OUTPUT_VERTEX_EXT)
    i(GL_OUTPUT_COLOR0_EXT)
    i(GL_OUTPUT_COLOR1_EXT)
    i(GL_OUTPUT_TEXTURE_COORD0_EXT)
    i(GL_OUTPUT_TEXTURE_COORD1_EXT)
    i(GL_OUTPUT_TEXTURE_COORD2_EXT)
    i(GL_OUTPUT_TEXTURE_COORD3_EXT)
    i(GL_OUTPUT_TEXTURE_COORD4_EXT)
    i(GL_OUTPUT_TEXTURE_COORD5_EXT)
    i(GL_OUTPUT_TEXTURE_COORD6_EXT)
    i(GL_OUTPUT_TEXTURE_COORD7_EXT)
    i(GL_OUTPUT_TEXTURE_COORD8_EXT)
    i(GL_OUTPUT_TEXTURE_COORD9_EXT)
    i(GL_OUTPUT_TEXTURE_COORD10_EXT)
    i(GL_OUTPUT_TEXTURE_COORD11_EXT)
    i(GL_OUTPUT_TEXTURE_COORD12_EXT)
    i(GL_OUTPUT_TEXTURE_COORD13_EXT)
    i(GL_OUTPUT_TEXTURE_COORD14_EXT)
    i(GL_OUTPUT_TEXTURE_COORD15_EXT)
    i(GL_OUTPUT_TEXTURE_COORD16_EXT)
    i(GL_OUTPUT_TEXTURE_COORD17_EXT)
    i(GL_OUTPUT_TEXTURE_COORD18_EXT)
    i(GL_OUTPUT_TEXTURE_COORD19_EXT)
    i(GL_OUTPUT_TEXTURE_COORD20_EXT)
    i(GL_OUTPUT_TEXTURE_COORD21_EXT)
    i(GL_OUTPUT_TEXTURE_COORD22_EXT)
    i(GL_OUTPUT_TEXTURE_COORD23_EXT)
    i(GL_OUTPUT_TEXTURE_COORD24_EXT)
    i(GL_OUTPUT_TEXTURE_COORD25_EXT)
    i(GL_OUTPUT_TEXTURE_COORD26_EXT)
    i(GL_OUTPUT_TEXTURE_COORD27_EXT)
    i(GL_OUTPUT_TEXTURE_COORD28_EXT)
    i(GL_OUTPUT_TEXTURE_COORD29_EXT)
    i(GL_OUTPUT_TEXTURE_COORD30_EXT)
    i(GL_OUTPUT_TEXTURE_COORD31_EXT)
    i(GL_OUTPUT_FOG_EXT)
    i(GL_SCALAR_EXT)
    i(GL_VECTOR_EXT)
    i(GL_MATRIX_EXT)
    i(GL_VARIANT_EXT)
    i(GL_INVARIANT_EXT)
    i(GL_LOCAL_CONSTANT_EXT)
    i(GL_LOCAL_EXT)
    i(GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT)
    i(GL_MAX_VERTEX_SHADER_VARIANTS_EXT)
    i(GL_MAX_VERTEX_SHADER_INVARIANTS_EXT)
    i(GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT)
    i(GL_MAX_VERTEX_SHADER_LOCALS_EXT)
    i(GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT)
    i(GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT)
    i(GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT)
    i(GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT)
    i(GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT)
    i(GL_VERTEX_SHADER_INSTRUCTIONS_EXT)
    i(GL_VERTEX_SHADER_VARIANTS_EXT)
    i(GL_VERTEX_SHADER_INVARIANTS_EXT)
    i(GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT)
    i(GL_VERTEX_SHADER_LOCALS_EXT)
    i(GL_VERTEX_SHADER_OPTIMIZED_EXT)
    i(GL_X_EXT)
    i(GL_Y_EXT)
    i(GL_Z_EXT)
    i(GL_W_EXT)
    i(GL_NEGATIVE_X_EXT)
    i(GL_NEGATIVE_Y_EXT)
    i(GL_NEGATIVE_Z_EXT)
    i(GL_NEGATIVE_W_EXT)
    i(GL_ZERO_EXT)
    i(GL_ONE_EXT)
    i(GL_NEGATIVE_ONE_EXT)
    i(GL_NORMALIZED_RANGE_EXT)
    i(GL_FULL_RANGE_EXT)
    i(GL_CURRENT_VERTEX_EXT)
    i(GL_MVP_MATRIX_EXT)
    i(GL_VARIANT_VALUE_EXT)
    i(GL_VARIANT_DATATYPE_EXT)
    i(GL_VARIANT_ARRAY_STRIDE_EXT)
    i(GL_VARIANT_ARRAY_TYPE_EXT)
    i(GL_VARIANT_ARRAY_EXT)
    i(GL_VARIANT_ARRAY_POINTER_EXT)
    i(GL_INVARIANT_VALUE_EXT)
    i(GL_INVARIANT_DATATYPE_EXT)
    i(GL_LOCAL_CONSTANT_VALUE_EXT)
    i(GL_LOCAL_CONSTANT_DATATYPE_EXT)
#endif /* GL_EXT_vertex_shader */

#ifndef NO_GL_EXT_vertex_weighting
    i(GL_MODELVIEW0_STACK_DEPTH_EXT)
    i(GL_MODELVIEW1_STACK_DEPTH_EXT)
    i(GL_MODELVIEW0_MATRIX_EXT)
    i(GL_MODELVIEW1_MATRIX_EXT)
    i(GL_VERTEX_WEIGHTING_EXT)
    i(GL_MODELVIEW0_EXT)
    i(GL_MODELVIEW1_EXT)
    i(GL_CURRENT_VERTEX_WEIGHT_EXT)
    i(GL_VERTEX_WEIGHT_ARRAY_EXT)
    i(GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT)
    i(GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT)
    i(GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT)
    i(GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT)
#endif /* GL_EXT_vertex_weighting */

#ifndef NO_GL_EXT_window_rectangles
    i(GL_INCLUSIVE_EXT)
    i(GL_EXCLUSIVE_EXT)
    i(GL_WINDOW_RECTANGLE_EXT)
    i(GL_WINDOW_RECTANGLE_MODE_EXT)
    i(GL_MAX_WINDOW_RECTANGLES_EXT)
    i(GL_NUM_WINDOW_RECTANGLES_EXT)
#endif /* GL_EXT_window_rectangles */

#ifndef NO_GL_EXT_x11_sync_object
    i(GL_SYNC_X11_FENCE_EXT)
#endif /* GL_EXT_x11_sync_object */

#ifndef NO_GL_GREMEDY_frame_terminator
#endif /* GL_GREMEDY_frame_terminator */

#ifndef NO_GL_GREMEDY_string_marker
#endif /* GL_GREMEDY_string_marker */

#ifndef NO_GL_HP_convolution_border_modes
    i(GL_IGNORE_BORDER_HP)
    i(GL_CONSTANT_BORDER_HP)
    i(GL_REPLICATE_BORDER_HP)
    i(GL_CONVOLUTION_BORDER_COLOR_HP)
#endif /* GL_HP_convolution_border_modes */

#ifndef NO_GL_HP_image_transform
    i(GL_IMAGE_SCALE_X_HP)
    i(GL_IMAGE_SCALE_Y_HP)
    i(GL_IMAGE_TRANSLATE_X_HP)
    i(GL_IMAGE_TRANSLATE_Y_HP)
    i(GL_IMAGE_ROTATE_ANGLE_HP)
    i(GL_IMAGE_ROTATE_ORIGIN_X_HP)
    i(GL_IMAGE_ROTATE_ORIGIN_Y_HP)
    i(GL_IMAGE_MAG_FILTER_HP)
    i(GL_IMAGE_MIN_FILTER_HP)
    i(GL_IMAGE_CUBIC_WEIGHT_HP)
    i(GL_CUBIC_HP)
    i(GL_AVERAGE_HP)
    i(GL_IMAGE_TRANSFORM_2D_HP)
    i(GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP)
    i(GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP)
#endif /* GL_HP_image_transform */

#ifndef NO_GL_HP_occlusion_test
    i(GL_OCCLUSION_TEST_HP)
    i(GL_OCCLUSION_TEST_RESULT_HP)
#endif /* GL_HP_occlusion_test */

#ifndef NO_GL_HP_texture_lighting
    i(GL_TEXTURE_LIGHTING_MODE_HP)
    i(GL_TEXTURE_POST_SPECULAR_HP)
    i(GL_TEXTURE_PRE_SPECULAR_HP)
#endif /* GL_HP_texture_lighting */

#ifndef NO_GL_IBM_cull_vertex
    i(GL_CULL_VERTEX_IBM)
#endif /* GL_IBM_cull_vertex */

#ifndef NO_GL_IBM_multimode_draw_arrays
#endif /* GL_IBM_multimode_draw_arrays */

#ifndef NO_GL_IBM_rasterpos_clip
    i(GL_RASTER_POSITION_UNCLIPPED_IBM)
#endif /* GL_IBM_rasterpos_clip */

#ifndef NO_GL_IBM_static_data
    i(GL_ALL_STATIC_DATA_IBM)
    i(GL_STATIC_VERTEX_ARRAY_IBM)
#endif /* GL_IBM_static_data */

#ifndef NO_GL_IBM_texture_mirrored_repeat
    i(GL_MIRRORED_REPEAT_IBM)
#endif /* GL_IBM_texture_mirrored_repeat */

#ifndef NO_GL_IBM_vertex_array_lists
    i(GL_VERTEX_ARRAY_LIST_IBM)
    i(GL_NORMAL_ARRAY_LIST_IBM)
    i(GL_COLOR_ARRAY_LIST_IBM)
    i(GL_INDEX_ARRAY_LIST_IBM)
    i(GL_TEXTURE_COORD_ARRAY_LIST_IBM)
    i(GL_EDGE_FLAG_ARRAY_LIST_IBM)
    i(GL_FOG_COORDINATE_ARRAY_LIST_IBM)
    i(GL_SECONDARY_COLOR_ARRAY_LIST_IBM)
    i(GL_VERTEX_ARRAY_LIST_STRIDE_IBM)
    i(GL_NORMAL_ARRAY_LIST_STRIDE_IBM)
    i(GL_COLOR_ARRAY_LIST_STRIDE_IBM)
    i(GL_INDEX_ARRAY_LIST_STRIDE_IBM)
    i(GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM)
    i(GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM)
    i(GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM)
    i(GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM)
#endif /* GL_IBM_vertex_array_lists */

#ifndef NO_GL_INGR_blend_func_separate
#endif /* GL_INGR_blend_func_separate */

#ifndef NO_GL_INGR_color_clamp
    i(GL_RED_MIN_CLAMP_INGR)
    i(GL_GREEN_MIN_CLAMP_INGR)
    i(GL_BLUE_MIN_CLAMP_INGR)
    i(GL_ALPHA_MIN_CLAMP_INGR)
    i(GL_RED_MAX_CLAMP_INGR)
    i(GL_GREEN_MAX_CLAMP_INGR)
    i(GL_BLUE_MAX_CLAMP_INGR)
    i(GL_ALPHA_MAX_CLAMP_INGR)
#endif /* GL_INGR_color_clamp */

#ifndef NO_GL_INGR_interlace_read
    i(GL_INTERLACE_READ_INGR)
#endif /* GL_INGR_interlace_read */

#ifndef NO_GL_INTEL_fragment_shader_ordering
#endif /* GL_INTEL_fragment_shader_ordering */

#ifndef NO_GL_INTEL_framebuffer_CMAA
#endif /* GL_INTEL_framebuffer_CMAA */

#ifndef NO_GL_INTEL_map_texture
    i(GL_TEXTURE_MEMORY_LAYOUT_INTEL)
    i(GL_LAYOUT_DEFAULT_INTEL)
    i(GL_LAYOUT_LINEAR_INTEL)
    i(GL_LAYOUT_LINEAR_CPU_CACHED_INTEL)
#endif /* GL_INTEL_map_texture */

#ifndef NO_GL_INTEL_parallel_arrays
    i(GL_PARALLEL_ARRAYS_INTEL)
    i(GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL)
    i(GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL)
    i(GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL)
    i(GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL)
#endif /* GL_INTEL_parallel_arrays */

#ifndef NO_GL_INTEL_performance_query
    i(GL_PERFQUERY_SINGLE_CONTEXT_INTEL)
    i(GL_PERFQUERY_GLOBAL_CONTEXT_INTEL)
    i(GL_PERFQUERY_WAIT_INTEL)
    i(GL_PERFQUERY_FLUSH_INTEL)
    i(GL_PERFQUERY_DONOT_FLUSH_INTEL)
    i(GL_PERFQUERY_COUNTER_EVENT_INTEL)
    i(GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL)
    i(GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL)
    i(GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL)
    i(GL_PERFQUERY_COUNTER_RAW_INTEL)
    i(GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL)
    i(GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL)
    i(GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL)
    i(GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL)
    i(GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL)
    i(GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL)
    i(GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL)
    i(GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL)
    i(GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL)
    i(GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL)
#endif /* GL_INTEL_performance_query */

#ifndef NO_GL_MESAX_texture_stack
    i(GL_TEXTURE_1D_STACK_MESAX)
    i(GL_TEXTURE_2D_STACK_MESAX)
    i(GL_PROXY_TEXTURE_1D_STACK_MESAX)
    i(GL_PROXY_TEXTURE_2D_STACK_MESAX)
    i(GL_TEXTURE_1D_STACK_BINDING_MESAX)
    i(GL_TEXTURE_2D_STACK_BINDING_MESAX)
#endif /* GL_MESAX_texture_stack */

#ifndef NO_GL_MESA_pack_invert
    i(GL_PACK_INVERT_MESA)
#endif /* GL_MESA_pack_invert */

#ifndef NO_GL_MESA_resize_buffers
#endif /* GL_MESA_resize_buffers */

#ifndef NO_GL_MESA_window_pos
#endif /* GL_MESA_window_pos */

#ifndef NO_GL_MESA_ycbcr_texture
    i(GL_UNSIGNED_SHORT_8_8_MESA)
    i(GL_UNSIGNED_SHORT_8_8_REV_MESA)
    i(GL_YCBCR_MESA)
#endif /* GL_MESA_ycbcr_texture */

#ifndef NO_GL_NVX_conditional_render
#endif /* GL_NVX_conditional_render */

#ifndef NO_GL_NVX_gpu_memory_info
    i(GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX)
    i(GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX)
    i(GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX)
    i(GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX)
    i(GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX)
#endif /* GL_NVX_gpu_memory_info */

#ifndef NO_GL_NV_bindless_multi_draw_indirect
#endif /* GL_NV_bindless_multi_draw_indirect */

#ifndef NO_GL_NV_bindless_multi_draw_indirect_count
#endif /* GL_NV_bindless_multi_draw_indirect_count */

#ifndef NO_GL_NV_bindless_texture
#endif /* GL_NV_bindless_texture */

#ifndef NO_GL_NV_blend_equation_advanced
    i(GL_BLEND_OVERLAP_NV)
    i(GL_BLEND_PREMULTIPLIED_SRC_NV)
    i(GL_BLUE_NV)
    i(GL_COLORBURN_NV)
    i(GL_COLORDODGE_NV)
    i(GL_CONJOINT_NV)
    i(GL_CONTRAST_NV)
    i(GL_DARKEN_NV)
    i(GL_DIFFERENCE_NV)
    i(GL_DISJOINT_NV)
    i(GL_DST_ATOP_NV)
    i(GL_DST_IN_NV)
    i(GL_DST_NV)
    i(GL_DST_OUT_NV)
    i(GL_DST_OVER_NV)
    i(GL_EXCLUSION_NV)
    i(GL_GREEN_NV)
    i(GL_HARDLIGHT_NV)
    i(GL_HARDMIX_NV)
    i(GL_HSL_COLOR_NV)
    i(GL_HSL_HUE_NV)
    i(GL_HSL_LUMINOSITY_NV)
    i(GL_HSL_SATURATION_NV)
    i(GL_INVERT_OVG_NV)
    i(GL_INVERT_RGB_NV)
    i(GL_LIGHTEN_NV)
    i(GL_LINEARBURN_NV)
    i(GL_LINEARDODGE_NV)
    i(GL_LINEARLIGHT_NV)
    i(GL_MINUS_CLAMPED_NV)
    i(GL_MINUS_NV)
    i(GL_MULTIPLY_NV)
    i(GL_OVERLAY_NV)
    i(GL_PINLIGHT_NV)
    i(GL_PLUS_CLAMPED_ALPHA_NV)
    i(GL_PLUS_CLAMPED_NV)
    i(GL_PLUS_DARKER_NV)
    i(GL_PLUS_NV)
    i(GL_RED_NV)
    i(GL_SCREEN_NV)
    i(GL_SOFTLIGHT_NV)
    i(GL_SRC_ATOP_NV)
    i(GL_SRC_IN_NV)
    i(GL_SRC_NV)
    i(GL_SRC_OUT_NV)
    i(GL_SRC_OVER_NV)
    i(GL_UNCORRELATED_NV)
    i(GL_VIVIDLIGHT_NV)
    i(GL_XOR_NV)
#endif /* GL_NV_blend_equation_advanced */

#ifndef NO_GL_NV_blend_equation_advanced_coherent
    i(GL_BLEND_ADVANCED_COHERENT_NV)
#endif /* GL_NV_blend_equation_advanced_coherent */

#ifndef NO_GL_NV_blend_square
#endif /* GL_NV_blend_square */

#ifndef NO_GL_NV_clip_space_w_scaling
    i(GL_VIEWPORT_POSITION_W_SCALE_NV)
    i(GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV)
    i(GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV)
#endif /* GL_NV_clip_space_w_scaling */

#ifndef NO_GL_NV_command_list
    i(GL_TERMINATE_SEQUENCE_COMMAND_NV)
    i(GL_NOP_COMMAND_NV)
    i(GL_DRAW_ELEMENTS_COMMAND_NV)
    i(GL_DRAW_ARRAYS_COMMAND_NV)
    i(GL_DRAW_ELEMENTS_STRIP_COMMAND_NV)
    i(GL_DRAW_ARRAYS_STRIP_COMMAND_NV)
    i(GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV)
    i(GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV)
    i(GL_ELEMENT_ADDRESS_COMMAND_NV)
    i(GL_ATTRIBUTE_ADDRESS_COMMAND_NV)
    i(GL_UNIFORM_ADDRESS_COMMAND_NV)
    i(GL_BLEND_COLOR_COMMAND_NV)
    i(GL_STENCIL_REF_COMMAND_NV)
    i(GL_LINE_WIDTH_COMMAND_NV)
    i(GL_POLYGON_OFFSET_COMMAND_NV)
    i(GL_ALPHA_REF_COMMAND_NV)
    i(GL_VIEWPORT_COMMAND_NV)
    i(GL_SCISSOR_COMMAND_NV)
    i(GL_FRONT_FACE_COMMAND_NV)
#endif /* GL_NV_command_list */

#ifndef NO_GL_NV_compute_program5
    i(GL_COMPUTE_PROGRAM_NV)
    i(GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV)
#endif /* GL_NV_compute_program5 */

#ifndef NO_GL_NV_conditional_render
    i(GL_QUERY_WAIT_NV)
    i(GL_QUERY_NO_WAIT_NV)
    i(GL_QUERY_BY_REGION_WAIT_NV)
    i(GL_QUERY_BY_REGION_NO_WAIT_NV)
#endif /* GL_NV_conditional_render */

#ifndef NO_GL_NV_conservative_raster
    i(GL_CONSERVATIVE_RASTERIZATION_NV)
    i(GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV)
    i(GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV)
    i(GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV)
#endif /* GL_NV_conservative_raster */

#ifndef NO_GL_NV_conservative_raster_dilate
    i(GL_CONSERVATIVE_RASTER_DILATE_NV)
    i(GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV)
    i(GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV)
#endif /* GL_NV_conservative_raster_dilate */

#ifndef NO_GL_NV_conservative_raster_pre_snap_triangles
    i(GL_CONSERVATIVE_RASTER_MODE_NV)
    i(GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV)
    i(GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV)
#endif /* GL_NV_conservative_raster_pre_snap_triangles */

#ifndef NO_GL_NV_copy_depth_to_color
    i(GL_DEPTH_STENCIL_TO_RGBA_NV)
    i(GL_DEPTH_STENCIL_TO_BGRA_NV)
#endif /* GL_NV_copy_depth_to_color */

#ifndef NO_GL_NV_copy_image
#endif /* GL_NV_copy_image */

#ifndef NO_GL_NV_deep_texture3D
    i(GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV)
    i(GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV)
#endif /* GL_NV_deep_texture3D */

#ifndef NO_GL_NV_depth_buffer_float
    i(GL_DEPTH_COMPONENT32F_NV)
    i(GL_DEPTH32F_STENCIL8_NV)
    i(GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV)
    i(GL_DEPTH_BUFFER_FLOAT_MODE_NV)
#endif /* GL_NV_depth_buffer_float */

#ifndef NO_GL_NV_depth_clamp
    i(GL_DEPTH_CLAMP_NV)
#endif /* GL_NV_depth_clamp */

#ifndef NO_GL_NV_draw_texture
#endif /* GL_NV_draw_texture */

#ifndef NO_GL_NV_evaluators
    i(GL_EVAL_2D_NV)
    i(GL_EVAL_TRIANGULAR_2D_NV)
    i(GL_MAP_TESSELLATION_NV)
    i(GL_MAP_ATTRIB_U_ORDER_NV)
    i(GL_MAP_ATTRIB_V_ORDER_NV)
    i(GL_EVAL_FRACTIONAL_TESSELLATION_NV)
    i(GL_EVAL_VERTEX_ATTRIB0_NV)
    i(GL_EVAL_VERTEX_ATTRIB1_NV)
    i(GL_EVAL_VERTEX_ATTRIB2_NV)
    i(GL_EVAL_VERTEX_ATTRIB3_NV)
    i(GL_EVAL_VERTEX_ATTRIB4_NV)
    i(GL_EVAL_VERTEX_ATTRIB5_NV)
    i(GL_EVAL_VERTEX_ATTRIB6_NV)
    i(GL_EVAL_VERTEX_ATTRIB7_NV)
    i(GL_EVAL_VERTEX_ATTRIB8_NV)
    i(GL_EVAL_VERTEX_ATTRIB9_NV)
    i(GL_EVAL_VERTEX_ATTRIB10_NV)
    i(GL_EVAL_VERTEX_ATTRIB11_NV)
    i(GL_EVAL_VERTEX_ATTRIB12_NV)
    i(GL_EVAL_VERTEX_ATTRIB13_NV)
    i(GL_EVAL_VERTEX_ATTRIB14_NV)
    i(GL_EVAL_VERTEX_ATTRIB15_NV)
    i(GL_MAX_MAP_TESSELLATION_NV)
    i(GL_MAX_RATIONAL_EVAL_ORDER_NV)
#endif /* GL_NV_evaluators */

#ifndef NO_GL_NV_explicit_multisample
    i(GL_SAMPLE_POSITION_NV)
    i(GL_SAMPLE_MASK_NV)
    i(GL_SAMPLE_MASK_VALUE_NV)
    i(GL_TEXTURE_BINDING_RENDERBUFFER_NV)
    i(GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV)
    i(GL_TEXTURE_RENDERBUFFER_NV)
    i(GL_SAMPLER_RENDERBUFFER_NV)
    i(GL_INT_SAMPLER_RENDERBUFFER_NV)
    i(GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV)
    i(GL_MAX_SAMPLE_MASK_WORDS_NV)
#endif /* GL_NV_explicit_multisample */

#ifndef NO_GL_NV_fence
    i(GL_ALL_COMPLETED_NV)
    i(GL_FENCE_STATUS_NV)
    i(GL_FENCE_CONDITION_NV)
#endif /* GL_NV_fence */

#ifndef NO_GL_NV_fill_rectangle
    i(GL_FILL_RECTANGLE_NV)
#endif /* GL_NV_fill_rectangle */

#ifndef NO_GL_NV_float_buffer
    i(GL_FLOAT_R_NV)
    i(GL_FLOAT_RG_NV)
    i(GL_FLOAT_RGB_NV)
    i(GL_FLOAT_RGBA_NV)
    i(GL_FLOAT_R16_NV)
    i(GL_FLOAT_R32_NV)
    i(GL_FLOAT_RG16_NV)
    i(GL_FLOAT_RG32_NV)
    i(GL_FLOAT_RGB16_NV)
    i(GL_FLOAT_RGB32_NV)
    i(GL_FLOAT_RGBA16_NV)
    i(GL_FLOAT_RGBA32_NV)
    i(GL_TEXTURE_FLOAT_COMPONENTS_NV)
    i(GL_FLOAT_CLEAR_COLOR_VALUE_NV)
    i(GL_FLOAT_RGBA_MODE_NV)
#endif /* GL_NV_float_buffer */

#ifndef NO_GL_NV_fog_distance
    i(GL_FOG_DISTANCE_MODE_NV)
    i(GL_EYE_RADIAL_NV)
    i(GL_EYE_PLANE_ABSOLUTE_NV)
#endif /* GL_NV_fog_distance */

#ifndef NO_GL_NV_fragment_coverage_to_color
    i(GL_FRAGMENT_COVERAGE_TO_COLOR_NV)
    i(GL_FRAGMENT_COVERAGE_COLOR_NV)
#endif /* GL_NV_fragment_coverage_to_color */

#ifndef NO_GL_NV_fragment_program
    i(GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV)
    i(GL_FRAGMENT_PROGRAM_NV)
    i(GL_MAX_TEXTURE_COORDS_NV)
    i(GL_MAX_TEXTURE_IMAGE_UNITS_NV)
    i(GL_FRAGMENT_PROGRAM_BINDING_NV)
    i(GL_PROGRAM_ERROR_STRING_NV)
#endif /* GL_NV_fragment_program */

#ifndef NO_GL_NV_fragment_program2
    i(GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV)
    i(GL_MAX_PROGRAM_CALL_DEPTH_NV)
    i(GL_MAX_PROGRAM_IF_DEPTH_NV)
    i(GL_MAX_PROGRAM_LOOP_DEPTH_NV)
    i(GL_MAX_PROGRAM_LOOP_COUNT_NV)
#endif /* GL_NV_fragment_program2 */

#ifndef NO_GL_NV_fragment_program4
#endif /* GL_NV_fragment_program4 */

#ifndef NO_GL_NV_fragment_program_option
#endif /* GL_NV_fragment_program_option */

#ifndef NO_GL_NV_fragment_shader_interlock
#endif /* GL_NV_fragment_shader_interlock */

#ifndef NO_GL_NV_framebuffer_mixed_samples
    i(GL_COVERAGE_MODULATION_TABLE_NV)
    i(GL_COLOR_SAMPLES_NV)
    i(GL_DEPTH_SAMPLES_NV)
    i(GL_STENCIL_SAMPLES_NV)
    i(GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV)
    i(GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV)
    i(GL_COVERAGE_MODULATION_NV)
    i(GL_COVERAGE_MODULATION_TABLE_SIZE_NV)
#endif /* GL_NV_framebuffer_mixed_samples */

#ifndef NO_GL_NV_framebuffer_multisample_coverage
    i(GL_RENDERBUFFER_COVERAGE_SAMPLES_NV)
    i(GL_RENDERBUFFER_COLOR_SAMPLES_NV)
    i(GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV)
    i(GL_MULTISAMPLE_COVERAGE_MODES_NV)
#endif /* GL_NV_framebuffer_multisample_coverage */

#ifndef NO_GL_NV_geometry_program4
    i(GL_GEOMETRY_PROGRAM_NV)
    i(GL_MAX_PROGRAM_OUTPUT_VERTICES_NV)
    i(GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV)
#endif /* GL_NV_geometry_program4 */

#ifndef NO_GL_NV_geometry_shader4
#endif /* GL_NV_geometry_shader4 */

#ifndef NO_GL_NV_geometry_shader_passthrough
#endif /* GL_NV_geometry_shader_passthrough */

#ifndef NO_GL_NV_gpu_program4
    i(GL_MIN_PROGRAM_TEXEL_OFFSET_NV)
    i(GL_MAX_PROGRAM_TEXEL_OFFSET_NV)
    i(GL_PROGRAM_ATTRIB_COMPONENTS_NV)
    i(GL_PROGRAM_RESULT_COMPONENTS_NV)
    i(GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV)
    i(GL_MAX_PROGRAM_RESULT_COMPONENTS_NV)
    i(GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV)
    i(GL_MAX_PROGRAM_GENERIC_RESULTS_NV)
#endif /* GL_NV_gpu_program4 */

#ifndef NO_GL_NV_gpu_program5
    i(GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV)
    i(GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV)
    i(GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV)
    i(GL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV)
    i(GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV)
    i(GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV)
    i(GL_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV)
    i(GL_MAX_PROGRAM_SUBROUTINE_NUM_NV)
#endif /* GL_NV_gpu_program5 */

#ifndef NO_GL_NV_gpu_program5_mem_extended
#endif /* GL_NV_gpu_program5_mem_extended */

#ifndef NO_GL_NV_gpu_shader5
#endif /* GL_NV_gpu_shader5 */

#ifndef NO_GL_NV_half_float
    i(GL_HALF_FLOAT_NV)
#endif /* GL_NV_half_float */

#ifndef NO_GL_NV_internalformat_sample_query
    i(GL_MULTISAMPLES_NV)
    i(GL_SUPERSAMPLE_SCALE_X_NV)
    i(GL_SUPERSAMPLE_SCALE_Y_NV)
    i(GL_CONFORMANT_NV)
#endif /* GL_NV_internalformat_sample_query */

#ifndef NO_GL_NV_light_max_exponent
    i(GL_MAX_SHININESS_NV)
    i(GL_MAX_SPOT_EXPONENT_NV)
#endif /* GL_NV_light_max_exponent */

#ifndef NO_GL_NV_multisample_coverage
#endif /* GL_NV_multisample_coverage */

#ifndef NO_GL_NV_multisample_filter_hint
    i(GL_MULTISAMPLE_FILTER_HINT_NV)
#endif /* GL_NV_multisample_filter_hint */

#ifndef NO_GL_NV_occlusion_query
    i(GL_PIXEL_COUNTER_BITS_NV)
    i(GL_CURRENT_OCCLUSION_QUERY_ID_NV)
    i(GL_PIXEL_COUNT_NV)
    i(GL_PIXEL_COUNT_AVAILABLE_NV)
#endif /* GL_NV_occlusion_query */

#ifndef NO_GL_NV_packed_depth_stencil
    i(GL_DEPTH_STENCIL_NV)
    i(GL_UNSIGNED_INT_24_8_NV)
#endif /* GL_NV_packed_depth_stencil */

#ifndef NO_GL_NV_parameter_buffer_object
    i(GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV)
    i(GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV)
    i(GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV)
    i(GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV)
    i(GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV)
#endif /* GL_NV_parameter_buffer_object */

#ifndef NO_GL_NV_parameter_buffer_object2
#endif /* GL_NV_parameter_buffer_object2 */

#ifndef NO_GL_NV_path_rendering
    i(GL_PATH_FORMAT_SVG_NV)
    i(GL_PATH_FORMAT_PS_NV)
    i(GL_STANDARD_FONT_NAME_NV)
    i(GL_SYSTEM_FONT_NAME_NV)
    i(GL_FILE_NAME_NV)
    i(GL_PATH_STROKE_WIDTH_NV)
    i(GL_PATH_END_CAPS_NV)
    i(GL_PATH_INITIAL_END_CAP_NV)
    i(GL_PATH_TERMINAL_END_CAP_NV)
    i(GL_PATH_JOIN_STYLE_NV)
    i(GL_PATH_MITER_LIMIT_NV)
    i(GL_PATH_DASH_CAPS_NV)
    i(GL_PATH_INITIAL_DASH_CAP_NV)
    i(GL_PATH_TERMINAL_DASH_CAP_NV)
    i(GL_PATH_DASH_OFFSET_NV)
    i(GL_PATH_CLIENT_LENGTH_NV)
    i(GL_PATH_FILL_MODE_NV)
    i(GL_PATH_FILL_MASK_NV)
    i(GL_PATH_FILL_COVER_MODE_NV)
    i(GL_PATH_STROKE_COVER_MODE_NV)
    i(GL_PATH_STROKE_MASK_NV)
    i(GL_COUNT_UP_NV)
    i(GL_COUNT_DOWN_NV)
    i(GL_PATH_OBJECT_BOUNDING_BOX_NV)
    i(GL_CONVEX_HULL_NV)
    i(GL_BOUNDING_BOX_NV)
    i(GL_TRANSLATE_X_NV)
    i(GL_TRANSLATE_Y_NV)
    i(GL_TRANSLATE_2D_NV)
    i(GL_TRANSLATE_3D_NV)
    i(GL_AFFINE_2D_NV)
    i(GL_AFFINE_3D_NV)
    i(GL_TRANSPOSE_AFFINE_2D_NV)
    i(GL_TRANSPOSE_AFFINE_3D_NV)
    i(GL_UTF8_NV)
    i(GL_UTF16_NV)
    i(GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV)
    i(GL_PATH_COMMAND_COUNT_NV)
    i(GL_PATH_COORD_COUNT_NV)
    i(GL_PATH_DASH_ARRAY_COUNT_NV)
    i(GL_PATH_COMPUTED_LENGTH_NV)
    i(GL_PATH_FILL_BOUNDING_BOX_NV)
    i(GL_PATH_STROKE_BOUNDING_BOX_NV)
    i(GL_SQUARE_NV)
    i(GL_ROUND_NV)
    i(GL_TRIANGULAR_NV)
    i(GL_BEVEL_NV)
    i(GL_MITER_REVERT_NV)
    i(GL_MITER_TRUNCATE_NV)
    i(GL_SKIP_MISSING_GLYPH_NV)
    i(GL_USE_MISSING_GLYPH_NV)
    i(GL_PATH_ERROR_POSITION_NV)
    i(GL_ACCUM_ADJACENT_PAIRS_NV)
    i(GL_ADJACENT_PAIRS_NV)
    i(GL_FIRST_TO_REST_NV)
    i(GL_PATH_GEN_MODE_NV)
    i(GL_PATH_GEN_COEFF_NV)
    i(GL_PATH_GEN_COMPONENTS_NV)
    i(GL_PATH_STENCIL_FUNC_NV)
    i(GL_PATH_STENCIL_REF_NV)
    i(GL_PATH_STENCIL_VALUE_MASK_NV)
    i(GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV)
    i(GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV)
    i(GL_PATH_COVER_DEPTH_FUNC_NV)
    i(GL_PATH_DASH_OFFSET_RESET_NV)
    i(GL_MOVE_TO_RESETS_NV)
    i(GL_MOVE_TO_CONTINUES_NV)
    i(GL_CLOSE_PATH_NV)
    i(GL_MOVE_TO_NV)
    i(GL_RELATIVE_MOVE_TO_NV)
    i(GL_LINE_TO_NV)
    i(GL_RELATIVE_LINE_TO_NV)
    i(GL_HORIZONTAL_LINE_TO_NV)
    i(GL_RELATIVE_HORIZONTAL_LINE_TO_NV)
    i(GL_VERTICAL_LINE_TO_NV)
    i(GL_RELATIVE_VERTICAL_LINE_TO_NV)
    i(GL_QUADRATIC_CURVE_TO_NV)
    i(GL_RELATIVE_QUADRATIC_CURVE_TO_NV)
    i(GL_CUBIC_CURVE_TO_NV)
    i(GL_RELATIVE_CUBIC_CURVE_TO_NV)
    i(GL_SMOOTH_QUADRATIC_CURVE_TO_NV)
    i(GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV)
    i(GL_SMOOTH_CUBIC_CURVE_TO_NV)
    i(GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV)
    i(GL_SMALL_CCW_ARC_TO_NV)
    i(GL_RELATIVE_SMALL_CCW_ARC_TO_NV)
    i(GL_SMALL_CW_ARC_TO_NV)
    i(GL_RELATIVE_SMALL_CW_ARC_TO_NV)
    i(GL_LARGE_CCW_ARC_TO_NV)
    i(GL_RELATIVE_LARGE_CCW_ARC_TO_NV)
    i(GL_LARGE_CW_ARC_TO_NV)
    i(GL_RELATIVE_LARGE_CW_ARC_TO_NV)
    i(GL_RESTART_PATH_NV)
    i(GL_DUP_FIRST_CUBIC_CURVE_TO_NV)
    i(GL_DUP_LAST_CUBIC_CURVE_TO_NV)
    i(GL_RECT_NV)
    i(GL_CIRCULAR_CCW_ARC_TO_NV)
    i(GL_CIRCULAR_CW_ARC_TO_NV)
    i(GL_CIRCULAR_TANGENT_ARC_TO_NV)
    i(GL_ARC_TO_NV)
    i(GL_RELATIVE_ARC_TO_NV)
    i(GL_BOLD_BIT_NV)
    i(GL_ITALIC_BIT_NV)
    i(GL_GLYPH_WIDTH_BIT_NV)
    i(GL_GLYPH_HEIGHT_BIT_NV)
    i(GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV)
    i(GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV)
    i(GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV)
    i(GL_GLYPH_VERTICAL_BEARING_X_BIT_NV)
    i(GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV)
    i(GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV)
    i(GL_GLYPH_HAS_KERNING_BIT_NV)
    i(GL_FONT_X_MIN_BOUNDS_BIT_NV)
    i(GL_FONT_Y_MIN_BOUNDS_BIT_NV)
    i(GL_FONT_X_MAX_BOUNDS_BIT_NV)
    i(GL_FONT_Y_MAX_BOUNDS_BIT_NV)
    i(GL_FONT_UNITS_PER_EM_BIT_NV)
    i(GL_FONT_ASCENDER_BIT_NV)
    i(GL_FONT_DESCENDER_BIT_NV)
    i(GL_FONT_HEIGHT_BIT_NV)
    i(GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV)
    i(GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV)
    i(GL_FONT_UNDERLINE_POSITION_BIT_NV)
    i(GL_FONT_UNDERLINE_THICKNESS_BIT_NV)
    i(GL_FONT_HAS_KERNING_BIT_NV)
    i(GL_ROUNDED_RECT_NV)
    i(GL_RELATIVE_ROUNDED_RECT_NV)
    i(GL_ROUNDED_RECT2_NV)
    i(GL_RELATIVE_ROUNDED_RECT2_NV)
    i(GL_ROUNDED_RECT4_NV)
    i(GL_RELATIVE_ROUNDED_RECT4_NV)
    i(GL_ROUNDED_RECT8_NV)
    i(GL_RELATIVE_ROUNDED_RECT8_NV)
    i(GL_RELATIVE_RECT_NV)
    i(GL_FONT_GLYPHS_AVAILABLE_NV)
    i(GL_FONT_TARGET_UNAVAILABLE_NV)
    i(GL_FONT_UNAVAILABLE_NV)
    i(GL_FONT_UNINTELLIGIBLE_NV)
    i(GL_CONIC_CURVE_TO_NV)
    i(GL_RELATIVE_CONIC_CURVE_TO_NV)
    i(GL_FONT_NUM_GLYPH_INDICES_BIT_NV)
    i(GL_STANDARD_FONT_FORMAT_NV)
    i(GL_2_BYTES_NV)
    i(GL_3_BYTES_NV)
    i(GL_4_BYTES_NV)
    i(GL_EYE_LINEAR_NV)
    i(GL_OBJECT_LINEAR_NV)
    i(GL_CONSTANT_NV)
    i(GL_PATH_FOG_GEN_MODE_NV)
    i(GL_PRIMARY_COLOR_NV)
    i(GL_SECONDARY_COLOR_NV)
    i(GL_PATH_GEN_COLOR_FORMAT_NV)
    i(GL_PATH_PROJECTION_NV)
    i(GL_PATH_MODELVIEW_NV)
    i(GL_PATH_MODELVIEW_STACK_DEPTH_NV)
    i(GL_PATH_MODELVIEW_MATRIX_NV)
    i(GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV)
    i(GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV)
    i(GL_PATH_PROJECTION_STACK_DEPTH_NV)
    i(GL_PATH_PROJECTION_MATRIX_NV)
    i(GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV)
    i(GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV)
    i(GL_FRAGMENT_INPUT_NV)
#endif /* GL_NV_path_rendering */

#ifndef NO_GL_NV_path_rendering_shared_edge
    i(GL_SHARED_EDGE_NV)
#endif /* GL_NV_path_rendering_shared_edge */

#ifndef NO_GL_NV_pixel_data_range
    i(GL_WRITE_PIXEL_DATA_RANGE_NV)
    i(GL_READ_PIXEL_DATA_RANGE_NV)
    i(GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV)
    i(GL_READ_PIXEL_DATA_RANGE_LENGTH_NV)
    i(GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV)
    i(GL_READ_PIXEL_DATA_RANGE_POINTER_NV)
#endif /* GL_NV_pixel_data_range */

#ifndef NO_GL_NV_point_sprite
    i(GL_POINT_SPRITE_NV)
    i(GL_COORD_REPLACE_NV)
    i(GL_POINT_SPRITE_R_MODE_NV)
#endif /* GL_NV_point_sprite */

#ifndef NO_GL_NV_present_video
    i(GL_FRAME_NV)
    i(GL_FIELDS_NV)
    i(GL_CURRENT_TIME_NV)
    i(GL_NUM_FILL_STREAMS_NV)
    i(GL_PRESENT_TIME_NV)
    i(GL_PRESENT_DURATION_NV)
#endif /* GL_NV_present_video */

#ifndef NO_GL_NV_primitive_restart
    i(GL_PRIMITIVE_RESTART_NV)
    i(GL_PRIMITIVE_RESTART_INDEX_NV)
#endif /* GL_NV_primitive_restart */

#ifndef NO_GL_NV_register_combiners
    i(GL_REGISTER_COMBINERS_NV)
    i(GL_VARIABLE_A_NV)
    i(GL_VARIABLE_B_NV)
    i(GL_VARIABLE_C_NV)
    i(GL_VARIABLE_D_NV)
    i(GL_VARIABLE_E_NV)
    i(GL_VARIABLE_F_NV)
    i(GL_VARIABLE_G_NV)
    i(GL_CONSTANT_COLOR0_NV)
    i(GL_CONSTANT_COLOR1_NV)
    i(GL_SPARE0_NV)
    i(GL_SPARE1_NV)
    i(GL_DISCARD_NV)
    i(GL_E_TIMES_F_NV)
    i(GL_SPARE0_PLUS_SECONDARY_COLOR_NV)
    i(GL_UNSIGNED_IDENTITY_NV)
    i(GL_UNSIGNED_INVERT_NV)
    i(GL_EXPAND_NORMAL_NV)
    i(GL_EXPAND_NEGATE_NV)
    i(GL_HALF_BIAS_NORMAL_NV)
    i(GL_HALF_BIAS_NEGATE_NV)
    i(GL_SIGNED_IDENTITY_NV)
    i(GL_SIGNED_NEGATE_NV)
    i(GL_SCALE_BY_TWO_NV)
    i(GL_SCALE_BY_FOUR_NV)
    i(GL_SCALE_BY_ONE_HALF_NV)
    i(GL_BIAS_BY_NEGATIVE_ONE_HALF_NV)
    i(GL_COMBINER_INPUT_NV)
    i(GL_COMBINER_MAPPING_NV)
    i(GL_COMBINER_COMPONENT_USAGE_NV)
    i(GL_COMBINER_AB_DOT_PRODUCT_NV)
    i(GL_COMBINER_CD_DOT_PRODUCT_NV)
    i(GL_COMBINER_MUX_SUM_NV)
    i(GL_COMBINER_SCALE_NV)
    i(GL_COMBINER_BIAS_NV)
    i(GL_COMBINER_AB_OUTPUT_NV)
    i(GL_COMBINER_CD_OUTPUT_NV)
    i(GL_COMBINER_SUM_OUTPUT_NV)
    i(GL_MAX_GENERAL_COMBINERS_NV)
    i(GL_NUM_GENERAL_COMBINERS_NV)
    i(GL_COLOR_SUM_CLAMP_NV)
    i(GL_COMBINER0_NV)
    i(GL_COMBINER1_NV)
    i(GL_COMBINER2_NV)
    i(GL_COMBINER3_NV)
    i(GL_COMBINER4_NV)
    i(GL_COMBINER5_NV)
    i(GL_COMBINER6_NV)
    i(GL_COMBINER7_NV)
#endif /* GL_NV_register_combiners */

#ifndef NO_GL_NV_register_combiners2
    i(GL_PER_STAGE_CONSTANTS_NV)
#endif /* GL_NV_register_combiners2 */

#ifndef NO_GL_NV_robustness_video_memory_purge
    i(GL_PURGED_CONTEXT_RESET_NV)
#endif /* GL_NV_robustness_video_memory_purge */

#ifndef NO_GL_NV_sample_locations
    i(GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV)
    i(GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV)
    i(GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV)
    i(GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV)
    i(GL_SAMPLE_LOCATION_NV)
    i(GL_PROGRAMMABLE_SAMPLE_LOCATION_NV)
    i(GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV)
    i(GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV)
#endif /* GL_NV_sample_locations */

#ifndef NO_GL_NV_sample_mask_override_coverage
#endif /* GL_NV_sample_mask_override_coverage */

#ifndef NO_GL_NV_shader_atomic_counters
#endif /* GL_NV_shader_atomic_counters */

#ifndef NO_GL_NV_shader_atomic_float
#endif /* GL_NV_shader_atomic_float */

#ifndef NO_GL_NV_shader_atomic_float64
#endif /* GL_NV_shader_atomic_float64 */

#ifndef NO_GL_NV_shader_atomic_fp16_vector
#endif /* GL_NV_shader_atomic_fp16_vector */

#ifndef NO_GL_NV_shader_atomic_int64
#endif /* GL_NV_shader_atomic_int64 */

#ifndef NO_GL_NV_shader_buffer_load
    i(GL_BUFFER_GPU_ADDRESS_NV)
    i(GL_GPU_ADDRESS_NV)
    i(GL_MAX_SHADER_BUFFER_ADDRESS_NV)
#endif /* GL_NV_shader_buffer_load */

#ifndef NO_GL_NV_shader_buffer_store
    i(GL_SHADER_GLOBAL_ACCESS_BARRIER_BIT_NV)
#endif /* GL_NV_shader_buffer_store */

#ifndef NO_GL_NV_shader_storage_buffer_object
#endif /* GL_NV_shader_storage_buffer_object */

#ifndef NO_GL_NV_shader_thread_group
    i(GL_WARP_SIZE_NV)
    i(GL_WARPS_PER_SM_NV)
    i(GL_SM_COUNT_NV)
#endif /* GL_NV_shader_thread_group */

#ifndef NO_GL_NV_shader_thread_shuffle
#endif /* GL_NV_shader_thread_shuffle */

#ifndef NO_GL_NV_stereo_view_rendering
#endif /* GL_NV_stereo_view_rendering */

#ifndef NO_GL_NV_tessellation_program5
    i(GL_MAX_PROGRAM_PATCH_ATTRIBS_NV)
    i(GL_TESS_CONTROL_PROGRAM_NV)
    i(GL_TESS_EVALUATION_PROGRAM_NV)
    i(GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV)
    i(GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV)
#endif /* GL_NV_tessellation_program5 */

#ifndef NO_GL_NV_texgen_emboss
    i(GL_EMBOSS_LIGHT_NV)
    i(GL_EMBOSS_CONSTANT_NV)
    i(GL_EMBOSS_MAP_NV)
#endif /* GL_NV_texgen_emboss */

#ifndef NO_GL_NV_texgen_reflection
    i(GL_NORMAL_MAP_NV)
    i(GL_REFLECTION_MAP_NV)
#endif /* GL_NV_texgen_reflection */

#ifndef NO_GL_NV_texture_barrier
#endif /* GL_NV_texture_barrier */

#ifndef NO_GL_NV_texture_compression_vtc
#endif /* GL_NV_texture_compression_vtc */

#ifndef NO_GL_NV_texture_env_combine4
    i(GL_COMBINE4_NV)
    i(GL_SOURCE3_RGB_NV)
    i(GL_SOURCE3_ALPHA_NV)
    i(GL_OPERAND3_RGB_NV)
    i(GL_OPERAND3_ALPHA_NV)
#endif /* GL_NV_texture_env_combine4 */

#ifndef NO_GL_NV_texture_expand_normal
    i(GL_TEXTURE_UNSIGNED_REMAP_MODE_NV)
#endif /* GL_NV_texture_expand_normal */

#ifndef NO_GL_NV_texture_multisample
    i(GL_TEXTURE_COVERAGE_SAMPLES_NV)
    i(GL_TEXTURE_COLOR_SAMPLES_NV)
#endif /* GL_NV_texture_multisample */

#ifndef NO_GL_NV_texture_rectangle
    i(GL_TEXTURE_RECTANGLE_NV)
    i(GL_TEXTURE_BINDING_RECTANGLE_NV)
    i(GL_PROXY_TEXTURE_RECTANGLE_NV)
    i(GL_MAX_RECTANGLE_TEXTURE_SIZE_NV)
#endif /* GL_NV_texture_rectangle */

#ifndef NO_GL_NV_texture_shader
    i(GL_OFFSET_TEXTURE_RECTANGLE_NV)
    i(GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV)
    i(GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV)
    i(GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV)
    i(GL_UNSIGNED_INT_S8_S8_8_8_NV)
    i(GL_UNSIGNED_INT_8_8_S8_S8_REV_NV)
    i(GL_DSDT_MAG_INTENSITY_NV)
    i(GL_SHADER_CONSISTENT_NV)
    i(GL_TEXTURE_SHADER_NV)
    i(GL_SHADER_OPERATION_NV)
    i(GL_CULL_MODES_NV)
    i(GL_OFFSET_TEXTURE_MATRIX_NV)
    i(GL_OFFSET_TEXTURE_SCALE_NV)
    i(GL_OFFSET_TEXTURE_BIAS_NV)
    i(GL_OFFSET_TEXTURE_2D_MATRIX_NV)
    i(GL_OFFSET_TEXTURE_2D_SCALE_NV)
    i(GL_OFFSET_TEXTURE_2D_BIAS_NV)
    i(GL_PREVIOUS_TEXTURE_INPUT_NV)
    i(GL_CONST_EYE_NV)
    i(GL_PASS_THROUGH_NV)
    i(GL_CULL_FRAGMENT_NV)
    i(GL_OFFSET_TEXTURE_2D_NV)
    i(GL_DEPENDENT_AR_TEXTURE_2D_NV)
    i(GL_DEPENDENT_GB_TEXTURE_2D_NV)
    i(GL_DOT_PRODUCT_NV)
    i(GL_DOT_PRODUCT_DEPTH_REPLACE_NV)
    i(GL_DOT_PRODUCT_TEXTURE_2D_NV)
    i(GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV)
    i(GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV)
    i(GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV)
    i(GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV)
    i(GL_HILO_NV)
    i(GL_DSDT_NV)
    i(GL_DSDT_MAG_NV)
    i(GL_DSDT_MAG_VIB_NV)
    i(GL_HILO16_NV)
    i(GL_SIGNED_HILO_NV)
    i(GL_SIGNED_HILO16_NV)
    i(GL_SIGNED_RGBA_NV)
    i(GL_SIGNED_RGBA8_NV)
    i(GL_SIGNED_RGB_NV)
    i(GL_SIGNED_RGB8_NV)
    i(GL_SIGNED_LUMINANCE_NV)
    i(GL_SIGNED_LUMINANCE8_NV)
    i(GL_SIGNED_LUMINANCE_ALPHA_NV)
    i(GL_SIGNED_LUMINANCE8_ALPHA8_NV)
    i(GL_SIGNED_ALPHA_NV)
    i(GL_SIGNED_ALPHA8_NV)
    i(GL_SIGNED_INTENSITY_NV)
    i(GL_SIGNED_INTENSITY8_NV)
    i(GL_DSDT8_NV)
    i(GL_DSDT8_MAG8_NV)
    i(GL_DSDT8_MAG8_INTENSITY8_NV)
    i(GL_SIGNED_RGB_UNSIGNED_ALPHA_NV)
    i(GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV)
    i(GL_HI_SCALE_NV)
    i(GL_LO_SCALE_NV)
    i(GL_DS_SCALE_NV)
    i(GL_DT_SCALE_NV)
    i(GL_MAGNITUDE_SCALE_NV)
    i(GL_VIBRANCE_SCALE_NV)
    i(GL_HI_BIAS_NV)
    i(GL_LO_BIAS_NV)
    i(GL_DS_BIAS_NV)
    i(GL_DT_BIAS_NV)
    i(GL_MAGNITUDE_BIAS_NV)
    i(GL_VIBRANCE_BIAS_NV)
    i(GL_TEXTURE_BORDER_VALUES_NV)
    i(GL_TEXTURE_HI_SIZE_NV)
    i(GL_TEXTURE_LO_SIZE_NV)
    i(GL_TEXTURE_DS_SIZE_NV)
    i(GL_TEXTURE_DT_SIZE_NV)
    i(GL_TEXTURE_MAG_SIZE_NV)
#endif /* GL_NV_texture_shader */

#ifndef NO_GL_NV_texture_shader2
    i(GL_DOT_PRODUCT_TEXTURE_3D_NV)
#endif /* GL_NV_texture_shader2 */

#ifndef NO_GL_NV_texture_shader3
    i(GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV)
    i(GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV)
    i(GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV)
    i(GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV)
    i(GL_OFFSET_HILO_TEXTURE_2D_NV)
    i(GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV)
    i(GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV)
    i(GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV)
    i(GL_DEPENDENT_HILO_TEXTURE_2D_NV)
    i(GL_DEPENDENT_RGB_TEXTURE_3D_NV)
    i(GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV)
    i(GL_DOT_PRODUCT_PASS_THROUGH_NV)
    i(GL_DOT_PRODUCT_TEXTURE_1D_NV)
    i(GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV)
    i(GL_HILO8_NV)
    i(GL_SIGNED_HILO8_NV)
    i(GL_FORCE_BLUE_TO_ONE_NV)
#endif /* GL_NV_texture_shader3 */

#ifndef NO_GL_NV_transform_feedback
    i(GL_BACK_PRIMARY_COLOR_NV)
    i(GL_BACK_SECONDARY_COLOR_NV)
    i(GL_TEXTURE_COORD_NV)
    i(GL_CLIP_DISTANCE_NV)
    i(GL_VERTEX_ID_NV)
    i(GL_PRIMITIVE_ID_NV)
    i(GL_GENERIC_ATTRIB_NV)
    i(GL_TRANSFORM_FEEDBACK_ATTRIBS_NV)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV)
    i(GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV)
    i(GL_ACTIVE_VARYINGS_NV)
    i(GL_ACTIVE_VARYING_MAX_LENGTH_NV)
    i(GL_TRANSFORM_FEEDBACK_VARYINGS_NV)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_START_NV)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV)
    i(GL_TRANSFORM_FEEDBACK_RECORD_NV)
    i(GL_PRIMITIVES_GENERATED_NV)
    i(GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV)
    i(GL_RASTERIZER_DISCARD_NV)
    i(GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV)
    i(GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV)
    i(GL_INTERLEAVED_ATTRIBS_NV)
    i(GL_SEPARATE_ATTRIBS_NV)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_NV)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV)
    i(GL_LAYER_NV)
    i(GL_NEXT_BUFFER_NV)
    i(GL_SKIP_COMPONENTS4_NV)
    i(GL_SKIP_COMPONENTS3_NV)
    i(GL_SKIP_COMPONENTS2_NV)
    i(GL_SKIP_COMPONENTS1_NV)
#endif /* GL_NV_transform_feedback */

#ifndef NO_GL_NV_transform_feedback2
    i(GL_TRANSFORM_FEEDBACK_NV)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV)
    i(GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV)
    i(GL_TRANSFORM_FEEDBACK_BINDING_NV)
#endif /* GL_NV_transform_feedback2 */

#ifndef NO_GL_NV_uniform_buffer_unified_memory
    i(GL_UNIFORM_BUFFER_UNIFIED_NV)
    i(GL_UNIFORM_BUFFER_ADDRESS_NV)
    i(GL_UNIFORM_BUFFER_LENGTH_NV)
#endif /* GL_NV_uniform_buffer_unified_memory */

#ifndef NO_GL_NV_vdpau_interop
    i(GL_SURFACE_STATE_NV)
    i(GL_SURFACE_REGISTERED_NV)
    i(GL_SURFACE_MAPPED_NV)
    i(GL_WRITE_DISCARD_NV)
#endif /* GL_NV_vdpau_interop */

#ifndef NO_GL_NV_vertex_array_range
    i(GL_VERTEX_ARRAY_RANGE_NV)
    i(GL_VERTEX_ARRAY_RANGE_LENGTH_NV)
    i(GL_VERTEX_ARRAY_RANGE_VALID_NV)
    i(GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV)
    i(GL_VERTEX_ARRAY_RANGE_POINTER_NV)
#endif /* GL_NV_vertex_array_range */

#ifndef NO_GL_NV_vertex_array_range2
    i(GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV)
#endif /* GL_NV_vertex_array_range2 */

#ifndef NO_GL_NV_vertex_attrib_integer_64bit
#endif /* GL_NV_vertex_attrib_integer_64bit */

#ifndef NO_GL_NV_vertex_buffer_unified_memory
    i(GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV)
    i(GL_ELEMENT_ARRAY_UNIFIED_NV)
    i(GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV)
    i(GL_VERTEX_ARRAY_ADDRESS_NV)
    i(GL_NORMAL_ARRAY_ADDRESS_NV)
    i(GL_COLOR_ARRAY_ADDRESS_NV)
    i(GL_INDEX_ARRAY_ADDRESS_NV)
    i(GL_TEXTURE_COORD_ARRAY_ADDRESS_NV)
    i(GL_EDGE_FLAG_ARRAY_ADDRESS_NV)
    i(GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV)
    i(GL_FOG_COORD_ARRAY_ADDRESS_NV)
    i(GL_ELEMENT_ARRAY_ADDRESS_NV)
    i(GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV)
    i(GL_VERTEX_ARRAY_LENGTH_NV)
    i(GL_NORMAL_ARRAY_LENGTH_NV)
    i(GL_COLOR_ARRAY_LENGTH_NV)
    i(GL_INDEX_ARRAY_LENGTH_NV)
    i(GL_TEXTURE_COORD_ARRAY_LENGTH_NV)
    i(GL_EDGE_FLAG_ARRAY_LENGTH_NV)
    i(GL_SECONDARY_COLOR_ARRAY_LENGTH_NV)
    i(GL_FOG_COORD_ARRAY_LENGTH_NV)
    i(GL_ELEMENT_ARRAY_LENGTH_NV)
    i(GL_DRAW_INDIRECT_UNIFIED_NV)
    i(GL_DRAW_INDIRECT_ADDRESS_NV)
    i(GL_DRAW_INDIRECT_LENGTH_NV)
#endif /* GL_NV_vertex_buffer_unified_memory */

#ifndef NO_GL_NV_vertex_program
    i(GL_VERTEX_PROGRAM_NV)
    i(GL_VERTEX_STATE_PROGRAM_NV)
    i(GL_ATTRIB_ARRAY_SIZE_NV)
    i(GL_ATTRIB_ARRAY_STRIDE_NV)
    i(GL_ATTRIB_ARRAY_TYPE_NV)
    i(GL_CURRENT_ATTRIB_NV)
    i(GL_PROGRAM_LENGTH_NV)
    i(GL_PROGRAM_STRING_NV)
    i(GL_MODELVIEW_PROJECTION_NV)
    i(GL_IDENTITY_NV)
    i(GL_INVERSE_NV)
    i(GL_TRANSPOSE_NV)
    i(GL_INVERSE_TRANSPOSE_NV)
    i(GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV)
    i(GL_MAX_TRACK_MATRICES_NV)
    i(GL_MATRIX0_NV)
    i(GL_MATRIX1_NV)
    i(GL_MATRIX2_NV)
    i(GL_MATRIX3_NV)
    i(GL_MATRIX4_NV)
    i(GL_MATRIX5_NV)
    i(GL_MATRIX6_NV)
    i(GL_MATRIX7_NV)
    i(GL_CURRENT_MATRIX_STACK_DEPTH_NV)
    i(GL_CURRENT_MATRIX_NV)
    i(GL_VERTEX_PROGRAM_POINT_SIZE_NV)
    i(GL_VERTEX_PROGRAM_TWO_SIDE_NV)
    i(GL_PROGRAM_PARAMETER_NV)
    i(GL_ATTRIB_ARRAY_POINTER_NV)
    i(GL_PROGRAM_TARGET_NV)
    i(GL_PROGRAM_RESIDENT_NV)
    i(GL_TRACK_MATRIX_NV)
    i(GL_TRACK_MATRIX_TRANSFORM_NV)
    i(GL_VERTEX_PROGRAM_BINDING_NV)
    i(GL_PROGRAM_ERROR_POSITION_NV)
    i(GL_VERTEX_ATTRIB_ARRAY0_NV)
    i(GL_VERTEX_ATTRIB_ARRAY1_NV)
    i(GL_VERTEX_ATTRIB_ARRAY2_NV)
    i(GL_VERTEX_ATTRIB_ARRAY3_NV)
    i(GL_VERTEX_ATTRIB_ARRAY4_NV)
    i(GL_VERTEX_ATTRIB_ARRAY5_NV)
    i(GL_VERTEX_ATTRIB_ARRAY6_NV)
    i(GL_VERTEX_ATTRIB_ARRAY7_NV)
    i(GL_VERTEX_ATTRIB_ARRAY8_NV)
    i(GL_VERTEX_ATTRIB_ARRAY9_NV)
    i(GL_VERTEX_ATTRIB_ARRAY10_NV)
    i(GL_VERTEX_ATTRIB_ARRAY11_NV)
    i(GL_VERTEX_ATTRIB_ARRAY12_NV)
    i(GL_VERTEX_ATTRIB_ARRAY13_NV)
    i(GL_VERTEX_ATTRIB_ARRAY14_NV)
    i(GL_VERTEX_ATTRIB_ARRAY15_NV)
    i(GL_MAP1_VERTEX_ATTRIB0_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB1_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB2_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB3_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB4_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB5_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB6_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB7_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB8_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB9_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB10_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB11_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB12_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB13_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB14_4_NV)
    i(GL_MAP1_VERTEX_ATTRIB15_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB0_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB1_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB2_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB3_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB4_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB5_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB6_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB7_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB8_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB9_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB10_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB11_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB12_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB13_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB14_4_NV)
    i(GL_MAP2_VERTEX_ATTRIB15_4_NV)
#endif /* GL_NV_vertex_program */

#ifndef NO_GL_NV_vertex_program1_1
#endif /* GL_NV_vertex_program1_1 */

#ifndef NO_GL_NV_vertex_program2
#endif /* GL_NV_vertex_program2 */

#ifndef NO_GL_NV_vertex_program2_option
#endif /* GL_NV_vertex_program2_option */

#ifndef NO_GL_NV_vertex_program3
#endif /* GL_NV_vertex_program3 */

#ifndef NO_GL_NV_vertex_program4
    i(GL_VERTEX_ATTRIB_ARRAY_INTEGER_NV)
#endif /* GL_NV_vertex_program4 */

#ifndef NO_GL_NV_video_capture
    i(GL_VIDEO_BUFFER_NV)
    i(GL_VIDEO_BUFFER_BINDING_NV)
    i(GL_FIELD_UPPER_NV)
    i(GL_FIELD_LOWER_NV)
    i(GL_NUM_VIDEO_CAPTURE_STREAMS_NV)
    i(GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV)
    i(GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV)
    i(GL_LAST_VIDEO_CAPTURE_STATUS_NV)
    i(GL_VIDEO_BUFFER_PITCH_NV)
    i(GL_VIDEO_COLOR_CONVERSION_MATRIX_NV)
    i(GL_VIDEO_COLOR_CONVERSION_MAX_NV)
    i(GL_VIDEO_COLOR_CONVERSION_MIN_NV)
    i(GL_VIDEO_COLOR_CONVERSION_OFFSET_NV)
    i(GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV)
    i(GL_PARTIAL_SUCCESS_NV)
    i(GL_SUCCESS_NV)
    i(GL_FAILURE_NV)
    i(GL_YCBYCR8_422_NV)
    i(GL_YCBAYCR8A_4224_NV)
    i(GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV)
    i(GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV)
    i(GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV)
    i(GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV)
    i(GL_Z4Y12Z4CB12Z4CR12_444_NV)
    i(GL_VIDEO_CAPTURE_FRAME_WIDTH_NV)
    i(GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV)
    i(GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV)
    i(GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV)
    i(GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV)
#endif /* GL_NV_video_capture */

#ifndef NO_GL_NV_viewport_array2
#endif /* GL_NV_viewport_array2 */

#ifndef NO_GL_NV_viewport_swizzle
    i(GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV)
    i(GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV)
    i(GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV)
    i(GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV)
    i(GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV)
    i(GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV)
    i(GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV)
    i(GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV)
    i(GL_VIEWPORT_SWIZZLE_X_NV)
    i(GL_VIEWPORT_SWIZZLE_Y_NV)
    i(GL_VIEWPORT_SWIZZLE_Z_NV)
    i(GL_VIEWPORT_SWIZZLE_W_NV)
#endif /* GL_NV_viewport_swizzle */

#ifndef NO_GL_OML_interlace
    i(GL_INTERLACE_OML)
    i(GL_INTERLACE_READ_OML)
#endif /* GL_OML_interlace */

#ifndef NO_GL_OML_resample
    i(GL_PACK_RESAMPLE_OML)
    i(GL_UNPACK_RESAMPLE_OML)
    i(GL_RESAMPLE_REPLICATE_OML)
    i(GL_RESAMPLE_ZERO_FILL_OML)
    i(GL_RESAMPLE_AVERAGE_OML)
    i(GL_RESAMPLE_DECIMATE_OML)
#endif /* GL_OML_resample */

#ifndef NO_GL_OML_subsample
    i(GL_FORMAT_SUBSAMPLE_24_24_OML)
    i(GL_FORMAT_SUBSAMPLE_244_244_OML)
#endif /* GL_OML_subsample */

#ifndef NO_GL_OVR_multiview
    i(GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR)
    i(GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR)
    i(GL_MAX_VIEWS_OVR)
#endif /* GL_OVR_multiview */

#ifndef NO_GL_OVR_multiview2
#endif /* GL_OVR_multiview2 */

#ifndef NO_GL_PGI_misc_hints
    i(GL_PREFER_DOUBLEBUFFER_HINT_PGI)
    i(GL_CONSERVE_MEMORY_HINT_PGI)
    i(GL_RECLAIM_MEMORY_HINT_PGI)
    i(GL_NATIVE_GRAPHICS_HANDLE_PGI)
    i(GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI)
    i(GL_NATIVE_GRAPHICS_END_HINT_PGI)
    i(GL_ALWAYS_FAST_HINT_PGI)
    i(GL_ALWAYS_SOFT_HINT_PGI)
    i(GL_ALLOW_DRAW_OBJ_HINT_PGI)
    i(GL_ALLOW_DRAW_WIN_HINT_PGI)
    i(GL_ALLOW_DRAW_FRG_HINT_PGI)
    i(GL_ALLOW_DRAW_MEM_HINT_PGI)
    i(GL_STRICT_DEPTHFUNC_HINT_PGI)
    i(GL_STRICT_LIGHTING_HINT_PGI)
    i(GL_STRICT_SCISSOR_HINT_PGI)
    i(GL_FULL_STIPPLE_HINT_PGI)
    i(GL_CLIP_NEAR_HINT_PGI)
    i(GL_CLIP_FAR_HINT_PGI)
    i(GL_WIDE_LINE_HINT_PGI)
    i(GL_BACK_NORMALS_HINT_PGI)
#endif /* GL_PGI_misc_hints */

#ifndef NO_GL_PGI_vertex_hints
    i(GL_VERTEX_DATA_HINT_PGI)
    i(GL_VERTEX_CONSISTENT_HINT_PGI)
    i(GL_MATERIAL_SIDE_HINT_PGI)
    i(GL_MAX_VERTEX_HINT_PGI)
    i(GL_COLOR3_BIT_PGI)
    i(GL_COLOR4_BIT_PGI)
    i(GL_EDGEFLAG_BIT_PGI)
    i(GL_INDEX_BIT_PGI)
    i(GL_MAT_AMBIENT_BIT_PGI)
    i(GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI)
    i(GL_MAT_DIFFUSE_BIT_PGI)
    i(GL_MAT_EMISSION_BIT_PGI)
    i(GL_MAT_COLOR_INDEXES_BIT_PGI)
    i(GL_MAT_SHININESS_BIT_PGI)
    i(GL_MAT_SPECULAR_BIT_PGI)
    i(GL_NORMAL_BIT_PGI)
    i(GL_TEXCOORD1_BIT_PGI)
    i(GL_TEXCOORD2_BIT_PGI)
    i(GL_TEXCOORD3_BIT_PGI)
    i(GL_TEXCOORD4_BIT_PGI)
    i(GL_VERTEX23_BIT_PGI)
    i(GL_VERTEX4_BIT_PGI)
#endif /* GL_PGI_vertex_hints */

#ifndef NO_GL_REND_screen_coordinates
    i(GL_SCREEN_COORDINATES_REND)
    i(GL_INVERTED_SCREEN_W_REND)
#endif /* GL_REND_screen_coordinates */

#ifndef NO_GL_S3_s3tc
    i(GL_RGB_S3TC)
    i(GL_RGB4_S3TC)
    i(GL_RGBA_S3TC)
    i(GL_RGBA4_S3TC)
    i(GL_RGBA_DXT5_S3TC)
    i(GL_RGBA4_DXT5_S3TC)
#endif /* GL_S3_s3tc */

#ifndef NO_GL_SGIS_detail_texture
    i(GL_DETAIL_TEXTURE_2D_SGIS)
    i(GL_DETAIL_TEXTURE_2D_BINDING_SGIS)
    i(GL_LINEAR_DETAIL_SGIS)
    i(GL_LINEAR_DETAIL_ALPHA_SGIS)
    i(GL_LINEAR_DETAIL_COLOR_SGIS)
    i(GL_DETAIL_TEXTURE_LEVEL_SGIS)
    i(GL_DETAIL_TEXTURE_MODE_SGIS)
    i(GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS)
#endif /* GL_SGIS_detail_texture */

#ifndef NO_GL_SGIS_fog_function
    i(GL_FOG_FUNC_SGIS)
    i(GL_FOG_FUNC_POINTS_SGIS)
    i(GL_MAX_FOG_FUNC_POINTS_SGIS)
#endif /* GL_SGIS_fog_function */

#ifndef NO_GL_SGIS_generate_mipmap
    i(GL_GENERATE_MIPMAP_SGIS)
    i(GL_GENERATE_MIPMAP_HINT_SGIS)
#endif /* GL_SGIS_generate_mipmap */

#ifndef NO_GL_SGIS_multisample
    i(GL_MULTISAMPLE_SGIS)
    i(GL_SAMPLE_ALPHA_TO_MASK_SGIS)
    i(GL_SAMPLE_ALPHA_TO_ONE_SGIS)
    i(GL_SAMPLE_MASK_SGIS)
    i(GL_1PASS_SGIS)
    i(GL_2PASS_0_SGIS)
    i(GL_2PASS_1_SGIS)
    i(GL_4PASS_0_SGIS)
    i(GL_4PASS_1_SGIS)
    i(GL_4PASS_2_SGIS)
    i(GL_4PASS_3_SGIS)
    i(GL_SAMPLE_BUFFERS_SGIS)
    i(GL_SAMPLES_SGIS)
    i(GL_SAMPLE_MASK_VALUE_SGIS)
    i(GL_SAMPLE_MASK_INVERT_SGIS)
    i(GL_SAMPLE_PATTERN_SGIS)
#endif /* GL_SGIS_multisample */

#ifndef NO_GL_SGIS_pixel_texture
    i(GL_PIXEL_TEXTURE_SGIS)
    i(GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS)
    i(GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS)
    i(GL_PIXEL_GROUP_COLOR_SGIS)
#endif /* GL_SGIS_pixel_texture */

#ifndef NO_GL_SGIS_point_line_texgen
    i(GL_EYE_DISTANCE_TO_POINT_SGIS)
    i(GL_OBJECT_DISTANCE_TO_POINT_SGIS)
    i(GL_EYE_DISTANCE_TO_LINE_SGIS)
    i(GL_OBJECT_DISTANCE_TO_LINE_SGIS)
    i(GL_EYE_POINT_SGIS)
    i(GL_OBJECT_POINT_SGIS)
    i(GL_EYE_LINE_SGIS)
    i(GL_OBJECT_LINE_SGIS)
#endif /* GL_SGIS_point_line_texgen */

#ifndef NO_GL_SGIS_point_parameters
    i(GL_POINT_SIZE_MIN_SGIS)
    i(GL_POINT_SIZE_MAX_SGIS)
    i(GL_POINT_FADE_THRESHOLD_SIZE_SGIS)
    i(GL_DISTANCE_ATTENUATION_SGIS)
#endif /* GL_SGIS_point_parameters */

#ifndef NO_GL_SGIS_sharpen_texture
    i(GL_LINEAR_SHARPEN_SGIS)
    i(GL_LINEAR_SHARPEN_ALPHA_SGIS)
    i(GL_LINEAR_SHARPEN_COLOR_SGIS)
    i(GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS)
#endif /* GL_SGIS_sharpen_texture */

#ifndef NO_GL_SGIS_texture4D
    i(GL_PACK_SKIP_VOLUMES_SGIS)
    i(GL_PACK_IMAGE_DEPTH_SGIS)
    i(GL_UNPACK_SKIP_VOLUMES_SGIS)
    i(GL_UNPACK_IMAGE_DEPTH_SGIS)
    i(GL_TEXTURE_4D_SGIS)
    i(GL_PROXY_TEXTURE_4D_SGIS)
    i(GL_TEXTURE_4DSIZE_SGIS)
    i(GL_TEXTURE_WRAP_Q_SGIS)
    i(GL_MAX_4D_TEXTURE_SIZE_SGIS)
    i(GL_TEXTURE_4D_BINDING_SGIS)
#endif /* GL_SGIS_texture4D */

#ifndef NO_GL_SGIS_texture_border_clamp
    i(GL_CLAMP_TO_BORDER_SGIS)
#endif /* GL_SGIS_texture_border_clamp */

#ifndef NO_GL_SGIS_texture_color_mask
    i(GL_TEXTURE_COLOR_WRITEMASK_SGIS)
#endif /* GL_SGIS_texture_color_mask */

#ifndef NO_GL_SGIS_texture_edge_clamp
    i(GL_CLAMP_TO_EDGE_SGIS)
#endif /* GL_SGIS_texture_edge_clamp */

#ifndef NO_GL_SGIS_texture_filter4
    i(GL_FILTER4_SGIS)
    i(GL_TEXTURE_FILTER4_SIZE_SGIS)
#endif /* GL_SGIS_texture_filter4 */

#ifndef NO_GL_SGIS_texture_lod
    i(GL_TEXTURE_MIN_LOD_SGIS)
    i(GL_TEXTURE_MAX_LOD_SGIS)
    i(GL_TEXTURE_BASE_LEVEL_SGIS)
    i(GL_TEXTURE_MAX_LEVEL_SGIS)
#endif /* GL_SGIS_texture_lod */

#ifndef NO_GL_SGIS_texture_select
    i(GL_DUAL_ALPHA4_SGIS)
    i(GL_DUAL_ALPHA8_SGIS)
    i(GL_DUAL_ALPHA12_SGIS)
    i(GL_DUAL_ALPHA16_SGIS)
    i(GL_DUAL_LUMINANCE4_SGIS)
    i(GL_DUAL_LUMINANCE8_SGIS)
    i(GL_DUAL_LUMINANCE12_SGIS)
    i(GL_DUAL_LUMINANCE16_SGIS)
    i(GL_DUAL_INTENSITY4_SGIS)
    i(GL_DUAL_INTENSITY8_SGIS)
    i(GL_DUAL_INTENSITY12_SGIS)
    i(GL_DUAL_INTENSITY16_SGIS)
    i(GL_DUAL_LUMINANCE_ALPHA4_SGIS)
    i(GL_DUAL_LUMINANCE_ALPHA8_SGIS)
    i(GL_QUAD_ALPHA4_SGIS)
    i(GL_QUAD_ALPHA8_SGIS)
    i(GL_QUAD_LUMINANCE4_SGIS)
    i(GL_QUAD_LUMINANCE8_SGIS)
    i(GL_QUAD_INTENSITY4_SGIS)
    i(GL_QUAD_INTENSITY8_SGIS)
    i(GL_DUAL_TEXTURE_SELECT_SGIS)
    i(GL_QUAD_TEXTURE_SELECT_SGIS)
#endif /* GL_SGIS_texture_select */

#ifndef NO_GL_SGIX_async
    i(GL_ASYNC_MARKER_SGIX)
#endif /* GL_SGIX_async */

#ifndef NO_GL_SGIX_async_histogram
    i(GL_ASYNC_HISTOGRAM_SGIX)
    i(GL_MAX_ASYNC_HISTOGRAM_SGIX)
#endif /* GL_SGIX_async_histogram */

#ifndef NO_GL_SGIX_async_pixel
    i(GL_ASYNC_TEX_IMAGE_SGIX)
    i(GL_ASYNC_DRAW_PIXELS_SGIX)
    i(GL_ASYNC_READ_PIXELS_SGIX)
    i(GL_MAX_ASYNC_TEX_IMAGE_SGIX)
    i(GL_MAX_ASYNC_DRAW_PIXELS_SGIX)
    i(GL_MAX_ASYNC_READ_PIXELS_SGIX)
#endif /* GL_SGIX_async_pixel */

#ifndef NO_GL_SGIX_blend_alpha_minmax
    i(GL_ALPHA_MIN_SGIX)
    i(GL_ALPHA_MAX_SGIX)
#endif /* GL_SGIX_blend_alpha_minmax */

#ifndef NO_GL_SGIX_calligraphic_fragment
    i(GL_CALLIGRAPHIC_FRAGMENT_SGIX)
#endif /* GL_SGIX_calligraphic_fragment */

#ifndef NO_GL_SGIX_clipmap
    i(GL_LINEAR_CLIPMAP_LINEAR_SGIX)
    i(GL_TEXTURE_CLIPMAP_CENTER_SGIX)
    i(GL_TEXTURE_CLIPMAP_FRAME_SGIX)
    i(GL_TEXTURE_CLIPMAP_OFFSET_SGIX)
    i(GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX)
    i(GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX)
    i(GL_TEXTURE_CLIPMAP_DEPTH_SGIX)
    i(GL_MAX_CLIPMAP_DEPTH_SGIX)
    i(GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX)
    i(GL_NEAREST_CLIPMAP_NEAREST_SGIX)
    i(GL_NEAREST_CLIPMAP_LINEAR_SGIX)
    i(GL_LINEAR_CLIPMAP_NEAREST_SGIX)
#endif /* GL_SGIX_clipmap */

#ifndef NO_GL_SGIX_convolution_accuracy
    i(GL_CONVOLUTION_HINT_SGIX)
#endif /* GL_SGIX_convolution_accuracy */

#ifndef NO_GL_SGIX_depth_pass_instrument
#endif /* GL_SGIX_depth_pass_instrument */

#ifndef NO_GL_SGIX_depth_texture
    i(GL_DEPTH_COMPONENT16_SGIX)
    i(GL_DEPTH_COMPONENT24_SGIX)
    i(GL_DEPTH_COMPONENT32_SGIX)
#endif /* GL_SGIX_depth_texture */

#ifndef NO_GL_SGIX_flush_raster
#endif /* GL_SGIX_flush_raster */

#ifndef NO_GL_SGIX_fog_offset
    i(GL_FOG_OFFSET_SGIX)
    i(GL_FOG_OFFSET_VALUE_SGIX)
#endif /* GL_SGIX_fog_offset */

#ifndef NO_GL_SGIX_fragment_lighting
    i(GL_FRAGMENT_LIGHTING_SGIX)
    i(GL_FRAGMENT_COLOR_MATERIAL_SGIX)
    i(GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX)
    i(GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX)
    i(GL_MAX_FRAGMENT_LIGHTS_SGIX)
    i(GL_MAX_ACTIVE_LIGHTS_SGIX)
    i(GL_CURRENT_RASTER_NORMAL_SGIX)
    i(GL_LIGHT_ENV_MODE_SGIX)
    i(GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX)
    i(GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX)
    i(GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX)
    i(GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX)
    i(GL_FRAGMENT_LIGHT0_SGIX)
    i(GL_FRAGMENT_LIGHT1_SGIX)
    i(GL_FRAGMENT_LIGHT2_SGIX)
    i(GL_FRAGMENT_LIGHT3_SGIX)
    i(GL_FRAGMENT_LIGHT4_SGIX)
    i(GL_FRAGMENT_LIGHT5_SGIX)
    i(GL_FRAGMENT_LIGHT6_SGIX)
    i(GL_FRAGMENT_LIGHT7_SGIX)
#endif /* GL_SGIX_fragment_lighting */

#ifndef NO_GL_SGIX_framezoom
    i(GL_FRAMEZOOM_SGIX)
    i(GL_FRAMEZOOM_FACTOR_SGIX)
    i(GL_MAX_FRAMEZOOM_FACTOR_SGIX)
#endif /* GL_SGIX_framezoom */

#ifndef NO_GL_SGIX_igloo_interface
#endif /* GL_SGIX_igloo_interface */

#ifndef NO_GL_SGIX_instruments
    i(GL_INSTRUMENT_BUFFER_POINTER_SGIX)
    i(GL_INSTRUMENT_MEASUREMENTS_SGIX)
#endif /* GL_SGIX_instruments */

#ifndef NO_GL_SGIX_interlace
    i(GL_INTERLACE_SGIX)
#endif /* GL_SGIX_interlace */

#ifndef NO_GL_SGIX_ir_instrument1
    i(GL_IR_INSTRUMENT1_SGIX)
#endif /* GL_SGIX_ir_instrument1 */

#ifndef NO_GL_SGIX_list_priority
    i(GL_LIST_PRIORITY_SGIX)
#endif /* GL_SGIX_list_priority */

#ifndef NO_GL_SGIX_pixel_texture
    i(GL_PIXEL_TEX_GEN_SGIX)
    i(GL_PIXEL_TEX_GEN_MODE_SGIX)
#endif /* GL_SGIX_pixel_texture */

#ifndef NO_GL_SGIX_pixel_tiles
    i(GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX)
    i(GL_PIXEL_TILE_CACHE_INCREMENT_SGIX)
    i(GL_PIXEL_TILE_WIDTH_SGIX)
    i(GL_PIXEL_TILE_HEIGHT_SGIX)
    i(GL_PIXEL_TILE_GRID_WIDTH_SGIX)
    i(GL_PIXEL_TILE_GRID_HEIGHT_SGIX)
    i(GL_PIXEL_TILE_GRID_DEPTH_SGIX)
    i(GL_PIXEL_TILE_CACHE_SIZE_SGIX)
#endif /* GL_SGIX_pixel_tiles */

#ifndef NO_GL_SGIX_polynomial_ffd
    i(GL_TEXTURE_DEFORMATION_BIT_SGIX)
    i(GL_GEOMETRY_DEFORMATION_BIT_SGIX)
    i(GL_GEOMETRY_DEFORMATION_SGIX)
    i(GL_TEXTURE_DEFORMATION_SGIX)
    i(GL_DEFORMATIONS_MASK_SGIX)
    i(GL_MAX_DEFORMATION_ORDER_SGIX)
#endif /* GL_SGIX_polynomial_ffd */

#ifndef NO_GL_SGIX_reference_plane
    i(GL_REFERENCE_PLANE_SGIX)
    i(GL_REFERENCE_PLANE_EQUATION_SGIX)
#endif /* GL_SGIX_reference_plane */

#ifndef NO_GL_SGIX_resample
    i(GL_PACK_RESAMPLE_SGIX)
    i(GL_UNPACK_RESAMPLE_SGIX)
    i(GL_RESAMPLE_REPLICATE_SGIX)
    i(GL_RESAMPLE_ZERO_FILL_SGIX)
    i(GL_RESAMPLE_DECIMATE_SGIX)
#endif /* GL_SGIX_resample */

#ifndef NO_GL_SGIX_scalebias_hint
    i(GL_SCALEBIAS_HINT_SGIX)
#endif /* GL_SGIX_scalebias_hint */

#ifndef NO_GL_SGIX_shadow
    i(GL_TEXTURE_COMPARE_SGIX)
    i(GL_TEXTURE_COMPARE_OPERATOR_SGIX)
    i(GL_TEXTURE_LEQUAL_R_SGIX)
    i(GL_TEXTURE_GEQUAL_R_SGIX)
#endif /* GL_SGIX_shadow */

#ifndef NO_GL_SGIX_shadow_ambient
    i(GL_SHADOW_AMBIENT_SGIX)
#endif /* GL_SGIX_shadow_ambient */

#ifndef NO_GL_SGIX_sprite
    i(GL_SPRITE_SGIX)
    i(GL_SPRITE_MODE_SGIX)
    i(GL_SPRITE_AXIS_SGIX)
    i(GL_SPRITE_TRANSLATION_SGIX)
    i(GL_SPRITE_AXIAL_SGIX)
    i(GL_SPRITE_OBJECT_ALIGNED_SGIX)
    i(GL_SPRITE_EYE_ALIGNED_SGIX)
#endif /* GL_SGIX_sprite */

#ifndef NO_GL_SGIX_subsample
    i(GL_PACK_SUBSAMPLE_RATE_SGIX)
    i(GL_UNPACK_SUBSAMPLE_RATE_SGIX)
    i(GL_PIXEL_SUBSAMPLE_4444_SGIX)
    i(GL_PIXEL_SUBSAMPLE_2424_SGIX)
    i(GL_PIXEL_SUBSAMPLE_4242_SGIX)
#endif /* GL_SGIX_subsample */

#ifndef NO_GL_SGIX_tag_sample_buffer
#endif /* GL_SGIX_tag_sample_buffer */

#ifndef NO_GL_SGIX_texture_add_env
    i(GL_TEXTURE_ENV_BIAS_SGIX)
#endif /* GL_SGIX_texture_add_env */

#ifndef NO_GL_SGIX_texture_coordinate_clamp
    i(GL_TEXTURE_MAX_CLAMP_S_SGIX)
    i(GL_TEXTURE_MAX_CLAMP_T_SGIX)
    i(GL_TEXTURE_MAX_CLAMP_R_SGIX)
#endif /* GL_SGIX_texture_coordinate_clamp */

#ifndef NO_GL_SGIX_texture_lod_bias
    i(GL_TEXTURE_LOD_BIAS_S_SGIX)
    i(GL_TEXTURE_LOD_BIAS_T_SGIX)
    i(GL_TEXTURE_LOD_BIAS_R_SGIX)
#endif /* GL_SGIX_texture_lod_bias */

#ifndef NO_GL_SGIX_texture_multi_buffer
    i(GL_TEXTURE_MULTI_BUFFER_HINT_SGIX)
#endif /* GL_SGIX_texture_multi_buffer */

#ifndef NO_GL_SGIX_texture_scale_bias
    i(GL_POST_TEXTURE_FILTER_BIAS_SGIX)
    i(GL_POST_TEXTURE_FILTER_SCALE_SGIX)
    i(GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX)
    i(GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX)
#endif /* GL_SGIX_texture_scale_bias */

#ifndef NO_GL_SGIX_vertex_preclip
    i(GL_VERTEX_PRECLIP_SGIX)
    i(GL_VERTEX_PRECLIP_HINT_SGIX)
#endif /* GL_SGIX_vertex_preclip */

#ifndef NO_GL_SGIX_ycrcb
    i(GL_YCRCB_422_SGIX)
    i(GL_YCRCB_444_SGIX)
#endif /* GL_SGIX_ycrcb */

#ifndef NO_GL_SGIX_ycrcb_subsample
#endif /* GL_SGIX_ycrcb_subsample */

#ifndef NO_GL_SGIX_ycrcba
    i(GL_YCRCB_SGIX)
    i(GL_YCRCBA_SGIX)
#endif /* GL_SGIX_ycrcba */

#ifndef NO_GL_SGI_color_matrix
    i(GL_COLOR_MATRIX_SGI)
    i(GL_COLOR_MATRIX_STACK_DEPTH_SGI)
    i(GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI)
    i(GL_POST_COLOR_MATRIX_RED_SCALE_SGI)
    i(GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI)
    i(GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI)
    i(GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI)
    i(GL_POST_COLOR_MATRIX_RED_BIAS_SGI)
    i(GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI)
    i(GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI)
    i(GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI)
#endif /* GL_SGI_color_matrix */

#ifndef NO_GL_SGI_color_table
    i(GL_COLOR_TABLE_SGI)
    i(GL_POST_CONVOLUTION_COLOR_TABLE_SGI)
    i(GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI)
    i(GL_PROXY_COLOR_TABLE_SGI)
    i(GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI)
    i(GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI)
    i(GL_COLOR_TABLE_SCALE_SGI)
    i(GL_COLOR_TABLE_BIAS_SGI)
    i(GL_COLOR_TABLE_FORMAT_SGI)
    i(GL_COLOR_TABLE_WIDTH_SGI)
    i(GL_COLOR_TABLE_RED_SIZE_SGI)
    i(GL_COLOR_TABLE_GREEN_SIZE_SGI)
    i(GL_COLOR_TABLE_BLUE_SIZE_SGI)
    i(GL_COLOR_TABLE_ALPHA_SIZE_SGI)
    i(GL_COLOR_TABLE_LUMINANCE_SIZE_SGI)
    i(GL_COLOR_TABLE_INTENSITY_SIZE_SGI)
#endif /* GL_SGI_color_table */

#ifndef NO_GL_SGI_texture_color_table
    i(GL_TEXTURE_COLOR_TABLE_SGI)
    i(GL_PROXY_TEXTURE_COLOR_TABLE_SGI)
#endif /* GL_SGI_texture_color_table */

#ifndef NO_GL_SUNX_constant_data
    i(GL_UNPACK_CONSTANT_DATA_SUNX)
    i(GL_TEXTURE_CONSTANT_DATA_SUNX)
#endif /* GL_SUNX_constant_data */

#ifndef NO_GL_SUN_convolution_border_modes
    i(GL_WRAP_BORDER_SUN)
#endif /* GL_SUN_convolution_border_modes */

#ifndef NO_GL_SUN_global_alpha
    i(GL_GLOBAL_ALPHA_SUN)
    i(GL_GLOBAL_ALPHA_FACTOR_SUN)
#endif /* GL_SUN_global_alpha */

#ifndef NO_GL_SUN_mesh_array
    i(GL_QUAD_MESH_SUN)
    i(GL_TRIANGLE_MESH_SUN)
#endif /* GL_SUN_mesh_array */

#ifndef NO_GL_SUN_slice_accum
    i(GL_SLICE_ACCUM_SUN)
#endif /* GL_SUN_slice_accum */

#ifndef NO_GL_SUN_triangle_list
    i(GL_RESTART_SUN)
    i(GL_REPLACE_MIDDLE_SUN)
    i(GL_REPLACE_OLDEST_SUN)
    i(GL_TRIANGLE_LIST_SUN)
    i(GL_REPLACEMENT_CODE_SUN)
    i(GL_REPLACEMENT_CODE_ARRAY_SUN)
    i(GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN)
    i(GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN)
    i(GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN)
    i(GL_R1UI_V3F_SUN)
    i(GL_R1UI_C4UB_V3F_SUN)
    i(GL_R1UI_C3F_V3F_SUN)
    i(GL_R1UI_N3F_V3F_SUN)
    i(GL_R1UI_C4F_N3F_V3F_SUN)
    i(GL_R1UI_T2F_V3F_SUN)
    i(GL_R1UI_T2F_N3F_V3F_SUN)
    i(GL_R1UI_T2F_C4F_N3F_V3F_SUN)
#endif /* GL_SUN_triangle_list */

#ifndef NO_GL_SUN_vertex
#endif /* GL_SUN_vertex */

#ifndef NO_GL_WIN_phong_shading
    i(GL_PHONG_WIN)
    i(GL_PHONG_HINT_WIN)
#endif /* GL_WIN_phong_shading */

#ifndef NO_GL_WIN_specular_fog
    i(GL_FOG_SPECULAR_TEXTURE_WIN)
#endif /* GL_WIN_specular_fog */

#ifdef __cplusplus
}
#endif

#endif
