#!perl -T
use 5.006;
use strict;
use warnings FATAL => 'all';
use Test::More;

use Mojo::Util::Collection;
use Mojo::Util::Model::User;

my $collection = Mojo::Util::Collection->new(
    items => [
        {
            id         => 1,
            first_name => 'Joe',
            last_name  => 'Doe',
            age        => 19
        },
        {
            id         => 2,
            first_name => 'Jane',
            last_name  => 'Doe',
            age        => 21
        },
        {
            id         => 3,
            first_name => 'John',
            last_name  => 'Doe',
            age        => 22
        },
        {
            id         => 4,
            first_name => 'Jill',
            last_name  => 'Doe',
            age        => 23
        },
    ],
    model => Mojo::Util::Model::User->new
);

$collection->limit(2);

is_deeply($collection->page(1)->only('id'), [ { id => 1 }, { id => 2 } ], 'page 1');
is_deeply($collection->page(2)->only('id'), [ { id => 3 }, { id => 4 } ], 'page 2');
is_deeply($collection->page(3)->only('id'), [], 'page 3');

done_testing();
