/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.ScanControllerRowSource;
import org.apache.derby.iapi.store.access.conglomerate.Sort;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Orderable;
import org.apache.derby.impl.store.access.sort.MergeInserter;
import org.apache.derby.impl.store.access.sort.MergeScan;
import org.apache.derby.impl.store.access.sort.MergeScanRowSource;
import org.apache.derby.impl.store.access.sort.Scan;
import org.apache.derby.impl.store.access.sort.SortBuffer;
import org.apache.derby.impl.store.access.sort.SortBufferRowSource;
import org.apache.derby.impl.store.access.sort.SortBufferScan;

public final class MergeSort
implements Sort {
    static final int STATE_CLOSED = 0;
    static final int STATE_INITIALIZED = 1;
    static final int STATE_INSERTING = 2;
    static final int STATE_DONE_INSERTING = 3;
    static final int STATE_SCANNING = 4;
    static final int STATE_DONE_SCANNING = 5;
    protected int state = 0;
    protected DataValueDescriptor[] template;
    protected ColumnOrdering[] columnOrdering;
    protected int[] columnOrderingMap;
    protected boolean[] columnOrderingAscendingMap;
    protected SortObserver sortObserver;
    protected boolean alreadyInOrder;
    protected MergeInserter inserter = null;
    protected Scan scan = null;
    protected Vector mergeRuns = null;
    protected SortBuffer sortBuffer = null;
    protected int sortBufferMax;
    protected int sortBufferMin;
    static Properties properties = null;

    public SortController open(TransactionManager transactionManager) throws StandardException {
        this.state = 2;
        this.inserter = new MergeInserter();
        if (!this.inserter.initialize(this, transactionManager)) {
            throw StandardException.newException("XSAS6.S");
        }
        return this.inserter;
    }

    public ScanController openSortScan(TransactionManager transactionManager, boolean bl) throws StandardException {
        if (this.mergeRuns == null || this.mergeRuns.size() == 0) {
            this.scan = new SortBufferScan(this, transactionManager, this.sortBuffer, bl);
            this.sortBuffer = null;
        } else {
            MergeScan mergeScan;
            long l = this.createMergeRun(transactionManager, this.sortBuffer);
            this.mergeRuns.addElement(new Long(l));
            if (this.mergeRuns.size() > 1024 || this.mergeRuns.size() > this.sortBuffer.capacity()) {
                this.multiStageMerge(transactionManager);
            }
            if (!(mergeScan = new MergeScan(this, transactionManager, this.sortBuffer, this.mergeRuns, this.sortObserver, bl)).init(transactionManager)) {
                throw StandardException.newException("XSAS6.S");
            }
            this.scan = mergeScan;
            this.sortBuffer = null;
            this.mergeRuns = null;
        }
        this.state = 4;
        return this.scan;
    }

    public ScanControllerRowSource openSortRowSource(TransactionManager transactionManager) throws StandardException {
        ScanControllerRowSource scanControllerRowSource = null;
        if (this.mergeRuns == null || this.mergeRuns.size() == 0) {
            this.scan = new SortBufferRowSource(this.sortBuffer, transactionManager, this.sortObserver, false, this.sortBufferMax);
            scanControllerRowSource = (ScanControllerRowSource)((Object)this.scan);
            this.sortBuffer = null;
        } else {
            MergeScanRowSource mergeScanRowSource;
            long l = this.createMergeRun(transactionManager, this.sortBuffer);
            this.mergeRuns.addElement(new Long(l));
            if (this.mergeRuns.size() > 1024 || this.mergeRuns.size() > this.sortBuffer.capacity()) {
                this.multiStageMerge(transactionManager);
            }
            if (!(mergeScanRowSource = new MergeScanRowSource(this, transactionManager, this.sortBuffer, this.mergeRuns, this.sortObserver, false)).init(transactionManager)) {
                throw StandardException.newException("XSAS6.S");
            }
            this.scan = mergeScanRowSource;
            scanControllerRowSource = mergeScanRowSource;
            this.sortBuffer = null;
            this.mergeRuns = null;
        }
        this.state = 4;
        return scanControllerRowSource;
    }

    public void drop(TransactionController transactionController) throws StandardException {
        if (this.inserter != null) {
            this.inserter.close();
        }
        this.inserter = null;
        if (this.scan != null) {
            this.scan.close();
            this.scan = null;
        }
        if (this.sortBuffer != null) {
            this.sortBuffer.close();
            this.sortBuffer = null;
        }
        this.template = null;
        this.columnOrdering = null;
        this.sortObserver = null;
        this.dropMergeRuns((TransactionManager)transactionController);
        this.state = 0;
    }

    protected boolean checkColumnOrdering(DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray) {
        int n = dataValueDescriptorArray.length;
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < columnOrderingArray.length; ++i) {
            int n2 = columnOrderingArray[i].getColumnId();
            if (n2 < 0 || n2 >= n) {
                return false;
            }
            if (blArray[n2]) {
                return false;
            }
            blArray[n2] = true;
            DataValueDescriptor dataValueDescriptor = RowUtil.getColumn(dataValueDescriptorArray, (FormatableBitSet)null, n2);
            if (dataValueDescriptor instanceof Orderable) continue;
            return false;
        }
        return true;
    }

    void checkColumnTypes(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        int n = dataValueDescriptorArray.length;
        if (this.template.length != n) {
            throw StandardException.newException("XSAS3.S");
        }
    }

    int compare(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2) throws StandardException {
        int n = this.columnOrdering.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.columnOrderingMap[i];
            int n3 = dataValueDescriptorArray[n2].compare(dataValueDescriptorArray2[n2]);
            if (n3 == 0) continue;
            if (this.columnOrderingAscendingMap[i]) {
                return n3;
            }
            return -n3;
        }
        return 0;
    }

    public void initialize(DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, SortObserver sortObserver, boolean bl, long l, int n) throws StandardException {
        this.template = dataValueDescriptorArray;
        this.columnOrdering = columnOrderingArray;
        this.sortObserver = sortObserver;
        this.alreadyInOrder = bl;
        this.columnOrderingMap = new int[columnOrderingArray.length];
        this.columnOrderingAscendingMap = new boolean[columnOrderingArray.length];
        for (int i = 0; i < columnOrderingArray.length; ++i) {
            this.columnOrderingMap[i] = columnOrderingArray[i].getColumnId();
            this.columnOrderingAscendingMap[i] = columnOrderingArray[i].getIsAscending();
        }
        this.inserter = null;
        this.scan = null;
        this.mergeRuns = null;
        this.sortBuffer = null;
        this.sortBufferMax = n;
        this.sortBufferMin = l > (long)n ? n : (int)l;
        this.state = 1;
    }

    void doneInserting(MergeInserter mergeInserter, SortBuffer sortBuffer, Vector vector) {
        this.sortBuffer = sortBuffer;
        this.mergeRuns = vector;
        this.inserter = null;
        this.state = 3;
    }

    void doneScanning(Scan scan, SortBuffer sortBuffer) {
        this.sortBuffer = sortBuffer;
        this.scan = null;
        this.state = 5;
    }

    void doneScanning(Scan scan, SortBuffer sortBuffer, Vector vector) {
        this.mergeRuns = vector;
        this.doneScanning(scan, sortBuffer);
    }

    void dropMergeRuns(TransactionManager transactionManager) {
        if (this.mergeRuns != null) {
            Enumeration enumeration = this.mergeRuns.elements();
            try {
                Transaction transaction = transactionManager.getRawStoreXact();
                long l = -1L;
                while (enumeration.hasMoreElements()) {
                    long l2 = (Long)enumeration.nextElement();
                    transaction.dropStreamContainer(l, l2);
                }
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            this.mergeRuns = null;
        }
    }

    private void multiStageMerge(TransactionManager transactionManager) throws StandardException {
        int n = this.sortBuffer.capacity();
        if (n > 1024) {
            n = 1024;
        }
        while (this.mergeRuns.size() > n) {
            Object object;
            Vector<Long> vector = new Vector<Long>(n);
            Vector<Long> vector2 = new Vector<Long>(this.mergeRuns.size() - n);
            Enumeration enumeration = this.mergeRuns.elements();
            while (enumeration.hasMoreElements()) {
                object = (Long)enumeration.nextElement();
                if (vector.size() < n) {
                    vector.addElement((Long)object);
                    continue;
                }
                vector2.addElement((Long)object);
            }
            this.mergeRuns = vector2;
            object = new MergeScanRowSource(this, transactionManager, this.sortBuffer, vector, this.sortObserver, false);
            if (!((MergeScan)object).init(transactionManager)) {
                throw StandardException.newException("XSAS6.S");
            }
            Transaction transaction = transactionManager.getRawStoreXact();
            int n2 = -1;
            long l = transaction.addAndLoadStreamContainer(n2, properties, (RowSource)object);
            this.mergeRuns.addElement(new Long(l));
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Long l2 = (Long)enumeration.nextElement();
                transaction.dropStreamContainer(n2, l2);
            }
        }
    }

    long createMergeRun(TransactionManager transactionManager, SortBuffer sortBuffer) throws StandardException {
        SortBufferRowSource sortBufferRowSource = new SortBufferRowSource(sortBuffer, null, this.sortObserver, true, this.sortBufferMax);
        Transaction transaction = transactionManager.getRawStoreXact();
        int n = -1;
        long l = transaction.addAndLoadStreamContainer(n, properties, sortBufferRowSource);
        sortBufferRowSource = null;
        return l;
    }

    static {
        properties = new Properties();
        properties.put("derby.storage.streamFileBufferSize", "16384");
    }
}

