/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import org.apache.derby.impl.services.bytecode.BCJava;

class BCMethodDescriptor {
    static final String[] EMPTY = new String[0];
    private final String[] vmParameterTypes;
    private final String vmReturnType;
    private final String vmDescriptor;

    BCMethodDescriptor(String[] stringArray, String string, BCJava bCJava) {
        this.vmParameterTypes = stringArray;
        this.vmReturnType = string;
        this.vmDescriptor = bCJava.vmType(this);
    }

    static String get(String[] stringArray, String string, BCJava bCJava) {
        return new BCMethodDescriptor(stringArray, string, bCJava).toString();
    }

    String buildMethodDescriptor() {
        int n = this.vmParameterTypes.length;
        int n2 = 30 * (n + 1);
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append('(');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.vmParameterTypes[i]);
        }
        stringBuffer.append(')');
        stringBuffer.append(this.vmReturnType);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.vmDescriptor;
    }

    public int hashCode() {
        return this.vmParameterTypes.length | this.vmReturnType.hashCode() & 0xFFFFFF00;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCMethodDescriptor)) {
            return false;
        }
        BCMethodDescriptor bCMethodDescriptor = (BCMethodDescriptor)object;
        if (bCMethodDescriptor.vmParameterTypes.length != this.vmParameterTypes.length) {
            return false;
        }
        for (int i = 0; i < this.vmParameterTypes.length; ++i) {
            if (this.vmParameterTypes[i].equals(bCMethodDescriptor.vmParameterTypes[i])) continue;
            return false;
        }
        return this.vmReturnType.equals(bCMethodDescriptor.vmReturnType);
    }
}

