/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public abstract class BooleanExpression
extends BinaryExpression
implements Negatable {
    public BooleanExpression(Expression p1, int operator, Expression p2) {
        super(p1, operator, p2);
    }

    public String getExpressionName() {
        return Token.tokens[this.getOperator()] + "-expression";
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e = super.typeCheck(visitor, contextItemType);
        if (e == this) {
            XPathException err0 = TypeChecker.ebvError(this.operand0, visitor.getConfiguration().getTypeHierarchy());
            if (err0 != null) {
                err0.setLocator(this);
                throw err0;
            }
            XPathException err1 = TypeChecker.ebvError(this.operand1, visitor.getConfiguration().getTypeHierarchy());
            if (err1 != null) {
                err1.setLocator(this);
                throw err1;
            }
            if (this.operand0 instanceof Literal && !(((Literal)this.operand0).getValue() instanceof BooleanValue)) {
                this.operand0 = Literal.makeLiteral(BooleanValue.get(this.operand0.effectiveBooleanValue(null)));
            }
            if (this.operand1 instanceof Literal && !(((Literal)this.operand1).getValue() instanceof BooleanValue)) {
                this.operand1 = Literal.makeLiteral(BooleanValue.get(this.operand1.effectiveBooleanValue(null)));
            }
        }
        return e;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression op1;
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        this.operand0 = ExpressionTool.unsortedIfHomogeneous(opt, this.operand0);
        this.operand1 = ExpressionTool.unsortedIfHomogeneous(opt, this.operand1);
        Expression op0 = BooleanFn.rewriteEffectiveBooleanValue(this.operand0, visitor, contextItemType);
        if (op0 != null) {
            this.operand0 = op0;
        }
        if ((op1 = BooleanFn.rewriteEffectiveBooleanValue(this.operand1, visitor, contextItemType)) != null) {
            this.operand1 = op1;
        }
        return this;
    }

    protected Expression forceToBoolean(Expression in, TypeHierarchy th) {
        if (in.getItemType(th) == BuiltInAtomicType.BOOLEAN && in.getCardinality() == 16384) {
            return in;
        }
        return SystemFunction.makeSystemFunction("boolean", new Expression[]{in});
    }

    public boolean isNegatable(ExpressionVisitor visitor) {
        return true;
    }

    public abstract Expression negate();

    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public abstract boolean effectiveBooleanValue(XPathContext var1) throws XPathException;

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public static void listAndComponents(Expression exp, List list) {
        if (exp instanceof BooleanExpression && ((BooleanExpression)exp).getOperator() == 10) {
            Iterator<Expression> iter = exp.iterateSubExpressions();
            while (iter.hasNext()) {
                BooleanExpression.listAndComponents(iter.next(), list);
            }
        } else {
            list.add(exp);
        }
    }
}

