#ifndef ERROR_H
#define ERROR_H

#include "bibtex_ast.h"
#include <ast.h>

#define MAX_ERROR 1024

/*
 * Prototypes for functions exported by error.c but only used within
 * the library -- functions that can be called by outsiders are declared
 * in btparse.h.
 */

void notify (char *format,...);
void content_warning (AST * ast, char *format,...);
void structural_warning (AST * ast, char *format,...);
void lexical_warning (char *format,...);
void lexical_error (char *format,...);
void syntax_error (char *format,...);
void fatal_error (char *format,...);
void internal_error (char *format,...);

#endif
