/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.couchbase.mock.memcached.DataStore;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.views.Configuration;
import org.couchbase.mock.views.View;

public class Mapper {
    private final String body;
    private final ScriptEngine engine;

    public Mapper(ScriptEngine engine, String body) {
        this.engine = engine;
        this.body = body;
    }

    public ArrayList<HashMap> execute(DataStore store, Configuration config) {
        ArrayList<HashMap> rows = new ArrayList<HashMap>();
        for (Map<String, Item> map : store.getData()) {
            for (Map.Entry<String, Item> entry : map.entrySet()) {
                String jsonStr = new String(entry.getValue().getValue());
                try {
                    JSONObject json = JSONObject.fromObject(jsonStr);
                    json.put("_id", entry.getKey());
                    jsonStr = json.toString();
                }
                catch (JSONException ex) {
                    continue;
                }
                try {
                    this.engine.eval("result = []");
                    this.engine.eval("(" + this.body + ")(" + jsonStr + ")");
                    ArrayList result = (ArrayList)View.fromNativeObject(this.engine.get("result"));
                    for (ArrayList row : result) {
                        HashMap<String, Object> document = new HashMap<String, Object>();
                        document.put("id", entry.getKey());
                        document.put("key", row.get(0));
                        document.put("value", row.get(1));
                        if (config.includeDocs()) {
                            Item item = entry.getValue();
                            JSONObject obj = JSONObject.fromObject(new String(item.getValue()));
                            obj.put("$flags", (Object)item.getFlags());
                            obj.put("$exp", (Object)item.getExptime());
                            document.put("doc", obj);
                        }
                        rows.add(document);
                    }
                }
                catch (ScriptException ex) {
                    Logger.getLogger(View.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return rows;
    }
}

