# Generated by default/object.tt
package Paws::MediaLive::EbuTtDDestinationSettings;
  use Moose;
  has CopyrightHolder => (is => 'ro', isa => 'Str', request_name => 'copyrightHolder', traits => ['NameInRequest']);
  has FillLineGap => (is => 'ro', isa => 'Str', request_name => 'fillLineGap', traits => ['NameInRequest']);
  has FontFamily => (is => 'ro', isa => 'Str', request_name => 'fontFamily', traits => ['NameInRequest']);
  has StyleControl => (is => 'ro', isa => 'Str', request_name => 'styleControl', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::EbuTtDDestinationSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::EbuTtDDestinationSettings object:

  $service_obj->Method(Att1 => { CopyrightHolder => $value, ..., StyleControl => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::EbuTtDDestinationSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->CopyrightHolder

=head1 DESCRIPTION

Ebu Tt DDestination Settings

=head1 ATTRIBUTES


=head2 CopyrightHolder => Str

Applies only if you plan to convert these source captions to EBU-TT-D
or TTML in an output. Complete this field if you want to include the
name of the copyright holder in the copyright metadata tag in the TTML


=head2 FillLineGap => Str

Specifies how to handle the gap between the lines (in multi-line
captions). - enabled: Fill with the captions background color (as
specified in the input captions). - disabled: Leave the gap unfilled.


=head2 FontFamily => Str

Specifies the font family to include in the font data attached to the
EBU-TT captions. Valid only if styleControl is set to include. If you
leave this field empty, the font family is set to "monospaced". (If
styleControl is set to exclude, the font family is always set to
"monospaced".) You specify only the font family. All other style
information (color, bold, position and so on) is copied from the input
captions. The size is always set to 100% to allow the downstream player
to choose the size. - Enter a list of font families, as a
comma-separated list of font names, in order of preference. The name
can be a font family (such as E<ldquo>ArialE<rdquo>), or a generic font
family (such as E<ldquo>serifE<rdquo>), or E<ldquo>defaultE<rdquo> (to
let the downstream player choose the font). - Leave blank to set the
family to E<ldquo>monospaceE<rdquo>.


=head2 StyleControl => Str

Specifies the style information (font color, font position, and so on)
to include in the font data that is attached to the EBU-TT captions. -
include: Take the style information (font color, font position, and so
on) from the source captions and include that information in the font
data attached to the EBU-TT captions. This option is valid only if the
source captions are Embedded or Teletext. - exclude: In the font data
attached to the EBU-TT captions, set the font family to "monospaced".
Do not include any other style information.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

