package Net::Async::Spotify::Object::Generated::SavedAlbum;

use strict;
use warnings;

our $VERSION = '0.001'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::SavedAlbum - Package representing Spotify SavedAlbum Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify SavedAlbum Object attributes:

=over 4

=item added_at

Type:Timestamp
Description:The date and time the album was saved
Timestamps are returned in ISO 8601 format as Coordinated Universal Time (UTC) with a zero offset: YYYY-MM-DDTHH:MM:SSZ.
If the time is imprecise (for example, the date/time of an album release), an additional field indicates the precision; see for example, release_date in an album object.

=item album

Type:AlbumObject
Description:Information about the album.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        added_at => 'Timestamp',
        album => 'AlbumObject',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
