### The Blue Dither Component for the bag of the Blue (Dither) Filter

use parent 'OnePassBitmapAlgorithmComponent';

sub new {
    my $class = shift;

    $self = SUPER::OnePassBitmapAlgorithmComponent->new(BagElement1);
    $self = { matrixbitmap => undef, index => -1, };
    
    bless $self, $class;
}

### returns matrix of the changed bitmap matrix
sub getBitmap {
  my $self = shift;

  return $self->{matrixbitmap};
}

sub blueDither {
    my ($self) = @_;
    
    my $ditherobj = MatrixBitmapDitherBlue->new;

    ### NOTE : uses WithClassOp, sets index (the base class only contains 1 idx)
    my $self->{index} = $self->addFunctor(OnePassFunctorWithClassOp->new(&$ditherobj->ditherBlue));
    ### sets class on which this operates
    $self->indexFunctor($i)->setClassOp(\$ditherobj);
}

### only one functor in this component, can be altered with class arithmetics
sub executeAllFunctors {
  my ($self, $matrixbitmapobj) = @_;

    my $resultmatrixobj = $self->indexFunctor($self->{index})->do($matrixbitmapobj);
    
    $self->indexFunctor($self->{index})->setResult($resultmatrixobj);
}

1;
