# Generated by default/object.tt
package Paws::ApplicationMigration::IdentificationHints;
  use Moose;
  has AwsInstanceID => (is => 'ro', isa => 'Str', request_name => 'awsInstanceID', traits => ['NameInRequest']);
  has Fqdn => (is => 'ro', isa => 'Str', request_name => 'fqdn', traits => ['NameInRequest']);
  has Hostname => (is => 'ro', isa => 'Str', request_name => 'hostname', traits => ['NameInRequest']);
  has VmWareUuid => (is => 'ro', isa => 'Str', request_name => 'vmWareUuid', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApplicationMigration::IdentificationHints

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApplicationMigration::IdentificationHints object:

  $service_obj->Method(Att1 => { AwsInstanceID => $value, ..., VmWareUuid => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApplicationMigration::IdentificationHints object:

  $result = $service_obj->Method(...);
  $result->Att1->AwsInstanceID

=head1 DESCRIPTION

Identification hints.

=head1 ATTRIBUTES


=head2 AwsInstanceID => Str

AWS Instance ID identification hint.


=head2 Fqdn => Str

FQDN address identification hint.


=head2 Hostname => Str

Hostname identification hint.


=head2 VmWareUuid => Str

vmWare UUID identification hint.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApplicationMigration>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

