# Contributing to PiFlash

Thanks for contributing to PiFlash! Here are some quick guidelines.

Generally, if you are reporting a problem or offering a suggestion, open an issue. If you have a patch to the code,
submit a pull request. Choose one or the other - it is not necessary to submit an issue for the same thing as a
pull request.

## Code of conduct

A more detailed code of conduct will be selected as more developers join the PiFlash project.
To set inital expectations, we'll use the [Contributor Covenant v1.4](https://www.contributor-covenant.org/version/1/4/code-of-conduct).
This expectation applies both ways, and should be used as a gentle reminder to contributors or developers as needed.

The point of a code of conduct in an Open Source software project is to avoid an unstructured environment where
the last loud bully standing always wins, after they've caused others to give up and go away.
Like it or not, that's human nature - if you allow it by having no standards of behavior, someone *will* do that.
Even before the Internet, this trend was documented in the 1970s in "[The Tyranny of Structurelessness](https://en.wikipedia.org/wiki/The_Tyranny_of_Structurelessness)".
It is not a new problem.

## Submitting an issue

If you're having a problem with PiFlash, try to describe enough so it will be possible for others to understand
what the problem is, and how to duplicate it on their systems. For example, show what happened and tell how that
differs from what you expected to happen. A description of your system hardware is helpful,
and that can be accomplished by attaching a file with the output of PiFlash's --verbose flag. Be sure to look
through the verbose output and remove any private info that you don't want posted in public. It's helpful to know
where something was removed - a good way to communicate that is to replace removed text with the string "[redacted]".

New issues can be submitted at https://github.com/ikluft/piflash/issues

Be ready to answer questions about the issue if necessary.

## Submitting a Pull Request

Generally the idea behind a pull request is to fork the repository, make your changes in a branch named to
describe the changes, and submit it to the project. Be sure to describe the purpose of the change first.
If anything is obscure about the change, explain it.
Before it can be accepted, it will be reviewed.
Any description, documentation and tests necessary for that may help speed it along.

GitHub has help on creating pull requerts at https://help.github.com/articles/creating-a-pull-request/

New pull requests can be submitted at https://github.com/ikluft/piflash/pulls

Be ready to answer questions about the pull request if necessary.
