use strict;
use warnings;
use Config;
use Devel::CheckLib;
use ExtUtils::MakeMaker;

# buffering will ruin your day!
select STDERR; $|=1;
select STDOUT; $|=1;

# prereqs
my $CONF_version = 0;      # Config
my $EX_version   = 0;      # Exporter
my $DL_version   = 0;      # DynaLoader
my $TM_version   = '0.88'; # Test::More
my $DC_version   = '1.14'; # Devel::CheckLib
my $EUMM_version = '6.64'; # ExtUtils::MakeMaker
my $FT_version   = '0.10'; # File::Temp

my $UUID_version = get_uuidpm_version();

# Authority poisons everybody who takes
# authority on himself.
#                     -- Vladimir Lenin
my $no_mymeta = ($UUID_version =~ /_/) ? 1 : 0;

my $defines     = check_defines();
my $has_threads = check_threads();

WriteMakefile1(
    'NAME'             => 'UUID',
    'AUTHOR'           => 'Rick Myers <jrm@cpan.org>',
    'VERSION_FROM'     => 'UUID.pm',
    'ABSTRACT_FROM'    => 'UUID.pm',
    'LICENSE'          => 'artistic_2',
    'MIN_PERL_VERSION' => '5.005',
    'LIBS'             => '',
    'NO_MYMETA'        => $no_mymeta,
    'INC'              => '-I.',
    'CCFLAGS'          => $Config{ccflags},
    'DEFINE'           => $defines,
    'OBJECT'           => '$(O_FILES)',
    'LDFROM'           => join( ' ', qw{
        UUID.o uulib/chacha.o uulib/clear.o uulib/clock.o
        uulib/compare.o uulib/copy.o uulib/gen.o uulib/gettime.o
        uulib/isnull.o uulib/node.o uulib/pack.o uulib/parse.o
        uulib/splitmix.o uulib/unpack.o uulib/unparse.o uulib/util.o
        uulib/xoshiro.o
    }),
    'C' => [qw{
        UUID.c uulib/chacha.c uulib/clear.c uulib/clock.c
        uulib/compare.c uulib/copy.c uulib/gen.c uulib/gettime.c
        uulib/isnull.c uulib/node.c uulib/pack.c uulib/parse.c
        uulib/splitmix.c uulib/unpack.c uulib/unparse.c uulib/util.c
        uulib/xoshiro.c
    }],
    'H' => [qw{
        uulib/CONF.h uulib/EUMM.h uulib/TYPE.h uulib/chacha.h
        uulib/clear.h uulib/clock.h uulib/compare.h uulib/copy.h
        uulib/isnull.h uulib/gen.h uulib/gettime.h uulib/node.h
        uulib/pack.h uulib/parse.h uulib/splitmix.h uulib/unpack.h
        uulib/unparse.h uulib/util.h uulib/xoshiro.h
    }],
    'PREREQ_PM'          => {
        'DynaLoader' => $DL_version,
        'Exporter'   => $EX_version,
        'strict'     => 0,
        'vars'       => 0,
        'warnings'   => 0,
    },
    'CONFIGURE_REQUIRES' => {
        'Config'              => $CONF_version,
        'Devel::CheckLib'     => $DC_version,
        'ExtUtils::MakeMaker' => $EUMM_version,
        'File::Spec'          => 0,
        'strict'              => 0,
        'warnings'            => 0,
    },
    'BUILD_REQUIRES' => {
        'Config'              => $CONF_version,
        'Devel::CheckLib'     => $DC_version,
        'ExtUtils::MakeMaker' => $EUMM_version,
        'File::Temp'          => $FT_version,,
        'strict'              => 0,
        'warnings'            => 0,
    },
    'TEST_REQUIRES' => {
        'Benchmark'          => 0,
        'CPAN::Meta'         => 0,
        'DynaLoader'         => $DL_version,
        'Exporter'           => $EX_version,
        'ExtUtils::Manifest' => 0,
        'File::Temp'         => $FT_version,
        'Test::More'         => $TM_version,
        'Time::HiRes'        => 0,
        'Try::Tiny'          => 0,
        'lib'                => 0,
        'strict'             => 0,
        'vars'               => 0,
        'warnings'           => 0,
        ( $has_threads
            ? (
            'threads'         => 0,
            'threads::shared' => 0,
            )
            : ()
        ),
    },
    'META_MERGE' => {
        'dynamic_config' => 0,
        'provides' => {
            'UUID' => {
                'file'    => 'UUID.pm',
                'version' => $UUID_version,
            },
        },
    },
    'realclean' => {
        'FILES' => join( ' ', sort qw{
            LICENSE_new
            META_new.json
            META_new.yml
            README_new
            README_new.bak
            UUID.obj
            UUID.pdb
            UUID.xsc
            assertconf*.h
            assertlib*.c
            assertlib*.exe
            assertlib*.obj
            asserttest*
            perl.core
            perl.exe.stackdump
            uulib/*.obj
            uulib/*.pdb
            uulib/EUMM.h
        }),
    },
);

exit 0;

sub WriteMakefile1 {  #Written by Alexandr Ciornii, version 0.21. Added by eumm-upgrade.
    my %params=@_;
    my $eumm_version=$ExtUtils::MakeMaker::VERSION;
    $eumm_version=eval $eumm_version;
    die "EXTRA_META is deprecated" if exists $params{EXTRA_META};
    die "LICENSE not specified" if not exists $params{LICENSE};
    if ($params{BUILD_REQUIRES} and $eumm_version < 6.5503) {
        #EUMM 6.5502 has problems with BUILD_REQUIRES
        $params{PREREQ_PM}={ %{$params{PREREQ_PM} || {}} , %{$params{BUILD_REQUIRES}} };
        delete $params{BUILD_REQUIRES};
    }
    delete $params{TEST_REQUIRES} if $eumm_version < 6.64;
    delete $params{CONFIGURE_REQUIRES} if $eumm_version < 6.52;
    delete $params{MIN_PERL_VERSION} if $eumm_version < 6.48;
    delete $params{META_MERGE} if $eumm_version < 6.46;
    delete $params{META_ADD} if $eumm_version < 6.46;
    delete $params{LICENSE} if $eumm_version < 6.31;
    delete $params{NO_MYMETA} if $eumm_version < 6.58;
    delete $params{AUTHOR} if $] < 5.005;
    delete $params{ABSTRACT_FROM} if $] < 5.005;
    delete $params{BINARY_LOCATION} if $] < 5.005;

    WriteMakefile(%params);
}

sub get_uuidpm_version {
    open my $fh, '<', 'UUID.pm' or die "open: UUID.pm: $!";
    while (<$fh>) {
        # $VERSION = '0.30_02';
        return $1
            if /^\$VERSION = '([\d\.\_]+)';$/;
    }
    return undef;
}

sub check_defines {
    my $defs = [];
    my $long = 0;

    for my $check ( 1, 0 ) {

        # this is to turn off the copious amount of spewage seen compiling
        # xs code on freebsd.
        # WISHLIST: would be nice if we could inspect the compiler output
        # from building the test file. would like to see if there was a
        # "unsupported command line option" warning. looks like it would
        # be a good bit of work though.
        try_ccflag($check, \$long, $defs, '-Wno-compound-token-split-by-macro');
        #... more ?
    }

    return join ' ', @$defs;
}

sub check_threads {
    # return true/false
    $Config{useithreads} ? 1 : 0;
}

sub try_ccflag {
    my ($check, $long, $flags, $try) = @_;
    my $msg = join ' ', 'Checking compound token switch';
    my $len = length $msg;
    if ($check) { $$long = $len if $len > $$long; return; }
    my $more = $$long - $len;
    if ( check_lib(
        lib     => 'c', # always do at least this
        ccflags => $try,
        debug   => 0,
    )) {
        push @$flags, $try;
        print $msg, ' ..', '.'x$more, " works\n";
    }
    else {
        print $msg, ' ..', '.'x$more, " fails\n";
    }
}



package MY;
use Config;


#
# some of the commented stuff below is just too dangerous
# to fool with just to satisfy ocd.
#

# make order:
#   pm_to_blib
#   config
#   xsubpp & Mkbootstrap
#   c files


#
# add 'compare' target.
#
sub top_targets {
    my $t = shift->SUPER::top_targets(@_);
    $t .= "\ncompare : dynamic pure_all\n";
    $t .= "\t\$(ABSPERLRUN) -Iblib\$(DFSEP)lib -Iblib\$(DFSEP)arch util\$(DFSEP)bench_cmp.pl 1\n";
    $t;
}


##
## stop rebuilding manifypods.
## hold manifypods until later.
##
#sub manifypods {
#    my $t = shift->SUPER::manifypods(@_);
#    return $t if $t =~ /NOOP/;
#    # dont manifypods every.single.time.
#    $t =~ s{\\$}{\\\n\t\$(INST_MAN3DIR)/UUID.\$(MAN3EXT)\n\n\$(INST_MAN3DIR)/UUID.\$(MAN3EXT): \\}ms;
#    # delay manifypods until after lib build
#    $t =~ s{UUID\.pm$}{UUID.pm \$(INST_DYNAMIC)}ms;
#    $t;
#}


#
# add distlicense and distreadme prereqs.
## silence manicopy step during config.
#
sub distdir {
    my $t = shift->SUPER::distdir(@_);
    $t =~ s{^(distdir :).*$}{$1 create_distdir license metafile readme distlicense distmeta distreadme}m;
    #$t =~ s{PERLRUN}{NOECHO) \$(PERLRUN};
    $t;
}


#
# remove metafile comments in manifest.
# make metafiles authoritative to cpan.
#
sub distmeta {
    my $t = <<'EOS';
distmeta : create_distdir license metafile readme
	$(NOECHO) $(ECHO) Adding META.json to MANIFEST
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd \
	  -e "die 'No META.json' unless -f 'META.json';" \
	  -e "die 'No MANIFEST' unless -f 'MANIFEST';" \
	  -e "eval { maniadd({ 'META.json' => '' }) }" \
	  -e "    or die \"Could not add META.json to MANIFEST: $$ @\"" --
	$(NOECHO) $(ECHO) Adding META.yml to MANIFEST
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd \
	  -e "die 'No META.yml' unless -f 'META.yml';" \
	  -e "die 'No MANIFEST' unless -f 'MANIFEST';" \
	  -e "eval { maniadd({ 'META.yml' => '' }) }" \
	  -e "    or die \"Could not add META.yml to MANIFEST: $$ @\"" --
EOS
    $t;
}


#
# re-order meta generation
#
sub metafile {
    my $t = shift->SUPER::metafile_target(@_);
    $t =~ s{^(metafile :.*)$} {$1 meta_json meta_yml}m;
    $t =~ s{^(\s+.+Generating META.yml.*)$}  {\nmeta_yml :\n$1}m;
    $t =~ s{^(\s+.+Generating META.json.*)$} {\nmeta_json :\n$1}m;
    $t;
}


#
# add UUID_DISTTEST flag to 'make disttest'
#
sub dist_test {
    my $t = shift->SUPER::dist_test(@_);
    $t =~ s{ test }{ test UUID_DISTTEST=1 };
    $t;
}


#
# make TEST_VERBOSE=1 when AUTOMATED_TESTING=1.
# add t/*/*.t to tests.
# add TEST_LIB variable, set to t/lib.
# insert TEST_LIB before other libs.
#
sub test {
    my $t = shift->SUPER::test(@_);
    #
    # make TEST_VERBOSE=1 when AUTOMATED_TESTING=1.
    if ( $ENV{AUTOMATED_TESTING}
        or $ENV{NONINTERACTIVE_TESTING}
        or $ENV{PERL_CPAN_REPORTER_CONFIG}
    ) {
        $t =~ s{TEST_VERBOSE=0}{TEST_VERBOSE=1}msg;
    }
    #
    # add t/*/*.t to tests.
    $t =~ s{^(TEST_FILES\s*=\s*).+$} {$1 t\$(DFSEP)*.t t\$(DFSEP)*\$(DFSEP)*.t}m;
    #
    # add TEST_LIB variable, set to t/lib.
    $t =~ s{^} {TEST_LIB=t\$(DFSEP)0LIB\n}s;
    #
    # insert TEST_LIB before other libs.
    $t =~ s{(\S+)(INST_LIB)(\S+)} {${1}TEST_LIB$3 $1$2$3}g;
    $t;
}


#
# silence "cp_nonempty" bootstrap.
# silence chmod bootstrap.
# remove implicit rules and make our own!
# (some seem to use the implicits first?)
#
sub xs_c { '' }
sub xs_o { '' }
sub dynamic_bs {
    my $t = shift->SUPER::dynamic_bs(@_);
    # delay Mkbootstrap() until after configure
    $t =~ s{^(\S+\s*:\s+.+$)} {$1 \$(uulib_EUMM).h}m;
    $t;
}
sub perldepend {
    my $t = shift->SUPER::perldepend(@_);
    # make UUID.c depend on UUID.xs and EUMM.h
    $t =~ s{$} { UUID.xs \$(uulib_EUMM).h}s;
    # run xsubpp
    $t .= "\t". '$(XSUBPPRUN) $(XSPROTOARG) $(XSUBPPARGS) $(XSUBPP_EXTRA_ARGS) UUID.xs > UUID.xsc'. "\n";
    $t .= "\t". '$(MV) UUID.xsc UUID.c';
    $t;
}


#
# remove targets in dynamic_lib section. we do them manually later.
#
sub dynamic_lib {
    my $t = shift->SUPER::dynamic_lib(@_);
    $t =~ s{\n\n.+$} {\n}ms;
    $t;
}


#
# our variables
#
sub post_constants {
    my $t = shift->SUPER::post_constants(@_);
    $t .= <<'EOPC';
ubin_configure = ubin$(DFSEP)configure.pl
uulib_CONF     = uulib$(DFSEP)CONF
uulib_EUMM     = uulib$(DFSEP)EUMM
uulib_TYPE     = uulib$(DFSEP)TYPE
uulib_chacha   = uulib$(DFSEP)chacha
uulib_clear    = uulib$(DFSEP)clear
uulib_clock    = uulib$(DFSEP)clock
uulib_compare  = uulib$(DFSEP)compare
uulib_copy     = uulib$(DFSEP)copy
uulib_gen      = uulib$(DFSEP)gen
uulib_gettime  = uulib$(DFSEP)gettime
uulib_isnull   = uulib$(DFSEP)isnull
uulib_node     = uulib$(DFSEP)node
uulib_pack     = uulib$(DFSEP)pack
uulib_parse    = uulib$(DFSEP)parse
uulib_splitmix = uulib$(DFSEP)splitmix
uulib_unpack   = uulib$(DFSEP)unpack
uulib_unparse  = uulib$(DFSEP)unparse
uulib_util     = uulib$(DFSEP)util
uulib_xoshiro  = uulib$(DFSEP)xoshiro
EOPC
    $t;
}


#
# add distlicense and distreadme targets.
# add autoconf generated targets.
# add explicit object rules.
#
sub postamble {
    my $pa = <<'EOP';
# Software::License requires perl-5.12.0
license: create_distdir
	$(NOECHO) $(ECHO) Generating LICENSE
	$(NOECHO) $(RM_F) LICENSE_new
	$(NOECHO) $(ABSPERLRUN) -M5.12.0 -MSoftware::License::Artistic_2_0 \
	  -e 'print Software::License::Artistic_2_0->new({holder => "Rick Myers", year => sprintf("2014-%04d", 1900+(localtime(time))[5])})->fulltext' \
	  > LICENSE_new
	$(NOECHO) $(MV) LICENSE_new $(DISTVNAME)$(DFSEP)LICENSE

distlicense: create_distdir license
	$(NOECHO) $(ECHO) Adding LICENSE to MANIFEST
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd \
	  -e "die 'No LICENSE' unless -f 'LICENSE';" \
	  -e "die 'No MANIFEST' unless -f 'MANIFEST';" \
	  -e "eval { maniadd({ 'LICENSE' => '' }) }" \
	  -e "    or die \"Could not add LICENSE to MANIFEST: $$ @\"" --
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -e "print sort <>" MANIFEST > MANIFEST_new
	$(NOECHO) $(MV) $(DISTVNAME)$(DFSEP)MANIFEST_new $(DISTVNAME)$(DFSEP)MANIFEST

readme: create_distdir
	$(NOECHO) $(ECHO) Generating README
	$(NOECHO) $(RM_F) README_new
	$(NOECHO) pod2text UUID.pm README_new
	$(NOECHO) $(ABSPERLRUN) -i.bak -pe's{\*(\S+)\*}{\1}g' README_new
	$(NOECHO) $(RM_F) README_new.bak
	$(NOECHO) $(MV) README_new $(DISTVNAME)$(DFSEP)README

distreadme: create_distdir readme
	$(NOECHO) $(ECHO) Adding README to MANIFEST
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd \
	  -e "die 'No README' unless -f 'README';" \
	  -e "die 'No MANIFEST' unless -f 'MANIFEST';" \
	  -e "eval { maniadd({ 'README' => '' }) }" \
	  -e "    or die \"Could not add README to MANIFEST: $$ @\"" --
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -e "print sort <>" MANIFEST > MANIFEST_new
	$(NOECHO) $(MV) $(DISTVNAME)$(DFSEP)MANIFEST_new $(DISTVNAME)$(DFSEP)MANIFEST

config :: $(FIRST_MAKEFILE) $(ubin_configure) pm_to_blib $(uulib_EUMM).h
	$(NOECHO) $(NOOP)

deps = $(XSUBPPDEPS)
cccmd = $(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE)


$(uulib_EUMM).h     : pm_to_blib $(ubin_configure)
	$(NOECHO) $(ECHO) Generating EUMM.h
	$(NOECHO) $(RM_F) $(uulib_EUMM).h      $(uulib_EUMM).h.tmp
	$(NOECHO) $(PERL) -l $(ubin_configure) $(uulib_EUMM).h.tmp
	$(NOECHO) $(MV)   $(uulib_EUMM).h.tmp  $(uulib_EUMM).h


UUID.obj              : UUID.c
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb $*.c

$(uulib_chacha).obj   : $(uulib_chacha).c $(uulib_chacha).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_clear).obj    : $(uulib_clear).c $(uulib_clear).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_clock).obj    : $(uulib_clock).c $(uulib_clock).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_compare).obj  : $(uulib_compare).c $(uulib_compare).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_copy).obj     : $(uulib_copy).c $(uulib_copy).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_gen).obj      : $(uulib_gen).c $(uulib_gen).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_gettime).obj  : $(uulib_gettime).c $(uulib_gettime).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_isnull).obj   : $(uulib_isnull).c $(uulib_isnull).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_node).obj     : $(uulib_node).c $(uulib_node).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_pack).obj     : $(uulib_pack).c $(uulib_pack).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_parse).obj    : $(uulib_parse).c $(uulib_parse).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_splitmix).obj : $(uulib_splitmix).c $(uulib_splitmix).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_unpack).obj   : $(uulib_unpack).c $(uulib_unpack).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_unparse).obj  : $(uulib_unparse).c $(uulib_unparse).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_util).obj     : $(uulib_util).c $(uulib_util).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c

$(uulib_xoshiro).obj  : $(uulib_xoshiro).c $(uulib_xoshiro).h
	$(CCCMD) $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -Fd$(*).pdb -Fo$(*).obj $*.c


UUID.o              : $(deps) UUID.c
	$(cccmd) UUID.c              -o UUID.o

$(uulib_chacha).o   : $(uulib_chacha).c $(uulib_chacha).h
	$(cccmd) $(uulib_chacha).c   -o $(uulib_chacha).o

$(uulib_clear).o    : $(uulib_clear).c    $(uulib_clear).h
	$(cccmd) $(uulib_clear).c    -o $(uulib_clear).o

$(uulib_clock).o    : $(uulib_clock).c    $(uulib_clock).h
	$(cccmd) $(uulib_clock).c    -o $(uulib_clock).o

$(uulib_compare).o  : $(uulib_compare).c  $(uulib_compare).h
	$(cccmd) $(uulib_compare).c  -o $(uulib_compare).o

$(uulib_copy).o     : $(uulib_copy).c     $(uulib_copy).h
	$(cccmd) $(uulib_copy).c     -o $(uulib_copy).o

$(uulib_gen).o      : $(uulib_gen).c      $(uulib_gen).h
	$(cccmd) $(uulib_gen).c      -o $(uulib_gen).o

$(uulib_gettime).o  : $(uulib_gettime).c  $(uulib_gettime).h
	$(cccmd) $(uulib_gettime).c  -o $(uulib_gettime).o

$(uulib_isnull).o   : $(uulib_isnull).c   $(uulib_isnull).h
	$(cccmd) $(uulib_isnull).c   -o $(uulib_isnull).o

$(uulib_node).o     : $(uulib_node).c     $(uulib_node).h
	$(cccmd) $(uulib_node).c     -o $(uulib_node).o

$(uulib_pack).o     : $(uulib_pack).c     $(uulib_pack).h
	$(cccmd) $(uulib_pack).c     -o $(uulib_pack).o

$(uulib_parse).o    : $(uulib_parse).c    $(uulib_parse).h
	$(cccmd) $(uulib_parse).c    -o $(uulib_parse).o

$(uulib_splitmix).o : $(uulib_splitmix).c $(uulib_splitmix).h
	$(cccmd) $(uulib_splitmix).c -o $(uulib_splitmix).o

$(uulib_unpack).o   : $(uulib_unpack).c   $(uulib_unpack).h
	$(cccmd) $(uulib_unpack).c   -o $(uulib_unpack).o

$(uulib_unparse).o  : $(uulib_unparse).c  $(uulib_unparse).h
	$(cccmd) $(uulib_unparse).c  -o $(uulib_unparse).o

$(uulib_util).o     : $(uulib_util).c     $(uulib_util).h
	$(cccmd) $(uulib_util).c     -o $(uulib_util).o

$(uulib_xoshiro).o  : $(uulib_xoshiro).c  $(uulib_xoshiro).h
	$(cccmd) $(uulib_xoshiro).c  -o $(uulib_xoshiro).o


EOP

    if ($Config{make} eq 'nmake') {
        $pa .= <<'EOP';
$(INST_DYNAMIC) : \
	UUID.obj \
	uulib/chacha.obj \
	uulib/clear.obj \
	uulib/clock.obj \
	uulib/compare.obj \
	uulib/copy.obj \
	uulib/copy.obj \
	uulib/gen.obj \
	uulib/gettime.obj \
	uulib/isnull.obj \
	uulib/node.obj \
	uulib/pack.obj \
	uulib/parse.obj \
	uulib/splitmix.obj \
	uulib/unpack.obj \
	uulib/unparse.obj \
	uulib/util.obj \
	uulib/xoshiro.obj \
	$(INST_ARCHAUTODIR)$(DFSEP).exists $(EXPORT_LIST) \
	$(PERL_ARCHIVEDEP) $(INST_DYNAMIC_DEP)
	$(LD) -out:$@ $(LDDLFLAGS) \
	UUID.obj \
	uulib/chacha.obj \
	uulib/clear.obj \
	uulib/clock.obj \
	uulib/compare.obj \
	uulib/copy.obj \
	uulib/gen.obj \
	uulib/gettime.obj \
	uulib/isnull.obj \
	uulib/node.obj \
	uulib/pack.obj \
	uulib/parse.obj \
	uulib/splitmix.obj \
	uulib/unpack.obj \
	uulib/unparse.obj \
	uulib/util.obj \
	uulib/xoshiro.obj \
	$(OTHERLDFLAGS) $(MYEXTLIB) "$(PERL_ARCHIVE)" $(LDLOADLIBS) \
	-def:$(EXPORT_LIST)
	if exist $@.manifest mt -nologo -manifest $@.manifest -outputresource:$@;2
	if exist $@.manifest del $@.manifest
	$(CHMOD) $(PERM_RWX) $@
EOP
    }
    else {
        $pa .= <<'EOP';
$(INST_DYNAMIC) : $(OBJECT) $(MYEXTLIB) $(INST_ARCHAUTODIR)$(DFSEP).exists \
	$(EXPORT_LIST) $(PERL_ARCHIVEDEP) $(PERL_ARCHIVE_AFTER) $(INST_DYNAMIC_DEP)
	$(RM_F) $@
	$(LD) $(LDDLFLAGS) $(LDFROM) $(OTHERLDFLAGS) -o $@ $(MYEXTLIB) \
	  $(PERL_ARCHIVE) $(LDLOADLIBS) $(PERL_ARCHIVE_AFTER) $(EXPORT_LIST) \
	  $(INST_DYNAMIC_FIX)
	$(CHMOD) $(PERM_RWX) $@
EOP
    }

    return $pa;
}
