# Generated by default/object.tt
package Paws::CloudFront::FunctionMetadata;
  use Moose;
  has CreatedTime => (is => 'ro', isa => 'Str');
  has FunctionARN => (is => 'ro', isa => 'Str', required => 1);
  has LastModifiedTime => (is => 'ro', isa => 'Str', required => 1);
  has Stage => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::FunctionMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::FunctionMetadata object:

  $service_obj->Method(Att1 => { CreatedTime => $value, ..., Stage => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::FunctionMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedTime

=head1 DESCRIPTION

Contains metadata about a CloudFront function.

=head1 ATTRIBUTES


=head2 CreatedTime => Str

The date and time when the function was created.


=head2 B<REQUIRED> FunctionARN => Str

The Amazon Resource Name (ARN) of the function. The ARN uniquely
identifies the function.


=head2 B<REQUIRED> LastModifiedTime => Str

The date and time when the function was most recently updated.


=head2 Stage => Str

The stage that the function is in, either C<DEVELOPMENT> or C<LIVE>.

When a function is in the C<DEVELOPMENT> stage, you can test the
function with C<TestFunction>, and update it with C<UpdateFunction>.

When a function is in the C<LIVE> stage, you can attach the function to
a distributionE<rsquo>s cache behavior, using the functionE<rsquo>s
ARN.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

