use warnings;
use strict;

package RT::Extension::Nagios;

our $VERSION = '1.00';

1;

=head1 NAME

RT::Extension::Nagios - Merge and resolve Nagios tickets

=head1 DESCRIPTION

L<Nagios|http://www.nagios.org> is a powerful monitoring system that
enables organizations to identify and resolve IT infrastructure problems
before they affect critical business processes.

This extension allows email alerts generated by Nagios to be aggregated
and resolved as it generates them.  It does this by examining the
standard subject line that Nagios generates; by default, these take the form:

    PROBLEM Service Alert: localhost/Root Partition is WARNING

There are 5 useful parts in subject; we call them C<type>, C<category>,
C<host>, C<problem_type> and C<problem_severity>.  These are parsed from
the subject via a regular expression; in the above example, the
extension would extract:

    type:             PROBLEM
    category:         Service
    host:             localhost
    problem_type:     Root Partition
    problem_severity: WARNING

After the new ticket is created, the following is done:

=over

=item 1.

Find all the other active tickets in the same queue with the same values
of C<category>, C<host> and C<problem_type>.  If the configuration
setting C<NagiosSearchAllQueues> is set (see below), all queues are
searched.

=item 2.

If the configuration setting C<NagiosMergeTickets> is set (see below),
merge all matching tickets.

=item 3.

If C<type> is 'RECOVERY', resolve them.

=back

=head1 INSTALLATION

=over

=item C<perl Makefile.PL>

=item C<make>

=item C<make install>

May need root permissions

=item C<make initdb>

Only run this the first time you install this module.

If you run this twice, you may end up with duplicate data
in your database.

If you are upgrading this module, check for upgrading instructions
in case changes need to be made to your database.

=item Edit your F</opt/rt4/etc/RT_SiteConfig.pm>

If you are using RT 4.2 or greater, add this line:

    Plugin('RT::Extension::Nagios');

For RT 4.0, add this line:

    Set(@Plugins, qw(RT::Extension::Nagios));

or add C<RT::Extension::Nagios> to your existing C<@Plugins> line.

=item Restart your webserver

=back

=head1 CONFIGURATION

This extension has three configuration settings; setting them should be
done in C<RT_SiteConfig.pm>.

=over

=item C<NagiosSearchAllQueues>

If set, this causes step 1, above, to search for matching Nagios tickets
in an queue.  In most configurations, Nagios notifications will arrive
in one queue, and remain there.  If your workflow involves triaging
Nagios notifications from there into other queues, you will want to set:

   Set( $NagiosSearchAllQueues, 1 );

=item C<NagiosMergeTickets>

Controls if the extensions merges tickets about the same incident
together.  By default, each C<PROBLEM>, C<ACKNOWLEDGEMENT>, and
C<RECOVERY> notification will remain as its own ticket; when the
C<RECOVERY> email is received by RT, all will be resolved.

Setting this configuration parameter to C<1> causes the extension to
merge all old tickets on the same topic into new tickets as they arrive;
as such, the C<Created> date will respect the most recent message.

Setting it to C<-1> causes the extension to merge new tickets into any
existing tickets as they arrive; the C<Created> date will respect the
oldest message, and the ticket ID will remain constant:

    Set( $NagiosMergeTickets, -1 );

=item C<NagiosResolvedStatus>

Since RT allows for custom lifecycles on queues, this extension's
default of setting tickets to C<Resolved> upon C<RECOVERY> may be
incorrect for the queue they are in.  If the queue your Nagios tickets
reside in does not have a C<Resolved> status, or you would like tickets
to be transitioned to a different status on C<RECOVERY>, set
C<NagiosResolvedStatus>:

    Set( $NagiosResolvedStatus, 'recovered' );

=back

=head1 AUTHOR

Best Practical Solutions, LLC E<lt>modules@bestpractical.comE<gt>

Based on work by Todd Chapman.

=head1 BUGS

All bugs should be reported via email to

    L<bug-RT-Extension-Nagios@rt.cpan.org|mailto:bug-RT-Extension-Nagios@rt.cpan.org>

or via the web at

    L<rt.cpan.org|http://rt.cpan.org/Public/Dist/Display.html?Name=RT-Extension-Nagios>.

=head1 LICENSE AND COPYRIGHT

This software is Copyright (c) 2014 by Best Practical Solutions

This is free software, licensed under:

  The GNU General Public License, Version 2, June 1991

=cut
