/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.Color;
import java.awt.Paint;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDPatternResources;

public class PDColorState
implements Cloneable {
    private static final Log LOG = LogFactory.getLog(PDColorState.class);
    private static volatile Color iccOverrideColor = Color.getColor("org.apache.pdfbox.ICC_override_color");
    private PDColorSpace colorSpace = new PDDeviceGray();
    private COSArray colorSpaceValue = new COSArray();
    private PDPatternResources pattern = null;
    private Color color = null;
    private Paint paint = null;

    public static void setIccOverrideColor(Color color) {
        iccOverrideColor = color;
    }

    public PDColorState() {
        this.setColorSpaceValue(new float[]{0.0f});
    }

    public Object clone() {
        PDColorState retval = new PDColorState();
        retval.colorSpace = this.colorSpace;
        retval.colorSpaceValue.clear();
        retval.colorSpaceValue.addAll(this.colorSpaceValue);
        retval.setPattern(this.getPattern());
        return retval;
    }

    public Color getJavaColor() throws IOException {
        if (this.color == null && this.colorSpaceValue.size() > 0) {
            this.color = this.createColor();
        }
        return this.color;
    }

    public Paint getPaint(int pageHeight) throws IOException {
        if (this.paint == null && this.pattern != null) {
            this.paint = this.pattern.getPaint(pageHeight);
        }
        return this.paint;
    }

    private Color createColor() throws IOException {
        float[] components = this.colorSpaceValue.toFloatArray();
        try {
            if (this.colorSpace.getName().equals("DeviceRGB") && components.length == 3) {
                return new Color(components[0], components[1], components[2]);
            }
            if (components.length == 1) {
                if (this.colorSpace.getName().equals("Separation")) {
                    return new Color((int)components[0]);
                }
                if (this.colorSpace.getName().equals("DeviceGray")) {
                    return new Color(components[0], components[0], components[0]);
                }
            }
            Color override = iccOverrideColor;
            ColorSpace cs = this.colorSpace.getJavaColorSpace();
            if (cs instanceof ICC_ColorSpace && override != null) {
                LOG.warn("Using an ICC override color to avoid a potential JVM crash (see PDFBOX-511)");
                return override;
            }
            return new Color(cs, components, 1.0f);
        }
        catch (Exception e) {
            Color cGuess;
            String sMsg = "Unable to create the color instance " + Arrays.toString(components) + " in color space " + this.colorSpace + "; guessing color ... ";
            try {
                switch (components.length) {
                    case 1: {
                        cGuess = new Color((int)components[0]);
                        sMsg = sMsg + "\nInterpretating as single-integer RGB";
                        break;
                    }
                    case 3: {
                        cGuess = new Color(components[0], components[1], components[2]);
                        sMsg = sMsg + "\nInterpretating as RGB";
                        break;
                    }
                    case 4: {
                        float k = components[3];
                        float r = components[0] * (1.0f - k) + k;
                        float g = components[1] * (1.0f - k) + k;
                        float b = components[2] * (1.0f - k) + k;
                        r = 1.0f - r;
                        g = 1.0f - g;
                        b = 1.0f - b;
                        cGuess = new Color(r, g, b);
                        sMsg = sMsg + "\nInterpretating as CMYK";
                        break;
                    }
                    default: {
                        sMsg = sMsg + "\nUnable to guess using " + components.length + " components; using black instead";
                        cGuess = Color.BLACK;
                        break;
                    }
                }
            }
            catch (Exception e2) {
                sMsg = sMsg + "\nColor interpolation failed; using black instead\n";
                sMsg = sMsg + e2.toString();
                cGuess = Color.BLACK;
            }
            LOG.warn(sMsg, e);
            return cGuess;
        }
    }

    public PDColorState(COSArray csValues) {
        this.colorSpaceValue = csValues;
    }

    public PDColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(PDColorSpace value) {
        this.colorSpace = value;
        this.color = null;
        this.pattern = null;
    }

    public float[] getColorSpaceValue() {
        return this.colorSpaceValue.toFloatArray();
    }

    public COSArray getCOSColorSpaceValue() {
        return this.colorSpaceValue;
    }

    public void setColorSpaceValue(float[] value) {
        this.colorSpaceValue.setFloatArray(value);
        this.color = null;
        this.pattern = null;
    }

    public PDPatternResources getPattern() {
        return this.pattern;
    }

    public void setPattern(PDPatternResources patternValue) {
        this.pattern = patternValue;
        this.color = null;
    }
}

