/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image;

import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataAdapter;

public class ImgDataConverter
extends ImgDataAdapter
implements BlkImgDataSrc {
    private DataBlk srcBlk = new DataBlkInt();
    private BlkImgDataSrc src;
    private int fp;

    public ImgDataConverter(BlkImgDataSrc imgSrc, int fp) {
        super(imgSrc);
        this.src = imgSrc;
        this.fp = fp;
    }

    public ImgDataConverter(BlkImgDataSrc imgSrc) {
        super(imgSrc);
        this.src = imgSrc;
        this.fp = 0;
    }

    public int getFixedPoint(int c) {
        return this.fp;
    }

    public DataBlk getCompData(DataBlk blk, int c) {
        return this.getData(blk, c, false);
    }

    public final DataBlk getInternCompData(DataBlk blk, int c) {
        return this.getData(blk, c, true);
    }

    private DataBlk getData(DataBlk blk, int c, boolean intern) {
        DataBlk reqBlk;
        int otype = blk.getDataType();
        if (otype == this.srcBlk.getDataType()) {
            reqBlk = blk;
        } else {
            reqBlk = this.srcBlk;
            reqBlk.ulx = blk.ulx;
            reqBlk.uly = blk.uly;
            reqBlk.w = blk.w;
            reqBlk.h = blk.h;
        }
        this.srcBlk = intern ? this.src.getInternCompData(reqBlk, c) : this.src.getCompData(reqBlk, c);
        if (this.srcBlk.getDataType() == otype) {
            return this.srcBlk;
        }
        int w = this.srcBlk.w;
        int h = this.srcBlk.h;
        switch (otype) {
            case 4: {
                float[] farr = (float[])blk.getData();
                if (farr == null || farr.length < w * h) {
                    farr = new float[w * h];
                    blk.setData(farr);
                }
                blk.scanw = this.srcBlk.w;
                blk.offset = 0;
                blk.progressive = this.srcBlk.progressive;
                int[] srcIArr = (int[])this.srcBlk.getData();
                this.fp = this.src.getFixedPoint(c);
                if (this.fp != 0) {
                    float mult = 1.0f / (float)(1 << this.fp);
                    int k = w * h - 1;
                    int kSrc = this.srcBlk.offset + (h - 1) * this.srcBlk.scanw + w - 1;
                    for (int i = h - 1; i >= 0; --i) {
                        int kmin = k - w;
                        while (k > kmin) {
                            farr[k] = (float)srcIArr[kSrc] * mult;
                            --k;
                            --kSrc;
                        }
                        kSrc -= this.srcBlk.scanw - w;
                    }
                } else {
                    int k = w * h - 1;
                    int kSrc = this.srcBlk.offset + (h - 1) * this.srcBlk.scanw + w - 1;
                    for (int i = h - 1; i >= 0; --i) {
                        int kmin = k - w;
                        while (k > kmin) {
                            farr[k] = srcIArr[kSrc];
                            --k;
                            --kSrc;
                        }
                        kSrc -= this.srcBlk.scanw - w;
                    }
                }
                break;
            }
            case 3: {
                int[] iarr = (int[])blk.getData();
                if (iarr == null || iarr.length < w * h) {
                    iarr = new int[w * h];
                    blk.setData(iarr);
                }
                blk.scanw = this.srcBlk.w;
                blk.offset = 0;
                blk.progressive = this.srcBlk.progressive;
                float[] srcFArr = (float[])this.srcBlk.getData();
                if (this.fp != 0) {
                    float mult = 1 << this.fp;
                    int k = w * h - 1;
                    int kSrc = this.srcBlk.offset + (h - 1) * this.srcBlk.scanw + w - 1;
                    for (int i = h - 1; i >= 0; --i) {
                        int kmin = k - w;
                        while (k > kmin) {
                            iarr[k] = srcFArr[kSrc] > 0.0f ? (int)(srcFArr[kSrc] * mult + 0.5f) : (int)(srcFArr[kSrc] * mult - 0.5f);
                            --k;
                            --kSrc;
                        }
                        kSrc -= this.srcBlk.scanw - w;
                    }
                } else {
                    int k = w * h - 1;
                    int kSrc = this.srcBlk.offset + (h - 1) * this.srcBlk.scanw + w - 1;
                    for (int i = h - 1; i >= 0; --i) {
                        int kmin = k - w;
                        while (k > kmin) {
                            iarr[k] = srcFArr[kSrc] > 0.0f ? (int)(srcFArr[kSrc] + 0.5f) : (int)(srcFArr[kSrc] - 0.5f);
                            --k;
                            --kSrc;
                        }
                        kSrc -= this.srcBlk.scanw - w;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Only integer and float data are supported by JJ2000");
            }
        }
        return blk;
    }
}

