#!perl -T

use Test::More tests => 1;

use Mail::SNCF::Remind;

my @lines = <DATA>;
my $output = join("", @lines);

my $file = "t/sncf";
my $sncf = Mail::SNCF::Remind->parse($file);

is($sncf->as_string, $output, "Remind output works");

__DATA__
REM Jan 05 2009 AT  7:47 DURATION 2:2 MSG %"MASSY TGV -> RENNES%"
REM Jan 09 2009 AT 14:35 DURATION 2:12 MSG %"RENNES -> MASSY TGV%"
REM Jan 12 2009 AT 10:05 DURATION 2:3 MSG %"PARIS MONTPARNASSE 1 ET 2 -> RENNES%"
REM Jan 12 2009 AT 18:39 DURATION 2:9 MSG %"RENNES -> MASSY TGV%"
REM Jan 14 2009 AT 10:05 DURATION 2:3 MSG %"PARIS MONTPARNASSE 1 ET 2 -> RENNES%"
REM Jan 15 2009 AT 18:39 DURATION 2:9 MSG %"RENNES -> MASSY TGV%"
REM Jan 23 2009 AT  7:47 DURATION 2:2 MSG %"MASSY TGV -> RENNES%"
REM Jan 23 2009 AT 19:09 DURATION 2:9 MSG %"RENNES -> MASSY TGV%"
REM Feb 02 2009 AT  7:47 DURATION 2:2 MSG %"MASSY TGV -> RENNES%"
REM Feb 11 2009 AT 16:16 DURATION 3:6 MSG %"PARIS GARE DE LYON -> MARSEILLE ST CHARLES%"
REM Feb 13 2009 AT 14:22 DURATION 3:28 MSG %"ST RAPHAEL VALESCURE -> LYON PART DIEU%"
REM Feb 06 2009 AT 17:10 DURATION 2:12 MSG %"RENNES -> MASSY TGV%"
REM Feb 09 2009 AT 10:05 DURATION 2:3 MSG %"PARIS MONTPARNASSE 1 ET 2 -> RENNES%"
REM Feb 13 2009 AT 14:14 DURATION 4:17 MSG %"RENNES -> LYON PART DIEU%"
REM Feb 16 2009 AT 17:26 DURATION 2:9 MSG %"LYON PART DIEU -> MASSY PALAISEAU%"
REM Feb 17 2009 AT  7:47 DURATION 2:2 MSG %"MASSY TGV -> RENNES%"
REM Feb 20 2009 AT 17:10 DURATION 2:12 MSG %"RENNES -> MASSY TGV%"
REM Feb 23 2009 AT 10:05 DURATION 2:3 MSG %"PARIS MONTPARNASSE 1 ET 2 -> RENNES%"
REM Feb 27 2009 AT 17:10 DURATION 2:12 MSG %"RENNES -> MASSY TGV%"
REM Mar 02 2009 AT 10:05 DURATION 2:3 MSG %"PARIS MONTPARNASSE 1 ET 2 -> RENNES%"
