## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::unix::groupname::exists;

our $DATE = '2024-11-15'; # DATE
our $VERSION = '0.022'; # VERSION

our $rschema = do{my$var={base=>"unix::groupname",clsets_after_base=>[{description=>"\nSupport coercion from GID.\n\n",prefilters=>["Unix::convert_gid_to_unix_group","Unix::check_unix_group_exists"],summary=>"Unix group name that must exist on the system"}],clsets_after_type=>[{description=>"\nThe checking follows POSIX rules: does not begin with a hyphen and only contains\n[A-Za-z0-9._-].\n\nThe above rule allows integers like 1234, which can be confused with GID, so\nthis schema disallows pure integers.\n\nThe maximum length is 32 following libc6's limit.\n\nNote that this schema does not check whether the group name exists (has record\nin the user database e.g. `/etc/group`). To do that, use the\n`unix::groupname::exists` schema.\n\n",examples=>[{valid=>0,value=>""},{valid=>1,value=>"foo"},{valid=>0,value=>"-andy"},{valid=>0,value=>1234},{valid=>1,value=>"andy2"},{valid=>0,value=>"an dy"},{valid=>1,value=>"an.dy"},{summary=>"Too long",valid=>0,value=>"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"}],match=>qr((?=\A[A-Za-z0-9._][A-Za-z0-9._-]{0,31}\z)(?=.*[A-Za-z._-])),max_len=>32,min_len=>1,prefilters=>["Unix::convert_gid_to_unix_group"],summary=>"Unix group name","x.completion"=>["unix_group_or_gid"]},'$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_type}[0]','$var->{clsets_after_base}[0]'],resolve_path=>["str","unix::groupname"],type=>"str",v=>2};$var->{clsets_after_type}[1]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_type}[0];$var->{"clsets_after_type.alt.merge.merged"}[1]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Unix group name that must exist on the system

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::unix::groupname::exists - Unix group name that must exist on the system

=head1 VERSION

This document describes version 0.022 of Sah::SchemaR::unix::groupname::exists (from Perl distribution Sah-SchemaBundle-Unix), released on 2024-11-15.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::SchemaBundle during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-SchemaBundle-Unix>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-SchemaBundle-Unix>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-SchemaBundle-Unix>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
