
# This file defines things which are generic to the build process
# employed here, ie which are NOT platform-specific, nor product-specific.

debugtypes=full optimize

# for debug builds, we _always_ define DEBUG and _DEBUG in the preprocessor.
ifeq ($(DEBUG),full)
CDEBUGFLAGS=-DDEBUG -D_DEBUG
CONFARGS=--enable-debug --enable-dynamic --enable-shared
else
CONFARGS=--disable-debug --enable-dynamic --enable-shared
endif

# We always put the build output here:

ifndef BUILD_ROOT
BUILD_ROOT=.
endif
VNUM=31
LVNUM=3.1
TARGETDIR:=$(BUILD_ROOT)/built/$(PLATFORM)-$(DEBUG)
OBJDIR:=$(TARGETDIR)/obj

CFLAGS=$(CDEBUGFLAGS) $(COPTFLAGS) $(PLATCFLAGS) 
COMPILE=$(CC) -c $(CFLAGS) $(OBJ_OUT_COMMAND)$@ $<
LINK_EXE=$(CC) $(CFLAGS) $(PLAT_LINKFLAGS) -o $@ 

# Stuff to try to check that the command-line args make sense
# This is in here because it needs to know the platform list
.PHONY :.check_args all _first_all

# Some platforms are dumb with respect to multithreading, this
# variable tells us whether we're to build a multithreaded version
# or not. Defaults to yes.
ifndef MT
MT=yes
endif

.check_args:
ifdef DEBUG
ifdef PLATFORM
else
	@echo You need to specify PLAFTOM=one of [$(platformlist)]
	exit 1
endif
else
	@echo You need to specify DEBUG=one of [$(debugtypes)]
	exit 1
endif
	@echo Making $(DEBUG) build of DB for $(PLATFORM) thread=$(MT)

_first_all:	all

$(OBJDIR):
	mkdir -p $(OBJDIR)

