#!/usr/bin/perl

use strict;
use warnings;
use DBIx::SchemaChecksum;

my $sc = DBIx::SchemaChecksum->new_with_options();

print $sc->schemadump ."\n" if $sc->verbose;
print $sc->checksum,"\n";

__END__

=head1 NAME

schema_checksum.pl - calculate and print a db checksum

=head1 SYNOPSIS

    schema_checksum.pl --dsn dbi:Pg:dbname=your_db;host=db.example.org
  
=head1 DESCRIPTION

Please see C<perldoc DBIx::SchemaChecksum> for more information.

=head1 OPTIONS

See L<DBIx::SchemaChecksum> section C<Attributes generated by Moose>

=head1 AUTHOR

Thomas Klausner, C<< <domm at cpan.org> >>

=head1 COPYRIGHT & LICENSE

Copyright 2008 Thomas Klausner, revdev.at, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

