#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for all tag names
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.03';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo);

#
# Note: the tables below are generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

my @tableList = (
    'Image::ExifTool::Canon::CameraSettings',
    'Image::ExifTool::Canon::ColorInfo',
    'Image::ExifTool::Canon::ColorInfoD30',
    'Image::ExifTool::Canon::FileInfo',
    'Image::ExifTool::Canon::FocalLength',
    'Image::ExifTool::Canon::Main',
    'Image::ExifTool::Canon::PictureInfo',
    'Image::ExifTool::Canon::PreviewImageInfo',
    'Image::ExifTool::Canon::ShotInfo',
    'Image::ExifTool::Canon::WhiteBalance',
    'Image::ExifTool::CanonCustom::Functions10D',
    'Image::ExifTool::CanonCustom::Functions1D',
    'Image::ExifTool::CanonCustom::Functions20D',
    'Image::ExifTool::CanonCustom::FunctionsD30',
    'Image::ExifTool::CanonRaw::ExposureInfo',
    'Image::ExifTool::CanonRaw::FlashInfo',
    'Image::ExifTool::CanonRaw::ImageFormat',
    'Image::ExifTool::CanonRaw::ImageInfo',
    'Image::ExifTool::CanonRaw::Main',
    'Image::ExifTool::CanonRaw::MakeModel',
    'Image::ExifTool::CanonRaw::SensorInfo',
    'Image::ExifTool::CanonRaw::TimeStamp',
    'Image::ExifTool::Casio::Main',
    'Image::ExifTool::Casio::Type2',
    'Image::ExifTool::Exif::Main',
    'Image::ExifTool::FujiFilm::Main',
    'Image::ExifTool::GPS::Main',
    'Image::ExifTool::GeoTiff::Main',
    'Image::ExifTool::ICC_Profile::Chromaticity',
    'Image::ExifTool::ICC_Profile::ColorantTable',
    'Image::ExifTool::ICC_Profile::Header',
    'Image::ExifTool::ICC_Profile::Main',
    'Image::ExifTool::ICC_Profile::Measurement',
    'Image::ExifTool::ICC_Profile::ViewingConditions',
    'Image::ExifTool::IPTC::ApplicationRecord',
    'Image::ExifTool::IPTC::EnvelopeRecord',
    'Image::ExifTool::IPTC::Main',
    'Image::ExifTool::IPTC::NewsPhoto',
    'Image::ExifTool::IPTC::ObjectData',
    'Image::ExifTool::IPTC::PostObjectData',
    'Image::ExifTool::IPTC::PreObjectData',
    'Image::ExifTool::Jpeg2000::CaptureResolution',
    'Image::ExifTool::Jpeg2000::DisplayResolution',
    'Image::ExifTool::Jpeg2000::ImageHeader',
    'Image::ExifTool::Jpeg2000::Main',
    'Image::ExifTool::Kodak::Borders',
    'Image::ExifTool::Kodak::Main',
    'Image::ExifTool::Kodak::SpecialEffects',
    'Image::ExifTool::Kodak::Type2',
    'Image::ExifTool::Kodak::Type3',
    'Image::ExifTool::Kodak::Type4',
    'Image::ExifTool::Kodak::Type5',
    'Image::ExifTool::Kodak::Type6',
    'Image::ExifTool::Kodak::Unknown',
    'Image::ExifTool::Minolta::CameraSettings',
    'Image::ExifTool::Minolta::Main',
    'Image::ExifTool::Nikon::ColorBalance0100',
    'Image::ExifTool::Nikon::ColorBalance0102',
    'Image::ExifTool::Nikon::ColorBalance0103',
    'Image::ExifTool::Nikon::LensData',
    'Image::ExifTool::Nikon::Main',
    'Image::ExifTool::Nikon::MakerNotesB',
    'Image::ExifTool::Nikon::NikonCaptureOffsets',
    'Image::ExifTool::Nikon::PreviewImage',
    'Image::ExifTool::Olympus::CameraSettings',
    'Image::ExifTool::Olympus::Equipment',
    'Image::ExifTool::Olympus::FocusInfo',
    'Image::ExifTool::Olympus::ImageProcessing',
    'Image::ExifTool::Olympus::Main',
    'Image::ExifTool::Olympus::RawDevelopment',
    'Image::ExifTool::Panasonic::Main',
    'Image::ExifTool::Pentax::Main',
    'Image::ExifTool::Photoshop::JPEG_Quality',
    'Image::ExifTool::Photoshop::Main',
    'Image::ExifTool::PrintIM::Main',
    'Image::ExifTool::Ricoh::Main',
    'Image::ExifTool::Ricoh::Subdir',
    'Image::ExifTool::Ricoh::Text',
    'Image::ExifTool::Sanyo::Main',
    'Image::ExifTool::Sigma::Main',
    'Image::ExifTool::Sony::Main',
    'Image::ExifTool::Unknown::Main',
    'Image::ExifTool::XMP::Main',
    'Image::ExifTool::compositeTags',
    'Image::ExifTool::extraTags',
);

my %tagLookup = (
    'actionadvised' => { 34 => 0x2a },
    'addoriginaldecisiondata' => { 12 => 0x11 },
    'adjustmentmode' => { 79 => 0x15 },
    'advisory' => { 82 => 'Advisory' },
    'aebbracketvalue' => { 8 => 0x11 },
    'aebsequence' => { 10 => 0x9, 11 => 0x9, 12 => 0x8, 13 => 0x7 },
    'afaperture' => { 59 => 0x5 },
    'afareas' => { 64 => 0x304 },
    'afassist' => { 10 => 0x5, 13 => 0x5 },
    'afassistbeam' => { 12 => 0x4 },
    'afmode' => { 79 => 0x5 },
    'afpoint' => { 0 => 0x13, 60 => 0x88 },
    'afpointactivationarea' => { 11 => 0x11 },
    'afpointillumination' => { 11 => 0xa },
    'afpointregistration' => { 10 => 0x7 },
    'afpointselection' => { 11 => 0xb },
    'afpointselectionmethod' => { 12 => 0xc },
    'afpointspotmetering' => { 11 => 0xd },
    'afpointsused' => { 6 => 0x16 },
    'afsearch' => { 64 => 0x303 },
    'aiservotrackingsensitivity' => { 11 => 0x14 },
    'aliaslayermetadata' => { 24 => 0xc660 },
    'alphachannelsnames' => { 73 => 0x3ee },
    'alphaidentifiers' => { 73 => 0x41d },
    'analogbalance' => { 24 => 0xc627 },
    'analogzoom' => { 49 => 0x1e },
    'annotations' => { 24 => 0xc44f },
    'antialiasstrength' => { 24 => 0xc632 },
    'aperture' => { 83 => 'Aperture' },
    'aperturevalue' => { 24 => 0x9202, 82 => 'ApertureValue' },
    'applicationnotes' => { 24 => 0x2bc },
    'applicationrecordversion' => { 34 => 0x0 },
    'armidentifier' => { 35 => 0x78 },
    'armversion' => { 35 => 0x7a },
    'artist' => { 24 => 0x13b, 82 => 'Artist' },
    'asshotneutral' => { 24 => 0xc628 },
    'asshotwhitexy' => { 24 => 0xc629 },
    'assistbuttonfunction' => { 10 => 0xd },
    'association' => { 44 => 'asoc' },
    'atob0' => { 31 => 'A2B0' },
    'atob1' => { 31 => 'A2B1' },
    'atob2' => { 31 => 'A2B2' },
    'audio' => { 70 => 0x20 },
    'audioduration' => { 34 => 0x99 },
    'audiooutcue' => { 34 => 0x9a },
    'audiosamplingrate' => { 34 => 0x97 },
    'audiosamplingresolution' => { 34 => 0x98 },
    'audiotype' => { 34 => 0x96 },
    'author' => { 82 => 'Author' },
    'authorsposition' => { 82 => 'AuthorsPosition' },
    'autoafpoint' => { 71 => 0xf },
    'autobracket' => { 79 => 0x19 },
    'autobracketing' => { 25 => 0x1100 },
    'autoexposurebracketing' => { 8 => 0x10 },
    'autofocus' => { 66 => 0x209 },
    'autorotate' => { 8 => 0x1b },
    'auxiliarylens' => { 60 => 0x82 },
    'avvalue' => { 14 => 0x2 },
    'backgroundcolor' => { 73 => 0x3f2 },
    'backgroundcolorindicator' => { 24 => 0x84e8 },
    'backgroundcolorvalue' => { 24 => 0x84ea },
    'badfaxlines' => { 24 => 0x146 },
    'baseiso' => { 18 => 0x101c },
    'baselineexposure' => { 24 => 0xc62a },
    'baselinenoise' => { 24 => 0xc62b },
    'baselinesharpness' => { 24 => 0xc62c },
    'baseurl' => { 82 => 'BaseURL' },
    'batterylevel' => { 24 => 0x828f },
    'bayergreensplit' => { 24 => 0xc62d },
    'bestqualityscale' => { 24 => 0xc65c },
    'bestshotmode' => { 23 => 0x3007 },
    'binaryfilter' => { 44 => 'bfil' },
    'bitspercomponent' => { 37 => 0x87, 43 => 0xa, 44 => 'bpcc' },
    'bitsperextendedrunlength' => { 24 => 0x84e5 },
    'bitsperrunlength' => { 24 => 0x84e4 },
    'bitspersample' => { 24 => 0x102, 82 => 'BitsPerSample' },
    'blacklevel' => { 24 => 0xc61a, 68 => 0x1012 },
    'blackleveldeltah' => { 24 => 0xc61b },
    'blackleveldeltav' => { 24 => 0xc61c },
    'blacklevelrepeatdim' => { 24 => 0xc619 },
    'blackpoint' => { 71 => 0x200 },
    'bluebalance' => { 56 => 0x1, 57 => 0x1, 58 => 0x1, 68 => 0x1018, 71 => 0x1b },
    'bluebalanceauto' => { 9 => 0x1 },
    'bluebalanceb&w' => { 9 => 0xf },
    'bluebalancecloudy' => { 9 => 0x5 },
    'bluebalancecustom' => { 9 => 0xd },
    'bluebalancedaylight' => { 9 => 0x3 },
    'bluebalanceflash' => { 9 => 0xb },
    'bluebalancefluorescent' => { 9 => 0x9 },
    'bluebalanceshade' => { 9 => 0x11 },
    'bluebalancetungsten' => { 9 => 0x7 },
    'bluegain' => { 77 => 'Bg' },
    'bluehue' => { 82 => 'BlueHue' },
    'bluematrixcolumn' => { 31 => 'bXYZ' },
    'bluesaturation' => { 82 => 'BlueSaturation' },
    'bluetrc' => { 31 => 'bTRC' },
    'blurwarning' => { 25 => 0x1300 },
    'bodyfirmwareversion' => { 65 => 0x104 },
    'borderid' => { 45 => 0x2 },
    'borderinformation' => { 73 => 0x3f1 },
    'borderlocation' => { 45 => 0x3 },
    'bordername' => { 45 => 0x1 },
    'bordersversion' => { 45 => 0x0 },
    'bordertype' => { 45 => 0x4 },
    'bracket' => { 68 => 0x1006 },
    'bracketstep' => { 54 => 0xe },
    'brightness' => { 24 => 0xfe53, 54 => 0x2c, 82 => 'Brightness' },
    'brightnessvalue' => { 24 => 0x9203, 82 => 'BrightnessValue' },
    'btoa0' => { 31 => 'B2A0' },
    'btoa1' => { 31 => 'B2A1' },
    'btoa2' => { 31 => 'B2A2' },
    'bulbduration' => { 8 => 0x18 },
    'burstmode' => { 46 => 0xa },
    'burstmode2' => { 46 => 0x18 },
    'bw_halftoninginfo' => { 73 => 0x3f4 },
    'bw_transferfunc' => { 73 => 0x3f7 },
    'bwfilter' => { 54 => 0x2a },
    'bwmode' => { 68 => 0x203 },
    'by-line' => { 34 => 0x50 },
    'by-linetitle' => { 34 => 0x55 },
    'calibrationdatetime' => { 31 => 'calt' },
    'calibrationilluminant1' => { 24 => 0xc65a },
    'calibrationilluminant2' => { 24 => 0xc65b },
    'cameracalibration1' => { 24 => 0xc623 },
    'cameracalibration2' => { 24 => 0xc624 },
    'cameraid' => { 68 => 0x209, 78 => 0x209 },
    'cameraiso' => { 0 => 0x10 },
    'cameraobject' => { 18 => 0x2807 },
    'cameraowner' => { 24 => 0xc353 },
    'camerasettings' => { 68 => 0x2020 },
    'camerasettingsversion' => { 64 => 0x0 },
    'cameraspecification' => { 18 => 0x3004 },
    'canoncamerasettings' => { 5 => 0x1, 18 => 0x102d },
    'canoncolorinfo' => { 5 => 0xa0 },
    'canoncolorinfo1' => { 18 => 0x32 },
    'canoncolorinfo2' => { 18 => 0x102c },
    'canoncolorinfod30' => { 5 => 0xa },
    'canoncustomfunctions10d' => { 5 => 0xf, 18 => 0x1033 },
    'canoncustomfunctions1d' => { 5 => 0x90 },
    'canoncustomfunctions20d' => { 5 => 0xf, 18 => 0x1033 },
    'canoncustomfunctionsd30' => { 5 => 0xf, 18 => 0x1033 },
    'canonexposuremode' => { 0 => 0x14 },
    'canonfiledescription' => { 18 => 0x805 },
    'canonfileinfo' => { 5 => 0x93 },
    'canonfilelength' => { 5 => 0xe },
    'canonfirmwareversion' => { 5 => 0x7, 18 => 0x80b },
    'canonflashmode' => { 0 => 0x4 },
    'canonfocallength' => { 5 => 0x2, 18 => 0x1029 },
    'canonimageheight' => { 6 => 0x3 },
    'canonimageheightasshot' => { 6 => 0x5 },
    'canonimagesize' => { 0 => 0xa },
    'canonimagetype' => { 5 => 0x6, 18 => 0x815 },
    'canonimagewidth' => { 6 => 0x2 },
    'canonimagewidthasshot' => { 6 => 0x4 },
    'canonpictureinfo' => { 5 => 0x12, 18 => 0x1038 },
    'canonrawmakemodel' => { 18 => 0x80a },
    'canonshotinfo' => { 5 => 0x4, 18 => 0x102a },
    'caption-abstract' => { 34 => 0x78 },
    'captionwriter' => { 82 => 'CaptionWriter' },
    'captureconditionspar' => { 24 => 0xc352 },
    'capturedevicefid' => { 24 => 0xc357 },
    'captureresolution' => { 44 => 'resc' },
    'capturexresolution' => { 41 => 0x4 },
    'capturexresolutionunit' => { 41 => 0x9 },
    'captureyresolution' => { 41 => 0x0 },
    'captureyresolutionunit' => { 41 => 0x8 },
    'casioimagesize' => { 23 => 0x9 },
    'category' => { 34 => 0xf, 82 => 'Category' },
    'ccdisosensitivity' => { 23 => 0x3014 },
    'ccdsensitivity' => { 22 => 0x14, 61 => 0x6 },
    'celllength' => { 24 => 0x109 },
    'cellwidth' => { 24 => 0x108 },
    'certificate' => { 82 => 'Certificate' },
    'cfalayout' => { 24 => 0xc617 },
    'cfapattern' => { 24 => 0xa302, 82 => 'CFAPattern', 83 => 'CFAPattern' },
    'cfapattern2' => { 24 => 0x828e },
    'cfapatterncolumns' => { 82 => 'CFAPatternColumns' },
    'cfapatternrows' => { 82 => 'CFAPatternRows' },
    'cfapatternvalues' => { 82 => 'CFAPatternValues' },
    'cfaplanecolor' => { 24 => 0xc616 },
    'cfarepeatpatterndim' => { 24 => 0x828d },
    'chartarget' => { 31 => 'targ' },
    'chromablurradius' => { 24 => 0xc631 },
    'chromaticaberrationb' => { 82 => 'ChromaticAberrationB' },
    'chromaticaberrationr' => { 82 => 'ChromaticAberrationR' },
    'chromaticadaptation' => { 31 => 'chad' },
    'chromaticity' => { 31 => 'chrm' },
    'chromaticitychannel1' => { 28 => 0xc },
    'chromaticitychannel2' => { 28 => 0x14 },
    'chromaticitychannel3' => { 28 => 0x1c },
    'chromaticitychannel4' => { 28 => 0x24 },
    'chromaticitychannels' => { 28 => 0x8 },
    'chromaticitycolorant' => { 28 => 0xa },
    'city' => { 34 => 0x5a, 82 => 'City' },
    'classifystate' => { 34 => 0xe1 },
    'cleanfaxdata' => { 24 => 0x147 },
    'clippath' => { 24 => 0x157 },
    'clippingpathname' => { 73 => 0xbb7 },
    'cmmflags' => { 30 => 0x2c },
    'codedcharacterset' => { 35 => 0x5a },
    'codestreamheader' => { 44 => 'jpch' },
    'codestreamregistration' => { 44 => 'creg' },
    'codingmethods' => { 24 => 0x193 },
    'coloradjustment' => { 79 => 0x14 },
    'coloradjustmentmode' => { 78 => 0x210 },
    'colorant1coordinates' => { 29 => 0x2c },
    'colorant1name' => { 29 => 0xc },
    'colorant2coordinates' => { 29 => 0x52 },
    'colorant2name' => { 29 => 0x32 },
    'colorant3coordinates' => { 29 => 0x78 },
    'colorant3name' => { 29 => 0x58 },
    'colorantcount' => { 29 => 0x8 },
    'colorantorder' => { 31 => 'clro' },
    'coloranttable' => { 31 => 'clrt' },
    'colorbalance0100' => { 60 => 0x97 },
    'colorbalance0102' => { 60 => 0x97 },
    'colorbalance0103' => { 60 => 0x97 },
    'colorbalance1' => { 60 => 0xc },
    'colorbalanceblue' => { 54 => 0x1e },
    'colorbalancegreen' => { 54 => 0x1d },
    'colorbalancered' => { 54 => 0x1c },
    'colorbalanceunknown' => { 60 => 0x97 },
    'colorbitdepth' => { 17 => 0x5 },
    'colorbw' => { 17 => 0x6 },
    'colorcalibrationmatrix' => { 37 => 0x46 },
    'colorcharacterization' => { 24 => 0x84ed },
    'colorcontrol' => { 68 => 0x102b },
    'coloreffect' => { 70 => 0x28 },
    'colorfilter' => { 54 => 0x29 },
    'colorgroup' => { 44 => 'cgrp' },
    'colorhalftoninginfo' => { 73 => 0x3f5 },
    'colorhue' => { 60 => 0x8d },
    'colormap' => { 24 => 0x140 },
    'colormatrix' => { 2 => 0xa, 67 => 0x200, 68 => 0x1011 },
    'colormatrix1' => { 24 => 0xc621 },
    'colormatrix2' => { 24 => 0xc622 },
    'colormode' => { 23 => 0x3015, 46 => 0x66, 54 => 0x28, 55 => 0x101, 60 => 0x3, 61 => 0x4, 68 => 0x101 },
    'colornoisereduction' => { 82 => 'ColorNoiseReduction' },
    'colorpalette' => { 37 => 0x55 },
    'colorrepresentation' => { 37 => 0x3c },
    'colorresponseunit' => { 24 => 0x12c },
    'colorsamplersresource' => { 73 => 0x40e },
    'colorsequence' => { 24 => 0x84e1, 37 => 0x41 },
    'colorspace' => { 18 => 0x10b4, 24 => 0xa001, 64 => 0x507, 79 => 0xb, 82 => 'ColorSpace' },
    'colorspacedata' => { 30 => 0x10 },
    'colorspecification' => { 44 => 'colr' },
    'colortable' => { 24 => 0x84e6 },
    'colortemperature' => { 1 => 0x9, 2 => 0x9, 5 => 0xae, 18 => 0x10ae },
    'colortone' => { 0 => 0x2a },
    'colortransferfuncs' => { 73 => 0x3f8 },
    'comment' => { 84 => 'Comment' },
    'componentbitdepth' => { 17 => 0x4 },
    'componentdefinition' => { 44 => 'cdef' },
    'componentmapping' => { 44 => 'cmap' },
    'componentsconfiguration' => { 24 => 0x9101, 82 => 'ComponentsConfiguration' },
    'componentversion' => { 18 => 0x80c },
    'compositinglayerheader' => { 44 => 'jplh' },
    'composition' => { 44 => 'comp' },
    'compositionoptions' => { 44 => 'copt' },
    'compressedbitsperpixel' => { 24 => 0x9102, 82 => 'CompressedBitsPerPixel' },
    'compressedimagesize' => { 55 => 0x40, 68 => 0x40 },
    'compression' => { 24 => 0x103, 43 => 0xb, 63 => 0x103, 82 => 'Compression' },
    'compressionfactor' => { 64 => 0x50d },
    'compressionratio' => { 68 => 0x1034 },
    'conditionalfec' => { 83 => 'ConditionalFEC' },
    'confirmedobjectsize' => { 39 => 0xa },
    'consecutivebadfaxlines' => { 24 => 0x148 },
    'contact' => { 34 => 0x76 },
    'contentlocationcode' => { 34 => 0x1a },
    'contentlocationname' => { 34 => 0x1b },
    'contiguouscodestream' => { 44 => 'jp2c' },
    'continuousdrive' => { 0 => 0x5 },
    'contrast' => { 0 => 0xd, 22 => 0xc, 23 => 0x20, 24 => [0xa408,0xfe54], 25 => 0x1004, 54 => 0x20, 68 => 0x1029, 70 => 0x2c, 71 => 0x20, 79 => 0xd, 82 => 'Contrast' },
    'contrastsetting' => { 64 => 0x505 },
    'contributor' => { 82 => 'Contributor' },
    'converter' => { 24 => 0xfe4d, 61 => 0xb },
    'copyright' => { 24 => 0x8298, 31 => 'cprt', 82 => 'Copyright' },
    'copyrightflag' => { 73 => 0x40a },
    'copyrightnotice' => { 34 => 0x74 },
    'coringfilter' => { 68 => 0x102d },
    'country' => { 82 => 'Country' },
    'country-primarylocationcode' => { 34 => 0x64 },
    'country-primarylocationname' => { 34 => 0x65 },
    'countrycode' => { 82 => 'CountryCode' },
    'coverage' => { 82 => 'Coverage' },
    'crdinfo' => { 31 => 'crdi' },
    'createdate' => { 24 => 0x9004, 82 => 'CreateDate' },
    'creationdate' => { 82 => 'CreationDate' },
    'creator' => { 82 => 'Creator' },
    'creatorcontactinfo' => { 82 => 'CreatorContactInfo' },
    'creatorcontactinfociadrcity' => { 82 => 'CreatorContactInfoCiAdrCity' },
    'creatorcontactinfociadrctry' => { 82 => 'CreatorContactInfoCiAdrCtry' },
    'creatorcontactinfociadrextadr' => { 82 => 'CreatorContactInfoCiAdrExtadr' },
    'creatorcontactinfociadrpcode' => { 82 => 'CreatorContactInfoCiAdrPcode' },
    'creatorcontactinfociadrregion' => { 82 => 'CreatorContactInfoCiAdrRegion' },
    'creatorcontactinfociemailwork' => { 82 => 'CreatorContactInfoCiEmailWork' },
    'creatorcontactinfocitelwork' => { 82 => 'CreatorContactInfoCiTelWork' },
    'creatorcontactinfociurlwork' => { 82 => 'CreatorContactInfoCiUrlWork' },
    'creatortool' => { 82 => 'CreatorTool' },
    'credit' => { 34 => 0x6e, 82 => 'Credit' },
    'cross-reference' => { 44 => 'cref' },
    'customrendered' => { 24 => 0xa401, 82 => 'CustomRendered' },
    'customsaturation' => { 64 => 0x503 },
    'datacompressionmethod' => { 37 => 0x6e },
    'datadump' => { 60 => 0x10, 68 => 0xf00, 70 => 0x21, 71 => 0x3fe, 78 => 0xf00 },
    'datadump2' => { 68 => 0xf01 },
    'datareference' => { 44 => 'dtbl' },
    'datatype' => { 24 => 0x80e4 },
    'date' => { 46 => 0x10, 49 => 0xc, 71 => 0x6, 82 => 'Date' },
    'datecreated' => { 34 => 0x37, 82 => 'DateCreated' },
    'datesent' => { 35 => 0x46 },
    'datetime' => { 82 => 'DateTime' },
    'datetimecreated' => { 83 => 'DateTimeCreated' },
    'datetimedigitized' => { 82 => 'DateTimeDigitized' },
    'datetimeoriginal' => { 21 => 0x0, 24 => 0x9003, 82 => 'DateTimeOriginal', 83 => 'DateTimeOriginal' },
    'datetimestamp' => { 46 => 0x64 },
    'dealeridnumber' => { 24 => 0xc356 },
    'decode' => { 24 => 0x1b1 },
    'decodertable' => { 18 => 0x1835 },
    'decposition' => { 54 => 0x32 },
    'defaultcroporigin' => { 24 => 0xc61f },
    'defaultcropsize' => { 24 => 0xc620 },
    'defaultimagecolor' => { 24 => 0x1b2 },
    'defaultscale' => { 24 => 0xc61e },
    'derivedfrom' => { 82 => 'DerivedFrom' },
    'derivedfromdocumentid' => { 82 => 'DerivedFromDocumentID' },
    'derivedfrominstanceid' => { 82 => 'DerivedFromInstanceID' },
    'derivedfrommanager' => { 82 => 'DerivedFromManager' },
    'derivedfrommanagervariant' => { 82 => 'DerivedFromManagerVariant' },
    'derivedfrommanageto' => { 82 => 'DerivedFromManageTo' },
    'derivedfrommanageui' => { 82 => 'DerivedFromManageUI' },
    'derivedfromrenditionclass' => { 82 => 'DerivedFromRenditionClass' },
    'derivedfromrenditionparams' => { 82 => 'DerivedFromRenditionParams' },
    'derivedfromversionid' => { 82 => 'DerivedFromVersionID' },
    'description' => { 82 => 'Description' },
    'desiredreproductions' => { 44 => 'drep' },
    'destination' => { 35 => 0x5 },
    'destinationcity' => { 71 => 0x24 },
    'destinationcitycode' => { 71 => 0x1001 },
    'destinationdst' => { 71 => 0x26 },
    'deviceattributes' => { 30 => 0x38 },
    'devicemanufacturer' => { 30 => 0x30 },
    'devicemfgdesc' => { 31 => 'dmnd' },
    'devicemodel' => { 30 => 0x34 },
    'devicemodeldesc' => { 31 => 'dmdd' },
    'devicesettingdescription' => { 24 => 0xa40b, 82 => 'DeviceSettingDescription' },
    'devicesettingdescriptioncolumns' => { 82 => 'DeviceSettingDescriptionColumns' },
    'devicesettingdescriptionrows' => { 82 => 'DeviceSettingDescriptionRows' },
    'devicesettingdescriptionsettings' => { 82 => 'DeviceSettingDescriptionSettings' },
    'devicesettings' => { 31 => 'devs' },
    'digitalcreationdate' => { 34 => 0x3e },
    'digitalcreationtime' => { 34 => 0x3f },
    'digitaleffectsname' => { 47 => 0x1 },
    'digitaleffectstype' => { 47 => 0x2 },
    'digitaleffectsversion' => { 47 => 0x0 },
    'digitalsignature' => { 44 => 'chck' },
    'digitalzoom' => { 0 => 0xc, 22 => 0xa, 46 => 0x68, 51 => 0x22, 52 => 0x1e, 54 => 0xc, 60 => 0x86, 61 => 0xa, 68 => 0x204, 71 => 0x1e, 78 => 0x204 },
    'digitalzoomon' => { 78 => 0x21b },
    'digitalzoomratio' => { 24 => 0xa404, 82 => 'DigitalZoomRatio' },
    'directory' => { 84 => 'Directory' },
    'displayinfo' => { 73 => 0x3ef },
    'displayresolution' => { 44 => 'resd' },
    'displayxresolution' => { 42 => 0x4 },
    'displayxresolutionunit' => { 42 => 0x9 },
    'displayyresolution' => { 42 => 0x0 },
    'displayyresolutionunit' => { 42 => 0x8 },
    'distance1' => { 46 => 0x28 },
    'distance2' => { 46 => 0x2c },
    'distance3' => { 46 => 0x30 },
    'distance4' => { 46 => 0x34 },
    'distortioncorrection' => { 64 => 0x50b },
    'dngbackwardversion' => { 24 => 0xc613 },
    'dngcameraserialnumber' => { 24 => 0xc62f },
    'dnglensinfo' => { 24 => 0xc630 },
    'dngprivatedata' => { 24 => 0xc634 },
    'dngversion' => { 24 => 0xc612 },
    'documenthistory' => { 34 => 0xe7 },
    'documentid' => { 82 => 'DocumentID' },
    'documentname' => { 24 => 0x10d },
    'documentnotes' => { 34 => 0xe6 },
    'dotrange' => { 24 => 0x150 },
    'drivemode' => { 54 => 0x6, 79 => 0x3, 83 => 'DriveMode' },
    'duotonehalftoninginfo' => { 73 => 0x3f6 },
    'duotoneimageinfo' => { 73 => 0x3fa },
    'duotonetransferfuncs' => { 73 => 0x3f9 },
    'easymode' => { 0 => 0xb },
    'editorialupdate' => { 34 => 0x8 },
    'editstatus' => { 34 => 0x7 },
    'edittagarray' => { 24 => 0xc366 },
    'effectivebw' => { 73 => 0x3fb },
    'effectivemaxaperture' => { 59 => 0x12 },
    'effectsvisible' => { 73 => 0x412 },
    'endpoints' => { 37 => 0x7d },
    'enhancement' => { 23 => 0x3016 },
    'envelopenumber' => { 24 => 0xc358, 35 => 0x28 },
    'envelopepriority' => { 35 => 0x3c },
    'enveloperecordversion' => { 35 => 0x0 },
    'epsonimageheight' => { 68 => 0x20c },
    'epsonimagewidth' => { 68 => 0x20b },
    'epsonsoftware' => { 68 => 0x20d },
    'epsoptions' => { 73 => 0x3fd },
    'equipment' => { 68 => 0x2010 },
    'equipmentversion' => { 65 => 0x0 },
    'error' => { 84 => 'Error' },
    'ettlii' => { 12 => 0xd },
    'excursiontolerance' => { 37 => 0x82 },
    'exif' => { 84 => 'EXIF' },
    'exifcamerainfo' => { 34 => 0xe8 },
    'exifimageheight' => { 82 => 'PixelYDimension' },
    'exifimagelength' => { 24 => 0xa003 },
    'exifimagewidth' => { 24 => 0xa002, 82 => 'PixelXDimension' },
    'exifinformation' => { 18 => 0x300b },
    'exifoffset' => { 24 => 0x8769 },
    'exiftoolversion' => { 84 => 'ExifToolVersion' },
    'exifversion' => { 24 => 0x9000, 82 => 'ExifVersion' },
    'expirationdate' => { 34 => 0x25 },
    'expirationtime' => { 34 => 0x26 },
    'exposure' => { 24 => 0xfe51, 82 => 'Exposure' },
    'exposurebracketvalue' => { 60 => 0x19 },
    'exposurecompensation' => { 8 => 0x6, 14 => 0x0, 24 => 0x9204, 46 => 0x24, 54 => 0xd, 71 => 0x16, 79 => 0xc, 82 => 'ExposureBiasValue' },
    'exposuredifference' => { 60 => 0xe },
    'exposureindex' => { 24 => [0x9215,0xa215], 82 => 'ExposureIndex' },
    'exposureinfo' => { 18 => 0x1818 },
    'exposurelevelincrements' => { 10 => 0x6, 11 => 0x6, 12 => 0x5, 13 => 0x4 },
    'exposuremode' => { 24 => 0xa402, 54 => 0x1, 64 => 0x200, 79 => 0x8, 82 => 'ExposureMode' },
    'exposureprogram' => { 24 => 0x8822, 82 => 'ExposureProgram' },
    'exposuretime' => { 8 => 0x16, 24 => 0x829a, 46 => 0x20, 49 => 0x38, 51 => 0x14, 52 => 0x10, 71 => 0x12, 82 => 'ExposureTime' },
    'exposurewarning' => { 25 => 0x1302 },
    'extender' => { 65 => 0x301 },
    'extenderfirmwareversion' => { 65 => 0x304 },
    'extenderserialnumber' => { 65 => 0x302 },
    'externalflash' => { 66 => 0x1201 },
    'extrasamples' => { 24 => 0x152 },
    'faxprofile' => { 24 => 0x192 },
    'faxrecvparams' => { 24 => 0x885c },
    'faxrecvtime' => { 24 => 0x885e },
    'faxsubaddress' => { 24 => 0x885d },
    'fileformat' => { 16 => 0x0, 35 => 0x14 },
    'filemodifydate' => { 84 => 'FileModifyDate' },
    'filename' => { 84 => 'FileName' },
    'filenumber' => { 3 => 0x1, 5 => 0x8, 18 => 0x1817 },
    'filenumbermemory' => { 54 => 0x1a },
    'filesize' => { 84 => 'FileSize' },
    'filesource' => { 24 => 0xa300, 82 => 'FileSource' },
    'filesystemversion' => { 60 => 0x1 },
    'filetype' => { 44 => 'ftyp', 84 => 'FileType' },
    'fileversion' => { 35 => 0x16 },
    'fillflashautoreduction' => { 10 => 0xe, 11 => 0xe, 13 => 0xa },
    'fillorder' => { 24 => 0x10a },
    'filmcategory' => { 24 => 0xc35a },
    'filmgencode' => { 24 => 0xc35b },
    'filmproductcode' => { 24 => 0xc350 },
    'filmsize' => { 24 => 0xc35d },
    'filter' => { 23 => 0x3017 },
    'finderdisplayduringexposure' => { 11 => 0x1 },
    'firmware' => { 79 => 0x17 },
    'firmwareversion' => { 68 => 0x207, 70 => 0x2 },
    'firmwareversion2' => { 65 => 0x100 },
    'fixtureidentifier' => { 34 => 0x16 },
    'flash' => { 24 => 0x9209, 52 => 0x22, 82 => 'Flash' },
    'flashactivity' => { 0 => 0x1c },
    'flashbias' => { 68 => 0x1023, 70 => 0x24 },
    'flashbits' => { 0 => 0x1d },
    'flashdevice' => { 68 => 0x1005 },
    'flashdistance' => { 23 => 0x2034 },
    'flashenergy' => { 24 => [0x920b,0xa20b], 82 => 'FlashEnergy' },
    'flashexposurebracketvalue' => { 60 => 0x18 },
    'flashexposurecomp' => { 8 => 0xf, 54 => 0x23, 60 => 0x12 },
    'flashexposurecompensation' => { 64 => 0x401 },
    'flashfired' => { 46 => 0x5d, 54 => 0x14, 82 => 'FlashFired' },
    'flashfiring' => { 12 => 0x6 },
    'flashfirmwareversion' => { 65 => 0x1004 },
    'flashfunction' => { 82 => 'FlashFunction' },
    'flashguidenumber' => { 15 => 0x0 },
    'flashinfo' => { 18 => 0x1813 },
    'flashintensity' => { 22 => 0x5 },
    'flashmode' => { 22 => 0x4, 46 => 0x5c, 51 => 0x27, 54 => 0x2, 60 => 0x87, 64 => 0x400, 68 => 0x1004, 71 => 0xc, 78 => 0x225, 82 => 'FlashMode' },
    'flashmodel' => { 65 => 0x1001 },
    'flashon' => { 83 => 'FlashOn' },
    'flashpixversion' => { 24 => 0xa000, 82 => 'FlashpixVersion' },
    'flashredeyemode' => { 82 => 'FlashRedEyeMode' },
    'flashreturn' => { 82 => 'FlashReturn' },
    'flashserialnumber' => { 65 => 0x1003 },
    'flashsetting' => { 60 => 0x8 },
    'flashstrength' => { 25 => 0x1011 },
    'flashsyncspeedav' => { 10 => 0x3, 12 => 0x2, 13 => 0x6 },
    'flashthreshold' => { 15 => 0x1 },
    'flashtype' => { 60 => 0x9, 65 => 0x1000, 83 => 'FlashType' },
    'flickerreduce' => { 78 => 0x218 },
    'fnumber' => { 8 => 0x15, 24 => 0x829d, 46 => 0x1e, 49 => 0x3c, 51 => 0x1c, 52 => 0x18, 71 => 0x13, 82 => 'FNumber' },
    'focallength' => { 4 => 0x1, 23 => 0x1d, 24 => 0x920a, 54 => 0x12, 59 => 0xa, 71 => 0x1d, 82 => 'FocalLength' },
    'focallength35efl' => { 83 => 'FocalLength35efl' },
    'focallengthin35mmformat' => { 24 => 0xa405, 82 => 'FocalLengthIn35mmFilm' },
    'focalplanediagonal' => { 65 => 0x103, 68 => 0x205 },
    'focalplaneresolutionunit' => { 24 => [0x9210,0xa210], 82 => 'FocalPlaneResolutionUnit' },
    'focalplanexresolution' => { 24 => [0x920e,0xa20e], 82 => 'FocalPlaneXResolution' },
    'focalplanexsize' => { 4 => 0x2 },
    'focalplaneyresolution' => { 24 => [0x920f,0xa20f], 82 => 'FocalPlaneYResolution' },
    'focalplaneysize' => { 4 => 0x3 },
    'focalunits' => { 0 => 0x19 },
    'focus' => { 61 => 0x8 },
    'focusarea' => { 54 => 0x31 },
    'focuscontinuous' => { 0 => 0x20 },
    'focusdistance' => { 54 => 0x13, 59 => 0x9, 66 => 0x305, 68 => 0x100c },
    'focusdistancelower' => { 8 => 0x14 },
    'focusdistanceupper' => { 8 => 0x13 },
    'focusinfo' => { 68 => 0x2050 },
    'focusinfoversion' => { 66 => 0x0 },
    'focusingscreen' => { 11 => 0x0 },
    'focusmode' => { 0 => 0x7, 22 => 0x3, 23 => [0x3003,0xd], 25 => 0x1021, 46 => 0x38, 54 => 0x30, 60 => 0x7, 64 => 0x301, 68 => 0x100b, 70 => 0x7, 71 => 0xd },
    'focusposition' => { 59 => 0x8, 71 => 0x10 },
    'focusprocess' => { 64 => 0x302 },
    'focussetting' => { 79 => 0x6 },
    'focustype' => { 0 => 0x12 },
    'focuswarning' => { 25 => 0x1301 },
    'foldername' => { 54 => 0x27 },
    'format' => { 82 => 'Format' },
    'fragmentlist' => { 44 => 'flst' },
    'fragmenttable' => { 44 => 'ftbl' },
    'framenumber' => { 24 => 0xc359, 71 => 0x29 },
    'free' => { 44 => 'free' },
    'freebytecounts' => { 24 => 0x121 },
    'freebytes' => { 18 => 0x1 },
    'freeoffsets' => { 24 => 0x120 },
    'fujiflashmode' => { 25 => 0x1010 },
    'gaincontrol' => { 24 => 0xa407, 82 => 'GainControl' },
    'gamma' => { 24 => 0xa500 },
    'gammacompensatedvalue' => { 37 => 0x91 },
    'gamut' => { 31 => 'gamt' },
    'gdalmetadata' => { 24 => 0xa480 },
    'gdalnodata' => { 24 => 0xa481 },
    'geogangularunits' => { 27 => 0x806 },
    'geogangularunitsize' => { 27 => 0x807 },
    'geogazimuthunits' => { 27 => 0x80c },
    'geogcitation' => { 27 => 0x801 },
    'geogellipsoid' => { 27 => 0x808 },
    'geoggeodeticdatum' => { 27 => 0x802 },
    'geoginvflattening' => { 27 => 0x80b },
    'geoglinearunits' => { 27 => 0x804 },
    'geoglinearunitsize' => { 27 => 0x805 },
    'geogprimemeridian' => { 27 => 0x803 },
    'geogprimemeridianlong' => { 27 => 0x80d },
    'geographictype' => { 27 => 0x800 },
    'geogsemimajoraxis' => { 27 => 0x809 },
    'geogsemiminoraxis' => { 27 => 0x80a },
    'geotiffasciiparams' => { 24 => 0x87b1 },
    'geotiffdirectory' => { 24 => 0x87af },
    'geotiffdoubleparams' => { 24 => 0x87b0 },
    'geotiffversion' => { 27 => 0x1 },
    'globalaltitude' => { 73 => 0x419 },
    'globalangle' => { 73 => 0x40d },
    'globalparametersifd' => { 24 => 0x190 },
    'gpsaltitude' => { 26 => 0x6, 82 => 'GPSAltitude' },
    'gpsaltituderef' => { 26 => 0x5, 82 => 'GPSAltitudeRef' },
    'gpsareainformation' => { 26 => 0x1c, 82 => 'GPSAreaInformation' },
    'gpsdatestamp' => { 26 => 0x1d },
    'gpsdatetime' => { 83 => 'GPSDateTime' },
    'gpsdestbearing' => { 26 => 0x18, 82 => 'GPSDestBearing' },
    'gpsdestbearingref' => { 26 => 0x17, 82 => 'GPSDestBearingRef' },
    'gpsdestdistance' => { 26 => 0x1a, 82 => 'GPSDestDistance' },
    'gpsdestdistanceref' => { 26 => 0x19, 82 => 'GPSDestDistanceRef' },
    'gpsdestlatitude' => { 26 => 0x14, 82 => 'GPSDestLatitude' },
    'gpsdestlatituderef' => { 26 => 0x13 },
    'gpsdestlongitude' => { 26 => 0x16, 82 => 'GPSDestLongitude' },
    'gpsdestlongituderef' => { 26 => 0x15 },
    'gpsdifferential' => { 26 => 0x1e, 82 => 'GPSDifferential' },
    'gpsdop' => { 26 => 0xb },
    'gpsimgdirection' => { 26 => 0x11, 82 => 'GPSImgDirection' },
    'gpsimgdirectionref' => { 26 => 0x10, 82 => 'GPSImgDirectionRef' },
    'gpsinfo' => { 24 => 0x8825 },
    'gpslatitude' => { 26 => 0x2, 82 => 'GPSLatitude' },
    'gpslatituderef' => { 26 => 0x1 },
    'gpslongitude' => { 26 => 0x4, 82 => 'GPSLongitude' },
    'gpslongituderef' => { 26 => 0x3 },
    'gpsmapdatum' => { 26 => 0x12, 82 => 'GPSMapDatum' },
    'gpsmeasuremode' => { 26 => 0xa },
    'gpsprocessingmethod' => { 26 => 0x1b, 82 => 'GPSProcessingMethod' },
    'gpssatellites' => { 26 => 0x8, 82 => 'GPSSatellites' },
    'gpsspeed' => { 26 => 0xd, 82 => 'GPSSpeed' },
    'gpsspeedref' => { 26 => 0xc, 82 => 'GPSSpeedRef' },
    'gpsstatus' => { 26 => 0x9, 82 => 'GPSStatus' },
    'gpstimestamp' => { 26 => 0x7, 82 => 'GPSTimeStamp' },
    'gpstrack' => { 26 => 0xf, 82 => 'GPSTrack' },
    'gpstrackref' => { 26 => 0xe, 82 => 'GPSTrackRef' },
    'gpsversionid' => { 26 => 0x0, 82 => 'GPSVersionID' },
    'gradation' => { 64 => 0x50f },
    'graphicstechnologystandardoutput' => { 44 => 'gtso' },
    'grayresponsecurve' => { 24 => 0x123 },
    'grayresponseunit' => { 24 => 0x122 },
    'graytrc' => { 31 => 'kTRC' },
    'greengain' => { 77 => 'Gg' },
    'greenhue' => { 82 => 'GreenHue' },
    'greenmatrixcolumn' => { 31 => 'gXYZ' },
    'greensaturation' => { 82 => 'GreenSaturation' },
    'greentrc' => { 31 => 'gTRC' },
    'gridguidesinfo' => { 73 => 0x408 },
    'gtcitation' => { 27 => 0x402 },
    'gtmodeltype' => { 27 => 0x400 },
    'gtrastertype' => { 27 => 0x401 },
    'halftonehints' => { 24 => 0x141 },
    'hcusage' => { 24 => 0x84ee },
    'headline' => { 34 => 0x69, 82 => 'Headline' },
    'highlight' => { 79 => 0xf },
    'history' => { 82 => 'History' },
    'historyaction' => { 82 => 'HistoryAction' },
    'historyinstanceid' => { 82 => 'HistoryInstanceID' },
    'historyparameters' => { 82 => 'HistoryParameters' },
    'historysoftwareagent' => { 82 => 'HistorySoftwareAgent' },
    'historywhen' => { 82 => 'HistoryWhen' },
    'hometowncity' => { 71 => 0x23 },
    'hometowncitycode' => { 71 => 0x1000 },
    'hometowndst' => { 71 => 0x25 },
    'hostcomputer' => { 24 => 0x13c },
    'hueadjustment' => { 60 => 0x92 },
    'icc_profile' => { 24 => 0x8773, 73 => 0x40f },
    'icc_untagged' => { 73 => 0x411 },
    'iccprofile' => { 37 => 0x42 },
    'identifier' => { 82 => 'Identifier' },
    'idsbasevalue' => { 73 => 0x414 },
    'ifd0_offset' => { 62 => 0x1 },
    'imageadjustment' => { 60 => 0x80, 61 => 0x5 },
    'imageboundary' => { 60 => 0x16 },
    'imagecolorindicator' => { 24 => 0x84e7 },
    'imagecolorvalue' => { 24 => 0x84e9 },
    'imagedepth' => { 24 => 0x80e5 },
    'imagedescription' => { 18 => 0x2804, 24 => 0x10e, 82 => 'ImageDescription' },
    'imageformat' => { 18 => 0x1803 },
    'imageheader' => { 44 => 'ihdr' },
    'imageheight' => { 17 => 0x1, 24 => 0x101, 43 => 0x0, 82 => 'ImageLength', 84 => 'ImageHeight' },
    'imagehistory' => { 24 => [0x9213,0xa213] },
    'imageid' => { 24 => 0x800d },
    'imageinfo' => { 18 => 0x1810 },
    'imagelayer' => { 24 => 0x87ac },
    'imagenumber' => { 24 => [0x9211,0xa211] },
    'imageoptimization' => { 60 => 0xa9 },
    'imageorientation' => { 34 => 0x83 },
    'imageprintstatus' => { 24 => 0xc46e },
    'imageprocessing' => { 68 => 0x2040 },
    'imageprocessingversion' => { 67 => 0x0 },
    'imageprops' => { 18 => 0x300a },
    'imagequality' => { 70 => 0x1 },
    'imagequality2' => { 64 => 0x603 },
    'imagerotated' => { 51 => 0x2a },
    'imagerotationstatus' => { 24 => 0xc363 },
    'imagesize' => { 83 => 'ImageSize' },
    'imagesourcedata' => { 24 => 0x935c },
    'imagesourceek' => { 24 => 0xc351 },
    'imagestabilization' => { 55 => 0x18 },
    'imagestabilizer' => { 70 => 0x1a },
    'imagetype' => { 34 => 0x82 },
    'imageuniqueid' => { 24 => 0xa420, 82 => 'ImageUniqueID' },
    'imagewidth' => { 17 => 0x0, 24 => 0x100, 43 => 0x4, 82 => 'ImageWidth', 84 => 'ImageWidth' },
    'indexed' => { 24 => 0x15a },
    'indexedcolourtablecount' => { 73 => 0x416 },
    'inknames' => { 24 => 0x14d },
    'inkset' => { 24 => 0x14c },
    'instructions' => { 82 => 'Instructions' },
    'instructionset' => { 44 => 'inst' },
    'intellectualgenre' => { 82 => 'IntellectualGenre' },
    'intellectualproperty' => { 44 => 'jp2i' },
    'interchangecolorspace' => { 37 => 0x40 },
    'intergraphflagregisters' => { 24 => 0x847f },
    'intergraphmatrix' => { 24 => 0x8480 },
    'intergraphpacketdata' => { 24 => 0x8474 },
    'interlace' => { 24 => 0x8829 },
    'internalflash' => { 54 => 0x2b, 66 => 0x1208 },
    'interopindex' => { 24 => 0x1 },
    'interopoffset' => { 24 => 0xa005 },
    'interopversion' => { 24 => 0x2 },
    'intervallength' => { 54 => 0x10 },
    'intervalmode' => { 54 => 0x26 },
    'intervalnumber' => { 54 => 0x11 },
    'iptc-naa' => { 24 => 0x83bb },
    'iptc-naa2' => { 24 => 0x8568 },
    'iptcapplication' => { 36 => 0x2 },
    'iptcbitspersample' => { 37 => 0x56 },
    'iptcdata' => { 73 => 0x404 },
    'iptcenvelope' => { 36 => 0x1 },
    'iptcimageheight' => { 37 => 0x1e },
    'iptcimagerotation' => { 37 => 0x66 },
    'iptcimagewidth' => { 37 => 0x14 },
    'iptcnewsphoto' => { 36 => 0x3 },
    'iptcobjectdata' => { 36 => 0x8 },
    'iptcpicturenumber' => { 37 => 0xa },
    'iptcpixelheight' => { 37 => 0x32 },
    'iptcpixelwidth' => { 37 => 0x28 },
    'iptcpostobjectdata' => { 36 => 0x9 },
    'iptcpreobjectdata' => { 36 => 0x7 },
    'iso' => { 8 => 0x2, 23 => 0x14, 24 => 0x8827, 46 => 0x60, 49 => 0x4e, 51 => 0x1e, 52 => 0x1a, 60 => 0x2, 71 => 0x14, 82 => 'ISOSpeedRatings' },
    'isoexpansion' => { 12 => 0x7 },
    'isoselection' => { 60 => 0xf },
    'isosetting' => { 46 => 0x5e, 52 => 0x14, 54 => 0x24, 60 => 0x13 },
    'isospeedexpansion' => { 11 => 0x3 },
    'it8header' => { 24 => 0x84e2 },
    'ixusafpoint' => { 8 => 0xe },
    'jobid' => { 34 => 0xb8 },
    'jobref' => { 82 => 'JobRef' },
    'jobrefid' => { 82 => 'JobRefId' },
    'jobrefname' => { 82 => 'JobRefName' },
    'jobrefurl' => { 82 => 'JobRefUrl' },
    'jp2header' => { 44 => 'jp2h' },
    'jp2signature' => { 44 => ["jP\x1a\x1a",'jP  '] },
    'jpeg_quality' => { 73 => 0x406 },
    'jpegactables' => { 24 => 0x209 },
    'jpegdctables' => { 24 => 0x208 },
    'jpeglosslesspredictors' => { 24 => 0x205 },
    'jpegpointtransforms' => { 24 => 0x206 },
    'jpegproc' => { 24 => 0x200 },
    'jpegqtables' => { 24 => 0x207 },
    'jpegrestartinterval' => { 24 => 0x203 },
    'jpegtables' => { 24 => 0x15b },
    'jpgfromraw' => { 18 => 0x2007, 83 => 'JpgFromRaw' },
    'jpgfromrawlength' => { 24 => 0x202 },
    'jpgfromrawstart' => { 24 => 0x201 },
    'jumptoxpep' => { 73 => 0x41c },
    'keywords' => { 34 => 0x19, 82 => 'Keywords' },
    'kodakbordersifd' => { 24 => 0xc36f },
    'kodakeffectsifd' => { 24 => 0xc36e },
    'kodakimageheight' => { 46 => 0xe, 48 => 0x70 },
    'kodakimagewidth' => { 46 => 0xc, 48 => 0x6c },
    'kodakmaker' => { 48 => 0x8 },
    'kodakmodel' => { 46 => 0x0, 48 => 0x28 },
    'label' => { 44 => 'lbl ' },
    'language' => { 82 => 'Language' },
    'languageidentifier' => { 34 => 0x87 },
    'lastfilenumber' => { 54 => 0x1b },
    'lasturl' => { 82 => 'LastURL' },
    'layersgroupinfo' => { 73 => 0x402 },
    'layerstateinfo' => { 73 => 0x400 },
    'lcdpanels' => { 11 => 0x8 },
    'lens' => { 24 => 0xfdea, 60 => 0x84, 65 => 0x201, 79 => 0xa, 82 => 'Lens', 83 => 'Lens' },
    'lens35efl' => { 83 => 'Lens35efl' },
    'lensafstopbutton' => { 10 => 0x11, 11 => 0x13, 12 => 0x10, 13 => 0x9 },
    'lensdata0101' => { 60 => 0x98 },
    'lensdata0201' => { 60 => 0x98 },
    'lensdataunknown' => { 60 => 0x98 },
    'lensdataversion' => { 59 => 0x0 },
    'lensfirmwareversion' => { 65 => 0x204 },
    'lensfstops' => { 59 => 0xc, 60 => 0x8b },
    'lensid' => { 59 => 0xb },
    'lensserialnumber' => { 65 => 0x202 },
    'lensspec' => { 83 => 'LensSpec' },
    'lenstype' => { 0 => 0x16, 60 => 0x83, 71 => 0x3f },
    'lightsource' => { 24 => 0x9208, 60 => 0x90, 82 => 'LightSource' },
    'lightsourcespecial' => { 78 => 0x21d },
    'linearizationtable' => { 24 => 0xc618 },
    'linearresponselimit' => { 24 => 0xc62e },
    'localcaption' => { 34 => 0x79 },
    'localizedcameramodel' => { 24 => 0xc615 },
    'location' => { 82 => 'Location' },
    'longexposurenoisereduction' => { 12 => 0x1, 13 => 0x1 },
    'longfocal' => { 0 => 0x17 },
    'lookuptable' => { 37 => 0x50 },
    'luminance' => { 31 => 'lumi' },
    'luminancesmoothing' => { 82 => 'LuminanceSmoothing' },
    'macintoshprintinfo' => { 73 => 0x3e9 },
    'macro' => { 25 => 0x1020, 51 => 0x2b, 68 => 0x202, 78 => 0x202 },
    'macrofocus' => { 68 => 0x100e },
    'macromode' => { 0 => 0x1, 54 => 0xb, 64 => 0x300, 70 => 0x1c },
    'magnification' => { 24 => 0xc367 },
    'make' => { 19 => 0x0, 24 => 0x10f, 82 => 'Make' },
    'makeandmodel' => { 31 => 'mmod' },
    'makernote' => { 82 => 'MakerNote' },
    'makernotecanon' => { 24 => 0x927c },
    'makernotecasio' => { 24 => 0x927c },
    'makernotecasio2' => { 24 => 0x927c },
    'makernotecasioex-z3' => { 24 => 0x927c },
    'makernotefujifilm' => { 24 => 0x927c },
    'makernotekodak1a' => { 24 => 0x927c },
    'makernotekodak1b' => { 24 => 0x927c },
    'makernotekodak2' => { 24 => 0x927c },
    'makernotekodak3' => { 24 => 0x927c },
    'makernotekodak4' => { 24 => 0x927c },
    'makernotekodak5' => { 24 => 0x927c },
    'makernotekodak6a' => { 24 => 0x927c },
    'makernotekodak6b' => { 24 => 0x927c },
    'makernotekodakunknown' => { 24 => 0x927c },
    'makernotekyocera' => { 24 => 0x927c },
    'makernoteleica' => { 24 => 0x927c },
    'makernoteminolta' => { 24 => 0x927c },
    'makernotenikon' => { 24 => 0x927c },
    'makernotenikon2' => { 24 => 0x927c },
    'makernotenikon3' => { 24 => 0x927c },
    'makernoteoffset' => { 78 => 0xff },
    'makernoteolympus' => { 24 => 0x927c },
    'makernotepanasonic' => { 24 => 0x927c },
    'makernotepentax' => { 24 => 0x927c },
    'makernotericoh' => { 24 => 0x927c },
    'makernotericohtext' => { 24 => 0x927c },
    'makernotesafety' => { 24 => 0xc635 },
    'makernotesanyo' => { 24 => 0x927c },
    'makernotesigma' => { 24 => 0x927c },
    'makernotesony' => { 24 => 0x927c },
    'makernotetype' => { 75 => 0x1 },
    'makernoteunknown' => { 24 => 0x927c },
    'makernoteversion' => { 55 => 0x0, 68 => 0x0, 75 => 0x2 },
    'managedfrom' => { 82 => 'ManagedFrom' },
    'managedfromdocumentid' => { 82 => 'ManagedFromDocumentID' },
    'managedfrominstanceid' => { 82 => 'ManagedFromInstanceID' },
    'managedfrommanager' => { 82 => 'ManagedFromManager' },
    'managedfrommanagervariant' => { 82 => 'ManagedFromManagerVariant' },
    'managedfrommanageto' => { 82 => 'ManagedFromManageTo' },
    'managedfrommanageui' => { 82 => 'ManagedFromManageUI' },
    'managedfromrenditionclass' => { 82 => 'ManagedFromRenditionClass' },
    'managedfromrenditionparams' => { 82 => 'ManagedFromRenditionParams' },
    'managedfromversionid' => { 82 => 'ManagedFromVersionID' },
    'manager' => { 82 => 'Manager' },
    'managervariant' => { 82 => 'ManagerVariant' },
    'manageto' => { 82 => 'ManageTo' },
    'manageui' => { 82 => 'ManageUI' },
    'manualfocusdistance' => { 60 => 0x85, 78 => 0x223 },
    'manualtv' => { 11 => 0x5 },
    'marked' => { 82 => 'Marked' },
    'masterdocumentid' => { 34 => 0xb9 },
    'matteing' => { 24 => 0x80e3 },
    'maxaperture' => { 54 => 0x17 },
    'maxapertureatmaxfocal' => { 59 => 0x10, 65 => 0x206 },
    'maxapertureatminfocal' => { 59 => 0xf },
    'maxaperturevalue' => { 24 => 0x9205, 82 => 'MaxApertureValue' },
    'maxfocallength' => { 59 => 0xe, 65 => 0x208 },
    'maximumdensityrange' => { 37 => 0x8c },
    'maximumobjectsize' => { 40 => 0x5f },
    'maxsamplevalue' => { 24 => 0x119 },
    'maxsubfilesize' => { 40 => 0x14 },
    'mcuversion' => { 59 => 0x11 },
    'measuredev' => { 18 => 0x1814 },
    'measuredinfo' => { 18 => 0x3003 },
    'measurement' => { 31 => 'meas' },
    'measurementbacking' => { 32 => 0xc },
    'measurementflare' => { 32 => 0x1c },
    'measurementgeometry' => { 32 => 0x18 },
    'measurementilluminant' => { 32 => 0x20 },
    'measurementobserver' => { 32 => 0x8 },
    'mediablackpoint' => { 31 => 'bkpt' },
    'mediadata' => { 44 => 'mdat' },
    'mediawhitepoint' => { 31 => 'wtpt' },
    'menubuttondisplayposition' => { 10 => 0xb, 12 => 0xa },
    'menubuttonreturn' => { 13 => 0xb },
    'metadatadate' => { 82 => 'MetadataDate' },
    'metadatanumber' => { 24 => 0xc365 },
    'meteringmode' => { 0 => 0x11, 24 => 0x9207, 46 => 0x1c, 54 => 0x7, 64 => 0x202, 71 => 0x17, 79 => 0x9, 82 => 'MeteringMode' },
    'minfocallength' => { 59 => 0xd, 65 => 0x207 },
    'minoltaaperture' => { 54 => 0xa },
    'minoltacamerasettings' => { 55 => 0x3, 68 => 0x3 },
    'minoltacamerasettings2' => { 55 => 0xf00 },
    'minoltacamerasettingsold' => { 55 => 0x1, 68 => 0x1 },
    'minoltadate' => { 54 => 0x15 },
    'minoltaimagesize' => { 54 => 0x4 },
    'minoltaiso' => { 54 => 0x8 },
    'minoltamodel' => { 54 => 0x25 },
    'minoltaquality' => { 54 => 0x5, 55 => [0x102,0x103], 68 => [0x102,0x103] },
    'minoltashutterspeed' => { 54 => 0x9 },
    'minoltatime' => { 54 => 0x16 },
    'minsamplevalue' => { 24 => 0x118 },
    'mirrorlockup' => { 10 => 0xc, 11 => 0xc, 12 => 0xb, 13 => 0x3 },
    'moddate' => { 82 => 'ModDate' },
    'model' => { 19 => 0x6, 24 => 0x110, 82 => 'Model' },
    'model2' => { 24 => 0x827d },
    'modelandversion' => { 24 => 0xc35c },
    'modeltiepoint' => { 24 => 0x8482 },
    'modeltransform' => { 24 => 0x85d8 },
    'modenumber' => { 24 => 0x195 },
    'modifiedsaturation' => { 64 => 0x504 },
    'modifydate' => { 24 => 0x132, 82 => 'ModifyDate' },
    'moirefilter' => { 24 => 0xfe58 },
    'mpeg7binary' => { 44 => 'mp7b' },
    'namedcolor' => { 31 => 'ncol' },
    'namedcolor2' => { 31 => 'ncl2' },
    'nativedisplayinfo' => { 31 => 'ndin' },
    'nativeresolutionunit' => { 24 => 0xc37a },
    'nativexresolution' => { 24 => 0xc36c },
    'nativeyresolution' => { 24 => 0xc36d },
    'nefcurve1' => { 60 => 0x8c },
    'nefcurve2' => { 60 => 0x96 },
    'nefthumbnailsize' => { 60 => 0x99 },
    'newsphotoversion' => { 37 => 0x0 },
    'nickname' => { 82 => 'Nickname' },
    'nikoncaptureoffsets' => { 60 => 0xe0e },
    'nikonpreview' => { 60 => 0x11 },
    'noise' => { 24 => [0x920d,0xa20d] },
    'noisefilter2' => { 67 => 0x1010 },
    'noisereduction' => { 60 => 0x95, 64 => 0x50a, 70 => 0x2d },
    'nullrecord' => { 18 => 0x0 },
    'numberlist' => { 44 => 'nlst' },
    'numberofcomponents' => { 43 => 0x8 },
    'numberofinks' => { 24 => 0x14e },
    'numindexentries' => { 37 => 0x54 },
    'objectattributereference' => { 34 => 0x4 },
    'objectcycle' => { 34 => 0x4b },
    'objectdistance' => { 22 => 0x6, 23 => 0x2022 },
    'objectname' => { 34 => 0x5 },
    'objectpreviewdata' => { 34 => 0xca },
    'objectpreviewfileformat' => { 34 => 0xc8 },
    'objectpreviewfileversion' => { 34 => 0xc9 },
    'objectsizeannounced' => { 40 => 0x5a },
    'objecttypereference' => { 34 => 0x3 },
    'obsoletephotoshoptag1' => { 73 => 0x3fc },
    'obsoletephotoshoptag2' => { 73 => 0x3ff },
    'obsoletephotoshoptag3' => { 73 => 0x403 },
    'oceapplicationselector' => { 24 => 0xc428 },
    'oceidnumber' => { 24 => 0xc429 },
    'oceimagelogic' => { 24 => 0xc42a },
    'ocescanjobdesc' => { 24 => 0xc427 },
    'oecfcolumns' => { 82 => 'OECFColumns' },
    'oecfnames' => { 82 => 'OECFNames' },
    'oecfrows' => { 82 => 'OECFRows' },
    'oecfvalues' => { 82 => 'OECFValues' },
    'oldsubfiletype' => { 24 => 0xff },
    'olympusimageheight' => { 68 => 0x102f },
    'olympusimageheight2' => { 67 => 0x615 },
    'olympusimagewidth' => { 68 => 0x102e },
    'olympusimagewidth2' => { 67 => 0x614 },
    'onetouchwb' => { 68 => 0x302 },
    'opacity' => { 44 => 'opct' },
    'opiproxy' => { 24 => 0x15f },
    'opticalzoom' => { 51 => 0x20, 52 => 0x1c },
    'opticalzoomon' => { 78 => 0x219 },
    'opto-electricconvfactor' => { 24 => 0x8828, 82 => 'OECF' },
    'orientation' => { 24 => 0x112, 82 => 'Orientation' },
    'originalfilename' => { 18 => 0x816, 50 => 0x20 },
    'originaltransmissionreference' => { 34 => 0x67 },
    'originatingprogram' => { 34 => 0x41 },
    'otherimagelength' => { 24 => 0x202 },
    'otherimagestart' => { 24 => 0x201 },
    'outputresponse' => { 31 => 'resp' },
    'owner' => { 82 => 'Owner' },
    'ownerid' => { 34 => 0xbc },
    'ownername' => { 5 => 0x9, 18 => 0x810, 24 => 0xfde8 },
    'pagename' => { 24 => 0x11d },
    'pagenumber' => { 24 => 0x129 },
    'palette' => { 44 => 'pclr' },
    'panoramamode' => { 46 => 0x3c },
    'pcscitation' => { 27 => 0xc01 },
    'pdfversion' => { 82 => 'PDFVersion' },
    'pentaximagesize' => { 71 => 0x9 },
    'pentaxmode' => { 71 => 0x1 },
    'photometricinterpretation' => { 24 => 0x106, 82 => 'PhotometricInterpretation' },
    'photoshop2colortable' => { 73 => 0x3eb },
    'photoshop2info' => { 73 => 0x3e8 },
    'photoshopformat' => { 72 => 0x1 },
    'photoshopquality' => { 72 => 0x0 },
    'photoshopsettings' => { 24 => 0x8649 },
    'photoshopthumbnail' => { 73 => 0x40c },
    'pictinfo' => { 78 => 0x208 },
    'pictureinfo' => { 68 => 0x208 },
    'picturemode' => { 25 => 0x1031, 71 => 0xb },
    'pixelaspectratio' => { 17 => 0x2 },
    'pixelintensityrange' => { 24 => 0x84eb },
    'pixelscale' => { 24 => 0x830e },
    'planarconfiguration' => { 24 => 0x11c, 82 => 'PlanarConfiguration' },
    'postscript2crd0' => { 31 => 'psd0' },
    'postscript2crd1' => { 31 => 'psd1' },
    'postscript2crd2' => { 31 => 'psd2' },
    'postscript2csa' => { 31 => 'ps2s' },
    'precaptureframes' => { 68 => 0x300 },
    'predictor' => { 24 => 0x13d },
    'preview0' => { 31 => 'pre0' },
    'preview1' => { 31 => 'pre1' },
    'preview2' => { 31 => 'pre2' },
    'previewfocalplanexresolution' => { 7 => 0x6 },
    'previewfocalplaneyresolution' => { 7 => 0x8 },
    'previewifd_offset' => { 62 => 0x2 },
    'previewimage' => { 23 => 0x2000, 24 => 0x927c, 83 => 'PreviewImage' },
    'previewimagedata' => { 55 => 0x81, 68 => 0x81 },
    'previewimageheight' => { 7 => 0x4 },
    'previewimageinfo' => { 5 => 0xb6 },
    'previewimagelength' => { 7 => 0x2, 23 => 0x3, 24 => [0x117,0x202], 55 => 0x89, 63 => 0x202, 64 => 0x102, 68 => [0x89,0x1037], 71 => 0x3 },
    'previewimagesize' => { 23 => 0x2, 71 => 0x2, 83 => 'PreviewImageSize' },
    'previewimagestart' => { 7 => 0x5, 23 => 0x4, 24 => [0x111,0x201], 55 => 0x88, 63 => 0x201, 64 => 0x101, 68 => [0x88,0x1036], 71 => 0x4 },
    'previewimagevalid' => { 64 => 0x100, 68 => 0x1035 },
    'previewimagewidth' => { 7 => 0x3 },
    'primarychromaticities' => { 24 => 0x13f, 82 => 'PrimaryChromaticities' },
    'primaryplatform' => { 30 => 0x28 },
    'printflags' => { 73 => 0x3f3 },
    'printflagsinfo' => { 73 => 0x2710 },
    'printim' => { 23 => 0xe00, 24 => 0xc4a5, 55 => 0xe00, 60 => 0xe00, 68 => 0xe00, 70 => 0xe00, 71 => 0xe00, 75 => 0xe00, 78 => 0xe00, 80 => 0xe00, 81 => 0xe00 },
    'printquality' => { 24 => 0xc46c },
    'processgeotiff' => { 83 => 'ProcessGeoTiff' },
    'producer' => { 82 => 'Producer' },
    'productid' => { 35 => 0x32 },
    'profile' => { 44 => 'prfl' },
    'profileclass' => { 30 => 0xc },
    'profilecmmtype' => { 30 => 0x4 },
    'profileconnectionspace' => { 30 => [0x14,0x44] },
    'profilecreator' => { 30 => 0x50 },
    'profiledatetime' => { 30 => 0x18 },
    'profiledescription' => { 31 => 'desc' },
    'profiledescriptionml' => { 31 => 'dscm' },
    'profilefilesignature' => { 30 => 0x24 },
    'profileheader' => { 31 => 'Header' },
    'profileid' => { 30 => 0x54 },
    'profilesequencedesc' => { 31 => 'pseq' },
    'profiletype' => { 24 => 0x191 },
    'profileversion' => { 30 => 0x8 },
    'programversion' => { 34 => 0x46 },
    'progressivescans' => { 72 => 0x2 },
    'projazimuthangle' => { 27 => 0xc16 },
    'projcentereasting' => { 27 => 0xc12 },
    'projcenterlat' => { 27 => 0xc11 },
    'projcenterlong' => { 27 => 0xc10 },
    'projcenternorthing' => { 27 => 0xc13 },
    'projcoordtrans' => { 27 => 0xc03 },
    'projectedcstype' => { 27 => 0xc00 },
    'projection' => { 27 => 0xc02 },
    'projfalseeasting' => { 27 => 0xc0a },
    'projfalsenorthing' => { 27 => 0xc0b },
    'projfalseorigineasting' => { 27 => 0xc0e },
    'projfalseoriginlat' => { 27 => 0xc0d },
    'projfalseoriginlong' => { 27 => 0xc0c },
    'projfalseoriginnorthing' => { 27 => 0xc0f },
    'projlinearunits' => { 27 => 0xc04 },
    'projlinearunitsize' => { 27 => 0xc05 },
    'projnatoriginlat' => { 27 => 0xc09 },
    'projnatoriginlong' => { 27 => 0xc08 },
    'projrectifiedgridangle' => { 27 => 0xc18 },
    'projscaleatcenter' => { 27 => 0xc15 },
    'projscaleatnatorigin' => { 27 => 0xc14 },
    'projstdparallel1' => { 27 => 0xc06 },
    'projstdparallel2' => { 27 => 0xc07 },
    'projstraightvertpolelong' => { 27 => 0xc17 },
    'province-state' => { 34 => 0x5f },
    'ps2crdvmsize' => { 31 => 'psvm' },
    'ps2renteringintent' => { 31 => 'ps2i' },
    'pstringcaption' => { 73 => 0x3f0 },
    'publisher' => { 82 => 'Publisher' },
    'quality' => { 0 => 0x3, 22 => 0x2, 23 => 0x3002, 25 => 0x1000, 46 => 0x9, 60 => 0x4, 61 => 0x3, 68 => 0x201, 71 => 0x8, 79 => 0x16 },
    'qualitymode' => { 23 => 0x8 },
    'quantizationmethod' => { 37 => 0x78 },
    'quickmaskinfo' => { 73 => 0x3fe },
    'quickshot' => { 78 => 0x213 },
    'rasterizedcaption' => { 34 => 0x7d },
    'rasterpadding' => { 24 => 0x84e3 },
    'rawandjpgrecording' => { 10 => 0x8 },
    'rawdata' => { 18 => 0x2005 },
    'rawdevcolorspace' => { 69 => 0x108 },
    'rawdevcontrastvalue' => { 69 => 0x106 },
    'rawdeveditstatus' => { 69 => 0x10b },
    'rawdevelopment' => { 68 => 0x2030 },
    'rawdevengine' => { 69 => 0x109 },
    'rawdevexposurebiasvalue' => { 69 => 0x100 },
    'rawdevgraypoint' => { 69 => 0x103 },
    'rawdevmemorycoloremphasis' => { 69 => 0x105 },
    'rawdevnoisereduction' => { 69 => 0x10a },
    'rawdevsaturationemphasis' => { 69 => 0x104 },
    'rawdevsettings' => { 69 => 0x10c },
    'rawdevsharpnessvalue' => { 69 => 0x107 },
    'rawdevversion' => { 69 => 0x0 },
    'rawdevwbfineadjustment' => { 69 => 0x102 },
    'rawdevwhitebalancevalue' => { 69 => 0x101 },
    'rawfile' => { 24 => 0xfe4c },
    'rawfilename' => { 82 => 'RawFileName' },
    'rawimagemode' => { 73 => 0x405 },
    'rawimagesize' => { 71 => 0x39 },
    'readerrequirements' => { 44 => 'rreq' },
    'recordid' => { 18 => 0x1804 },
    'recordingmode' => { 22 => 0x1 },
    'recordmode' => { 23 => 0x3000 },
    'recordshutterrelease' => { 78 => 0x217 },
    'redbalance' => { 56 => 0x0, 57 => 0x0, 58 => 0x0, 68 => 0x1017, 71 => 0x1c },
    'redbalanceauto' => { 9 => 0x0 },
    'redbalanceb&w' => { 9 => 0xe },
    'redbalancecloudy' => { 9 => 0x4 },
    'redbalancecustom' => { 9 => 0xc },
    'redbalancedaylight' => { 9 => 0x2 },
    'redbalanceflash' => { 9 => 0xa },
    'redbalancefluorescent' => { 9 => 0x8 },
    'redbalanceshade' => { 9 => 0x10 },
    'redbalancetungsten' => { 9 => 0x6 },
    'redbluebias' => { 67 => 0x100 },
    'redeyereduction' => { 83 => 'RedEyeReduction' },
    'redgain' => { 77 => 'Rg' },
    'redhue' => { 82 => 'RedHue' },
    'redmatrixcolumn' => { 31 => 'rXYZ' },
    'redsaturation' => { 82 => 'RedSaturation' },
    'redtrc' => { 31 => 'rTRC' },
    'reductionmatrix1' => { 24 => 0xc625 },
    'reductionmatrix2' => { 24 => 0xc626 },
    'referenceblackwhite' => { 24 => 0x214, 82 => 'ReferenceBlackWhite' },
    'referencedate' => { 34 => 0x2f },
    'referencenumber' => { 34 => 0x32 },
    'referenceservice' => { 34 => 0x2d },
    'relatedimagefileformat' => { 24 => 0x1000 },
    'relatedimagelength' => { 24 => 0x1002 },
    'relatedimagewidth' => { 24 => 0x1001 },
    'relatedsoundfile' => { 24 => 0xa004, 82 => 'RelatedSoundFile' },
    'relation' => { 82 => 'Relation' },
    'releasedate' => { 34 => 0x1e },
    'releasesetting' => { 18 => 0x1016 },
    'releasetime' => { 34 => 0x23 },
    'renderingintent' => { 30 => 0x40 },
    'renditionclass' => { 82 => 'RenditionClass' },
    'renditionof' => { 82 => 'RenditionOf' },
    'renditionofdocumentid' => { 82 => 'RenditionOfDocumentID' },
    'renditionofinstanceid' => { 82 => 'RenditionOfInstanceID' },
    'renditionofmanager' => { 82 => 'RenditionOfManager' },
    'renditionofmanagervariant' => { 82 => 'RenditionOfManagerVariant' },
    'renditionofmanageto' => { 82 => 'RenditionOfManageTo' },
    'renditionofmanageui' => { 82 => 'RenditionOfManageUI' },
    'renditionofrenditionclass' => { 82 => 'RenditionOfRenditionClass' },
    'renditionofrenditionparams' => { 82 => 'RenditionOfRenditionParams' },
    'renditionofversionid' => { 82 => 'RenditionOfVersionID' },
    'renditionparams' => { 82 => 'RenditionParams' },
    'resaved' => { 78 => 0x21e },
    'resolution' => { 44 => 'res ' },
    'resolutioninfo' => { 73 => 0x3ed },
    'resolutionmode' => { 79 => 0x4 },
    'resolutionunit' => { 24 => 0x128, 63 => 0x128, 82 => 'ResolutionUnit' },
    'revision' => { 77 => ['Rev','Rv'] },
    'ricohdatetime1' => { 76 => 0x4 },
    'ricohdatetime2' => { 76 => 0x5 },
    'ricohrr1subdir' => { 75 => 0x2001 },
    'ricohsubdir' => { 75 => 0x2001 },
    'rights' => { 82 => 'Rights' },
    'roidescription' => { 44 => 'roid' },
    'rollguidelements' => { 24 => 0xc364 },
    'romoperationmode' => { 18 => 0x80d },
    'rotation' => { 17 => 0x3 },
    'rowsperstrip' => { 24 => 0x116 },
    'safetyshiftinavortv' => { 10 => 0x10, 11 => 0x10, 12 => 0xf },
    'sampleformat' => { 24 => 0x153 },
    'samplesperpixel' => { 24 => 0x115, 82 => 'SamplesPerPixel' },
    'samplestructure' => { 37 => 0x5a },
    'sanyoquality' => { 78 => 0x201 },
    'sanyothumbnail' => { 78 => 0x100 },
    'saturation' => { 0 => 0xe, 22 => 0xd, 23 => 0x1f, 24 => [0xa409,0xfe55], 25 => 0x1003, 54 => 0x1f, 60 => [0x94,0xaa], 71 => 0x1f, 79 => 0x10, 82 => 'Saturation' },
    'saveid' => { 82 => 'SaveID' },
    'sba_rgbshifts' => { 24 => 0xc35e },
    'sbaexposurerecord' => { 24 => 0xc361 },
    'sbainputimagebitdepth' => { 24 => 0xc360 },
    'sbainputimagecolorspace' => { 24 => 0xc35f },
    'scalefactor35efl' => { 83 => 'ScaleFactor35efl' },
    'scanningdirection' => { 37 => 0x64 },
    'scene' => { 82 => 'Scene' },
    'scenecapturetype' => { 24 => 0xa406, 82 => 'SceneCaptureType' },
    'scenemode' => { 60 => 0x8f, 64 => 0x509 },
    'sceneselect' => { 78 => 0x21f },
    'scenetype' => { 24 => 0xa301, 82 => 'SceneType' },
    'screening' => { 31 => 'scrn' },
    'screeningdesc' => { 31 => 'scrd' },
    'securityclassification' => { 24 => [0x9212,0xa212] },
    'self-timer' => { 0 => 0x2 },
    'self-timer2' => { 8 => 0x1d },
    'selftimer' => { 23 => 0x3001, 78 => 0x214 },
    'selftimermode' => { 24 => 0x882b },
    'selftimertime' => { 18 => 0x1806 },
    'sensingmethod' => { 24 => [0x9217,0xa217], 82 => 'SensingMethod' },
    'sensorbottomborder' => { 20 => 0x8 },
    'sensorcleaning' => { 13 => 0xd },
    'sensorheight' => { 20 => 0x2 },
    'sensorinfo' => { 18 => 0x1031 },
    'sensorleftborder' => { 20 => 0x5 },
    'sensorrightborder' => { 20 => 0x7 },
    'sensortopborder' => { 20 => 0x6 },
    'sensorwidth' => { 20 => 0x1 },
    'sequence' => { 64 => 0x600 },
    'sequencenumber' => { 8 => 0x9, 46 => 0x1d },
    'sequenceshotinterval' => { 78 => 0x224 },
    'sequentialshot' => { 78 => 0x20e },
    'serialnumber' => { 5 => 0xc, 18 => 0x180b, 24 => [0xc354,0xfde9], 60 => [0xa0,0x1d], 65 => 0x101, 68 => 0x101a, 70 => 0x25, 79 => 0x2, 82 => 'SerialNumber' },
    'serviceidentifier' => { 35 => 0x1e },
    'setbuttonfunction' => { 10 => 0x1, 13 => 0xc },
    'setfunctionwhenshooting' => { 12 => 0x0 },
    'shadingcompensation' => { 64 => 0x50c },
    'shadingcompensation2' => { 67 => 0x1012 },
    'shadow' => { 79 => 0xe },
    'shadows' => { 24 => 0xfe52, 82 => 'Shadows' },
    'shadowscale' => { 24 => 0xc633 },
    'shadowtint' => { 82 => 'ShadowTint' },
    'sharpness' => { 0 => 0xf, 22 => 0xb, 23 => 0x21, 24 => [0xa40a,0xfe56], 25 => 0x1001, 46 => 0x6b, 49 => 0x37, 54 => 0x21, 60 => 0x6, 71 => 0x21, 79 => 0x11, 82 => 'Sharpness' },
    'sharpnessfactor' => { 68 => [0x100f,0x102a] },
    'sharpnesssetting' => { 64 => 0x506 },
    'shootingmode' => { 60 => 0x89, 70 => 0x1f, 83 => 'ShootingMode' },
    'shootingrecord' => { 18 => 0x3002 },
    'shortdocumentid' => { 34 => 0xba },
    'shortfocal' => { 0 => 0x18 },
    'shutter-aelock' => { 10 => 0x4, 12 => 0x3, 13 => 0x2 },
    'shutteraelbutton' => { 11 => 0x4 },
    'shuttercount' => { 3 => 0x1, 60 => 0xa7 },
    'shuttercurtainhack' => { 83 => 'ShutterCurtainHack' },
    'shuttercurtainsync' => { 10 => 0xf, 11 => 0xf, 12 => 0xe, 13 => 0x8 },
    'shuttermode' => { 46 => 0x1b },
    'shutterreleasemethod' => { 18 => 0x1010 },
    'shutterreleasenocfcard' => { 10 => 0x2, 11 => 0x2, 13 => 0xf },
    'shutterreleasetiming' => { 18 => 0x1011 },
    'shutterspeed' => { 83 => 'ShutterSpeed' },
    'shutterspeedvalue' => { 24 => 0x9201, 82 => 'ShutterSpeedValue' },
    'similarityindex' => { 34 => 0xe4 },
    'site' => { 24 => 0x84e0 },
    'sizemode' => { 40 => 0xa },
    'slices' => { 73 => 0x41a },
    'slowsync' => { 25 => 0x1030 },
    'smaxsamplevalue' => { 24 => 0x155 },
    'sminsamplevalue' => { 24 => 0x154 },
    'smoothingparameter1' => { 67 => 0x300 },
    'smoothingparameter2' => { 67 => 0x310 },
    'smoothingthreshold2' => { 67 => 0x610 },
    'smoothingthresholds' => { 67 => 0x600 },
    'smoothness' => { 24 => 0xfe57 },
    'software' => { 24 => 0x131, 79 => 0x18, 82 => 'Software' },
    'softwareversion' => { 78 => 0x207 },
    'source' => { 34 => 0x73, 82 => 'Source' },
    'sourceimagedirectory' => { 24 => 0xc418 },
    'sourceimagefilename' => { 24 => 0xc419 },
    'sourceimagevolumename' => { 24 => 0xc41a },
    'spatialfrequencyresponse' => { 24 => [0x920c,0xa20c], 82 => 'SpatialFrequencyResponse' },
    'spatialfrequencyresponsecolumns' => { 82 => 'SpatialFrequencyResponseColumns' },
    'spatialfrequencyresponsenames' => { 82 => 'SpatialFrequencyResponseNames' },
    'spatialfrequencyresponserows' => { 82 => 'SpatialFrequencyResponseRows' },
    'spatialfrequencyresponsevalues' => { 82 => 'SpatialFrequencyResponseValues' },
    'specialinstructions' => { 34 => 0x28 },
    'specialmode' => { 68 => 0x200, 78 => 0x200 },
    'spectralsensitivity' => { 24 => 0x8824, 82 => 'SpectralSensitivity' },
    'spotfocuspointx' => { 54 => 0x2d },
    'spotfocuspointy' => { 54 => 0x2e },
    'spothalftone' => { 73 => 0x413 },
    'spotmode' => { 70 => 0xf },
    'state' => { 82 => 'State' },
    'stonits' => { 24 => 0x923f },
    'stripbytecounts' => { 24 => 0x117 },
    'stripoffsets' => { 24 => 0x111 },
    'striprowcounts' => { 24 => 0x22f },
    'sub-location' => { 34 => 0x5c },
    'subfile' => { 38 => 0xa },
    'subfiletype' => { 24 => 0xfe },
    'subifd' => { 24 => 0x14a },
    'subifd_offset' => { 62 => 0x3 },
    'subject' => { 82 => 'Subject' },
    'subjectarea' => { 82 => 'SubjectArea' },
    'subjectcode' => { 82 => 'SubjectCode' },
    'subjectdistance' => { 24 => 0x9206, 46 => 0x3e, 82 => 'SubjectDistance' },
    'subjectdistancerange' => { 24 => 0xa40c, 82 => 'SubjectDistanceRange' },
    'subjectlocation' => { 24 => [0x9214,0xa214], 82 => 'SubjectLocation' },
    'subjectprogram' => { 54 => 0x22 },
    'subjectreference' => { 34 => 0xc },
    'subsecdatetimeoriginal' => { 83 => 'SubSecDateTimeOriginal' },
    'subsectime' => { 24 => 0x9290 },
    'subsectimedigitized' => { 24 => 0x9292 },
    'subsectimeoriginal' => { 24 => 0x9291 },
    'superimposeddisplay' => { 10 => 0xa, 12 => 0x9, 13 => 0xe },
    'supplementalcategories' => { 34 => 0x14, 82 => 'SupplementalCategories' },
    'supplementaltype' => { 37 => 0x37 },
    'switchtoregisteredafpoint' => { 11 => 0x12 },
    't4options' => { 24 => 0x124 },
    't6options' => { 24 => 0x125 },
    'targetcompressionratio' => { 16 => 0x1 },
    'targetdistancesetting' => { 18 => 0x1807 },
    'targetimagetype' => { 18 => 0x100a },
    'targetprinter' => { 24 => 0x151 },
    'technology' => { 31 => 'tech' },
    'thresholding' => { 24 => 0x107 },
    'thumbnailfilename' => { 18 => 0x817 },
    'thumbnailimage' => { 18 => 0x2008, 68 => 0x100, 83 => 'ThumbnailImage' },
    'thumbnaillength' => { 24 => 0x202 },
    'thumbnailoffset' => { 24 => 0x201 },
    'thumbnailresource' => { 73 => 0x409 },
    'thumbnails' => { 82 => 'Thumbnails' },
    'thumbnailsformat' => { 82 => 'ThumbnailsFormat' },
    'thumbnailsheight' => { 82 => 'ThumbnailsHeight' },
    'thumbnailsimage' => { 82 => 'ThumbnailsImage' },
    'thumbnailswidth' => { 82 => 'ThumbnailsWidth' },
    'tiff-epstandardid' => { 24 => [0x9216,0xa216] },
    'tilebytecounts' => { 24 => 0x145 },
    'tiledepth' => { 24 => 0x80e6 },
    'tilelength' => { 24 => 0x143 },
    'tileoffsets' => { 24 => 0x144 },
    'tilewidth' => { 24 => 0x142 },
    'time' => { 46 => 0x14, 49 => 0x10, 71 => 0x7 },
    'timecreated' => { 34 => 0x3c },
    'timesent' => { 35 => 0x50 },
    'timestamp' => { 18 => 0x180e },
    'timezone' => { 23 => 0x3006 },
    'timezonecode' => { 21 => 0x1 },
    'timezoneinfo' => { 21 => 0x2 },
    'timezoneoffset' => { 24 => 0x882a },
    'title' => { 82 => 'Title' },
    'tonecomp' => { 60 => 0x81 },
    'tonecurve' => { 71 => 0x402 },
    'tonecurves' => { 71 => 0x403 },
    'totalzoom' => { 46 => 0x62 },
    'transferfunction' => { 24 => 0x12d, 82 => 'TransferFunction' },
    'transferrange' => { 24 => 0x156 },
    'transmissionreference' => { 82 => 'TransmissionReference' },
    'transparencyindicator' => { 24 => 0x84ec },
    'transparentindex' => { 73 => 0x417 },
    'tvvalue' => { 14 => 0x1 },
    'type' => { 82 => 'Type' },
    'ucrbg' => { 31 => 'bfd ' },
    'unicodealphanames' => { 73 => 0x415 },
    'uniquecameramodel' => { 24 => 0xc614 },
    'uniquedocumentid' => { 34 => 0xbb },
    'uniqueobjectname' => { 35 => 0x64 },
    'urgency' => { 34 => 0xa, 82 => 'Urgency' },
    'url' => { 44 => 'url ', 73 => 0x40b },
    'url_list' => { 73 => 0x41e },
    'usageterms' => { 82 => 'UsageTerms' },
    'useradjsba_rgbshifts' => { 24 => 0xc362 },
    'usercomment' => { 18 => 0x805, 24 => 0x9286, 82 => 'UserComment' },
    'userselectgrouptitle' => { 24 => 0xc355 },
    'usmlenselectronicmf' => { 11 => 0x7 },
    'uuid-geojp2' => { 44 => 'uuid' },
    'uuid-unknown' => { 44 => 'uuid' },
    'uuid-xmp' => { 44 => 'uuid' },
    'uuidinfo' => { 44 => 'uinf' },
    'uuidlist' => { 44 => 'ulst' },
    'validbits' => { 67 => 0x611, 68 => 0x102c },
    'variousmodes' => { 46 => 0x26 },
    'variousmodes2' => { 46 => 0x3a },
    'variprogram' => { 60 => 0xab },
    'version' => { 25 => 0x0, 82 => 'Version' },
    'versionid' => { 82 => 'VersionID' },
    'versioninfo' => { 73 => 0x421 },
    'versions' => { 82 => 'Versions' },
    'versionscomments' => { 82 => 'VersionsComments' },
    'versionsevent' => { 82 => 'VersionsEvent' },
    'versionseventaction' => { 82 => 'VersionsEventAction' },
    'versionseventinstanceid' => { 82 => 'VersionsEventInstanceID' },
    'versionseventparameters' => { 82 => 'VersionsEventParameters' },
    'versionseventsoftwareagent' => { 82 => 'VersionsEventSoftwareAgent' },
    'versionseventwhen' => { 82 => 'VersionsEventWhen' },
    'versionsmodifier' => { 82 => 'VersionsModifier' },
    'versionsmodifydate' => { 82 => 'VersionsModifyDate' },
    'versionsversion' => { 82 => 'VersionsVersion' },
    'versionyear' => { 24 => 0x194 },
    'verticalcitation' => { 27 => 0x1001 },
    'verticalcstype' => { 27 => 0x1000 },
    'verticaldatum' => { 27 => 0x1002 },
    'verticalunits' => { 27 => 0x1003 },
    'videocardgamma' => { 31 => 'vcgt' },
    'viewingconddesc' => { 31 => 'vued' },
    'viewingcondilluminant' => { 33 => 0x8 },
    'viewingcondilluminanttype' => { 33 => 0x20 },
    'viewingconditions' => { 31 => 'view' },
    'viewingcondsurround' => { 33 => 0x14 },
    'vignetteamount' => { 82 => 'VignetteAmount' },
    'vignettemidpoint' => { 82 => 'VignetteMidpoint' },
    'voicememo' => { 78 => 0x216 },
    'wangannotation' => { 24 => 0x80a4 },
    'warning' => { 84 => 'Warning' },
    'watermark' => { 73 => 0x410 },
    'watermarktype' => { 45 => 0x8 },
    'webstatement' => { 82 => 'WebStatement' },
    'whitebalance' => { 8 => 0x7, 22 => 0x7, 23 => [0x19,0x2012], 24 => [0xa403,0xfe4e], 25 => 0x1002, 46 => 0x40, 51 => 0x1a, 54 => 0x3, 60 => 0x5, 61 => 0x7, 68 => 0x1015, 70 => 0x3, 71 => 0x19, 79 => 0x7, 82 => 'WhiteBalance' },
    'whitebalancebias' => { 23 => 0x2011, 70 => 0x23 },
    'whitebalancebracket' => { 64 => 0x502 },
    'whitebalancefinetune' => { 60 => 0xb },
    'whitebalancemode' => { 71 => 0x1a },
    'whitebalancetable' => { 5 => 0xa9, 18 => 0x10a9 },
    'whitebalancetemperature' => { 64 => 0x501 },
    'whitelevel' => { 24 => 0xc61d },
    'whitepoint' => { 24 => 0x13e, 71 => 0x201, 82 => 'WhitePoint' },
    'widefocuszone' => { 54 => 0x2f },
    'widerange' => { 78 => 0x20f },
    'workflowurl' => { 73 => 0x41b },
    'workingpath' => { 73 => 0x401 },
    'worldtimelocation' => { 71 => 0x22 },
    'writer-editor' => { 34 => 0x7a },
    'x3filllight' => { 79 => 0x12 },
    'xclippathunits' => { 24 => 0x158 },
    'xml' => { 44 => 'xml ' },
    'xmldata' => { 73 => 0x3ea },
    'xmp' => { 84 => 'XMP' },
    'xpauthor' => { 24 => 0x9c9d },
    'xpcomment' => { 24 => 0x9c9c },
    'xpkeywords' => { 24 => 0x9c9e },
    'xposition' => { 24 => 0x11e },
    'xpsubject' => { 24 => 0x9c9f },
    'xptitle' => { 24 => 0x9c9b },
    'xresolution' => { 24 => 0x11a, 63 => 0x11a, 82 => 'XResolution' },
    'ycbcrcoefficients' => { 24 => 0x211, 82 => 'YCbCrCoefficients' },
    'ycbcrpositioning' => { 24 => 0x213, 63 => 0x213 },
    'ycbcrsubsampling' => { 24 => 0x212, 82 => 'YCbCrSubSampling' },
    'yclippathunits' => { 24 => 0x159 },
    'yposition' => { 24 => 0x11f },
    'yresolution' => { 24 => 0x11b, 63 => 0x11b, 82 => 'YResolution' },
    'zoom' => { 68 => 0x100d },
    'zoomedresolution' => { 0 => 0x24 },
    'zoomedresolutionbase' => { 0 => 0x25 },
    'zoomposition' => { 66 => 0x300 },
);

#++++ End automatically generated code ++++


#------------------------------------------------------------------------------
# find information for tag (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        &$writeProc();
                        @infoList = GetTagInfoList($table,$tagID);
                    }
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for all tag names

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2005, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
