#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorBalance1',
	'Image::ExifTool::Canon::ColorBalance2',
	'Image::ExifTool::Canon::ColorBalance3',
	'Image::ExifTool::Canon::ColorBalance4',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Raw',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::Microsoft',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 52 => 0x69 },
	'about' => { 207 => 'about' },
	'abspeakaudiofilepath' => { 212 => 'absPeakAudioFilePath' },
	'accessorytype' => { 160 => 0x53 },
	'actionadvised' => { 63 => 0x2a },
	'activearea' => { 57 => 0xc68d },
	'actived-lighting' => { 119 => 0x22, 137 => 0x24 },
	'actived-lightingmode' => { 137 => 0x25 },
	'addaspectratioinfo' => { 34 => 0x80e },
	'additionalmodelinformation' => { 200 => 'AdditionalModelInformation' },
	'addoriginaldecisiondata' => { 34 => 0x80f, 35 => 0x11, 36 => 0x13, 39 => 0x14 },
	'address' => { 86 => 'Address' },
	'adjustmentmode' => { 185 => [0x15,0x22] },
	'adultcontentwarning' => { 203 => 'AdultContentWarning', 206 => 'adultContentWarning' },
	'advancedraw' => { 139 => 0x76a43203 },
	'advisory' => { 210 => 'Advisory' },
	'ae_iso' => { 162 => 0x2 },
	'aeaperture' => { 162 => 0x1 },
	'aebautocancel' => { 34 => 0x104 },
	'aebbracketvalue' => { 31 => 0x11 },
	'aebsequence' => { 32 => 0x9, 33 => 0x9, 34 => 0x105, 35 => 0x8, 36 => 0x9, 39 => 0x9, 40 => 0x7 },
	'aebshotcount' => { 34 => 0x106 },
	'aebxv' => { 162 => 0x4 },
	'aeexposuretime' => { 162 => 0x0 },
	'aeextra' => { 162 => 0x7 },
	'aelock' => { 127 => '733.3', 128 => '752.2', 146 => 0x201, 173 => 0x48 },
	'aelockbutton' => { 127 => '733.2', 128 => '752.1' },
	'aemaxaperture' => { 162 => 0x9 },
	'aemaxaperture2' => { 162 => 0xa },
	'aemeteringmode' => { 162 => 0xc },
	'aemeteringsegments' => { 173 => 0x209 },
	'aeminaperture' => { 162 => 0xb },
	'aeminexposuretime' => { 162 => 0x5 },
	'aeprogrammode' => { 162 => 0x6 },
	'aesetting' => { 12 => 0x21 },
	'aexv' => { 162 => 0x3 },
	'af-cpriorityselection' => { 126 => '791.1' },
	'af-onformb-d10' => { 126 => '793.1' },
	'af-spriorityselection' => { 126 => '791.2' },
	'afactivation' => { 126 => '792.1' },
	'afadjustment' => { 173 => 0x72 },
	'afaperture' => { 117 => 0x5, 118 => 0x5 },
	'afareaillumination' => { 128 => '763.3' },
	'afareamode' => { 103 => 0x0, 104 => 0x5, 128 => 0x2fc },
	'afareamodesetting' => { 127 => 0x2e4 },
	'afareas' => { 146 => 0x304 },
	'afassist' => { 32 => 0x5, 40 => 0x5, 127 => '729.2', 128 => '748.2' },
	'afassistbeam' => { 34 => 0x50e, 35 => 0x4, 36 => 0x5, 37 => 0x4, 38 => 0x4, 39 => 0x5 },
	'afassistilluminator' => { 126 => '792.4' },
	'afdefocus' => { 163 => 0x6 },
	'afduringliveview' => { 34 => 0x511 },
	'afexpansionwithselectedpoint' => { 34 => 0x508 },
	'affinetuneadj' => { 126 => 0x2d1 },
	'afintegrationtime' => { 163 => 0x7 },
	'afmicroadjustment' => { 34 => 0x507 },
	'afmode' => { 160 => 0xf, 185 => 0x5 },
	'afonaelockbuttonswitch' => { 34 => 0x702 },
	'afpoint' => { 12 => 0x13, 53 => 0x18, 103 => 0x1, 149 => 0x308 },
	'afpointactivationarea' => { 33 => 0x11, 39 => 0x11 },
	'afpointautoselection' => { 34 => 0x50b },
	'afpointbrightness' => { 34 => 0x50d },
	'afpointdisplayduringfocus' => { 34 => 0x50c },
	'afpointillumination' => { 33 => 0xa, 126 => '792.3' },
	'afpointmode' => { 166 => 0x3 },
	'afpointposition' => { 54 => 0x2021 },
	'afpointregistration' => { 32 => 0x7 },
	'afpoints' => { 97 => 0x10 },
	'afpointselected' => { 173 => 0xe },
	'afpointselected2' => { 166 => 0x4 },
	'afpointselection' => { 33 => 0xb, 126 => '791.3' },
	'afpointselectionmethod' => { 34 => 0x50f, 35 => 0xc, 36 => 0xd, 39 => 0xd },
	'afpointsinfocus' => { 31 => 0xe, 103 => 0x2, 163 => 0xb, 173 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 9 => 0x38 },
	'afpointspotmetering' => { 33 => 0xd },
	'afpointsunknown1' => { 163 => 0x0 },
	'afpointsunknown2' => { 163 => 0x2 },
	'afpointsused' => { 104 => 0x8 },
	'afpredictor' => { 163 => 0x4 },
	'afresponse' => { 119 => 0xad },
	'afresult' => { 151 => 0x1038 },
	'afsearch' => { 146 => 0x303 },
	'aggregationtype' => { 204 => 'aggregationType' },
	'agreement' => { 206 => 'agreement' },
	'aiservoimagepriority' => { 34 => 0x503 },
	'aiservotrackingmethod' => { 34 => 0x504 },
	'aiservotrackingsensitivity' => { 33 => 0x14, 34 => 0x502 },
	'album' => { 212 => 'album' },
	'alreadyapplied' => { 195 => 'AlreadyApplied' },
	'alternatetitle' => { 204 => 'alternateTitle' },
	'alttapename' => { 212 => 'altTapeName' },
	'alttimecodetimeformat' => { 212 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 212 => 'altTimecodeTimeValue' },
	'alttimecodevalue' => { 212 => 'altTimecodeValue' },
	'anti-blur' => { 186 => 0xb04b },
	'antialiasstrength' => { 57 => 0xc632 },
	'aperturerange' => { 34 => 0x10d },
	'apertureringuse' => { 166 => '1.4' },
	'aperturevalue' => { 43 => 0x2, 57 => 0x9202, 151 => 0x1002, 198 => 'ApertureValue' },
	'applekeywords' => { 155 => 'AAPL:Keywords' },
	'applicationnotes' => { 57 => 0x2bc },
	'applicationrecordversion' => { 63 => 0x0 },
	'applyshootingmeteringmode' => { 34 => 0x10e },
	'approximatefnumber' => { 158 => 0x313 },
	'armidentifier' => { 64 => 0x78 },
	'armversion' => { 64 => 0x7a },
	'artist' => { 57 => 0x13b, 157 => 'Artist', 208 => 'Artist', 212 => 'artist' },
	'artworkcopyrightnotice' => { 200 => 'ArtworkOrObjectAOCopyrightNotice' },
	'artworkcreator' => { 200 => 'ArtworkOrObjectAOCreator' },
	'artworkdatecreated' => { 200 => 'ArtworkOrObjectAODateCreated' },
	'artworksource' => { 200 => 'ArtworkOrObjectAOSource' },
	'artworksourceinventoryno' => { 200 => 'ArtworkOrObjectAOSourceInvNo' },
	'artworktitle' => { 200 => 'ArtworkOrObjectAOTitle' },
	'asshoticcprofile' => { 57 => 0xc68f },
	'asshotneutral' => { 57 => 0xc628 },
	'asshotpreprofilematrix' => { 57 => 0xc690 },
	'asshotprofilename' => { 57 => 0xc6f6 },
	'asshotwhitexy' => { 57 => 0xc629 },
	'assignfuncbutton' => { 34 => 0x70b },
	'assistbuttonfunction' => { 32 => 0xd },
	'attributionname' => { 194 => 'attributionName' },
	'attributionurl' => { 194 => 'attributionURL' },
	'audio' => { 160 => 0x20 },
	'audiochanneltype' => { 212 => 'audioChannelType' },
	'audiocompression' => { 80 => 'Compression' },
	'audiocompressor' => { 212 => 'audioCompressor' },
	'audioduration' => { 63 => 0x99 },
	'audiomoddate' => { 212 => 'audioModDate' },
	'audiooutcue' => { 63 => 0x9a },
	'audiosamplerate' => { 212 => 'audioSampleRate' },
	'audiosampletype' => { 212 => 'audioSampleType' },
	'audiosamplingrate' => { 63 => 0x97 },
	'audiosamplingresolution' => { 63 => 0x98 },
	'audiotype' => { 63 => 0x96 },
	'author' => { 82 => 'Author', 155 => 'Author', 157 => 'Author', 181 => 'Author', 201 => 'Author' },
	'authorsposition' => { 202 => 'AuthorsPosition' },
	'autoaperture' => { 170 => '0.1' },
	'autobracket' => { 185 => 0x19 },
	'autobracketing' => { 61 => 0x1100, 173 => 0x18 },
	'autobracketmodem' => { 126 => '811.2' },
	'autobracketorder' => { 126 => '811.3', 128 => '750.2' },
	'autobracketrelease' => { 119 => 0x8a },
	'autobracketset' => { 126 => '811.1', 128 => '750.1' },
	'autobrightness' => { 195 => 'AutoBrightness' },
	'autocontrast' => { 195 => 'AutoContrast' },
	'autoexposure' => { 195 => 'AutoExposure' },
	'autoexposurebracketing' => { 31 => 0x10 },
	'autofocus' => { 104 => 0x6, 149 => 0x209 },
	'autofp' => { 128 => '755.3' },
	'autoiso' => { 31 => 0x1, 54 => 0x3008, 127 => '730.1', 128 => '749.1' },
	'autoisomax' => { 127 => '730.2', 128 => '749.2' },
	'autoisominshutterspeed' => { 127 => '730.3', 128 => '749.3' },
	'autolightingoptimizer' => { 34 => 0x204, 52 => 0x6f },
	'autolightingoptimizeron' => { 52 => 0x6e },
	'autoredeye' => { 139 => 0xfe28a44f },
	'autorotate' => { 31 => 0x1b },
	'autoshadows' => { 195 => 'AutoShadows' },
	'auxiliarylens' => { 119 => 0x82 },
	'avaperturesetting' => { 166 => 0x13 },
	'avsettingwithoutlens' => { 34 => 0x707 },
	'azimuth' => { 90 => 'Azimuth' },
	'babyage' => { 160 => [0x8010,0x33] },
	'baseexposurecompensation' => { 166 => 0x15 },
	'baseiso' => { 31 => 0x2, 47 => 0x101c },
	'baselineexposure' => { 57 => 0xc62a },
	'baselinenoise' => { 57 => 0xc62b },
	'baselinesharpness' => { 57 => 0xc62c },
	'baseurl' => { 210 => 'BaseURL' },
	'batteryadbodyload' => { 164 => 0x3 },
	'batteryadbodynoload' => { 164 => 0x2 },
	'batteryadgripload' => { 164 => 0x5 },
	'batteryadgripnoload' => { 164 => 0x4 },
	'batteryorder' => { 126 => '802.3' },
	'batterystates' => { 164 => 0x1 },
	'bayergreensplit' => { 57 => 0xc62d },
	'bayerpattern' => { 67 => 0xf902, 100 => 0x17 },
	'beatspliceparamsriseindecibel' => { 212 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimedurationscale' => { 212 => 'beatSpliceParamsRiseInTimeDurationScale' },
	'beatspliceparamsriseintimedurationvalue' => { 212 => 'beatSpliceParamsRiseInTimeDurationValue' },
	'beatspliceparamsusefilebeatsmarker' => { 212 => 'beatSpliceParamsUseFileBeatsMarker' },
	'beep' => { 126 => '803.1', 127 => '729.1', 128 => '748.1' },
	'bestqualityscale' => { 57 => 0xc65c },
	'bestshotmode' => { 54 => 0x3007 },
	'bitdepth' => { 87 => 'BitDepth', 100 => 0x11, 124 => 0x41 },
	'bitspercomponent' => { 65 => 0x87 },
	'bitspersample' => { 57 => 0x102, 208 => 'BitsPerSample' },
	'blacklevel' => { 57 => 0xc61a, 151 => 0x1012 },
	'blacklevel2' => { 150 => 0x600, 154 => 0x600 },
	'blackpoint' => { 173 => 0x200 },
	'bluebalance' => { 151 => 0x1018, 161 => 0x12, 173 => 0x1b },
	'bluecurvelimits' => { 51 => 0x1fe },
	'bluecurvepoints' => { 51 => 0x1d4 },
	'bluehue' => { 195 => 'BlueHue' },
	'bluesaturation' => { 195 => 'BlueSaturation' },
	'blurwarning' => { 61 => 0x1300 },
	'bodyfirmwareversion' => { 147 => 0x104, 148 => 0x100, 151 => 0x104 },
	'bracketmode' => { 21 => 0x3 },
	'bracketsequence' => { 54 => 0x301d },
	'bracketshotnumber' => { 21 => 0x5, 166 => 0x9 },
	'bracketstep' => { 95 => 0xe },
	'bracketvalue' => { 21 => 0x4 },
	'brightness' => { 57 => 0xfe53, 81 => 'Brightness', 95 => 0x2c, 121 => 0x34, 195 => 'Brightness' },
	'brightnessadj' => { 51 => 0x114, 132 => 0x0, 142 => 0x2d },
	'brightnessvalue' => { 57 => 0x9203, 151 => 0x1003, 198 => 'BrightnessValue' },
	'bulbduration' => { 31 => 0x18 },
	'burstmode' => { 69 => 0xa, 160 => 0x2a },
	'burstmode2' => { 69 => 0x18 },
	'buttonfunctioncontroloff' => { 34 => 0x70a },
	'bwfilter' => { 95 => 0x2a, 101 => 0x39 },
	'bwmode' => { 151 => 0x203 },
	'by-line' => { 63 => 0x50 },
	'by-linetitle' => { 63 => 0x55 },
	'bytecount' => { 204 => 'byteCount' },
	'calibrationilluminant1' => { 57 => 0xc65a },
	'calibrationilluminant2' => { 57 => 0xc65b },
	'cameracalibrationsig' => { 57 => 0xc6f3 },
	'cameraid' => { 151 => 0x209, 184 => 0x209 },
	'cameraiso' => { 12 => 0x10 },
	'cameraorientation' => { 1 => 0x30, 6 => 0x30, 7 => 0x30, 8 => 0x31, 9 => 0x27, 10 => 0x31 },
	'cameraparameters' => { 151 => 0x2050 },
	'cameraprofile' => { 195 => 'CameraProfile' },
	'cameraprofiledigest' => { 195 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 57 => 0xc62f, 191 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 146 => 0x0 },
	'cameratemperature' => { 158 => 0x320, 173 => 0x47 },
	'cameratype' => { 31 => 0x1a, 151 => 0x207 },
	'cameratype2' => { 147 => 0x100 },
	'canonexposuremode' => { 12 => 0x14 },
	'canonfiledescription' => { 47 => 0x805 },
	'canonfilelength' => { 24 => 0xe },
	'canonfirmwareversion' => { 24 => 0x7, 47 => 0x80b },
	'canonflashinfo' => { 47 => 0x1028 },
	'canonflashmode' => { 12 => 0x4 },
	'canonimagesize' => { 3 => 0x39, 12 => 0xa },
	'canonimagetype' => { 24 => 0x6, 47 => 0x815 },
	'canonmodelid' => { 24 => 0x10, 47 => 0x1834 },
	'canonvrd' => { 58 => 'CanonVRD' },
	'caption-abstract' => { 63 => 0x78 },
	'captionwriter' => { 202 => 'CaptionWriter' },
	'casioimagesize' => { 54 => 0x9 },
	'catalogsets' => { 190 => 'CatalogSets' },
	'categories' => { 24 => 0x23 },
	'category' => { 63 => 0xf, 202 => 'Category' },
	'ccdboardversion' => { 158 => 0x331 },
	'ccdscanmode' => { 151 => 0x1039 },
	'ccdsensitivity' => { 129 => 0x6 },
	'ccdversion' => { 158 => 0x330 },
	'celllength' => { 57 => 0x109 },
	'cellwidth' => { 57 => 0x108 },
	'centerafarea' => { 128 => '763.1' },
	'centerweightedareasize' => { 126 => '797.1', 128 => '754.3' },
	'certificate' => { 216 => 'Certificate' },
	'cfapattern' => { 57 => 0xa302 },
	'cfapatterncolumns' => { 198 => 'CFAPatternColumns' },
	'cfapatternrows' => { 198 => 'CFAPatternRows' },
	'cfapatternvalues' => { 198 => 'CFAPatternValues' },
	'channel' => { 204 => 'channel' },
	'channels' => { 80 => 'Channels' },
	'checkmark' => { 51 => 0x26a },
	'childfontfiles' => { 217 => 'FontsChildFontFiles' },
	'chromablurradius' => { 57 => 0xc631 },
	'chromaticaberration' => { 52 => 0x66 },
	'chromaticaberrationb' => { 195 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 52 => 0x6b },
	'chromaticaberrationon' => { 52 => 0x62 },
	'chromaticaberrationr' => { 195 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 52 => 0x6a },
	'chrominancenoisereduction' => { 52 => 0x5e },
	'chrominancenr_tiff_jpeg' => { 52 => 0x60 },
	'city' => { 63 => 0x5a, 86 => 'City', 202 => 'City' },
	'clarity' => { 195 => 'Clarity' },
	'classifystate' => { 63 => 0xe1 },
	'clmodeshootingspeed' => { 126 => '800.2' },
	'cmcontrast' => { 154 => 0x2022 },
	'cmexposurecompensation' => { 154 => 0x2000 },
	'cmhue' => { 154 => 0x2021 },
	'cmsaturation' => { 154 => 0x2020 },
	'cmsharpness' => { 154 => 0x2023 },
	'cmwhitebalance' => { 154 => 0x2001 },
	'cmwhitebalancecomp' => { 154 => 0x2002 },
	'cmwhitebalancegraypoint' => { 154 => 0x2010 },
	'codec' => { 94 => 'Codec' },
	'codedcharacterset' => { 64 => 0x5a },
	'coloraberrationcontrol' => { 139 => 0xc89224b },
	'coloradjustment' => { 185 => 0x14 },
	'coloradjustmentmode' => { 184 => 0x210 },
	'coloranta' => { 217 => 'ColorantsA' },
	'colorantb' => { 217 => 'ColorantsB' },
	'colorantblack' => { 217 => 'ColorantsBlack' },
	'colorantblue' => { 217 => 'ColorantsBlue' },
	'colorantcyan' => { 217 => 'ColorantsCyan' },
	'colorantgreen' => { 217 => 'ColorantsGreen' },
	'colorantl' => { 217 => 'ColorantsL' },
	'colorantmagenta' => { 217 => 'ColorantsMagenta' },
	'colorantmode' => { 217 => 'ColorantsMode' },
	'colorantred' => { 217 => 'ColorantsRed' },
	'colorantswatchname' => { 217 => 'ColorantsSwatchName' },
	'coloranttype' => { 217 => 'ColorantsType' },
	'colorantyellow' => { 217 => 'ColorantsYellow' },
	'colorbalance' => { 81 => 'ColorBalance' },
	'colorbalance1' => { 119 => 0xc },
	'colorbalanceadj' => { 139 => 0x76a43202 },
	'colorbalanceblue' => { 95 => 0x1e },
	'colorbalancegreen' => { 95 => 0x1d },
	'colorbalancered' => { 95 => 0x1c },
	'colorblur' => { 52 => 0x65 },
	'colorbooster' => { 139 => 0x5f0e7d23 },
	'colorboostlevel' => { 133 => 0x1 },
	'colorboosttype' => { 133 => 0x0 },
	'colorclass' => { 176 => 0xde },
	'colorcontrol' => { 151 => 0x102b },
	'coloreffect' => { 160 => 0x28 },
	'colorfilter' => { 53 => 0x17, 95 => 0x29, 101 => 0x38, 175 => 0x17 },
	'colorgain' => { 124 => 0x51 },
	'colorhue' => { 119 => 0x8d },
	'colorimetricreference' => { 57 => 0xc6bf },
	'colormatrix' => { 150 => 0x200, 151 => 0x1011 },
	'colormatrix2' => { 154 => 0x200 },
	'colormatrixa' => { 173 => 0x203 },
	'colormatrixb' => { 173 => 0x204 },
	'colormatrixnumber' => { 151 => 0x1019 },
	'colormode' => { 54 => 0x3015, 61 => 0x1210, 69 => 0x66, 95 => 0x28, 98 => 0x16, 99 => 0x101, 101 => 0x7, 119 => 0x3, 129 => 0x4, 151 => 0x101, 160 => 0x32, 186 => 0xb029, 202 => 'ColorMode' },
	'colormoirereduction' => { 140 => 0x15 },
	'colormoirereductionmode' => { 140 => 0x5 },
	'colornoisereduction' => { 195 => 'ColorNoiseReduction' },
	'colornoisereductionintensity' => { 140 => 0x18 },
	'colornoisereductionsharpness' => { 140 => 0x1c },
	'colorplanes' => { 60 => 0x2 },
	'colorprofile' => { 95 => 0x33 },
	'colorrepresentation' => { 65 => 0x3c },
	'colorreproduction' => { 186 => 0xb020 },
	'colorsequence' => { 65 => 0x41 },
	'colorspace' => { 18 => 0x3, 24 => 0xb4, 47 => 0x10b4, 57 => 0xa001, 87 => 'ColorSpace', 96 => 0x2f, 97 => 0x25, 119 => 0x1e, 146 => 0x507, 173 => 0x37, 185 => 0xb, 198 => 'ColorSpace' },
	'colortempasshot' => { 14 => 0x1d, 15 => 0x26, 16 => 0x43, 17 => 0x43 },
	'colortempauto' => { 14 => 0x22, 15 => 0x1c, 16 => 0x48, 17 => 0x48 },
	'colortempcloudy' => { 14 => 0x31, 15 => 0x35, 16 => 0x5c, 17 => 0x61 },
	'colortempcustom' => { 16 => 0x84 },
	'colortempcustom1' => { 14 => 0x45 },
	'colortempcustom2' => { 14 => 0x4a },
	'colortempdaylight' => { 14 => 0x27, 15 => 0x2b, 16 => 0x52, 17 => 0x57 },
	'colortemperature' => { 1 => 0x73, 2 => [0x48,0x4e], 3 => 0x37, 4 => 0x62, 5 => 0x37, 6 => 0x73, 7 => 0x73, 8 => 0x73, 9 => 0x58, 24 => 0xae, 29 => 0x9, 47 => 0x10ae, 61 => 0x1005, 68 => 0x846, 81 => 'ColorTemperature', 96 => [0x6e,0x49], 97 => 0x3f, 98 => 0x5e, 99 => 0x10b, 101 => 0x3c, 158 => 0x321, 173 => 0x50, 186 => 0xb021 },
	'colortemperaturebg' => { 151 => 0x1013 },
	'colortemperaturerg' => { 151 => 0x1014 },
	'colortempflash' => { 14 => 0x40, 15 => 0x49, 16 => 0x70, 17 => 0x75 },
	'colortempfluorescent' => { 14 => 0x3b, 15 => 0x3f, 16 => 0x66, 17 => 0x6b },
	'colortempkelvin' => { 15 => 0x44, 16 => 0x6b, 17 => 0x70 },
	'colortempmeasured' => { 16 => 0x4d, 17 => 0x4d },
	'colortemppc1' => { 15 => 0x94, 16 => 0x75 },
	'colortemppc2' => { 15 => 0x99, 16 => 0x7a },
	'colortemppc3' => { 15 => 0x9e, 16 => 0x7f },
	'colortempshade' => { 14 => 0x2c, 15 => 0x30, 16 => 0x57, 17 => 0x5c },
	'colortemptungsten' => { 14 => 0x36, 15 => 0x3a, 16 => 0x61, 17 => 0x66 },
	'colortempunknown' => { 15 => 0x21, 17 => 0x52 },
	'colortempunknown10' => { 15 => 0x76, 17 => 0xa2 },
	'colortempunknown11' => { 15 => 0x7b, 17 => 0xa7 },
	'colortempunknown12' => { 15 => 0x80 },
	'colortempunknown13' => { 15 => 0x85 },
	'colortempunknown14' => { 15 => 0x8a },
	'colortempunknown15' => { 15 => 0x8f },
	'colortempunknown16' => { 15 => 0xa3 },
	'colortempunknown2' => { 15 => 0x4e, 17 => 0x7a },
	'colortempunknown3' => { 15 => 0x53, 17 => 0x7f },
	'colortempunknown4' => { 15 => 0x58, 17 => 0x84 },
	'colortempunknown5' => { 15 => 0x5d, 17 => 0x89 },
	'colortempunknown6' => { 15 => 0x62, 17 => 0x8e },
	'colortempunknown7' => { 15 => 0x67, 17 => 0x93 },
	'colortempunknown8' => { 15 => 0x6c, 17 => 0x98 },
	'colortempunknown9' => { 15 => 0x71, 17 => 0x9d },
	'colortone' => { 3 => 0x6f, 5 => 0x77, 12 => 0x2a, 18 => 0x2 },
	'colortoneadj' => { 51 => 0x11e },
	'colortonefaithful' => { 9 => 0x107 },
	'colortonelandscape' => { 9 => 0x105 },
	'colortoneneutral' => { 9 => 0x106 },
	'colortoneportrait' => { 9 => 0x104 },
	'colortonestandard' => { 9 => 0x103 },
	'colortoneuserdef1' => { 9 => 0x109 },
	'colortoneuserdef2' => { 9 => 0x10a },
	'colortoneuserdef3' => { 9 => 0x10b },
	'commanddials' => { 128 => '753.1' },
	'commanddialsaperturesetting' => { 126 => '807.3' },
	'commanddialschangemainsub' => { 126 => '807.2' },
	'commanddialsmenuandplayback' => { 126 => '807.4' },
	'commanddialsreverserotation' => { 126 => '807.1' },
	'commanderchannel' => { 128 => '758.2' },
	'commandergroupa_manualoutput' => { 128 => '761.2' },
	'commandergroupa_ttl-aacomp' => { 128 => '761.1' },
	'commandergroupamode' => { 128 => '759.2' },
	'commandergroupb_manualoutput' => { 128 => '762.2' },
	'commandergroupb_ttl-aacomp' => { 128 => '762.1' },
	'commandergroupbmode' => { 128 => '759.3' },
	'commanderinternalflash' => { 128 => '759.1' },
	'commanderinternalmanualoutput' => { 128 => '760.2' },
	'commanderinternalttlcomp' => { 128 => '760.1' },
	'comment' => { 0 => 0x2, 58 => 'Comment', 82 => 'Comment', 157 => 'Comment' },
	'complianceprofile' => { 204 => 'complianceProfile' },
	'componentsconfiguration' => { 57 => 0x9101, 87 => 'Components', 198 => 'ComponentsConfiguration' },
	'componentversion' => { 47 => 0x80c },
	'composer' => { 212 => 'composer' },
	'compressedbitsperpixel' => { 57 => 0x9102, 198 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 99 => 0x40, 151 => 0x40 },
	'compression' => { 57 => 0x103, 208 => 'Compression' },
	'compressionfactor' => { 146 => 0x50d },
	'compressionratio' => { 87 => 'Compression', 151 => 0x1034 },
	'constrainedcropheight' => { 51 => 0x266, 176 => 0xd6 },
	'constrainedcropwidth' => { 51 => 0x262, 176 => 0xd5 },
	'contact' => { 63 => 0x76 },
	'contentlocationcode' => { 63 => 0x1a },
	'contentlocationname' => { 63 => 0x1b },
	'continuousdrive' => { 12 => 0x5 },
	'continuousshootingspeed' => { 34 => 0x610 },
	'continuousshotlimit' => { 34 => 0x611 },
	'contrast' => { 3 => 0x73, 5 => 0x75, 12 => 0xd, 53 => 0xc, 54 => [0x3012,0x20], 57 => [0xa408,0xfe54], 61 => [0x1004,0x1006], 81 => 'Contrast', 95 => 0x20, 96 => 0x31, 97 => 0x27, 98 => 0x19, 101 => 0x2, 121 => 0x33, 151 => 0x1029, 160 => [0x2c,0x39], 173 => 0x20, 175 => 0xc, 185 => 0xd, 195 => 'Contrast', 198 => 'Contrast' },
	'contrastadj' => { 51 => 0x115, 142 => 0x2c },
	'contrastfaithful' => { 9 => 0xec },
	'contrastlandscape' => { 9 => 0xea },
	'contrastmonochrome' => { 9 => 0xed },
	'contrastneutral' => { 9 => 0xeb },
	'contrastportrait' => { 9 => 0xe9 },
	'contrastsetting' => { 146 => 0x505, 154 => 0x1012 },
	'contraststandard' => { 9 => 0xe8 },
	'contrastuserdef1' => { 9 => 0xee },
	'contrastuserdef2' => { 9 => 0xef },
	'contrastuserdef3' => { 9 => 0xf0 },
	'contributedmediadurationscale' => { 212 => 'contributedMediaDurationScale' },
	'contributedmediadurationvalue' => { 212 => 'contributedMediaDurationValue' },
	'contributedmediamanaged' => { 212 => 'contributedMediaManaged' },
	'contributedmediapath' => { 212 => 'contributedMediaPath' },
	'contributedmediastarttimescale' => { 212 => 'contributedMediaStartTimeScale' },
	'contributedmediastarttimevalue' => { 212 => 'contributedMediaStartTimeValue' },
	'contributedmediatrack' => { 212 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 212 => 'contributedMediaWebStatement' },
	'contributor' => { 196 => 'contributor' },
	'contributors' => { 82 => 'Contributors' },
	'controlledvocabularyterm' => { 200 => 'CVterm' },
	'controllerboardversion' => { 158 => 0x332 },
	'controlmode' => { 31 => 0x12 },
	'conversionlens' => { 160 => 0x35 },
	'converter' => { 57 => 0xfe4d, 129 => 0xb, 195 => 'Converter' },
	'converttograyscale' => { 195 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 57 => 0x8298, 82 => 'Copyright', 157 => 'Copyright', 181 => 'Copyright', 201 => 'Copyright', 204 => 'copyright', 206 => 'copyright', 208 => 'Copyright', 212 => 'copyright' },
	'copyrightflag' => { 179 => 0x40a },
	'copyrightnotice' => { 63 => 0x74 },
	'copyrightownerid' => { 203 => 'CopyrightOwnerCopyrightOwnerID' },
	'copyrightownerimageid' => { 203 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 203 => 'CopyrightOwnerCopyrightOwnerName' },
	'copyrightregistrationnumber' => { 203 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 203 => 'CopyrightStatus' },
	'coringfilter' => { 150 => 0x310, 151 => 0x102d, 154 => 0x310 },
	'coringvalues' => { 150 => 0x311, 154 => 0x311 },
	'corporateentity' => { 204 => 'corporateEntity' },
	'country' => { 86 => 'Country', 202 => 'Country' },
	'country-primarylocationcode' => { 63 => 0x64 },
	'country-primarylocationname' => { 63 => 0x65 },
	'countrycode' => { 177 => 'CountryCode', 199 => 'CountryCode' },
	'coverage' => { 196 => 'coverage' },
	'coverdate' => { 204 => 'coverDate' },
	'coverdisplaydate' => { 204 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 173 => 0x28 },
	'crc32' => { 197 => 'crc32' },
	'createdate' => { 57 => 0x9004, 82 => 'CreateDate', 155 => 'CreationDate', 181 => 'CreationDate', 210 => 'CreateDate' },
	'creationdate' => { 201 => 'CreationDate', 204 => 'creationDate' },
	'creationtime' => { 157 => 'Creation Time' },
	'creator' => { 155 => 'Creator', 181 => 'Creator', 196 => 'creator', 201 => 'Creator' },
	'creatoraddress' => { 199 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcity' => { 199 => 'CreatorContactInfoCiAdrCity' },
	'creatorcountry' => { 199 => 'CreatorContactInfoCiAdrCtry' },
	'creatorpostalcode' => { 199 => 'CreatorContactInfoCiAdrPcode' },
	'creatorregion' => { 199 => 'CreatorContactInfoCiAdrRegion' },
	'creatortool' => { 210 => 'CreatorTool' },
	'creatorworkemail' => { 199 => 'CreatorContactInfoCiEmailWork' },
	'creatorworktelephone' => { 199 => 'CreatorContactInfoCiTelWork' },
	'creatorworkurl' => { 199 => 'CreatorContactInfoCiUrlWork' },
	'credit' => { 63 => 0x6e, 202 => 'Credit' },
	'creditline' => { 206 => 'creditLine' },
	'creditlinereq' => { 215 => 'CreditLineReq' },
	'creditlinerequired' => { 203 => 'CreditLineRequired' },
	'cropactive' => { 51 => 0x244 },
	'cropangle' => { 195 => 'CropAngle' },
	'cropaspectratio' => { 51 => 0x260 },
	'cropbottom' => { 60 => 0x9, 134 => 0x36, 176 => 0xdc, 195 => 'CropBottom' },
	'cropheight' => { 51 => 0x24c, 150 => 0x615, 154 => 0x615, 195 => 'CropHeight' },
	'crophispeed' => { 119 => 0x1b },
	'cropleft' => { 51 => 0x246, 60 => 0x6, 134 => 0x1e, 150 => 0x612, 154 => 0x612, 176 => 0xd9, 195 => 'CropLeft' },
	'cropoutputheight' => { 134 => 0xce },
	'cropoutputheightinches' => { 134 => 0x96 },
	'cropoutputpixels' => { 134 => 0xd6 },
	'cropoutputresolution' => { 134 => 0xb6 },
	'cropoutputscale' => { 134 => 0xbe },
	'cropoutputwidth' => { 134 => 0xc6 },
	'cropoutputwidthinches' => { 134 => 0x8e },
	'cropright' => { 60 => 0x8, 134 => 0x2e, 176 => 0xdb, 195 => 'CropRight' },
	'croprotation' => { 60 => 0xb },
	'cropscaledresolution' => { 134 => 0x9e },
	'cropsourceresolution' => { 134 => 0xae },
	'croptop' => { 51 => 0x248, 60 => 0x7, 134 => 0x26, 150 => 0x613, 154 => 0x613, 176 => 0xda, 195 => 'CropTop' },
	'cropunit' => { 195 => 'CropUnit' },
	'cropunits' => { 195 => 'CropUnits' },
	'cropwidth' => { 51 => 0x24a, 150 => 0x614, 154 => 0x614, 195 => 'CropWidth' },
	'currenticcprofile' => { 57 => 0xc691 },
	'currentpreprofilematrix' => { 57 => 0xc692 },
	'curves' => { 139 => 0x76a43201 },
	'custom1' => { 203 => 'Custom1' },
	'custom10' => { 203 => 'Custom10' },
	'custom2' => { 203 => 'Custom2' },
	'custom3' => { 203 => 'Custom3' },
	'custom4' => { 203 => 'Custom4' },
	'custom5' => { 203 => 'Custom5' },
	'custom6' => { 203 => 'Custom6' },
	'custom7' => { 203 => 'Custom7' },
	'custom8' => { 203 => 'Custom8' },
	'custom9' => { 203 => 'Custom9' },
	'customrendered' => { 57 => 0xa401, 198 => 'CustomRendered' },
	'customsaturation' => { 146 => 0x503 },
	'd-lightinghq' => { 139 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 135 => 0x2 },
	'd-lightinghqhighlight' => { 135 => 0x1 },
	'd-lightinghqselected' => { 139 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 135 => 0x0 },
	'd-lightinghs' => { 139 => 0xce5554aa },
	'd-lightinghsadjustment' => { 136 => 0x0 },
	'd-lightinghscolorboost' => { 136 => 0x1 },
	'datacompressionmethod' => { 65 => 0x6e },
	'dataimprint' => { 95 => 0x34 },
	'date' => { 173 => 0x6, 196 => 'date' },
	'dateacquired' => { 191 => 'DateAcquired' },
	'datecreated' => { 63 => 0x37, 202 => 'DateCreated' },
	'datedisplayformat' => { 131 => 0x3 },
	'daterecieved' => { 204 => 'dateRecieved' },
	'datesent' => { 64 => 0x46 },
	'datestampmode' => { 24 => 0x1c },
	'datetime' => { 208 => 'DateTime' },
	'datetimedigitized' => { 198 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 50 => 0x0, 57 => 0x9003, 79 => 0x14, 82 => 'OriginalDate', 198 => 'DateTimeOriginal' },
	'datetimestamp' => { 69 => 0x64 },
	'daylightsavings' => { 131 => 0x2 },
	'declination' => { 90 => 'Declination' },
	'decposition' => { 95 => 0x32 },
	'defaultcroporigin' => { 57 => 0xc61f },
	'defaultcropsize' => { 57 => 0xc620 },
	'defaultscale' => { 57 => 0xc61e },
	'defringe' => { 195 => 'Defringe' },
	'deletedimagecount' => { 119 => 0xa6, 125 => 0x6e },
	'derivedfromalternatepaths' => { 213 => 'DerivedFromAlternatePaths' },
	'derivedfromdocumentid' => { 213 => 'DerivedFromDocumentID' },
	'derivedfromfilepath' => { 213 => 'DerivedFromFilePath' },
	'derivedfromfrompart' => { 213 => 'DerivedFromFromPart' },
	'derivedfrominstanceid' => { 213 => 'DerivedFromInstanceID' },
	'derivedfromlastmodifydate' => { 213 => 'DerivedFromLastModifyDate' },
	'derivedfrommanager' => { 213 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 213 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 213 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 213 => 'DerivedFromManageUI' },
	'derivedfrommaskmarkers' => { 213 => 'DerivedFromMaskMarkers' },
	'derivedfrompartmapping' => { 213 => 'DerivedFromPartMapping' },
	'derivedfromrenditionclass' => { 213 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 213 => 'DerivedFromRenditionParams' },
	'derivedfromtopart' => { 213 => 'DerivedFromToPart' },
	'derivedfromversionid' => { 213 => 'DerivedFromVersionID' },
	'description' => { 157 => 'Description', 196 => 'description' },
	'destination' => { 64 => 0x5 },
	'destinationcity' => { 173 => 0x24 },
	'destinationcitycode' => { 175 => 0x1001 },
	'destinationdst' => { 173 => 0x26 },
	'developmentdynamicrange' => { 61 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 198 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 198 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 198 => 'DeviceSettingDescriptionSettings' },
	'dialdirectiontvav' => { 34 => 0x706 },
	'digitalcreationdate' => { 63 => 0x3e },
	'digitalcreationtime' => { 63 => 0x3f },
	'digitalgain' => { 29 => 0xb },
	'digitalgem' => { 114 => 0x0 },
	'digitalice' => { 124 => 0x100 },
	'digitalimageguid' => { 200 => 'DigImageGUID' },
	'digitalroc' => { 123 => 0x0 },
	'digitalsourcefiletype' => { 200 => 'DigitalSourcefileType' },
	'digitalzoom' => { 12 => 0xc, 53 => 0xa, 69 => 0x68, 81 => 'DigitalZoom', 95 => 0xc, 119 => 0x86, 129 => 0xa, 151 => 0x204, 173 => 0x1e, 175 => 0xa, 184 => 0x204 },
	'digitalzoomon' => { 184 => 0x21b },
	'digitalzoomratio' => { 57 => 0xa404, 198 => 'DigitalZoomRatio' },
	'directory' => { 58 => 'Directory' },
	'directoryindex' => { 1 => 0x137, 4 => 0x17e, 6 => 0x13f, 7 => 0x133 },
	'directorynumber' => { 110 => 0x6 },
	'disclaimer' => { 157 => 'Disclaimer' },
	'displayaperture' => { 12 => 0x23 },
	'displayedunitsx' => { 180 => 0x2 },
	'displayedunitsy' => { 180 => 0x6 },
	'distance1' => { 69 => 0x28 },
	'distance2' => { 69 => 0x2c },
	'distance3' => { 69 => 0x30 },
	'distance4' => { 69 => 0x34 },
	'distortioncorrection' => { 52 => 0x67, 146 => 0x50b },
	'distortioncorrection2' => { 150 => 0x1011 },
	'distortioncorrectionon' => { 52 => 0x63 },
	'distributor' => { 204 => 'distributor' },
	'dngbackwardversion' => { 57 => 0xc613 },
	'dnglensinfo' => { 57 => 0xc630 },
	'dngversion' => { 57 => 0xc612 },
	'document' => { 157 => 'Document' },
	'documenthistory' => { 63 => 0xe7 },
	'documentid' => { 213 => 'DocumentID' },
	'documentname' => { 57 => 0x10d },
	'documentnotes' => { 63 => 0xe6 },
	'doi' => { 204 => 'doi' },
	'dotrange' => { 57 => 0x150 },
	'drivemode' => { 95 => 0x6, 98 => 0x1e, 146 => 0x600, 173 => 0x34, 185 => 0x3 },
	'drivemode2' => { 166 => 0x7 },
	'dspfirmwareversion' => { 173 => 0x27 },
	'duration' => { 80 => 'Duration', 94 => 'Duration' },
	'durationscale' => { 212 => 'durationScale' },
	'durationvalue' => { 212 => 'durationValue' },
	'dynamicafarea' => { 126 => '791.4' },
	'dynamicrange' => { 61 => 0x1400 },
	'dynamicrangeexpansion' => { 173 => 0x69 },
	'dynamicrangemax' => { 51 => 0x7c },
	'dynamicrangemin' => { 51 => 0x7a },
	'dynamicrangeoptimizer' => { 186 => 0xb025 },
	'dynamicrangesetting' => { 61 => 0x1402 },
	'e-dialinprogram' => { 166 => '1.3' },
	'easyexposurecompensation' => { 126 => '796.4' },
	'easymode' => { 12 => 0xb },
	'edgenoisereduction' => { 140 => 0x4 },
	'edition' => { 204 => 'edition' },
	'editorialupdate' => { 63 => 0x8 },
	'editstatus' => { 63 => 0x7, 177 => 'EditStatus' },
	'effectivelv' => { 173 => 0x2d },
	'effectivemaxaperture' => { 117 => 0x12, 118 => 0x13 },
	'eissn' => { 204 => 'eIssn' },
	'elevation' => { 90 => 'Elevation' },
	'email' => { 82 => 'EMail' },
	'embargodate' => { 204 => 'embargoDate', 206 => 'embargoDate' },
	'endingpage' => { 204 => 'endingPage' },
	'enduserid' => { 203 => 'EndUserEndUserID' },
	'endusername' => { 203 => 'EndUserEndUserName' },
	'engineer' => { 212 => 'engineer' },
	'enhancedarktones' => { 132 => 0x8 },
	'enhancement' => { 53 => 0x16, 54 => 0x3016 },
	'enhancer' => { 150 => 0x300 },
	'enhancervalues' => { 150 => 0x301 },
	'envelopenumber' => { 64 => 0x28 },
	'envelopepriority' => { 64 => 0x3c },
	'enveloperecordversion' => { 64 => 0x0 },
	'epsonimageheight' => { 151 => 0x20c },
	'epsonimagewidth' => { 151 => 0x20b },
	'epsonsoftware' => { 151 => 0x20d },
	'equipmentinstitution' => { 188 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 188 => 'EquipmentManufacturer' },
	'equipmentversion' => { 147 => 0x0 },
	'ettlii' => { 34 => 0x304, 35 => 0xd, 36 => 0xe, 37 => 0x7, 38 => 0x7, 39 => 0xe },
	'event' => { 190 => 'Event', 200 => 'Event', 204 => 'event' },
	'evsteps' => { 166 => '1.2', 168 => 0x0 },
	'evstepsize' => { 128 => '748.7' },
	'exclusivityenddate' => { 206 => 'exclusivityEndDate' },
	'excursiontolerance' => { 65 => 0x82 },
	'exif' => { 58 => 'EXIF' },
	'exifbyteorder' => { 58 => 'ExifByteOrder' },
	'exifcamerainfo' => { 63 => 0xe8 },
	'exifimageheight' => { 57 => 0xa003, 198 => 'PixelYDimension' },
	'exifimagewidth' => { 57 => 0xa002, 198 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 58 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 57 => 0x9000, 198 => 'ExifVersion' },
	'exitpupilposition' => { 117 => 0x4, 118 => 0x4 },
	'expirationdate' => { 63 => 0x25, 204 => 'expirationDate', 206 => 'expirationDate' },
	'expirationtime' => { 63 => 0x26 },
	'exposure' => { 57 => 0xfe51, 195 => 'Exposure' },
	'exposureadj' => { 137 => 0x0 },
	'exposureadj2' => { 137 => 0x12 },
	'exposurebracketstepsize' => { 166 => 0x8 },
	'exposurebracketvalue' => { 119 => 0x19 },
	'exposurecompensation' => { 31 => 0x6, 43 => 0x0, 57 => 0x9204, 69 => 0x24, 81 => 'ExposureComp', 95 => 0xd, 96 => 0x53, 97 => 0x1e, 98 => 0x1, 151 => 0x1006, 173 => 0x16, 185 => [0xc,0x35], 198 => 'ExposureBiasValue' },
	'exposurecontrolstepsize' => { 126 => '796.2' },
	'exposuredelaymode' => { 126 => '800.1', 128 => '754.4' },
	'exposuredifference' => { 119 => 0xe },
	'exposureindex' => { 57 => 0xa215, 198 => 'ExposureIndex' },
	'exposurelevelincrements' => { 32 => 0x6, 33 => 0x6, 34 => 0x101, 35 => 0x5, 36 => 0x6, 37 => 0x5, 38 => 0x5, 39 => 0x6, 40 => 0x4 },
	'exposuremode' => { 57 => 0xa402, 81 => 'ExposureMode', 95 => 0x1, 96 => 0xa, 97 => 0x0, 98 => 0x0, 146 => 0x200, 185 => 0x8, 186 => 0xb041, 198 => 'ExposureMode' },
	'exposuremodeinmanual' => { 34 => 0x10b },
	'exposureprogram' => { 57 => 0x8822, 198 => 'ExposureProgram' },
	'exposuretime' => { 2 => 0x4, 3 => 0x4, 4 => 0x4, 5 => 0x4, 9 => 0x4, 11 => 0x6, 31 => 0x16, 57 => 0x829a, 67 => 0xfd05, 69 => 0x20, 70 => 0xfa24, 72 => 0xf104, 76 => 0x38, 79 => 0x10, 81 => 'ExposureTime', 95 => 0x9, 96 => 0x35, 97 => 0x48, 173 => 0x12, 185 => 0x32, 198 => 'ExposureTime' },
	'exposuretime2' => { 185 => 0x33 },
	'exposurevalue' => { 68 => 0x3 },
	'exposurewarning' => { 61 => 0x1302 },
	'extendedwbdetect' => { 146 => 0x902 },
	'extender' => { 147 => 0x301 },
	'extenderfirmwareversion' => { 147 => 0x304 },
	'extendermagnification' => { 83 => 'Magnification' },
	'extendermake' => { 83 => 'Make' },
	'extendermodel' => { 83 => 'Model', 147 => 0x303 },
	'extenderserialnumber' => { 83 => 'SerialNumber', 147 => 0x302 },
	'externalflash' => { 149 => 0x1201 },
	'externalflashae1' => { 151 => 0x101f },
	'externalflashae1_0' => { 151 => 0x101b },
	'externalflashae2' => { 151 => 0x1020 },
	'externalflashae2_0' => { 151 => 0x101c },
	'externalflashbounce' => { 149 => 0x1204, 151 => 0x1026, 169 => 0x1a },
	'externalflashexposurecomp' => { 169 => 0x19 },
	'externalflashflags' => { 111 => 0x8, 112 => 0x8, 113 => 0x8 },
	'externalflashguidenumber' => { 149 => 0x1203, 169 => '24.1' },
	'externalflashgvalue' => { 151 => 0x1025 },
	'externalflashmode' => { 151 => 0x1028, 169 => 0x2 },
	'externalflashzoom' => { 149 => 0x1205, 151 => 0x1027 },
	'externalsensorbrightnessvalue' => { 158 => 0x311 },
	'face0position' => { 19 => 0x8 },
	'face1position' => { 19 => 0xa },
	'face2position' => { 19 => 0xc },
	'face3position' => { 19 => 0xe },
	'face4position' => { 19 => 0x10 },
	'face5position' => { 19 => 0x12 },
	'face6position' => { 19 => 0x14 },
	'face7position' => { 19 => 0x16 },
	'face8position' => { 19 => 0x18 },
	'facedetect' => { 150 => 0x1200 },
	'facedetectarea' => { 150 => 0x1201 },
	'facedetectframeheight' => { 19 => 0x4 },
	'facedetectframewidth' => { 19 => 0x3 },
	'facesdetected' => { 19 => 0x2, 20 => 0x2 },
	'ffid' => { 197 => 'ffid' },
	'fieldcount' => { 151 => 0x103f },
	'filedatarate' => { 212 => 'fileDataRate' },
	'fileformat' => { 45 => 0x0, 64 => 0x14 },
	'fileindex' => { 1 => 0x143, 4 => 0x172, 6 => 0x133, 7 => 0x13f },
	'filemodifydate' => { 58 => 'FileModifyDate' },
	'filename' => { 58 => 'FileName' },
	'filenameasdelivered' => { 203 => 'FileNameAsDelivered' },
	'filenumber' => { 21 => 0x1, 24 => 0x8, 47 => 0x1817, 110 => 0x8 },
	'filenumbermemory' => { 95 => 0x1a },
	'filenumbersequence' => { 126 => '802.2' },
	'filesource' => { 57 => 0xa300, 61 => 0x8000, 198 => 'FileSource' },
	'fileversion' => { 64 => 0x16 },
	'fillflashautoreduction' => { 32 => 0xe, 33 => 0xe, 40 => 0xa },
	'filllight' => { 195 => 'FillLight' },
	'fillorder' => { 57 => 0x10a },
	'filmmode' => { 61 => 0x1401, 160 => 0x42 },
	'filmtype' => { 124 => 0x2 },
	'filter' => { 54 => 0x3017 },
	'filtereffect' => { 21 => 0xe, 121 => 0x37 },
	'filtereffectmonochrome' => { 9 => 0xff },
	'finderdisplayduringexposure' => { 33 => 0x1 },
	'finetuneoptcenterweighted' => { 126 => '797.2' },
	'finetuneoptmatrixmetering' => { 126 => '798.1' },
	'finetuneoptspotmetering' => { 126 => '798.2' },
	'finetunestepsize' => { 126 => '796.3' },
	'firmware' => { 151 => 0x405, 185 => [0x17,0x3b], 193 => 'Firmware' },
	'firmwaredate' => { 53 => 0x15, 54 => 0x2001 },
	'firmwareid' => { 100 => 0x0 },
	'firmwarerevision' => { 9 => 0xa4, 24 => 0x1e },
	'firmwareversion' => { 1 => 0x10b, 4 => 0x136, 6 => 0xff, 7 => 0x107, 68 => 0xce5, 79 => 0x57, 81 => 'FirmwareVersion', 160 => 0x2 },
	'firstpublicationdate' => { 203 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 63 => 0x16 },
	'flash' => { 57 => 0x9209, 96 => 0x1f, 97 => 0x15 },
	'flashactivity' => { 12 => 0x1c },
	'flashbias' => { 160 => 0x24 },
	'flashbits' => { 12 => 0x1d },
	'flashchargelevel' => { 151 => 0x1010 },
	'flashcommandermode' => { 111 => '9.1', 112 => '9.1', 113 => '9.1' },
	'flashcompensation' => { 193 => 'FlashCompensation' },
	'flashcontrolmode' => { 111 => '9.2', 112 => '9.2', 113 => '9.2' },
	'flashdevice' => { 151 => 0x1005 },
	'flashdistance' => { 54 => 0x2034 },
	'flashenergy' => { 57 => 0xa20b, 198 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 119 => 0x18 },
	'flashexposurecomp' => { 31 => 0xf, 61 => 0x1011, 84 => 'ExposureComp', 95 => 0x23, 99 => 0x104, 111 => 0xa, 112 => 0xa, 113 => 0xa, 119 => 0x12, 146 => 0x401, 151 => 0x1023, 173 => 0x4d, 185 => 0x3a, 186 => 0x104 },
	'flashexposurecompset' => { 162 => 0xe },
	'flashfired' => { 69 => 0x5d, 84 => 'Fired', 95 => 0x14, 128 => '590.3', 198 => 'FlashFired' },
	'flashfiring' => { 34 => 0x306, 35 => 0x6, 36 => 0x7, 39 => 0x7 },
	'flashfirmwareversion' => { 147 => 0x1002 },
	'flashfocallength' => { 111 => 0xb, 112 => 0xc, 113 => 0xc },
	'flashfunction' => { 198 => 'FlashFunction' },
	'flashgroupacontrolmode' => { 111 => 0xf, 112 => '16.1', 113 => '17.1' },
	'flashgroupaexposurecomp' => { 111 => 0x11, 112 => 0x12, 113 => 0x13 },
	'flashgroupaoutput' => { 111 => 0x11, 112 => 0x12, 113 => 0x13 },
	'flashgroupbcontrolmode' => { 111 => 0x10, 112 => '17.1', 113 => '18.1' },
	'flashgroupbexposurecomp' => { 111 => 0x12, 112 => 0x13, 113 => 0x14 },
	'flashgroupboutput' => { 111 => 0x12, 112 => 0x13, 113 => 0x14 },
	'flashgroupccontrolmode' => { 112 => '17.2', 113 => '18.2' },
	'flashgroupcexposurecomp' => { 112 => 0x14, 113 => 0x15 },
	'flashgroupcoutput' => { 112 => 0x14, 113 => 0x15 },
	'flashguidenumber' => { 31 => 0xd, 44 => 0x0, 84 => 'GuideNumber' },
	'flashintensity' => { 53 => [0x19,0x5] },
	'flashlevel' => { 127 => 0x2e2 },
	'flashmake' => { 84 => 'Make' },
	'flashmanufacturer' => { 191 => 'FlashManufacturer' },
	'flashmetering' => { 95 => 0x3f },
	'flashmeteringsegments' => { 173 => 0x20a },
	'flashmode' => { 53 => 0x4, 69 => 0x5c, 84 => 'Mode', 95 => 0x2, 96 => 0x20, 97 => 0x16, 119 => 0x87, 146 => 0x400, 151 => 0x1004, 173 => 0xc, 175 => 0x4, 182 => 0x20, 184 => 0x225, 198 => 'FlashMode' },
	'flashmodel' => { 84 => 'Model', 111 => 0x4, 112 => 0x4, 113 => 0x4, 147 => 0x1001, 191 => 'FlashModel' },
	'flashoptions' => { 166 => 0x2 },
	'flashoptions2' => { 166 => 0x10 },
	'flashoutput' => { 31 => 0x21, 111 => 0xa, 112 => 0xa, 113 => 0xa },
	'flashpixversion' => { 57 => 0xa000, 198 => 'FlashpixVersion' },
	'flashredeyemode' => { 198 => 'FlashRedEyeMode' },
	'flashreturn' => { 198 => 'FlashReturn' },
	'flashserialnumber' => { 84 => 'SerialNumber', 147 => 0x1003 },
	'flashsetting' => { 119 => 0x8 },
	'flashshutterspeed' => { 126 => '810.2', 128 => '755.2' },
	'flashstatus' => { 169 => 0x0 },
	'flashsyncspeed' => { 126 => '810.1' },
	'flashsyncspeedav' => { 32 => 0x3, 34 => 0x10f, 35 => 0x2, 36 => 0x3, 37 => 0x2, 38 => 0x2, 39 => 0x3, 40 => 0x6 },
	'flashthreshold' => { 44 => 0x1 },
	'flashtype' => { 84 => 'Type', 119 => 0x9, 147 => 0x1000 },
	'flashwarning' => { 128 => '755.1' },
	'flickerreduce' => { 184 => 0x218 },
	'fliphorizontal' => { 139 => 0x76a43206 },
	'fnumber' => { 4 => 0x3, 9 => 0x3, 11 => 0x5, 31 => 0x15, 57 => 0x829d, 67 => 0xfd04, 69 => 0x1e, 70 => 0xfa23, 72 => 0xf103, 76 => 0x3c, 79 => 0xc, 88 => 'FNumber', 95 => 0xa, 96 => 0x36, 97 => 0x47, 173 => 0x13, 185 => 0x31, 198 => 'FNumber' },
	'focallength' => { 1 => 0x1d, 2 => 0xa, 3 => 0x9, 4 => 0x1d, 5 => 0x9, 6 => 0x1d, 7 => 0x1d, 9 => 0x28, 23 => 0x1, 54 => 0x1d, 57 => 0x920a, 88 => 'FocalLength', 95 => 0x12, 117 => 0xa, 118 => 0xb, 170 => 0x9, 173 => 0x1d, 198 => 'FocalLength' },
	'focallengthin35mmformat' => { 57 => 0xa405, 198 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 147 => 0x103, 151 => 0x205 },
	'focalplaneresolutionunit' => { 57 => 0xa210, 198 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 57 => 0xa20e, 198 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 23 => 0x2 },
	'focalplanexunknown' => { 23 => 0x2 },
	'focalplaneyresolution' => { 57 => 0xa20f, 198 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 23 => 0x3 },
	'focalplaneyunknown' => { 23 => 0x3 },
	'focaltype' => { 3 => 0x2d, 23 => 0x0 },
	'focalunits' => { 12 => 0x19 },
	'focus' => { 129 => 0x8 },
	'focusarea' => { 95 => 0x31 },
	'focusareaselection' => { 128 => '763.2' },
	'focuscontinuous' => { 12 => 0x20 },
	'focusdistance' => { 88 => 'FocusDistance', 95 => 0x13, 117 => 0x9, 118 => 0xa, 149 => 0x305 },
	'focusdistancelower' => { 1 => 0x45, 4 => 0x45, 6 => 0x45, 7 => 0x45, 8 => 0x52, 31 => 0x14 },
	'focusdistanceupper' => { 1 => 0x43, 4 => 0x43, 6 => 0x43, 7 => 0x43, 8 => 0x50, 31 => 0x13 },
	'focusinfoversion' => { 149 => 0x0 },
	'focusingscreen' => { 33 => 0x0, 34 => 0x80b, 39 => 0x0 },
	'focusmode' => { 12 => 0x7, 53 => 0x3, 54 => [0x3003,0xd], 61 => 0x1021, 69 => 0x38, 81 => 'FocusMode', 95 => 0x30, 97 => 0xe, 119 => 0x7, 146 => 0x301, 151 => 0x100b, 160 => 0x7, 173 => 0xd, 175 => 0x3 },
	'focusmode2' => { 166 => '3.1' },
	'focusmodesetting' => { 127 => 0x2e3 },
	'focuspixel' => { 61 => 0x1023 },
	'focuspointwrap' => { 126 => '792.2' },
	'focusposition' => { 117 => 0x8, 118 => 0x8, 173 => 0x10 },
	'focusprocess' => { 146 => 0x302 },
	'focusrange' => { 12 => 0x12, 151 => 0x100a },
	'focussetting' => { 185 => 0x6 },
	'focusstepcount' => { 149 => 0x301, 151 => 0x100e },
	'focusstepinfinity' => { 149 => 0x303 },
	'focusstepnear' => { 149 => 0x304 },
	'focustrackinglockon' => { 126 => '791.5' },
	'focuswarning' => { 61 => 0x1301 },
	'foldername' => { 95 => 0x27 },
	'fontcomposite' => { 217 => 'FontsComposite' },
	'fontface' => { 217 => 'FontsFontFace' },
	'fontfamily' => { 217 => 'FontsFontFamily' },
	'fontfilename' => { 217 => 'FontsFontFileName' },
	'fontname' => { 217 => 'FontsFontName' },
	'fonttype' => { 217 => 'FontsFontType' },
	'fontversion' => { 217 => 'FontsVersionString' },
	'for' => { 181 => 'For' },
	'format' => { 196 => 'format' },
	'forwardmatrix1' => { 57 => 0xc714 },
	'forwardmatrix2' => { 57 => 0xc715 },
	'framenum' => { 176 => 0xd7 },
	'framenumber' => { 61 => 0x8003, 173 => 0x29 },
	'freebytes' => { 47 => 0x1 },
	'freememorycardimages' => { 96 => [0x37,0x54], 97 => [0x2d,0x4a] },
	'fujiflashmode' => { 61 => 0x1010 },
	'fullsizeimage' => { 87 => 'data' },
	'fullsizeimagename' => { 87 => '1Name' },
	'fullsizeimagetype' => { 87 => '0Type' },
	'functionbutton' => { 128 => '753.2' },
	'gainbase' => { 150 => 0x610 },
	'gaincontrol' => { 57 => 0xa407, 198 => 'GainControl' },
	'gamma' => { 57 => 0xa500 },
	'gammacompensatedvalue' => { 65 => 0x91 },
	'genre' => { 204 => 'genre', 212 => 'genre' },
	'geography' => { 205 => 'geography' },
	'globalaltitude' => { 179 => 0x419 },
	'globalangle' => { 179 => 0x40d },
	'gpsaltitude' => { 62 => 0x6, 85 => 'Altitude', 198 => 'GPSAltitude' },
	'gpsaltituderef' => { 62 => 0x5, 198 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 62 => 0x1c, 198 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 62 => 0x1d },
	'gpsdatetime' => { 85 => 'DateTime', 198 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 62 => 0x18, 85 => 'Bearing', 198 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 62 => 0x17, 198 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 62 => 0x1a, 85 => 'Distance', 198 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 62 => 0x19, 198 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 62 => 0x14, 198 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 62 => 0x13 },
	'gpsdestlongitude' => { 62 => 0x16, 198 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 62 => 0x15 },
	'gpsdifferential' => { 62 => 0x1e, 85 => 'Differential', 198 => 'GPSDifferential' },
	'gpsdop' => { 62 => 0xb, 198 => 'GPSDOP' },
	'gpsimgdirection' => { 62 => 0x11, 198 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 62 => 0x10, 198 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 62 => 0x2, 85 => 'Latitude', 198 => 'GPSLatitude' },
	'gpslatituderef' => { 62 => 0x1 },
	'gpslongitude' => { 62 => 0x4, 85 => 'Longitude', 198 => 'GPSLongitude' },
	'gpslongituderef' => { 62 => 0x3 },
	'gpsmapdatum' => { 62 => 0x12, 85 => 'Datum', 198 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 62 => 0xa, 85 => 'MeasureMode', 198 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 62 => 0x1b, 198 => 'GPSProcessingMethod' },
	'gpssatellites' => { 62 => 0x8, 85 => 'Satellites', 198 => 'GPSSatellites' },
	'gpsspeed' => { 62 => 0xd, 85 => 'Speed', 198 => 'GPSSpeed' },
	'gpsspeedref' => { 62 => 0xc, 198 => 'GPSSpeedRef' },
	'gpsstatus' => { 62 => 0x9, 198 => 'GPSStatus' },
	'gpstimestamp' => { 62 => 0x7 },
	'gpstrack' => { 62 => 0xf, 85 => 'Heading', 198 => 'GPSTrack' },
	'gpstrackref' => { 62 => 0xe, 198 => 'GPSTrackRef' },
	'gpsversionid' => { 62 => 0x0, 198 => 'GPSVersionID' },
	'gradation' => { 146 => 0x50f },
	'graymixeraqua' => { 195 => 'GrayMixerAqua' },
	'graymixerblue' => { 195 => 'GrayMixerBlue' },
	'graymixergreen' => { 195 => 'GrayMixerGreen' },
	'graymixermagenta' => { 195 => 'GrayMixerMagenta' },
	'graymixerorange' => { 195 => 'GrayMixerOrange' },
	'graymixerpurple' => { 195 => 'GrayMixerPurple' },
	'graymixerred' => { 195 => 'GrayMixerRed' },
	'graymixeryellow' => { 195 => 'GrayMixerYellow' },
	'grayresponseunit' => { 57 => 0x122 },
	'greencurvelimits' => { 51 => 0x1c4 },
	'greencurvepoints' => { 51 => 0x19a },
	'greenhue' => { 195 => 'GreenHue' },
	'greensaturation' => { 195 => 'GreenSaturation' },
	'griddisplay' => { 126 => '803.3', 128 => '754.1' },
	'halftonehints' => { 57 => 0x141 },
	'hasalternative' => { 204 => 'hasAlternative' },
	'hascorrection' => { 204 => 'hasCorrection' },
	'hascrop' => { 195 => 'HasCrop' },
	'hasextendedxmp' => { 214 => 'HasExtendedXMP' },
	'haspreviousversion' => { 204 => 'hasPreviousVersion' },
	'hassettings' => { 195 => 'HasSettings' },
	'hastranslation' => { 204 => 'hasTranslation' },
	'headline' => { 63 => 0x69, 202 => 'Headline' },
	'hierarchicalsubject' => { 189 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 34 => 0x202, 119 => 0xb1, 173 => 0x71 },
	'highlight' => { 185 => 0xf },
	'highlightprotection' => { 138 => 0x6 },
	'highlightrecovery' => { 195 => 'HighlightRecovery' },
	'highlighttonepriority' => { 34 => 0x203 },
	'history' => { 202 => 'History' },
	'historyaction' => { 213 => 'HistoryAction' },
	'historychanged' => { 213 => 'HistoryChanged' },
	'historyinstanceid' => { 213 => 'HistoryInstanceID' },
	'historyparameters' => { 213 => 'HistoryParameters' },
	'historysoftwareagent' => { 213 => 'HistorySoftwareAgent' },
	'historywhen' => { 213 => 'HistoryWhen' },
	'hometowncity' => { 54 => 0x3006, 173 => 0x23 },
	'hometowncitycode' => { 175 => 0x1000 },
	'hometowndst' => { 173 => 0x25 },
	'hostcomputer' => { 57 => 0x13c },
	'hue' => { 101 => 0x3b },
	'hueadj' => { 142 => 0x2f },
	'hueadjustment' => { 96 => 0x4a, 97 => 0x40, 119 => 0x92, 121 => 0x36 },
	'hueadjustmentaqua' => { 195 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 195 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 195 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 195 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 195 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 195 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 195 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 195 => 'HueAdjustmentYellow' },
	'huesetting' => { 154 => 0x1011 },
	'icc_profile' => { 58 => 'ICC_Profile' },
	'iccprofilename' => { 202 => 'ICCProfile' },
	'identifier' => { 196 => 'identifier', 210 => 'Identifier' },
	'illumination' => { 128 => '748.5' },
	'imageadjustment' => { 119 => 0x80, 129 => 0x5 },
	'imagealterationconstraints' => { 203 => 'ImageAlterationConstraints' },
	'imageareaoffset' => { 173 => 0x38 },
	'imageauthentication' => { 119 => 0x20 },
	'imageboundary' => { 119 => 0x16 },
	'imagecount' => { 119 => 0xa5 },
	'imagecreatorid' => { 203 => 'ImageCreatorImageCreatorID' },
	'imagecreatorimageid' => { 203 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 203 => 'ImageCreatorImageCreatorName' },
	'imagedatasize' => { 119 => 0xa2 },
	'imagedescription' => { 57 => 0x10e, 208 => 'ImageDescription' },
	'imageduplicationconstraints' => { 203 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 139 => 0xfe443a45 },
	'imagefileconstraints' => { 203 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 203 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 203 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 57 => 0x101, 100 => 0xc, 208 => 'ImageLength' },
	'imagehistory' => { 57 => 0x9213 },
	'imageidnumber' => { 158 => 0x340 },
	'imagenumber' => { 9 => 0xd0, 57 => 0x9211, 81 => 'ImageNumber', 96 => 0xae, 97 => 0x5e, 193 => 'ImageNumber' },
	'imagenumber2' => { 97 => 0x62 },
	'imageoptimization' => { 119 => 0xa9 },
	'imageorientation' => { 63 => 0x83 },
	'imageprocessing' => { 119 => 0x1a, 173 => 0x32 },
	'imageprocessingcount' => { 173 => 0x41 },
	'imageprocessingversion' => { 150 => 0x0 },
	'imagequality' => { 81 => 'ImageQuality', 128 => '708.1', 160 => 0x1 },
	'imagequality2' => { 146 => 0x603 },
	'imagereview' => { 127 => '729.4', 128 => '748.4' },
	'imagereviewtime' => { 127 => 0x2db },
	'imagesize' => { 87 => 'ImageSize' },
	'imagesizerestriction' => { 206 => 'imageSizeRestriction' },
	'imagesourcedata' => { 57 => 0x935c },
	'imagestabilization' => { 12 => 0x22, 54 => 0x3020, 81 => 'ImageStabilization', 96 => 0xbd, 97 => 0x71, 98 => 0x57, 99 => [0x18,0x107,0x113], 119 => 0xac, 149 => 0x1600, 160 => 0x1a, 186 => 0xb026 },
	'imagesupplierid' => { 203 => 'ImageSupplierImageSupplierID' },
	'imagesupplierimageid' => { 203 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 203 => 'ImageSupplierImageSupplierName' },
	'imagetone' => { 173 => 0x4f },
	'imagetype' => { 63 => 0x82, 203 => 'ImageType' },
	'imageuniqueid' => { 57 => 0xa420, 198 => 'ImageUniqueID' },
	'imagewidth' => { 57 => 0x100, 100 => 0xe, 208 => 'ImageWidth' },
	'incrementaltemperature' => { 195 => 'IncrementalTemperature' },
	'incrementaltint' => { 195 => 'IncrementalTint' },
	'industry' => { 204 => 'industry', 205 => 'industry' },
	'infinitylensstep' => { 151 => 0x103b },
	'infobuttonwhenshooting' => { 34 => 0x409 },
	'ingredientsalternatepaths' => { 213 => 'IngredientsAlternatePaths' },
	'ingredientsdocumentid' => { 213 => 'IngredientsDocumentID' },
	'ingredientsfilepath' => { 213 => 'IngredientsFilePath' },
	'ingredientsfrompart' => { 213 => 'IngredientsFromPart' },
	'ingredientsinstanceid' => { 213 => 'IngredientsInstanceID' },
	'ingredientslastmodifydate' => { 213 => 'IngredientsLastModifyDate' },
	'ingredientsmanager' => { 213 => 'IngredientsManager' },
	'ingredientsmanagervariant' => { 213 => 'IngredientsManagerVariant' },
	'ingredientsmanageto' => { 213 => 'IngredientsManageTo' },
	'ingredientsmanageui' => { 213 => 'IngredientsManageUI' },
	'ingredientsmaskmarkers' => { 213 => 'IngredientsMaskMarkers' },
	'ingredientspartmapping' => { 213 => 'IngredientsPartMapping' },
	'ingredientsrenditionclass' => { 213 => 'IngredientsRenditionClass' },
	'ingredientsrenditionparams' => { 213 => 'IngredientsRenditionParams' },
	'ingredientstopart' => { 213 => 'IngredientsToPart' },
	'ingredientsversionid' => { 213 => 'IngredientsVersionID' },
	'initialzoomsetting' => { 126 => '799.3' },
	'inkset' => { 57 => 0x14c },
	'instanceid' => { 213 => 'InstanceID' },
	'instructions' => { 202 => 'Instructions' },
	'instrument' => { 212 => 'instrument' },
	'intellectualgenre' => { 199 => 'IntellectualGenre' },
	'interchangecolorspace' => { 65 => 0x40 },
	'internalflash' => { 95 => 0x2b, 126 => '813.1', 127 => '737.1', 128 => '756.1', 149 => 0x1208 },
	'internalflashae1' => { 151 => 0x1021 },
	'internalflashae1_0' => { 151 => 0x101d },
	'internalflashae2' => { 151 => 0x1022 },
	'internalflashae2_0' => { 151 => 0x101e },
	'internalflashmode' => { 169 => 0x1 },
	'internalflashstrength' => { 169 => 0x3 },
	'internalflashtable' => { 151 => 0x1024 },
	'internalserialnumber' => { 24 => 0x96, 30 => 0x9, 61 => 0x10, 147 => 0x102, 160 => 0x25, 165 => 0x4 },
	'interopindex' => { 57 => 0x1 },
	'interopversion' => { 57 => 0x2 },
	'intervallength' => { 95 => 0x10 },
	'intervalmode' => { 95 => 0x26 },
	'intervalnumber' => { 95 => 0x11 },
	'introtimescale' => { 212 => 'introTimeScale' },
	'introtimevalue' => { 212 => 'introTimeValue' },
	'iptc-naa' => { 57 => 0x83bb },
	'iptcbitspersample' => { 65 => 0x56 },
	'iptcdigest' => { 179 => 0x425 },
	'iptcimageheight' => { 65 => 0x1e },
	'iptcimagerotation' => { 65 => 0x66 },
	'iptcimagewidth' => { 65 => 0x14 },
	'iptclastedited' => { 200 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 65 => 0xa },
	'iptcpixelheight' => { 65 => 0x32 },
	'iptcpixelwidth' => { 65 => 0x28 },
	'isbn' => { 204 => 'isbn' },
	'iscorrectionof' => { 204 => 'isCorrectionOf' },
	'iso' => { 3 => 0x75, 4 => 0x6, 5 => 0x79, 9 => 0x6, 11 => 0x0, 53 => 0x14, 54 => [0x3014,0x14], 57 => 0x8827, 67 => 0xfd06, 68 => 0x1784, 69 => 0x60, 70 => [0xfa2e,0xfa46], 71 => [0x27,0x28], 72 => 0xf105, 76 => 0x4e, 79 => 0x34, 81 => 'ISO', 95 => 0x8, 115 => 0x0, 119 => 0x2, 161 => 0x17, 173 => 0x14, 175 => 0x14, 198 => 'ISOSpeedRatings' },
	'iso2' => { 115 => 0x6, 125 => 0x256, 126 => 0x25c },
	'isoexpansion' => { 34 => 0x103, 35 => 0x7, 36 => 0x8, 39 => 0x8, 115 => 0x4 },
	'isoexpansion2' => { 115 => 0xa },
	'isofloor' => { 166 => 0x6 },
	'isoselection' => { 119 => 0xf },
	'isosetting' => { 69 => 0x5e, 81 => 'ISOSetting', 95 => 0x24, 96 => 0x26, 97 => 0x1c, 101 => 0x6, 119 => 0x13, 166 => '17.3', 182 => 0x27 },
	'isospeedexpansion' => { 33 => 0x3 },
	'isospeedincrements' => { 34 => 0x102 },
	'isospeedrange' => { 34 => 0x103 },
	'isostepsize' => { 126 => '796.1' },
	'isovalue' => { 151 => 0x1001 },
	'issn' => { 204 => 'issn' },
	'issueidentifier' => { 204 => 'issueIdentifier' },
	'issuename' => { 204 => 'issueName' },
	'istranslationof' => { 204 => 'isTranslationOf' },
	'jobid' => { 63 => 0xb8 },
	'jobrefid' => { 211 => 'JobRefId' },
	'jobrefname' => { 211 => 'JobRefName' },
	'jobrefurl' => { 211 => 'JobRefUrl' },
	'jpegquality' => { 3 => 0x66 },
	'jpgfromraw' => { 47 => 0x2007, 55 => 'JpgFromRaw' },
	'jpgfromrawlength' => { 57 => [0x117,0x202] },
	'jpgfromrawstart' => { 57 => [0x111,0x201] },
	'jpgrecordedpixels' => { 166 => 0xe },
	'key' => { 212 => 'key' },
	'keyword' => { 204 => 'keyword' },
	'keywords' => { 63 => 0x19, 82 => 'Keywords', 155 => 'Keywords', 181 => 'Keywords', 201 => 'Keywords' },
	'killdate' => { 204 => 'killDate' },
	'kodakimageheight' => { 67 => 0xf908, 69 => 0xe, 70 => [0xfa1e,0xfa52], 75 => 0x70 },
	'kodakimagewidth' => { 67 => 0xf907, 69 => 0xc, 70 => [0xfa1d,0xfa51], 75 => 0x6c },
	'kodakinfotype' => { 67 => 0xfa00 },
	'kodakmaker' => { 75 => 0x8 },
	'kodakmodel' => { 69 => 0x0, 75 => 0x28 },
	'label' => { 157 => 'Label', 210 => 'Label' },
	'language' => { 196 => 'language' },
	'languageidentifier' => { 63 => 0x87 },
	'lastfilenumber' => { 95 => 0x1b },
	'lastkeywordiptc' => { 191 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 191 => 'LastKeywordXMP' },
	'lasturl' => { 213 => 'LastURL' },
	'lc1' => { 170 => 0x2 },
	'lc10' => { 170 => 0xb },
	'lc11' => { 170 => 0xc },
	'lc12' => { 170 => 0xd },
	'lc14' => { 170 => 0xf },
	'lc15' => { 170 => 0x10 },
	'lc2' => { 170 => 0x3 },
	'lc3' => { 170 => 0x4 },
	'lc4' => { 170 => 0x5 },
	'lc5' => { 170 => 0x6 },
	'lc6' => { 170 => 0x7 },
	'lc7' => { 170 => 0x8 },
	'lcddisplayatpoweron' => { 34 => 0x811, 38 => 0xa },
	'lcddisplayreturntoshoot' => { 39 => 0x12 },
	'lcdillumination' => { 126 => '807.5' },
	'lcdilluminationduringbulb' => { 34 => 0x408 },
	'lcdpanels' => { 33 => 0x8 },
	'lcheditor' => { 139 => 0x8ae85e },
	'legacyiptcdigest' => { 202 => 'LegacyIPTCDigest' },
	'lens' => { 57 => 0xfdea, 119 => 0x84, 185 => 0xa, 193 => 'Lens' },
	'lensafstopbutton' => { 32 => 0x11, 33 => 0x13, 34 => 0x506, 35 => 0x10, 36 => 0x12, 39 => 0x13, 40 => 0x9 },
	'lensaperturerange' => { 185 => 0x30 },
	'lensdistortionparams' => { 151 => 0x206 },
	'lensdrivenoaf' => { 34 => 0x505 },
	'lensfirmwareversion' => { 147 => 0x204 },
	'lensfstops' => { 116 => 0x7, 117 => 0xc, 118 => 0xd, 119 => 0x8b, 170 => '0.3' },
	'lensid' => { 193 => 'LensID' },
	'lensidnumber' => { 116 => 0x6, 117 => 0xb, 118 => 0xc },
	'lensinfo' => { 193 => 'LensInfo' },
	'lenskind' => { 170 => 0x1 },
	'lensmake' => { 88 => 'Make' },
	'lensmanufacturer' => { 191 => 'LensManufacturer' },
	'lensmodel' => { 1 => 0x937, 6 => 0x92b, 7 => 0x933, 24 => 0x95, 88 => 'Model', 191 => 'LensModel' },
	'lensproperties' => { 147 => 0x20b },
	'lensserialnumber' => { 88 => 'SerialNumber', 147 => 0x202, 160 => 0x52 },
	'lenstemperature' => { 151 => 0x1008 },
	'lenstype' => { 1 => 0xe3, 2 => 0xd, 3 => 0xd, 4 => 0x112, 5 => 0xd, 6 => 0xd7, 7 => 0xdf, 8 => 0xeb, 9 => [0xd,0x98], 12 => 0x16, 99 => 0x10c, 119 => 0x83, 147 => 0x201, 158 => 0x310, 160 => 0x51, 171 => 0x0, 172 => 0x0, 173 => 0x3f, 186 => 0xb027 },
	'license' => { 194 => 'license' },
	'licenseeid' => { 203 => 'LicenseeLicenseeID' },
	'licenseeimageid' => { 203 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 203 => 'LicenseeImageNotes' },
	'licenseename' => { 203 => 'LicenseeLicenseeName' },
	'licenseenddate' => { 203 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 203 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 203 => 'LicenseeTransactionID' },
	'licenseid' => { 203 => 'LicenseID' },
	'licensestartdate' => { 203 => 'LicenseStartDate' },
	'licensetransactiondate' => { 203 => 'LicenseTransactionDate' },
	'licensetype' => { 197 => 'licensetype' },
	'licensorcity' => { 203 => 'LicensorLicensorCity' },
	'licensorcountry' => { 203 => 'LicensorLicensorCountry' },
	'licensoremail' => { 203 => 'LicensorLicensorEmail' },
	'licensorextendedaddress' => { 203 => 'LicensorLicensorExtendedAddress' },
	'licensorid' => { 203 => 'LicensorLicensorID' },
	'licensorimageid' => { 203 => 'LicensorImageID' },
	'licensorname' => { 203 => 'LicensorLicensorName' },
	'licensornotes' => { 203 => 'LicensorNotes' },
	'licensorpostalcode' => { 203 => 'LicensorLicensorPostalCode' },
	'licensorregion' => { 203 => 'LicensorLicensorRegion' },
	'licensorstreetaddress' => { 203 => 'LicensorLicensorStreetAddress' },
	'licensortelephone1' => { 203 => 'LicensorLicensorTelephone1' },
	'licensortelephone2' => { 203 => 'LicensorLicensorTelephone2' },
	'licensortelephonetype1' => { 203 => 'LicensorLicensorTelephoneType1' },
	'licensortelephonetype2' => { 203 => 'LicensorLicensorTelephoneType2' },
	'licensortransactionid' => { 203 => 'LicensorTransactionID' },
	'licensorurl' => { 203 => 'LicensorLicensorURL' },
	'lightcondition' => { 151 => 0x1009 },
	'lightreading' => { 173 => 0x15 },
	'lightsource' => { 57 => 0x9208, 119 => 0x90, 154 => 0x1000, 198 => 'LightSource' },
	'lightsourcespecial' => { 184 => 0x21d },
	'lightvaluecenter' => { 151 => 0x103d },
	'lightvalueperiphery' => { 151 => 0x103e },
	'linearresponselimit' => { 57 => 0xc62e },
	'liveviewexposuresimulation' => { 34 => 0x810 },
	'localcaption' => { 63 => 0x79 },
	'localizedcameramodel' => { 57 => 0xc615 },
	'location' => { 190 => 'Location', 199 => 'Location', 204 => 'location' },
	'locationcreatedcity' => { 200 => 'LocationCreatedCity' },
	'locationcreatedcountrycode' => { 200 => 'LocationCreatedCountryCode' },
	'locationcreatedcountryname' => { 200 => 'LocationCreatedCountryName' },
	'locationcreatedprovincestate' => { 200 => 'LocationCreatedProvinceState' },
	'locationcreatedsublocation' => { 200 => 'LocationCreatedSublocation' },
	'locationcreatedworldregion' => { 200 => 'LocationCreatedWorldRegion' },
	'locationshowncity' => { 200 => 'LocationShownCity' },
	'locationshowncountrycode' => { 200 => 'LocationShownCountryCode' },
	'locationshowncountryname' => { 200 => 'LocationShownCountryName' },
	'locationshownprovincestate' => { 200 => 'LocationShownProvinceState' },
	'locationshownsublocation' => { 200 => 'LocationShownSublocation' },
	'locationshownworldregion' => { 200 => 'LocationShownWorldRegion' },
	'lockmicrophonebutton' => { 34 => 0x709 },
	'logcomment' => { 212 => 'logComment' },
	'longexposurenoisereduction' => { 34 => 0x201, 35 => 0x1, 36 => 0x2, 37 => 0x1, 38 => 0x1, 39 => 0x2, 40 => 0x1, 186 => 0xb04e },
	'longfocal' => { 2 => 0x10, 3 => 0x13, 4 => 0x115, 5 => 0x13, 6 => 0xda, 9 => 0x95, 12 => 0x17 },
	'loop' => { 212 => 'loop' },
	'luminanceadjustmentaqua' => { 195 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 195 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 195 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 195 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 195 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 195 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 195 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 195 => 'LuminanceAdjustmentYellow' },
	'luminancenoisereduction' => { 52 => 0x5f },
	'luminancenr_tiff_jpeg' => { 52 => 0x6d },
	'luminancesmoothing' => { 195 => 'LuminanceSmoothing' },
	'm16cversion' => { 158 => 0x333 },
	'macro' => { 61 => 0x1020, 151 => 0x202, 182 => 0x21, 184 => 0x202, 186 => 0xb040 },
	'macromode' => { 12 => 0x1, 95 => 0xb, 146 => 0x300, 160 => 0x1c },
	'magnifiedview' => { 36 => 0x11, 38 => 0x9 },
	'maindialexposurecomp' => { 128 => '748.6' },
	'make' => { 48 => 0x0, 57 => 0x10f, 81 => 'Make', 157 => 'Make', 161 => 0x10f, 208 => 'Make' },
	'makernote' => { 198 => 'MakerNote' },
	'makernotecanon' => { 56 => 'MakN', 57 => 0x927c },
	'makernotecasio' => { 56 => 'MakN', 57 => 0x927c },
	'makernotecasio2' => { 56 => 'MakN', 57 => 0x927c },
	'makernotefujifilm' => { 56 => 'MakN', 57 => 0x927c },
	'makernotehp' => { 56 => 'MakN', 57 => 0x927c },
	'makernotehp2' => { 56 => 'MakN', 57 => 0x927c },
	'makernotehp4' => { 56 => 'MakN', 57 => 0x927c },
	'makernotehp6' => { 56 => 'MakN', 57 => 0x927c },
	'makernoteisl' => { 56 => 'MakN', 57 => 0x927c },
	'makernotejvc' => { 56 => 'MakN', 57 => 0x927c },
	'makernotejvctext' => { 56 => 'MakN', 57 => 0x927c },
	'makernotekodak1a' => { 56 => 'MakN', 57 => 0x927c },
	'makernotekodak1b' => { 56 => 'MakN', 57 => 0x927c },
	'makernotekodak2' => { 56 => 'MakN', 57 => 0x927c },
	'makernotekodak3' => { 56 => 'MakN', 57 => 0x927c },
	'makernotekodak4' => { 56 => 'MakN', 57 => 0x927c },
	'makernotekodak5' => { 56 => 'MakN', 57 => 0x927c },
	'makernotekodak6a' => { 56 => 'MakN', 57 => 0x927c },
	'makernotekodak6b' => { 56 => 'MakN', 57 => 0x927c },
	'makernotekodak7' => { 56 => 'MakN', 57 => 0x927c },
	'makernotekodak8a' => { 56 => 'MakN', 57 => 0x927c },
	'makernotekodak8b' => { 56 => 'MakN', 57 => 0x927c },
	'makernotekodak9' => { 56 => 'MakN', 57 => 0x927c },
	'makernotekodakunknown' => { 56 => 'MakN', 57 => 0x927c },
	'makernotekyocera' => { 56 => 'MakN', 57 => 0x927c },
	'makernoteleica' => { 56 => 'MakN', 57 => 0x927c },
	'makernoteleica2' => { 56 => 'MakN', 57 => 0x927c },
	'makernoteleica3' => { 56 => 'MakN', 57 => 0x927c },
	'makernoteminolta' => { 56 => 'MakN', 57 => 0x927c },
	'makernoteminolta2' => { 56 => 'MakN', 57 => 0x927c },
	'makernoteminolta3' => { 56 => 'MakN', 57 => 0x927c },
	'makernotenikon' => { 56 => 'MakN', 57 => 0x927c },
	'makernotenikon2' => { 56 => 'MakN', 57 => 0x927c },
	'makernotenikon3' => { 56 => 'MakN', 57 => 0x927c },
	'makernoteoffset' => { 184 => 0xff },
	'makernoteolympus' => { 56 => 'MakN', 57 => 0x927c },
	'makernoteolympus2' => { 56 => 'MakN', 57 => 0x927c },
	'makernotepanasonic' => { 56 => 'MakN', 57 => 0x927c },
	'makernotepanasonic2' => { 56 => 'MakN', 57 => 0x927c },
	'makernotepentax' => { 56 => 'MakN', 57 => 0x927c },
	'makernotepentax2' => { 56 => 'MakN', 57 => 0x927c },
	'makernotepentax3' => { 56 => 'MakN', 57 => 0x927c },
	'makernotepentax4' => { 56 => 'MakN', 57 => 0x927c },
	'makernotericoh' => { 56 => 'MakN', 57 => 0x927c },
	'makernotericohtext' => { 56 => 'MakN', 57 => 0x927c },
	'makernotesafety' => { 57 => 0xc635 },
	'makernotesanyo' => { 56 => 'MakN', 57 => 0x927c },
	'makernotesanyoc4' => { 56 => 'MakN', 57 => 0x927c },
	'makernotesanyopatch' => { 56 => 'MakN', 57 => 0x927c },
	'makernotesigma' => { 56 => 'MakN', 57 => 0x927c },
	'makernotesony' => { 56 => 'MakN', 57 => 0x927c },
	'makernotesony2' => { 56 => 'MakN', 57 => 0x927c },
	'makernotesony3' => { 56 => 'MakN', 57 => 0x927c },
	'makernotesony4' => { 56 => 'MakN', 57 => 0x927c },
	'makernotesonysrf' => { 56 => 'MakN', 57 => 0x927c },
	'makernotetype' => { 183 => 0x1 },
	'makernoteunknown' => { 56 => 'MakN', 57 => 0x927c },
	'makernoteversion' => { 99 => 0x0, 119 => 0x1, 151 => 0x0, 160 => 0x8000, 183 => 0x2, 185 => 0x1d },
	'managedfromalternatepaths' => { 213 => 'ManagedFromAlternatePaths' },
	'managedfromdocumentid' => { 213 => 'ManagedFromDocumentID' },
	'managedfromfilepath' => { 213 => 'ManagedFromFilePath' },
	'managedfromfrompart' => { 213 => 'ManagedFromFromPart' },
	'managedfrominstanceid' => { 213 => 'ManagedFromInstanceID' },
	'managedfromlastmodifydate' => { 213 => 'ManagedFromLastModifyDate' },
	'managedfrommanager' => { 213 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 213 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 213 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 213 => 'ManagedFromManageUI' },
	'managedfrommaskmarkers' => { 213 => 'ManagedFromMaskMarkers' },
	'managedfrompartmapping' => { 213 => 'ManagedFromPartMapping' },
	'managedfromrenditionclass' => { 213 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 213 => 'ManagedFromRenditionParams' },
	'managedfromtopart' => { 213 => 'ManagedFromToPart' },
	'managedfromversionid' => { 213 => 'ManagedFromVersionID' },
	'manager' => { 213 => 'Manager' },
	'managervariant' => { 213 => 'ManagerVariant' },
	'manageto' => { 213 => 'ManageTo' },
	'manageui' => { 213 => 'ManageUI' },
	'manometerpressure' => { 146 => 0x900 },
	'manometerreading' => { 146 => 0x901 },
	'manualflash' => { 149 => 0x1209 },
	'manualflashoutput' => { 12 => 0x29, 127 => '737.2', 128 => '756.2' },
	'manualfocusdistance' => { 119 => 0x85, 151 => 0x100c, 184 => 0x223 },
	'manualtv' => { 33 => 0x5, 34 => 0x705 },
	'manufacturedate' => { 165 => 0x1 },
	'marked' => { 201 => 'Marked', 216 => 'Marked' },
	'markerscomment' => { 212 => 'markersComment' },
	'markerscuepointparamskey' => { 212 => 'markersCuePointParamsKey' },
	'markerscuepointparamsvalue' => { 212 => 'markersCuePointParamsValue' },
	'markerscuepointtype' => { 212 => 'markersCuePointType' },
	'markersduration' => { 212 => 'markersDuration' },
	'markerslocation' => { 212 => 'markersLocation' },
	'markersname' => { 212 => 'markersName' },
	'markersprobability' => { 212 => 'markersProbability' },
	'markersspeaker' => { 212 => 'markersSpeaker' },
	'markersstarttime' => { 212 => 'markersStartTime' },
	'markerstarget' => { 212 => 'markersTarget' },
	'markerstype' => { 212 => 'markersType' },
	'maskedareas' => { 57 => 0xc68e },
	'masterdocumentid' => { 63 => 0xb9 },
	'mastergain' => { 124 => 0x50 },
	'maxaperture' => { 12 => 0x1a, 72 => 0x6103, 88 => 'MaxAperture', 95 => 0x17, 170 => '14.1' },
	'maxapertureatcurrentfocal' => { 147 => 0x20a },
	'maxapertureatmaxfocal' => { 61 => 0x1407, 88 => 'MaxApertureAtMaxFocal', 116 => 0xb, 117 => 0x10, 118 => 0x11, 147 => 0x206 },
	'maxapertureatminfocal' => { 61 => 0x1406, 116 => 0xa, 117 => 0xf, 118 => 0x10, 147 => 0x205 },
	'maxaperturevalue' => { 57 => 0x9205, 198 => 'MaxApertureValue' },
	'maxavailheight' => { 200 => 'MaxAvailHeight' },
	'maxavailwidth' => { 200 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 126 => '801.1' },
	'maxfocallength' => { 61 => 0x1405, 88 => 'MaxFocalLength', 116 => 0x9, 117 => 0xe, 118 => 0xf, 147 => 0x208 },
	'maximumdensityrange' => { 65 => 0x8c },
	'maxpagesizeh' => { 217 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 217 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 217 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 57 => 0x119 },
	'mb-d10batteries' => { 126 => '802.4' },
	'mb-d80batteries' => { 128 => '754.5' },
	'mcuversion' => { 116 => 0xc, 117 => 0x11, 118 => 0x12 },
	'md5digest' => { 89 => 'zmd5' },
	'measuredev' => { 31 => 0x3, 47 => 0x1814, 81 => 'MeasuredEV' },
	'measuredlv' => { 158 => 0x312 },
	'mediaconstraints' => { 203 => 'MediaConstraints' },
	'mediasummarycode' => { 203 => 'MediaSummaryCode' },
	'menubuttondisplayposition' => { 32 => 0xb, 35 => 0xa, 36 => 0xb, 39 => 0xb },
	'menubuttonreturn' => { 40 => 0xb },
	'metadatadate' => { 210 => 'MetadataDate' },
	'metadatamoddate' => { 212 => 'metadataModDate' },
	'metering' => { 127 => 0x2df },
	'meteringmode' => { 12 => 0x11, 57 => 0x9207, 69 => 0x1c, 95 => 0x7, 96 => 0x25, 146 => 0x202, 173 => 0x17, 185 => 0x9, 198 => 'MeteringMode' },
	'meteringmode2' => { 166 => '2.1' },
	'meteringmode3' => { 166 => '16.1' },
	'meteringtime' => { 126 => '812.2', 127 => '732.2', 128 => '751.2' },
	'mieversion' => { 89 => '0Vers' },
	'minaperture' => { 12 => 0x1b, 88 => 'MinAperture', 170 => '0.2' },
	'minfocallength' => { 61 => 0x1404, 88 => 'MinFocalLength', 116 => 0x8, 117 => 0xd, 118 => 0xe, 147 => 0x207 },
	'minoltadate' => { 95 => 0x15 },
	'minoltaimagesize' => { 95 => 0x4, 96 => 0xc, 97 => 0x2, 99 => 0x103 },
	'minoltamodelid' => { 95 => 0x25 },
	'minoltaquality' => { 95 => 0x5, 96 => 0xd, 97 => 0x3, 99 => [0x102,0x103], 151 => [0x102,0x103] },
	'minoltatime' => { 95 => 0x16 },
	'minormodelagedisclosure' => { 203 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 57 => 0x118 },
	'mirrorlockup' => { 32 => 0xc, 33 => 0xc, 34 => 0x60f, 35 => 0xb, 36 => 0xc, 37 => 0x6, 38 => 0x6, 39 => 0xc, 40 => 0x3 },
	'moddate' => { 201 => 'ModDate' },
	'model' => { 48 => 0x6, 57 => 0x110, 81 => 'Model', 157 => 'Model', 161 => 0x110, 208 => 'Model' },
	'modelage' => { 200 => 'ModelAge' },
	'modelingflash' => { 126 => '811.4', 128 => '755.4' },
	'modelreleaseid' => { 203 => 'ModelReleaseID' },
	'modelreleasestatus' => { 203 => 'ModelReleaseStatus' },
	'modificationdate' => { 204 => 'modificationDate' },
	'modifiedcolortemp' => { 25 => 0x9 },
	'modifieddigitalgain' => { 25 => 0xb },
	'modifiedparamflag' => { 22 => 0x1 },
	'modifiedpicturestyle' => { 25 => 0xa },
	'modifiedsaturation' => { 146 => 0x504 },
	'modifiedsensorbluelevel' => { 25 => 0x5 },
	'modifiedsensorredlevel' => { 25 => 0x4 },
	'modifiedsharpness' => { 25 => 0x2 },
	'modifiedsharpnessfreq' => { 25 => 0x3 },
	'modifiedtonecurve' => { 25 => 0x1 },
	'modifiedwhitebalance' => { 25 => 0x8 },
	'modifiedwhitebalanceblue' => { 25 => 0x7 },
	'modifiedwhitebalancered' => { 25 => 0x6 },
	'modifydate' => { 57 => 0x132, 82 => 'ModifyDate', 155 => 'ModDate', 156 => 'tIME', 181 => 'ModDate', 210 => 'ModifyDate' },
	'moirefilter' => { 57 => 0xfe58, 195 => 'MoireFilter' },
	'monitorofftime' => { 126 => '808.2', 127 => '732.1', 128 => '751.1' },
	'monochromecontrast' => { 52 => 0x3c },
	'monochromefiltereffect' => { 52 => 0x3a },
	'monochromelinear' => { 52 => 0x3d },
	'monochromesharpness' => { 52 => 0x3e },
	'monochrometoningeffect' => { 52 => 0x3b },
	'monthdaycreated' => { 69 => 0x12, 76 => 0xe },
	'morepermissions' => { 194 => 'morePermissions' },
	'multiexposureautogain' => { 120 => 0x3 },
	'multiexposuremode' => { 120 => 0x1 },
	'multiexposureshots' => { 120 => 0x2 },
	'multipleexposureset' => { 166 => '10.1' },
	'multisample' => { 124 => 0x40 },
	'multiselector' => { 126 => '799.4' },
	'multiselectorplaybackmode' => { 126 => '799.2' },
	'multiselectorshootmode' => { 126 => '799.1' },
	'mycolormode' => { 26 => 0x2 },
	'nativedigest' => { 198 => 'NativeDigest', 208 => 'NativeDigest' },
	'ncdfileinfo' => { 68 => 0x414 },
	'ndfilter' => { 31 => 0x1c },
	'nearlensstep' => { 151 => 0x103c },
	'nefcompression' => { 119 => 0x93 },
	'newsphotoversion' => { 65 => 0x0 },
	'nickname' => { 210 => 'Nickname' },
	'nikon_0x00b9' => { 119 => 0xb9 },
	'nikoncaptureversion' => { 119 => 0xe09 },
	'nikoniccprofile' => { 119 => 0xe1d },
	'nikonimagesize' => { 128 => 0x2c4 },
	'noisefilter' => { 146 => 0x527 },
	'noisereduction' => { 21 => 0x8, 61 => 0x100b, 96 => 0xb0, 97 => 0x60, 98 => 0x3f, 119 => 0x95, 139 => 0x753dcbc0, 140 => 0x17, 146 => 0x50a, 151 => 0x103a, 160 => 0x2d, 173 => 0x49 },
	'noisereduction2' => { 150 => 0x1010 },
	'noisereductionapplied' => { 57 => 0xc6f7 },
	'noisereductionintensity' => { 140 => 0x9 },
	'noisereductionmethod' => { 140 => 0x11 },
	'noisereductionsharpness' => { 140 => 0xd },
	'nomemorycard' => { 126 => '812.1', 127 => '729.3', 128 => '748.3' },
	'nominalmaxaperture' => { 170 => 0xa },
	'nominalminaperture' => { 170 => '10.1' },
	'notes' => { 187 => 'Notes' },
	'npages' => { 217 => 'NPages' },
	'nullrecord' => { 47 => 0x0 },
	'number' => { 204 => 'number' },
	'numberofbeats' => { 212 => 'numberOfBeats' },
	'numindexentries' => { 65 => 0x54 },
	'object' => { 204 => 'object' },
	'objectattributereference' => { 63 => 0x4 },
	'objectcycle' => { 63 => 0x4b },
	'objectdistance' => { 53 => 0x6, 54 => 0x2022 },
	'objectname' => { 63 => 0x5 },
	'objectpreviewdata' => { 63 => 0xca },
	'objectpreviewfileformat' => { 63 => 0xc8 },
	'objectpreviewfileversion' => { 63 => 0xc9 },
	'objecttypereference' => { 63 => 0x3 },
	'oecfcolumns' => { 198 => 'OECFColumns' },
	'oecfnames' => { 198 => 'OECFNames' },
	'oecfrows' => { 198 => 'OECFRows' },
	'oecfvalues' => { 198 => 'OECFValues' },
	'offsetschema' => { 57 => 0xea1d },
	'oldsubfiletype' => { 57 => 0xff },
	'olympusimageheight' => { 151 => 0x102f },
	'olympusimagewidth' => { 151 => 0x102e },
	'onetouchwb' => { 151 => 0x302 },
	'opticalzoom' => { 70 => 0xfa3d, 72 => [0x6006,0xf006], 73 => 0x1000, 74 => 0xf, 76 => 0x1e, 88 => 'OpticalZoom' },
	'opticalzoomcode' => { 31 => 0xa },
	'opticalzoommode' => { 160 => 0x34 },
	'opticalzoomon' => { 184 => 0x219 },
	'optionenddate' => { 206 => 'optionEndDate' },
	'ordernumber' => { 61 => 0x8002 },
	'organisationinimagecode' => { 200 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 200 => 'OrganisationInImageName' },
	'organization' => { 204 => 'organization' },
	'orientation' => { 57 => 0x112, 161 => 0x112, 208 => 'Orientation' },
	'originaldecisiondata' => { 55 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 24 => 0x83 },
	'originaldocumentid' => { 213 => 'OriginalDocumentID' },
	'originalfilename' => { 47 => 0x816, 68 => 0x3e9, 77 => 0x20 },
	'originalimageheight' => { 60 => 0x1 },
	'originalimagewidth' => { 60 => 0x0 },
	'originalrawfiledata' => { 57 => 0xc68c },
	'originalrawfiledigest' => { 57 => 0xc71d },
	'originalrawfilename' => { 57 => 0xc68b },
	'originaltransmissionreference' => { 63 => 0x67 },
	'originatingprogram' => { 63 => 0x41 },
	'originplatform' => { 204 => 'originPlatform' },
	'os' => { 197 => 'os' },
	'otherconditions' => { 203 => 'OtherConditions' },
	'otherconstraints' => { 203 => 'OtherConstraints' },
	'otherimageinfo' => { 203 => 'OtherImageInfo' },
	'otherlicensedocuments' => { 203 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 203 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 203 => 'OtherLicenseRequirements' },
	'outcuescale' => { 212 => 'outCueScale' },
	'outcuevalue' => { 212 => 'outCueValue' },
	'outputimageheight' => { 105 => 0x3 },
	'outputimagewidth' => { 105 => 0x2 },
	'outputresolution' => { 105 => 0x4 },
	'owner' => { 216 => 'Owner' },
	'ownerid' => { 63 => 0xbc },
	'ownername' => { 24 => 0x9, 47 => 0x810, 57 => 0xfde8, 81 => 'OwnerName', 193 => 'OwnerName' },
	'padding' => { 57 => 0xea1c },
	'pagename' => { 57 => 0x11d },
	'pagenumber' => { 57 => 0x129 },
	'pagerange' => { 204 => 'pageRange' },
	'panasonicexifversion' => { 160 => 0x26 },
	'panasonicrawversion' => { 161 => 0x1 },
	'panoramadirection' => { 27 => 0x5 },
	'panoramaframe' => { 27 => 0x2 },
	'panoramamode' => { 69 => 0x3c, 146 => 0x601 },
	'parametricdarks' => { 195 => 'ParametricDarks' },
	'parametrichighlights' => { 195 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 195 => 'ParametricHighlightSplit' },
	'parametriclights' => { 195 => 'ParametricLights' },
	'parametricmidtonesplit' => { 195 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 195 => 'ParametricShadows' },
	'parametricshadowsplit' => { 195 => 'ParametricShadowSplit' },
	'patientid' => { 188 => 'PatientID' },
	'patientsbirthdate' => { 188 => 'PatientDOB' },
	'patientsname' => { 188 => 'PatientName' },
	'patientssex' => { 188 => 'PatientSex' },
	'pdfversion' => { 201 => 'PDFVersion' },
	'pentaximagesize' => { 173 => 0x9 },
	'pentaxmodelid' => { 165 => 0x0, 173 => 0x5 },
	'pentaxmodeltype' => { 173 => 0x1 },
	'pentaxversion' => { 173 => 0x0 },
	'people' => { 190 => 'People' },
	'peripheralillumination' => { 52 => 0x68 },
	'peripheralilluminationon' => { 52 => 0x64 },
	'permissions' => { 206 => 'permissions' },
	'person' => { 204 => 'person' },
	'personinimage' => { 200 => 'PersonInImage' },
	'pf0customfuncregistration' => { 42 => 0x1 },
	'pf10retainprogramshift' => { 42 => 0xb },
	'pf13drivepriority' => { 42 => 0xe },
	'pf14disablefocussearch' => { 42 => 0xf },
	'pf15disableafassistbeam' => { 42 => 0x10 },
	'pf16autofocuspointshoot' => { 42 => 0x11 },
	'pf17disableafpointsel' => { 42 => 0x12 },
	'pf18enableautoafpointsel' => { 42 => 0x13 },
	'pf19continuousshootspeed' => { 42 => 0x14 },
	'pf19shootingspeedhigh' => { 41 => 0xa },
	'pf19shootingspeedlow' => { 41 => 0x9 },
	'pf1disableshootingmodes' => { 42 => 0x2 },
	'pf1value' => { 41 => 0x1 },
	'pf20limitcontinousshots' => { 42 => 0x15 },
	'pf20maxcontinousshots' => { 41 => 0xb },
	'pf21enablequietoperation' => { 42 => 0x16 },
	'pf23felocktime' => { 41 => 0xd },
	'pf23postreleasetime' => { 41 => 0xe },
	'pf23settimerlengths' => { 42 => 0x18 },
	'pf23shutterbuttontime' => { 41 => 0xc },
	'pf24lightlcdduringbulb' => { 42 => 0x19 },
	'pf25aemode' => { 41 => 0xf },
	'pf25afmode' => { 41 => 0x12 },
	'pf25afpointsel' => { 41 => 0x13 },
	'pf25colormatrix' => { 41 => 0x17 },
	'pf25defaultclearsettings' => { 42 => 0x1a },
	'pf25drivemode' => { 41 => 0x11 },
	'pf25imagesize' => { 41 => 0x14 },
	'pf25meteringmode' => { 41 => 0x10 },
	'pf25parameters' => { 41 => 0x16 },
	'pf25wbmode' => { 41 => 0x15 },
	'pf26shortenreleaselag' => { 42 => 0x1b },
	'pf27reversedialrotation' => { 42 => 0x1c },
	'pf27value' => { 41 => 0x18 },
	'pf28noquickdialexpcomp' => { 42 => 0x1d },
	'pf29quickdialswitchoff' => { 42 => 0x1e },
	'pf2disablemeteringmodes' => { 42 => 0x3 },
	'pf2value' => { 41 => 0x2 },
	'pf30enlargementmode' => { 42 => 0x1f },
	'pf31originaldecisiondata' => { 42 => 0x20 },
	'pf3manualexposuremetering' => { 42 => 0x4 },
	'pf3value' => { 41 => 0x3 },
	'pf4exposuretimelimits' => { 42 => 0x5 },
	'pf4exposuretimemax' => { 41 => 0x5 },
	'pf4exposuretimemin' => { 41 => 0x4 },
	'pf5aperturelimits' => { 42 => 0x6 },
	'pf5aperturemax' => { 41 => 0x7 },
	'pf5aperturemin' => { 41 => 0x6 },
	'pf6presetshootingmodes' => { 42 => 0x7 },
	'pf7bracketcontinuousshoot' => { 42 => 0x8 },
	'pf8bracketshots' => { 41 => 0x8 },
	'pf8setbracketshots' => { 42 => 0x9 },
	'pf9changebracketsequence' => { 42 => 0xa },
	'phonenumber' => { 82 => 'Phone' },
	'photoeffect' => { 12 => 0x28 },
	'photoeffects' => { 139 => 0xab5eca5e },
	'photoeffectsblue' => { 141 => 0x8 },
	'photoeffectsgreen' => { 141 => 0x6 },
	'photoeffectsred' => { 141 => 0x4 },
	'photoeffectstype' => { 141 => 0x0 },
	'photoinfoplayback' => { 126 => '807.6' },
	'photometricinterpretation' => { 57 => 0x106, 208 => 'PhotometricInterpretation' },
	'photoshopquality' => { 178 => 0x0 },
	'pictinfo' => { 184 => 0x208 },
	'picturecontrol' => { 139 => 0xe2173c47 },
	'picturecontrolactive' => { 142 => 0x0 },
	'picturecontroladjust' => { 121 => 0x30 },
	'picturecontrolbase' => { 121 => 0x18 },
	'picturecontrolmode' => { 142 => 0x13 },
	'picturecontrolname' => { 121 => 0x4 },
	'picturecontrolquickadjust' => { 121 => 0x31 },
	'picturefinish' => { 96 => 0x71 },
	'picturemode' => { 61 => 0x1031, 146 => 0x520, 173 => [0xb,0x33] },
	'picturemode2' => { 166 => 0x0 },
	'picturemodebwfilter' => { 146 => 0x525 },
	'picturemodecontrast' => { 146 => 0x523 },
	'picturemodehue' => { 146 => 0x522 },
	'picturemodesaturation' => { 146 => 0x521 },
	'picturemodesharpness' => { 146 => 0x524 },
	'picturemodetone' => { 146 => 0x526 },
	'picturestyle' => { 2 => [0x4b,0x51], 3 => 0x6c, 4 => 0x86, 5 => 0x73, 9 => 0x6c, 29 => 0xa, 52 => 0x2 },
	'planarconfiguration' => { 57 => 0x11c, 208 => 'PlanarConfiguration' },
	'platenames' => { 217 => 'PlateNames' },
	'plusversion' => { 203 => 'Version' },
	'pngwarning' => { 157 => 'Warning' },
	'postalcode' => { 86 => 'PostalCode' },
	'postcropvignetteamount' => { 195 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 195 => 'PostCropVignetteFeather' },
	'postcropvignettemidpoint' => { 195 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 195 => 'PostCropVignetteRoundness' },
	'powersource' => { 164 => 0x0 },
	'precaptureframes' => { 151 => 0x300 },
	'predictor' => { 57 => 0x13d },
	'prefs' => { 63 => 0xdd, 177 => 'Prefs' },
	'preservedfilename' => { 213 => 'PreservedFileName' },
	'previewapplicationname' => { 57 => 0xc716 },
	'previewapplicationversion' => { 57 => 0xc717 },
	'previewcolorspace' => { 57 => 0xc71a },
	'previewdatetime' => { 57 => 0xc71b },
	'previewheight' => { 70 => 0xfa58 },
	'previewimage' => { 54 => 0x2000, 55 => 'PreviewImage', 56 => 'MakN', 57 => 0x927c, 59 => 0x4, 91 => 'data', 99 => 0x81, 151 => 0x280, 161 => 0x2e, 186 => 0x2001 },
	'previewimageborders' => { 173 => 0x3e },
	'previewimageheight' => { 28 => 0x4 },
	'previewimagelength' => { 28 => 0x2, 54 => 0x3, 57 => [0x117,0x202], 99 => 0x89, 122 => 0x202, 146 => 0x102, 151 => 0x1037, 173 => 0x3, 182 => 0x1e, 185 => 0x1b },
	'previewimagename' => { 91 => '1Name' },
	'previewimagesize' => { 54 => 0x2, 91 => 'ImageSize', 173 => 0x2, 185 => 0x1c },
	'previewimagestart' => { 28 => 0x5, 54 => 0x4, 57 => [0x111,0x201], 99 => 0x88, 122 => 0x201, 146 => 0x101, 151 => 0x1036, 173 => 0x4, 182 => 0x1c, 185 => 0x1a },
	'previewimagetype' => { 91 => '0Type' },
	'previewimagevalid' => { 146 => 0x100, 151 => 0x1035 },
	'previewimagewidth' => { 28 => 0x3 },
	'previewquality' => { 28 => 0x1 },
	'previewsettingsdigest' => { 57 => 0xc719 },
	'previewsettingsname' => { 57 => 0xc718 },
	'previewwidth' => { 70 => 0xfa57 },
	'primarychromaticities' => { 57 => 0x13f, 208 => 'PrimaryChromaticities' },
	'printim' => { 57 => 0xc4a5 },
	'privatertkinfo' => { 189 => 'privateRTKInfo' },
	'processingsoftware' => { 57 => 0xb },
	'producer' => { 155 => 'Producer', 201 => 'Producer' },
	'productid' => { 64 => 0x32 },
	'productioncode' => { 165 => 0x2 },
	'productorserviceconstraints' => { 203 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 57 => 0xc6f4 },
	'profilecopyright' => { 57 => 0xc6fe },
	'profileembedpolicy' => { 57 => 0xc6fd },
	'profilehuesatmapdata1' => { 57 => 0xc6fa },
	'profilehuesatmapdata2' => { 57 => 0xc6fb },
	'profilehuesatmapdims' => { 57 => 0xc6f9 },
	'profilelooktabledata' => { 57 => 0xc726 },
	'profilelooktabledims' => { 57 => 0xc725 },
	'profilename' => { 57 => 0xc6f8 },
	'profiletonecurve' => { 57 => 0xc6fc },
	'programiso' => { 160 => 0x3c },
	'programline' => { 166 => '1.1' },
	'programmode' => { 101 => 0x5 },
	'programshift' => { 119 => 0xd },
	'programversion' => { 63 => 0x46 },
	'projectrefpath' => { 212 => 'projectRefPath' },
	'projectreftype' => { 212 => 'projectRefType' },
	'propertyreleaseid' => { 203 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 203 => 'PropertyReleaseStatus' },
	'province-state' => { 63 => 0x5f },
	'publicationdate' => { 204 => 'publicationDate' },
	'publicationname' => { 204 => 'publicationName' },
	'publisher' => { 196 => 'publisher' },
	'pulldown' => { 212 => 'pullDown' },
	'quality' => { 0 => 0x1, 12 => 0x3, 53 => 0x2, 54 => 0x3002, 61 => 0x1000, 69 => 0x9, 119 => 0x4, 129 => 0x3, 151 => 0x201, 158 => 0x300, 173 => 0x8, 175 => 0x2, 185 => 0x16, 186 => [0x102,0xb047] },
	'qualitymode' => { 54 => 0x8 },
	'quantizationmethod' => { 65 => 0x78 },
	'quickadjust' => { 142 => 0x2a },
	'quickcontroldialinmeter' => { 34 => 0x703 },
	'quickshot' => { 184 => 0x213 },
	'rasterizedcaption' => { 63 => 0x7d },
	'rating' => { 57 => 0x4746, 176 => 0xdf, 197 => 'rating', 210 => 'Rating' },
	'ratingpercent' => { 57 => 0x4749, 191 => 'Rating' },
	'rawandjpgrecording' => { 32 => 0x8, 166 => 0xd },
	'rawbrightnessadj' => { 51 => 0x38 },
	'rawcoloradj' => { 51 => 0x2e },
	'rawcolortoneadj' => { 52 => 0xd },
	'rawcontrastadj' => { 52 => 0xf },
	'rawcropbottom' => { 176 => 0xd4 },
	'rawcropleft' => { 176 => 0xd1 },
	'rawcropright' => { 176 => 0xd3 },
	'rawcroptop' => { 176 => 0xd2 },
	'rawcustomsaturation' => { 51 => 0x30 },
	'rawcustomtone' => { 51 => 0x34 },
	'rawdatauniqueid' => { 57 => 0xc65d },
	'rawdepth' => { 100 => 0x10 },
	'rawdevautogradation' => { 153 => 0x119 },
	'rawdevcolorspace' => { 152 => 0x108, 153 => 0x109 },
	'rawdevcontrastvalue' => { 152 => 0x106, 153 => 0x105 },
	'rawdeveditstatus' => { 152 => 0x10b },
	'rawdevengine' => { 152 => 0x109, 153 => 0x10b },
	'rawdevexposurebiasvalue' => { 152 => 0x100, 153 => 0x100 },
	'rawdevgradation' => { 153 => 0x112 },
	'rawdevgraypoint' => { 152 => 0x103, 153 => 0x104 },
	'rawdevmemorycoloremphasis' => { 152 => 0x105, 153 => 0x108 },
	'rawdevnoisereduction' => { 152 => 0x10a, 153 => 0x10a },
	'rawdevpicturemode' => { 153 => 0x10c },
	'rawdevpm_bwfilter' => { 153 => 0x110 },
	'rawdevpmcontrast' => { 153 => 0x10e },
	'rawdevpmnoisefilter' => { 153 => 0x120 },
	'rawdevpmpicturetone' => { 153 => 0x111 },
	'rawdevpmsaturation' => { 153 => 0x10d },
	'rawdevpmsharpness' => { 153 => 0x10f },
	'rawdevsaturation3' => { 153 => 0x113 },
	'rawdevsaturationemphasis' => { 152 => 0x104, 153 => 0x107 },
	'rawdevsettings' => { 152 => 0x10c },
	'rawdevsharpnessvalue' => { 152 => 0x107, 153 => 0x106 },
	'rawdevversion' => { 152 => 0x0, 153 => 0x0 },
	'rawdevwbfineadjustment' => { 152 => 0x102, 153 => 0x103 },
	'rawdevwhitebalance' => { 153 => 0x101 },
	'rawdevwhitebalancevalue' => { 152 => 0x101, 153 => 0x102 },
	'rawfile' => { 57 => 0xfe4c },
	'rawfilename' => { 195 => 'RawFileName' },
	'rawhighlightpoint' => { 52 => 0x12 },
	'rawimagecenter' => { 119 => 0x99 },
	'rawimagedigest' => { 57 => 0xc71c },
	'rawimagesize' => { 173 => 0x39 },
	'rawinfoversion' => { 154 => 0x0 },
	'rawjpgheight' => { 49 => 0x4 },
	'rawjpgquality' => { 21 => 0x6, 49 => 0x1 },
	'rawjpgsize' => { 21 => 0x7, 49 => 0x2 },
	'rawjpgwidth' => { 49 => 0x3 },
	'rawlinear' => { 52 => 0x10 },
	'rawsaturationadj' => { 52 => 0xe },
	'rawshadowpoint' => { 52 => 0x13 },
	'rawsharpnessadj' => { 52 => 0x11 },
	'recordid' => { 47 => 0x1804 },
	'recordingmode' => { 53 => 0x1, 175 => 0x1 },
	'recordmode' => { 12 => 0x9, 54 => 0x3000 },
	'recordshutterrelease' => { 184 => 0x217 },
	'redbalance' => { 151 => 0x1017, 161 => 0x11, 173 => 0x1c },
	'redcurvelimits' => { 51 => 0x18a },
	'redcurvepoints' => { 51 => 0x160 },
	'redeyecorrection' => { 143 => 0x0 },
	'redeyeinfo' => { 195 => 'RedEyeInfo' },
	'redhue' => { 195 => 'RedHue' },
	'redsaturation' => { 195 => 'RedSaturation' },
	'referenceblackwhite' => { 57 => 0x214, 208 => 'ReferenceBlackWhite' },
	'referencedate' => { 63 => 0x2f },
	'referencenumber' => { 63 => 0x32 },
	'references' => { 82 => 'References' },
	'referenceservice' => { 63 => 0x2d },
	'regionconstraints' => { 203 => 'RegionConstraints' },
	'registryitemid' => { 200 => 'RegistryIdRegItemId' },
	'registryorganisationid' => { 200 => 'RegistryIdRegOrgId' },
	'relatedaudiofile' => { 80 => 'data' },
	'relatedaudiofilename' => { 80 => '1Name' },
	'relatedaudiofiletype' => { 80 => '0Type' },
	'relatedimagefileformat' => { 57 => 0x1000 },
	'relatedimageheight' => { 57 => 0x1002 },
	'relatedimagewidth' => { 57 => 0x1001 },
	'relatedsoundfile' => { 57 => 0xa004, 198 => 'RelatedSoundFile' },
	'relatedvideofile' => { 94 => 'data' },
	'relatedvideofilename' => { 94 => '1Name' },
	'relatedvideofiletype' => { 94 => '0Type' },
	'relation' => { 196 => 'relation' },
	'relativepeakaudiofilepath' => { 212 => 'relativePeakAudioFilePath' },
	'relativetimestampscale' => { 212 => 'relativeTimestampScale' },
	'relativetimestampvalue' => { 212 => 'relativeTimestampValue' },
	'releasebuttontousedial' => { 126 => '807.8' },
	'releasedate' => { 63 => 0x1e, 212 => 'releaseDate' },
	'releasesetting' => { 47 => 0x1016 },
	'releasetime' => { 63 => 0x23 },
	'remoteonduration' => { 127 => '733.1', 128 => '752.3' },
	'renditionclass' => { 213 => 'RenditionClass' },
	'renditionofalternatepaths' => { 213 => 'RenditionOfAlternatePaths' },
	'renditionofdocumentid' => { 213 => 'RenditionOfDocumentID' },
	'renditionoffilepath' => { 213 => 'RenditionOfFilePath' },
	'renditionoffrompart' => { 213 => 'RenditionOfFromPart' },
	'renditionofinstanceid' => { 213 => 'RenditionOfInstanceID' },
	'renditionoflastmodifydate' => { 213 => 'RenditionOfLastModifyDate' },
	'renditionofmanager' => { 213 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 213 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 213 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 213 => 'RenditionOfManageUI' },
	'renditionofmaskmarkers' => { 213 => 'RenditionOfMaskMarkers' },
	'renditionofpartmapping' => { 213 => 'RenditionOfPartMapping' },
	'renditionofrenditionclass' => { 213 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 213 => 'RenditionOfRenditionParams' },
	'renditionoftopart' => { 213 => 'RenditionOfToPart' },
	'renditionofversionid' => { 213 => 'RenditionOfVersionID' },
	'renditionparams' => { 213 => 'RenditionParams' },
	'repeatingflashcount' => { 111 => 0xd, 112 => 0xe, 113 => 0xe, 128 => '757.2' },
	'repeatingflashoutput' => { 128 => '757.1' },
	'repeatingflashrate' => { 111 => 0xc, 112 => 0xd, 113 => 0xd, 128 => '758.1' },
	'resampleparamsquality' => { 212 => 'resampleParamsQuality' },
	'resaved' => { 184 => 0x21e },
	'resolution' => { 87 => 'Resolution' },
	'resolutionmode' => { 185 => 0x4 },
	'resolutionunit' => { 57 => 0x128, 66 => 0x2, 208 => 'ResolutionUnit' },
	'restrictions' => { 206 => 'restrictions' },
	'retouchhistory' => { 119 => 0x9e },
	'retouchinfo' => { 195 => 'RetouchInfo' },
	'reuse' => { 203 => 'Reuse' },
	'reuseallowed' => { 215 => 'ReuseAllowed' },
	'reuseprohibited' => { 206 => 'reuseProhibited' },
	'reverseindicators' => { 126 => '802.1' },
	'revision' => { 197 => 'revision' },
	'rgbcurvelimits' => { 51 => 0x238 },
	'rgbcurvepoints' => { 51 => 0x20e },
	'ricohdate' => { 182 => 0x6 },
	'ricohimageheight' => { 182 => 0x2 },
	'ricohimagewidth' => { 182 => 0x0 },
	'rightascension' => { 90 => 'RightAscension' },
	'rights' => { 196 => 'rights' },
	'rightsagent' => { 204 => 'rightsAgent', 206 => 'rightsAgent' },
	'rightsowner' => { 206 => 'rightsOwner' },
	'romoperationmode' => { 47 => 0x80d },
	'rotation' => { 11 => 0x17, 46 => 0x3, 51 => 0x26e, 60 => 0x4, 90 => 'Rotation', 96 => [0x65,0x50], 97 => 0x46, 98 => 0x5a, 128 => '590.1', 139 => 0x76a43207, 160 => 0x30, 166 => '17.2', 176 => 0xd8 },
	'routing' => { 181 => 'Routing' },
	'rowsperstrip' => { 57 => 0x116 },
	'rpp' => { 192 => 'rpp' },
	'safetyshift' => { 34 => 0x108 },
	'safetyshiftinavortv' => { 32 => 0x10, 33 => 0x10, 35 => 0xf, 36 => 0x10, 39 => 0x10 },
	'samplebits' => { 80 => 'SampleBits' },
	'samplerate' => { 80 => 'SampleRate' },
	'samplesperpixel' => { 57 => 0x115, 208 => 'SamplesPerPixel' },
	'samplestructure' => { 65 => 0x5a },
	'sanyoquality' => { 184 => 0x201 },
	'sanyothumbnail' => { 184 => 0x100 },
	'saturation' => { 3 => 0x6e, 5 => 0x76, 12 => 0xe, 18 => 0x1, 53 => 0xd, 54 => [0x3013,0x1f], 57 => [0xa409,0xfe55], 61 => 0x1003, 81 => 'Saturation', 95 => 0x1f, 96 => 0x32, 97 => 0x28, 98 => 0x1a, 101 => 0x1, 119 => [0x94,0xaa], 121 => 0x35, 160 => 0x40, 173 => 0x1f, 175 => 0xd, 182 => 0x28, 185 => 0x10, 195 => 'Saturation', 198 => 'Saturation' },
	'saturationadj' => { 51 => 0x116, 138 => 0x1, 142 => 0x2e },
	'saturationadjustmentaqua' => { 195 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 195 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 195 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 195 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 195 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 195 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 195 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 195 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 9 => 0xfe },
	'saturationinfo' => { 173 => 0x21b },
	'saturationlandscape' => { 9 => 0xfc },
	'saturationneutral' => { 9 => 0xfd },
	'saturationportrait' => { 9 => 0xfb },
	'saturationsetting' => { 154 => 0x1010 },
	'saturationstandard' => { 9 => 0xfa },
	'saturationuserdef1' => { 9 => 0x100 },
	'saturationuserdef2' => { 9 => 0x101 },
	'saturationuserdef3' => { 9 => 0x102 },
	'saveid' => { 213 => 'SaveID' },
	'scaletype' => { 212 => 'scaleType' },
	'scanningdirection' => { 65 => 0x64 },
	'scene' => { 199 => 'Scene', 212 => 'scene' },
	'scenearea' => { 149 => 0x211, 151 => 0x1031 },
	'sceneassist' => { 119 => 0x9c },
	'scenecapturetype' => { 57 => 0xa406, 198 => 'SceneCaptureType' },
	'scenedetect' => { 149 => 0x210, 151 => 0x1030 },
	'scenedetectdata' => { 149 => 0x212, 151 => 0x1033 },
	'scenemode' => { 70 => 0xfa02, 99 => 0x100, 119 => 0x8f, 146 => 0x509, 151 => 0x403, 160 => 0x8001, 186 => 0xb023 },
	'scenemodeused' => { 72 => [0x6002,0xf002] },
	'sceneselect' => { 184 => 0x21f },
	'scenetype' => { 57 => 0xa301, 198 => 'SceneType' },
	'section' => { 204 => 'section' },
	'securityclassification' => { 57 => 0x9212 },
	'selectableafpoint' => { 34 => 0x509 },
	'selftimer' => { 12 => 0x2, 54 => 0x3001, 160 => 0x2e, 184 => 0x214 },
	'selftimer2' => { 31 => 0x1d },
	'selftimermode' => { 57 => 0x882b },
	'selftimertime' => { 47 => 0x1806, 126 => '808.1', 127 => '732.3', 128 => '751.3' },
	'seminfo' => { 57 => 0x8546 },
	'sensingmethod' => { 57 => 0xa217, 198 => 'SensingMethod' },
	'sensitivityadjust' => { 173 => 0x40 },
	'sensitivitysteps' => { 166 => '17.4', 168 => 0x1 },
	'sensorbluelevel' => { 29 => 0x5 },
	'sensorcleaning' => { 40 => 0xd },
	'sensorfullheight' => { 67 => 0xf904 },
	'sensorfullwidth' => { 67 => 0xf903 },
	'sensorheight' => { 67 => 0xf901, 70 => 0xfa21, 100 => 0x8 },
	'sensorpixelsize' => { 119 => 0x9a },
	'sensorredlevel' => { 29 => 0x4 },
	'sensorsize' => { 81 => 'SensorSize' },
	'sensortemperature' => { 149 => 0x1500, 151 => 0x1007 },
	'sensorwidth' => { 67 => 0xf900, 70 => 0xfa20, 100 => 0xa },
	'sequencenumber' => { 31 => 0x9, 54 => 0x301c, 61 => 0x1101, 69 => 0x1d, 160 => 0x2b },
	'sequenceshotinterval' => { 184 => 0x224 },
	'sequentialshot' => { 184 => 0x20e },
	'serialnumber' => { 24 => 0xc, 47 => 0x180b, 57 => 0xfde9, 67 => 0xfa04, 70 => 0xfa19, 78 => 0x0, 79 => 0xa8, 81 => 'SerialNumber', 119 => 0xa0, 147 => 0x101, 151 => [0x404,0x101a], 158 => 0x303, 185 => 0x2, 193 => 'SerialNumber' },
	'serialnumberformat' => { 24 => 0x15, 47 => 0x183b },
	'seriesdatetime' => { 188 => 'SeriesDateTime' },
	'seriesdescription' => { 188 => 'SeriesDescription' },
	'seriesmodality' => { 188 => 'SeriesModality' },
	'seriesnumber' => { 188 => 'SeriesNumber' },
	'serviceidentifier' => { 64 => 0x1e },
	'setbuttoncrosskeysfunc' => { 37 => 0x0, 38 => 0x0 },
	'setbuttonfunction' => { 32 => 0x1, 40 => 0xc },
	'setbuttonwhenshooting' => { 34 => 0x704 },
	'setfunctionwhenshooting' => { 35 => 0x0, 36 => 0x1, 39 => 0x1 },
	'shadingcompensation' => { 146 => 0x50c },
	'shadingcompensation2' => { 150 => 0x1012 },
	'shadow' => { 185 => 0xe },
	'shadowprotection' => { 138 => 0x0 },
	'shadows' => { 57 => 0xfe52, 195 => 'Shadows' },
	'shadowscale' => { 57 => 0xc633 },
	'shadowtint' => { 195 => 'ShadowTint' },
	'shakereduction' => { 174 => 0x1 },
	'sharpendetail' => { 195 => 'SharpenDetail' },
	'sharpenedgemasking' => { 195 => 'SharpenEdgeMasking' },
	'sharpeningadj' => { 142 => 0x2b },
	'sharpenradius' => { 195 => 'SharpenRadius' },
	'sharpness' => { 2 => [0x42,0x48], 3 => 0x72, 5 => 0x74, 12 => 0xf, 29 => 0x2, 53 => 0xb, 54 => [0x3011,0x21], 57 => [0xa40a,0xfe56], 61 => 0x1001, 69 => 0x6b, 76 => 0x37, 81 => 'Sharpness', 95 => 0x21, 96 => 0x30, 97 => 0x26, 98 => 0x18, 101 => 0x3, 119 => 0x6, 121 => 0x32, 151 => 0x100f, 160 => 0x41, 173 => 0x21, 175 => 0xb, 182 => 0x22, 183 => 0x1003, 185 => 0x11, 195 => 'Sharpness', 198 => 'Sharpness' },
	'sharpnessadj' => { 51 => 0x25a },
	'sharpnessfactor' => { 151 => 0x102a },
	'sharpnessfaithful' => { 9 => 0xf5 },
	'sharpnessfrequency' => { 2 => [0x41,0x47], 29 => 0x3 },
	'sharpnesslandscape' => { 9 => 0xf3 },
	'sharpnessmonochrome' => { 9 => 0xf6 },
	'sharpnessneutral' => { 9 => 0xf4 },
	'sharpnessportrait' => { 9 => 0xf2 },
	'sharpnesssetting' => { 146 => 0x506, 154 => 0x1013 },
	'sharpnessstandard' => { 9 => 0xf1 },
	'sharpnessuserdef1' => { 9 => 0xf7 },
	'sharpnessuserdef2' => { 9 => 0xf8 },
	'sharpnessuserdef3' => { 9 => 0xf9 },
	'shootinginfodisplay' => { 126 => '803.2' },
	'shootingmode' => { 81 => 'ShootingMode', 119 => 0x89, 160 => 0x1f },
	'shootingmodesetting' => { 127 => '734.1' },
	'shortdescription' => { 197 => 'shortdescription' },
	'shortdocumentid' => { 63 => 0xba },
	'shortfocal' => { 2 => 0xe, 3 => 0x11, 4 => 0x113, 5 => 0x11, 6 => 0xd8, 9 => 0x93, 12 => 0x18 },
	'shortownername' => { 9 => 0xac },
	'shortreleasetimelag' => { 34 => 0x80d },
	'shotdate' => { 212 => 'shotDate' },
	'shotlocation' => { 212 => 'shotLocation' },
	'shotname' => { 212 => 'shotName' },
	'shutter-aelock' => { 32 => 0x4, 34 => 0x701, 35 => 0x3, 36 => 0x4, 37 => 0x3, 38 => 0x3, 39 => 0x4, 40 => 0x2 },
	'shutteraelbutton' => { 33 => 0x4 },
	'shutterbuttonafonbutton' => { 34 => 0x701 },
	'shuttercount' => { 4 => 0x176, 21 => 0x1, 125 => [0x6a,0x157,0x276], 126 => 0x279, 127 => 0x246, 128 => 0x24a, 173 => 0x5d },
	'shuttercurtainsync' => { 32 => 0xf, 33 => 0xf, 34 => 0x305, 35 => 0xe, 36 => 0xf, 37 => 0x8, 38 => 0x8, 39 => 0xf, 40 => 0x8 },
	'shuttermode' => { 69 => 0x1b },
	'shutterreleasebuttonae-l' => { 126 => '807.7' },
	'shutterreleasemethod' => { 47 => 0x1010 },
	'shutterreleasenocfcard' => { 32 => 0x2, 33 => 0x2, 40 => 0xf },
	'shutterreleasetiming' => { 47 => 0x1011 },
	'shutterspeedrange' => { 34 => 0x10c },
	'shutterspeedvalue' => { 43 => 0x1, 57 => 0x9201, 151 => 0x1000, 198 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 202 => 'SidecarForExtension' },
	'similarityindex' => { 63 => 0xe4 },
	'slaveflashmeteringsegments' => { 173 => 0x20b },
	'slowshutter' => { 31 => 0x8 },
	'slowsync' => { 61 => 0x1030 },
	'smoothness' => { 57 => 0xfe57, 195 => 'Smoothness' },
	'software' => { 57 => 0x131, 82 => 'Software', 157 => 'Software', 185 => 0x18, 208 => 'Software' },
	'softwareversion' => { 184 => 0x207 },
	'source' => { 63 => 0x73, 157 => 'Source', 196 => 'source', 197 => 'source', 202 => 'Source' },
	'spatialfrequencyresponsecolumns' => { 198 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 198 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 198 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 198 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 212 => 'speakerPlacement' },
	'specialinstructions' => { 63 => 0x28 },
	'specialmode' => { 151 => 0x200, 184 => 0x200 },
	'spectralsensitivity' => { 57 => 0x8824, 198 => 'SpectralSensitivity' },
	'splittoningbalance' => { 195 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 195 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 195 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 195 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 195 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 95 => 0x2d },
	'spotfocuspointy' => { 95 => 0x2e },
	'spotmeteringmode' => { 12 => 0x27 },
	'spotmeterlinktoafpoint' => { 34 => 0x107 },
	'sractive' => { 166 => '17.1' },
	'srawquality' => { 12 => 0x2e },
	'srfocallength' => { 174 => 0x3 },
	'srhalfpresstime' => { 174 => 0x2 },
	'srresult' => { 174 => 0x0 },
	'startingpage' => { 204 => 'startingPage' },
	'starttimecodetimeformat' => { 212 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 212 => 'startTimecodeTimeValue' },
	'starttimecodevalue' => { 212 => 'startTimecodeValue' },
	'state' => { 86 => 'State', 202 => 'State' },
	'status' => { 190 => 'Status' },
	'storagemethod' => { 100 => 0x12 },
	'straightenangle' => { 139 => 0x2fc08431 },
	'stretchmode' => { 212 => 'stretchMode' },
	'studydatetime' => { 188 => 'StudyDateTime' },
	'studydescription' => { 188 => 'StudyDescription' },
	'studyid' => { 188 => 'StudyID' },
	'studyphysician' => { 188 => 'StudyPhysician' },
	'sub-location' => { 63 => 0x5c },
	'subfiledata' => { 89 => 'data' },
	'subfiledirectory' => { 89 => '1Directory' },
	'subfilemimetype' => { 89 => '2MIME' },
	'subfilename' => { 89 => '1Name' },
	'subfileresource' => { 89 => 'rsrc' },
	'subfiletype' => { 57 => 0xfe, 89 => '0Type' },
	'subject' => { 155 => 'Subject', 181 => 'Subject', 196 => 'subject', 201 => 'Subject' },
	'subjectarea' => { 198 => 'SubjectArea' },
	'subjectcode' => { 199 => 'SubjectCode' },
	'subjectdistance' => { 57 => 0x9206, 69 => 0x3e, 198 => 'SubjectDistance' },
	'subjectdistancerange' => { 57 => 0xa40c, 198 => 'SubjectDistanceRange' },
	'subjectlocation' => { 57 => [0x9214,0xa214], 198 => 'SubjectLocation' },
	'subjectprogram' => { 95 => 0x22 },
	'subjectreference' => { 63 => 0xc },
	'subsectime' => { 57 => 0x9290, 68 => 0x401 },
	'subsectimedigitized' => { 57 => 0x9292 },
	'subsectimeoriginal' => { 57 => 0x9291 },
	'subsection1' => { 204 => 'subsection1' },
	'subsection2' => { 204 => 'subsection2' },
	'subsection3' => { 204 => 'subsection3' },
	'subsection4' => { 204 => 'subsection4' },
	'superimposeddisplay' => { 32 => 0xa, 34 => 0x510, 35 => 0x9, 36 => 0xa, 39 => 0xa, 40 => 0xe },
	'supplementalcategories' => { 63 => 0x14, 202 => 'SupplementalCategories' },
	'supplementaltype' => { 65 => 0x37 },
	'svisosetting' => { 166 => 0x14 },
	'switchtoregisteredafpoint' => { 33 => 0x12, 34 => 0x50a },
	'tagged' => { 176 => 0xdd },
	'tapename' => { 212 => 'tapeName' },
	'targetaperture' => { 31 => 0x4 },
	'targetcompressionratio' => { 45 => 0x1 },
	'targetdistancesetting' => { 47 => 0x1807 },
	'targetexposuretime' => { 31 => 0x5 },
	'targetimagetype' => { 47 => 0x100a },
	'teaser' => { 204 => 'teaser' },
	'teleconverter' => { 99 => 0x105, 186 => 0x105 },
	'temperature' => { 195 => 'Temperature' },
	'tempo' => { 212 => 'tempo' },
	'termsandconditionstext' => { 203 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 203 => 'TermsAndConditionsURL' },
	'thresholding' => { 57 => 0x107 },
	'thumbnailfilename' => { 47 => 0x817 },
	'thumbnailformat' => { 210 => 'ThumbnailsFormat' },
	'thumbnailheight' => { 70 => 0xfa55, 210 => 'ThumbnailsHeight' },
	'thumbnailimage' => { 47 => 0x2008, 55 => 'ThumbnailImage', 59 => 0x3, 92 => 'data', 151 => 0x100, 210 => 'ThumbnailsImage' },
	'thumbnailimagename' => { 92 => '1Name' },
	'thumbnailimagesize' => { 92 => 'ImageSize' },
	'thumbnailimagetype' => { 92 => '0Type' },
	'thumbnailimagevalidarea' => { 24 => 0x13 },
	'thumbnaillength' => { 57 => 0x202 },
	'thumbnailoffset' => { 57 => 0x201 },
	'thumbnailwidth' => { 70 => 0xfa54, 210 => 'ThumbnailsWidth' },
	'ticker' => { 204 => 'ticker' },
	'tilelength' => { 57 => 0x143 },
	'tilewidth' => { 57 => 0x142 },
	'time' => { 173 => 0x7 },
	'timecreated' => { 63 => 0x3c, 69 => 0x14, 76 => 0x10, 177 => 'TimeCreated' },
	'timeperiod' => { 204 => 'timePeriod' },
	'timerfunctionbutton' => { 127 => '734.2' },
	'timerlength' => { 34 => 0x80c },
	'timescaleparamsframeoverlappingpercentage' => { 212 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 212 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 212 => 'timeScaleParamsQuality' },
	'timesent' => { 64 => 0x50 },
	'timesignature' => { 212 => 'timeSignature' },
	'timesincepoweron' => { 160 => 0x29 },
	'timestamp' => { 4 => 0x45e, 9 => 0x11c, 157 => 'TimeStamp' },
	'timestamp1' => { 4 => 0x45a },
	'timezone' => { 131 => 0x0 },
	'timezonecode' => { 50 => 0x1 },
	'timezoneinfo' => { 50 => 0x2 },
	'timezoneoffset' => { 57 => 0x882a },
	'tint' => { 195 => 'Tint' },
	'title' => { 57 => 0xc6d2, 82 => 'Title', 155 => 'Title', 157 => 'Title', 181 => 'Title', 196 => 'title', 201 => 'Title' },
	'tonecomp' => { 119 => 0x81 },
	'tonecurve' => { 29 => 0x1, 173 => 0x402, 195 => 'ToneCurve' },
	'tonecurveactive' => { 51 => 0x110 },
	'tonecurvefilename' => { 68 => 0x1391 },
	'tonecurvename' => { 195 => 'ToneCurveName' },
	'tonecurveproperty' => { 51 => 0x3c },
	'tonecurves' => { 173 => 0x403 },
	'toningeffect' => { 21 => 0xf, 119 => 0xb3, 121 => 0x38 },
	'toningeffectmonochrome' => { 9 => 0x108 },
	'toningsaturation' => { 121 => 0x39 },
	'totalzoom' => { 69 => 0x62 },
	'tracknumber' => { 212 => 'trackNumber' },
	'tracksframerate' => { 212 => 'TracksFrameRate' },
	'tracksmarkerscomment' => { 212 => 'TracksMarkersComment' },
	'tracksmarkerscuepointparamskey' => { 212 => 'TracksMarkersCuePointParamsKey' },
	'tracksmarkerscuepointparamsvalue' => { 212 => 'TracksMarkersCuePointParamsValue' },
	'tracksmarkerscuepointtype' => { 212 => 'TracksMarkersCuePointType' },
	'tracksmarkersduration' => { 212 => 'TracksMarkersDuration' },
	'tracksmarkerslocation' => { 212 => 'TracksMarkersLocation' },
	'tracksmarkersname' => { 212 => 'TracksMarkersName' },
	'tracksmarkersprobability' => { 212 => 'TracksMarkersProbability' },
	'tracksmarkersspeaker' => { 212 => 'TracksMarkersSpeaker' },
	'tracksmarkersstarttime' => { 212 => 'TracksMarkersStartTime' },
	'tracksmarkerstarget' => { 212 => 'TracksMarkersTarget' },
	'tracksmarkerstype' => { 212 => 'TracksMarkersType' },
	'trackstrackname' => { 212 => 'TracksTrackName' },
	'trackstracktype' => { 212 => 'TracksTrackType' },
	'trailersignature' => { 89 => 'zmie' },
	'transferfunction' => { 208 => 'TransferFunction' },
	'transmissionreference' => { 202 => 'TransmissionReference' },
	'trapped' => { 155 => 'Trapped', 201 => 'Trapped' },
	'travelday' => { 160 => 0x36 },
	'ttl_da_adown' => { 169 => 0x5 },
	'ttl_da_aup' => { 169 => 0x4 },
	'ttl_da_bdown' => { 169 => 0x7 },
	'ttl_da_bup' => { 169 => 0x6 },
	'tvexposuretimesetting' => { 166 => 0x12 },
	'type' => { 196 => 'type' },
	'uniquecameramodel' => { 57 => 0xc614 },
	'uniquedocumentid' => { 63 => 0xbb },
	'uniqueobjectname' => { 64 => 0x64 },
	'unknownblock' => { 150 => 0x1103 },
	'unknowncompensation' => { 185 => 0xc },
	'unknownev' => { 68 => 0x1 },
	'unknownnumber' => { 47 => 0x180b },
	'unsharp1color' => { 144 => 0x13 },
	'unsharp1halowidth' => { 144 => 0x19 },
	'unsharp1intensity' => { 144 => 0x17 },
	'unsharp1threshold' => { 144 => 0x1b },
	'unsharp2color' => { 144 => 0x2e },
	'unsharp2halowidth' => { 144 => 0x34 },
	'unsharp2intensity' => { 144 => 0x32 },
	'unsharp2threshold' => { 144 => 0x36 },
	'unsharp3color' => { 144 => 0x49 },
	'unsharp3halowidth' => { 144 => 0x4f },
	'unsharp3intensity' => { 144 => 0x4d },
	'unsharp3threshold' => { 144 => 0x51 },
	'unsharp4color' => { 144 => 0x64 },
	'unsharp4halowidth' => { 144 => 0x6a },
	'unsharp4intensity' => { 144 => 0x68 },
	'unsharp4threshold' => { 144 => 0x6c },
	'unsharpcount' => { 144 => 0x0 },
	'unsharpmask' => { 139 => 0x76a43200 },
	'urgency' => { 63 => 0xa, 202 => 'Urgency' },
	'url' => { 82 => 'URL', 157 => 'URL', 179 => 0x40b, 204 => 'url' },
	'usablemeteringmodes' => { 34 => 0x10a },
	'usableshootingmodes' => { 34 => 0x109 },
	'usage' => { 205 => 'usage' },
	'usagefee' => { 206 => 'usageFee' },
	'usageterms' => { 216 => 'UsageTerms' },
	'usercomment' => { 47 => 0x805, 57 => 0x9286, 198 => 'UserComment' },
	'userdef1picturestyle' => { 9 => 0x10c },
	'userdef2picturestyle' => { 9 => 0x10e },
	'userdef3picturestyle' => { 9 => 0x110 },
	'userfields' => { 190 => 'UserFields' },
	'userprofile' => { 158 => 0x302 },
	'usmlenselectronicmf' => { 33 => 0x7, 34 => 0x501 },
	'utmeasting' => { 93 => 'Easting' },
	'utmmapdatum' => { 93 => 'Datum' },
	'utmnorthing' => { 93 => 'Northing' },
	'utmzone' => { 93 => 'Zone' },
	'uv-irfiltercorrection' => { 158 => 0x325 },
	'validbits' => { 150 => 0x611, 151 => 0x102c },
	'validpixeldepth' => { 154 => 0x611 },
	'variousmodes' => { 69 => 0x26 },
	'variousmodes2' => { 69 => 0x3a },
	'variprogram' => { 119 => 0xab },
	'version' => { 61 => 0x0, 181 => 'Version', 195 => 'Version' },
	'versionid' => { 213 => 'VersionID' },
	'versionidentifier' => { 204 => 'versionIdentifier' },
	'versionscomments' => { 213 => 'VersionsComments' },
	'versionseventaction' => { 213 => 'VersionsEventAction' },
	'versionseventchanged' => { 213 => 'VersionsEventChanged' },
	'versionseventinstanceid' => { 213 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 213 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 213 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 213 => 'VersionsEventWhen' },
	'versionsmodifier' => { 213 => 'VersionsModifier' },
	'versionsmodifydate' => { 213 => 'VersionsModifyDate' },
	'versionsversion' => { 213 => 'VersionsVersion' },
	'vibrance' => { 195 => 'Vibrance' },
	'vibrationreduction' => { 125 => [0x75,0x82,0x1ae], 127 => '586.1', 128 => '590.2', 130 => 0x4 },
	'videoalphamode' => { 212 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 212 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 212 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 212 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 212 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 212 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 212 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 212 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 212 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 212 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 212 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 212 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 212 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 212 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 212 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 212 => 'videoColorSpace' },
	'videocompressor' => { 212 => 'videoCompressor' },
	'videofieldorder' => { 212 => 'videoFieldOrder' },
	'videoframerate' => { 212 => 'videoFrameRate' },
	'videoframesizeh' => { 212 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 212 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 212 => 'videoFrameSizeW' },
	'videomoddate' => { 212 => 'videoModDate' },
	'videopixelaspectratio' => { 212 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 212 => 'videoPixelDepth' },
	'viewfinderwarning' => { 126 => '803.4', 128 => '754.2' },
	'viewinfoduringexposure' => { 34 => 0x407 },
	'vignetteamount' => { 195 => 'VignetteAmount' },
	'vignettecontrol' => { 119 => 0x2a, 139 => 0x76a43205 },
	'vignettecontrolintensity' => { 139 => 0xac6bd5c0 },
	'vignettemidpoint' => { 195 => 'VignetteMidpoint' },
	'voicememo' => { 184 => 0x216 },
	'volume' => { 204 => 'volume' },
	'vr_0x66' => { 125 => 0x66 },
	'vrdoffset' => { 24 => 0xd0 },
	'wb_glevel' => { 150 => 0x11f },
	'wb_glevel3000k' => { 150 => 0x113 },
	'wb_glevel3300k' => { 150 => 0x114 },
	'wb_glevel3600k' => { 150 => 0x115 },
	'wb_glevel3900k' => { 150 => 0x116 },
	'wb_glevel4000k' => { 150 => 0x117 },
	'wb_glevel4300k' => { 150 => 0x118 },
	'wb_glevel4500k' => { 150 => 0x119 },
	'wb_glevel4800k' => { 150 => 0x11a },
	'wb_glevel5300k' => { 150 => 0x11b },
	'wb_glevel6000k' => { 150 => 0x11c },
	'wb_glevel6600k' => { 150 => 0x11d },
	'wb_glevel7500k' => { 150 => 0x11e },
	'wb_grbglevels' => { 109 => 0x0 },
	'wb_rbgglevels' => { 106 => 0x0 },
	'wb_rblevels' => { 150 => 0x100 },
	'wb_rblevels3000k' => { 150 => 0x102 },
	'wb_rblevels3300k' => { 150 => 0x103 },
	'wb_rblevels3600k' => { 150 => 0x104 },
	'wb_rblevels3900k' => { 150 => 0x105 },
	'wb_rblevels4000k' => { 150 => 0x106 },
	'wb_rblevels4300k' => { 150 => 0x107 },
	'wb_rblevels4500k' => { 150 => 0x108 },
	'wb_rblevels4800k' => { 150 => 0x109 },
	'wb_rblevels5300k' => { 150 => 0x10a },
	'wb_rblevels6000k' => { 150 => 0x10b },
	'wb_rblevels6600k' => { 150 => 0x10c },
	'wb_rblevels7500k' => { 150 => 0x10d },
	'wb_rblevelsauto' => { 154 => 0x110 },
	'wb_rblevelscloudy' => { 154 => 0x121 },
	'wb_rblevelscoolwhitefluor' => { 154 => 0x132 },
	'wb_rblevelscwb1' => { 150 => 0x10e },
	'wb_rblevelscwb2' => { 150 => 0x10f },
	'wb_rblevelscwb3' => { 150 => 0x110 },
	'wb_rblevelscwb4' => { 150 => 0x111 },
	'wb_rblevelsdaylightfluor' => { 154 => 0x130 },
	'wb_rblevelsdaywhitefluor' => { 154 => 0x131 },
	'wb_rblevelseveningsunlight' => { 154 => 0x124 },
	'wb_rblevelsfineweather' => { 154 => 0x122 },
	'wb_rblevelsshade' => { 154 => 0x120 },
	'wb_rblevelstungsten' => { 154 => 0x123 },
	'wb_rblevelsused' => { 154 => 0x100 },
	'wb_rblevelswhitefluorescent' => { 154 => 0x133 },
	'wb_rgbglevels' => { 108 => 0x0 },
	'wb_rgblevels' => { 159 => 0xd },
	'wb_rggblevels' => { 107 => 0x0 },
	'wb_rggblevelsasshot' => { 14 => 0x19, 15 => 0x22, 16 => 0x3f, 17 => 0x3f },
	'wb_rggblevelsauto' => { 13 => 0x0, 14 => 0x1e, 15 => 0x18, 16 => 0x44, 17 => 0x44 },
	'wb_rggblevelscloudy' => { 13 => 0xc, 14 => 0x2d, 15 => 0x31, 16 => 0x58, 17 => 0x5d, 173 => 0x20f },
	'wb_rggblevelscustom' => { 13 => 0x1c, 16 => 0x80 },
	'wb_rggblevelscustom1' => { 14 => 0x41 },
	'wb_rggblevelscustom2' => { 14 => 0x46 },
	'wb_rggblevelsdaylight' => { 13 => 0x4, 14 => 0x23, 15 => 0x27, 16 => 0x4e, 17 => 0x53, 173 => 0x20d },
	'wb_rggblevelsflash' => { 13 => 0x18, 14 => 0x3c, 15 => 0x45, 16 => 0x6c, 17 => 0x71, 173 => 0x214 },
	'wb_rggblevelsfluorescent' => { 13 => 0x14, 14 => 0x37, 15 => 0x3b, 16 => 0x62, 17 => 0x67 },
	'wb_rggblevelsfluorescentd' => { 173 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 173 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 173 => 0x213 },
	'wb_rggblevelskelvin' => { 13 => 0x20, 15 => 0x40, 16 => 0x67, 17 => 0x6c },
	'wb_rggblevelsmeasured' => { 16 => 0x49, 17 => 0x49 },
	'wb_rggblevelspc1' => { 15 => 0x90, 16 => 0x71 },
	'wb_rggblevelspc2' => { 15 => 0x95, 16 => 0x76 },
	'wb_rggblevelspc3' => { 15 => 0x9a, 16 => 0x7b },
	'wb_rggblevelsshade' => { 13 => 0x8, 14 => 0x28, 15 => 0x2c, 16 => 0x53, 17 => 0x58, 173 => 0x20e },
	'wb_rggblevelstungsten' => { 13 => 0x10, 14 => 0x32, 15 => 0x36, 16 => 0x5d, 17 => 0x62, 173 => 0x210 },
	'wb_rggblevelsunknown' => { 15 => 0x1d, 17 => 0x4e },
	'wb_rggblevelsunknown10' => { 15 => 0x72, 17 => 0x9e },
	'wb_rggblevelsunknown11' => { 15 => 0x77, 17 => 0xa3 },
	'wb_rggblevelsunknown12' => { 15 => 0x7c },
	'wb_rggblevelsunknown13' => { 15 => 0x81 },
	'wb_rggblevelsunknown14' => { 15 => 0x86 },
	'wb_rggblevelsunknown15' => { 15 => 0x8b },
	'wb_rggblevelsunknown16' => { 15 => 0x9f },
	'wb_rggblevelsunknown2' => { 15 => 0x4a, 17 => 0x76 },
	'wb_rggblevelsunknown3' => { 15 => 0x4f, 17 => 0x7b },
	'wb_rggblevelsunknown4' => { 15 => 0x54, 17 => 0x80 },
	'wb_rggblevelsunknown5' => { 15 => 0x59, 17 => 0x85 },
	'wb_rggblevelsunknown6' => { 15 => 0x5e, 17 => 0x8a },
	'wb_rggblevelsunknown7' => { 15 => 0x63, 17 => 0x8f },
	'wb_rggblevelsunknown8' => { 15 => 0x68, 17 => 0x94 },
	'wb_rggblevelsunknown9' => { 15 => 0x6d, 17 => 0x99 },
	'wbadjbluebalance' => { 145 => 0x8 },
	'wbadjcolortemp' => { 51 => 0x1a },
	'wbadjlighting' => { 145 => 0x15 },
	'wbadjlightingsubtype' => { 145 => 0x14 },
	'wbadjmode' => { 145 => 0x10 },
	'wbadjredbalance' => { 145 => 0x0 },
	'wbadjrgblevels' => { 51 => 0x8 },
	'wbadjtemperature' => { 145 => 0x18 },
	'wbadjtint' => { 145 => 0x25 },
	'wbadjustab' => { 160 => 0x46 },
	'wbadjustgm' => { 160 => 0x47 },
	'wbbluelevel' => { 158 => 0x324, 160 => 0x8006, 161 => 0x26 },
	'wbbracketmode' => { 21 => 0x9 },
	'wbbracketvalueab' => { 21 => 0xc },
	'wbbracketvaluegm' => { 21 => 0xd },
	'wbfinetuneactive' => { 51 => 0x24 },
	'wbfinetunesaturation' => { 51 => 0x28 },
	'wbfinetunetone' => { 51 => 0x2c },
	'wbgreenlevel' => { 158 => 0x323, 160 => 0x8005, 161 => 0x25 },
	'wblevels' => { 102 => 0x4 },
	'wbmediaimagesizesetting' => { 34 => 0x708 },
	'wbmode' => { 101 => 0x4, 151 => 0x1015 },
	'wbredlevel' => { 158 => 0x322, 160 => 0x8004, 161 => 0x24 },
	'wbscale' => { 102 => 0x0 },
	'wbshiftab' => { 29 => 0xc, 167 => 0x10 },
	'wbshiftgm' => { 29 => 0xd },
	'wbshiftmg' => { 167 => 0x11 },
	'webstatement' => { 216 => 'WebStatement' },
	'whitebalance' => { 1 => 0x6f, 2 => [0x44,0x4a], 3 => 0x36, 4 => 0x5e, 5 => 0x36, 6 => 0x6f, 7 => 0x6f, 9 => 0x54, 29 => 0x8, 31 => 0x7, 53 => 0x7, 54 => [0x19,0x2012], 57 => [0xa403,0xfe4e], 61 => 0x1002, 69 => 0x40, 95 => 0x3, 96 => 0xe, 97 => 0x4, 98 => 0xb, 119 => 0x5, 129 => 0x7, 158 => 0x304, 160 => 0x3, 173 => 0x19, 175 => 0x7, 182 => 0x26, 185 => [0x3c,0x7], 195 => 'WhiteBalance', 198 => 'WhiteBalance' },
	'whitebalance2' => { 146 => 0x500 },
	'whitebalanceadj' => { 51 => 0x18, 139 => 0x76a43204 },
	'whitebalancebias' => { 54 => 0x2011, 151 => 0x304, 160 => 0x23 },
	'whitebalanceblue' => { 29 => 0x7 },
	'whitebalancebracket' => { 146 => 0x502, 151 => 0x303 },
	'whitebalancecomp' => { 154 => 0x1001 },
	'whitebalancefinetune' => { 61 => 0x100a, 119 => 0xb, 186 => 0x112 },
	'whitebalancemode' => { 173 => 0x1a },
	'whitebalancered' => { 29 => 0x6 },
	'whitebalanceset' => { 166 => 0xa },
	'whitebalancetemperature' => { 146 => 0x501 },
	'whiteboard' => { 151 => 0x301 },
	'whitelevel' => { 57 => 0xc61d },
	'whitepoint' => { 57 => 0x13e, 173 => 0x201, 208 => 'WhitePoint' },
	'widefocuszone' => { 95 => 0x2f },
	'widerange' => { 184 => 0x20f },
	'wordcount' => { 204 => 'wordCount' },
	'workcolorspace' => { 51 => 0x270 },
	'worldtimelocation' => { 160 => 0x3a, 173 => 0x22 },
	'writer-editor' => { 63 => 0x7a },
	'x3filllight' => { 185 => 0x12 },
	'xmp' => { 58 => 'XMP' },
	'xmptoolkit' => { 209 => 'xmptk' },
	'xpauthor' => { 57 => 0x9c9d },
	'xpcomment' => { 57 => 0x9c9c },
	'xpkeywords' => { 57 => 0x9c9e },
	'xposition' => { 57 => 0x11e },
	'xpsubject' => { 57 => 0x9c9f },
	'xptitle' => { 57 => 0x9c9b },
	'xresolution' => { 57 => 0x11a, 66 => 0x3, 180 => 0x0, 208 => 'XResolution' },
	'xyresolution' => { 60 => 0x3 },
	'ycbcrcoefficients' => { 57 => 0x211, 208 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 57 => 0x213, 208 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 57 => 0x212, 208 => 'YCbCrSubSampling' },
	'yearcreated' => { 69 => 0x10, 76 => 0xc },
	'yposition' => { 57 => 0x11f },
	'yresolution' => { 57 => 0x11b, 66 => 0x5, 180 => 0x4, 208 => 'YResolution' },
	'zonematching' => { 99 => 0x10a, 101 => 0x3a, 186 => 0xb024 },
	'zonematchingon' => { 97 => 0x75 },
	'zoomsourcewidth' => { 12 => 0x24 },
	'zoomstepcount' => { 149 => 0x300, 151 => 0x100d },
	'zoomtargetwidth' => { 12 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_stream' => 1,
	'abstract' => 1,
	'acdsee' => 1,
	'actualcompensation' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'aeinfo' => 1,
	'afarea' => 1,
	'afareaheight' => 1,
	'afareaheights' => 1,
	'afareawidth' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afimageheight' => 1,
	'afimagewidth' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'aimetadata' => 1,
	'aiprivatedata' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatespotcolors' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreid' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratio' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'association' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosamplebits' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiovendorid' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitflag' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blocksperframe' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameradatetime' => 1,
	'camerainfo' => 1,
	'cameramodel' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseektoend' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'chapter' => 1,
	'characterset' => 1,
	'charcount' => 1,
	'charcountwithspaces' => 1,
	'charset' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'ciff' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance2' => 1,
	'colorbalance3' => 1,
	'colorbalance4' => 1,
	'colorbalance4b' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'company' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastcurve' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'cuepoint' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'distribution' => 1,
	'djvuversion' => 1,
	'dngadobedata' => 1,
	'dngpentaxdata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docrights' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustremovaldata' => 1,
	'dvdid' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'entrypoint' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipment2' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'extcache' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrafieldlength' => 1,
	'extrasamples' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileattributes' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'filenamelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileversionnumber' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashon' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focusinfo2' => 1,
	'focuspos' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'fujilayout' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'generator' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'gradientbasedcorractive' => 1,
	'gradientbasedcorramount' => 1,
	'gradientbasedcorrbrightness' => 1,
	'gradientbasedcorrclarity' => 1,
	'gradientbasedcorrcontrast' => 1,
	'gradientbasedcorrexposure' => 1,
	'gradientbasedcorrhue' => 1,
	'gradientbasedcorrmaskcenterweight' => 1,
	'gradientbasedcorrmaskdabs' => 1,
	'gradientbasedcorrmaskflow' => 1,
	'gradientbasedcorrmaskfullx' => 1,
	'gradientbasedcorrmaskfully' => 1,
	'gradientbasedcorrmaskradius' => 1,
	'gradientbasedcorrmaskvalue' => 1,
	'gradientbasedcorrmaskwhat' => 1,
	'gradientbasedcorrmaskzerox' => 1,
	'gradientbasedcorrmaskzeroy' => 1,
	'gradientbasedcorrsaturation' => 1,
	'gradientbasedcorrsharpness' => 1,
	'gradientbasedcorrwhat' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'howpublished' => 1,
	'http-equiv' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'identification' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'illustrator' => 1,
	'image' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessing2' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageversion' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'includedfileid' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internalname' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isoinfo' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'itch' => 1,
	'item' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastkeyframetime' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfocalrange' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'libraryid' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'makeandmodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsa100' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mrwinfo' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiquality' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikoncaptureoutput' => 1,
	'nikonpreview' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2200' => 1,
	'olympus2300' => 1,
	'olympus2400' => 1,
	'olympus2500' => 1,
	'olympus2600' => 1,
	'olympus2700' => 1,
	'olympus2800' => 1,
	'olympus2900' => 1,
	'olympusjunk' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'osversion' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'othersampledesc' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintcorrectionactive' => 1,
	'paintcorrectionamount' => 1,
	'paintcorrectionbrightness' => 1,
	'paintcorrectionclarity' => 1,
	'paintcorrectioncontrast' => 1,
	'paintcorrectionexposure' => 1,
	'paintcorrectionhue' => 1,
	'paintcorrectionmaskcenterweight' => 1,
	'paintcorrectionmaskdabs' => 1,
	'paintcorrectionmaskflow' => 1,
	'paintcorrectionmaskfullx' => 1,
	'paintcorrectionmaskfully' => 1,
	'paintcorrectionmaskradius' => 1,
	'paintcorrectionmaskvalue' => 1,
	'paintcorrectionmaskwhat' => 1,
	'paintcorrectionmaskzerox' => 1,
	'paintcorrectionmaskzeroy' => 1,
	'paintcorrectionsaturation' => 1,
	'paintcorrectionsharpness' => 1,
	'paintcorrectionwhat' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'petype' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'pictureinfo' => 1,
	'pieceinfo' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'plus' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'pragma' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryafpoint' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'proccessinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'product' => 1,
	'productname' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2_2' => 1,
	'rawdevelopment' => 1,
	'rawdevelopment2' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawinfo' => 1,
	'rawinfo2' => 1,
	'rawjpginfo' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'realtimestreamingprotocol' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'renderingintent' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'sampletable' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'school' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shakereductioninfo' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300' => 1,
	'shotinfod40' => 1,
	'shotinfod80' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'startofframe' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitrateprops' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	'supermacro' => 1,
	'svgversion' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'tdat' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transform' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tvepisode' => 1,
	'tvepisodenumber' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknownjunk' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videosampledesc' => 1,
	'videosize' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'visibleoutputs' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_grgblevels' => 1,
	'wbadjdata' => 1,
	'wcsprofiles' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'writer' => 1,
	'x' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zipversion' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2009, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
