%module "Math::GSL::DHT"
%include "typemaps.i"
%include "gsl_typemaps.i"

%{
    #include "gsl/gsl_dht.h"
%}

%include "gsl/gsl_dht.h"

%perlcode %{
@EXPORT_OK = qw/
               gsl_dht_alloc 
               gsl_dht_new 
               gsl_dht_init 
               gsl_dht_x_sample 
               gsl_dht_k_sample 
               gsl_dht_free 
               gsl_dht_apply 
             /;
%EXPORT_TAGS = ( all => [ @EXPORT_OK ] );

__END__

=head1 NAME

Math::GSL::DHT - Functions for performing Discrete Hankel Transforms

=head1 SYNOPSIS

use Math::GSL::DHT qw/:all/;

=head1 DESCRIPTION

Here is a list of all the functions included in this module :

=over

=item C<gsl_dht_alloc($size)> - This function allocates a Discrete Hankel transform object of size $size.  

=item C<gsl_dht_new($size, $nu, $xmax)> -  This function allocates a Discrete Hankel transform object of size $size and initializes it for the given values of $nu and $xmax. 

=item C<gsl_dht_init($t, $nu, $xmax)> - This function initializes the transform $t for the given values of $nu and $xmax.  

=item C<gsl_dht_x_sample($t, $n)> - This function returns the value of the $n-th sample point in the unit interval, (j_{\nu,n+1}/j_{\nu,M}) X. These are the points where the function f(t) is assumed to be sampled.  

=item C<gsl_dht_k_sample($t, $n)> - This function returns the value of the $n-th sample point in “k-space”, j_{\nu,n+1}/X.  

=item C<gsl_dht_free($t)> - This function frees the transform $t.  

=item C<gsl_dht_apply> 

=back

=head1 EXAMPLES

=head1 AUTHOR

Jonathan Leto <jonathan@leto.net> and Thierry Moisan <thierry.moisan@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 Jonathan Leto and Thierry Moisan

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut
%}
