CREATE TABLE func_import_project_delta(
    uuid VARCHAR(40) NOT NULL,
    parent_uuid VARCHAR(40),
    project_status_uuid VARCHAR(40),
    name VARCHAR(40),
    title VARCHAR(1024),
    work_delta INTEGER
);


CREATE TRIGGER
    func_import_project_delta_bi_1
BEFORE INSERT ON
    func_import_project_delta
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.uuid,
        NEW.parent_uuid,
        NEW.project_status_uuid,
        NEW.name,
        NEW.title,
        NEW.work_delta
    );

    INSERT INTO
        func_update_project(
            change_id,
            id,
            parent_id,
            project_status_id,
            name,
            title,
            work_delta
        )
    SELECT
        currval('changes'),
        p.id,
        pp.id,
        s.id,
        NEW.name,
        NEW.title,
        NEW.work_delta
    FROM
        topics p
    LEFT JOIN
        topics pp
    ON
        pp.uuid = NEW.parent_uuid
    LEFT JOIN
        topics s
    ON
        s.uuid = NEW.project_status_uuid
    WHERE
        p.uuid = NEW.uuid
    ;

    SELECT RAISE(IGNORE);
END;
