CREATE TABLE hub_deltas (
    id INTEGER NOT NULL PRIMARY KEY,
    change_id INTEGER NOT NULL,
    hub_id INTEGER NOT NULL,
    new INTEGER,
    FOREIGN KEY(change_id) REFERENCES changes(id) ON DELETE CASCADE,
    FOREIGN KEY(hub_id) REFERENCES hubs(id) ON DELETE CASCADE
);

CREATE TRIGGER
    hub_deltas_ai_1
AFTER INSERT ON
    hub_deltas
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.change_id,
        NEW.hub_id,
        NEW.new
    );


    INSERT INTO
        hub_related_changes(
            change_id,
            hub_id
        )
    VALUES (
        NEW.change_id,
        NEW.hub_id
    );

    INSERT OR IGNORE INTO
        hubs_tomerge(hub_id) VALUES (NEW.hub_id);

/*
    UPDATE
        hubs_tomerge
    SET
        name = name + (NEW.name IS NOT NULL)
    WHERE
        hub_id = NEW.hub_id
    ;
*/

END;

CREATE TRIGGER
    hub_deltas_ad_1
AFTER DELETE ON
    hub_deltas
FOR EACH ROW
BEGIN

    SELECT debug(
        OLD.hub_id
    );

    INSERT OR IGNORE INTO
        hubs_tomerge(hub_id) VALUES (OLD.hub_id);

/*
    UPDATE
        hubs_tomerge
    SET
        name = name + (OLD.name IS NOT NULL)
    WHERE
        hub_id = OLD.hub_id
    ;
*/

END;

