package App::bif::log::issue;
use strict;
use warnings;
use feature 'state';
use Bif::Mo;

our $VERSION = '0.1.5_5';
extends 'App::bif::log';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $db   = $self->db;
    my $info = $self->get_node( $opts->{id}, 'issue' );

    state $have_dbix = DBIx::ThinSQL->import(qw/ qv concat /);
    my $now = $self->now;

    my $sth = $db->xprepare(
        select => [
            'id.issue_id AS id',
            concat( qv('c'), 'c.id' )->as('change_id'),
            'SUBSTR(c.uuid,1,8) AS change_uuid',
            'c.mtime AS mtime',
            "c.mtimetz AS mtimetz",
            'c.mtimetzhm AS mtimetzhm',
            "$now - c.mtime AS mtime_age",
            'c.action',
            'COALESCE(c.author,e.name) AS author',
            "COALESCE(c.author_contact_method || ': ' || "
              . "c.author_contact, ecm.method || ': ' || "
              . "ecm.mvalue) AS contact",
            'c.message',
            'c.ucount',
            'ist.status',
            'id.title',
            'ct.depth',
        ],
        from       => 'changes_tree ct',
        inner_join => 'changes c',
        on         => 'c.id = ct.child',
        inner_join => 'entities e',
        on         => 'e.id = c.identity_id',
        inner_join => 'entity_contact_methods ecm',
        on         => 'ecm.id = e.default_contact_method_id',
        inner_join => 'issue_deltas id',
        on         => 'id.change_id = c.id',
        inner_join => 'issues i',
        on         => 'i.id = id.issue_id',
        left_join  => 'projects p',
        on         => 'p.id = i.project_id',
        left_join  => 'issue_status ist',
        on         => 'ist.id = id.issue_status_id',
        where      => {
            'ct.parent' => $info->{first_change_id},
        },
        order_by => 'c.path ASC',
    );

    $sth->execute;
    $self->start_pager;

    my $first = $sth->hashref;
    $first->{ctime}     = $first->{mtime};
    $first->{ctimetz}   = $first->{mtimetz};
    $first->{ctimetzhm} = $first->{mtimetzhm};
    $first->{ctime_age} = $first->{mtime_age};
    $self->log_item( $first, 'issue' );

    $self->log_comment($_) for $sth->hashrefs;

    return $self->ok('LogIssue');
}

1;
__END__

=head1 NAME

=for bif-doc #history

bif-log-issue - review the history of a issue

=head1 VERSION

0.1.5_5 (2015-08-13)

=head1 SYNOPSIS

    bif log issue ID [OPTIONS...]

=head1 DESCRIPTION

The B<bif-log-issue> command displays the history of an issue.

=head1 ARGUMENTS & OPTIONS

=over

=item ID

The ID of a issue. Required.

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2014-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

