CREATE TABLE func_import_new_entity(
    change_uuid VARCHAR(40) NOT NULL,
    node_uuid VARCHAR(40) NOT NULL,
    contact_uuid VARCHAR(40),
    default_contact_method_uuid VARCHAR(40),
    name VARCHAR NOT NULL
);

CREATE TRIGGER
    func_import_new_entity_bi_1
BEFORE INSERT ON
    func_import_new_entity
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.change_uuid,
        NEW.node_uuid,
        NEW.contact_uuid,
        NEW.default_contact_method_uuid,
        NEW.name
    );

    INSERT INTO
        func_new_entity(
            change_id,
            id,
            contact_id,
            default_contact_method_id,
            name
        )
    SELECT
        c.id,
        n.id,
        cn.id,
        ecm.id,
        NEW.name
    FROM
        changes c
    INNER JOIN
        nodes n
    ON
        n.uuid = NEW.node_uuid
    LEFT JOIN
        nodes cn
    ON
        cn.uuid = NEW.contact_uuid
    LEFT JOIN
        nodes ecm
    ON
        ecm.uuid = NEW.default_contact_method_uuid
    WHERE
        c.uuid = NEW.change_uuid
    ;

    SELECT RAISE(IGNORE);
END;
