#!perl

use 5.010;
use strict;
use warnings;

use App::ConvertOperaBookmarksToOrg qw(
                                          convert_opera_bookmarks_to_org
                                          convert_org_to_opera_bookmarks
                                  );
use Test::More 0.98;
use Test::Differences;

my $adr = <<'EOF';
Opera Hotlist version 2.0
Options: encoding = utf8, version=3

#FOLDER
	ID=14
	NAME=f1
	CREATED=1413081192
	UNIQUEID=1C8FB59051B811E48566B8DEBFA056EC

#FOLDER
	ID=15
	NAME=f11
	CREATED=1413081192
	UNIQUEID=1CC7405051B811E4856798C59B500E50

#URL
	ID=16
	NAME=u111
	URL=http://example.com/
	CREATED=1403087670
	DESCRIPTION=description
	UNIQUEID=216CE090F6D411E385B9E13C07C33763

#URL
	ID=17
	NAME=u112
	URL=http://example.com/
	CREATED=1403087692
	DESCRIPTION=description
	UNIQUEID=2E4D89E0F6D411E385BAC86741CE36A9

-

-

#FOLDER
	ID=18
	NAME=f2
	CREATED=1413081192
	UNIQUEID=1CCD0CB051B811E48568A8B22F78C5E0

#FOLDER
	ID=19
	NAME=f21
	CREATED=1413081192
	UNIQUEID=1CCE453051B811E485698870F7D52847

#URL
	ID=20
	NAME=u211
	URL=http://example.com/
	CREATED=1348620509
	UNIQUEID=E3A4FB90077311E2B2E6B566C4C5B9AD

-

-

EOF

my $org = <<'EOF';
* FOLDER: f1
- CREATED :: 1413081192
- UNIQUEID :: 1C8FB59051B811E48566B8DEBFA056EC
** FOLDER: f11
- CREATED :: 1413081192
- UNIQUEID :: 1CC7405051B811E4856798C59B500E50
*** URL: u111
- URL :: http://example.com/
- CREATED :: 1403087670
- DESCRIPTION :: description
- UNIQUEID :: 216CE090F6D411E385B9E13C07C33763
*** URL: u112
- URL :: http://example.com/
- CREATED :: 1403087692
- DESCRIPTION :: description
- UNIQUEID :: 2E4D89E0F6D411E385BAC86741CE36A9
* FOLDER: f2
- CREATED :: 1413081192
- UNIQUEID :: 1CCD0CB051B811E48568A8B22F78C5E0
** FOLDER: f21
- CREATED :: 1413081192
- UNIQUEID :: 1CCE453051B811E485698870F7D52847
*** URL: u211
- URL :: http://example.com/
- CREATED :: 1348620509
- UNIQUEID :: E3A4FB90077311E2B2E6B566C4C5B9AD
EOF

eq_or_diff(convert_opera_bookmarks_to_org(input=>$adr)->[2],
           $org, "adr -> org");

my $adr2 = <<'EOF';
Opera Hotlist version 2.0 (generated by App::ConvertOperaBookmarksToOrg version [[VERSION]])
Options: encoding = utf8, version=3

#FOLDER
	ID=1
	NAME=f1
	CREATED=1413081192
	UNIQUEID=1C8FB59051B811E48566B8DEBFA056EC

#FOLDER
	ID=2
	NAME=f11
	CREATED=1413081192
	UNIQUEID=1CC7405051B811E4856798C59B500E50

#URL
	ID=3
	NAME=u111
	URL=http://example.com/
	CREATED=1403087670
	DESCRIPTION=description
	UNIQUEID=216CE090F6D411E385B9E13C07C33763

#URL
	ID=4
	NAME=u112
	URL=http://example.com/
	CREATED=1403087692
	DESCRIPTION=description
	UNIQUEID=2E4D89E0F6D411E385BAC86741CE36A9

-

-

#FOLDER
	ID=5
	NAME=f2
	CREATED=1413081192
	UNIQUEID=1CCD0CB051B811E48568A8B22F78C5E0

#FOLDER
	ID=6
	NAME=f21
	CREATED=1413081192
	UNIQUEID=1CCE453051B811E485698870F7D52847

#URL
	ID=7
	NAME=u211
	URL=http://example.com/
	CREATED=1348620509
	UNIQUEID=E3A4FB90077311E2B2E6B566C4C5B9AD

-

-

EOF

$adr2 =~ s/\[\[VERSION\]\]/$App::ConvertOperaBookmarksToOrg::VERSION || "dev"/e;

eq_or_diff(convert_org_to_opera_bookmarks(input=>$org)->[2],
           $adr2, "org -> adr");

done_testing;
