package Chart::GGPlot::Geom::Functions;

# ABSTRACT: Function interface for Chart::GGPlot::Geom

use Chart::GGPlot::Setup qw(:base :pdl);

our $VERSION = '0.0000_01'; # TRIAL VERSION

use Chart::GGPlot::Layer::Functions qw(layer);
use Chart::GGPlot::Types;
use Chart::GGPlot::Util qw(:all);

use parent qw(Exporter::Tiny);

my @export_ggplot = qw(
  geom_blank
  geom_point
  geom_path geom_line
  geom_bar geom_histogram
);

our @EXPORT_OK = (
    @export_ggplot,
);

our %EXPORT_TAGS = (
    all    => \@EXPORT_OK,
    ggplot => \@export_ggplot,
);

fun geom_blank (:$mapping = undef, :$data = undef,
                :$stat = "identity", :$position = "identity",
                :$show_legend = 'auto', :$inherit_aes = true,
                %rest) {
    return layer(
        data        => $data,
        mapping     => $mapping,
        stat        => $stat,
        position    => $position,
        show_legend => $show_legend,
        inherit_aes => $inherit_aes,
        check_aes   => false,
        geom        => 'blank',
        params      => \%rest,
    );
}

fun geom_path (:$mapping = undef, :$data = undef, 
               :$stat = 'identity', :$position = 'identity', 
               :$na_rm = false,
               :$show_legend = 'auto', :$inherit_aes = true, 
               %rest) {
    return layer(
        data        => $data,
        mapping     => $mapping,
        stat        => $stat,
        position    => $position,
        show_legend => $show_legend,
        inherit_aes => $inherit_aes,
        geom        => 'path',
        params      => { na_rm => $na_rm, %rest },
    );
}

fun geom_line (:$mapping = undef, :$data = undef, 
               :$stat = 'identity', :$position = 'identity', 
               :$na_rm = false,
               :$show_legend = 'auto', :$inherit_aes = true, 
               %rest) {
    return layer(
        data        => $data,
        mapping     => $mapping,
        stat        => $stat,
        position    => $position,
        show_legend => $show_legend,
        inherit_aes => $inherit_aes,
        geom        => 'line',
        params      => { na_rm => $na_rm, %rest },
    );
}

fun geom_point (:$mapping = undef, :$data = undef,
                :$stat = 'identity', :$position = 'identity',
                :$na_rm = false,
                :$show_legend = 'auto', :$inherit_aes = true, 
                %rest) {
    return layer(
        data        => $data,
        mapping     => $mapping,
        stat        => $stat,
        position    => $position,
        show_legend => $show_legend,
        inherit_aes => $inherit_aes,
        geom        => 'point',
        params      => { na_rm => $na_rm, %rest },
    );
}

fun geom_bar(:$mapping = undef, :$data = undef,
             :$stat = 'count', :$position = 'stack', 
             :$width = undef, :$na_rm = false,
             :$show_legend = 'auto', :$inherit_aes = true,
             %rest) {
    return layer(
        data        => $data,
        mapping     => $mapping,
        stat        => $stat,
        geom        => 'bar',
        position    => $position,
        show_legend => $show_legend,
        inherit_aes => $inherit_aes,
        params      => {
            width => $width,
            na_rm => $na_rm,
            %rest,
        },
    );
}

fun geom_histogram (:$data = undef, :$mapping = undef,
                    :$stat = "bin", :$position = "stack",
                    :$binwidth = undef, :$bins = undef,
                    :$na_rm = false,
                    :$show_legend = 'auto', :$inherit_aes = true,
                    %rest) {
    return layer(
        data        => $data,
        mapping     => $mapping,
        stat        => $stat,
        geom        => 'bar',
        position    => $position,
        show_legend => $show_legend,
        inherit_aes => $inherit_aes,
        params      => {
            binwidth => $binwidth,
            bins     => $bins,
            na_rm    => $na_rm,
            pad      => false,
            %rest
        },
    );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Chart::GGPlot::Geom::Functions - Function interface for Chart::GGPlot::Geom

=head1 VERSION

version 0.0000_01

=head1 AUTHOR

Stephan Loyd <sloyd@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Stephan Loyd.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
