/*	Copyright (c) 1990, 1991 UNIX System Laboratories, Inc.	*/
/*	Copyright (c) 1984, 1986, 1987, 1988, 1989, 1990 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF     	*/
/*	UNIX System Laboratories, Inc.                     	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef _FS_PROCFS_PRDATA_H	/* wrapper symbol for kernel use */
#define _FS_PROCFS_PRDATA_H	/* subject to change without notice */

/*#ident	"@(#)uts-comm:fs/procfs/prdata.h	1.9"*/
#ident  "$Revision: 1.14 $"

#include <sys/types.h>
#include <sys/sema.h>

/* XXX duplicated here & in fdfs, in place of param.h's BSD macros */
#define	min(a,b)	((a) <= (b) ? (a) : (b))
#define	max(a,b)	((a) >= (b) ? (a) : (b))
#define	round(r)	(((r)+sizeof(off_t)-1)&(~(sizeof(off_t)-1)))

#define	PNSIZ	5			/* size of /proc name entries */

#ifdef _KERNEL
extern struct vfs *procvfs;	/* Points to /proc vfs entry. */
extern dev_t procdev;
extern struct vnodeops prvnodeops;
#endif


/*
 * Macros for mapping between i-numbers and pids.
 */
#define	PRBIAS	64
#define	itop(n)	((int)((n)-PRBIAS))	/* i-number to pid */
#define	ptoi(n)	((int)((n)+PRBIAS))	/* pid to i-number */

typedef enum prnodetype {
	PR_PROCDIR,	/* /proc */
	PR_PSINFO	/* /proc/pinfo */
} prnodetype_t;

/*
 * MP locking protocols:
 *	pr_free				splock/spunlock prfreelock
 *	pr_vnext			splock/spunlock pr_proc->p_siglck
 *	pr_vnode, etc.			prlock/prunlock
 */
typedef struct prnode {
	struct prnode	*pr_free;	/* freelist pointer */
	struct vnode	*pr_vnext;	/* linked list of invalid vnodes */
	struct vnode	*pr_vnode;	/* associated vnode */
	struct proc	*pr_proc;	/* process being traced */
	prnodetype_t	pr_type;
	short		pr_mode;	/* file mode bits */
	short		pr_opens;	/* count of opens */
	short		pr_writers;	/* count of opens for writing */
	short		pr_flags;	/* private flags */
	sema_t		pr_lock;	/* mutual exclusion */
} prnode_t;

/*
 * Conversion macros.
 */
#define	VTOP(vp)	((struct prnode *)(vp)->v_data)
#define	PTOV(pnp)	((pnp)->pr_vnode)

/*
 * Flags for pr_flags.
 */
#define	PREXCL		0x01	/* Exclusive-use (disallow opens for write) */
#define	PRINVAL		0x02	/* vnode is invalid (security provision) */

/*
 * Flags to prlock()
 */
#define PRNULLOK	0	/* null proc ok */
#define PRNONULL	0x1	/* null proc not ok */

/*
 * Assign one set to another (possible different sizes).
 *
 * Assigning to a smaller set causes members to be lost.
 * Assigning to a larger set causes extra members to be cleared.
 */
#define	prassignset(ap, sp)					\
{								\
	register int _i_ = sizeof(*(ap))/sizeof(__uint32_t);	\
	while (--_i_ >= 0)					\
		((__uint32_t*)(ap))[_i_] =			\
		  (_i_ >= sizeof(*(sp))/sizeof(__uint32_t)) ?	\
		  0L : ((__uint32_t*)(sp))[_i_];		\
}

/*
 * Determine whether or not a set (of arbitrary size) is empty.
 */
#define prisempty(sp)	\
	setisempty((__uint32_t *)(sp), sizeof(*(sp))/sizeof(__uint32_t))

/* This header file exists in kernel source only. 
 * Commands that include this header must be
 * built like kernel, thus passing in _KMEMUSER flag.
 */
#ifdef _KERNEL

#define isactive(p)	((p)->p_stat == SSLEEP || (p)->p_stat == SRUN  || \
			 (p)->p_stat == SZOMB  || (p)->p_stat == SSTOP || \
			 (p)->p_stat == SIDL   || (p)->p_stat == SXBRK)

/*
 * This macro defines whether the process can get back into user
 * space or not. It does NOT guarantee that the process will not
 * wakeup inside the kernel and continue running inside the O.S.
 * it must NOT be used as a substitute for locking.
 */
#define isstopped(p)	((p)->p_stat == SSTOP && (p)->p_whystop != JOBCONTROL \
			 || (p)->p_stat == SSLEEP && ((p)->p_flag & SPRSTOP) \
			 || (p)->p_stat == SXBRK && ((p)->p_flag & SPRSTOP) \
			 || ((p)->p_flag2 & SONCESTOPPED))

#include <sys/uio.h>		/* XXX for enum uio_rw */

enum uio_rw;
struct cred;
struct prmap;
struct prmap_sgi;
struct pgd;
struct prpgd_sgi;
struct proc;
struct prpsinfo;
struct prstatus;
struct region;
struct sigaction;
struct uio;
struct user;

int		prusrio(struct proc *, enum uio_rw, struct uio *);
int		prisreadable(struct proc *, struct cred *);
int		prlock(struct prnode *, int, int);
void		prunlock(struct prnode *);
int		prgetstatus(struct proc *, struct prstatus *);
void		prgetaction(struct proc *, struct user *, u_int,
			    struct sigaction *);
int		prnsegs(struct proc *, int);
void		prgetmap(struct proc *, struct prmap *, int);
int		prgetmap_sgi(struct proc *, caddr_t, int *);
int		prgetpgd_sgi(struct proc *, caddr_t, struct prpgd_sgi *);
int		prgetpgf(preg_t *, caddr_t, pgno_t, struct pgd *);
struct vnode	*prvnode(struct proc *, struct region *, caddr_t);
int		prgetpsinfo(struct proc *, struct prpsinfo *);
int		setisempty(__uint32_t *, unsigned);
int		prwstop(proc_t *, struct prnode *);
void		prstop(proc_t *);

/*
 * Machine-dependent routines (defined in prmachdep.c).
 */
#include <sys/ksignal.h>	/* XXX for sigset_t, required by ucontext.h */
#include <sys/kucontext.h>

struct prusage;
struct user	*prumap(struct proc *);
void		prunmap(struct proc *);
void		prgetregs(struct user *, greg_t *);
void		prsetregs(struct user *, greg_t *);
int		prhasfp(void);
int		prgetfpregs(struct proc *, fpregset_t *);
int		prsetfpregs(struct proc *, fpregset_t *);
caddr_t		prgetpsaddr(struct proc *);
void		prstep(struct proc *, struct user *);
void		prsvaddr(struct proc *, struct user *, caddr_t);
caddr_t		prmapin(struct proc *, caddr_t, int);
void		prmapout(struct proc *, caddr_t, caddr_t, int);
caddr_t		prfastmapin(struct proc *, caddr_t, int);
void		prfastmapout(struct proc *, caddr_t, caddr_t, int);
int		prrgetu(caddr_t, caddr_t, u_int);
void		prawake(struct proc *);
void		prinvalidate(struct user *);
void		prexit(struct proc *);
void		prgetptimer(proc_t *, timestruc_t *);
int		watchcopy(caddr_t, ulong, ulong, caddr_t *);
void		prgetusage(struct user *, struct prusage *);
int		prgetpginfo(proc_t *, preg_t *, caddr_t, pgno_t,
			struct pgd *, pgno_t *);
#define	prgetsizes(a,b,c,d,e) (void)prgetpginfo(a,b,c,d,0,e)
#define	prgetpgf(a,b,c,d,e) prgetpginfo(a,b,c,d,e,0)

#if _K32US64
void		prgetregs64(struct user *, irix5_64_greg_t *);
void		prsetregs64(struct user *, irix5_64_greg_t *);
int		prgetfpregs64(struct proc *, irix5_64_fpregset_t *);
int		prsetfpregs64(struct proc *, irix5_64_fpregset_t *);
#endif	/* _K32U64 */

#endif /* _KERNEL */

#endif	/* _FS_PROCFS_PRDATA_H */
