/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.java.io.LogRecord;
import org.apache.java.io.Logger;
import org.apache.java.util.Configurations;
import org.apache.java.util.SimpleQueue;

public class LogWriter
implements Logger {
    public static final String DEFAULT_IDENTIFIER = "log";
    public static final String DEFAULT_DATEFORMAT = "[dd/MM/yyyy HH:mm:ss zz] ";
    public static final String KEYWORD_DATEFORMAT = "dateFormat";
    public static final String KEYWORD_TIMESTAMP = "timestamp";
    public static final String KEYWORD_CHANNEL = "channel";
    public static final String KEYWORD_FILE = "file";
    public static final String KEYWORD_QUEUE_MAXAGE = "queue.maxage";
    public static final String KEYWORD_QUEUE_MAXSIZE = "queue.maxsize";
    public static final String CH_QUEUE_STATUS = "info";
    public static final String CH_EXCEPTION_TRACING = "servletException";
    public Configurations configurations;
    public boolean active = false;
    private long queue_maxage;
    private long queue_maxsize;
    private String identifier;
    private boolean timestamp;
    private SimpleDateFormat formatter;
    private PrintWriter writer;
    private Agent logDaemon;
    private boolean logChannel;
    protected SimpleQueue logQueue = new SimpleQueue();

    public LogWriter(OutputStream outputStream, String string, Configurations configurations) throws IOException {
        this(new BufferedWriter(new OutputStreamWriter(outputStream)), string, configurations);
    }

    public LogWriter(OutputStream outputStream, Configurations configurations) throws IOException {
        this(new BufferedWriter(new OutputStreamWriter(outputStream)), DEFAULT_IDENTIFIER, configurations);
    }

    public LogWriter(Writer writer, String string, Configurations configurations) throws IOException {
        if (configurations == null) {
            return;
        }
        this.configurations = configurations;
        this.identifier = string == null ? DEFAULT_IDENTIFIER : string;
        this.active = configurations.getBoolean(string, false);
        this.logChannel = configurations.getBoolean(String.valueOf(string) + "." + KEYWORD_CHANNEL, false);
        if (this.active) {
            String string2;
            if (writer == null) {
                string2 = configurations.getString(String.valueOf(string) + "." + KEYWORD_FILE);
                if (string2 == null) {
                    throw new IOException("Log is active, but log file (" + string + "." + KEYWORD_FILE + ") is not specified");
                }
                File file = new File(string2);
                if (file.exists()) {
                    if (!file.canWrite()) {
                        throw new IOException("Not writable: " + file.getAbsolutePath());
                    }
                } else {
                    try {
                        File file2 = new File(file.getParent());
                        if (!file2.canWrite()) {
                            throw new IOException("Directory not writable: " + file2.getAbsolutePath());
                        }
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                this.writer = new PrintWriter(new FileWriter(file.getAbsolutePath(), true));
            } else {
                this.writer = new PrintWriter(writer);
            }
            this.timestamp = configurations.getBoolean(String.valueOf(string) + "." + KEYWORD_TIMESTAMP, false);
            if (this.timestamp) {
                string2 = configurations.getString(String.valueOf(string) + "." + KEYWORD_DATEFORMAT, DEFAULT_DATEFORMAT);
                this.formatter = new SimpleDateFormat(string2);
                this.formatter.setTimeZone(TimeZone.getDefault());
            }
            this.queue_maxage = configurations.getInteger(KEYWORD_QUEUE_MAXAGE, 5000);
            this.queue_maxsize = configurations.getInteger(KEYWORD_QUEUE_MAXSIZE, 10000);
            this.logDaemon = new Agent();
            this.logDaemon.setDaemon(true);
            this.logDaemon.start();
        }
    }

    public LogWriter(Writer writer, Configurations configurations) throws IOException {
        this(writer, DEFAULT_IDENTIFIER, configurations);
    }

    public LogWriter(String string, Configurations configurations) throws IOException {
        this((Writer)null, string, configurations);
    }

    public LogWriter(Configurations configurations) throws IOException {
        this((Writer)null, DEFAULT_IDENTIFIER, configurations);
    }

    public void flush() {
        if (this.logDaemon != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    Thread.currentThread().setPriority(10);
                    LogWriter.this.logDaemon.flush();
                }
            };
            new Thread(runnable).start();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isActive(String string) {
        try {
            return string != null && this.configurations.getBoolean(String.valueOf(this.identifier) + "." + KEYWORD_CHANNEL + "." + string, false);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void log(String string, String string2) {
        if (this.active && this.isActive(string)) {
            this.logQueue.put(new LogRecord(string, string2, null));
            if ((long)this.logQueue.size() > this.queue_maxsize) {
                this.logQueue.put(new LogRecord(CH_QUEUE_STATUS, "Log queue size limit exceeded", null));
                this.flush();
            }
        }
    }

    public void log(String string, Throwable throwable) {
        if (this.active && this.isActive(string)) {
            this.logQueue.put(new LogRecord(string == null ? CH_EXCEPTION_TRACING : string, null, throwable));
            if ((long)this.logQueue.size() > this.queue_maxsize) {
                this.logQueue.put(new LogRecord(CH_QUEUE_STATUS, "Log queue size limit exceeded", null));
                this.flush();
            }
        }
    }

    public void log(Throwable throwable) {
        this.log(null, throwable);
    }

    protected class Agent
    extends Thread {
        protected Agent() {
        }

        public void flush() {
            while (!LogWriter.this.logQueue.isEmpty()) {
                LogRecord logRecord = (LogRecord)LogWriter.this.logQueue.get();
                if (logRecord == null) continue;
                this.write(logRecord);
            }
        }

        public void run() {
            Thread.currentThread().setPriority(1);
            try {
                while (true) {
                    LogRecord logRecord = (LogRecord)LogWriter.this.logQueue.waitObject();
                    this.write(logRecord);
                    if (System.currentTimeMillis() - logRecord.date <= LogWriter.this.queue_maxage) continue;
                    Thread.currentThread().setPriority(10);
                    this.write(new LogRecord(LogWriter.CH_QUEUE_STATUS, "Log queue age limit exceeded", null));
                    this.flush();
                    Thread.currentThread().setPriority(1);
                }
            }
            catch (InterruptedException interruptedException) {
                if (!LogWriter.this.logQueue.isEmpty()) {
                    this.write(new LogRecord(LogWriter.CH_EXCEPTION_TRACING, "Logger thread interrupted, flushing...", interruptedException));
                    this.flush();
                    this.write(new LogRecord(LogWriter.CH_EXCEPTION_TRACING, "Flushed, logging stopped.", null));
                }
                return;
            }
        }

        public synchronized void write(LogRecord logRecord) {
            if (LogWriter.this.isActive(logRecord.channel)) {
                if (LogWriter.this.timestamp) {
                    LogWriter.this.writer.print(LogWriter.this.formatter.format(new Date(logRecord.date)));
                }
                if (LogWriter.this.logChannel && logRecord.channel != null) {
                    LogWriter.this.writer.print(" <");
                    LogWriter.this.writer.print(logRecord.channel);
                    LogWriter.this.writer.print(">");
                }
                LogWriter.this.writer.print(" ");
                if (logRecord.message != null) {
                    LogWriter.this.writer.println(logRecord.message);
                }
                if (logRecord.t != null) {
                    logRecord.t.printStackTrace(LogWriter.this.writer);
                }
                LogWriter.this.writer.flush();
            }
        }
    }
}

