@rem = '--*-CPerl-*--
@echo off
perl -x -S %0 %*
goto endofperl
@rem ';
#!perl -w
#line 8
##
##  configure.bat -- mod_ssl configuration script (Win32 version)
##
##  ====================================================================
##  Copyright (c) 1998 Ralf S. Engelschall. All rights reserved.
## 
##  Redistribution and use in source and binary forms, with or without
##  modification, are permitted provided that the following conditions
##  are met:
## 
##  1. Redistributions of source code must retain the above copyright
##     notice, this list of conditions and the following disclaimer. 
## 
##  2. Redistributions in binary form must reproduce the above copyright
##     notice, this list of conditions and the following
##     disclaimer in the documentation and/or other materials
##     provided with the distribution.
## 
##  3. All advertising materials mentioning features or use of this
##     software must display the following acknowledgment:
##     "This product includes software developed by 
##      Ralf S. Engelschall <rse@engelschall.com> for use in the
##      mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)."
## 
##  4. The names "mod_ssl" must not be used to endorse or promote
##     products derived from this software without prior written
##     permission. For written permission, please contact
##     rse@engelschall.com.
## 
##  5. Products derived from this software may not be called "mod_ssl"
##     nor may "mod_ssl" appear in their names without prior
##     written permission of Ralf S. Engelschall.
## 
##  6. Redistributions of any form whatsoever must retain the following
##     acknowledgment:
##     "This product includes software developed by 
##      Ralf S. Engelschall <rse@engelschall.com> for use in the
##      mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)."
## 
##  THIS SOFTWARE IS PROVIDED BY RALF S. ENGELSCHALL ``AS IS'' AND ANY
##  EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
##  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
##  PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RALF S. ENGELSCHALL OR
##  HIS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
##  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
##  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
##  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
##  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
##  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
##  OF THE POSSIBILITY OF SUCH DAMAGE.
##  ====================================================================
##

require 5.003;
use strict;

#
#   configuration
#
my $prefix  = ' +';
my $prefixe = '  ';
my $apache  = '';
my $ssleay  = '';
my $patch   = 'etc\patch\patch.exe';

(my $progname = $0) =~ s|.*[/\\]||;

#
#   determine versions and give a friendly header
#
open(FP, "<ssl.source\\libssl.version");
my $v = <FP>;
$v =~ s|\n||;
close(FP);
(my $V_MODSSL = $v) =~ s|-.+$||;
(my $V_APACHE = $v) =~ s|^.+-||;
my $V_MODSSL_NUM;
if ($V_MODSSL =~ m|(\d+).(\d+)b(\d+)|) {
    $V_MODSSL_NUM = sprintf("%d%02d0%02d", $1, $2, $3);
}
else  {
    $V_MODSSL_NUM = sprintf("%d%02d1%02d", $1, $2, $3);
}

#
#   parse argument line
#
my $arg;
my $usage = 0;
my $help = 0;
foreach $arg (@ARGV) {
    if ($arg =~ m|--with-apache=(\S+)|) {
        $apache = $1;
        $apache =~ s|/|\\|g;
        next;
    }
    if ($arg =~ m|--with-ssleay=(\S+)|) {
        $ssleay = $1;
        $ssleay =~ s|/|\\|g;
        next;
    }
    if ($arg =~ m|--with-patch=(\S+)|) {
        $patch = $1;
        $patch =~ s|/|\\|g;
        next;
    }
    if ($arg =~ m|--help|) {
        $help = 1;
        last;
    }
    $usage = 1;
    last;
}
$usage = 1 if ($#ARGV == -1);
if ($usage) {
    print STDERR "$progname: Bad argument line\n";
    print STDERR "$progname: Usage: $progname [options]\n";
    $help  = 1;
}
if ($help) {
    print STDERR "Options are:\n";
    print STDERR "  --with-apache=DIR  ...path to Apache 1.3.x source tree    [REQUIRED]\n";
    print STDERR "  --with-ssleay=DIR  ...path to SSLeay 0.9.x source tree    [REQUIRED]\n";
    print STDERR "  --with-patch=FILE  ...path to your vendor 'patch' program [OPTIONAL]\n";
    exit(1);
}

#
#   give a friendly header
#
print "Configuring mod_ssl/$V_MODSSL for Apache/$V_APACHE\n";

#
#   check for Apache 1.3
#
if (not -f "$apache\\src\\include\\httpd.h") {
    print STDERR "$progname:Error: Cannot find Apache 1.3 source tree under $apache\n";
    print STDERR "$progname:Hint:  Please specify location via --with-apache=DIR\n";
    exit(1);
}
open(FP, "<$apache\\src\\include\\httpd.h");
my $data = '';
$data .= $_ while(<FP>);
close(FP);
my ($APV) = ($data =~ m|SERVER_BASEVERSION\s+\"Apache/(\d+\.\d+[.b]\d+)\"|);
if ($V_APACHE ne $APV) {
    print STDERR "Error: The mod_ssl/$V_MODSSL can be used for Apache/$V_APACHE only.\n";
    print STDERR "Error: Your Apache source tree under $apache is version $APV.\n";
    print STDERR "Hint:  Please use an extracted apache_$V_APACHE.tar.gz tarball\n";
    print STDERR "Hint:  with the --with-apache option, only.\n";
    exit(1);
}
print "$prefix Using Apache $APV source tree under $apache\n";

#
#   check for SSLeay
#
if (not -f "$ssleay\\bin\\ssleay.exe"   or
    not -f "$ssleay\\include\\ssl.h"    or 
    not -f "$ssleay\\lib\\libeay32.lib" or 
    not -f "$ssleay\\lib\\ssleay32.lib"    ) {
    print STDERR "Error: Cannot find SSLeay source or install tree under $ssleay\n";
    print STDERR "Hint:  Please specify location via --with-ssleay=DIR\n";
    exit(1);
}
print "$prefix Using SSLeay source or install tree under $ssleay\n"; 

#
#   Apply patches
#
print "$prefix Applying mod_ssl extension and patches to Apache source tree\n";
my $f;
foreach $f ("README", "LICENSE", "INSTALL") {
    print "$prefixe creating: [FILE] $f.SSL\n";
    system("copy /b $f $apache\\$f.SSL >nul:");
}
print "$prefixe creating: [FILE] src\\CHANGES.SSL\n";
system("copy /b CHANGES $apache\\src\\CHANGES.SSL >nul:");
open(FP, "$patch --forward --directory=$apache <ssl.patch\\apache.patch 2>&1|") || die "$!";
my $line;
while (defined($line = <FP>)) {
    if ($line =~ m/^\|Index:\s+(\S+).*/) {
        my $f = $1;
        $f =~ s|/|\\|g;
        print "   patching: [FILE] $f\n";
    }
}
close(FP);

#
# patch Apache DevStudio-generated Makefiles
#
sub patch_mak {
    my ($ssl_base, $apache_base, $mak) = @_;
    my ($data, $src_base);

    #   display action
    print "   patching: [FILE] src\\$mak\n";

    #   determine relative path to Apache src dir
    $src_base = '';
    my @s = split(/\\/, $mak);
    $src_base = "..\\" x $#s;
    $src_base =~ s|\\$||;
    $src_base = "." if ($src_base eq "");

    #   read Makefile
    open(FP, "<$apache_base\\src\\$mak") || die "$!";
    $data = '';
    $data .= $_ while (<FP>);
    close(FP);
    
    #   patch Makefile
    $data =~ s|^(CPP_PROJ\s*)=|$1=/DEAPI /DMOD_SSL=$V_MODSSL_NUM /I$ssl_base\\include |mg;
    
    #   write Makefile
    open(FP, ">$apache_base\\src\\$mak") || die "$!";
    print FP $data;
    close(FP);
}
my $mak;
foreach $mak (qw(
    Apache.mak
    ApacheCore.mak
    ap\ap.mak
    main\gen_test_char.mak
    main\gen_uri_delims.mak
    modules\proxy\ApacheModuleProxy.mak
    os\win32\ApacheModuleAuthAnon.mak
    os\win32\ApacheModuleCERNMeta.mak
    os\win32\ApacheModuleDigest.mak
    os\win32\ApacheModuleExpires.mak
    os\win32\ApacheModuleHeaders.mak
    os\win32\ApacheModuleInfo.mak
    os\win32\ApacheModuleRewrite.mak
    os\win32\ApacheModuleSpeling.mak
    os\win32\ApacheModuleStatus.mak
    os\win32\ApacheModuleUserTrack.mak
    os\win32\ApacheOS.mak
    os\win32\MakeModuleMak.mak
    regex\regex.mak
)) {
    patch_mak($ssleay, $apache, $mak);
}
print "   patching: [FILE] src\\Makefile.nt\n";
open(FP, "<$apache\\src\\Makefile.nt") || die "$!";
$data = '';
$data .= $_ while (<FP>);
close(FP);
$data =~ s|^(\s+)(cd modules\\proxy)$|$1cd modules\\ssl\n$1nmake /nologo CFG="mod_ssl - Win32 %LONG%" -f Makefile\n$1cd ..\\..\n$1$2|mg;
$data =~ s|^(\s+)(copy modules\\proxy\\.*)$|$1copy modules\\ssl\\\*\.dll \$\(INSTDIR\)\\modules\n$1$2|mg;
open(FP, ">$apache\\src\\Makefile.nt") || die "$!";
print FP $data;
close(FP);

#
#  copy sources
#
if (not -d "$apache\\src\\modules\\ssl") {
    print "   creating: [DIR]  modules\\ssl\n";
    system("mkdir $apache\\src\\modules\\ssl\n");
}
print "   creating: [FILE] modules\\ssl\\Makefile\n";
open(SRC, "<ssl.source\\Makefile.win32") or die "$!";
open(DST, ">$apache\\src\\modules\\ssl\\Makefile") or die "$!";
while (<SRC>) {
    s|^(SSLEAY_INC\s*)=.*|$1=$ssleay\\include|g;
    s|^(SSLEAY_LIB\s*)=.*|$1=$ssleay\\lib|g;
    s|^(MOD_SSL_VERS_NUM\s*)=.*|$1=$V_MODSSL_NUM|g;
    s|^(MOD_SSL_VERS_STR\s*)=.*|$1=$V_MODSSL|g;
    print DST $_;
}
close(SRC);
close(DST);
my @F = glob("ssl.source\\*");
foreach $f (@F) {
    my $b = $f;
    $b =~ s|^ssl.source\\||;
    next if ($b =~ m|^Makefile\..+|);
    print "   creating: [FILE] src\\modules\\ssl\\$b\n";
    system("copy /b ssl.source\\$b $apache\\src\\modules\\ssl >nul:");
}
print "$prefixe creating: [FILE] src\\ap\\ap_hook.c\n";
system("copy /b ssl.eapi\\ap_hook.c $apache\\src\\ap\\ap_hook.c >nul:");
print "$prefixe creating: [FILE] src\\ap\\ap_ctx.c\n";
system("copy /b ssl.eapi\\ap_ctx.c $apache\\src\\ap\\ap_ctx.c >nul:");
print "$prefixe creating: [FILE] src\\include\\ap_hook.h\n";
system("copy /b ssl.eapi\\ap_hook.h $apache\\src\\include\\ap_hook.h >nul:");
print "$prefixe creating: [FILE] src\\include\\ap_ctx.h\n";
system("copy /b ssl.eapi\\ap_ctx.h $apache\\src\\include\\ap_ctx.h >nul:");
print "$prefixe creating: [FILE] htdocs\\manual\\mod\\mod_ssl.html\n";
system("copy /b ssl.docs\\mod_ssl.html $apache\\htdocs\\manual\\mod\\mod_ssl.html >nul:");
print "$prefixe creating: [FILE] htdocs\\manual\\mod\\mod_ssl_about.html\n";
system("copy /b ssl.docs\\mod_ssl_about.html $apache\\htdocs\\manual\\mod\\mod_ssl_about.html >nul:");
print "$prefixe creating: [FILE] htdocs\\manual\\mod\\mod_ssl_ref.html\n";
system("copy /b ssl.docs\\mod_ssl_ref.html $apache\\htdocs\\manual\\mod\\mod_ssl_ref.html >nul:");
print "$prefixe creating: [FILE] htdocs\\manual\\mod\\mod_ssl_compat.html\n";
system("copy /b ssl.docs\\mod_ssl_compat.html $apache\\htdocs\\manual\\mod\\mod_ssl_compat.html >nul:");
print "$prefixe creating: [FILE] htdocs\\manual\\mod\\mod_ssl_faq.html\n";
system("copy /b ssl.docs\\mod_ssl_faq.html $apache\\htdocs\\manual\\mod\\mod_ssl_faq.html >nul:");
print "$prefixe creating: [FILE] htdocs\\manual\\mod\\mod_ssl_glossary.html\n";
system("copy /b ssl.docs\\mod_ssl_glossary.html $apache\\htdocs\\manual\\mod\\mod_ssl_glossary.html >nul:");
print "$prefixe creating: [FILE] htdocs\\manual\\images\\mod_ssl.jpg\n";
system("copy /b ssl.docs\\mod_ssl.jpg $apache\\htdocs\\manual\\images\\mod_ssl.jpg >nul:");
print "$prefixe creating: [FILE] htdocs\\manual\\images\\mod_ssl_sb.gif\n";
system("copy /b ssl.docs\\mod_ssl_sb.gif $apache\\htdocs\\manual\\images\\mod_ssl_sb.gif >nul:");
print "$prefixe creating: [FILE] htdocs\\manual\\images\\apache_pb.gif\n";
system("copy /b ssl.docs\\apache_pb.gif $apache\\htdocs\\manual\\images\\apache_pb.gif >nul:");
print "$prefixe creating: [FILE] htdocs\\manual\\images\\ssleay.gif\n";
system("copy /b ssl.docs\\ssleay.gif $apache\\htdocs\\manual\\images\\ssleay.gif >nul:");
print "Done: SSL source extension and patches successfully applied.\n";

##
##  Final message
##
print "\n";
print "Now please switch to $apache\\src and run:\n";
print " \$ nmake /f Makefile.nt\n";
print " \$ nmake /f Makefile.nt installr\n";
print "\n";

exit(0);

__END__
:endofperl

