
/* sxnet.h	- Thawte StrongExtraNet interface code
 *
 * Requires SSLeay-0.8.0 or above
 *
 * Copyright 1997 Thawte Consulting Pty Ltd
 *
 * http://www.thawte.com
 *
 */

#ifndef HEADER_THAWTE_SXNET_H
#define HEADER_THAWTE_SXNET_H

/*

 Thawte StrongExtranet X509v3 Extension
 OID 1.3.101.1.4.1

 SEQUENCE (
    INTEGER(0) -- Version
    SEQUENCE (
      SEQUENCE ( INTEGER, OCTETSTRING ),
      SEQUENCE ( INTEGER, OCTETSTRING ),
      SEQUENCE ( INTEGER, OCTETSTRING ),
      ...
      )
    )
  )

*/

/*
 * "id"     a character string that is an identity within a zone
 * "zone"   an integer describing a unique zone
 * "idlist" a set of zone+id combinations
 *
 */

#define THAWTE_SXNET_MAX_ID_LENGTH 64
typedef struct {
  long  zone;
  int   idLength;
  char  id[THAWTE_SXNET_MAX_ID_LENGTH];
} THAWTE_SXNET_ID;

typedef struct {
  int             idListCount;
  THAWTE_SXNET_ID idList[1];        /* array of ids */
} THAWTE_SXNET_IDLIST;

int THAWTE_SXNET_extract_list(X509 *cert,THAWTE_SXNET_IDLIST **ids);
THAWTE_SXNET_ID *THAWTE_extract_zone(THAWTE_SXNET_IDLIST *ids, int zone);
char *binaryToBase64(char *data, int len);

#endif /* HEADER_THAWTE_SXNET_H */



