#include <stdio.h>
#include "mixmaster.h"
#include "inet.h"
#define MAXLINE 512


/* The following I/O procedures are from Network programming */

/*
 * Read "n" bytes from a descriptor.
 * Use in place of read() when fd is a stream socket.
 *
 */

int readn(fd, ptr, nbytes)
register int	fd;
register char	*ptr;
register int	nbytes;
{
	int	nleft, nread;

	nleft = nbytes;
	while (nleft > 0) {
	  nread = read(fd,ptr,nleft);
	  if (nread < 0) return(nread);	/* error, return < 0 */
	  else if (nread == 0) break;	/* EOF */

	  nleft	-= nread;
	  ptr	+= nread;
	}
	return(nbytes - nleft);		/* return >= 0 */
}


/*
 * Write "n" bytes to a descriptor.
 * Use in place of write() when fd is a stream socket.
 */

int writen(fd, ptr, nbytes)
register int	fd;
register char	*ptr;
register int	nbytes;
{
	int	nleft, nwritten;

	nleft = nbytes;
	while (nleft > 0) {
	  nwritten = write(fd, ptr,nleft);
	  if (nwritten <= 0) return(nwritten);	/* error */

	  nleft	-= nwritten;
	  ptr	+= nwritten;
	}
	return(nbytes - nleft);
}


/*
 * Read a line from a descriptor. Read the line one byte at a time,
 * looking for the newline. We store the newline in the buffer,
 * then follow it with a null (the same as fgets(3)).
 * We return the number of characters up to, but not including,
 * the null (the same as strlen(3)).
 */

int readline(fd, ptr, maxlen)
register int	fd;
register char	*ptr;
register int	maxlen;
{
	int	n, rc;
	char	c;

	for (n=1; n< maxlen; n++) {
	  if ( (rc = read(fd, &c,1)) == 1) {
	    *ptr++ = c;
	    if (c == '\n') break;
	  } else if (rc == 0) {
	    if (n == 1) return(0);	/* EOF, no data read */
	    else break;			/* EOF, some date read */
	  } else return(-1);		/* error */
	}

	*ptr = 0;
	return(n);
}

/*
 * Read a stream socket one line at a time, and write each line back
 * to the sender.
 *
 * Return when the connection is terminated.
 */


void str_echo(sockfd)
int	sockfd;
{
	int	n;
	char	line[MAXLINE];

	for( ; ; ) {
	  n = readline(sockfd, line, MAXLINE);
	  if(n == 0) return;		/* connection terminated */
	  else if (n < 0) err_dump("str_echo: readline error");

	  if (writen(sockfd, line, n) != n)
	  	err_dump("str_echo: writen error");
	}
}

/*
 * Read the content of the FILE *fp, write each line to the
 * stream socket (to the serve process), then read a line back from
 * the socket and write it to the standard output.
 *
 * Return to caller when an EOF is encountered on the input file.
 */

str_cli(fp, sockfd)
register FILE	*fp;
register int	sockfd;
{
	int	n;
	char	sendline[MAXLINE], recvline[MAXLINE + 1];

	while (fgets(sendline, MAXLINE, fp) != NULL) {
	   n = strlen(sendline);
	   if(writen(sockfd, sendline,n) != n)
	   	err_dump("str_cli: writen error on socket");

	   n = readline (sockfd, recvline, MAXLINE);
	   if (n < 0) err_dump("str_cli: readline error");

	   fputs(recvline, stdout);
	}

	if (ferror(fp)) err_dump("str_cli: error reading file");
}

/* the following procedures are hacks by me */

/* reads upto maxlen characters from fd upto ASCII zero */
/* returns number of chars read. Neg if EOF, zero if maxlen */
int sock_read(fd,line,maxlen)
int fd, maxlen;
char line[];
{
	char	*ptr;
	int	i, error;

	ptr = line;
	i=1;
	while (i<=maxlen) {
	  error = read(fd,ptr,1);
	  if(error == 0) {
	    i *= -1;
	    ptr++;
	    *ptr = 0;
	    return(i);
	  }
	  if(*ptr == 0) {
	    return(i);
	  }
	  i++;
	  ptr++;
	}
	return(0);
}

int sock_write(fd,line)
int fd;
char *line;
{
	int	error, zero=0;

	error = write(fd,line,strlen(line));
	if (error != strlen(line)) return(-1);
	error = write(fd,&zero,1);
	if (error != 1) return(-1);
	return(1);
}


/*
 * Read From the socket. Put all but the first caracter in the passed
 * buffer. If first char is +, get another line, if char is -
 * that was the last line. 
 */

int read_block(fd,buff)
int fd;
BUFFER *buff;
{
	char	line[256], *ptr;
	int	n;

	while((n = readline(fd,line,256)) > 0) {
	   add_to_buffer(buff,line+1,n-1);
	   if(line[0] == '-') break; /* that was the last line */
	}
	return(n);
}
