/*
 * util.c        1.1 11/2/95
 *	Changed fclose to pclose for pipes
 *
 * util.c        1.0 4/23/95
 *
 *      (c) Copyright 1995 by Lance Cottrell. All right reserved.
 *      The author assumes no liability for damages resulting from the
 *      use of this software, even if the damage results from defects in
 *      this software. No warranty is expressed or implied.
 *
 *      This software is being distributed under the GNU Public Licence,
 *      see the file GNU.license for more details.
 *
 *                      - Lance Cottrell (loki@obscura.com) 4/23/95
 *
 */

#include "crypt.h"
#include "mixmaster.h"
#include <sys/file.h>
#include <fcntl.h>

#ifndef LOCK_SH
#define	LOCK_SH	1    /* shared lock */
#define LOCK_EX	2    /* exclusive lock */
#define LOCK_NB 4    /* don't block when locking */
#define LOCK_UN 8    /* unlock */
#endif

long int **make_matrix(nrl,nrh,ncl,nch)
long int nrl,nrh,ncl,nch;
{
	int i, fail, *tmp;
	long int **m;

	fail=0;
	i = (nrh-nrl+1)*sizeof(int *);
	tmp = (int *) malloc(i);
	if (tmp==NULL) return(NULL);
	tmp -= nrl;
	m = (long int **) tmp;

	for(i=nrl;i<=nrh;i++) {
		m[i]=(long int *)malloc((size_t)(nch-ncl+1)*sizeof(long int));
		if (m[i]==NULL) return(NULL);
		m[i] -= ncl;
	}
	return(m);
}


FILE  *tempfile(char *rootname)
/*
   Takes the root name to which will be added 6 characters.
   Returns file pointer to new file. Array containing name
   Must be at least 6 characters longer than the name.
*/
{
	FILE	*fptr;
	char	tmp[256];

	sprintf(tmp,"%sXXXXXX",rootname);
	strcpy(rootname,tmp);
	if(!mktemp(rootname)) return(NULL);
	fptr = fopen(rootname,"w+");
	return(fptr);
}

int file_list(char *search, char **names) /* returns the number of files */
{
	FILE	*fptr;
	char	name[80], *foo;
	int	i;
	
        sprintf(name,"ls %s 2>> /dev/null",search);
        if((fptr = popen(name,"r"))==NULL) return(-1);
        i=-1;
        while(fgets(name,80,fptr)!=NULL && i < 255){
	  if(!strstr(name,"No match")){
            i++;
            foo = (char *)malloc(strlen(name) * sizeof(char) +1);
            foo[0] = 0;
            strncat(foo,name,strlen(name)-1);
            names[i] = foo;
	  }
        }
        pclose(fptr);
	return(i+1);
}

/* Routine to open a file in $PGPPATH */

FILE *open_mix_file (char *s,char *attr)
{
        return  fopen (s, attr);
}

/* returns 0 if mode is locked */
/* returns 1 if file is not locked, and creates lock file */
int	mix_lock(char *name, FILE **fptr)
{
	char	buff[128];
	int	status;
	struct flock	lockstruct;

	strcpy(buff,"lock.");
	strcat(buff,name);
	if((*fptr = fopen(buff,"r+"))==NULL) { /* file exists */
	  if((*fptr = fopen(buff,"w"))==NULL) { /* create file */
	    fprintf(stderr,"Error, could not create %s\n",buff);
	    return(0); /* if cant create lock, treat as locked */
          }
	}
	lockstruct.l_type	= F_WRLCK;
	lockstruct.l_whence	= 0;
	lockstruct.l_start	= 0;
	lockstruct.l_len	= 0;
	status = fcntl(fileno(*fptr),F_SETLKW,&lockstruct);
	if(status == -1) return(0);
	return(1);
}

void	mix_unlock(char *name, FILE *fptr)
{
	char	buff[128];
	struct flock	lockstruct;

	strcpy(buff,"lock.");
	strcat(buff,name);
	if(fptr!=NULL) {
	  lockstruct.l_type	= F_UNLCK;
	  lockstruct.l_whence	= 0;
	  lockstruct.l_start	= 0;
	  lockstruct.l_len	= 0;
	  fcntl(fileno(fptr),F_SETLKW,&lockstruct);
	  fclose(fptr);
	}
}


int safe_tolower(c)
     int c;
{
  if (isupper(c))
    return tolower(c);
  else
    return c;
}

/*
 * SafeToLowerStr
 *
 * Safely (in the safe_tolower sense) convert a string to all lowercase
 *
 * Assumes that its argument actually points to a null-terminated string
 */
void SafeToLowerStr(string)
char *string;
{
  while (*string)
    *string++ = safe_tolower(*string);
}


int destination_block(numdest, destination)
byte	numdest;
char	*destination[];
{
	FILE	*block;
	char	lowdest[256],buff[256];
	int	i,j;

        /* handle blocked destinations */
        if((block = open_mix_file("destination.block","r"))!=NULL){
          for(i=0;i<numdest;i++) {
             strcpy(lowdest, destination[i]);
             for(j=0; j< strlen(lowdest); j++) {
                lowdest[j] = safe_tolower(lowdest[j]);
             } /* lower case */
             while(fgets(buff,255,block)!=NULL) {
               buff[strlen(buff)-1] = 0;
               if(strlen(buff) < 2) continue; /* skip blank lines */
               for(j=0; j< strlen(buff); j++) {
                  buff[j] = safe_tolower(buff[j]);
               } /* lower case */
               if(strstr(lowdest,buff)) {
                 fprintf(stderr,"Blocked destination %s\n",lowdest);
                 fclose(block);
                 strcpy(destination[i],"");
               } /* if blocked */
             } /* while not at end of blocked list */
             rewind(block);
           } /* for numdest */

          for(i=0;i<numdest;i++) {
            if(strlen(destination[i])>1) return(0);
          }
          return(1); /* all addresses blocked */
	} /* if could not open blocked list */

	fprintf(stderr,"Could not open blocked list\n");
	return(0); /* no blocked list available */
}

