; --------------------------------------------------------------------------
; NOISE.SYS Multiplex services and API/IOCTL routines

; Note: the interrupt hooks used by NOISE.SYS do not conform to the AMIS
;       standard described in Ralf Brown's Interrupt List (no.48).  This
;       may or may not change in future versions of the driver.

; ----- A short handler that watches Int 2F for various things...
@MultiPrev      LABEL   DWORD
                DD      ?
_MultiplexServ  PROC    FAR
; Normally we'd call the original handler first, but in this case it
; interferes with values passed to and from orig. handler, so we check
; values passed first then jump.
                pushf
                cmp     ah, 16h                 ; Win broadcasts?
                jne     SHORT @QuitMServ
  if __samplwinbc
                test    cs:[Flags], WindowsFlag ; are we in Windows
                jz      SHORT @MultNWin         ; if not, don't sample
                pushad                          ; save registers
                push    ds cs                   ; set ds = cs
                pop     ds
                call    Sample
                pop     ds                      ; restore regs
                popad
  @MultNWin:
  endif
                cmp     al, 8                   ; Check for init/close msgs
                jb      SHORT @QuitMServ
                cmp     al, 9
                ja      SHORT @QuitMServ
                xor     BYTE PTR cs:[Flags], WindowsFlag ; toggle flag
  @QuitMServ:
                popf
                jmp     DWORD PTR cs:[@MultiPrev]
_MultiplexServ  ENDP

