
#  Data for encryption algorithms is saved as (key, plaintext,
# ciphertext) tuples.  Hashing algorithm test data is simply
# (text, hashvalue) pairs.

# MD2 validation data

md2= [
     ("", 0x8350e5a3e24c153df2275c9f80692773L),
     ("a", 0x32ec01ec4a6dac72c0ab96fb34c0b5d1L),
     ("abc", 0xda853b0d3f88d99b30283a69e6ded6bbL),
     ("message digest", 0xab4f496bfb2a530b219ff33031fe06b0L),
     ("abcdefghijklmnopqrstuvwxyz", 0x4e8ddff3650292ab5a4108c3aa47940bL),
     ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",
      0xda33def2a42df13975352846c30338cdL),
     ("12345678901234567890123456789012345678901234567890123456789012345678901234567890",
      0xd5976f79d83d3a0dc9806c3c66f3efd8L)
     ]

# MD4 validation data

md4= [
      ('', 0x31d6cfe0d16ae931b73c59d7e0c089c0L),
      ("a",   0xbde52cb31de33e46245e05fbdbd6fb24L),
      ("abc",   0xa448017aaf21d8525fc10ae87aa6729dL),
      ("message digest",   0xd9130a8164549fe818874806e1c7014bL),
      ("abcdefghijklmnopqrstuvwxyz",   0xd79e1c308aa5bbcdeea8ed63df412da9L),
      ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",
       0x043f8582f241db351ce627e153e7f0e4L), 
      ("12345678901234567890123456789012345678901234567890123456789012345678901234567890",
      0xe33b4ddc9c38f2199c3e7b164fcc0536L),
     ]

# MD5 validation data

md5= [
    ('',  0xd41d8cd98f00b204e9800998ecf8427eL),
    ('a', 0x0cc175b9c0f1b6a831c399e269772661L),
    ('abc', 0x900150983cd24fb0d6963f7d28e17f72L),
    ('message digest', 0xf96b697d7cb7938d525a2f31aaf161d0L),
    ('abcdefghijklmnopqrstuvwxyz', 0xc3fcd3d76192e4007dfb496cca67e13bL),
    ('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789',
	       0xd174ab98d277d9f5a5611c2c9f419d9fL),
    ('12345678901234567890123456789012345678901234567890123456789'
     '012345678901234567890', 0x57edf4a22be3c955ac49da2e2107b67aL)
     ]

# Test data for SHA, the Secure Hash Algorithm.

sha = [
       ('abc', 0xA9993E364706816ABA3E25717850C26C9CD0D89DL),
       ('abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq',
        0x84983E441C3BD26EBAAE4AA1F95129E5E54670F1L)
      ]

# DES validation data

des = [ ('0000000000000000', '0000000000000000', '8CA64DE9C1B123A7'),
    ('FFFFFFFFFFFFFFFF', 'FFFFFFFFFFFFFFFF', '7359B2163E4EDC58'),
    ('3000000000000000', '1000000000000001', '958E6E627A05557B'),
    ('1111111111111111', '1111111111111111', 'F40379AB9E0EC533'),
    ('0123456789ABCDEF', '1111111111111111', '17668DFC7292532D'),
    ('1111111111111111', '0123456789ABCDEF', '8A5AE1F81AB8F2DD'),
    ('0000000000000000', '0000000000000000', '8CA64DE9C1B123A7'),
    ('FEDCBA9876543210', '0123456789ABCDEF', 'ED39D950FA74BCC4'),
    ('7CA110454A1A6E57', '01A1D6D039776742', '690F5B0D9A26939B'),
    ('0131D9619DC1376E', '5CD54CA83DEF57DA', '7A389D10354BD271'),
    ('07A1133E4A0B2686', '0248D43806F67172', '868EBB51CAB4599A'),
    ('3849674C2602319E', '51454B582DDF440A', '7178876E01F19B2A'),
    ('04B915BA43FEB5B6', '42FD443059577FA2', 'AF37FB421F8C4095'),
    ('0113B970FD34F2CE', '059B5E0851CF143A', '86A560F10EC6D85B'),
    ('0170F175468FB5E6', '0756D8E0774761D2', '0CD3DA020021DC09'),
    ('43297FAD38E373FE', '762514B829BF486A', 'EA676B2CB7DB2B7A'),
    ('07A7137045DA2A16', '3BDD119049372802', 'DFD64A815CAF1A0F'),
    ('04689104C2FD3B2F', '26955F6835AF609A', '5C513C9C4886C088'),
    ('37D06BB516CB7546', '164D5E404F275232', '0A2AEEAE3FF4AB77'),
    ('1F08260D1AC2465E', '6B056E18759F5CCA', 'EF1BF03E5DFA575A'),
    ('584023641ABA6176', '004BD6EF09176062', '88BF0DB6D70DEE56'),
    ('025816164629B007', '480D39006EE762F2', 'A1F9915541020B56'),
    ('49793EBC79B3258F', '437540C8698F3CFA', '6FBF1CAFCFFD0556'),
    ('4FB05E1515AB73A7', '072D43A077075292', '2F22E49BAB7CA1AC'),
    ('49E95D6D4CA229BF', '02FE55778117F12A', '5A6B612CC26CCE4A'),
    ('018310DC409B26D6', '1D9D5C5018F728C2', '5F4C038ED12B2E41'),
    ('1C587F1C13924FEF', '305532286D6F295A', '63FAC0D034D9F793'),
    ('0101010101010101', '0123456789ABCDEF', '617B3A0CE8F07100'),
    ('1F1F1F1F0E0E0E0E', '0123456789ABCDEF', 'DB958605F8C8C606'),
    ('E0FEE0FEF1FEF1FE', '0123456789ABCDEF', 'EDBFD1C66C29CCC7'),
    ('0000000000000000', 'FFFFFFFFFFFFFFFF', '355550B2150E2451'),
    ('FFFFFFFFFFFFFFFF', '0000000000000000', 'CAAAAF4DEAF1DBAE'),
    ('0123456789ABCDEF', '0000000000000000', 'D5D44FF720683D0D'),
    ('FEDCBA9876543210', 'FFFFFFFFFFFFFFFF', '2A2BB008DF97C2F2'),
    ('0101010101010101', '95F8A5E5DD31D900', '8000000000000000'),
    ('0101010101010101', 'DD7F121CA5015619', '4000000000000000'),
    ('0101010101010101', '2E8653104F3834EA', '2000000000000000'),
    ('0101010101010101', '4BD388FF6CD81D4F', '1000000000000000'),
    ('0101010101010101', '20B9E767B2FB1456', '0800000000000000'),
    ('0101010101010101', '55579380D77138EF', '0400000000000000'),
    ('0101010101010101', '6CC5DEFAAF04512F', '0200000000000000'), 
    ('0101010101010101', '0D9F279BA5D87260', '0100000000000000'),
    ('0101010101010101', 'D9031B0271BD5A0A', '0080000000000000'),
    ('0101010101010101', '424250B37C3DD951', '0040000000000000'),
    ('0101010101010101', 'B8061B7ECD9A21E5', '0020000000000000'),
    ('0101010101010101', 'F15D0F286B65BD28', '0010000000000000'),
    ('0101010101010101', 'ADD0CC8D6E5DEBA1', '0008000000000000'),
    ('0101010101010101', 'E6D5F82752AD63D1', '0004000000000000'),
    ('0101010101010101', 'ECBFE3BD3F591A5E', '0002000000000000'),
    ('0101010101010101', 'F356834379D165CD', '0001000000000000'),
    ('0101010101010101', '2B9F982F20037FA9', '0000800000000000'),
    ('0101010101010101', '889DE068A16F0BE6', '0000400000000000'),
    ('0101010101010101', 'E19E275D846A1298', '0000200000000000'),
    ('0101010101010101', '329A8ED523D71AEC', '0000100000000000'),
    ('0101010101010101', 'E7FCE22557D23C97', '0000080000000000'),
    ('0101010101010101', '12A9F5817FF2D65D', '0000040000000000'),
    ('0101010101010101', 'A484C3AD38DC9C19', '0000020000000000'),
    ('0101010101010101', 'FBE00A8A1EF8AD72', '0000010000000000'),
    ('0101010101010101', '750D079407521363', '0000008000000000'),
    ('0101010101010101', '64FEED9C724C2FAF', '0000004000000000'),
    ('0101010101010101', 'F02B263B328E2B60', '0000002000000000'),
    ('0101010101010101', '9D64555A9A10B852', '0000001000000000'),
    ('0101010101010101', 'D106FF0BED5255D7', '0000000800000000'),
    ('0101010101010101', 'E1652C6B138C64A5', '0000000400000000'),
    ('0101010101010101', 'E428581186EC8F46', '0000000200000000'),
    ('0101010101010101', 'AEB5F5EDE22D1A36', '0000000100000000'),
    ('0101010101010101', 'E943D7568AEC0C5C', '0000000080000000'),
    ('0101010101010101', 'DF98C8276F54B04B', '0000000040000000'),
    ('0101010101010101', 'B160E4680F6C696F', '0000000020000000'),
    ('0101010101010101', 'FA0752B07D9C4AB8', '0000000010000000'),
    ('0101010101010101', 'CA3A2B036DBC8502', '0000000008000000'),
    ('0101010101010101', '5E0905517BB59BCF', '0000000004000000'),
    ('0101010101010101', '814EEB3B91D90726', '0000000002000000'),
    ('0101010101010101', '4D49DB1532919C9F', '0000000001000000'),
    ('0101010101010101', '25EB5FC3F8CF0621', '0000000000800000'),
    ('0101010101010101', 'AB6A20C0620D1C6F', '0000000000400000'),
    ('0101010101010101', '79E90DBC98F92CCA', '0000000000200000'),
    ('0101010101010101', '866ECEDD8072BB0E', '0000000000100000'),
    ('0101010101010101', '8B54536F2F3E64A8', '0000000000080000'),
    ('0101010101010101', 'EA51D3975595B86B', '0000000000040000'),
    ('0101010101010101', 'CAFFC6AC4542DE31', '0000000000020000'),
    ('0101010101010101', '8DD45A2DDF90796C', '0000000000010000'),
    ('0101010101010101', '1029D55E880EC2D0', '0000000000008000'),
    ('0101010101010101', '5D86CB23639DBEA9', '0000000000004000'),
    ('0101010101010101', '1D1CA853AE7C0C5F', '0000000000002000'),
    ('0101010101010101', 'CE332329248F3228', '0000000000001000'),
    ('0101010101010101', '8405D1ABE24FB942', '0000000000000800'),
    ('0101010101010101', 'E643D78090CA4207', '0000000000000400'),
    ('0101010101010101', '48221B9937748A23', '0000000000000200'),
    ('0101010101010101', 'DD7C0BBD61FAFD54', '0000000000000100'),
    ('0101010101010101', '2FBC291A570DB5C4', '0000000000000080'),
    ('0101010101010101', 'E07C30D7E4E26E12', '0000000000000040'),
    ('0101010101010101', '0953E2258E8E90A1', '0000000000000020'),
    ('0101010101010101', '5B711BC4CEEBF2EE', '0000000000000010'),
    ('0101010101010101', 'CC083F1E6D9E85F6', '0000000000000008'),
    ('0101010101010101', 'D2FD8867D50D2DFE', '0000000000000004'),
    ('0101010101010101', '06E7EA22CE92708F', '0000000000000002'),
    ('0101010101010101', '166B40B44ABA4BD6', '0000000000000001'),
    ('8001010101010101', '0000000000000000', '95A8D72813DAA94D'),
    ('4001010101010101', '0000000000000000', '0EEC1487DD8C26D5'),
    ('2001010101010101', '0000000000000000', '7AD16FFB79C45926'),
    ('1001010101010101', '0000000000000000', 'D3746294CA6A6CF3'),
    ('0801010101010101', '0000000000000000', '809F5F873C1FD761'),
    ('0401010101010101', '0000000000000000', 'C02FAFFEC989D1FC'),
    ('0201010101010101', '0000000000000000', '4615AA1D33E72F10'),
    ('0180010101010101', '0000000000000000', '2055123350C00858'),
    ('0140010101010101', '0000000000000000', 'DF3B99D6577397C8'),
    ('0120010101010101', '0000000000000000', '31FE17369B5288C9'),
    ('0110010101010101', '0000000000000000', 'DFDD3CC64DAE1642'),
    ('0108010101010101', '0000000000000000', '178C83CE2B399D94'),
    ('0104010101010101', '0000000000000000', '50F636324A9B7F80'),
    ('0102010101010101', '0000000000000000', 'A8468EE3BC18F06D'),
    ('0101800101010101', '0000000000000000', 'A2DC9E92FD3CDE92'),
    ('0101400101010101', '0000000000000000', 'CAC09F797D031287'),
    ('0101200101010101', '0000000000000000', '90BA680B22AEB525'),
    ('0101100101010101', '0000000000000000', 'CE7A24F350E280B6'),
    ('0101080101010101', '0000000000000000', '882BFF0AA01A0B87'),
    ('0101040101010101', '0000000000000000', '25610288924511C2'),
    ('0101020101010101', '0000000000000000', 'C71516C29C75D170'),
    ('0101018001010101', '0000000000000000', '5199C29A52C9F059'),
    ('0101014001010101', '0000000000000000', 'C22F0A294A71F29F'),
    ('0101012001010101', '0000000000000000', 'EE371483714C02EA'),
    ('0101011001010101', '0000000000000000', 'A81FBD448F9E522F'),
    ('0101010801010101', '0000000000000000', '4F644C92E192DFED'),
    ('0101010401010101', '0000000000000000', '1AFA9A66A6DF92AE'),
    ('0101010201010101', '0000000000000000', 'B3C1CC715CB879D8'),
    ('0101010180010101', '0000000000000000', '19D032E64AB0BD8B'),
    ('0101010140010101', '0000000000000000', '3CFAA7A7DC8720DC'),
    ('0101010120010101', '0000000000000000', 'B7265F7F447AC6F3'),
    ('0101010110010101', '0000000000000000', '9DB73B3C0D163F54'),
    ('0101010108010101', '0000000000000000', '8181B65BABF4A975'),
    ('0101010104010101', '0000000000000000', '93C9B64042EAA240'),
    ('0101010102010101', '0000000000000000', '5570530829705592'),
    ('0101010101800101', '0000000000000000', '8638809E878787A0'),
    ('0101010101400101', '0000000000000000', '41B9A79AF79AC208'),
    ('0101010101200101', '0000000000000000', '7A9BE42F2009A892'),
    ('0101010101100101', '0000000000000000', '29038D56BA6D2745'),
    ('0101010101080101', '0000000000000000', '5495C6ABF1E5DF51'),
    ('0101010101040101', '0000000000000000', 'AE13DBD561488933'),
    ('0101010101020101', '0000000000000000', '024D1FFA8904E389'),
    ('0101010101018001', '0000000000000000', 'D1399712F99BF02E'),
    ('0101010101014001', '0000000000000000', '14C1D7C1CFFEC79E'),
    ('0101010101012001', '0000000000000000', '1DE5279DAE3BED6F'),
    ('0101010101011001', '0000000000000000', 'E941A33F85501303'),
    ('0101010101010801', '0000000000000000', 'DA99DBBC9A03F379'),
    ('0101010101010401', '0000000000000000', 'B7FC92F91D8E92E9'),
    ('0101010101010201', '0000000000000000', 'AE8E5CAA3CA04E85'),
    ('0101010101010180', '0000000000000000', '9CC62DF43B6EED74'),
    ('0101010101010140', '0000000000000000', 'D863DBB5C59A91A0'),
    ('0101010101010120', '0000000000000000', 'A1AB2190545B91D7'),
    ('0101010101010110', '0000000000000000', '0875041E64C570F7'),
    ('0101010101010108', '0000000000000000', '5A594528BEBEF1CC'),
    ('0101010101010104', '0000000000000000', 'FCDB3291DE21F0C0'),
    ('0101010101010102', '0000000000000000', '869EFD7F9F265A09'),
    ('1046913489980131', '0000000000000000', '88D55E54F54C97B4'),
    ('1007103489988020', '0000000000000000', '0C0CC00C83EA48FD'),
    ('10071034C8980120', '0000000000000000', '83BC8EF3A6570183'),
    ('1046103489988020', '0000000000000000', 'DF725DCAD94EA2E9'),
    ('1086911519190101', '0000000000000000', 'E652B53B550BE8B0'),
    ('1086911519580101', '0000000000000000', 'AF527120C485CBB0'),
    ('5107B01519580101', '0000000000000000', '0F04CE393DB926D5'),
    ('1007B01519190101', '0000000000000000', 'C9F00FFC74079067'),
    ('3107915498080101', '0000000000000000', '7CFD82A593252B4E'),
    ('3107919498080101', '0000000000000000', 'CB49A2F9E91363E3'),
    ('10079115B9080140', '0000000000000000', '00B588BE70D23F56'),
    ('3107911598080140', '0000000000000000', '406A9A6AB43399AE'),
    ('1007D01589980101', '0000000000000000', '6CB773611DCA9ADA'),
    ('9107911589980101', '0000000000000000', '67FD21C17DBB5D70'),
    ('9107D01589190101', '0000000000000000', '9592CB4110430787'),
    ('1007D01598980120', '0000000000000000', 'A6B7FF68A318DDD3'),
    ('1007940498190101', '0000000000000000', '4D102196C914CA16'),
    ('0107910491190401', '0000000000000000', '2DFA9F4573594965'),
    ('0107910491190101', '0000000000000000', 'B46604816C0E0774'),
    ('0107940491190401', '0000000000000000', '6E7E6221A4F34E87'),
    ('19079210981A0101', '0000000000000000', 'AA85E74643233199'),
    ('1007911998190801', '0000000000000000', '2E5A19DB4D1962D6'),
    ('10079119981A0801', '0000000000000000', '23A866A809D30894'),
    ('1007921098190101', '0000000000000000', 'D812D961F017D320'),
    ('100791159819010B', '0000000000000000', '055605816E58608F'),
    ('1004801598190101', '0000000000000000', 'ABD88E8B1B7716F1'),
    ('1004801598190102', '0000000000000000', '537AC95BE69DA1E1'),
    ('1004801598190108', '0000000000000000', 'AED0F6AE3C25CDD8'),
    ('1002911598100104', '0000000000000000', 'B3E35A5EE53E7B8D'),
    ('1002911598190104', '0000000000000000', '61C79C71921A2EF8'),
    ('1002911598100201', '0000000000000000', 'E2F5728F0995013C'),
    ('1002911698100101', '0000000000000000', '1AEAC39A61F0A464'),
    ('7CA110454A1A6E57', '01A1D6D039776742', '690F5B0D9A26939B'),
    ('0131D9619DC1376E', '5CD54CA83DEF57DA', '7A389D10354BD271'),
    ('07A1133E4A0B2686', '0248D43806F67172', '868EBB51CAB4599A'),
    ('3849674C2602319E', '51454B582DDF440A', '7178876E01F19B2A'),
    ('04B915BA43FEB5B6', '42FD443059577FA2', 'AF37FB421F8C4095'),
    ('0113B970FD34F2CE', '059B5E0851CF143A', '86A560F10EC6D85B'),
    ('0170F175468FB5E6', '0756D8E0774761D2', '0CD3DA020021DC09'),
    ('43297FAD38E373FE', '762514B829BF486A', 'EA676B2CB7DB2B7A'),
    ('07A7137045DA2A16', '3BDD119049372802', 'DFD64A815CAF1A0F'),
    ('04689104C2FD3B2F', '26955F6835AF609A', '5C513C9C4886C088'),
    ('37D06BB516CB7546', '164D5E404F275232', '0A2AEEAE3FF4AB77'),
    ('1F08260D1AC2465E', '6B056E18759F5CCA', 'EF1BF03E5DFA575A'),
    ('584023641ABA6176', '004BD6EF09176062', '88BF0DB6D70DEE56'),
    ('025816164629B007', '480D39006EE762F2', 'A1F9915541020B56'),
    ('49793EBC79B3258F', '437540C8698F3CFA', '6FBF1CAFCFFD0556'),
    ('4FB05E1515AB73A7', '072D43A077075292', '2F22E49BAB7CA1AC'),
    ('49E95D6D4CA229BF', '02FE55778117F12A', '5A6B612CC26CCE4A'),
    ('018310DC409B26D6', '1D9D5C5018F728C2', '5F4C038ED12B2E41'),
    ('1C587F1C13924FEF', '305532286D6F295A', '63FAC0D034D9F793') ]


#       LOKI91 Validation Data Suite 
loki91 = [
# List of weak and semi-weak keys
#
#  Weak Keys
#
('0000000000000000', '0000000000000000', 'bd84a2085ef609c7'),
('0000000000000000', 'bd84a2085ef609c7', '0000000000000000'),
('ffffffffffffffff', '0000000000000000', '5c77e002d1991c4d'),
('ffffffffffffffff', '5c77e002d1991c4d', '0000000000000000'),
('55555555aaaaaaaa', '0000000000000000', '71fd6dc44bf4e881'),
('55555555aaaaaaaa', '71fd6dc44bf4e881', '0000000000000000'),
('aaaaaaaa55555555', '0000000000000000', '65b38fdc551b2576'),
('aaaaaaaa55555555', '65b38fdc551b2576', '0000000000000000'),
#
# Semi-Weak Keys
#
('0000000055555555', '0000000000000000', '85d84cad08342044'),
('0000000055555555', '8621ccb894705f8f', '0000000000000000'),
('aaaaaaaa00000000', '0000000000000000', '8621ccb894705f8f'),
('aaaaaaaa00000000', '85d84cad08342044', '0000000000000000'),
#
('00000000aaaaaaaa', '0000000000000000', '971fe23b8904399b'),
('00000000aaaaaaaa', 'e10c4efc9d4c9b52', '0000000000000000'),
('5555555500000000', '0000000000000000', 'e10c4efc9d4c9b52'),
('5555555500000000', '971fe23b8904399b', '0000000000000000'),
#
('00000000ffffffff', '0000000000000000', 'ca30a526e3bf6fe9'),
('00000000ffffffff', '9cc24ace4d477f39', '0000000000000000'),
('ffffffff00000000', '0000000000000000', '9cc24ace4d477f39'),
('ffffffff00000000', 'ca30a526e3bf6fe9', '0000000000000000'),
#
('5555555555555555', '0000000000000000', 'bc85de5e486d7ddb'),
('5555555555555555', '504d4c4fea439b63', '0000000000000000'),
('aaaaaaaaaaaaaaaa', '0000000000000000', '504d4c4fea439b63'),
('aaaaaaaaaaaaaaaa', 'bc85de5e486d7ddb', '0000000000000000'),
#
('55555555ffffffff', '0000000000000000', '0bef28021cd23fcb'),
('55555555ffffffff', 'baa5521bd8ff9f75', '0000000000000000'),
('ffffffffaaaaaaaa', '0000000000000000', 'baa5521bd8ff9f75'),
('ffffffffaaaaaaaa', '0bef28021cd23fcb', '0000000000000000'),
#
('aaaaaaaaffffffff', '0000000000000000', 'a78c6f84509c4d9a'),
('aaaaaaaaffffffff', '05dac4a04d83c0ab', '0000000000000000'),
('ffffffff55555555', '0000000000000000', '05dac4a04d83c0ab'),
('ffffffff55555555', 'a78c6f84509c4d9a', '0000000000000000'),
#
# Inversion of all the key and plaintext bits results
#  in the inversion of all the ciphertext bits
#
('0123456789abcdef', '0000000000000000', 'd26de3321aaa29f6'),
('0123456789abcdef', 'fcf597b7da5a3a3d', '0000000000000000'),
('fedcba9876543210', 'ffffffffffffffff', '2d921ccde555d609'),
('fedcba9876543210', '030a684825a5c5c2', 'ffffffffffffffff'),
#
# Other assorted values
#
('0000000000000000', '0000000000000000', 'bd84a2085ef609c7'),
('0000000000000000', 'bd84a2085ef609c7', '0000000000000000'),
('0000000000000000', '355550b2150e2451', '3644dd20d5ba5d10'),
('0000000000000000', '3644dd20d5ba5d10', '355550b2150e2451'),
('0000000000000000', '35a7bae825c0d73b', '826ff28db7edf0a3'),
('0000000000000000', '826ff28db7edf0a3', '35a7bae825c0d73b'),
('0000000000000000', '8ca64de9c1b123a7', 'fb3038a35a93646b'),
('0000000000000000', 'fb3038a35a93646b', '8ca64de9c1b123a7'),
('0000000000000000', '8e2a251b94704c69', '4829a2faf34973e8'),
('0000000000000000', '4829a2faf34973e8', '8e2a251b94704c69'),
('0000000000000000', 'ffffffffffffffff', 'a3881ffd2e66e3b2'),
('0000000000000000', 'a3881ffd2e66e3b2', 'ffffffffffffffff'),
('0101010101010101', '0123456789abcdef', '7935b683eada00f4'),
('0101010101010101', 'ec5960c9d3bf1e1e', '0123456789abcdef'),
('0101010101010101', '617b3a0ce8f07100', 'a6090c5f651d84ff'),
('0101010101010101', '8eeb7798a291b0b3', '617b3a0ce8f07100'),
('0101010101010101', '9b38f6ce85aab9c3', '2165fc9b5a4430d4'),
('0101010101010101', '2143badadbd4f539', '9b38f6ce85aab9c3'),
('0113b970fd34f2ce', '059b5e0851cf143a', 'f1f6daa4368d32c0'),
('0113b970fd34f2ce', '313b8c589bcf2955', '059b5e0851cf143a'),
('0113b970fd34f2ce', '7514cdb961b6760d', 'a2f3f0e425f6cd30'),
('0113b970fd34f2ce', '31b8050defd959ce', '7514cdb961b6760d'),
('0113b970fd34f2ce', '86a560f10ec6d85b', 'a27506525cf66e5c'),
('0113b970fd34f2ce', '6566f294daf82c26', '86a560f10ec6d85b'),
('0123456789abcdef', '0000000000000000', 'd26de3321aaa29f6'),
('0123456789abcdef', 'fcf597b7da5a3a3d', '0000000000000000'),
('0123456789abcdef', '1111111111111111', 'e1dd3b59134f32ab'),
('0123456789abcdef', 'c7c0ea4a6a9d3360', '1111111111111111'),
('0123456789abcdef', '17668dfc7292532d', '7aab3b9a42feceb2'),
('0123456789abcdef', '0a9462fa8fee7f4a', '17668dfc7292532d'),
('0123456789abcdef', '23c086665917b8e1', '9fbc1a193dcee02d'),
('0123456789abcdef', '1cb728f0c1b26f75', '23c086665917b8e1'),
('0123456789abcdef', 'd5d44ff720683d0d', '621f20a1884677f3'),
('0123456789abcdef', 'c8c9a1ace8cf89dc', 'd5d44ff720683d0d'),
('0123456789abcdef', 'fce30226576320bd', '5da683da7e9fd159'),
('0123456789abcdef', '5edf1c8466ce6cca', 'fce30226576320bd'),
('0131d9619dc1376e', '5cd54ca83def57da', '018781deb9ea97cc'),
('0131d9619dc1376e', 'bd1084a4b6d1ab38', '5cd54ca83def57da'),
('0131d9619dc1376e', '65e160aed7b773a9', '57e3c651e72c6d99'),
('0131d9619dc1376e', 'aeab88168e9c0e3e', '65e160aed7b773a9'),
('0131d9619dc1376e', '7a389d10354bd271', '5520951007ac3123'),
('0131d9619dc1376e', '78eaddbfcb1ca8f2', '7a389d10354bd271'),
('0170f175468fb5e6', '0756d8e0774761d2', 'ab786040f925d13e'),
('0170f175468fb5e6', 'b7c1284ca7043dcb', '0756d8e0774761d2'),
('0170f175468fb5e6', '0cd3da020021dc09', '77ce52c63517b689'),
('0170f175468fb5e6', '802191063dd8ff06', '0cd3da020021dc09'),
('0170f175468fb5e6', '914c1806fccbce33', 'dd546f5263780633'),
('0170f175468fb5e6', '5356fadab9832b2c', '914c1806fccbce33'),
('018310dc409b26d6', '1d9d5c5018f728c2', '80d1106e854f7296'),
('018310dc409b26d6', '0eb06d867b7034b3', '1d9d5c5018f728c2'),
('018310dc409b26d6', '5a0bf934fd6009f8', 'f67c664125809846'),
('018310dc409b26d6', '9c1edf390e47f09a', '5a0bf934fd6009f8'),
('018310dc409b26d6', '5f4c038ed12b2e41', '20a61c3bc186b0b2'),
('018310dc409b26d6', 'e93ae52452b20098', '5f4c038ed12b2e41'),
('025816164629b007', '480d39006ee762f2', '8197cc96e066f971'),
('025816164629b007', '8e67efe514fa5985', '480d39006ee762f2'),
('025816164629b007', 'a1f9915541020b56', '0e1b15aa45daad23'),
('025816164629b007', '7b1bd88c59347ee4', 'a1f9915541020b56'),
('025816164629b007', 'ec92e65da168b46f', 'fd5d36553cc7cdad'),
('025816164629b007', '10f09ce8ec84f207', 'ec92e65da168b46f'),
('04689104c2fd3b2f', '26955f6835af609a', '082133fd6bfa1e88'),
('04689104c2fd3b2f', '36153da8e8e4a67a', '26955f6835af609a'),
('04689104c2fd3b2f', '5265227fe08a28ec', '1b03084901b20c14'),
('04689104c2fd3b2f', 'f2e7e1a4678d10a7', '5265227fe08a28ec'),
('04689104c2fd3b2f', '5c513c9c4886c088', 'db8e496a8aa4eae8'),
('04689104c2fd3b2f', '49a2827db6293c72', '5c513c9c4886c088'),
('04b915ba43feb5b6', '42fd443059577fa2', 'b794c8fec41d93fd'),
('04b915ba43feb5b6', '688762c5782c8d46', '42fd443059577fa2'),
('04b915ba43feb5b6', 'a483ea7ccf2e0e5a', '1319804d5e6477fb'),
('04b915ba43feb5b6', 'a4407673e0289704', 'a483ea7ccf2e0e5a'),
('04b915ba43feb5b6', 'af37fb421f8c4095', '5e1fbeca6d3dd240'),
('04b915ba43feb5b6', '76f8a9d3d646b45a', 'af37fb421f8c4095'),
('07a1133e4a0b2686', '0248d43806f67172', 'bdc50f07265f98bb'),
('07a1133e4a0b2686', '5352ea74d4f98d17', '0248d43806f67172'),
('07a1133e4a0b2686', '624f2e2dfa008142', '43966fba71697d9e'),
('07a1133e4a0b2686', '94e8f64562868d44', '624f2e2dfa008142'),
('07a1133e4a0b2686', '868ebb51cab4599a', '2bc4d7ac9f09e2cf'),
('07a1133e4a0b2686', '38df7d98c5841cb1', '868ebb51cab4599a'),
('07a7137045da2a16', '28e686668c3bd6d9', '5ddb3c7fc1c8ce22'),
('07a7137045da2a16', 'a725d943d567693c', '28e686668c3bd6d9'),
('07a7137045da2a16', '3bdd119049372802', '3f0db5539d36d6ff'),
('07a7137045da2a16', 'e617587ef5ec4992', '3bdd119049372802'),
('07a7137045da2a16', 'dfd64a815caf1a0f', 'a4af3b0773dad9be'),
('07a7137045da2a16', '3000a06acca1e95c', 'dfd64a815caf1a0f'),
('1111111111111111', '0123456789abcdef', '75f0c8bc2bafd309'),
('1111111111111111', '46b19d48d8569e55', '0123456789abcdef'),
('1111111111111111', '1111111111111111', 'cc8a79bccae0bb7e'),
('1111111111111111', 'd96e387165e701bc', '1111111111111111'),
('1111111111111111', '24900548c21a3567', '93f5dbd7f154b9ba'),
('1111111111111111', '66b41b7d36c436de', '24900548c21a3567'),
('1111111111111111', '8a5ae1f81ab8f2dd', '20f677bebabe1775'),
('1111111111111111', 'd96faf34f9f90454', '8a5ae1f81ab8f2dd'),
('1111111111111111', 'a273d7cb7d390531', '70ab8b1bc85a3535'),
('1111111111111111', '44260ee8c8eeb426', 'a273d7cb7d390531'),
('1111111111111111', 'f40379ab9e0ec533', '06f8080ae1393c2f'),
('1111111111111111', '9ae34de86300215f', 'f40379ab9e0ec533'),
('1c587f1c13924fef', '305532286d6f295a', '2fc181b0cb6b30b7'),
('1c587f1c13924fef', 'e9eef1eb68e8c676', '305532286d6f295a'),
('1c587f1c13924fef', '63fac0d034d9f793', 'e3f0d7afe60812b2'),
('1c587f1c13924fef', '7409d13ab01f25f6', '63fac0d034d9f793'),
('1c587f1c13924fef', 'f63de067f58c38ed', '3f4913280d2793fc'),
('1c587f1c13924fef', '0109eccd8a9c40dd', 'f63de067f58c38ed'),
('1f08260d1ac2465e', '2c0a241eb9f05999', 'e86f92ac2ec186f3'),
('1f08260d1ac2465e', '2dbafaaf1eb7b072', '2c0a241eb9f05999'),
('1f08260d1ac2465e', '6b056e18759f5cca', '02dd8970249255f1'),
('1f08260d1ac2465e', '377f235592b45ca9', '6b056e18759f5cca'),
('1f08260d1ac2465e', 'ef1bf03e5dfa575a', '98e1e5771c4a9455'),
('1f08260d1ac2465e', 'f489970bb6e8a94e', 'ef1bf03e5dfa575a'),
('1f1f1f1f0e0e0e0e', '0123456789abcdef', '1998d96b0bb0add6'),
('1f1f1f1f0e0e0e0e', '7454d8d7c56be016', '0123456789abcdef'),
('1f1f1f1f0e0e0e0e', '322f206b2d39d65d', '0b636eb981e987c0'),
('1f1f1f1f0e0e0e0e', '0b926c6049361bff', '322f206b2d39d65d'),
('1f1f1f1f0e0e0e0e', 'db958605f8c8c606', '5a153aea62bdd0cb'),
('1f1f1f1f0e0e0e0e', '2c7bf241aa0b2c97', 'db958605f8c8c606'),
('3000000000000000', '1000000000000001', '12f2d0471de69a16'),
('3000000000000000', 'b0ef21ad8b82dd0a', '1000000000000001'),
('3000000000000000', '958e6e627a05557b', '4be1b16ef2c9524a'),
('3000000000000000', '437b3ac6a2a027c8', '958e6e627a05557b'),
('3000000000000000', 'd3c4539579b96231', 'bbfcaf9cc8cd9e46'),
('3000000000000000', '7b8b6b2e19e13c69', 'd3c4539579b96231'),
('37d06bb516cb7546', '0a2aeeae3ff4ab77', '32a65f25341d17f0'),
('37d06bb516cb7546', '90d6dcee0f2f8d62', '0a2aeeae3ff4ab77'),
('37d06bb516cb7546', '164d5e404f275232', '782a69ec6256c642'),
('37d06bb516cb7546', '1dabf24c62f0fd89', '164d5e404f275232'),
('37d06bb516cb7546', '19acae3136c0bc7c', '9cd87a6a8ea4c562'),
('37d06bb516cb7546', 'f8bf4d34438681a2', '19acae3136c0bc7c'),
('3849674c2602319e', '126898d55e911500', 'c86caec1e3b7b17e'),
('3849674c2602319e', 'd8d28161851ed6d6', '126898d55e911500'),
('3849674c2602319e', '51454b582ddf440a', '8904c12a608bac74'),
('3849674c2602319e', '562de7a88b1f4877', '51454b582ddf440a'),
('3849674c2602319e', '7178876e01f19b2a', 'ba940cd1789e92fd'),
('3849674c2602319e', '295ece9867b10e95', '7178876e01f19b2a'),
('43297fad38e373fe', '4c974f1caa59f5d4', '71a64728851d6e14'),
('43297fad38e373fe', 'f386803c5a434216', '4c974f1caa59f5d4'),
('43297fad38e373fe', '762514b829bf486a', '6684fb847e1283c0'),
('43297fad38e373fe', 'bf8e6fbf6c48ec44', '762514b829bf486a'),
('43297fad38e373fe', 'ea676b2cb7db2b7a', '5a2d250d39eb8fc1'),
('43297fad38e373fe', '6d42d3b3b5a9abcc', 'ea676b2cb7db2b7a'),
('49793ebc79b3258f', '437540c8698f3cfa', '0b46e6cd65118775'),
('49793ebc79b3258f', 'b9d425d544c1ce71', '437540c8698f3cfa'),
('49793ebc79b3258f', '6fbf1cafcffd0556', '50bfa6e233cef0af'),
('49793ebc79b3258f', '000c45276715001d', '6fbf1cafcffd0556'),
('49793ebc79b3258f', 'a0cb2871752053f0', 'af27090a887c7e3e'),
('49793ebc79b3258f', '51fc08afec3c8f1a', 'a0cb2871752053f0'),
('49e95d6d4ca229bf', '00b0024eaac70ae3', '6f2421dc83df9ba2'),
('49e95d6d4ca229bf', '82537ce99e3476de', '00b0024eaac70ae3'),
('49e95d6d4ca229bf', '02fe55778117f12a', 'bd6bb416626be321'),
('49e95d6d4ca229bf', '417b8cdd1c64b3e7', '02fe55778117f12a'),
('49e95d6d4ca229bf', '5a6b612cc26cce4a', '73cb63595026b590'),
('49e95d6d4ca229bf', 'a90f566d8f4e3e41', '5a6b612cc26cce4a'),
('4fb05e1515ab73a7', '072d43a077075292', 'ac6174b535bcad69'),
('4fb05e1515ab73a7', '2d139d3801a19346', '072d43a077075292'),
('4fb05e1515ab73a7', '2f22e49bab7ca1ac', '86019dd993c46cbe'),
('4fb05e1515ab73a7', '44fef33e6971a69b', '2f22e49bab7ca1ac'),
('4fb05e1515ab73a7', 'ad87789bc00718c2', '733b12f600953a98'),
('4fb05e1515ab73a7', '8341990d8ba44544', 'ad87789bc00718c2'),
('584023641aba6176', '004bd6ef09176062', '6ceca0e2d5351cd1'),
('584023641aba6176', '9c6aedffd92b1cca', '004bd6ef09176062'),
('584023641aba6176', '88bf0db6d70dee56', 'b3a4719eca678ecc'),
('584023641aba6176', 'bb39bb8bdf9db594', '88bf0db6d70dee56'),
('584023641aba6176', 'c7d2845ea6d01c70', '2932e00da18db422'),
('584023641aba6176', '2217a63228e547c1', 'c7d2845ea6d01c70'),
('5b5a57676a56676e', '974affbf86022d1f', '6b6413098aaa7f2b'),
('5b5a57676a56676e', 'daabfab98dea5e78', '974affbf86022d1f'),
('7ca110454a1a6e57', '01a1d6d039776742', '0200c0b643578183'),
('7ca110454a1a6e57', '1405433e91265b1b', '01a1d6d039776742'),
('7ca110454a1a6e57', '690f5b0d9a26939b', 'd6173b3a2f754508'),
('7ca110454a1a6e57', '9f7c523c7bfe7586', '690f5b0d9a26939b'),
('7ca110454a1a6e57', 'ecd1c2f929f33ced', 'a5d38784ef7973ee'),
('7ca110454a1a6e57', 'c6642999c37b99b3', 'ecd1c2f929f33ced'),
('e0fee0fef1fef1fe', '0123456789abcdef', 'e09ca157c6dfe236'),
('e0fee0fef1fef1fe', '20bc4d004e45c048', '0123456789abcdef'),
('e0fee0fef1fef1fe', 'b7687facf9b1a656', 'eb2c523be4dedd8a'),
('e0fee0fef1fef1fe', 'c21c42ef608f5ae6', 'b7687facf9b1a656'),
('e0fee0fef1fef1fe', 'edbfd1c66c29ccc7', 'd7a84a5234f98995'),
('e0fee0fef1fef1fe', 'cb3f0e23d4ad3760', 'edbfd1c66c29ccc7'),
('fedcba9876543210', '0123456789abcdef', '480f0eac8d4c6cbc'),
('fedcba9876543210', '25d00012f501adaf', '0123456789abcdef'),
('fedcba9876543210', '2a2bb008df97c2f2', '9de0df5e77b9880c'),
('fedcba9876543210', '37365e5317307623', '2a2bb008df97c2f2'),
('fedcba9876543210', '7f46aa73f7fcde02', 'f6b3c639d4588687'),
('fedcba9876543210', '286334c90fc54d99', '7f46aa73f7fcde02'),
('fedcba9876543210', 'c44c1b3668a0f2cf', 'f1fbe0db72af2072'),
('fedcba9876543210', '4da710ea766dddb4', 'c44c1b3668a0f2cf'),
('fedcba9876543210', 'ed39d950fa74bcc4', '1529a5409e492728'),
('fedcba9876543210', 'ba2fcbdf566d6b40', 'ed39d950fa74bcc4'),
('fedcba9876543210', 'ffffffffffffffff', '2d921ccde555d609'),
('fedcba9876543210', '030a684825a5c5c2', 'ffffffffffffffff'),
('ffffffffffffffff', '0000000000000000', '5c77e002d1991c4d'),
('ffffffffffffffff', '5c77e002d1991c4d', '0000000000000000'),
('ffffffffffffffff', '16b15028f06a5ab8', 'c594d15528f44560'),
('ffffffffffffffff', 'c594d15528f44560', '16b15028f06a5ab8'),
('ffffffffffffffff', '3c7188775253884d', 'ac490aef39a87b61'),
('ffffffffffffffff', 'ac490aef39a87b61', '3c7188775253884d'),
('ffffffffffffffff', '7359b2163e4edc58', '04cfc75ca56c9b94'),
('ffffffffffffffff', '04cfc75ca56c9b94', '7359b2163e4edc58'),
('ffffffffffffffff', 'caaaaf4deaf1dbae', 'c9bb22df2a45a2ef'),
('ffffffffffffffff', 'c9bb22df2a45a2ef', 'caaaaf4deaf1dbae'),
('ffffffffffffffff', 'ffffffffffffffff', '427b5df7a109f638'),
('ffffffffffffffff', '427b5df7a109f638', 'ffffffffffffffff') ]

# Test data for Alleged RC4

arc4 = [ ('0000000000000000', '0000000000000000', 'de188941a3375d3a'),
         ('0123456789abcdef', '0123456789abcdef', '75b7878099e0c596'),
         ('0123456789abcdef', '0000000000000000', '7494c2e7104b0879'),
         ('ef012345', '00000000000000000000', 'd6a141a7ec3c38dfbd61') ]

# Test data for Sapphire : Ciphertext of characters 0 through 255, with
# key "testSapphirekey"

sapphire = ('0cf45580c5b2490830e0f90d5cc5970316e63d52f8cef4b88bace'
            '96257aa39c3c5a9156c9cf2f3ee7fb9d659dd27928b8bc7fff555'
            '593b0b27fb65180c21e2b1f1a121ecd2654ff274d6c5b1ed35eef'
            'f89f64b7e7dd55cdd5ba1a7f1516453fc648aa7926e359eb1ad26'
            '341cb53074960d033887a7473724b743ef4f706c88c4f6ee17652'
            '6e0c869089dc71225337b6c773c308f5b174e668b27b2f7c75cb3'
            '169a985c85e29c6dfa9def1b461cb9684105c55dfd6ed8701b19f'
            '1d05fe8ee8dad4062749ae87c4cb5f943607257024585af956171'
            '9758b578aecbd9cd863b2ff50218650fecca0ca9f6aed52be36ce'
            '39c4fa610b485dc3981ada313c0f02ba562'
           )

# Test data for IDEA

idea = [('00010002000300040005000600070008', '0000000100020003', '11fbed2b01986de5'),
        ('00010002000300040005000600070008', '0102030405060708', '540E5FEA18C2F8B1'),
        ('00010002000300040005000600070008', '0019324B647D96AF', '9F0A0AB6E10CED78'),
        ('00010002000300040005000600070008', 'F5202D5B9C671B08', 'CF18FD7355E2C5C5'),
        ('00010002000300040005000600070008', 'FAE6D2BEAA96826E', '85DF52005608193D'),
        ('00010002000300040005000600070008', '0A141E28323C4650', '2F7DE750212FB734'),
        ('00010002000300040005000600070008', '050A0F14191E2328', '7B7314925DE59C09'),
        ('0005000A000F00140019001E00230028', '0102030405060708', '3EC04780BEFF6E20'),
        ('3A984E2000195DB32EE501C8C47CEA60', '0102030405060708', '97BCD8200780DA86'),
        ('006400C8012C019001F4025802BC0320', '05320A6414C819FA', '65BE87E7A2538AED'),
        ('9D4075C103BC322AFB03E7BE6AB30006', '0808080808080808', 'F5DB1AC45E5EF9F9')
       ];

# Diamond validation data

diamond= [
('0FE834FDB933C502923D92BC9E14368E70D41C66CBDF36155033A66E07E6CC6D8D',
   '5A8D872D31EEDDE63FC46F6C36456D8E', '7345025F0802112D5575FC86C12DE34D'),
('0C07CFCB83B4BED44F6E253C5CFA36367A195E4D0D54843692856729A3542288',
   '407D166413286727B6694F63F2E53517', 'DDC1BB703FFCF63936833A375745A481'),
('095310E1AAAD0E4BB0EC167B770239A1BAFB7BA009C0986CFF5DCED2B9A708',
   '6AAABA305E9D60E437FADB7730883744', '4E8E8A32804C2DA248DD1621A2DF5A59'),
('06351601558986E3CB295E26D0B575E8A60226561CB098B91E9E48D0A421',
   '621127720D127F14AB021095257F6C9D', '8099EC7AA94A31E7A602C59B73EE53C4'),
('0E29D0C2E84D8954AE30F96D8080BA260B5D5485D36A4E4DF7C3B48E85',
   '23A6FCF704C04FBF19FDF983EDC39127', '7B86739B5F742871B53AD8916CBDC6B0'),
('0B2DF793534BE688C016711B05BF9DFFD4C74A1B33524FC494D3DA3E',
   'F1C964CDE2032DB0BC27B4BE0F3D9D0F', '1463F77F39BDC235EA5E8A5B081F9CE1'),
('089358CD27EF176094C635CACCD66234249E12137D65618533911A',
   'ECDA4CBE89F74DBF79EBE9B9F4F6CF2C', '4C333A87CDBC5F8EDD568A08ACD22D2E'),
('05031058F338D421B5EC460694B432ADD824708B6FBFC1E8E5BE',
   '1D0D3F08D8487FB6B68E762973FD2152', 'F9BE7970B1A6689FBA1D1B83DBDC1346'),
('0DA5C3BE04CDD35306F442817EAB347B9344D7E5C68BF3AE0C',
   '2ED35B01A830E3FCC46C1989C6F4D3DE', '1DA5D794C98F0937B32C355F9448B0A7'),
('0A4C748F1B820D90EF4E4487930184D83A975079258F3E4C',
   '607CF038557E4F47BF698C167B57591E', '48065D489BC746D6A75DC5DCC6E4F50B'),
('0728C4C94EB27C184197F02B75630D65DF00E5F6ADE5FE',
   'D5C77CD3F9A7EDF2EDB958F4DAF45FF9', '33F7E9DF813EBE5C58244C8F3E85EBB4'),
('0FC973FE155E072F4D59E8DC50F75E731C32FAC65986',
   '4574FF5B256C18928E2B9DF241825863', '687754F76CBDE753BAD5EDDF7A903715'),
('0C4AF410A88AC1E99CCB6E06588F53576D5E4F9D1A',
   'E4890AD4BD722A84A6C8BB3AB02C5FBD', '60291771D5810238C0459E0DE3A07725'),
('094F7102C1649E097A9259628C2F2711348FCBBD',
   '6917AF1266EBC9C7E901753973A06E82', '5BB024216B9314BA550085190A1509BE'),
('069502CA455398A07296669DC55B67756EC554',
   'E292CAF38755D561CF7035DFBD554ADB', 'A13380C10591BEBD8DEBFF63E22D219E'),
('0E56BF070CEC71301616A85980DADC37FBAE',
   '34F51EFDC20D06845853BAF2CE2727D9', '42B9F6F6A57E0F939FC40399FD3B3A4A'),
('0B1B81208A65F6DD6E9D75CA64B6DE9102',
   '28D471B93D593959D0828FD1DA9B876D', '188C3C40455E49E1716FF2B00D3B4852'),
('084B00E05A8A31EDD4491705399571A5',
   '8AF72EED4716980112A8EB3BF4A6BF0E', 'F197A1681AFD1F6B97EB46491722CDCD'),
('059CC4EB1BEE4A8C36D62AD1117D2C',
   'CB3DF13AA5C9A4B0CEA489C22D941127', 'CA635CB32EBA76EA6A263DC5B63E4462'),
('0DB3E4E9AAFEAA07657FE500DA49',
   '840506BFFE845A9D573A7014D915389A', '34066FB8EC127674DEA47682F48ED6A0'),
('0A0E91DC60AE757379CC07078C',
   'C940AE7EC343183C01D9A435E1DA1675', '38E8C4B858CFF14B425CF6ADF9C4E05D'),
('0718DB219F364817F8EA38E9',
   '4BDD132F3E7D215E5CAE53D033956989', '3FB1DDE1F10CA1813B71BDF51C9D0C4B'),
('0FB46C3A84C229322F38E0',
   'B05B9B1923A5154F901016264497FC10', '1A8F6CF4526045AFCC95AD377593797D'),
('0C5F7C6DE608F961490C',
   'EB4AEE30F3937A85D6DA4FE53E232333', '5005F10F2CDC39DA5D3A2B821E8AFAA7'),
('091C5D3EF1DAA3C5C8',
   'F329EF6A9492BCF8EA471B605DEE2718', '6C4C87C3C745FD514842A6CA979D26E3')
         ]

# Test data for RC5

rc5 = [('10200c1000000000000000000000000000000000', '0000000000000000',
        '21A5DBEE154B8F6D'),
       ('10200c10915F4619BE41B2516355A50110A9CE91', '21A5DBEE154B8F6D',
        'F7C013AC5B2B8952'),
       ('10200c10783348E75AEB0F2FD7B169BB8DC16787', 'F7C013AC5B2B8952',
        '2F42B3B70369FC92'),
       ('10200c10DC49DB1375A5584F6485B413B5F12BAF', '2F42B3B70369FC92',
        '65C178B284D197CC'),
       ('10200c105269F149D41BA0152497574D7F153125', '65C178B284D197CC',
        'EB44E415DA319824')
      ]

# Test data for Blowfish

blowfish = [('6162636465666768696a6b6c6d6e6f707172737475767778797a',
	     '424c4f5746495348', '324ed0fef413a203'),
	    ('57686f206973204a6f686e2047616c743f', 'fedcba9876543210', 
	     'cc91732b8022f684')
	   ]

# Test data for DES3

des3= [('0123456789abcdeffedcba9876543210', '0123456789abcde7',
	'7f1d0a77826b8aff')
      ]

# Test data for HAVAL  (passes, length, text, value)
haval = [(3, 128, '', '1BDC556B29AD02EC09AF8C66477F2A87'),
	 (3, 128, 'a', '24D2BC955A219E3E06462C91B555CFA1'),
	 (3, 128, 'HAVAL', '16C743E5EEFD3266ED50DEAC6C30313E'),
	 (3, 128, '0123456789', '82D163440F6E853229A97007EC4AF0E5'),
	 (3, 128, 'abcdefghijklmnopqrstuvwxyz', '92E8EC9AD7FD209D97E9CE21B50440E9'),
	 (3, 128, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', '4AE2F37CEF9275CCE0D73F6A1EB9CDD8'),
	 (3, 160, '', 'FE79D0A044FFB75D5354668D664E4F4B9CC33477'),
	 (3, 160, 'a', '5E1610FCED1D3ADB0BB18E92AC2B11F0BD99D8ED'),
	 (3, 160, 'HAVAL', '8E568AD6CCD58D17E0A11E92183232E0D1D2E9BF'),
	 (3, 160, '0123456789', '700D43A9B5E38300303FD4E25A6A326BEB4A2241'),
	 (3, 160, 'abcdefghijklmnopqrstuvwxyz', '1DD40AEAB9610585FCAE7492FF3B893C2A018F4E'),
	 (3, 160, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', '485ABB76ED2F5AC8BB86DDEB8CB4C54CF5BB077B'),
	 (3, 192, '', '5E05A29CA2DB5DABE05A36BEED1D9F23A62E24714E74E2FF'),
	 (3, 192, 'a', '53FD81208C51EBC807ED5A6596A2897BD8211975F10CC46E'),
	 (3, 192, 'HAVAL', '365F46AF04836A174C7F17E0A364E77FB613DC54990649D5'),
	 (3, 192, '0123456789', '241210926D574FAFB89CA187D51BDD78209DB46410660DF2'),
	 (3, 192, 'abcdefghijklmnopqrstuvwxyz', '91FF2A2BE448D2C4301E27AC664FC6BDE5B98BF275967DDC'),
	 (3, 192, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', 'F9658C8807D791F3A7F364E17B8771E85BE7BD539A1957A6'),
	 (3, 224, '', 'F3D390AF42356F1D32CBD3B6F26B16FAB3771AAE92E7B48D32DED172'),
	 (3, 224, 'a', 'C0ADA85221F054D8266370225C36765A4E337615C987703391D0A06F'),
	 (3, 224, 'HAVAL', 'A728355187983BBF110DC6EA263995F57D56B08A063FB2750D58648A'),
	 (3, 224, '0123456789', 'FD47F2202811C889A45C19E334249F52A23670843B6B4682636E5B14'),
	 (3, 224, 'abcdefghijklmnopqrstuvwxyz', '558832025C6B71DF1CA043905CE6199A031B4ED2DCAA820B2E27F122'),
	 (3, 224, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', '5311AADA23AF4F8993448B53C2994186F181E9D80D821A6A7F58386A'),
	 (3, 256, '', '839786AC4F89EE6AE87F2065AC681097D7276A9903B7E972E992566D0DE38E0C'),
	 (3, 256, 'a', '5BCB16472639B8E63CA1E2B347D9038F7A808D8B317CBE4F202DFB9C0529B0FD'),
	 (3, 256, 'HAVAL', '7208A60270D70EE998F942B03D5D3ACF5B3AA4A841F21360896948D0B78CACD2'),
	 (3, 256, '0123456789', 'CC2CE6F921AA5423E1EEAB178AE0FFD293972C2530DCE9C7FE8A7EA77C8ACEAC'),
	 (3, 256, 'abcdefghijklmnopqrstuvwxyz', 'DB9CEDB76576C2BFF4345F3D17C241CB1B4D29B0DBBE8F263E463BFFD260AC89'),
	 (3, 256, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', '8FB83BFDA5F8324DFBA078B3DB48A95B7C7C4023F8FB70045EF875425AF83868'),
	 (4, 128, '', 'A0E12BA547C3F7724B97BEB2B2466825'),
	 (4, 128, 'a', '9D576BED5A29B47100157FDBF7AF4B34'),
	 (4, 128, 'HAVAL', '3BF0CE4A6C375AD2C5FC954242B68219'),
	 (4, 128, '0123456789', '361F885D16277A4686558A0B694EE215'),
	 (4, 128, 'abcdefghijklmnopqrstuvwxyz', '198504C9CD40D1938396CE81F5F64BD0'),
	 (4, 128, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', '50F905D51FB69C2B8CA5D15F13C099CB'),
	 (4, 160, '', 'D4093169135AA22DAD562993D362F79BA23B5F10'),
	 (4, 160, 'a', 'F00666EFE778E269F149371FA9FABFC98C07B7BE'),
	 (4, 160, 'HAVAL', 'EB6E692476720867737523ECE547FF027839B84F'),
	 (4, 160, '0123456789', '0FB6575C829528FE5345E528E084AC814C1A88DA'),
	 (4, 160, 'abcdefghijklmnopqrstuvwxyz', '1BB37E16413FAE67FD39973C943A719C44F2855A'),
	 (4, 160, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', '1AC51AE99A8915BA8A651370C2B96037BC53496F'),
	 (4, 192, '', '51FA9E28C96865207ED6DAE2EAA1D8AF6E7DE2783EBEC4B4'),
	 (4, 192, 'a', 'A1446E6CEDB4B28BC6E13D4D1D2694E9CE4A3D942C73589E'),
	 (4, 192, 'HAVAL', '74AA31182FF09BCCE453A7F71B5A7C5E80872FA90CD93AE4'),
	 (4, 192, '0123456789', 'CA05546FFA4B69DAFA7C04424CC10802A2523EFCB8BEBB61'),
	 (4, 192, 'abcdefghijklmnopqrstuvwxyz', '5A238735D9E902E16CAD81229CC981A763508C73F4A52DD0'),
	 (4, 192, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', 'D51D73EB03B0D841C24F2007AA9159F0F70A971CBFBED33C'),
	 (4, 224, '', 'AACD8950B239B05E8A40A0419AFD3BBED206623913D8A6DFE71D174B'),
	 (4, 224, 'a', '54A26096C951725228D34A1B55C2DB5C28446E6B243FE2AE78623A4B'),
	 (4, 224, 'HAVAL', 'F9040EEBAE11709245501BEFFB5FB849F88A9086F24DF3A55A03A01A'),
	 (4, 224, '0123456789',
	  '144CB2DE11F05DF7C356282A3B485796DA653F6B702868C7DCF4AE76'),
	 (4, 224, 'abcdefghijklmnopqrstuvwxyz', 'FBB63F06592FB9AA4F59652B99BC53C1FF72675726C71326C682DABC'),
	 (4, 224, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', '1120B26105044DF0B4E5B904705F3B8CBBC14A52B73301C300BAFF8A'),
	 (4, 256, '', '75128F15B3DAADD15D3C1D85F88A8B7E39948BABA7B2F4EA3D7B8E9A75A710E7'),
	 (4, 256, 'a', 'D710C33A848E8138CCE2C3D8B4DE2252A55C75FD60B6B4E2D6C39EBBAB215EBF'),
	 (4, 256, 'HAVAL', '0D25D9903F37C840250179821DB66353CC490DF2B90A45A5E20060D5F2D67593'),
	 (4, 256, '0123456789', 'AEEF777C84664C3D07A939815E45DEF9C1750A6505DD24BF7FCEB88282A33DD2'),
	 (4, 256, 'abcdefghijklmnopqrstuvwxyz', 'CB8C4E5C74AD38DB97031A51C0125CDF466E396C16674479DDF57D5A7E5DB55B'),
	 (4, 256, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', '5A1910C4F800FF94B2D56403EF6371452EB50275896EFD57B4E2E716E955D6D1'),
	 (5, 128, '', '03FD808CAC90089E43B62B1C522953F8'),
	 (5, 128, 'a', '50FA56EAF75E634D63F2CDB6409125BA'),
	 (5, 128, 'HAVAL', 'C91CDFB768369566270A5E7F4B20E3B9'),
	 (5, 128, '0123456789', '29C0AAB1F6D03E11DFC1CF2B9E4DE91A'),
	 (5, 128, 'abcdefghijklmnopqrstuvwxyz', '6994C3F53914D42E736EA81427A408EC'),
	 (5, 128, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', '54E55ECCAC0BF7C7BBA47A49B3D27422'),
	 (5, 160, '', 'A8213CACD787CEBF23F416049540AAFB637D34F2'),
	 (5, 160, 'a', 'B960F55EADD6091ADEC094827455584131F3C62C'),
	 (5, 160, 'HAVAL', 'F9E24DD43FD5D3EA5B45D046529C7DDB93937F8B'),
	 (5, 160, '0123456789', 'A7C539EA79EAAF856089FA6DED81F60374E95A96'),
	 (5, 160, 'abcdefghijklmnopqrstuvwxyz', '40B8769D3C555E43DCF235C4F1E5E130EEE2CAC7'),
	 (5, 160, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', 'F4E246BC33D04DA73B0D0EDDF94CFA5824CF2063'),
	 (5, 192, '', 'A352EF5FC2004ECE93BACC1C7429B8DD66ED270FD7EE5B0D'),
	 (5, 192, 'a', 'FAF3158553F717992FFB29595FBC23E93AF632A5A2782C57'),
	 (5, 192, 'HAVAL', 'BED2A1EBD9CB2F89F65FE33254E460E5019275191589A739'),
	 (5, 192, '0123456789', '56048B23FAEEFBC90174B8238F1D8BB92FAEDAA6D73C8A93'),
	 (5, 192, 'abcdefghijklmnopqrstuvwxyz', 'D8D531F3872B42A23899A2057A503F15D8DCB19DB2361AE1'),
	 (5, 192, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', '20F3BA5DF1971041D4D2EC4724DCBC090A9BBB07151B9FE0'),
	 (5, 224, '', 'E84C8F723F431282E88B9D3F0AD44504769402D07E46F8F8B326438D'),
	 (5, 224, 'a', '23AD516F08E024A1C0976A25DDB161797E8EE2E4B657D725704216D6'),
	 (5, 224, 'HAVAL', 'A23B187B07B8F7A1B2DE0AE5408EF3CBA8830565355FF59D53CAB0E1'),
	 (5, 224, '0123456789', '9A050B4386E51F72E0F0088AF1917E737E66036F8561CFC25CDDB8DB'),
	 (5, 224, 'abcdefghijklmnopqrstuvwxyz', 'B917D5FB2637AEEF80EFC747CCD44E31B08726AA5890C20FD7757045'),
	 (5, 224, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', 'B70ADBC1504075689EBB71BF9B7D7A849805B77D37C5E1C209AA4E71'),
	 (5, 256, '', '5981D3F8CCE7F5674752595F4AD24C184BA1C738C986D4D2EDDF2BD86C3F8679'),
	 (5, 256, 'a', '166F2218E0994A78EBAD3FEAB0211B612B14E93E5CCEB60E6F143DF0FA166D39'),
	 (5, 256, 'HAVAL', '217BFDF84F5C775596C2F13CEEA7417CD4E198D53CA24902F9717585EC5789AC'),
	 (5, 256, '0123456789', 'A6828EEB82D5A9CBFC7C522AD4B3C38A42753DECEB20FB3A6FABC0DA8CCD6A1A'),
	 (5, 256, "abcdefghijklmnopqrstuvwxyz",
	  '1A1DC8099BDAA7F35B4DA4E805F1A28FEE909D8DEE920198185CBCAED8A10A8D'),
	 (5, 256,
	  "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",
	  'C5647FC6C1877FFF96742F27E9266B6874894F41A08F5913033D9D532AEDDB39')
        ]



