/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import netscape.ldap.LDAPCheckComm;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSSLSocketFactoryExt;

public class LDAPSSLSocketFactory
implements LDAPSSLSocketFactoryExt {
    private boolean m_clientAuth = false;
    private String m_packageName = "netscape.net.SSLSocket";
    private Object m_cipherSuites;
    private LDAPConnection m_connection;

    public LDAPSSLSocketFactory() {
    }

    public LDAPSSLSocketFactory(boolean bl) {
        this.m_clientAuth = bl;
    }

    public LDAPSSLSocketFactory(String string) {
        this.m_packageName = new String(string);
    }

    public LDAPSSLSocketFactory(String string, boolean bl) {
        this.m_packageName = new String(string);
        this.m_clientAuth = bl;
    }

    public LDAPSSLSocketFactory(String string, Object object) {
        this.m_packageName = new String(string);
        this.m_cipherSuites = object;
    }

    public LDAPSSLSocketFactory(String string, Object object, boolean bl) {
        this.m_packageName = new String(string);
        this.m_cipherSuites = object;
        this.m_clientAuth = bl;
    }

    public void enableClientAuth() {
        this.m_clientAuth = true;
    }

    public void enableClientAuth(String string, String string2, String string3, String string4, String string5) throws LDAPException {
        throw new LDAPException("Client auth not supported now");
    }

    public boolean isClientAuth() {
        return this.m_clientAuth;
    }

    public String getSSLSocketImpl() {
        return this.m_packageName;
    }

    public Object getCipherSuites() {
        return this.m_cipherSuites;
    }

    public Socket makeSocket(String string, int n) throws LDAPException {
        Object object;
        Object object2;
        Socket socket = null;
        if (this.m_clientAuth) {
            try {
                object2 = LDAPCheckComm.getMethod("netscape.security.PrivilegeManager", "enablePrivilege");
                if (object2 != null) {
                    object = new Object[]{new String("ClientAuth")};
                    ((Method)object2).invoke(null, (Object[])object);
                }
            }
            catch (Exception exception) {
                throw new LDAPException("Invoking enablePrivilege: " + exception.toString(), 89);
            }
        }
        try {
            object2 = null;
            if (this.m_cipherSuites != null) {
                object2 = this.m_cipherSuites.getClass().getName();
            }
            object = Class.forName(this.m_packageName);
            Constructor<?>[] constructorArray = ((Class)object).getConstructors();
            int n2 = 0;
            while (n2 < constructorArray.length) {
                Class<?>[] classArray = constructorArray[n2].getParameterTypes();
                if (this.m_cipherSuites == null && classArray.length == 2 && classArray[0].getName().equals("java.lang.String") && classArray[1].getName().equals("int")) {
                    Object[] objectArray = new Object[]{string, new Integer(n)};
                    socket = (Socket)constructorArray[n2].newInstance(objectArray);
                    return socket;
                }
                if (this.m_cipherSuites != null && classArray.length == 3 && classArray[0].getName().equals("java.lang.String") && classArray[1].getName().equals("int") && classArray[2].getName().equals(object2)) {
                    Object[] objectArray = new Object[]{string, new Integer(n), this.m_cipherSuites};
                    socket = (Socket)constructorArray[n2].newInstance(objectArray);
                    return socket;
                }
                ++n2;
            }
            throw new LDAPException("No appropriate constructor in " + this.m_packageName, 89);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LDAPException("Class " + this.m_packageName + " not found", 89);
        }
        catch (Exception exception) {
            throw new LDAPException("Failed to create SSL socket", 91);
        }
    }
}

