/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer.io;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import netscape.plugin.composer.io.Comment;
import netscape.plugin.composer.io.Entity;
import netscape.plugin.composer.io.FooStringBuffer;
import netscape.plugin.composer.io.SlidingBuffer;
import netscape.plugin.composer.io.Tag;
import netscape.plugin.composer.io.Text;
import netscape.plugin.composer.io.Token;

public class LexicalStream {
    private SlidingBuffer in;
    private FooStringBuffer buffer;
    private static final String NEWLINE = new String("\n");
    private boolean bHaveClosedStream;

    public LexicalStream(String string) {
        this(new CharArrayReader(string.toCharArray()));
    }

    public LexicalStream(Reader reader) {
        this.in = new SlidingBuffer(reader);
    }

    private int read() throws IOException {
        return this.in.read();
    }

    private boolean lookAhead(char c) throws IOException {
        return this.in.lookAhead(c);
    }

    private boolean lookAhead(String string) throws IOException {
        return this.in.lookAhead(string);
    }

    private boolean lookAhead(String string, boolean bl) throws IOException {
        return this.in.lookAhead(string, bl);
    }

    private boolean eatNewline() throws IOException {
        return this.in.eatNewline();
    }

    private boolean eatWhiteSpace() throws IOException {
        return this.in.eatWhiteSpace();
    }

    public Token next() throws IOException {
        int n;
        while ((n = this.read()) >= 0) {
            if (n == 38) {
                if (this.buffer != null) {
                    this.in.unread(1);
                    break;
                }
                FooStringBuffer fooStringBuffer = new FooStringBuffer();
                this.parseEntity(fooStringBuffer);
                return new Entity(fooStringBuffer);
            }
            if (n == 60) {
                if (this.buffer != null) {
                    this.in.unread(1);
                    break;
                }
                if (this.in.lookAhead('/')) {
                    return this.parseTag(false);
                }
                if (this.in.lookAhead('!')) {
                    return this.parseComment();
                }
                return this.parseTag(true);
            }
            if (n == 13) {
                if (this.buffer != null) {
                    this.in.unread(1);
                    break;
                }
                this.in.lookAhead('\n');
                return new Text(NEWLINE);
            }
            if (n == 10) {
                if (this.buffer != null) {
                    this.in.unread(1);
                    break;
                }
                return new Text(NEWLINE);
            }
            if (this.buffer == null) {
                this.buffer = new FooStringBuffer();
            }
            this.buffer.append((char)n);
        }
        if (this.buffer != null) {
            String string = this.buffer.toString();
            this.buffer = null;
            return new Text(string);
        }
        if (!this.bHaveClosedStream) {
            this.in.close();
            this.bHaveClosedStream = true;
        }
        return null;
    }

    private boolean isWhitespace(char c) {
        return Character.isSpace(c);
    }

    private Token parseTag(boolean bl) throws IOException {
        int n;
        FooStringBuffer fooStringBuffer = new FooStringBuffer();
        while ((n = this.read()) >= 0 && n != 62 && !this.isWhitespace((char)n)) {
            fooStringBuffer.append((char)n);
        }
        if (fooStringBuffer.length() == 0) {
            fooStringBuffer.append('<');
            if (!bl) {
                fooStringBuffer.append('/');
            }
            if (n >= 0) {
                fooStringBuffer.append((char)n);
            }
            return new Text(fooStringBuffer.toString());
        }
        Tag tag = new Tag(fooStringBuffer.toString(), bl);
        if (n == 62) {
            return tag;
        }
        while ((n = this.read()) >= 0 && n != 62) {
            if (this.isWhitespace((char)n)) continue;
            this.in.unread(1);
            this.parseTagAttribute(tag);
        }
        return tag;
    }

    private void parseTagAttribute(Tag tag) throws IOException {
        int n;
        FooStringBuffer fooStringBuffer = new FooStringBuffer();
        while ((n = this.read()) >= 0) {
            if (n == 62 || n == 61) {
                this.in.unread(1);
                break;
            }
            if (this.isWhitespace((char)n)) break;
            fooStringBuffer.append((char)n);
        }
        if (fooStringBuffer.length() == 0) {
            return;
        }
        this.eatWhiteSpace();
        n = this.read();
        FooStringBuffer fooStringBuffer2 = null;
        if (n != 61) {
            this.in.unread(1);
        } else {
            this.eatWhiteSpace();
            n = this.read();
            if (n >= 0) {
                if (n == 62) {
                    this.in.unread(1);
                } else if (n == 39 || n == 34) {
                    fooStringBuffer2 = this.parseQuotedString(n);
                } else {
                    fooStringBuffer2 = new FooStringBuffer();
                    fooStringBuffer2.append((char)n);
                    while ((n = this.read()) >= 0) {
                        if (n == 62) {
                            this.in.unread(1);
                            break;
                        }
                        if (this.isWhitespace((char)n)) break;
                        fooStringBuffer2.append((char)n);
                    }
                }
            }
        }
        tag.addAttribute(fooStringBuffer.toString(), fooStringBuffer2 != null ? fooStringBuffer2.toString() : null);
    }

    private FooStringBuffer parseQuotedString(int n) throws IOException {
        int n2;
        FooStringBuffer fooStringBuffer = new FooStringBuffer();
        while ((n2 = this.read()) >= 0) {
            if (n2 == 38) {
                if (this.in.peek() == 123) {
                    this.read();
                    this.parseJavaScriptEntity(fooStringBuffer);
                    continue;
                }
                this.parseEntity(fooStringBuffer);
                continue;
            }
            if (n2 == n) break;
            fooStringBuffer.append((char)n2);
        }
        return fooStringBuffer;
    }

    private Comment parseComment() throws IOException {
        int n;
        FooStringBuffer fooStringBuffer = new FooStringBuffer();
        boolean bl = false;
        if (this.in.lookAhead('-')) {
            if (this.in.lookAhead('-')) {
                bl = true;
            } else {
                fooStringBuffer.append('-');
            }
        }
        while ((n = this.read()) >= 0) {
            if (bl) {
                if (n == 45 && this.in.lookAhead('-')) {
                    if (this.in.lookAhead('>')) break;
                    fooStringBuffer.append("--");
                }
            } else if (n == 62) break;
            fooStringBuffer.append((char)n);
        }
        if (bl) {
            return new Comment("--" + fooStringBuffer + "--");
        }
        return new Comment(fooStringBuffer);
    }

    private void parseEntity(FooStringBuffer fooStringBuffer) throws IOException {
        int n;
        while ((n = this.read()) >= 0 && n != 59) {
            if (this.isWhitespace((char)n)) {
                this.in.unread(1);
                return;
            }
            fooStringBuffer.append((char)n);
        }
    }

    private void parseJavaScriptEntity(FooStringBuffer fooStringBuffer) throws IOException {
        int n;
        int n2 = 1;
        while ((n = this.read()) >= 0) {
            if (n == 39 || n == 34) {
                this.parseJavaScriptQuotedString(fooStringBuffer, n);
                continue;
            }
            if (n == 123) {
                fooStringBuffer.append((char)n);
                ++n2;
                continue;
            }
            if (n == 125) {
                if (--n2 == 0) {
                    this.in.lookAhead(';');
                    return;
                }
                fooStringBuffer.append((char)n);
                continue;
            }
            if (n == 47) {
                n = this.read();
                if (n < 0) break;
                if (n == 42) {
                    this.parseCComment(fooStringBuffer);
                    continue;
                }
                if (n == 47) {
                    this.parseEOLComment(fooStringBuffer);
                    continue;
                }
                fooStringBuffer.append('/');
                fooStringBuffer.append((char)n);
                continue;
            }
            fooStringBuffer.append((char)n);
        }
    }

    private void parseJavaScriptQuotedString(FooStringBuffer fooStringBuffer, int n) throws IOException {
        int n2;
        fooStringBuffer.append((char)n);
        while ((n2 = this.read()) >= 0) {
            fooStringBuffer.append((char)n2);
            if (n2 == 92) {
                n2 = this.read();
                if (n2 < 0) break;
                fooStringBuffer.append((char)n2);
                continue;
            }
            if (n2 != n) continue;
            return;
        }
    }

    private void parseCComment(FooStringBuffer fooStringBuffer) throws IOException {
        int n;
        fooStringBuffer.append("/*");
        while ((n = this.read()) >= 0) {
            fooStringBuffer.append((char)n);
            if (n != 42) continue;
            n = this.read();
            if (n < 0) break;
            fooStringBuffer.append((char)n);
            if (n != 47) continue;
            return;
        }
    }

    private void parseEOLComment(FooStringBuffer fooStringBuffer) throws IOException {
        int n;
        fooStringBuffer.append("//");
        while ((n = this.read()) >= 0) {
            fooStringBuffer.append((char)n);
            if (n != 10 && n != 13) continue;
            fooStringBuffer.append((char)n);
            return;
        }
    }
}

