/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import sunw.hotjava.doc.DocumentEvent;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.Hax;
import sunw.hotjava.misc.RequestProcessor;
import sunw.hotjava.ui.ImageToolTip;
import sunw.hotjava.ui.MessageBox;
import sunw.hotjava.ui.TimedMessageOwner;

public class TimedMessage {
    private Frame parentFrame;
    private String message;
    private Point location;
    private long waitTime;
    private long targetTime;
    private Point origPos;
    private Component initiator;
    private TimedMessageOwner messageOwner;
    private MessageBox messageBox;
    private boolean showing = false;
    private Thread thread;
    private boolean finishTiming = false;

    public TimedMessage(Frame frame, String string, Point point, Component component) {
        this.parentFrame = frame;
        this.message = string;
        this.location = point;
        this.initiator = component;
        if (component instanceof TimedMessageOwner) {
            this.messageOwner = (TimedMessageOwner)((Object)component);
        }
        this.origPos = component.getLocationOnScreen();
        String string2 = Globals.props.getProperty("hotjava.timedMessage.delay", "1");
        this.waitTime = this.getMillisecondProperty(string2, 1000L);
        this.setTargetTime();
        RequestProcessor.postRequest(new TimedMessageRequest(), 50);
    }

    public TimedMessage(Frame frame, String string, Point point, Component component, ImageToolTip imageToolTip) {
        this(frame, string, point, component);
        this.messageOwner = imageToolTip;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        Hax.debugln("hotjava.debug.timedMessage.events", "Event is " + mouseEvent);
        switch (mouseEvent.getID()) {
            case 501: 
            case 502: {
                this.finishTiming = true;
                this.hideMessageBox();
                this.messageOwner.removeTimedMessage();
                return;
            }
            case 503: 
            case 506: {
                this.setTargetTime();
                return;
            }
            case 505: {
                this.finishTiming = true;
                this.hideMessageBox();
                this.messageOwner.removeTimedMessage();
                return;
            }
        }
    }

    public void processDocumentEvent(DocumentEvent documentEvent) {
        switch (documentEvent.getID()) {
            case 1034: {
                this.setTargetTime();
                return;
            }
            case 1035: {
                this.finishTiming = true;
                this.hideMessageBox();
                this.messageOwner.removeTimedMessage();
            }
        }
    }

    public void checkTime() {
        block9: {
            boolean bl = false;
            try {
                TimedMessage timedMessage = this;
                synchronized (timedMessage) {
                    Point point;
                    boolean bl2 = System.currentTimeMillis() >= this.targetTime;
                    boolean bl3 = bl = !this.showing && bl2;
                    if (this.initiator.isShowing() && !(point = this.initiator.getLocationOnScreen()).equals(this.origPos)) {
                        this.finishTiming = true;
                        this.hideMessageBox();
                    }
                }
                if (!this.finishTiming && bl) {
                    this.showMessageBox();
                }
                if (this.finishTiming) break block9;
                RequestProcessor.postRequest(new TimedMessageRequest(), 50);
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                if (this.finishTiming) {
                    this.hideMessageBox();
                }
                throw throwable;
            }
        }
        Object var3_5 = null;
        if (this.finishTiming) {
            this.hideMessageBox();
        }
        Hax.debugln("hotjava.debug.timedMessage.events", "   exiting run loop");
    }

    private synchronized long getMillisecondProperty(String string, long l) {
        float f = 1.0f;
        try {
            f = Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
        return (long)(f * 1000.0f);
    }

    private synchronized void showMessageBox() {
        this.showing = true;
        this.messageBox = new MessageBox(this.parentFrame, this.message, this.location);
        Hax.debugln("hotjava.debug.timedMessage.events", "---> showing box");
        String string = Globals.props.getProperty("hotjava.timedMessage.destroydelay", "5");
        long l = this.getMillisecondProperty(string, 5000L);
        if (l > 0L) {
            RequestProcessor.postRequest(new MessageBoxKillRequest(), (int)l);
        }
    }

    private synchronized void hideMessageBox() {
        this.showing = false;
        Hax.debugln("hotjava.debug.timedMessage.events", "   hiding message box ");
        if (this.messageBox != null) {
            ((Component)this.messageBox).setVisible(false);
            this.messageBox.dispose();
            this.messageBox = null;
        }
    }

    private synchronized void setTargetTime() {
        this.targetTime = System.currentTimeMillis() + this.waitTime;
    }

    private class TimedMessageRequest
    extends RequestProcessor.Request {
        public void execute() {
            TimedMessage.this.checkTime();
        }

        TimedMessageRequest() {
            TimedMessage.this = TimedMessage.this;
        }
    }

    private class MessageBoxKillRequest
    extends RequestProcessor.Request {
        public void execute() {
            if (!TimedMessage.this.finishTiming) {
                TimedMessage.this.finishTiming = true;
                TimedMessage.this.hideMessageBox();
                TimedMessage.this.messageOwner.removeTimedMessage();
            }
        }

        MessageBoxKillRequest() {
            TimedMessage.this = TimedMessage.this;
        }
    }
}

