/*
 * Decompiled with CFR 0.152.
 */
package sunw.html.build;

import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import sunw.html.AttributeList;
import sunw.html.ContentModel;
import sunw.html.DTD;
import sunw.html.Element;
import sunw.html.Entity;
import sunw.html.build.DTDParser;
import sunw.html.build.PublicMapping;

public class DTDBuilder
extends DTD {
    static PublicMapping mapping = null;
    private Hashtable namesHash = new Hashtable();
    private Vector namesVector = new Vector();

    protected DTDBuilder(String string) {
        super(string);
    }

    void save(DataOutputStream dataOutputStream, String string) throws IOException {
        Object object;
        dataOutputStream.writeInt(DTD.FILE_VERSION);
        this.buildNamesTable();
        int n = this.namesVector.size();
        dataOutputStream.writeShort((short)this.namesVector.size());
        int n2 = 0;
        while (n2 < this.namesVector.size()) {
            object = (String)this.namesVector.elementAt(n2);
            dataOutputStream.writeUTF((String)object);
            ++n2;
        }
        this.saveEntities(dataOutputStream);
        dataOutputStream.writeShort((short)this.elements.size());
        object = this.elements.elements();
        while (object.hasMoreElements()) {
            this.saveElement(dataOutputStream, (Element)object.nextElement());
        }
        if (this.namesVector.size() != n) {
            System.err.println("!!! ERROR!  Names were added to the list!");
            Thread.dumpStack();
            System.exit(1);
        }
    }

    private void buildNamesTable() {
        Object object;
        Enumeration enumeration = this.entityHash.elements();
        while (enumeration.hasMoreElements()) {
            object = (Entity)enumeration.nextElement();
            this.getNameId(((Entity)object).getName());
        }
        object = this.elements.elements();
        while (object.hasMoreElements()) {
            Element element = (Element)object.nextElement();
            this.getNameId(element.getName());
            AttributeList attributeList = element.getAttributes();
            while (attributeList != null) {
                this.getNameId(attributeList.getName());
                if (attributeList.getValue() != null) {
                    this.getNameId(attributeList.getValue());
                }
                Enumeration enumeration2 = attributeList.getValues();
                while (enumeration2 != null && enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    this.getNameId(string);
                }
                attributeList = attributeList.getNext();
            }
        }
    }

    private short getNameId(String string) {
        Object v = this.namesHash.get(string);
        if (v != null) {
            return (short)((Integer)v).intValue();
        }
        int n = this.namesVector.size();
        this.namesVector.addElement(string);
        this.namesHash.put(string, new Integer(n));
        return (short)n;
    }

    void saveEntities(DataOutputStream dataOutputStream) throws IOException {
        Object object;
        int n = 0;
        Enumeration enumeration = this.entityHash.elements();
        while (enumeration.hasMoreElements()) {
            object = (Entity)enumeration.nextElement();
            if (!((Entity)object).isGeneral()) continue;
            ++n;
        }
        dataOutputStream.writeShort((short)n);
        object = this.entityHash.elements();
        while (object.hasMoreElements()) {
            Entity entity = (Entity)object.nextElement();
            if (!entity.isGeneral()) continue;
            dataOutputStream.writeShort(this.getNameId(entity.getName()));
            dataOutputStream.writeByte(entity.getType() & 0xFFFEFFFF);
            dataOutputStream.writeUTF(entity.getString());
        }
    }

    public void saveElement(DataOutputStream dataOutputStream, Element element) throws IOException {
        int n;
        int n2;
        int n3;
        dataOutputStream.writeShort(this.getNameId(element.getName()));
        dataOutputStream.writeByte(element.getType());
        byte by = 0;
        if (element.omitStart()) {
            by = (byte)(by | 1);
        }
        if (element.omitEnd()) {
            by = (byte)(by | 2);
        }
        dataOutputStream.writeByte(by);
        this.saveContentModel(dataOutputStream, element.getContent());
        if (element.exclusions == null) {
            dataOutputStream.writeShort(0);
        } else {
            n3 = 0;
            n2 = 0;
            while (n2 < element.exclusions.size()) {
                if (element.exclusions.get(n2)) {
                    n3 = (short)(n3 + 1);
                }
                ++n2;
            }
            dataOutputStream.writeShort(n3);
            n = 0;
            while (n < element.exclusions.size()) {
                if (element.exclusions.get(n)) {
                    dataOutputStream.writeShort(this.getNameId(this.getElement(n).getName()));
                }
                ++n;
            }
        }
        if (element.inclusions == null) {
            dataOutputStream.writeShort(0);
        } else {
            n3 = 0;
            n2 = 0;
            while (n2 < element.inclusions.size()) {
                if (element.inclusions.get(n2)) {
                    n3 = (short)(n3 + 1);
                }
                ++n2;
            }
            dataOutputStream.writeShort(n3);
            n = 0;
            while (n < element.inclusions.size()) {
                if (element.inclusions.get(n)) {
                    dataOutputStream.writeShort(this.getNameId(this.getElement(n).getName()));
                }
                ++n;
            }
        }
        n3 = 0;
        AttributeList attributeList = element.getAttributes();
        while (attributeList != null) {
            n3 = (short)(n3 + 1);
            attributeList = attributeList.getNext();
        }
        dataOutputStream.writeByte(n3);
        AttributeList attributeList2 = element.getAttributes();
        while (attributeList2 != null) {
            dataOutputStream.writeShort(this.getNameId(attributeList2.getName()));
            dataOutputStream.writeByte(attributeList2.getType());
            dataOutputStream.writeByte(attributeList2.getModifier());
            if (attributeList2.getValue() == null) {
                dataOutputStream.writeShort(-1);
            } else {
                dataOutputStream.writeShort(this.getNameId(attributeList2.getValue()));
            }
            if (attributeList2.values == null) {
                dataOutputStream.writeShort(0);
            } else {
                dataOutputStream.writeShort((short)attributeList2.values.size());
                int n4 = 0;
                while (n4 < attributeList2.values.size()) {
                    String string = (String)attributeList2.values.elementAt(n4);
                    dataOutputStream.writeShort(this.getNameId(string));
                    ++n4;
                }
            }
            attributeList2 = attributeList2.getNext();
        }
    }

    public void saveContentModel(DataOutputStream dataOutputStream, ContentModel contentModel) throws IOException {
        if (contentModel == null) {
            dataOutputStream.writeByte(0);
            return;
        }
        if (contentModel.content instanceof ContentModel) {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeByte(contentModel.type);
            this.saveContentModel(dataOutputStream, (ContentModel)contentModel.content);
            this.saveContentModel(dataOutputStream, contentModel.next);
            return;
        }
        if (contentModel.content instanceof Element) {
            dataOutputStream.writeByte(2);
            dataOutputStream.writeByte(contentModel.type);
            dataOutputStream.writeShort(this.getNameId(((Element)contentModel.content).getName()));
            this.saveContentModel(dataOutputStream, contentModel.next);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Properties properties = new Properties(System.getProperties());
        String string = System.getProperty("hotjava.home");
        if (string == null) {
            System.err.println("Must set property 'hotjava.home'");
            return;
        }
        try {
            properties.load(new FileInputStream(String.valueOf(string) + "/lib/hotjava.properties"));
        }
        catch (IOException iOException) {
            System.err.println("No system properties file");
            iOException.printStackTrace(System.err);
            return;
        }
        System.setProperties(properties);
        DTDBuilder dTDBuilder = null;
        try {
            dTDBuilder = new DTDBuilder(stringArray[0]);
            mapping = new PublicMapping(new URL(System.getProperty("public.map")));
            object = mapping.get(stringArray[0]);
            if (object == null) {
                throw new FileNotFoundException("DTD not found: " + stringArray[0]);
            }
            new DTDParser().parse(((URL)object).openStream(), dTDBuilder);
        }
        catch (IOException iOException) {
            System.err.println("Could not open DTD file " + stringArray[0]);
            iOException.printStackTrace(System.err);
            System.exit(1);
        }
        try {
            object = new DataOutputStream(System.out);
            dTDBuilder.save((DataOutputStream)object, stringArray[0]);
            ((FilterOutputStream)object).close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
            return;
        }
    }
}

