/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JInternalFrame;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.EmptyBorder;
import com.sun.java.swing.event.InternalFrameEvent;
import com.sun.java.swing.plaf.ColorUIResource;
import com.sun.java.swing.plaf.metal.MetalBumps;
import com.sun.java.swing.plaf.metal.MetalLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;

class MetalInternalFrameTitlePane
extends JComponent
implements LayoutManager,
ActionListener,
PropertyChangeListener {
    protected JMenuBar menuBar;
    protected boolean isPalette = false;
    JInternalFrame frame;
    protected JButton iconButton;
    protected JButton maxButton;
    protected JButton closeButton;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    Icon maxIcon;
    Icon altMaxIcon;
    Icon iconIcon;
    Icon closeIcon;
    int riseWidth;
    int interButtonSpacing = 3;
    MetalBumps activeBumps = new MetalBumps(0, 0, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControl());
    MetalBumps inactiveBumps = new MetalBumps(0, 0, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());
    static /* synthetic */ Class class$com$sun$java$swing$JInternalFrame;

    public MetalInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        this.frame = jInternalFrame;
        ((Component)this).setFont(UIManager.getFont("InternalFrameTitlePane.font"));
        this.maxIcon = (Icon)UIManager.get("InternalFrameTitlePane.maximizeIcon");
        this.altMaxIcon = (Icon)UIManager.get("InternalFrameTitlePane.altMaximizeIcon");
        this.iconIcon = (Icon)UIManager.get("InternalFrameTitlePane.iconizeIcon");
        this.closeIcon = (Icon)UIManager.get("InternalFrameTitlePane.closeIcon");
        this.iconButton = new JButton(this.iconIcon);
        this.iconButton.putClientProperty("paintActive", Boolean.TRUE);
        this.iconButton.setFocusPainted(false);
        this.iconButton.setBorder(handyEmptyBorder);
        this.iconButton.setOpaque(false);
        this.iconButton.addActionListener(this);
        this.iconButton.setActionCommand("Iconify");
        this.maxButton = new JButton(this.maxIcon);
        this.maxButton.putClientProperty("paintActive", Boolean.TRUE);
        this.maxButton.setBorder(handyEmptyBorder);
        this.maxButton.setOpaque(false);
        this.maxButton.setFocusPainted(false);
        this.maxButton.addActionListener(this);
        this.maxButton.setActionCommand("Maximize");
        this.closeButton = new JButton(this.closeIcon);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.setOpaque(false);
        this.closeButton.setFocusPainted(false);
        this.closeButton.addActionListener(this);
        this.closeButton.setActionCommand("Close");
        this.setLayout(this);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
        this.frame.addPropertyChangeListener(this);
    }

    public void paint(Graphics graphics) {
        MetalBumps metalBumps;
        ColorUIResource colorUIResource;
        ColorUIResource colorUIResource2;
        ColorUIResource colorUIResource3;
        ColorUIResource colorUIResource4;
        ColorUIResource colorUIResource5;
        boolean bl = this.frame.isSelected();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = ((JInternalFrame)this.getParent()).getContentPane().getBackground();
        if (bl) {
            colorUIResource5 = MetalLookAndFeel.getWindowTitleBackground();
            colorUIResource4 = MetalLookAndFeel.getWindowTitleForeground();
            colorUIResource3 = MetalLookAndFeel.getPrimaryControlShadow();
            colorUIResource2 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            colorUIResource = MetalLookAndFeel.getPrimaryControlHighlight();
            metalBumps = this.activeBumps;
        } else {
            colorUIResource5 = MetalLookAndFeel.getWindowTitleInactiveBackground();
            colorUIResource4 = MetalLookAndFeel.getWindowTitleInactiveForeground();
            colorUIResource3 = MetalLookAndFeel.getControlShadow();
            colorUIResource2 = MetalLookAndFeel.getControlDarkShadow();
            colorUIResource = MetalLookAndFeel.getControlHighlight();
            metalBumps = this.inactiveBumps;
        }
        graphics.setColor(colorUIResource5);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(colorUIResource);
        graphics.drawRect(0, 0, n - 1, n - 1);
        graphics.fillRect(0, 0, 2, 2);
        graphics.setColor(colorUIResource3);
        graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
        graphics.drawLine(n - 1, 1, n - 1, n2 - 2);
        graphics.setColor(colorUIResource2);
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
        graphics.drawLine(0, 0, 0, 0);
        graphics.drawLine(n - 1, 0, n - 1, 0);
        int n3 = 0;
        int n4 = 5;
        if (this.frame.getTitle() != null) {
            int n5;
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            fontMetrics.getHeight();
            Icon icon = this.frame.getFrameIcon();
            if (icon != null) {
                n5 = n2 / 2 - icon.getIconHeight() / 2;
                icon.paintIcon(this.frame, graphics, n4, n5);
                n4 += icon.getIconWidth() + 2;
            }
            graphics.setColor(colorUIResource4);
            n5 = (n2 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            graphics.drawString(this.frame.getTitle(), n4, n5);
            n3 = fontMetrics.stringWidth(this.frame.getTitle());
        }
        int n6 = this.getWidth() - ((n4 += n3 + this.interButtonSpacing) + this.riseWidth + this.interButtonSpacing);
        int n7 = this.getHeight() - 2 * this.interButtonSpacing - 2;
        metalBumps.setBumpArea(n6, n7);
        metalBumps.paintIcon(this, graphics, n4, this.interButtonSpacing);
        if (this.riseWidth != 0) {
            graphics.setColor(colorUIResource5);
            graphics.fillRect((n4 += n6 - 1) - 1, n2 - 7, 7, 3);
            graphics.setColor(colorUIResource2);
            graphics.drawLine(n4, n2 - 2, n4 + 1, n2 - 2);
            graphics.drawLine(n4 + 2, n2 - 3, n4 + 2, n2 - 3);
            graphics.drawLine(n4 + 3, n2 - 4, n4 + 4, n2 - 4);
            graphics.drawLine(n4 + 5, n2 - 5, n, n2 - 5);
            graphics.setColor(colorUIResource3);
            graphics.drawLine(n4 - 1, n2 - 3, n4 + 1, n2 - 3);
            graphics.drawLine(n4 + 1, n2 - 4, n4 + 2, n2 - 4);
            graphics.drawLine(n4 + 2, n2 - 5, n4 + 4, n2 - 5);
            graphics.drawLine(n4 + 4, n2 - 6, n, n2 - 6);
            graphics.setColor(color);
            graphics.drawLine(n4, n2 - 1, n, n2 - 1);
            graphics.drawLine(n4 + 2, n2 - 2, n, n2 - 2);
            graphics.drawLine(n4 + 3, n2 - 3, n, n2 - 3);
            graphics.drawLine(n4 + 5, n2 - 4, n, n2 - 4);
        }
        this.paintChildren(graphics);
    }

    void postClosingEvent(JInternalFrame jInternalFrame) {
        InternalFrameEvent internalFrameEvent = new InternalFrameEvent(jInternalFrame, 25550);
        if ((class$com$sun$java$swing$JInternalFrame != null ? class$com$sun$java$swing$JInternalFrame : (class$com$sun$java$swing$JInternalFrame = MetalInternalFrameTitlePane.class$("com.sun.java.swing.JInternalFrame"))).getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(internalFrameEvent);
                return;
            }
            catch (SecurityException securityException) {}
        }
        jInternalFrame.dispatchEvent(internalFrameEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Close".equals(actionEvent.getActionCommand()) && this.frame.isClosable()) {
            this.postClosingEvent(this.frame);
            return;
        }
        if ("Iconify".equals(actionEvent.getActionCommand()) && this.frame.isIconifiable()) {
            if (!this.frame.isIcon()) {
                try {
                    this.frame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                try {
                    this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
            ButtonModel buttonModel = this.iconButton.getModel();
            if (buttonModel != null) {
                buttonModel.setRollover(false);
                return;
            }
        } else {
            if ("Minimize".equals(actionEvent.getActionCommand()) && this.frame.isMaximizable()) {
                try {
                    this.frame.setIcon(true);
                    return;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
            if ("Maximize".equals(actionEvent.getActionCommand()) && this.frame.isMaximizable()) {
                if (!this.frame.isMaximum()) {
                    try {
                        this.frame.setMaximum(true);
                        return;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        return;
                    }
                }
                try {
                    this.frame.setMaximum(false);
                    return;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
            if ("Restore".equals(actionEvent.getActionCommand()) && this.frame.isMaximizable() && this.frame.isMaximum()) {
                try {
                    this.frame.setMaximum(false);
                    return;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
            if ("Restore".equals(actionEvent.getActionCommand()) && this.frame.isIconifiable() && this.frame.isIcon()) {
                try {
                    this.frame.setIcon(false);
                    return;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        JInternalFrame cfr_ignored_0 = (JInternalFrame)propertyChangeEvent.getSource();
        boolean bl = false;
        if (this.frame.isSelected()) {
            this.iconButton.putClientProperty("paintActive", Boolean.TRUE);
            this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
            this.maxButton.putClientProperty("paintActive", Boolean.TRUE);
            this.repaint();
        } else {
            this.iconButton.putClientProperty("paintActive", Boolean.FALSE);
            this.closeButton.putClientProperty("paintActive", Boolean.FALSE);
            this.maxButton.putClientProperty("paintActive", Boolean.FALSE);
            this.repaint();
        }
        if ("isSelected".equals(string)) {
            this.repaint();
            return;
        }
        if ("isMaximum".equals(string)) {
            bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                this.maxButton.setIcon(this.altMaxIcon);
                return;
            }
            this.maxButton.setIcon(this.maxIcon);
            return;
        }
        if ("isIcon".equals(string)) {
            bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                this.iconButton.setIcon(this.iconIcon);
                return;
            }
            this.iconButton.setIcon(this.iconIcon);
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getPreferredSize(container);
    }

    public Dimension getPreferredSize(Container container) {
        return new Dimension(container.getSize().width, this.computeHeight());
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    protected int computeHeight() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight();
        int n2 = this.frame.getFrameIcon().getIconHeight();
        int n3 = Math.max(n += 6, n2 += 7);
        return n3;
    }

    public void layoutContainer(Container container) {
        int n = this.getWidth();
        int n2 = this.closeButton.getIcon().getIconHeight();
        int n3 = this.closeButton.getIcon().getIconWidth();
        int n4 = n;
        if (this.frame.isClosable()) {
            this.closeButton.setBounds(n4 -= n3 + this.interButtonSpacing, this.interButtonSpacing, n3, n2);
        } else if (this.closeButton.getParent() != null) {
            this.closeButton.getParent().remove(this.closeButton);
        }
        if (this.frame.isMaximizable()) {
            this.maxButton.setBounds(n4 -= n3 + this.interButtonSpacing, this.interButtonSpacing, n3, n2);
        } else if (this.maxButton.getParent() != null) {
            this.maxButton.getParent().remove(this.maxButton);
        }
        if (this.frame.isIconifiable()) {
            this.iconButton.setBounds(n4 -= n3 + this.interButtonSpacing, this.interButtonSpacing, n3, n2);
        } else if (this.iconButton.getParent() != null) {
            this.iconButton.getParent().remove(this.iconButton);
        }
        this.riseWidth = n - n4;
    }

    public void setPalette(boolean bl) {
        this.isPalette = bl;
        this.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

