// === Starter Application 1.0.0 === //

//
// Functions that emit HTML dynamically
//


/* ======================================================

FUNCTION:  PrintBatchItem()

INPUT:     label - the label for a row item in a table
	   val - a string or number to be printed as a row item
		described by the label

RETURN:   none.

OUTPUT:  A row in an HTML table with 2 columns.

DESCRIPTION:  This function takes in the label and val arguments
   and constructs a row to an HTML table where label is the first 
   column, and val is the second column.

====================================================== */

function PrintBatchItem(label, val)
{
  write("<TR><TD ALIGN=RIGHT><STRONG>", label,
        "</STRONG></TD><TD>", val, "</TD></TR>\n");
}  // END PrintBatchItem()



/* ======================================================

FUNCTION:  PrintSettledBatch()

INPUT:     batch - batch object that contains information to be printed

RETURN:   none.

OUTPUT:  An HTML table that contains information about a single batch.

====================================================== */
 
function PrintSettledBatch(batch)
{
  var curDate = new Date();
 
  write("<CENTER><H1>Batch Settled</H1></CENTER>");
 
  write("<CENTER><TABLE BORDER=1>\n");
 
  PrintBatchItem("Date:",               curDate);
  PrintBatchItem("Batch Number:",       batch.batchNumber);
  PrintBatchItem("Merchant Reference:", batch.merchantReference);
  PrintBatchItem("Total Sales Amount:", batch.totalSalesAmount);
  PrintBatchItem("Total Credit Amount:", batch.totalCreditAmount);
  PrintBatchItem("Sales Count:",        batch.salesCount);
  PrintBatchItem("Credit Count:",       batch.creditCount);
  write("</TABLE></CENTER>\n");
 
  write('<BR><BR>');
}


/* ======================================================

FUNCTION:  GetTitleString()

INPUT:     viewtype - type of list requested 
	      can be one of 5 types:
		   "auth" - authorized transactions to capture or cancel
		   "credit" - captured transactions to credit
		   "view" - view only, no hyperlinks on transaction id
		   "current" - transactions in current batch
		   "errors" - view failed transactions
	   batchid - the id of the batch a transaction belongs to,
			if appropriate for the viewtype

RETURN:   An string of HTML that contains a title appropriate for the
	 type of transaction list that will be displayed in
	 "viewtrans.html".

====================================================== */

function GetTitleString( viewtype, batchid)
{

   if (viewtype == "auth") {
	cursor = database.cursor("select * from LP_PURCHASE where status = 'AUTHORIZED'");
	titleString = "<center><h3>Authorized Transactions that have NOT been Captured.</h3></center>";
   } 
   // Create a view of all CAPTURED transactions the admin might want to credit
   if (viewtype == "credit")
   {
	cursor = database.cursor("select * from LP_PURCHASE where LP_PURCHASE.batchID = " + batchid + " AND status = 'CAPTURED' order by LP_PURCHASE.ID");
	titleString = "<center><h3>Captured Transactions in Batch #" + batchid + ".  Click on an ID to CREDIT the Transaction.</h3></center>";
   }

   // Create a view of all transactions in a particular batch
   if (viewtype == "view")
   {
	cursor = database.cursor("select * from LP_PURCHASE where LP_PURCHASE.batchID = " + batchid + " order by LP_PURCHASE.ID");
	titleString = "<center><h3>Transactions in Batch #" + batchid + ".</h3></center>";
   }

   // Create a view of all transactions in the current batch
   if (viewtype == "current")
   {
	cursor = database.cursor("select * from LP_PURCHASE where LP_PURCHASE.batchID = " + batchid + " order by LP_PURCHASE.ID");
	titleString = "<center><h3>Transactions in the Current Batch (" + batchid + ").</h3></center>";
   }

   // Create a view of all transactions that failed.
   if (viewtype == "errors")
   {
	cursor = database.cursor("select * from LP_PURCHASE where ((status = 'AUTHFAILED') OR (status = 'AVSFAILED') OR (status = 'CAPTURING') OR (status = 'CREDITING')) order by LP_PURCHASE.ID");
	titleString = "<center><h3>Failed Transactions</h3></center>";
   }

   return titleString;

} // END FUNCTION GetTitleString();


/* ======================================================

FUNCTION:  PrintReceiptItem()

INPUT:   label - the label for a row item in a table
	   val - a string or number to be printed as a row item
		described by the label

RETURN:   none.

OUTPUT:  A row in an HTML table with 2 columns.

DESCRIPTION:  This function takes in the label and val arguments
   and constructs a row to an HTML table where label is the first 
   column, and val is the second column.
====================================================== */

function PrintReceiptItem(label, val)
{
  write("<TR><TD ALIGN=RIGHT><STRONG>", label,
        "</STRONG></TD><TD>", val, "</TD></TR>\n");

} // END PrintReceiptItem()



/* ======================================================

FUNCTION:  PrintReceipt()

INPUT:     pay - the Payevent object associated with the purchase.
	  desc - a string that describes the purchase

RETURN:   none.

OUTPUT:  An HTML table that is used as a receipt of purchase.

DESCRIPTION:  PrintReceipt() constructs a receipt of purchase in
	the form of an HTML table output to the customer.  
====================================================== */

function PrintReceipt(pay, desc)
{

  write("<CENTER><H1>Thank you for shopping with us!</H1></CENTER>");
 
  write("<CENTER><TABLE BORDER=1>\n");
 
  write("<TR><TD ALIGN=CENTER COLSPAN=2>",
        "<H2>Receipt of Purchase</H2></TD>\n");
 
  PrintReceiptItem("Date:",                 pay.eventTime);
  PrintReceiptItem("Merchant Reference:",   pay.merchantReference);
  PrintReceiptItem("Authorization Code:",   pay.authCode);
  PrintReceiptItem("Payment Service Data:", pay.paySvcData);
  PrintReceiptItem("AVS:",                  pay.avsResp);
  PrintReceiptItem("Description:",          desc);
  PrintReceiptItem("Amount:",               CentsToDollarStr(pay.amount));
 
  write("</TABLE></CENTER>\n");
 
  write('<BR><BR>');

} // END PrintReceipt()



/* ======================================================

FUNCTION:  EmitHeader()

INPUT:     title - a string that contains the title of the page

RETURN:   none

OUTPUT:  writes the standard HTML tags that generally begin every HTML page.

====================================================== */

function EmitHeader( title )
{

   write("<HTML>\n");
   write("<HEAD><TITLE>");
   write(title);
   write("</TITLE></HEAD>\n");


} // END FUNCTION EmitHeader()



/* ======================================================

FUNCTION:  EmitFooter()

INPUT:     none.

RETURN:    none.

OUTPUT:  writes the standard HTML tags that generally end every HTML page.

====================================================== */

function EmitFooter()
{

   write("</BODY>\n");
   write("</HTML>\n");

} // END FUNCTION EmitFooter()



/* ======================================================

FUNCTION:  PrintTransItem()

INPUT:   label - the label for a row item in a table
	   val - a string or number to be printed as a row item
		described by the label

RETURN:   none.

OUTPUT:  A row in an HTML table with 2 columns.

DESCRIPTION:  This function takes in the label and val arguments
   and constructs a row to an HTML table where label is the first 
   column, and val is the second column.
====================================================== */

function PrintTransItem(label, val)
{
  write("<TR><TD ALIGN=RIGHT><B>", label,
        "</B></TD><TD>", val, "</TD></TR>\n");
} // End PrintTransItem
 


/* ======================================================

FUNCTION:  PrintTrans()

INPUT:    cursor - a cursor object that points to the transaction

RETURN:   none.

OUTPUT:  An HTML table that shows information related to a particular
	transaction.

DESCRIPTION:  PrintTrans() constructs an HTML table that shows
	information relating to a single transaction.
====================================================== */

function PrintTrans( cursor )
{
  var curDate = new Date();
 
  write("<CENTER><TABLE BORDER=1>\n");
 
  PrintTransItem("ID:",cursor.id);
  PrintTransItem("Merchant Reference:",cursor.merchantReference);
  PrintTransItem("Cardholder Name:",cursor.cardHolderName);
  PrintTransItem("Currency Type:",cursor.currency);
  PrintTransItem("Amount:",cursor.amount);
  PrintTransItem("Authorization Code:",cursor.authCode);
  PrintTransItem("Payment Service Data:",cursor.paySvcData);
  PrintTransItem("AVS Response:",cursor.avsResp);
  PrintTransItem("Event Time:",cursor.eventTime);
  PrintTransItem("Slip ID:",cursor.slipID);
  PrintTransItem("Status:",cursor.status);
  write("</TABLE></CENTER>\n");
 
} // End PrintTrans



/* ======================================================

FUNCTION:  Confirm()

INPUT:     success - a boolean variable indicating whether or not
		to print out a message of success or failure of an operation.
	   type - a string to indicate what type of operation succeeded
		or failed (e.g. "Credit")

RETURN:    none.

OUTPUT:    Dynamically creates a complete HTML page that prints a 
	confirmation of a particular operation.  For example, 
	if an administrator had just Credited a transaction, this function
	could be called to output a page to the administrator to 
	indicate whether the operation was successful or not.

====================================================== */

function Confirm(success, type)
{

EmitHeader("Confirmation");
 
write("<BODY BACKGROUND=\"../images/grayback.jpg\">");

write("<CENTER><H1>Confirmation</H1>\n");

if (success)
	write("<h2>Your " + type + " was completed successfully!</h2>\n");
    else 
	write("<h2>Your " + type + " failed!</h2>\n");

write("<h3>Back to <A HREF=\"../admin/adminhome.html\">Administration</A></h3>\n");
write("</center>\n");
EmitFooter();

}  // End Confirm()




/* ======================================================

FUNCTION:  ViewTransaction()

INPUT:     transid - an integer specifying the transaction from which
	information will be taken and output to the user.

RETURN:    none.

OUTPUT:    dynamically contstructs a complete HTML page that contains
	information regarding a particular transaction.  The information
	is output in an HTML table.

====================================================== */

function ViewTransaction(transid)
{

  cursor = database.cursor("select * from LP_PURCHASE where id='" + transid + "'");
  cursor.next();  // Initialize the cursor.

  EmitHeader("Transaction #" + cursor.id);
  write("<BODY background=\"../images/grayback.jpg\">\n");

  write("<CENTER><H2>Description of Transaction #" + cursor.id + "</H2></CENTER>\n");


  PrintTrans(cursor);
  cursor.close();
  write("<h3>Back to <A HREF=\"adminhome.html\">Administration</A></h3>\n");


  EmitFooter();

} // END FUNCTION ViewTransaction()




/* ======================================================

FUNCTION:  DynSelect()

INPUT:     listname - the name to be given to the HTML select box

	   size     - the size of the select box, where a 1 indicates a 
			dropdown box, and greater than one indicates
			a scrolling list box.

	   multiple - boolean indicating if multiple selections are allowed.
		      true indicates multiple selections are allowed.

	   handlerText - a string representing a client-side JavaScript
			event handler for the select box

	   selectValue - a string representing the item to be selected
			by default upon the lists creation.  "" indicates
			no selection by default.

	   cursorObj - a database cursor that will be looped through to find entries
		      for the HTML select box being constructed.

	   blankLine -  a boolean indicating whether or not one blank entry is to be
			included in the list.

RETURN:    none.

OUTPUT:    Dynamically creates an HTML selection box that is configurable
	by specifiying values as indicated by the input parameters.

====================================================== */

function DynSelect( listname, size, multiple, handlerText, selectValue, cursorObj, blankLine)  
{

var	value, label;


   selectValue = selectValue.toUpperCase();  // convert to upper case for purposes of comparison

   // Construct the SELECT tag
   write("<SELECT NAME=\"" + listname + "\" SIZE=" + size);

   // Allow multiple selections if "multiple" is true
   if (multiple) 
	write(" MULTIPLE ");

   // write out the client-side JavaScript handler, if any 
   write (" " + handlerText + ">\n");

   //Write out the options array

   if (blankLine)
	   write("<OPTION VALUE=\"\">\n");  // Give one blank option at the beginning.

   while(cursorObj.next()) {

   // Dynamically construct each option statement based upon the single field in the table
   // and the value for each record.

/*
 Writes out an option where the first column of the record is the value
 and the second column of the record is the label.  If the label
 is not present for some reason in the second column (e.g. the second 
 column doesn't exist, or is blank), the first column, the value, is
 used as the option label.
*/

	if ( ((cursorObj[0] + "") == "null") || (cursorObj[0] == "") )
		value = "";
	else
		value = cursorObj[0];

	if ((cursorObj[1] == null) || (cursorObj[1] == ""))
		label = value + "";	// convert to a string
	else
		label = cursorObj[1] + "";  // make sure it's a string

	write("<OPTION VALUE=\"" + value + "\"" + ((selectValue == (value + "")) ? " SELECTED " : "") + ">" + label + "\n");

   } // End while loop

   //Close the SELECT block
   write("</SELECT>\n");


} // END FUNCTION DynSelect()



/* ===================================================
 FUNCTION:  StateList( listname, size, multiple, handlerText, selectValue ) 
 
 INPUT: listname - the name of the dropdown list to be created
	site - the size of the dropdown list to be created
	multiple - true or false - if the list should allow multiple selections
	handlerText - optional JavaScript handler for the selected value
	selectValue - default value to be selected

 RETURN: dynamically generated dropdown list box for selecting state.

 =================================================== */
function StateList( listname, size, multiple, handlerText, selectValue ) {

selectValue = selectValue.toUpperCase();  // convert to upper case for purposes of comparison

// Construct the SELECT tag
write("<SELECT NAME=\"" + listname + "\" SIZE=" + size);

if (multiple) 
	write(" MULTIPLE ");
 
write (" " + handlerText + ">\n");

//Write out the options array

write("<OPTION VALUE=AL " + ((selectValue == "AL") ? "SELECTED" : "")   + ">AL\n");
write("<OPTION VALUE=AK " + ((selectValue == "AK") ? "SELECTED" : "")   + ">AK\n");
write("<OPTION VALUE=AR " + ((selectValue == "AR") ? "SELECTED" : "")   + ">AR\n");
write("<OPTION VALUE=AZ " + ((selectValue == "AZ") ? "SELECTED" : "")   + ">AZ\n");
write("<OPTION VALUE=CA " + ((selectValue == "CA") ? "SELECTED" : "")   + ">CA\n");
write("<OPTION VALUE=CO " + ((selectValue == "CO") ? "SELECTED" : "")   + ">CO\n");
write("<OPTION VALUE=CT " + ((selectValue == "CT") ? "SELECTED" : "")   + ">CT\n");
write("<OPTION VALUE=DE " + ((selectValue == "DE") ? "SELECTED" : "")   + ">DE\n");
write("<OPTION VALUE=FL " + ((selectValue == "FL") ? "SELECTED" : "")   + ">FL\n");
write("<OPTION VALUE=GA " + ((selectValue == "GA") ? "SELECTED" : "")   + ">GA\n");

write("<OPTION VALUE=HI " + ((selectValue == "HI") ? "SELECTED" : "")   + ">HI\n");
write("<OPTION VALUE=IA " + ((selectValue == "IA") ? "SELECTED" : "")   + ">IA\n");
write("<OPTION VALUE=ID " + ((selectValue == "ID") ? "SELECTED" : "")   + ">ID\n");
write("<OPTION VALUE=IL " + ((selectValue == "IL") ? "SELECTED" : "")   + ">IL\n");
write("<OPTION VALUE=IN " + ((selectValue == "IN") ? "SELECTED" : "")   + ">IN\n");
write("<OPTION VALUE=KS " + ((selectValue == "KS") ? "SELECTED" : "")   + ">KS\n");
write("<OPTION VALUE=KY " + ((selectValue == "KY") ? "SELECTED" : "")   + ">KY\n");
write("<OPTION VALUE=LA " + ((selectValue == "LA") ? "SELECTED" : "")   + ">LA\n");
write("<OPTION VALUE=MA " + ((selectValue == "MA") ? "SELECTED" : "")   + ">MA\n");
write("<OPTION VALUE=MD " + ((selectValue == "MD") ? "SELECTED" : "")   + ">MD\n");

write("<OPTION VALUE=ME " + ((selectValue == "ME") ? "SELECTED" : "")   + ">ME\n");
write("<OPTION VALUE=MI " + ((selectValue == "MI") ? "SELECTED" : "")   + ">MI\n");
write("<OPTION VALUE=MN " + ((selectValue == "MN") ? "SELECTED" : "")   + ">MN\n");
write("<OPTION VALUE=MO " + ((selectValue == "MO") ? "SELECTED" : "")   + ">MO\n");
write("<OPTION VALUE=MS " + ((selectValue == "MS") ? "SELECTED" : "")   + ">MS\n");
write("<OPTION VALUE=MT " + ((selectValue == "MT") ? "SELECTED" : "")   + ">MT\n");
write("<OPTION VALUE=NC " + ((selectValue == "NC") ? "SELECTED" : "")   + ">NC\n");
write("<OPTION VALUE=ND " + ((selectValue == "ND") ? "SELECTED" : "")   + ">ND\n");
write("<OPTION VALUE=NE " + ((selectValue == "NE") ? "SELECTED" : "")   + ">NE\n");
write("<OPTION VALUE=NH " + ((selectValue == "NH") ? "SELECTED" : "")   + ">NH\n");

write("<OPTION VALUE=NJ " + ((selectValue == "NJ") ? "SELECTED" : "")   + ">NJ\n");
write("<OPTION VALUE=NM " + ((selectValue == "NM") ? "SELECTED" : "")   + ">NM\n");
write("<OPTION VALUE=NV " + ((selectValue == "NV") ? "SELECTED" : "")   + ">NV\n");
write("<OPTION VALUE=NY " + ((selectValue == "NY") ? "SELECTED" : "")   + ">NY\n");
write("<OPTION VALUE=OH " + ((selectValue == "OH") ? "SELECTED" : "")   + ">OH\n");
write("<OPTION VALUE=OK " + ((selectValue == "OK") ? "SELECTED" : "")   + ">OK\n");
write("<OPTION VALUE=OR " + ((selectValue == "OR") ? "SELECTED" : "")   + ">OR\n");
write("<OPTION VALUE=PA " + ((selectValue == "PA") ? "SELECTED" : "")   + ">PA\n");
write("<OPTION VALUE=RI " + ((selectValue == "RI") ? "SELECTED" : "")   + ">RI\n");
write("<OPTION VALUE=SC " + ((selectValue == "SC") ? "SELECTED" : "")   + ">SC\n");

write("<OPTION VALUE=SD " + ((selectValue == "SC") ? "SELECTED" : "")   + ">SD\n");
write("<OPTION VALUE=TN " + ((selectValue == "TN") ? "SELECTED" : "")   + ">TN\n");
write("<OPTION VALUE=TX " + ((selectValue == "TX") ? "SELECTED" : "")   + ">TX\n");
write("<OPTION VALUE=UT " + ((selectValue == "UT") ? "SELECTED" : "")   + ">UT\n");
write("<OPTION VALUE=VA " + ((selectValue == "VA") ? "SELECTED" : "")   + ">VA\n");
write("<OPTION VALUE=VT " + ((selectValue == "VT") ? "SELECTED" : "")   + ">VT\n");
write("<OPTION VALUE=WA " + ((selectValue == "WA") ? "SELECTED" : "")   + ">WA\n");
write("<OPTION VALUE=WI " + ((selectValue == "WI") ? "SELECTED" : "")   + ">WI\n");
write("<OPTION VALUE=WV " + ((selectValue == "WV") ? "SELECTED" : "")   + ">WV\n");
write("<OPTION VALUE=WY " + ((selectValue == "WY") ? "SELECTED" : "")   + ">WY\n");

write("<OPTION VALUE=DC " + ((selectValue == "DC") ? "SELECTED" : "")   + ">D.C.\n");

//Close the SELECT block
write("</SELECT>\n");

}  // END FUNCTION StateList
