// === Starter Application 1.0.0 === //

/* ======================================================

FUNCTION:  ItemObject

INPUT:     amount - the amount/cost of the item.  Must be a whole integer (e.g. cents)
	   description - a short description of the item

DESCRIPTION:	This object constructor is intended to represent a typical 
		item for sale on a web site, comprised of an amount (as an ingeter,
		e.g. cents, for US currency).  This constructor may be modified
		to hold additional information.  See "Dependencies" below for
		issues related to modifying this object constructor.

DEPENDENCIES:   Function GetItemProperties and "auth.html" rely upon the existence and type
		of the amount (integer, cents) and description (string) properties.

SPECIAL NOTES:  This function is an object constructor for an ItemObject. 

====================================================== */

function ItemObject ( amount, description )
{
	this.amount = amount;
	this.desc = description;

} // END OBJECT CONTSTRUCTOR ItemObject



/* ======================================================

FUNCTION:  GetItemProperties

INPUT:     productID - a string representing a unique identifier for a product
		for sale on the web site.

RETURN:    an ItemObject containing the cost of the object in a whole integer (e.g. cents)
	   and a brief description of the product.

====================================================== */

function GetItemProperties ( productID )
{

	/*  This function should be replaced with your own item-property lookup scheme.
	   For example, if you already have or are building an Inventory Database for
	   your products, this routine would lookup the amount and item description 
	   for the item indicated by "productID" in your Inventory Table.
	*/

	if (productID == "001")
		item = new ItemObject("1800", "Mozilla Coffee Mug");
	else if (productID == "002")
		item = new ItemObject("995", "Netscape Mouse Pad");
	else if (productID == "003")
		item = new ItemObject("1495", "Stuffed Mozilla");
	else
		item = new ItemObject("0", "Invalid Item");

	return item;

} // END FUNCTION GetItemProperties



/* ======================================================

FUNCTION:  CalcOrderTotal

INPUT:     amount - a sub-total for a purchase.

RETURN:    The total amount of of the purchase, including any modifiers
	such as shipping, state or local taxes, processing fees, etc.

====================================================== */

function CalcOrderTotal ( amount )
{
	/*  This function should be replaced with your own amount calculation scheme.
	   If you need to add shipping costs, tax, etc. You can perform your calculations
	   here.  If you need to calculate a total of items for a Shopping Cart, you may
	   also perform that calculation here.
	
	   WARNING:  The amount returned by this function MUST be a whole integer (e.g. cents, no decimal).
	*/

	return (amount);

} // END FUNCTION CalcOrderTotal



