// === Starter Application 1.0.0 === //

/* ======================================================

FUNCTION:  Cancel()

INPUT:     authid - the id of the transaction that will be cancelled

RETURNS:   true, if the operation is successful.
	
	   The function calls PrintError() if unsuccessful.

NOTES:   This function does not communicate the cancellation to the
 acquirer as there is no way for this to be done.  This function simply
 changes the status of the transaction in the database from "AUTHORIZED"
 to "CANCELLED."  

====================================================== */

function Cancel(authid)
{
   var returnval = false;

   database.beginTransaction();

   if ((error = database.execute("update LP_PURCHASE set STATUS = 'CANCELLED' where ID = " + authid)))
   {
	database.rollbackTransaction();
	  if ((error == 5) || (error == 7))
		PrintError("Database Error.", "Could not update purchase id " + authid + 
			" in LP_PURCHASE table.  ",
			"Error code " + error + ": " + database.majorErrorMessage());
	  else if (error)
		PrintError("Database Error.", "Could not update purchase id " + authid + 
			" in LP_PURCHASE table.  ",
				"Error code " + error + " returned from the database.");
   }

   returnval = true;
   database.commitTransaction();
   return returnval;
   
} //End FUNCTION Cancel();
