/* Written by Germano Caronni */
/* (c) by G. Caronni in '97 */
/* This program is under the GNU Public License Version 2 */
/* Please note that this program implements RC5. While    */
/* the implementation is under the GNU License, you will  */
/* have to check with RSA DSI whether you are allowed to  */
/* use RC5 itself.                                        */

/* keymanager fuer client gec */

#include <stdio.h>
#include <string.h>
#include <assert.h>

#include "dic.h"
#include "keyclnt.h"






typedef unsigned int WORD;

#define w        32
#define r        12
#define b         6
#define c         2
#define t        26

WORD P = 0xb7e15163, Q = 0x9e3779b9;

#ifdef ROT_I386

/*
#define S(m) #m
#define SX(m) S(m)
*/

static __inline__ WORD ROTL(WORD x,WORD y)
{   
    WORD res;

    __asm__(
	"roll %%cl,%0\n\t"
	:"=g" (res)
	:"0" (x), "cx" (y)
	:"cx");
    return res;
}

#elif defined(ROT_POWER)

static __inline__ int ROTL(x,y)
{
    WORD res;

    __asm(
       "rlmi %0, %1, %2, 0, 31"
       :"=r" (res)
       :"r" (x), "r" (y));
    return res;
}

#else /* generic */

#define ROTL(x,y) (((x)<<(y&(w-1))) | ((x)>>(w-(y&(w-1)))))

#endif

#ifdef ROT3_I386

static __inline__ WORD ROTL3(WORD x)
{   
    WORD res;
    __asm__(
	"roll $3,%0\n\t"
	:"=g" (res)
	:"0" (x));
    return res;
}

#elif defined(ROT_POWER)

#define ROTL3(x) \
({ \
       int res; \
       __asm( \
           "rlimi %0, %1, 3, 0, 31" \
           :"=r" (res) \
           :"r" (x)); \
        res; \
})

#else /* generic */

#define ROTL3(x) ROTL(x,3)

#endif

static uchar ara[MAXLEN+1];
static uchar t_clear[8];
static uchar t_cipher[8];
static int size;
static unsigned long range;

WORD rc5_cipher[2];
WORD rc5_clear[2];

WORD L0[2];
WORD S0[t];

void init(char *start, unsigned long rng, char *clear, char *cipher)
{
    uchar *are;
    int t1,i,u=w/8;
    
    size=strlen(start)/2;
    assert(rng && size && size <= MAXLEN);
    assert(sizeof(WORD)==4);

    assert(size>4 && size<9); /* due to optimized code */

    range=rng;

    for(are=ara;*start;are++) {
	*are=(t1=*start++)>='A'?t1-'A'+10:t1-'0';
	*are= *are*16+((t1=*start++)>='A'?t1-'A'+10:t1-'0');
    }
    for(are=t_clear;*clear;are++) {
	*are=(t1=*clear++)>='A'?t1-'A'+10:t1-'0';
	*are= *are*16+((t1=*clear++)>='A'?t1-'A'+10:t1-'0');
    }
    for(are=t_cipher;*cipher;are++) {
	*are=(t1=*cipher++)>='A'?t1-'A'+10:t1-'0';
	*are= *are*16+((t1=*cipher++)>='A'?t1-'A'+10:t1-'0');
    }

    rc5_cipher[0] = 
	t_cipher[0]+t_cipher[1]*(1<<8)+t_cipher[2]*(1<<16)+t_cipher[3]*(1<<24);
    rc5_cipher[1] = 
	t_cipher[4]+t_cipher[5]*(1<<8)+t_cipher[6]*(1<<16)+t_cipher[7]*(1<<24);
    rc5_clear[0] = 
	t_clear[0]+t_clear[1]*(1<<8)+t_clear[2]*(1<<16)+t_clear[3]*(1<<24);
    rc5_clear[1] = 
	t_clear[4]+t_clear[5]*(1<<8)+t_clear[6]*(1<<16)+t_clear[7]*(1<<24);


    for (i = b - 1, L0[c - 1] = 0; i != -1; i--)
	L0[i / u] = (L0[i / u] << 8) + ara[i];

    for (S0[0] = P, i = 1; i < t; i++) S0[i] = S0[i - 1] + Q;

    /*S0[ 0] = ROTL(S0[ 0]          , 3);*/
#define S0_0_ 0xBF0A8B1D
}

WORD S[t];

int doit(void)
{
    WORD S1_, A, B, L_0, L_1, X, Y;


    while (range--) {

#ifndef ASM_LOOP

	B = L_0 = ROTL(L0[0] + (S0_0_), (S0_0_));
	S1_ = ROTL3(S0[ 1] + (S0_0_ + B));
	B = L_1 = ROTL(L0[1] + (S1_ + B), (S1_ + B));

	A = S[ 2] = ROTL3(S0[ 2] + (S1_ + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[ 3] = ROTL3(S0[ 3] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[ 4] = ROTL3(S0[ 4] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[ 5] = ROTL3(S0[ 5] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[ 6] = ROTL3(S0[ 6] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[ 7] = ROTL3(S0[ 7] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[ 8] = ROTL3(S0[ 8] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[ 9] = ROTL3(S0[ 9] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[10] = ROTL3(S0[10] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[11] = ROTL3(S0[11] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[12] = ROTL3(S0[12] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[13] = ROTL3(S0[13] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[14] = ROTL3(S0[14] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[15] = ROTL3(S0[15] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[16] = ROTL3(S0[16] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[17] = ROTL3(S0[17] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[18] = ROTL3(S0[18] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[19] = ROTL3(S0[19] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[20] = ROTL3(S0[20] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[21] = ROTL3(S0[21] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[22] = ROTL3(S0[22] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[23] = ROTL3(S0[23] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[24] = ROTL3(S0[24] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[25] = ROTL3(S0[25] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));


	A = S[ 0] = ROTL3(S0_0_ + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	    S1_   = ROTL3(S1_ + (A + B));
	B = L_1 = ROTL(L_1 + (S1_ + B), (S1_ + B));

	A = S[ 2] = ROTL3(S[ 2] + (S1_ + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[ 3] = ROTL3(S[ 3] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[ 4] = ROTL3(S[ 4] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[ 5] = ROTL3(S[ 5] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[ 6] = ROTL3(S[ 6] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[ 7] = ROTL3(S[ 7] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[ 8] = ROTL3(S[ 8] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[ 9] = ROTL3(S[ 9] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[10] = ROTL3(S[10] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[11] = ROTL3(S[11] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[12] = ROTL3(S[12] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[13] = ROTL3(S[13] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[14] = ROTL3(S[14] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[15] = ROTL3(S[15] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[16] = ROTL3(S[16] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[17] = ROTL3(S[17] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[18] = ROTL3(S[18] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[19] = ROTL3(S[19] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[20] = ROTL3(S[20] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[21] = ROTL3(S[21] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[22] = ROTL3(S[22] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[23] = ROTL3(S[23] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A = S[24] = ROTL3(S[24] + (A + B));
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A = S[25] = ROTL3(S[25] + (A + B));
	B = L_1 = ROTL(L_1 + (A + B), (A + B));


	A =         ROTL3(S[0] + (A + B));
        X = rc5_clear[0] + A;
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A =         ROTL3(S1_ + (A + B));
        Y = rc5_clear[1] + A;
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A =         ROTL3(S[ 2] + (A + B));
	X = ROTL(X ^ Y, Y) + A;
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A =         ROTL3(S[ 3] + (A + B));
        Y = ROTL(Y ^ X, X) + A;
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A =         ROTL3(S[ 4] + (A + B));
	X = ROTL(X ^ Y, Y) + A;
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A =         ROTL3(S[ 5] + (A + B));
        Y = ROTL(Y ^ X, X) + A;
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A =         ROTL3(S[ 6] + (A + B));
	X = ROTL(X ^ Y, Y) + A;
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A =         ROTL3(S[ 7] + (A + B));
        Y = ROTL(Y ^ X, X) + A;
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A =         ROTL3(S[ 8] + (A + B));
	X = ROTL(X ^ Y, Y) + A;
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A =         ROTL3(S[ 9] + (A + B));
        Y = ROTL(Y ^ X, X) + A;
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A =         ROTL3(S[10] + (A + B));
	X = ROTL(X ^ Y, Y) + A;
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A =         ROTL3(S[11] + (A + B));
        Y = ROTL(Y ^ X, X) + A;
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A =         ROTL3(S[12] + (A + B));
	X = ROTL(X ^ Y, Y) + A;
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A =         ROTL3(S[13] + (A + B));
        Y = ROTL(Y ^ X, X) + A;
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A =         ROTL3(S[14] + (A + B));
	X = ROTL(X ^ Y, Y) + A;
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A =         ROTL3(S[15] + (A + B));
        Y = ROTL(Y ^ X, X) + A;
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A =         ROTL3(S[16] + (A + B));
	X = ROTL(X ^ Y, Y) + A;
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A =         ROTL3(S[17] + (A + B));
        Y = ROTL(Y ^ X, X) + A;
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A =         ROTL3(S[18] + (A + B));
	X = ROTL(X ^ Y, Y) + A;
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A =         ROTL3(S[19] + (A + B));
        Y = ROTL(Y ^ X, X) + A;
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A =         ROTL3(S[20] + (A + B));
	X = ROTL(X ^ Y, Y) + A;
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A =         ROTL3(S[21] + (A + B));
        Y = ROTL(Y ^ X, X) + A;
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

	A =         ROTL3(S[22] + (A + B));
	X = ROTL(X ^ Y, Y) + A;
	B = L_0 = ROTL(L_0 + (A + B), (A + B));
	A =         ROTL3(S[23] + (A + B));
        Y = ROTL(Y ^ X, X) + A;
	B = L_1 = ROTL(L_1 + (A + B), (A + B));

#else

	A = S0_0_;
	L_0 = L0[0];
	L_1 = L0[1];

#include "asm.inc"

	B = L_1;

#endif

	A =         ROTL3(S[24] + (A + B));
	X = ROTL(X ^ Y, Y) + A;

        if (rc5_cipher[0] == X) {
	    B = L_0 = ROTL(L_0 + (A + B), (A + B));
	    A =         ROTL3(S[25] + (A + B));
            Y = ROTL(Y ^ X, X) + A;
	    if (rc5_cipher[1] == Y) return 1;
        }

	if (++L0[1] == (1<<(b*8-32))) {
	    L0[1]=0;
	    L0[0]++;
        }
    }

    return 0;
}

char *getresult(void)
{
    static char buf[MAXLEN*2+1];
    int i;
    /*WORD L[2]={L0[0],L0[1]}; too gcc specific :-( */
    WORD L[2];
    
    L[0]=L0[0];
    L[1]=L0[1];

    for(i=0;i<size;i++) {
	ara[i]= L[i/4] & 0xff;
        L[i/4]=L[i/4]>>8;
    }
    for(i=0;i<size;i++) sprintf(buf+2*i,"%02X",ara[i]);
    return buf;
}


#ifdef TEST
int main(void)
{
    int i;
    unsigned char res[17];
    unsigned char plain[8] = {'T' ^ 0xf6,
                              'h' ^ 0x75,
                              'e' ^ 0x17,
                              ' ' ^ 0x1a,
			      'u' ^ 0x59,
			      'n' ^ 0xb7,
			      'k' ^ 0xea,
			      'n' ^ 0xd0
			  };
   
    for(i=0;i<8;i++) sprintf(res+2*i,"%02X",plain[i]);
    /*printf("%s\n",res); A21D723A2CD981BE */

    init( /*start "27D86DD243" */ 
#ifdef RUN
    "0000000000" ,
#else
    "27D86DD243" ,
#endif
	  /*range*/ 1000000,
	  /*clear*/ res,
	  /*crypt*/ "B40A5388B13882AD"
        );

    i=doit();

    if (i) printf("Found %s\n",getresult());
    else printf("Not found\n");

    return 0;
}
#endif
