/* pkcrack - zdmain.c
 *
 * (C) by Peter Conrad <conrad@unix-ag.uni-kl.de>
 *
 * $Id: zdmain.c,v 1.2 1996/08/21 17:54:09 conrad Release1_2 $
 *
 * $Log: zdmain.c,v $
 * Revision 1.2  1996/08/21 17:54:09  conrad
 * Some cleanups to suppress warnings...
 *
 * Revision 1.1  1996/08/21 17:39:28  conrad
 * Initial revision
 *
 */

static char RCSID[]="$Id: zdmain.c,v 1.2 1996/08/21 17:54:09 conrad Release1_2 $";

#include <stdio.h>
#include "crc.h"
#include "pkcrack.h"

extern void zipdecrypt( char*infile, char*outfile, int k0, int k1, int k2 );

void main( int argc, char **argv )
{
uword k0, k1, k2;

    if( argc != 6 )
    {
	fprintf( stderr, "Usage: %s <key0> <key1> <key2> <ciphertextfilename> <plaintextfilename>\n", argv[0] );
	return;
    }

    mkCrcTab();

    sscanf( argv[1], "%x", &k0 );
    sscanf( argv[2], "%x", &k1 );
    sscanf( argv[3], "%x", &k2 );

    zipdecrypt( argv[4], argv[5], k0, k1, k2 );
}

